/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.text.StringSubstitutor;
import org.opensearch.OpenSearchException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.MLModelTool;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="QueryPlanningTool")
public class QueryPlanningTool
implements WithModelTool {
    public static final String TYPE = "QueryPlanningTool";
    public static final String MODEL_ID_FIELD = "model_id";
    private final MLModelTool queryGenerationTool;
    public static final String SYSTEM_PROMPT_FIELD = "system_prompt";
    public static final String USER_PROMPT_FIELD = "user_prompt";
    public static final String INDEX_MAPPING_FIELD = "index_mapping";
    public static final String QUERY_FIELDS_FIELD = "query_fields";
    private static final String GENERATION_TYPE_FIELD = "generation_type";
    private static final String LLM_GENERATED_TYPE_FIELD = "llmGenerated";
    private static final String DEFAULT_SYSTEM_PROMPT = "You are an OpenSearch Query DSL generation assistant, translating natural language questions to OpenSeach DSL Queries";
    private final String generationType;
    private String name = "QueryPlanningTool";
    private Map<String, Object> attributes;
    static String DEFAULT_DESCRIPTION = "Use this tool to generate opensearch query dsl for a given natural language question.";
    private String description = DEFAULT_DESCRIPTION;

    public QueryPlanningTool(String generationType, MLModelTool queryGenerationTool) {
        this.generationType = generationType;
        this.queryGenerationTool = queryGenerationTool;
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
        if (!this.validate(parameters)) {
            listener.onFailure((Exception)new IllegalArgumentException("Empty parameters for QueryPlanningTool: " + String.valueOf(parameters)));
            return;
        }
        if (!parameters.containsKey(SYSTEM_PROMPT_FIELD)) {
            parameters.put(SYSTEM_PROMPT_FIELD, DEFAULT_SYSTEM_PROMPT);
        }
        if (!parameters.containsKey(USER_PROMPT_FIELD)) {
            parameters.put(USER_PROMPT_FIELD, "==== PURPOSE ====\nYou are an OpenSearch DSL expert. Convert a natural-language question into a strict JSON OpenSearch query body.\n\n==== RULES ====\nUse only fields present in the provided mapping; never invent names.\nChoose query types based on user intent and field types:\n- match: single-token full-text on analyzed text fields.\n- match_phrase: multi-token phrases on analyzed text fields (search string contains spaces, hyphens, commas, etc.).\n- multi_match: when multiple analyzed text fields are equally relevant.\n- term / terms: exact match on keyword, numeric, boolean.\n- range: numeric/date comparisons (gt, lt, gte, lte).\n- bool with must, should, must_not, filter: AND/OR/NOT logic.\n- wildcard / prefix on keyword: \"starts with\" / pattern matching.\n- exists: field presence/absence.\n- nested query / nested agg: ONLY if the mapping for that exact path (or a parent) has \"type\":\"nested\".\n\nMechanics:\n- Put exact constraints (term, terms, range, exists, prefix, wildcard) in bool.filter (non-scoring). Put full-text relevance (match, match_phrase, multi_match) in bool.must.\n- Top N items/products/documents: return top hits (set \"size\": N as an integer) and sort by the relevant metric(s). Do not use aggregations for item lists.\n- Spelling tolerance: match_phrase does NOT support fuzziness; use match or multi_match with \"fuzziness\": \"AUTO\" when tolerant matching is needed.\n- Numeric note: use integers for sizes (e.g., \"size\": 5), not floats.\n\nAggregations (counts, averages, grouped summaries, distributions):\n- Use aggregations when the user asks for grouped summaries (e.g., counts by category, averages by brand, or top N categories/brands).\n- terms on field.keyword or numeric for grouping / top N groups (not items).\n- Metric aggs (avg, min, max, sum, stats, cardinality) on numeric fields.\n- date_histogram, histogram, range for distributions.\n- Always set \"size\": 0 when only aggregations are needed.\n- Use sub-aggregations + order for \"top N groups by metric\".\n- If grouping/filtering exactly on a text field, use its .keyword sub-field when present.\n\n==== FIELD SELECTION & PROXYING ====\nGoal: pick the smallest set of mapping fields that best capture the user's intent.\nQuery Fields: when provided, and present in the mapping, prioritize using them; ignore any that are not in the mapping.\nProxy Rule (mandatory): If at least one field is even loosely related to the intent, you MUST proceed using the best available proxy fields. Do NOT fall back to the default query due to ambiguity.\nSelection steps:\n- Harvest candidates from the question (entities, attributes, constraints).\n- From query_fields (that exist) and the index mapping, choose fields that map to those candidates and the user intent\u2014even if only loosely (use reasonable proxies).\n- Ignore other fields that don\u2019t help answer the question.\n- Micro Self-Check (silent): verify chosen fields exist; if any don\u2019t, swap to the closest mapped proxy and continue. Only if no remotely relevant fields exist at all, use the default match_all query.\n\n\n==== OUTPUT FORMAT ====\n- Return EXACTLY ONE JSON object representing the OpenSearch request body (not an escaped string).\n- Output NOTHING else before or after it.\n- Do NOT use code fences or markdown: no backticks (`), no ```json, no ```.\n- Do NOT wrap in quotes or prose: no single quotes ('), no smart quotes (\u2019 \u201c \u201d), no angle brackets (< >), no XML/HTML, no lists, no headers, no ellipses.\n- Use valid JSON only: standard double quotes (\") for all keys/strings; no comments; no trailing commas.\n- If the request truly cannot be fulfilled because no remotely relevant fields exist, return EXACTLY:\n{\"size\":10,\"query\":{\"match_all\":{}}}\n\n==== EXAMPLES ====\nExample 1 \u2014 numeric range\nInput: Show all products that cost more than 50 dollars.\nMapping: { \"properties\": { \"price\": { \"type\": \"float\" }, \"cost\": { \"type\": \"float\" }, \"color\": { \"type\": \"keyword\" } } }\nQuery Fields: [price]\nField selection: relevant=[price, cost]; ignored=[color]\nOutput: { \"query\": { \"range\": { \"price\": { \"gt\": 50 } } } }\nExample 2 \u2014 text match + exact filter (spelling tolerant)\nInput: Find employees in London who are active.\nMapping: { \"properties\": { \"city\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"status\": { \"type\": \"keyword\" }, \"notes\": { \"type\": \"text\" } } }\nQuery Fields: [city, status]\nField selection: relevant=[city(text), status(keyword)]; ignored=[notes]\nOutput: { \"query\": { \"bool\": { \"must\": [ { \"match\": { \"city\": { \"query\": \"London\", \"fuzziness\": \"AUTO\" } } } ], \"filter\": [ { \"term\": { \"status\": \"active\" } } ] } } }\nExample 3 \u2014 match_phrase for multi-token\nInput: Find employees located in New York City.\nMapping: { \"properties\": { \"city\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"department\": { \"type\": \"keyword\" } } }\nOutput: { \"query\": { \"match_phrase\": { \"city\": \"New York City\" } } }\nExample 4 \u2014 multi_match across multiple text fields (spelling tolerant)\nInput: Find profiles mentioning \"data engineering\" in the title or summary.\nMapping: { \"properties\": { \"title\": { \"type\": \"text\" }, \"summary\": { \"type\": \"text\" }, \"department\": { \"type\": \"keyword\" }, \"region\": { \"type\": \"keyword\" } } }\nOutput: { \"query\": { \"multi_match\": { \"query\": \"data engineering\", \"fields\": [\"title\", \"summary\"], \"fuzziness\": \"AUTO\" } } }\nExample 5 \u2014 bool with SHOULD\nInput: Search articles about \"machine learning\" that are research papers or blogs.\nMapping: { \"properties\": { \"content\": { \"type\": \"text\" }, \"type\": { \"type\": \"keyword\" } } }\nOutput: { \"query\": { \"bool\": { \"must\": [ { \"match\": { \"content\": \"machine learning\" } } ], \"should\": [ { \"term\": { \"type\": \"research paper\" } }, { \"term\": { \"type\": \"blog\" } } ], \"minimum_should_match\": 1 } } }\nExample 6 \u2014 wildcard + exists (exact filters in bool.filter)\nInput: Find users whose email starts with \"sam\" and who have a phone number on file.\nMapping: { \"properties\": { \"email\": { \"type\": \"keyword\" }, \"phone\": { \"type\": \"keyword\" }, \"avatar_url\": { \"type\": \"keyword\" } } }\nField selection: relevant=[email(prefix), phone(exists)]; ignored=[avatar_url]\nOutput: { \"query\": { \"bool\": { \"filter\": [ { \"prefix\": { \"email\": \"sam\" } }, { \"exists\": { \"field\": \"phone\" } } ] } } }\nExample 7 \u2014 nested query (only when mapping says nested)\nInput: Find books where an author's first_name is John AND last_name is Doe.\nMapping: { \"properties\": { \"author\": { \"type\": \"nested\", \"properties\": { \"first_name\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"last_name\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } } } }, \"title\": { \"type\": \"text\" } } }\nOutput: { \"query\": { \"nested\": { \"path\": \"author\", \"query\": { \"bool\": { \"must\": [ { \"term\": { \"author.first_name.keyword\": \"John\" } }, { \"term\": { \"author.last_name.keyword\": \"Doe\" } } ] } } } } }\nExample 8 \u2014 terms aggregation\nInput: Show the number of orders per status.\nMapping: { \"properties\": { \"status\": { \"type\": \"keyword\" }, \"order_id\": { \"type\": \"keyword\" } } }\nOutput: { \"size\": 0, \"aggs\": { \"orders_by_status\": { \"terms\": { \"field\": \"status\" } } } }\nExample 9 \u2014 top N items by metric (hits + sort, no aggs)\nInput: Show the 5 highest-rated electronics products.\nMapping: { \"properties\": { \"category\": { \"type\": \"keyword\" }, \"rating\": { \"type\": \"float\" }, \"reviews_count\": { \"type\": \"integer\" }, \"product_name\": { \"type\": \"text\" }, \"description\": { \"type\": \"text\" } } }\nField selection: relevant=[category(keyword), rating(float), reviews_count(integer), product_name(text), description(text)]\nOutput: { \"size\": 5, \"query\": { \"bool\": { \"filter\": [ { \"term\": { \"category\": \"electronics\" } } ] } }, \"sort\": [ { \"rating\": { \"order\": \"desc\" } }, { \"reviews_count\": { \"order\": \"desc\" } } ] }\nExample 10 \u2014 top N categories (grouping via aggs; not for item lists)\nInput: List the top 3 categories by total sales volume.\nMapping: { \"properties\": { \"category\": { \"type\": \"text\", \"fields\": { \"keyword\": { \"type\": \"keyword\" } } }, \"sales\": { \"type\": \"float\" }, \"region\": { \"type\": \"keyword\" } } }\nField selection: relevant=[category.keyword, sales]; ignored=[region]\nOutput: { \"size\": 0, \"aggs\": { \"top_categories\": { \"terms\": { \"field\": \"category.keyword\", \"size\": 3, \"order\": { \"total_sales\": \"desc\" } }, \"aggs\": { \"total_sales\": { \"sum\": { \"field\": \"sales\" } } } } } }\nExample 11 \u2014 ambiguous mapping, proxy success\nInput: Give medicines shipped from Vietnam.\nMapping: { \"properties\": { \"item_name\": { \"type\": \"text\" }, \"product_category\": { \"type\": \"keyword\" }, \"country\": { \"type\": \"keyword\" }, \"ship_status\": { \"type\": \"keyword\" }, \"notes\": { \"type\": \"text\" } } }\nQuery Fields: [product_category, origin_country]\nField selection: relevant=[product_category, country(proxy for origin), ship_status(proxy for shipped)]; ignored=[notes, item_name]\nOutput: { \"query\": { \"bool\": { \"filter\": [ { \"term\": { \"product_category\": \"medicines\" } }, { \"term\": { \"country\": \"Vietnam\" } }, { \"term\": { \"ship_status\": \"shipped\" } } ] } } }\nExample 12 \u2014 true fallback (no remotely relevant fields)\nInput: List satellites with periapsis above 400km.\nMapping: { \"properties\": { \"name\": { \"type\": \"text\" }, \"color\": { \"type\": \"keyword\" } } }\nOutput: {\"size\":10,\"query\":{\"match_all\":{}}}\n\n\n==== INPUT ====\nQuestion: ${parameters.query_text}\nMapping: ${parameters.index_mapping:-}\nQuery Fields: ${parameters.query_fields:-}\n\n==== OUTPUT ====\nGIVE THE OUTPUT PART ONLY IN YOUR RESPONSE (a single JSON object)\nOutput:");
        }
        if (parameters.containsKey(INDEX_MAPPING_FIELD)) {
            parameters.put(INDEX_MAPPING_FIELD, StringUtils.gson.toJson(parameters.get(INDEX_MAPPING_FIELD)));
        }
        if (parameters.containsKey(QUERY_FIELDS_FIELD)) {
            parameters.put(QUERY_FIELDS_FIELD, StringUtils.gson.toJson(parameters.get(QUERY_FIELDS_FIELD)));
        }
        ActionListener modelListener = ActionListener.wrap(r -> {
            try {
                String queryString = (String)r;
                if (queryString == null || queryString.isBlank() || queryString.equals("null")) {
                    StringSubstitutor substitutor = new StringSubstitutor(parameters, "${parameters.", "}");
                    String defaultQueryString = substitutor.replace("{\"size\":10,\"query\":{\"match_all\":{}}}");
                    listener.onResponse((Object)defaultQueryString);
                } else {
                    listener.onResponse((Object)queryString);
                }
            }
            catch (Exception e) {
                IllegalArgumentException parsingException = new IllegalArgumentException("Error processing query string: " + String.valueOf(r) + ". Try using response_filter in agent registration if needed.", e);
                listener.onFailure((Exception)parsingException);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.queryGenerationTool.run(parameters, modelListener);
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    @Generated
    public String getGenerationType() {
        return this.generationType;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    public static class Factory
    implements WithModelTool.Factory<QueryPlanningTool> {
        private Client client;
        private static volatile Factory INSTANCE;
        private static MLFeatureEnabledSetting mlFeatureEnabledSetting;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<QueryPlanningTool> clazz = QueryPlanningTool.class;
            synchronized (QueryPlanningTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
            this.client = client;
            Factory.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        }

        public QueryPlanningTool create(Map<String, Object> map) {
            if (!mlFeatureEnabledSetting.isAgenticSearchEnabled()) {
                throw new OpenSearchException(MLCommonsSettings.ML_COMMONS_AGENTIC_SEARCH_DISABLED_MESSAGE, new Object[0]);
            }
            MLModelTool queryGenerationTool = MLModelTool.Factory.getInstance().create(map);
            String type = (String)map.get(QueryPlanningTool.GENERATION_TYPE_FIELD);
            if (type == null || type.isEmpty()) {
                type = QueryPlanningTool.LLM_GENERATED_TYPE_FIELD;
            }
            if (!QueryPlanningTool.LLM_GENERATED_TYPE_FIELD.equals(type)) {
                throw new IllegalArgumentException("Invalid generation type: " + type + ". The current supported types are llmGenerated.");
            }
            return new QueryPlanningTool(type, queryGenerationTool);
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return QueryPlanningTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of(QueryPlanningTool.MODEL_ID_FIELD);
        }
    }
}

