/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.anomalylocalization;

import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.output.execute.anomalylocalization.Counter;

public class CountMinSketch
implements Counter {
    @Generated
    private static final Logger log = LogManager.getLogger(CountMinSketch.class);
    protected static final double INV_DELTOID = 100.0;
    protected static final double LOG_BASE_2 = 2.0;
    protected static final double INV_EPSILON = 1000.0;
    private int numHashes = (int)Math.ceil(Math.log(100.0) / Math.log(2.0));
    private int numBuckets = (int)Math.ceil(1000.0);
    private double[][] counts = new double[this.numHashes][this.numBuckets];
    private int[] hashes = new Random().ints(this.numHashes).toArray();

    public CountMinSketch() {
        log.info("count min sketch size " + this.numHashes + " * " + this.numBuckets + " = " + this.numHashes * this.numBuckets);
    }

    public void increment(List<String> key, double value) {
        int keyHash = key.hashCode();
        for (int i = 0; i < this.numHashes; ++i) {
            double[] dArray = this.counts[i];
            int n = this.getBucketIndex(keyHash, i);
            dArray[n] = dArray[n] + value;
        }
    }

    public double estimate(List<String> key) {
        int keyHash = key.hashCode();
        return IntStream.range(0, this.numHashes).mapToDouble(i -> this.counts[i][this.getBucketIndex(keyHash, i)]).min().orElse(0.0);
    }

    private int getBucketIndex(int keyHash, int hashIndex) {
        return Math.floorMod(this.hashes[hashIndex] ^ keyHash, this.numBuckets);
    }
}

