/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;
import org.opensearch.search.SearchHit;

public final class SearchResponseParser {
    private static final Logger logger = LogManager.getLogger(SearchResponseParser.class);

    private SearchResponseParser() {
    }

    public static void parseSearchResponse(SearchResponse searchResponse, NamedXContentRegistry namedXContentRegistry, ActionListener<List<SearchQueryRecord>> callback) {
        try {
            List<SearchQueryRecord> records = SearchResponseParser.parseSearchHits(searchResponse, namedXContentRegistry);
            callback.onResponse(records);
        }
        catch (Exception e) {
            OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.LOCAL_INDEX_READER_PARSING_EXCEPTIONS);
            logger.error("Unable to parse search response during multi-index search: ", (Throwable)e);
            callback.onFailure(e);
        }
    }

    private static List<SearchQueryRecord> parseSearchHits(SearchResponse searchResponse, NamedXContentRegistry namedXContentRegistry) throws Exception {
        ArrayList<SearchQueryRecord> records = new ArrayList<SearchQueryRecord>();
        for (SearchHit hit : searchResponse.getHits()) {
            SearchQueryRecord record = SearchResponseParser.parseSearchHit(hit, namedXContentRegistry);
            records.add(record);
        }
        return records;
    }

    private static SearchQueryRecord parseSearchHit(SearchHit hit, NamedXContentRegistry namedXContentRegistry) throws Exception {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());){
            SearchQueryRecord searchQueryRecord = SearchQueryRecord.fromXContent(parser);
            return searchQueryRecord;
        }
    }
}

