/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.exporter;

import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.plugin.insights.core.exporter.DebugExporter;
import org.opensearch.plugin.insights.core.exporter.LocalIndexExporter;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporter;
import org.opensearch.plugin.insights.core.exporter.SinkType;
import org.opensearch.plugin.insights.core.metrics.OperationalMetric;
import org.opensearch.plugin.insights.core.metrics.OperationalMetricsCounter;
import org.opensearch.transport.client.Client;

public class QueryInsightsExporterFactory {
    private final Logger logger = LogManager.getLogger();
    private final Client client;
    private final ClusterService clusterService;
    private final Map<String, QueryInsightsExporter> exporters;

    public QueryInsightsExporterFactory(Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.exporters = new HashMap<String, QueryInsightsExporter>();
    }

    public void validateExporterType(String exporterType) throws IllegalArgumentException {
        if (exporterType == null) {
            return;
        }
        try {
            SinkType.parse(exporterType);
        }
        catch (IllegalArgumentException e) {
            OperationalMetricsCounter.getInstance().incrementCounter(OperationalMetric.INVALID_EXPORTER_TYPE_FAILURES);
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid exporter type [%s], type should be one of %s", exporterType, SinkType.allSinkTypes()));
        }
    }

    public LocalIndexExporter createLocalIndexExporter(String id, String indexPattern, String indexMapping, long templatePriority) {
        LocalIndexExporter exporter = new LocalIndexExporter(this.client, this.clusterService, DateTimeFormatter.ofPattern(indexPattern, Locale.ROOT), indexMapping, id);
        exporter.setTemplatePriority(templatePriority);
        this.exporters.put(id, exporter);
        return exporter;
    }

    public LocalIndexExporter createLocalIndexExporter(String id, String indexPattern, String indexMapping) {
        return this.createLocalIndexExporter(id, indexPattern, indexMapping, 1847L);
    }

    public DebugExporter createDebugExporter(String id) {
        DebugExporter debugExporter = DebugExporter.getInstance();
        this.exporters.put(id, debugExporter);
        return debugExporter;
    }

    public QueryInsightsExporter updateExporter(QueryInsightsExporter exporter, String indexPattern, long templatePriority) {
        if (exporter.getClass() == LocalIndexExporter.class) {
            LocalIndexExporter localExporter = (LocalIndexExporter)exporter;
            localExporter.setIndexPattern(DateTimeFormatter.ofPattern(indexPattern, Locale.ROOT));
            localExporter.setTemplatePriority(templatePriority);
        }
        return exporter;
    }

    public QueryInsightsExporter getExporter(String id) {
        return this.exporters.get(id);
    }

    public void closeExporter(QueryInsightsExporter exporter) throws IOException {
        if (exporter != null) {
            exporter.close();
            this.exporters.remove(exporter.getId());
        }
    }

    public void closeAllExporters() {
        for (QueryInsightsExporter exporter : this.exporters.values()) {
            try {
                this.closeExporter(exporter);
            }
            catch (IOException e) {
                this.logger.error("Fail to close query insights exporter, error: ", (Throwable)e);
            }
        }
    }
}

