/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfo;

public class VkMemoryAllocateFlagsInfoKHR
extends VkMemoryAllocateFlagsInfo {
    public VkMemoryAllocateFlagsInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR sType$Default() {
        return this.sType(1000060000);
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHR set(VkMemoryAllocateFlagsInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfoKHR malloc() {
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR calloc() {
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkMemoryAllocateFlagsInfoKHR create(long address) {
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkMemoryAllocateFlagsInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateFlagsInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR mallocStack() {
        return VkMemoryAllocateFlagsInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR callocStack() {
        return VkMemoryAllocateFlagsInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(capacity, stack);
    }

    public static VkMemoryAllocateFlagsInfoKHR malloc(MemoryStack stack) {
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryAllocateFlagsInfoKHR calloc(MemoryStack stack) {
        return (VkMemoryAllocateFlagsInfoKHR)VkMemoryAllocateFlagsInfoKHR.wrap(VkMemoryAllocateFlagsInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkMemoryAllocateFlagsInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static class Buffer
    extends VkMemoryAllocateFlagsInfo.Buffer {
        private static final VkMemoryAllocateFlagsInfoKHR ELEMENT_FACTORY = VkMemoryAllocateFlagsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryAllocateFlagsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000060000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

