/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

public class CBParse {
    public static String bytes2Hex(byte[] bytes) {
        StringBuffer ret = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(CBParse.byte2Hex(bytes[i]));
        }
        return ret.toString();
    }

    public static String string2Hex(String orig) {
        StringBuffer ret = new StringBuffer(orig.length() * 2);
        char[] c = orig.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            ret.append(CBParse.char2Hex(c[i]));
        }
        return ret.toString();
    }

    public static String byte2Hex(byte b) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] array = new char[]{hexDigit[b >> 4 & 0xF], hexDigit[b & 0xF]};
        return new String(array);
    }

    public static String char2Hex(char c) {
        byte hi = (byte)(c >>> 8);
        byte lo = (byte)(c & 0xFF);
        return CBParse.byte2Hex(hi) + CBParse.byte2Hex(lo);
    }

    public static byte hex2Byte(char hex1, char hex2) {
        byte a = CBParse.hexChar2Byte(hex1);
        byte b = CBParse.hexChar2Byte(hex2);
        return (byte)((a << 4) + b);
    }

    public static byte hexChar2Byte(char hex) {
        if (hex <= '9') {
            return (byte)(hex - 48);
        }
        if (hex <= 'F') {
            return (byte)(hex - 55);
        }
        return (byte)(hex - 87);
    }

    public static String bytes2HexSplit(byte[] in, int wordlength) {
        String hex = CBParse.bytes2Hex(in);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < hex.length(); ++i) {
            buff.append(hex.charAt(i));
            if ((i + 1) % wordlength != 0) continue;
            buff.append(" ");
        }
        return buff.toString();
    }

    public static String bytes2HexSplit(byte[] in, int wordlength, int linelength) {
        String hex = CBParse.bytes2Hex(in);
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < hex.length(); ++i) {
            buff.append(hex.charAt(i));
            if ((i + 1) % wordlength == 0) {
                buff.append(" ");
            }
            if ((i + 1) % linelength != 0) continue;
            buff.append("\n");
        }
        return buff.toString();
    }

    public static boolean isUTF8(byte[] sequence) {
        boolean debug = false;
        if (debug) {
            System.out.println("\n\n Starting UTF8 Check\n\n");
        }
        for (int i = 0; i < sequence.length; ++i) {
            byte b = sequence[i];
            if (debug) {
                System.out.println("testing byte: " + CBParse.byte2Hex(b));
            }
            if ((b >> 6 & 3) == 2) {
                if (debug) {
                    System.out.println("start byte is invalid utf8 - has 10... start");
                }
                return false;
            }
            byte test = b;
            int numberBytesInChar = 0;
            while ((test & 0x80) > 0) {
                test = (byte)(test << 1);
                ++numberBytesInChar;
            }
            if (numberBytesInChar <= true) continue;
            for (int j = 1; j < numberBytesInChar; ++j) {
                if (i + j >= sequence.length) {
                    if (debug) {
                        System.out.println("following byte length is invalid - overruns end... ");
                    }
                    return false;
                }
                if (debug) {
                    System.out.println("testing byte: " + CBParse.byte2Hex(sequence[i + j]));
                }
                if ((sequence[i + j] >> 6 & 3) == 2) continue;
                if (debug) {
                    System.out.println("following byte is invalid utf8 - does *not* have 10... start");
                }
                return false;
            }
            i += numberBytesInChar - 1;
        }
        return true;
    }

    public static boolean isNonAsciiUTF8(byte[] sequence) {
        boolean nonAsciiDetected = false;
        for (int i = 0; i < sequence.length - 3; ++i) {
            byte b = sequence[i];
            if ((b >> 6 & 3) == 2) {
                return false;
            }
            byte test = b;
            int numberBytesInChar = 0;
            while ((test & 0x80) > 0) {
                test = (byte)(test << 1);
                ++numberBytesInChar;
            }
            if (numberBytesInChar <= true) continue;
            nonAsciiDetected = true;
            for (int j = 1; j < numberBytesInChar; ++j) {
                if ((sequence[i + j] >> 6 & 3) == 2) continue;
                return false;
            }
            i += numberBytesInChar - 1;
        }
        return nonAsciiDetected;
    }

    public static boolean isUnicode(byte[] sequence) {
        if (sequence.length >= 2) {
            if (sequence[0] == -1 && sequence[1] == -2) {
                return true;
            }
            if (sequence[0] == -2 && sequence[1] == -1) {
                return true;
            }
        }
        return false;
    }

    public static String toHTML(String rawText) {
        String test = rawText.length() > 14 ? rawText.substring(0, 14).toLowerCase() : rawText.toLowerCase();
        if (test.startsWith("<html>") || test.startsWith("<!doctype html>")) {
            if (test.startsWith("<html>")) {
                rawText = rawText.substring(6);
            } else if (test.startsWith("<!doctype html>")) {
                rawText = rawText.substring(15);
            }
            if (rawText.toLowerCase().endsWith("</html>")) {
                rawText = rawText.substring(0, rawText.length() - 7);
            }
            return rawText;
        }
        StringBuffer temp = new StringBuffer(rawText);
        block7: for (int pos = 0; pos < temp.length(); ++pos) {
            char C = temp.charAt(pos);
            switch (C) {
                case '<': {
                    CBParse.replaceChar(temp, pos, "&lt;");
                    continue block7;
                }
                case '>': {
                    CBParse.replaceChar(temp, pos, "&gt;");
                    continue block7;
                }
                case '&': {
                    CBParse.replaceChar(temp, pos, "&amp;");
                    continue block7;
                }
                case '\"': {
                    CBParse.replaceChar(temp, pos, "&quot;");
                    continue block7;
                }
                case '#': {
                    CBParse.replaceChar(temp, pos, "&#35;");
                    ++pos;
                }
            }
        }
        return temp.toString();
    }

    public static int replaceChar(StringBuffer text, int pos, String replacement) {
        text.deleteCharAt(pos);
        text.insert(pos, replacement);
        return pos + replacement.length();
    }

    public static String replaceAllChar(StringBuffer text, char c, String replacement) {
        return CBParse.replaceAllBufferChar(text, c, replacement).toString();
    }

    public static StringBuffer replaceAllBufferChar(StringBuffer text, char c, String replacement) {
        int pos = 0;
        while (pos != -1) {
            pos = text.toString().indexOf(c, pos);
            if (pos == -1) continue;
            pos = CBParse.replaceChar(text, pos, replacement);
        }
        return text;
    }

    public static int replaceString(StringBuffer text, int pos, int len, String replacement) {
        text.replace(pos, pos + len, replacement);
        return pos + replacement.length();
    }

    public static String replaceAllString(StringBuffer text, String orig, String replacement) {
        return CBParse.replaceAllBufferString(text, orig, replacement).toString();
    }

    public static StringBuffer replaceAllBufferString(StringBuffer text, String orig, String replacement) {
        int pos = 0;
        while (pos != -1) {
            pos = text.toString().indexOf(orig, pos);
            if (pos == -1) continue;
            pos = CBParse.replaceString(text, pos, orig.length(), replacement);
        }
        return text;
    }

    public static int nextCharIn(int pos, String searchMe, String compare, boolean match) {
        int length = searchMe.length();
        while (pos < length) {
            char test = searchMe.charAt(pos);
            if (compare.indexOf(test) != -1 == match) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }
}

