/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.jivesoftware.smack.packet.Element;

public class AbstractProvider<E extends Element> {
    private final Class<E> elementClass;

    protected AbstractProvider() {
        Type currentType = this.getClass().getGenericSuperclass();
        while (!(currentType instanceof ParameterizedType)) {
            Class currentClass = (Class)currentType;
            currentType = currentClass.getGenericSuperclass();
        }
        ParameterizedType parameterizedGenericSuperclass = (ParameterizedType)currentType;
        Type[] actualTypeArguments = parameterizedGenericSuperclass.getActualTypeArguments();
        Type elementType = actualTypeArguments[0];
        if (elementType instanceof Class) {
            this.elementClass = (Class)elementType;
        } else if (elementType instanceof ParameterizedType) {
            ParameterizedType parameteriezedElementType = (ParameterizedType)elementType;
            this.elementClass = (Class)parameteriezedElementType.getRawType();
        } else if (elementType instanceof TypeVariable) {
            TypeVariable typeVariableElementType = (TypeVariable)elementType;
            this.elementClass = typeVariableElementType.getClass();
        } else {
            throw new AssertionError((Object)("Element type '" + elementType + "' (" + elementType.getClass() + ") is neither of type Class, ParameterizedType or TypeVariable"));
        }
    }

    public final Class<E> getElementClass() {
        return this.elementClass;
    }
}

