/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

var testGenerator = testSteps();

function* testSteps()
{
  const urls = [
    "http://localhost",
    "http://www.mozilla.org",
    "http://example.com"
  ];

  const name = "test_getUsage.js";

  info("Opening databases");

  let request = indexedDB.open(name);
  request.onsuccess = continueToNextStepSync;

  yield undefined;

  // success

  for (let url of urls) {
    request = indexedDB.openForPrincipal(getPrincipal(url), name);
    request.onsuccess = continueToNextStepSync;

    yield undefined;

    // success
  }

  finishTest();
}
