// Copyright John Maddock 2025.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const std::array<std::array<T, 7>, 1040> ibeta_asym = {{
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(4.9877631664276123046875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8595650599998200763526761836496254286357e-103801), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(4.9902105331420898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0839774230488702218771452968760869212582e-84080), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(4.9926578998565673828125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1848762511513057221437363596112655784196e-66434), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(4.9951052665710449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.9534783117867768056651458342353825817065e-50865), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(4.9975526332855224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3294405368986941577207006329279258231529e-37371), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5437593585593338670495332030871331374806e-25953), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0024473667144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8667401527406194182139878884306505665057e-16611), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0048947334289550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7661800130663951382306890910905460194306e-9345), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0073421001434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2748010192451964528055690910997389500623e-4155), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0097894668579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6995356885522035275364454601002177889613e-1041), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0122368335723876953125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9835407593688209727727193948135311564548e-01), SC_(5.0164592406311790272272806051864688435452e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0146842002868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.2518161676016485291319881112875391457948e-1041) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0171315670013427734375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.6982357989728580519406881153338513420302e-4155) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0195789337158203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.9579762460453974127073617165166073587712e-9345) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0220263004302978515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1218187171609456200931890634911860109753e-16610) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0244736671447753906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6974958727312378399632843099597029737259e-25952) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0269210338592529296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5514358625578459860578689197122694242349e-37370) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0293684005737304687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5399291951945993843323020244832027637809e-50864) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0318157672882080078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2054477357535862582126090203903933309238e-66434) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9511715840000000000000000000000000000000e+09), SC_(5.0342631340026855468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9517596738505192019960896287503363359315e-84080) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9865424633026123046875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4602025711108221983697688676507643112470e-103777), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9889892339706420898437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7660711842547341284842872722933580272565e-84060), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9914360046386718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3663484345342374337965242236366367372357e-66419), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9938827753067016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8738888619197258319986554564460529211343e-50853), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9963295459747314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2782890787929262797658270698961292722478e-37362), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(4.9987763166427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6191261594431515813472769140892137326957e-25947), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0012230873107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.1105585040847710048034201736746023069621e-16608), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0036698579788208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6623035824799634097440970967780902935117e-9343), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0061166286468505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4752526554216598441571642192112950661389e-4154), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0085633993148803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.6950774246451801974748168425401828590302e-1041), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0110101699829101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9703938046810915339952604169921003926533e-01), SC_(5.0296061953189084660047395830078996073467e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0134569406509399414062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8555548619501618194002029223203509776148e-1040) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0159037113189697265625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0871054615056438115981029035467082217706e-4153) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0183504819869995117187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9995146912115414779718267580731857522938e-9342) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0207972526550292968750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1670883758698585274487132632866679737002e-16606) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0232440233230590820312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1603677963036124717285483928716751104440e-25945) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0256907939910888671875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3683351925762429968251857696620968578553e-37360) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0281375646591186523437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.8373595483047460500240515115206722660722e-50851) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0305843353271484375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.7668658650558453064331470981217493016421e-66417) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9560550400000000000000000000000000000000e+09), SC_(5.0330311059951782226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2123757121561380867385036913895960265628e-84058) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9853229522705078125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2857951208186816726122814771908293356526e-103750), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9877691268920898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8671204843089181146730074383591750467603e-84038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9902153015136718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6485812996090297971510067263674003936445e-66401), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9926614761352539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6431537534452111352368044214187615938793e-50839), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9951076507568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9204087983245267653491786936290684417376e-37352), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(4.9975538253784179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.7224432921475045818557684546687656326799e-25940), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8340398251855267945851829669492395167288e-16603), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0024461746215820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1148314121216928740299117800975174599439e-9340), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0048923492431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5420649259503214996106455034725535544886e-4153), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0073385238647460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8352385296051507453631419841114574198189e-1040), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0097846984863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9950001187535789773130463552349871522725e-01), SC_(5.0049998812464210226869536447650128477275e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0122308731079101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1692177272183092909232575673472604384846e-1040) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0146770477294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.7704770790429354262644884292290124521733e-4153) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0171232223510742187500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5901189928434218623246108669478865704050e-9340) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0195693969726562500000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.5428911325079969942785179466983345414836e-16603) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0220155715942382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0205608196145154005110189687622485210479e-25940) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0244617462158203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4545491845252935378294039307161225870096e-37352) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0269079208374023437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8212158253443948865674905005671951846791e-50840) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0293540954589843750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9032964528324756363237858081766524788391e-66402) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9609374720000000000000000000000000000000e+09), SC_(5.0318002700805664062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0408889890515126471603582529867408618414e-84039) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9841034412384033203125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7471000314086067275538487960802175367247e-103728), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9865490198135375976562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2360857894329558012384448373328174205039e-84021), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9889945983886718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3239501076023759794144163554432292818869e-66388), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9914401769638061523437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9222351953783358839715789435263091662298e-50829), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9938857555389404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5658105599906549540708284531802171191189e-37345), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9963313341140747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3127274982080162761003266231507374871296e-25935), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(4.9987769126892089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6642769784862712473388965740602331157138e-16600), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0012224912643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2294007787042499051695273472020983186277e-9339), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0036680698394775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.1769135672203626479335556353146661967733e-4153), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0061136484146118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5595520331403468352982872889031190194473e-1040), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0085592269897460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9520298528357454483833324730732018863918e-01), SC_(5.0479701471642545516166675269267981136082e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0110048055648803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1785385941555889603582919226571927195576e-1040) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0134503841400146484375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1768058128400292293867117357262037791018e-4151) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0158959627151489257812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8263989265475142907198455580085114061750e-9337) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0183415412902832031250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4613945910307632277425480346529191639602e-16597) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0207871198654174804687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7411350996997142048819466179659545597415e-25932) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0232326984405517578125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7381007939315704947625864893057862147453e-37341) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0256782770156860351562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4864310287620237902187870682354987744283e-50825) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0281238555908203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0666424294184597489188569498422691663743e-66383) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9658199040000000000000000000000000000000e+09), SC_(5.0305694341659545898437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3676751635199040251942740530359340123426e-84016) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9828851222991943359375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1329953468017989129841152926175141559623e-103699), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9853301048278808593750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.4703090157507900761300599166419989016806e-83997), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9877750873565673828125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9739822415851388879027356686905308372469e-66369), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9902200698852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4852398241680738522666410750026406380299e-50814), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9926650524139404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2163445936188861266808507453475224021264e-37334), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9951100349426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5373743769019263292490539457287172217722e-25927), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(4.9975550174713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1206710306099282859937596504905797850078e-16594), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.4764245681560381284931016669941566331792e-9336), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0024449825286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2184022148359748953285868783881932348111e-4151), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0048899650573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9712935218082346218710516772957026592889e-1040), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0073349475860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0048691281649259287454558353793158537231e-01), SC_(4.9951308718350740712545441646206841462769e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0097799301147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.8621293945680136674114503172265401380059e-1040) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0122249126434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5903991156827208227088092406156602945285e-4151) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0146698951721191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4513952125364044377116794644679050252625e-9336) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0171148777008056640625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2607350211898272437164587236124887609304e-16595) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0195598602294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.1677846267694294200165438194357704799176e-25928) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0220048427581787109375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.7788805793657342831873944825997983000815e-37335) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0244498252868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5927718533218427001113154096504725628004e-50815) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0268948078155517578125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4954573089482379780917757699399541269028e-66370) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9707033600000000000000000000000000000000e+09), SC_(5.0293397903442382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5066669135554195535138320663001515530661e-83999) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9816673994064331054687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6621541306282747208726333318273229878826e-103672), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9841117858886718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0333133483943175492776353282403173852830e-83975), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9865561723709106445312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2703773261364134708709288401281122975810e-66351), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9890005588531494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.3162481432377361694752572399240675567375e-50801), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9914449453353881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.7510427431219962270064463054298417761323e-37324), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9938893318176269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9055135846997438496839387734264843530779e-25920), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9963337182998657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.2232000456608896414068975177455888776313e-16590), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(4.9987781047821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.1188987231047995496151497066737509221630e-9333), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0012224912643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2093474015945641646594091432455927378776e-4149), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0036668777465820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8773753374957824590461837298550264327945e-1039), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0061112642288208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0284686568022098518894152904456079196993e-01), SC_(4.9715313431977901481105847095543920803007e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0085556507110595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.9748046701695328897188805128414921347480e-1040) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0110000371932983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6320588361861106103968606248691479305543e-4150) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0134444236755371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9289298768788815666583110165073117575397e-9334) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0158888101577758789062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.4440237016312422859832543498252030427750e-16592) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0183331966400146484375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7529895799082292058289067782801784781401e-25922) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0207775831222534179687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1549130835523266359469761463323223655406e-37326) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0232219696044921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5390057451615626156122324228235632830889e-50804) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0256663560867309570312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7480736190501815001406292069466035918610e-66355) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9755857920000000000000000000000000000000e+09), SC_(5.0281107425689697265625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5226120247307720164031929502981351999852e-83980) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9804496765136718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6189887375980928641048755566128886949630e-103648), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9828934669494628906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.8848011440958073407100543327737002434131e-83956), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9853372573852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1127990177197823207632952188561434815148e-66336), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9877810478210449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2509839679811504942552514417157348531769e-50789), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9902248382568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3941624243171368643004330908182928415164e-37315), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9926686286926269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1315987755108469513325261472416736329918e-25914), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9951124191284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3908042787731665885768802836171504056320e-16586), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(4.9975562095642089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5348961498380140636520943585592394403719e-9331), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.3749612895264885817428343340769644586414e-4149), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0024437904357910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5936042566414495608649458684309649226516e-1039), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0048875808715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0135431870099202335769941182976892776781e-01), SC_(4.9864568129900797664230058817023107223219e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0073313713073730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6174292325297688722459638796422836936181e-1039) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0097751617431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8167210157347832805552965603469094803583e-4149) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0122189521789550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.9719193129797360211027783345817722633438e-9332) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0146627426147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0141128436741998607897665082180444764180e-16587) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0171065330505371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3965487569586534159595705457591260105157e-25915) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0195503234863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.4408495040596491986992275576533508348379e-37317) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0219941139221191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2959744563700483566524857410206429261952e-50791) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0244379043579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5282462007308564731025930458733532834678e-66338) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9804692480000000000000000000000000000000e+09), SC_(5.0268816947937011718750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4208025252626729169637045267062960025989e-83958) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9792331457138061523437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1704797577593807701536280448356222427995e-103621), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9816763401031494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.4920047331926396534110369232857321821616e-83934), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9841195344924926757812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5784250398024544870374393319583137017242e-66318), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9865627288818359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1559886648228700758763499693890090235236e-50775), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9890059232711791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.0917229157027013062625300929368764369460e-37305), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9914491176605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1591745624378416522729617598622465709147e-25907), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9938923120498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2880329423638069115553445895597562983741e-16581), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9963355064392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1976121268226019644628212258397774355352e-9328), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(4.9987787008285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6834052120990929906585596165391914319939e-4147), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0012218952178955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9318023080625575108713271304000485091561e-1039), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0036650896072387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0367119868066528574378683329177361803742e-01), SC_(4.9632880131933471425621316670822638196258e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0061082839965820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9390271956649254748089559969577684200448e-1039) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0085514783859252929687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2998672220767012262985648915929078438478e-4148) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0109946727752685546875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.5574106886800416314410176772019501075423e-9330) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0134378671646118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8853381607335695933018209329116770171494e-16584) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0158810615539550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.1213970415075475962730066666125481822486e-25910) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0183242559432983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1928091367162317881031233125641986122213e-37309) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0207674503326416015625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.2167909116437196371632942286010938900592e-50780) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0232106447219848632812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8801153028735304019470767842858472308239e-66323) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9853516800000000000000000000000000000000e+09), SC_(5.0256538391113281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5262170794271046516888791561819560162834e-83939) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9780172109603881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2666207905621668149318443055829140527891e-103595), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9804598093032836914062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.1854266485236182410086861964902286453101e-83912), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9829024076461791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7818919848155875992749112972321577639761e-66301), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9853450059890747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0429907014772834932559417356029593240746e-50762), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9877876043319702148437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9361075508004361924082810783100423151848e-37295), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9902302026748657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6267705908167639489631574189124438916778e-25900), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9926728010177612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.8733606308679901716411285029933482638208e-16577), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9951153993606567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3564772782184034675562387173595315332459e-9325), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(4.9975579977035522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8241592456469588653906223315936929332923e-4146), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0000005960464477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8481626777156658435968400209058902630440e-1038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0024431943893432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0597477544799880632174481323155252296333e-01), SC_(4.9402522455200119367825518676844747703667e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0048857927322387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3300282513091969401465164455799093902455e-1039) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0073283910751342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.0270284814384489476899210657872011623300e-4148) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0097709894180297851562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6239115475349526934470718643944806862129e-9328) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0122135877609252929687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5877721708307502371715540055708886337770e-16580) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0146561861038208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2306784775264684903258733404847735379223e-25904) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0170987844467163085937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1518401541869715036843988216193525091326e-37300) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0195413827896118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2323713209309048550854347505029995497582e-50768) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0219839811325073242187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4244600432838853025018920234381907496395e-66308) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9902341120000000000000000000000000000000e+09), SC_(5.0244265794754028320312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6740660552775378562591751416905792832307e-83920) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9768006801605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.5351465826530518890005222522319080279880e-103576), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9792426824569702148437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5701550965936889877410708453355693117570e-83897), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9816846847534179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3240910845350573247177567475229675418017e-66290), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9841266870498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8534088468783681541989554028743685872664e-50754), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9865686893463134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.5229632918003155825708914894963662387215e-37290), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9890106916427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.1911185635259650112764687352401546734971e-25897), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9914526939392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4281404592719408664727202225157051766268e-16575), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9938946962356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4567942206650470463788977396609283525762e-9325), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9963366985321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2361452868538542367819265979014377342197e-4146), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(4.9987787008285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.9050879929741246576156303072263098018275e-1039), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0012207031250000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9771053333175739104349519381779876922902e-01), SC_(5.0228946666824260895650480618220123077098e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0036627054214477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7454343007759742576766463166529183223098e-1038) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0061047077178955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0849498324350458807142019200797218851012e-4145) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0085467100143432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.6523176474867386969678894736471834717747e-9324) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0109887123107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.5110318963863880607393071319685117333835e-16574) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0134307146072387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4428569791805450734943948807811698361544e-25895) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0158727169036865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.4139283920948015396917452138833629770614e-37288) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0183147192001342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.6328154350422660214942588585253563808763e-50752) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0207567214965820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4346629109008262395140745242652325583401e-66287) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(9.9951175680000000000000000000000000000000e+09), SC_(5.0231987237930297851562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5758598445791299019673065015277941952961e-83894) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9755859375000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.5089800123950323985224437784131243031483e-103549), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9780273437500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8857489779196478003289415410147024270253e-83875), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9804687500000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8799203706372477368527363459548309059276e-66272), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9829101562500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3254011426764580980841555732786312440517e-50740), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9853515625000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0695882954092229891283588406501656105406e-37279), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9877929687500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0405983032214119869655345924048573799799e-25889), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9902343750000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2833178954106063988886687898443029521816e-16570), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9926757812500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1183594420934861705926701131167024323867e-9322), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9951171875000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0555200052709313338945501119018801368677e-4145), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(4.9975585937500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1027017962159684828619127964318458716181e-1038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0024414062500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1027017962159684828619127964318458716181e-1038) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0048828125000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0555200052709313338945501119018801368677e-4145) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0073242187500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1183594420934861705926701131167024323867e-9322) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0097656250000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2833178954106063988886687898443029521816e-16570) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0122070312500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0405983032214119869655345924048573799799e-25889) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0146484375000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0695882954092229891283588406501656105406e-37279) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0170898437500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3254011426764580980841555732786312440517e-50740) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0195312500000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8799203706372477368527363459548309059276e-66272) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0000000000000000000000000000000000000000e+10), SC_(5.0219726562500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8857489779196478003289415410147024270253e-83875) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9743714928627014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.2454939977140468397072603883385006589473e-103525), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9768123030662536621093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2402897352788618827884527437873005101932e-83855), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9792531132698059082031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3167687049052475089167810305120665226192e-66257), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9816939234733581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.7606631621797524162668238193855280145717e-50729), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9841347336769104003906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0886640537715017508894112282346525274292e-37271), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9865755438804626464843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2073708401180733447969583643055242099969e-25884), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9890163540840148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.6149876956220361805029215463514295025806e-16567), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9914571642875671386718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2654933103369475384497400338112872764523e-9320), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9938979744911193847656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5691942595381340071218794493002601301024e-4144), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9963387846946716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1251674449433669325143157920772864873543e-1038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(4.9987795948982238769531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9892784488859056718107599963347123982717e-01), SC_(5.0107215511140943281892400036652876017283e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0012207031250000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5325534338425986019375094663273555323321e-1038) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0036615133285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3547704456139093888116587783073593217306e-4144) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0061023235321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2279322390934673672848629991549364693041e-9320) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0085431337356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9860157533024178563027556812598890877807e-16567) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0109839439392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1420348592528761857553793128304789088630e-25884) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0134247541427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3579955855272720667676486694895756870540e-37271) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0158655643463134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2980812180934325196995232562485994224081e-50729) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0183063745498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4490289346153544816191108307293550829494e-66257) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0004882432000000000000000000000000000000e+10), SC_(5.0207471847534179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.2262788475522057335666109799131449167554e-83856) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9731573462486267089843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2908204718128173444937076431588295123455e-103501), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9755975604057312011718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5349153121828566172778072190752437888242e-83836), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9780377745628356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.7731434573779260204937148252658453712351e-66242), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9804779887199401855468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5530505910539367648117544982641219367959e-50717), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9829182028770446777343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.5417100716643214269338598666069605793579e-37263), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9853584170341491699218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2931605739865818406917350938957959769133e-25878), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9877986311912536621093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4561115672393019846184256444189610216665e-16563), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9902388453483581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8950514337719570642898520397732680332047e-9318), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9926790595054626464843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1396246979601374751498447792800119646628e-4143), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9951192736625671386718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2804955850511537550612165361870386850516e-1038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9975594878196716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9738429911689813191718703482052369969897e-01), SC_(5.0261570088310186808281296517947630030103e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(4.9999997019767761230468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0602266777116149171738771606520599560397e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0024402141571044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.1339458470376332407465004570287000016430e-4143) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0048804283142089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.2060297156373234625803379567662767155614e-9318) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0073206424713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.8588946431449722248477921533449429000910e-16563) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0097608566284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6111443152893018973874747470117033218890e-25877) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0122010707855224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.2018856597886722819689773370213591712649e-37262) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0146412849426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.1226334237129072152448757406576626585449e-50716) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0170814990997314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2396969533966914314464417854795558328424e-66240) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0009765888000000000000000000000000000000e+10), SC_(5.0195217132568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4014928687141178327227389340347295029204e-83834) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9719440937042236328125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7481604364627039307393146327308207723427e-103476), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9743837118148803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1170180229774315118262465965895364462152e-83816), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9768233299255371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2473151523870480172108546430876545328930e-66226), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9792629480361938476562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5237741681995778927651410744714817650577e-50705), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9817025661468505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7074253038529531135520828736033817627009e-37254), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9841421842575073242187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4321744186877263607064349230914110330929e-25872), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9865818023681640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2797328461185391498088663206589122594138e-16559), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9890214204788208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0430460955244601809082495707235552472611e-9316), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9914610385894775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5186691100668676926298655149352715550071e-4142), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9939006567001342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3788853020523530349556720467960588398822e-1038), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9963402748107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9632705047230129340669147393373323645819e-01), SC_(5.0367294952769870659330852606626676354181e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(4.9987798929214477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2796162251842367345645256629408286718597e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0012195110321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9653320728244899314049038347321477133518e-4141) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0036591291427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.8394437174819245345608648701850709191667e-9315) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0060987472534179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3893446926257031770983977992440684190715e-16557) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0085383653640747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6233150309624089766671420093769176680406e-25869) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0109779834747314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2417683779674949351424106715642018552784e-37250) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0134176015853881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4269096997809262439500390466004118423630e-50701) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0158572196960449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8722007743598924997256942588725593798688e-66221) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0014648320000000000000000000000000000000e+10), SC_(5.0182968378067016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4276014267623472562603937310713977763224e-83811) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9707317352294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2787171752889190234525206382034774694093e-103449), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9731707572937011718750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.5124239073219332821387326643346833586301e-83795), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9756097793579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9953295771528168351624859994300115470410e-66209), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9780488014221191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.4552838501032159238237371962892364179077e-50692), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9804878234863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8142338721063006312587067191639634370826e-37244), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9829268455505371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1092357100884436274386140626323328337811e-25865), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9853658676147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9180240295840083881053484306516331904629e-16555), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9878048896789550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2733109142475172063448067711760614401562e-9313), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9902439117431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4722164210010787989261043103469664725531e-4141), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9926829338073730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7062999562605744083277688641606284462684e-1037), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9951219558715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9864974565033030026136451043448789444616e-01), SC_(5.0135025434966969973863548956551210555384e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(4.9975609779357910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7309666097720994336205794693452851977064e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.0561105430483986470137864394981681809809e-4141) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0024390220642089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.6119147574457154886558861274654021585257e-9313) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0048780441284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4404442873391911314549019367793170294466e-16554) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0073170661926269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.7089080272690239271263710332923790796659e-25864) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0097560882568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5259284329961488667502505938177507042281e-37242) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0121951103210449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0500180300333539712650210119942834451330e-50690) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0146341323852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3810853890947165392986482008236773783456e-66206) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0019530752000000000000000000000000000000e+10), SC_(5.0170731544494628906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.7742336783357951228066395991422587197620e-83792) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9695196747779846191406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.1662582813578420375289888269761378504104e-103423), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9719581007957458496093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9161395191355991421128905304860000817568e-83773), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9743965268135070800781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1422253578727658083307121921419932407155e-66191), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9768349528312683105468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1114292587273052313163226056915865937139e-50678), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9792733788490295410156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8585280295053309607633303334557988071298e-37234), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9817118048667907714843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0904558557016787432595791732959240677905e-25858), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9841502308845520019531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.7135302290863762375603916833852033222101e-16550), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9865886569023132324218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.2410299987330260309159065042230519879572e-9311), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9890270829200744628906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.7653460701582807697105628968074811944358e-4140), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9914655089378356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2138114891887420536016540533905858997197e-1037), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9939039349555969238281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0051226295200958353620730693038246974312e-01), SC_(4.9948773704799041646379269306961753025688e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9963423609733581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5426628977589679138951627665865802917193e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(4.9987807869911193847656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.8917278362463679012307427143169559275381e-4140) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0012195110321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.0827708022638597483232389060294246928937e-9312) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0036579370498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6572852136497516642470034262303752339266e-16551) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0060963630676269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8318364720127640215828835031632997249044e-25859) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0085347890853881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1624332283310696264959681466190007404744e-37236) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0109732151031494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9950849487943429176133266526175441319003e-50680) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0134116411209106445312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8163213456602119109740177477936727542063e-66193) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0024414208000000000000000000000000000000e+10), SC_(5.0158500671386718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.6125843295502477258433773786259719719585e-83775) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9683082103729248046875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.7795262046317731202787096819076523342809e-103399), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9707460403442382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8999535779436497210031562405300940914386e-83753), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9731838703155517578125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5962541871185619312930697943047064367150e-66176), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9756217002868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.1458869250094835525059797195988831806709e-50667), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9780595302581787109375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5977073258386986213547592330324031669967e-37225), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9804973602294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2906653981926382823275618115179447230253e-25852), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9829351902008056640625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4748705021526504215820141521031516831473e-16546), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9853730201721191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9447284604267071168485832346076798297562e-9309), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9878108501434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9042047130931326281473980956428971114699e-4139), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9902486801147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3460474924259279855866043077469366402573e-1037), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9926865100860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9951574063825297918011199887785220416435e-01), SC_(5.0048425936174702081988800112214779583565e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9951243400573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.5376850548059102814747673671520517995987e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(4.9975621700286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1090694512174862979509433699010339045090e-4139) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2972078213582599651919239577936450986430e-9308) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0024378299713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.8513505334453779918443426409785305325505e-16546) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0048756599426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7461469817220696939401002097553766544694e-25851) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0073134899139404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1607552131501090267023280663851294438718e-37224) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0097513198852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0908768703919234634379640863264127110153e-50665) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0121891498565673828125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3951925764070995066968630729911553662697e-66174) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0029296640000000000000000000000000000000e+10), SC_(5.0146269798278808593750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3279762355110701064604749514806159977897e-83751) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9670973420143127441406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4913467560022606498876475136351177832736e-103372), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9695345759391784667968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.4906817984018937795448763479888999686894e-83732), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9719718098640441894531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3151776256491085405166253647501005441352e-66159), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9744090437889099121093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5513083566536406986811842362037280364782e-50653), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9768462777137756347656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3520081827019989352202219922065025672657e-37215), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9792835116386413574218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.4724388713278004200875237191271271745589e-25845), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9817207455635070800781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9975709661473945417291594227991138771724e-16542), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9841579794883728027343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4971277161487212694082439531823990180505e-9306), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9865952134132385253906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.7289182408167055118994667285977260722329e-4138), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9890324473381042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5813363208775113605487794693896859823632e-1036), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9914696812629699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0143077571030558151822841736755837271384e-01), SC_(4.9856922428969441848177158263244162728616e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9939069151878356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6904779657030889298227926427521088388981e-1037) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9963441491127014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7716201563790918722264201245795978232999e-4138) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(4.9987813830375671386718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.1371335154286781066992849304096118710522e-9307) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0012189149856567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1317676347901710422420685777947713960414e-16543) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0036561489105224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9668329422946307230197477623424410710470e-25847) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0060933828353881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.6033513690981048992217230684078804841372e-37218) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0085306167602539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.0453592052801992955595094863030948808818e-50656) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0109678506851196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7071320747383802352126355083114503482405e-66161) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0034180096000000000000000000000000000000e+10), SC_(5.0134050846099853515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4577984140597823825355122452716078265233e-83734) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9658873677253723144531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.0959584941600547910616165017823494848078e-103345), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9683240056037902832031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.5944348943896481981599199631448235004805e-83710), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9707606434822082519531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2912271924979510225863563698996445588480e-66141), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9731972813606262207031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3486599231546189578329108490085708174174e-50640), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9756339192390441894531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9684236481315764053322318103297628595316e-37205), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9780705571174621582031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.3224360164466688415350286549795266251248e-25838), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9805071949958801269531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4981623182314520844242696280711021424765e-16537), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9829438328742980957031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3071629990142814977294726523947615714645e-9303), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9853804707527160644531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3102190598666141803029245890088889542749e-4136), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9878171086311340332031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3105713952088303088024123688147847255324e-1036), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9902537465095520019531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0386476473452360469922795377978001833964e-01), SC_(4.9613523526547639530077204622021998166036e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9926903843879699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1390463330290173030992847280464091578657e-1036) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9951270222663879394531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6732298285723218722996818986801036535390e-4137) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(4.9975636601448059082031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9232174402338439857709853980215325238668e-9305) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0000005960464477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3886779191942143812101235780662522378452e-16540) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0024372339248657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0601919925018001629099466945422689129163e-25841) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0048738718032836914062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.2408441236061191444948869187079013954082e-37210) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0073105096817016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.3711199370568096901606383881600704438492e-50645) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0097471475601196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0815536679679311046169282455510238608310e-66146) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0039062528000000000000000000000000000000e+10), SC_(5.0121837854385375976562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.2028373636497643189294131647534480805504e-83715) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9646776914596557617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.7349408629648107554092413810270133382448e-103321), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9671137332916259765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9187044929860439874805190430469568507942e-83690), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9695497751235961914062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.3525048401289485974566045531071989361978e-66126), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9719858169555664062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6392697904141782470916616030174909432776e-50628), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9744218587875366210937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.0942779258279498909720402180453822172244e-37197), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9768579006195068359375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.7610133378031062160016088270298897228831e-25832), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9792939424514770507812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0449874050849904688294355506493693063943e-16533), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9817299842834472656250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.7112949746253798904705803073533866772921e-9301), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9841660261154174804687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7366803069500815011424382101519247280447e-4135), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9866020679473876953125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.6108391251307955810470187732758208455621e-1036), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9890381097793579101562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0297324780611405791121787261543353158944e-01), SC_(4.9702675219388594208878212738456646841056e-01) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9914741516113281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3800179186083721998985900912791931628407e-1036) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9939101934432983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3451188045218660070759541826033178740457e-4136) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9963462352752685546875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4894499136707221310198329180352481299283e-9302) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(4.9987822771072387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.1630638889140671942909699844560134708227e-16535) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(5.0012183189392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.2304363094037101573344195929324302537560e-25834) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(5.0036543607711791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.2273059229335130943908396054261412331138e-37199) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(5.0060904026031494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5494627482646491897123436851810217041926e-50630) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(5.0085264444351196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1838511005322522280789730492315086957753e-66128) }, 
      { SC_(1.0000000000000000000000000000000000000000e+10), SC_(1.0043944960000000000000000000000000000000e+10), SC_(5.0109624862670898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.5838955006016884831676670761585757097056e-83692) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(4.9877631664276123046875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5808311106416542119999847425393632535007e-10379719), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(4.9902105331420898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.5931176836720815968227618055674800451245e-8407576), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(4.9926578998565673828125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2518003265436996116998642334927743545766e-6643029), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(4.9951052665710449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.8544208483614561251439613974525545841507e-5086077), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(4.9975526332855224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6980402339194707364132897176368421251589e-3736718), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.5044963211097080424488102736795346091123e-2594953), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0024473667144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9814141221124768039427997075880741864743e-1660779), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0048947334289550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0956889613352600818903350516651160806819e-934197), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0073421001434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3008084052148777305397931797935946036775e-415207), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0097894668579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2164622941168375782475165806150040915356e-103809), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0122368335723876953125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8817565991376496108903120942680230962127e-01), SC_(5.1182434008623503891096879057319769037873e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0146842002868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.5423423861601861005946805517494490559964e-103792) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0171315670013427734375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1610585595418497016803493993419439296540e-415174) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0195789337158203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1045491502583658115762286215051456107099e-934153) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0220263004302978515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9167556250655860901346813415564058904086e-1660729) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0244736671447753906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3668759068530148929462037604283496361109e-2594905) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0269210338592529296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6230465227113503339506635428342761433143e-3736683) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0293684005737304687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.9535116399210846634924003190376371186961e-5086066) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0318157672882080078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1924283437485988358302165878038854605624e-6643056) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9511717068800000000000000000000000000000e+11), SC_(5.0342631340026855468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3526504286937392764173701820507840816920e-8407657) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9865424633026123046875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6729424051477556668670825136069621126415e-10377385), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9889892339706420898437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3141906105554128224123098705407113702980e-8405700), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9914360046386718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6691223446959146261507482727729263623115e-6641561), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9938827753067016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2446198288103965168724263059605204111777e-5084968), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9963295459747314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5667618008885831093988552248980698147253e-3735918), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(4.9987763166427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.3538766131557061549176037169701626338005e-2594412), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0012230873107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0913086849547278716527606740907941325727e-1660447), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0036698579788208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2468291843506217871182605574692209939828e-934024), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0061166286468505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0105528821867233697663551890421456813599e-415142), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0085633993148803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2561932074094261868918773562667841756059e-103802), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0110101699829101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6463850259189482065695841895341808678972e-01), SC_(5.3536149740810517934304158104658191321028e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0134569406509399414062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1642908720290534775513186714376178722869e-103749) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0159037113189697265625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.3509347480355613102094123585495686410022e-415038) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0183504819869995117187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.8609507222646712465949475877608381530359e-933872) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0207972526550292968750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.2076379503155143346722733003056399319465e-1660253) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0232440233230590820312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4454430065062089386958506255779460907324e-2594182) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0256907939910888671875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4760064197046743243616698615134578020354e-3735663) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0281375646591186523437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4880403657142350460945515541020691031592e-5084697) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0305843353271484375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.7263820964663382718951795975925265414155e-6641288) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9560547942400000000000000000000000000000e+11), SC_(5.0330311059951782226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.6554172847821186004307857784271615870133e-8405438) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9853229522705078125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1229972513482229086374401029593726367799e-10374688), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9877691268920898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1721617480160518760264985859295955966254e-8403497), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9902153015136718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.6450447619376849553571467058663022496411e-6639804), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9926614761352539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4740792835062577368217057708670093200087e-5083605), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9951076507568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.6084785024770855762155447135570152571690e-3734901), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(4.9975538253784179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5153266330101248875745828137750804393336e-2593689), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7266044568470799278520540528497599138181e-1659969), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0024461746215820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2477225930969505338424102638139962634988e-933741), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0048923492431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3708614081487152742716192040918141577217e-415004), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0073385238647460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.4491769837769358726635838122681370006665e-103758), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0097846984863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8920266610696057983858169344428650482120e-01), SC_(5.1079733389303942016141830655571349517880e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0122308731079101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.3105611284814227371383072685741747560226e-103742) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0146770477294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0563161549490080114657868880610427772031e-414973) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0171232223510742187500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2981356883309795324484100072477389797485e-933699) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0195693969726562500000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9486039526236466624759543953079834660610e-1659921) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0220155715942382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9235054465618070191104446639262550571292e-2593641) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0244617462158203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4964107647071851285378954436380475737731e-3734860) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0269079208374023437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9902590400764075197435558441878411959790e-5083582) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0293540954589843750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1324691360625647388724657510489384344481e-6639809) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9609372262400000000000000000000000000000e+11), SC_(5.0318002700805664062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7104605012966724224115145378962409033529e-8403544) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9841040372848510742187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2592515959432000851551664736380457699016e-10371855), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9865496158599853515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3521195873395507849589082488521401784345e-8401172), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9889951944351196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7680645267576478202788221483648929526911e-6637937), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9914407730102539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7996545679448039579043552345501509128452e-5082147), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9938863515853881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3755359174927206587433786088463320775409e-3733801), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9963319301605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0432663427752671679643158657542144300900e-2592898), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(4.9987775087356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1468930439480752788377079538588359398571e-1659437), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0012230873107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2463352457984088142550463551090481951364e-933417), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0036686658859252929687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.3816235097520118537298441034807834075355e-414839), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0061142444610595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2165490094404967452274422648661625809873e-103700), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0085598230361938476562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3193257052343693800116744263848508606272e-01), SC_(4.6806742947656306199883255736151491393728e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0110054016113281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.6485427434980705893685547310512625805154e-103749) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0134509801864624023437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.2490781401424392275286829438234762690141e-414937) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0158965587615966796875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4495848984040292866728077512780200242445e-933568) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0183421373367309570312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2676367809677826432553093493563521566607e-1659644) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0207877159118652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1109837797068435804372652786353742722185e-2593168) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0232332944869995117187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4883151860903086989385872139378407184201e-3734140) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0256788730621337890625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6754110984880034992621938901359640979883e-5082563) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0281244516372680664062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9144730938955946986983254293884602981255e-6638440) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9658203136000000000000000000000000000000e+11), SC_(5.0305700302124023437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3605558279530867084236983869293375796782e-8401774) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9828851222991943359375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2591735633133168877941169926072248495512e-10369531), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9853301048278808593750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0531503084181409059938502630829129319696e-8399305), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9877750873565673828125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.7806347437415462361158537285251825973892e-6636477), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9902200698852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0007783038397153617369722199764196574753e-5081044), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9926650524139404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.4688197674112635255532588126915570463436e-3733007), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9951100349426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.0358472313408755305124841034287421453133e-2592362), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(4.9975550174713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3541924000525194189950907336921931086426e-1659108), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6185209716172244856300195028409598725080e-933246), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0024449825286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.5469646733051192007566704844794336064566e-414775), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0048899650573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0124315580829074775483235053333083759131e-103694), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0073349475860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0718138626132945495825616352243110201827e-01), SC_(4.9281861373867054504174383647756889798173e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0097799301147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9694624463355996450025549963286669835704e-103705) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0122249126434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8846118733748701311960928758785834473659e-414798) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0146698951721191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7364941030120539021278821504021624742317e-933284) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0171148777008056640625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6400896306431100472152069852026931892008e-1659164) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0195598602294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3596836083154127356929020727016078371439e-2592440) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0220048427581787109375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7720926093340896671687042985986240633869e-3733114) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0244498252868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1028891133228208395353749452918519888865e-5081188) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0268948078155517578125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.6657776672819636549336857247172266686909e-6636665) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9707034009600000000000000000000000000000e+11), SC_(5.0293397903442382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3669980228620667485646865541062462182016e-8399547) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9816673994064331054687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1887332603153952744408645134402063904032e-10366841), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9841117858886718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0174975946785628797039997451844280594535e-8397109), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9865561723709106445312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4828926719390344853556834088365019935143e-6634725), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9890005588531494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3918227742866168950876328564840381423657e-5079687), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9914449453353881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.8322807733582720464294413158934215493771e-3731994), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9938893318176269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7542407440196775668204930206454973403445e-2591643), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9963337182998657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7777514469350760216945990410096976019808e-1658634), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(4.9987781047821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5140431802578796688843010055306926604179e-932966), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0012224912643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4157737833803964646780294553586084291567e-414638), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0036668777465820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1799914042377396751163837503864055701566e-103651), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0061112642288208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3075074117872502917291045480688015942926e-01), SC_(4.6924925882127497082708954519311984057074e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0085556507110595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7486004792818780113389534117267167316439e-103697) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0110000371932983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6470133735014244702625159383525371874113e-414732) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0134444236755371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4671798990050002217769541536073645474982e-933109) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0158888101577758789062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.0166650424645296195404192142797650589229e-1658830) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0183331966400146484375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1327689570869665396049380180115480833791e-2591895) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0207775831222534179687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9667722055457776737401834127234188473201e-3732307) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0232219696044921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7320694951227834073994389397304888584397e-5080068) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0256663560867309570312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3083047417308406637737528805992870673368e-6635180) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9755858329600000000000000000000000000000e+11), SC_(5.0281107425689697265625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3135966392929922793244656632938329394760e-8397646) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9804496765136718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.1455163356799154649697708437666095252594e-10364521), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9828934669494628906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8047253167663699291529147782696495725141e-8395245), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9853372573852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7975253317002612500678839639082483743865e-6633268), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9877810478210449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2065017235220501212690067779741743048524e-5078588), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9902248382568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1727358098657445467337059898668923692154e-3731201), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9926686286926269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8120695099907295563898836236808268878073e-2591108), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9951124191284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3033041398879182990529549816226076294053e-1658307), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(4.9975562095642089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6270433088579108958051400570752368498604e-932796), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0228194164771509998997179024180314388547e-414575), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0024437904357910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2405478480205040927731580071592948881529e-103645), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0048875808715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0544071445781899838054255250928229116779e-01), SC_(4.9455928554218100161945744749071770883221e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0073313713073730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9791866862798821692873225510206903177224e-103653) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0097751617431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.8477037403649137134116176779173450555587e-414593) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0122189521789550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0036646450301596411575900899011770372967e-932824) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0146627426147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4430341352733057931061755788482046190660e-1658348) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0171065330505371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.7820747999476819926362320038365959311179e-2591166) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0195503234863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7643441975219714600410017518211942014617e-3731279) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0219941139221191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1468314649048541364676696834564412207207e-5078690) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0244379043579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4832411287130117687027622960406607054172e-6633401) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9804689203200000000000000000000000000000e+11), SC_(5.0268816947937011718750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1531134994542715909323978594273311592539e-8395415) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9792331457138061523437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.3619444807876080652432634055431893702507e-10361835), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9816763401031494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.5299112158253523535803242986398576590195e-8393053), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9841195344924926757812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7104922138277699739801853683812449831564e-6631519), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9865627288818359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0629518304681837551891441971325494496682e-5077232), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9890059232711791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5449353586418243253206979654013008746900e-3730190), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9914491176605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2724896404912895484146923147930635467187e-2590391), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9938923120498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.4265092030138234611384128379241885495024e-1657834), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9963355064392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0416855004619933957254473670601512438194e-932517), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(4.9987787008285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.1276832314656550228787089151349503357324e-414440), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0012218952178955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0295613820118394511313895774676758128395e-103602), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0036650896072387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2858919159175917572238631643761957073135e-01), SC_(4.7141080840824082427761368356238042926865e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0061082839965820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9589341337848960979489035861784892171664e-103645) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0085514783859252929687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.7945191456133106988001131328293976603429e-414527) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0109946727752685546875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0083362994632679444037859433015538823327e-932648) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0134378671646118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4891820814270668516221006369951658847603e-1658012) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0158810615539550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.4437562685532444350114683368299187013829e-2590619) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0183242559432983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9770882923636171227029568848133529907379e-3730470) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0207674503326416015625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.7909840792488140927560523102865516753044e-5077568) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0232106447219848632812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8885312894408663618611702493462420814807e-6631914) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9853513523200000000000000000000000000000e+11), SC_(5.0256538391113281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5482729142712615311050496068446384729748e-8393512) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9780166149139404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.8284902606748203614610624531615188939670e-10359517), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9804592132568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.9768998774269348909610214537357981547160e-8391191), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9829018115997314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.8713881719429337495138062565926334758249e-6630065), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9853444099426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2683779838251572173818651865762735633566e-5076135), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9877870082855224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8431639658055087862749743841081255489117e-3729400), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9902296066284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.1559002437488068653817197646660665418716e-2589858), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9926722049713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.1566110934768268394824156483537340184582e-1657508), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9951148033142089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2762171038480001926654751419984293408403e-932348), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(4.9975574016571044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5236537121470493034053019989757543480985e-414377), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4863337646955349565355334283365274116141e-103596), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0024425983428955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0291538211245611155181456097152212317097e-01), SC_(4.9708461788754388844818543902847787682903e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0048851966857910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2364829020696607211372625957813758517485e-103600) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0073277950286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.7084702795824788846777830421597856020524e-414387) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0097703933715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.4938521333492034756196147245010007555407e-932363) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0122129917144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6044663636491727107412193263110532424417e-1657529) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0146555900573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8599217218790172428299826836174821748308e-2589888) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0170981884002685546875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3772573673084349901261411039430922542164e-3729440) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0195407867431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6197472317418219166372479854525540710516e-5076188) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0219833850860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4606264020841016008248290339360197214690e-6630133) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9902344396800000000000000000000000000000e+11), SC_(5.0244259834289550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.9691632944015854231376363197771291774430e-8391279) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9768006801605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8407369408073178535477652175006955553508e-10357338), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9792426824569702148437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1551343471826541902937523481771932901510e-8389455), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9816846847534179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2765122774767232813497571630613487281126e-6628721), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9841266870498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9789678122730125699125689814845935629852e-5075135), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9865686893463134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5073744659674316035318326566517830307177e-3728693), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9890106916427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1061083392424245497911169607586349165284e-2589394), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9914526939392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4727919591681564487732461158061308405229e-1657237), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9938946962356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0419539267021599507749453527884352543559e-932220), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9963366985321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5881528226431706107553456950709359977157e-414343), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(4.9987787008285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1285718021369590766299078320124826168567e-103604), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0012207031250000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.5868464195605442593995909718682552536011e-01), SC_(5.4131535804394557406004090281317447463989e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0036627054214477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9798258612986488520750364422689703733449e-103542) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0061047077178955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.7656723127838303213916653188135636614152e-414219) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0085467100143432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8054723969709383947969549799637904154858e-932035) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0109887123107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.9885930693941670731709106907870303199603e-1656991) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0134307146072387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2625876428996790621079897626739021339190e-2589087) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0158727169036865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9540116008422795127120780172653558156640e-3728327) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0183147192001342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1110788556576375301284234586969122338263e-5074710) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0207567214965820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3320071782937118029236650774011919197774e-6628240) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9951168716800000000000000000000000000000e+11), SC_(5.0231987237930297851562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0438072831624313398912521614962102045544e-8388919) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9755859375000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0953606875337901924564386785112095013094e-10354515), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9780273437500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3168994307708777633263784156188796806878e-8387139), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9804687500000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.7312596999821006812775918888188960496401e-6626863), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9829101562500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2331858054597021706988274993189341854509e-5073684), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9853515625000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.6591663300054477978665723737017489283766e-3727600), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9877929687500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3614910028856013729666231192571123821730e-2588609), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9902343750000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0812900281651708788476957655912643093655e-1656709), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9926757812500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6854765239479037490654226059718184145785e-931900), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9951171875000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9121954182559303625776137577858929202081e-414180), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(4.9975585937500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.5251958978188833376956240331329296665157e-103548), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0024414062500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.5251958978188833376956240331329296665157e-103548) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0048828125000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.9121954182559303625776137577858929202081e-414180) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0073242187500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6854765239479037490654226059718184145785e-931900) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0097656250000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0812900281651708788476957655912643093655e-1656709) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0122070312500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3614910028856013729666231192571123821730e-2588609) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0146484375000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.6591663300054477978665723737017489283766e-3727600) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0170898437500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.2331858054597021706988274993189341854509e-5073684) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0195312500000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7312596999821006812775918888188960496401e-6626863) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(9.9999999590400000000000000000000000000000e+11), SC_(5.0219726562500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3168994307708777633263784156188796806878e-8387139) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9743714928627014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.2014057777546613665601661801586148364957e-10351946), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9768123030662536621093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5375472399699541026750812592739056604984e-8385051), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9792531132698059082031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1214662210205542366903054348683401259460e-6625207), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9816939234733581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1457164123987471294884611487717301607073e-5072410), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9841347336769104003906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0460627652175201946438493962361313091146e-3726658), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9865755438804626464843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8415281361382585006439375810314207477361e-2587950), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9890163540840148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.7380115309052134511145479659141074300020e-1656283), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9914571642875671386718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.6258856759203911441892048962921743300078e-931656), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9938979744911193847656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6087861843471086662482037058770487345025e-414067), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9963387846946716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.3386262932330210983845397491310716880717e-103517), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(4.9987795948982238769531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0775910286001602638027203448544471751962e-01), SC_(4.9224089713998397361972796551455528248038e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0012207031250000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1398089144596828336006862539942141247938e-103553) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0036615133285522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.1550069762792656853592906306744403329852e-414141) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0061023235321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0891196791225350464770608792258791628958e-931765) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0085431337356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2166789558580028050938983811322751018386e-1656428) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0109839439392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.3961943763181184540477749301369594279133e-2588131) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0134247541427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8616311338674178787427683253010164214901e-3726873) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0158655643463134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0026201576490319690757697514123367284191e-5072657) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0183063745498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.9932643467508984249409188646804698456420e-6625486) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0004883046400000000000000000000000000000e+12), SC_(5.0207471847534179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.5967028469589226796911902179426440671477e-8385360) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9731576442718505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4197700797627670753372048391637975180421e-10349514), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9755978584289550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.4828544507319900296422820985542414873589e-8383088), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9780380725860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.1616525867471091105897187507488508338752e-6623662), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9804782867431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2945575272543953326886921077131394734896e-5071233), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9829185009002685546875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.0779150968234446372356985443614481135148e-3725800), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9853587150573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.9374761051774535899539064511365154018626e-2587360), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9877989292144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3475777729589884644383246104225728031936e-1655911), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9902391433715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0272377919425609074494976472401045090485e-931452), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9926793575286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3442356722207204653254149145254414925854e-413982), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9951195716857910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6408288162188557640406668924046761109477e-103499), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(4.9975597858428955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9708894934190583626811756508534824990078e-01), SC_(5.0291105065809416373188243491465175009922e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.5331520403587224859885624093067650025852e-103495) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0024402141571044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.4368472323881482005364095380815004765824e-413973) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0048804283142089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1905225831732726808145155964648401253616e-931438) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0073206424713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.9025653655990668715613633673327019464050e-1655890) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0097608566284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.6552894048263859661531668480234521601475e-2587330) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0122010707855224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.7257911905598430048653741374301274378802e-3725760) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0146412849426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4467089697006822240662236713653018981242e-5071180) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0170814990997314453125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2058518067376370239049442978812777056253e-6623593) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0009765478400000000000000000000000000000e+12), SC_(5.0195217132568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5018100180692705721733670869984661196668e-8383000) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9719443917274475097656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7961770857706236641890027462191788417386e-10346943), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9743840098381042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.6804266190589802044700490692923995756539e-8380999), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9768236279487609863281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.9325706102433201279819377125028030876156e-6622005), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9792632460594177246093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.8458207609877025161510599228284469950120e-5069959), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9817028641700744628906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9382609337893255306415571122724338536592e-3724858), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9841424822807312011718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1625985423282459690392290463614118930516e-2586700), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9865821003913879394531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9231716080185202660601377071659026017426e-1655484), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9890217185020446777343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.7118934024040782841932689437375871686661e-931208), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9914613366127014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6910813970657883691089862741903628004997e-413869), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9939009547233581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6025226304853882628403396920344531698581e-103468), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9963405728340148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0499152027383634259128716677806171891305e-01), SC_(4.9500847972616365740871283322193828108695e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(4.9987801909446716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0279108974961373396558511251120171316496e-103475) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0012201070785522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8310839813111305595715899398724908651140e-413934) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0036597251892089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5914360412256165036081864696551091784988e-931303) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0060993432998657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9037564819640292857171304785571472920882e-1655609) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0085389614105224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9739047563196216717933320776633668712526e-2586852) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0109785795211791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5416165202511873507614209280899898161589e-3725033) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0134181976318359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8672333528746854151219893430579342094885e-5070154) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0158578157424926757812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2413423581706074678647394054861361195474e-6622216) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0014648565760000000000000000000000000000e+12), SC_(5.0182974338531494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4013528114460585858844909144121766616126e-8381222) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9707317352294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.9295782241298330509847314943910901018990e-10344510), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9731707572937011718750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5845998784336643515346801710805789875348e-8379033), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9756097793579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.8701308144526111713575564720996197894721e-6620458), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9780488014221191406250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2569236941488539491676308159122533029632e-5068780), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9804878234863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7401467870396555765972774273562174364806e-3723998), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9829268455505371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.4393124857650409297019720299968081915021e-2586110), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9853658676147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.7205099931954715686796307403677912541160e-1655112), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9878048896789550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1549051408047900904099801396224587061083e-931004), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9902439117431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7163186303220877299645777282074442604776e-413784), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9926829338073730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.1465987493455118886045982737593999305823e-103451), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9951219558715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9457622543258345592460297130576960816822e-01), SC_(5.0542377456741654407539702869423039183178e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(4.9975609779357910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3678641264301737553486837326830767122944e-103442) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3492040281304463875592001684309661683189e-413767) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0024390220642089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1293818396120893026098899694291533682360e-930976) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0048780441284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7484898692887848507702072256987646785634e-1655071) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0073170661926269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2287136889760083545820167909350414766453e-2586052) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0097560882568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.1686403649174443331762451026109043527668e-3723921) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0121951103210449218750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7360815154145613564225487471491385263736e-5068678) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0146341323852539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3378357936375616346981148153566948964903e-6620325) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0019530997760000000000000000000000000000e+12), SC_(5.0170731544494628906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9668285745748538947473980790039136791101e-8378864) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9695193767547607421875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2414388898609103169849843770835839638884e-10342189), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9719578027725219726562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9419115798116428140173408884267385222190e-8377169), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9743962287902832031250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1414399018068863621475516352655742753523e-6619001), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9768346548080444335937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0509150609383629877630080237957100004941e-5067681), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9792730808258056640625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6158421006132452208326606290686167686985e-3723206), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9817115068435668945312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5393859958366151279418436016052740491551e-2585575), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9841499328613281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.1026511228964480515820792707887894198121e-1654785), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9865883588790893554687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9950205705692761288533219401601818516986e-930834), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9890267848968505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3853232466471176495308568286522464693664e-413721), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9914652109146118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0670505698897466877570118167011071228772e-103444), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9939036369323730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6920052279298183172702246844261201383486e-01), SC_(5.3079947720701816827297753155738798616514e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9963420629501342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.2777250720080231158348214086347203430451e-103398) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(4.9987804889678955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1682476851035291830026305590727525574089e-413627) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0012189149856567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9840938234287943133777551344334256360938e-930691) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0036573410034179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9066766401722846685677252865275357409603e-1654589) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0060957670211791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3110636088760982519660835083474785767994e-2585323) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0085341930389404296875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.7162840963862891206932732664368474900817e-3722893) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0109726190567016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9669565559006415373382270462943528094276e-5067300) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0134110450744628906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8245881308111782372408774181607846098340e-6618546) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0024414085120000000000000000000000000000e+12), SC_(5.0158494710922241210937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.6020648127496291479553725476945053041952e-8376633) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9683085083961486816406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5125004136752461482253712757259157170100e-10339246), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9707463383674621582031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.3989692779582102862686638311982585377297e-8374746), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9731841683387756347656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0114841233978798189138653069778423956843e-6617046), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9756219983100891113281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3150191768712877944444230079334053971955e-5066146), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9780598282814025878906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8838774190426867104772484844766688545581e-3722041), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9804976582527160644531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0126521759581812808373740935744395966738e-2584730), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9829354882240295410156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7789271231189278943256854121801912535469e-1654209), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9853733181953430175781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.1284544065565856447280240545444301568234e-930478), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9878111481666564941406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3209962391584142382352444708695879461658e-413534), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9902489781379699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3314399782997509195829638800762383016048e-103376), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9926868081092834472656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2648838511627421850310197742427084605134e-01), SC_(4.7351161488372578149689802257572915394866e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9951246380805969238281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4962038851001386710172742291031701639366e-103416) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(4.9975624680519104003906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7923769632356954918700168501863510458257e-413612) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0000005960464477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0786309542411260453937638388042976530509e-930668) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0024384260177612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6087664098721008159131430488302172942450e-1654457) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0048762559890747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8500843404183119667355927727936257550901e-2585031) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0073140859603881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3200017359771690061454989345392777516802e-3722389) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0097519159317016601562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7108346987844237623083797614973548811851e-5066534) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0121897459030151367187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.9662351321163152737166926174391007186610e-6617467) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0029296517120000000000000000000000000000e+12), SC_(5.0146275758743286132812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1161902523039345467559581981339981444236e-8375188) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9670973420143127441406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.6222977507385062783233045691662773946956e-10336922), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9695345759391784667968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.9355236260640373935025905233164132188389e-8372878), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9719718098640441894531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0481496448293017246838407365370173007944e-6615586), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9744090437889099121093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.1441451314700526689131858667745255175225e-5065044), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9768462777137756347656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7020858276687795572694910035495003633573e-3721247), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9792835116386413574218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9000880853143089651991235069381346836591e-2584193), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9817207455635070800781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.3600805765725235389539744447263725650021e-1653881), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9841579794883728027343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.2358350325038821822169957436417854412605e-930307), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9865952134132385253906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3657306508780218530637420796230612529690e-413470), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9890324473381042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.8269134661832599120721100590980125976761e-103370), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9914696812629699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0163412187100231419416907115563836466701e-01), SC_(4.9836587812899768580583092884436163533299e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9939069151878356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.2517809173391377913191502524942009568624e-103372) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9963441491127014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1475118670686484064124612537149806370623e-413473) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(4.9987813830375671386718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8314542575331509885297097834984626929255e-930308) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0012189149856567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.5255812021099833619683648500349490342371e-1653977) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0036561489105224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8259835771571209241930146106472364640466e-2584303) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0060933828353881835937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.0433446336087783155773322672527699233082e-3721364) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0085306167602539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8888060008638906852112088317569631869577e-5065159) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0109678506851196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.2725137006002519945887960394695843421988e-6615691) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0034179604480000000000000000000000000000e+12), SC_(5.0134050846099853515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.3851646860602906509238550911140073649228e-8372961) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9658867716789245605468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7867222591053257888612057668036354303955e-10334594), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9683234095573425292968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0431921517922456485941821949951410723975e-8371008), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9707600474357604980468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1891224913828068198352743520450650463357e-6614124), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9731966853141784667968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.8758597383480362581739136640501613953986e-5063940), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9756333231925964355468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9192580752676997654788204504857506830615e-3720451), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9780699610710144042968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1118194236075070536864231784248648997767e-2583655), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9805065989494323730468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0424345567863897431572483015815248863018e-1653551), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9829432368278503417968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4894619145531764522715775481522746728307e-930135), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9853798747062683105468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7938073403463525941665366814143728111745e-413406), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9878165125846862792968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9583803573998515397162369163560199516216e-103363), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9902531504631042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7710331283843978161028802472867184774677e-01), SC_(5.2289668716156021838971197527132815225323e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9926897883415222167968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7945696560951735487524234616674211191482e-103328) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9951264262199401855468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4683445987033460662486237976661511068631e-413335) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9975630640983581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9275454759793729062608697117451773357665e-930025) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(4.9999997019767761230468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.9780252061429659278987530113416564023663e-1653397) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(5.0024366378784179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6437618021249933880386989865887438928972e-2583577) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(5.0048732757568359375000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3819204050136065970791476890425166087559e-3720340) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(5.0073099136352539062500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5183176931871673052395582038911107757588e-5063786) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(5.0097465515136718750000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4419789661465672287884572593465690265682e-6613917) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0039062691840000000000000000000000000000e+12), SC_(5.0121831893920898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.1658261917896470638144458484930493947797e-8370735) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9646773934364318847656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2005895235551993524231593863492532534057e-10331896), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9671134352684020996093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.7540279668469555340928353425389422263886e-8368805), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9695494771003723144531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.9603340150794167943563639024727860212451e-6612366), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9719855189323425292968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4326088547098501384352533558397623446040e-5062576), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9744215607643127441406250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2643838703228044769143918244580538153983e-3719433), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9768576025962829589843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.2530371427059903585226366053351553597777e-2582933), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9792936444282531738281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5008110877861093191596602437198016640762e-1653073), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9817296862602233886718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7153119362190148671148465424888592395462e-929852), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9841657280921936035156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5773249135149299615026894058345513979777e-413268), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9866017699241638183593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.1782868201144635582012142284193607593764e-103319), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9890378117561340332031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0183076793627504176986533194210479813460e-01), SC_(4.9816923206372495823013466805789520186540e-01) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9914738535881042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4649855998923992756995464783955959432212e-103321) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9939098954200744628906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8476309404340417761001826854966119123257e-413271) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9963459372520446777343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.5495368955034621909296949398293919676459e-929853) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(4.9987819790840148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7186010365056401705987261269555418385849e-1653065) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(5.0012183189392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0606134756672410041697549739170958799719e-2583036) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(5.0036543607711791992187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3065929549816152223362068108064255375069e-3719537) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(5.0060904026031494140625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.9113821944394617708566587772260327483127e-5062672) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(5.0085264444351196289062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.3480802673438024901277612367606007375753e-6612440) }, 
      { SC_(9.9999999590400000000000000000000000000000e+11), SC_(1.0043945123840000000000000000000000000000e+12), SC_(5.0109624862670898437500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.2388025924030535947866632965838369281888e-8368843) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3918001850417339086869395921840499607598e-259496502), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0024473667144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2611936879629533723023396458430489742256e-166078829), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0048947334289550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.8675057111757405518908088716369255037700e-93420333), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0073421001434326171875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3845669839724284640002716163365467039472e-41521008), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0097894668579101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.8942063004271778211050635640974994745169e-10380881), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0122368335723876953125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4171382607281511527520147303194788007433e-01), SC_(6.5828617392718488472479852696805211992567e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0146842002868652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.5570557666182174399829161518002863087593e-10378465) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0171315670013427734375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.1865026941544035442332319466326224034304e-41516376) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0195789337158203125000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.3384370511976168049550863165191560699205e-93413881) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0220263004302978515625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.1425571746182153612619687133302398599898e-166071156) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9511716282368000000000000000000000000000e+13), SC_(5.0244736671447753906250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.0605148167318850470616353220567881654001e-259488402) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(4.9987763166427612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0232335781665302664959424392480804306829e-259443222), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0012230873107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5497132125959886308211253320117622051752e-166046257), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0036698579788208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.2167079961045537982742175156337991881208e-93403453), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0061166286468505859375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0066239416308191425248421338278226277608e-41514794), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0085633993148803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.0681829015351107931037658676574380402088e-10380297), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0110101699829101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4578604329012597900821621523913669865167e-01), SC_(8.5421395670987402099178378476086330134833e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0134569406509399414062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.8762313258050970160666979935099576981219e-10373994) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0159037113189697265625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3389853555086997563109565073002135138382e-41502367) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0183504819869995117187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5006692915248982082737729073739365894277e-93385259) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0207972526550292968750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7168959676260756049550414572351114657514e-166022834) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9560546369536000000000000000000000000000e+13), SC_(5.0232440233230590820312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.8860190275790488111279897928819715843359e-259415286) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(4.9975538253784179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.2004243659895281951347618892822667012586e-259364833), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6674096235584924866374211734244272529420e-165993597), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0024461746215820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4437909458870906937294871509861792891340e-93371506), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0048923492431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9031628512246744515003364567455599731212e-41498536), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0073385238647460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3354455733051348483727989105577304641786e-10374690), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0097846984863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.8851879025982908889191113845165600403956e-01), SC_(5.1148120974017091110808886154834399596044e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0122308731079101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.8733393083791257643919333293636337674170e-10374544) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0146770477294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0637928883418154662796708880022167075612e-41498402) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0171232223510742187500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6425151898583447040521906776791999909692e-93371703) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0195693969726562500000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8912707985854812252347057146997895448427e-165994601) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9609376456704000000000000000000000000000e+13), SC_(5.0220155715942382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.5987164818070225288254037546204932740113e-259367280) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(4.9963319301605224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5820484846000280369422031750356856509186e-259286594), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(4.9987775087356567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1981206351480712878926033532535982494311e-165941058), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0012230873107910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2220565013033415720671161119849095021097e-93339651), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0036686658859252929687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8553597857930568062374414869965083436199e-41482338), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0061142444610595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6493742994782887957919932242357318822889e-10369114), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0085598230361938476562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.3825669244673297536574859084945534136120e-01), SC_(1.6174330755326702463425140915054465863880e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0110054016113281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4457880912952023893906613215531837348250e-10375064) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0134509801864624023437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3831683481512384525593178692141150983043e-41494377) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0158965587615966796875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0127985341733323319156326772647031246592e-93358057) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0183421373367309570312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9257714610838742178601891090518874260099e-165966248) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9658206543872000000000000000000000000000e+13), SC_(5.0207877159118652343750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.0900185424197866298075880813224693865715e-259319124) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(4.9951106309890747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1083286935360064468373803048381993724348e-259217397), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(4.9975556135177612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4557315845223260056037400144086042856068e-165895754), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0000005960464477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6230904319334397777835159432567815554889e-93313223), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0024455785751342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.8303714274536891678381559835077224043580e-41469760), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0048905611038208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.5407695720942377332160052213436639884370e-10365349), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0073355436325073242187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.1930232942506670958463937880160832400641e-01), SC_(8.0697670574933290415360621198391675993592e-02) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0097805261611938476562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.6717560737119860359967497511568717086324e-10373774) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0122255086898803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.3996668669013341161467860180249618730709e-41486730) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0146704912185668945312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.8753272777392387809928054869718808914704e-93338976) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0171154737472534179687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5102096961411672533591252109286977004580e-165930646) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9707028242432000000000000000000000000000e+13), SC_(5.0195604562759399414062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0610382112352344079816948998212689920471e-259261905) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(4.9938893318176269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7308833179700971030745450136572579270157e-259164679), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(4.9963337182998657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7056969367747557211853795947670056892943e-165863631), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(4.9987781047821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9464984352505307683177342291515907092681e-93296680), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0012224912643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.7883726044230796466200973407845119686050e-41463770), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0036668777465820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7866514283251900833339467979590794181264e-10364876), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0061112642288208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.6300324718247473615707817767323811886710e-01), SC_(2.3699675281752526384292182232676188113290e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0085556507110595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.3199312877037665564748603861510420267348e-10369190) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0110000371932983398437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0366868888299029148610677739469214061147e-41472496) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0134444236755371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8757099674757476606937848583487359233818e-93310017) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0158888101577758789062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9703554418771157675508256904227468097150e-165881877) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9755858329600000000000000000000000000000e+13), SC_(5.0183331966400146484375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7911271151764010864868402764206246925132e-259188229) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(4.9926686286926269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0375658564731454248582213258749533995757e-259112055), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(4.9951124191284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6464018032365858321044541078192869845301e-165831584), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(4.9975562095642089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.5983537532334167780066791254935906873291e-93280193), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6514776810325174944765405166150159859614e-41457818), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0024437904357910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.2125008219832944602151178752274274348686e-10364423), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0048875808715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1001640437351843756039624607981432889912e-01), SC_(4.8998359562648156243960375392018567110088e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0073313713073730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.8765704205434348162677500678088655542650e-10364587) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0097751617431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.6338946625098055682978649777350776047831e-41458225) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0122189521789550781250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.2332230623910495797178098976503584164659e-93281002) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0146627426147460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.3629900617779021683893792304675621112172e-165833032) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9804688416768000000000000000000000000000e+13), SC_(5.0171065330505371093750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8918745049007380399869953084826305594474e-259114459) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(4.9914485216140747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8518349570409875505283432375060697329875e-259059508), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(4.9938917160034179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0459239687787838926814600346234656396181e-165799598), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(4.9963349103927612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6633513916001351512235416917239672214554e-93263753), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(4.9987781047821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0706379408346241898746503496733896538715e-41451897), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0012212991714477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.4237588862615517428273960336868545786972e-10363986), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0036644935607910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5110140518564609366752614600109903420897e-01), SC_(7.4889859481435390633247385399890096579103e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0061076879501342773437500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0493936621017712289015746445957126269472e-10359969) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0085508823394775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2189461213779162300614267784720695868722e-41443923) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0109940767288208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5582378636711514136200325056799159216869e-93251941) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0134372711181640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.4410957357081622740370655783765431352660e-165784127) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9853518503936000000000000000000000000000e+13), SC_(5.0158804655075073242187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.7082575525605879599629495890129562043226e-259040614) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(4.9902296066284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9257311164292383780986798453505970852606e-258990631), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(4.9926722049713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.8001521346077458083636917089696825705223e-165754551), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(4.9951148033142089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3916573478769565418167666560213472203122e-93237517), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(4.9975574016571044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7152971345284564335214531246156646046357e-41439446), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.3917507622424861110614679179073363693857e-10360284), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0024425983428955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.9000094030298946599131837104703209773249e-01), SC_(6.0999905969701053400868162895296790226751e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0048851966857910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1314155074235878086773497852794080472434e-10358614) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0073277950286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.6660103874334608783434427215341651363769e-41436148) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0097703933715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4967219413418951268051073908086891396066e-93232668) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0122129917144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.0733388795777994305892562122690537140441e-165748270) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9902340202496000000000000000000000000000e+13), SC_(5.0146555900573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6453586179803480931111994565475876221163e-258983076) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(4.9890112876892089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9591394173357820354449978112370323620492e-258912896), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(4.9914532899856567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4212832540492949066732243370053572446654e-165702415), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(4.9938952922821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0474651387494384019514409569431323988288e-93205964), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(4.9963372945785522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2569091282453466604664864837241082806898e-41423450), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(4.9987792968750000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.4105619568900242088646542547349965112987e-10354809), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0012212991714477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.5923510521779341109996182920839005999730e-01), SC_(2.4076489478220658890003817079160994000270e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0036633014678955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3556389841365570867842287215315485196291e-10359034) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0061053037643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3929272755029613311446891686356231075701e-41431921) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0085473060607910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.4962050104457394976098153560038680065602e-93218720) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0109893083572387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.2019153636322321251855518506629849611131e-165719514) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(9.9951170289664000000000000000000000000000e+13), SC_(5.0134313106536865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.5790302539704137288662419060861157181090e-258934419) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(4.9877929687500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.5391645230096672560353923446716747115373e-258860461), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(4.9902343750000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.9253140987627989144026689063498721890031e-165670519), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(4.9926757812500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.8514584854974771113216573336358447326718e-93189592), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(4.9951171875000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7392911073056735177486236794492177177332e-41417574), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(4.9975585937500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4443244145184387324343038411521055226062e-10354393), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0024414062500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.4443244145184387324343038411521055226062e-10354393) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0048828125000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7392911073056735177486236794492177177332e-41417574) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0073242187500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.8514584854974771113216573336358447326718e-93189592) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0097656250000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9253140987627989144026689063498721890031e-165670519) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0000000037683200000000000000000000000000e+14), SC_(5.0122070312500000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.5391645230096672560353923446716747115373e-258860461) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9865752458572387695312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5019091979170048814730460193616106426472e-258808028), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9890160560607910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.0269666844289784361892322047305443725990e-165638625), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9914568662643432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8690378474364482117179656352844568811929e-93173220), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9938976764678955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.3341766545531751642382335907039952863234e-41411699), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9963384866714477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.9430797636391368464763609201744739319950e-10353979), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(4.9987792968750000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.4066915630248342138031229517367620258234e-01), SC_(7.5933084369751657861968770482632379741766e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(5.0012201070785522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.5839865657610703750567329610418319410814e-10349753) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(5.0036609172821044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3488590633559408402446827398671186780989e-41403227) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(5.0061017274856567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5044943758364401799019144927212810840035e-93160462) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(5.0085425376892089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.3673376238828936593286981874626744232515e-165621523) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0004883046400000000000000000000000000000e+14), SC_(5.0109833478927612304687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6330482896161784529477014961122817492412e-258786502) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9853587150573730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4293890254847643325719702869862430560001e-258730298), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9877989292144775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.6435640974708486672748463750166767780698e-165586494), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9902391433715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.9428540272897186777360512660995452922864e-93141671), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9926793575286865234375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0783045170270712640156946068802086216343e-41395705), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9951195716857910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.5212858415984718951041170650254342298960e-10348505), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(4.9975597858428955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0984279555203361154239845415142719582363e-01), SC_(3.9015720444796638845760154584857280417637e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1293987180713982078812347401362408595665e-10350171) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(5.0024402141571044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.9557682942976223025701092201680689856850e-41398998) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(5.0048804283142089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1117305637551324014993022533636950195189e-93146510) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(5.0073206424713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9811119239255762584999744319526674474298e-165592763) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0009766055116800000000000000000000000000e+14), SC_(5.0097608566284179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3185525684330646014221543532970816741188e-258737839) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9841424822807312011718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.2330502929668060924905799817589955775687e-258674044), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9865821003913879394531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6767049187909820072563319162828369978133e-165551544), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9890217185020446777343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0135728483873169973300623395338425948086e-93123009), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9914613366127014160156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.4109912165023540287027195256711540961323e-41388305), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9939009547233581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.3587328908395017478621084069821038608484e-10347328), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9963405728340148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.3202701356768019672406417914405566442066e-01), SC_(5.6797298643231980327593582085594433557934e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(4.9987801909446716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.9045476034026896414176216258803843741524e-10346291) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(5.0012201070785522460937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.4604838325707910382191365024470755257523e-41391229) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(5.0036597251892089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.7959343735349889669917857266969541428074e-93127247) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(5.0060993432998657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8141857585315883405707547506833523127959e-165556919) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0014648224972800000000000000000000000000e+14), SC_(5.0085389614105224609375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.0752385609808287373034597962579998398441e-258680319) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9829271435737609863281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.0344643197903099800299511587475290094792e-258596221), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9853661656379699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.5754479037729862320123721261678665007629e-165499339), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9878051877021789550781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0312840905235784928410365926796140551407e-93091404), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9902442097663879394531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8372631053184877952422424261642961109427e-41372274), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9926832318305969238281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.4708922609339056137007461493205266626893e-10341835), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9951222538948059082031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.9341788315078504091553610150690126684472e-01), SC_(2.0658211684921495908446389849309873315528e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(4.9975612759590148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.4016435856654290169705458518005951129166e-10346728) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(5.0000005960464477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.9308822745600452355809372024220392515386e-41387037) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(5.0024396181106567382812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.1338008626623400799421852912367063848544e-93113351) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(5.0048786401748657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6704684174079686839683685944913257464509e-165528234) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0019531233689600000000000000000000000000e+14), SC_(5.0073176622390747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.7843757234327189618725326977545236516033e-258631750) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9817118048667907714843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.6698808217670039714081728487889623338472e-258543605), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9841502308845520019531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.3787383430706891160567212997725872031541e-165467298), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9865886569023132324218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.2943746333621873807045248148123001758279e-93074923), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9890270829200744628906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5034215310700208166961804293586201165895e-41366326), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9914655089378356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8950991779806901534067469603806771136080e-10341384), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9939039349555969238281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.5014472111980515433179539575861763731426e-01), SC_(4.4985527888019484566820460424138236268574e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9963423609733581542968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.7346670615432397795245778392451116436346e-10342123) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(4.9987807869911193847656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.1377874456359797417530025567111426234416e-41367706) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(5.0012195110321044921875000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.4834913521841967932029797255943916251894e-93084331) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(5.0036579370498657226562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.9238057077239976800348554035198040212469e-165479383) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0024414242406400000000000000000000000000e+14), SC_(5.0060963630676269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.8765218962762883742088798822636645223571e-258557972) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9804970622062683105468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.0450202278538944488587266800378068917025e-258490898), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9829348921775817871093750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.7916537024090980032864192593207041010643e-165435186), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9853727221488952636718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.5903120421507118196591392774698104144101e-93058388), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9878105521202087402343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.0157074797959732855706762878475016071022e-41360342), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9902483820915222167968750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8043208015384831482847837240225875719141e-10340915), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9926862120628356933593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.8759477279860825174022935665009295117667e-01), SC_(7.1240522720139174825977064334990704882333e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9951240420341491699218750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.7904916352004504280044166598813026434391e-10337537) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9975618720054626464843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.1102661891834989352058535261022095288310e-41353467) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(4.9999997019767761230468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.6444705688240676238013846517776600184160e-93047780) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(5.0024378299713134765625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5283240510254704908209847226452082056911e-165430603) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0029297251123200000000000000000000000000e+14), SC_(5.0048756599426269531250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.9768910981325043987644918985817508137868e-258484285) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9792832136154174804687500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2297251645243184376884195651794902123782e-258434295), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9817204475402832031250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.5139447441524841397913962726859050047438e-165399959), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9841576814651489257812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6150646678217731416455309370945830279467e-93039518), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9865949153900146484375000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(7.5708692892386722131804016610022279235703e-41352803), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9890321493148803710937500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.9787398893170681557668231194179627478401e-10339669), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9914693832397460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6163113459889190472669500219113027288468e-01), SC_(8.3836886540110809527330499780886972711532e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9939066171646118164062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.2881857090599549089147547686584814225121e-10333727) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9963438510894775390625000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.0627200426524550940545595046594738296857e-41340780) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(4.9987810850143432617187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.3509696753786958405266021902589162750407e-93021141) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(5.0012183189392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.5078255837038137689475940663287071289193e-165374813) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0034179420979200000000000000000000000000e+14), SC_(5.0036555528640747070312500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(1.8212224604535383201288392494231686774204e-258401832) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9780702590942382812500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.2277916046526848589257210069625153816521e-258356067), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9805068969726562500000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6138314583696844279148036586921063021575e-165347429), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9829435348510742187500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.4441765424778658468728418419985136266390e-93007671), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9853801727294921875000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.1271977632325894163453517969890789221677e-41336610), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9878168106079101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.5789829030089052078977857926701968081320e-10334096), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9902534484863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.1157780466952356200887525724540019839355e-01), SC_(4.8842219533047643799112474275459980160645e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9926900863647460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(8.2883230961082760351592501570346202649363e-10334244) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9951267242431640625000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(4.3611502534090535546563077098252952868536e-41336749) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(4.9975633621215820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(5.1355844226308992624940176739542206175167e-93007486) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.2477409071597137051039735360859050453589e-165346450) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0039062429696000000000000000000000000000e+14), SC_(5.0024366378784179687500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(6.9252326088690822650033331154830002913579e-258353665) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9768576025962829589843750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7420969302826574713955840763577034327905e-258290333), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9792936444282531738281250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.8089573797585522339794433054268557547035e-165304895), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9817296862602233886718750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.4844001186429444441712795142062485277132e-92983320), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9841657280921936035156250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.6031221321949666859247787097293139589356e-41325416), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9866017699241638183593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.5517303228444158070456005707961317638630e-10331022), SC_(1.0000000000000000000000000000000000000000e+00) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9890378117561340332031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.8391785318011288791248765287286587015835e-01), SC_(4.1608214681988711208751234712713412984165e-01) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9914738535881042480468750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.3725767201098864079571539530740542062052e-10332262) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9939098954200744628906250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(2.6001277949704053752299775322548093477099e-41327720) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9963459372520446777343750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(9.6164880848840494899838859221616849909564e-92986335) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(4.9987819790840148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(7.4554211172668703603525631711915958803507e-165308091) }, 
      { SC_(1.0000000037683200000000000000000000000000e+14), SC_(1.0043945438412800000000000000000000000000e+14), SC_(5.0012183189392089843750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.0000000000000000000000000000000000000000e+00), SC_(3.4690874676360331196400484194307104811619e-258305643) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9511718631178240000000000000000000000000e+15), SC_(5.0122374296188354492187500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9999999999999999999999999999999999987697e-01), SC_(1.2302666016759449711870058233366459796960e-37) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9560552409333760000000000000000000000000e+15), SC_(5.0110107660293579101562500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9999999999999999976545013709598875539400e-01), SC_(2.3454986290401124460599880352760930729250e-19) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9609375450071040000000000000000000000000e+15), SC_(5.0097846984863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.8959855840518829749287394504376827139667e-03), SC_(9.9610401441594811702507126054956231728603e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9658209228226560000000000000000000000000e+15), SC_(5.0085592269897460937500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.6240646674919539980057378625395107043165e-12), SC_(9.9999999999137593533250804600199426213746e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9707032268963840000000000000000000000000e+15), SC_(5.0073349475860595703125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.9610010629173848313406615746215446904931e-02), SC_(9.5038998937082615168659338425378455309507e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9755866047119360000000000000000000000000e+15), SC_(5.0061106681823730468750000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.0363068846773661692843822127551858585241e-09), SC_(9.9999999796369311532263383071561778724481e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9804689087856640000000000000000000000000e+15), SC_(5.0048875808715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.7522423632716591948192694598633130149782e-01), SC_(8.2477576367283408051807305401366869850218e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9853522866012160000000000000000000000000e+15), SC_(5.0036644935607910156250000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(6.3652791991551795147216462542835659809785e-08), SC_(9.9999993634720800844820485278353745716434e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9902345906749440000000000000000000000000e+15), SC_(5.0024425983428955078125000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(3.3828547471369519837468982173176403958851e-01), SC_(6.6171452528630480162531017826823596041149e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(9.9951179684904960000000000000000000000000e+15), SC_(5.0012212991714477539062500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9999999999999999999999999999999866555398e-01), SC_(1.3344460183197995360536892964659708589971e-33) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0000000272564224000000000000000000000000e+16), SC_(5.0000000000000000000000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.0000000000000000000000000000000000000000e-01), SC_(5.0000000000000000000000000000000000000000e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0004882576637952000000000000000000000000e+16), SC_(4.9987795948982238769531250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(1.6364494216375254857808433208671045206023e-04), SC_(9.9983635505783624745142191566791328954794e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0009765954453504000000000000000000000000e+16), SC_(4.9975594878196716308593750000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(5.5124021708439874198863467060757438977578e-16), SC_(9.9999999999999944875978291560125801136533e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0014648258527232000000000000000000000000e+16), SC_(4.9963405728340148925781250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.5453527341249121800789383994577476189109e-04), SC_(9.9914546472658750878199210616005422523811e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0019531636342784000000000000000000000000e+16), SC_(4.9951219558715820312500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(8.2413660614659781256881921247356587954404e-01), SC_(1.7586339385340218743118078752643412045596e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0024413940416512000000000000000000000000e+16), SC_(4.9939042329788208007812500000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9999999819816685089564579570950050641769e-01), SC_(1.8018331491043542042904994935823064033111e-09) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0029297318232064000000000000000000000000e+16), SC_(4.9926868081092834472656250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9999999999999999999999655346226949501499e-01), SC_(3.4465377305049850103766836582355539425439e-24) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0034179622305792000000000000000000000000e+16), SC_(4.9914696812629699707031250000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(4.6139019895710894972876657976032041346712e-02), SC_(9.5386098010428910502712334202396795865329e-01) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0039063000121344000000000000000000000000e+16), SC_(4.9902534484863281250000000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(9.9596958743115699762055064903293314550541e-01), SC_(4.0304125688430023794493509670668544945940e-03) }, 
      { SC_(1.0000000272564224000000000000000000000000e+16), SC_(1.0043945304195072000000000000000000000000e+16), SC_(4.9890375137329101562500000000000000000000e-01), SC_(0.0000000000000000000000000000000000000000e+00), SC_(0.0000000000000000000000000000000000000000e+00), SC_(2.1688105044138971856553460331015977667304e-19), SC_(9.9999999999999999978311894955861028143447e-01) }
   }};
//#undef SC_
