.TH libinput-replay "1"
.SH NAME
libinput\-replay \- replay kernel events from a recording
.SH SYNOPSIS
.B libinput replay [options] \fIrecording\fB
.SH DESCRIPTION
.PP
The \fBlibinput replay\fR tool replays kernel events from a device recording
made by the \fBlibinput record(1)\fR tool. This tool needs to run as root to
create a device and/or replay events.
.PP
If the recording contains more than one device, all devices are replayed
simultaneously.
.SH OPTIONS
.TP 8
.B \-\-help
Print help
.TP 8
.B \-\-once
Only replay the recording once, then exit.
.TP 8
.B \-\-replay-after=s
Replay the recording after waiting for s seconds. This replaces the default
interactive prompt to start the replay.
.SH NOTES
.PP
This tool replays events from a recording through the the kernel and is
independent of libinput. In other words, updating or otherwise changing
libinput will not alter the output from this tool. libinput itself does not
need to be in use to replay events.
.PP
This tool does not replay kernel-emulated key repeat events (events of type
\fIEV_KEY\fR with a value of 2).
.SH LIBINPUT
.PP
Part of the
.B libinput(1)
suite
