/* Copyright (C) 2020-2023 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied,
   modified or distributed except as expressly authorized under the terms
   of the license contained in the file LICENSE in this distribution.

   Refer to licensing information at http://www.artifex.com or contact
   Artifex Software, Inc.,  39 Mesa Street, Suite 108A, San Francisco,
   CA 94129, USA, for further information.
*/

/* Pixel stretching function for image mask interpolation filter */

#include "simscale_foo.h"

#define a 5 /* top row */
#define b 6
#define c 7
#define d 8
#define e 9

#define f 10 /* edge */
#define g 14

#define h 15 /* edge */
#define i 19

#define j 20 /* edge */
#define k 24

#define l 25 /* bottom row */
#define m 26
#define n 27
#define o 28
#define p 29

#define V0 0x0
#define V1 0x8
#define V2 0x1
#define V3 0x9
#define V4 0x80e
#define V5 0x107
#define V6 0x8080c
#define V7 0xc0e0e
#define V8 0x60600
#define V9 0x6060f
#define V10 0x60e0c
#define V11 0x60e0f
#define V12 0x60703
#define V13 0x6070f
#define V14 0x60f0f
#define V15 0x10103
#define V16 0x30707
#define V17 0x8000000
#define V18 0x8000008
#define V19 0x8000001
#define V20 0x80e0e08
#define V21 0x80e0e0c
#define V22 0x80e0e0f
#define V23 0x80e0f0f
#define V24 0xc080800
#define V25 0xc0e0600
#define V26 0xc0e0e08
#define V27 0xc0e0e0c
#define V28 0xc0e0e0f
#define V29 0xc0e0f0f
#define V30 0xe080000
#define V31 0xe0e0c00
#define V32 0x1000000
#define V33 0x1000008
#define V34 0x1000001
#define V35 0x1070701
#define V36 0x1070703
#define V37 0x107070f
#define V38 0x1070f0f
#define V39 0x9000000
#define V40 0x3010100
#define V41 0x3070600
#define V42 0x3070701
#define V43 0x3070703
#define V44 0x307070f
#define V45 0x3070f0f
#define V46 0x7010000
#define V47 0x7070300
#define V48 0xf060600
#define V49 0xf0e0600
#define V50 0xf0e0e08
#define V51 0xf0e0e0c
#define V52 0xf070600
#define V53 0xf070701
#define V54 0xf070703
#define V55 0xf0f0600
#define V56 0xf0f0e08
#define V57 0xf0f0e0c
#define V58 0xf0f0701
#define V59 0xf0f0703
#define V60 0xf0f0f0f

#define T(t0) ((x & (1ULL<<(t0+32))) == 0)
#define TT(t0,t1) ((x & (1ULL<<(t0+32) | 1ULL<<(t1+32))) == 0)
#define F(f0)           ((x & (1ULL<<f0)) == 0)
#define TF(t0, f0)      ((x & (1ULL<<(t0+32) | 1ULL<<f0)) == 0)
#define TTF(t0, t1, f0)  ((x & (1ULL<<(t0+32) | 1ULL<<(t1+32) | 1ULL<<f0)) == 0)
#define TFF(t0, f0, f1) ((x & (1ULL<<(t0+32) | 1ULL<<f0 | 1ULL<<f1)) == 0)
#define TTFF(t0, t1, f0, f1)           ((x & (1ULL<<(t0+32) | 1ULL<<(t1+32) | 1ULL<<f0 | 1ULL<<f1)) == 0)
#define ANYTTFF(t0, t1, f0, f1) (x & ((1ULL<<t0) | (1ULL<<t1) | (1ULL<<(f0+32)) | (1ULL<<(f1+32))))

/* Find the value of a 4x4 pixel cluster in a given 5x5 context.*/
/* Checked by electronics against the full 5x5 table. */
unsigned int imscale_foo(unsigned int v5x5) {
    int v3x3 = ((v5x5 >> 11) & 07) | ((v5x5 >> 13) & 070) | ((v5x5 >> 15) & 0700);
    unsigned long long x = ~(unsigned long long)v5x5 << 32 | v5x5;

#if 0
    /* Extracted lines of the 5x5 matrix for convenient viewing. */
    unsigned int r0 = ( v5x5 >> 5 ) & 0x1f;
    unsigned int r1 = ( v5x5 >> 10 ) & 0x1f;
    unsigned int r2 = ( v5x5 >> 15 ) & 0x1f;
    unsigned int r3 = ( v5x5 >> 20 ) & 0x1f;
    unsigned int r4 = ( v5x5 >> 25 ) & 0x1f;
#endif

    switch(v3x3) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
        return V0;
    case 11:
        return V2;
    case 12:
    case 13:
    case 14:
        return V0;
    case 15:
    /* abcdefghijklmnop */
    /* ------1-1------- V2 */
    /* --------0------- V5 */
    /* ------0--------- V5 */
        if (TT(g,i))
        	return V2;
        else
        	return V5;
    case 16:
        return V60;
    case 17:
    /* abcdefghijklmnop */
    /* 10---0---------- V25 */
    /* 11---0---------- V27 */
    /* 10---1---------- V55 */
    /* 0--------------- V57 */
    /* -1---1---------- V57 */
    	if (TF(a,f)) {
    		if (T(b))
    			return V27;
    		else
    			return V25;
    	} else {
    		if (TTF(a,f,b))
    			return V55;
    		else
    			return V57;
    	}
    case 18:
    /* abcdefghijklmnop */
    /* 0111000--------- V9 */
    /* 0110-0---------- V28 */
    /* 011-10---------- V28 */
    /* 011--01--------- V28 */
    /* -0110-0--------- V44 */
    /* 1-110-0--------- V44 */
    /* --11010--------- V44 */
    /* --0------------- V60 */
    /* -0-0------------ V60 */
    /* 1--0------------ V60 */
    /* -0--1----------- V60 */
    /* 1---1----------- V60 */
    /* ---0-1---------- V60 */
    /* ----11---------- V60 */
    /* -0----1--------- V60 */
    /* 1-----1--------- V60 */
    /* -----11--------- V60 */
    	if (TTFF(b,c,a,f)) {
    		if (TFF(d,e,g))
    			return V9;
    		else
    			return V28;
    	} else {
    		if (TTFF(c,d,e,g))
    			return V44;
    		else
    			return V60;
    	}
    case 19:
    /* abcdefghijklmnop */
    /* 1-11000--------- V13 */
    /* 0-110-0--------- V44 */
    /* --11010--------- V44 */
    /* 1--0-0---------- V29 */
    /* 1-0--0---------- V29 */
    /* 1---10---------- V29 */
    /* 1----01--------- V29 */
    /* 0--0------------ V60 */
    /* 0-0------------- V60 */
    /* 0---1----------- V60 */
    /* ---0-1---------- V60 */
    /* --0--1---------- V60 */
    /* ----11---------- V60 */
    /* 0-----1--------- V60 */
    /* -----11--------- V60 */
        if (TTFF(c,d,e,g)) {
            if (TF(a,f))
                return V13;
            else
                return V44;
        } else {
            if (TF(a,f))
                return V29;
            else
                return V60;
        }
    case 20:
    /* abcdefghijklmnop */
    /* ---01-0--------- V41 */
    /* ---11-0--------- V43 */
    /* ---01-1--------- V55 */
    /* ----0----------- V59 */
    /* ---1--1--------- V59 */
        if (TF(e,g)) {
        	if (T(d))
        		return V43;
        	else
        		return V41;
        } else {
        	if (TTF(e,g,d))
        		return V55;
        	else
        		return V59;
        }
    case 21:
    /* abcdefghijklmnop */
    /* 1---100--------- V8 */
    /* 1---00---------- V25 */
    /* 1----01--------- V25 */
    /* 0---1-0--------- V41 */
    /* ----110--------- V41 */
    /* 0---0----------- V55 */
    /* ----01---------- V55 */
    /* 0-----1--------- V55 */
    /* -----11--------- V55 */
        if (TF(a,f)) {
            if (TF(e,g))
                return V8;
            else
                return V25;
        } else {
            if (TF(e,g))
                return V41;
            else
                return V55;
        }
    case 22:
    /* abcdefghijklmnop */
    /* 011-100--------- V11 */
    /* 011-00---------- V28 */
    /* 011--01--------- V28 */
    /* --0-1-0--------- V45 */
    /* -0--1-0--------- V45 */
    /* 1---1-0--------- V45 */
    /* ----110--------- V45 */
    /* --0-0----------- V60 */
    /* -0--0----------- V60 */
    /* 1---0----------- V60 */
    /* ----01---------- V60 */
    /* --0---1--------- V60 */
    /* -0----1--------- V60 */
    /* 1-----1--------- V60 */
    /* -----11--------- V60 */
        if (TTFF(b,c,a,f)) {
            if (TF(e,g))
                return V11;
            else
                return V28;
        } else {
            if (TF(e,g))
                return V45;
            else
                return V60;
        }
    case 23:
    /* abcdefghijklmnop */
    /* 1---100--------- V14 */
    /* 1---00---------- V29 */
    /* 1----01--------- V29 */
    /* 0---1-0--------- V45 */
    /* ----110--------- V45 */
    /* 0---0----------- V60 */
    /* ----01---------- V60 */
    /* 0-----1--------- V60 */
    /* -----11--------- V60 */
        if (TF(a,f)) {
        	if (TF(e,g))
        		return V14;
        	else
        		return V29;
        } else {
        	if (TF(e,g))
        		return V45;
        	else
        		return V60;
        }
    case 24:
    /* abcdefghijklmnop */
    /* 00---1-1-1-00--- V35 */
    /* -----0-1-1-00--- V38 */
    /* 1------1-1-00--- V38 */
    /* -1-----1-1-00--- V38 */
    /* 00---1-1-0------ V58 */
    /* 00---1-1---1---- V58 */
    /* 00---1-1----1--- V58 */
    /* -------0-------- V60 */
    /* -----0---0------ V60 */
    /* 1--------0------ V60 */
    /* -1-------0------ V60 */
    /* -----0-----1---- V60 */
    /* 1----------1---- V60 */
    /* -1---------1---- V60 */
    /* -----0------1--- V60 */
    /* 1-----------1--- V60 */
    /* -1----------1--- V60 */
    	if (TTFF(h,j,l,m)) {
    		if (TFF(f,a,b))
    			return V35;
    		else
    			return V38;
    	} else {
    		if (TTFF(f,h,a,b))
    			return V58;
    		else
    			return V60;
    	}
    case 25:
    /* abcdefghijklmnop */
    /* 10-----1-1-00--- V36 */
    /* 0------1-1-00--- V38 */
    /* -1-----1-1-00--- V38 */
    /* 10-------0------ V59 */
    /* 10-----0-------- V59 */
    /* 10---------1---- V59 */
    /* 10----------1--- V59 */
    /* 0--------0------ V60 */
    /* -1-----0-------- V60 */
    /* -1-------0------ V60 */
    /* 0------0-------- V60 */
    /* 0----------1---- V60 */
    /* -1---------1---- V60 */
    /* 0-----------1--- V60 */
    /* -1----------1--- V60 */
    	if (TTFF(h,j,l,m)) {
    		if (TF(a,b))
    			return V36;
    		else
    			return V38;
    	} else {
    		if (TF(a,b))
    			return V59;
    		else
    			return V60;
    	}
    case 26:
    /* abcdefghijklmnop */
    /* --110-01-1-00--- V37 */
    /* ---0---1-1-00--- V38 */
    /* --0----1-1-00--- V38 */
    /* ----1--1-1-00--- V38 */
    /* ------11-1-00--- V38 */
    /* --110-0--0------ V44 */
    /* --110-00-------- V44 */
    /* --110-0----1---- V44 */
    /* --110-0-----1--- V44 */
    /* ---0-----0------ V60 */
    /* --0----0-------- V60 */
    /* ----1----0------ V60 */
    /* ------10-------- V60 */
    /* --0------0------ V60 */
    /* ------1--0------ V60 */
    /* ---0---0-------- V60 */
    /* ----1--0-------- V60 */
    /* ---0-------1---- V60 */
    /* --0--------1---- V60 */
    /* ----1------1---- V60 */
    /* ------1----1---- V60 */
    /* ---0--------1--- V60 */
    /* --0---------1--- V60 */
    /* ----1-------1--- V60 */
    /* ------1-----1--- V60 */
    	if (TTFF(h,j,l,m)) {
    		if (TTFF(c,d,e,g))
    			return V37;
    		else
    			return V38;
    	} else {
    		if (TTFF(c,d,e,g))
    			return V44;
    		else
    			return V60;
    	}
    case 27:
    /* abcdefghijklmnop */
    /* --110-01-1-00--- V37 */
    /* ---0---1-1-00--- V38 */
    /* --0----1-1-00--- V38 */
    /* ----1--1-1-00--- V38 */
    /* ------11-1-00--- V38 */
    /* --110-0--0------ V44 */
    /* --110-00-------- V44 */
    /* --110-0----1---- V44 */
    /* --110-0-----1--- V44 */
    /* ---0-----0------ V60 */
    /* --0----0-------- V60 */
    /* ----1----0------ V60 */
    /* ------10-------- V60 */
    /* --0------0------ V60 */
    /* ------1--0------ V60 */
    /* ---0---0-------- V60 */
    /* ----1--0-------- V60 */
    /* ---0-------1---- V60 */
    /* --0--------1---- V60 */
    /* ----1------1---- V60 */
    /* ------1----1---- V60 */
    /* ---0--------1--- V60 */
    /* --0---------1--- V60 */
    /* ----1-------1--- V60 */
    /* ------1-----1--- V60 */
    	if (TTFF(h,j,l,m)) {
    		if (TTFF(c,d,e,g))
    			return V37;
    		else
    			return V38;
    	} else {
    		if (TTFF(c,d,e,g))
    			return V44;
    		else
    			return V60;
    	}
    case 28:
    /* abcdefghijklmnop */
    /* -------1-1-00--- V36 */
    /* ----1-0--0------ V43 */
    /* ----1-00-------- V43 */
    /* ----1-0----1---- V43 */
    /* ----1-0-----1--- V43 */
    /* ----0----0------ V59 */
    /* ------10-------- V59 */
    /* ------1--0------ V59 */
    /* ----0--0-------- V59 */
    /* ----0------1---- V59 */
    /* ------1----1---- V59 */
    /* ----0-------1--- V59 */
    /* ------1-----1--- V59 */
        /* pass through */
    case 29:
    /* abcdefghijklmnop */
    /* -------1-1-00--- V36 */
    /* ----1-0--0------ V43 */
    /* ----1-00-------- V43 */
    /* ----1-0----1---- V43 */
    /* ----1-0-----1--- V43 */
    /* ----0----0------ V59 */
    /* ------10-------- V59 */
    /* ------1--0------ V59 */
    /* ----0--0-------- V59 */
    /* ----0------1---- V59 */
    /* ------1----1---- V59 */
    /* ----0-------1--- V59 */
    /* ------1-----1--- V59 */
    	if (TTFF(h,j,l,m))
    		return V36;
    	else if(TF(e,g))
    		return V43;
    	else
    		return V59;
    case 30:
    /* abcdefghijklmnop */
    /* ------1-10------ V60 */
    /* ------101------- V60 */
    /* ------1-1--1---- V60 */
    /* ------1-1---1--- V60 */
    /* --------0------- V38 */
    /* ------0--------- V38 */
    /* -------1-1-00--- V38 */
    	/* pass through */
    case 31:
    /* abcdefghijklmnop */
    /* ------1-10------ V60 */
    /* ------101------- V60 */
    /* ------1-1--1---- V60 */
    /* ------1-1---1--- V60 */
    /* --------0------- V38 */
    /* ------0--------- V38 */
    /* -------1-1-00--- V38 */
    	if (TT(g,i) && ANYTTFF(l,m,h,j))
    		return V60;
    	else
    		return V38;
    case 32:
    case 33:
    case 34:
    case 35:
    case 36:
    case 37:
        return V0;
    case 38:
        return V1;
    case 39:
    /* abcdefghijklmnop */
    /* -----1-1-------- V1 */
    /* -------0-------- V4 */
    /* -----0---------- V4 */
    	if (TT(f,h))
    		return V1;
    	else
    		return V4;
    case 40:
    case 41:
    case 42:
        return V0;
    case 43:
        return V2;
    case 44:
    case 45:
        return V0;
    case 46:
        return V1;
    case 47:
    /* abcdefghijklmnop */
    /* ---------00----- V0 */
    /* ---------01----- V1 */
    /* ---------10----- V2 */
    /* ---------11----- V3 */
    	if (T(j)) {
    		if (T(k))
    			return V3;
    		else
    			return V2;
    	} else {
    		if (T(k))
    			return V1;
    		else
    			return V0;
    	}
    case 48:
    /* abcdefghijklmnop */
    /* ---00-1-1-1---00 V20 */
    /* ------0-1-1---00 V23 */
    /* ---1----1-1---00 V23 */
    /* ----1---1-1---00 V23 */
    /* ---00-1-1-0----- V56 */
    /* ---00-1-1-----1- V56 */
    /* ---00-1-1------1 V56 */
    /* --------0------- V60 */
    /* ------0---0----- V60 */
    /* ---1------0----- V60 */
    /* ----1-----0----- V60 */
    /* ------0-------1- V60 */
    /* ---1----------1- V60 */
    /* ----1---------1- V60 */
    /* ------0--------1 V60 */
    /* ---1-----------1 V60 */
    /* ----1----------1 V60 */
    	if (TTFF(i,k,o,p)) {
    		if (TFF(g,d,e))
    			return V20;
    		else
    			return V23;
    	} else {
    		if (TTFF(g,i,d,e))
    			return V56;
    		else
    			return V60;
    	}
    case 49:
    /* abcdefghijklmnop */
    /* --------1-1---00 V21 */
    /* 1----0----0----- V27 */
    /* 1----0--0------- V27 */
    /* 1----0--------1- V27 */
    /* 1----0---------1 V27 */
    /* 0---------0----- V57 */
    /* -----1--0------- V57 */
    /* -----1----0----- V57 */
    /* 0-------0------- V57 */
    /* 0-------------1- V57 */
    /* -----1--------1- V57 */
    /* 0--------------1 V57 */
    /* -----1---------1 V57 */
    	if (TTFF(i,k,o,p))
    		return V21;
    	else if(TF(a,f))
    		return V27;
    	else
    		return V57;
    case 50:
    /* abcdefghijklmnop */
    /* 011--0--1-1---00 V22 */
    /* --0-----1-1---00 V23 */
    /* -0------1-1---00 V23 */
    /* 1-------1-1---00 V23 */
    /* -----1--1-1---00 V23 */
    /* 011--0----0----- V28 */
    /* 011--0--0------- V28 */
    /* 011--0--------1- V28 */
    /* 011--0---------1 V28 */
    /* --0-------0----- V60 */
    /* -0------0------- V60 */
    /* 1---------0----- V60 */
    /* -----1--0------- V60 */
    /* -0--------0----- V60 */
    /* -----1----0----- V60 */
    /* --0-----0------- V60 */
    /* 1-------0------- V60 */
    /* --0-----------1- V60 */
    /* -0------------1- V60 */
    /* 1-------------1- V60 */
    /* -----1--------1- V60 */
    /* --0------------1 V60 */
    /* -0-------------1 V60 */
    /* 1--------------1 V60 */
    /* -----1---------1 V60 */
    	if (TTFF(i,k,o,p)) {
    		if (TTFF(b,c,a,f))
    			return V22;
    		else
    			return V23;
    	} else {
    		if (TTFF(b,c,a,f))
    			return V28;
    		else
    			return V60;
    	}
    case 51:
    /* abcdefghijklmnop */
    /* -----1-1--0----- V60 */
    /* -----1-10------- V60 */
    /* -----1-1------1- V60 */
    /* -----1-1-------1 V60 */
    /* -------0-------- V23 */
    /* -----0---------- V23 */
    /* --------1-1---00 V23 */
    	if (TT(f,h) && ANYTTFF(o,p,i,k))
    		return V60;
    	else
    		return V23;
    case 52:
    /* abcdefghijklmnop */
    /* ---01---1-1---00 V21 */
    /* ----0---1-1---00 V23 */
    /* ---1----1-1---00 V23 */
    /* ---01-----0----- V57 */
    /* ---01---0------- V57 */
    /* ---01---------1- V57 */
    /* ---01----------1 V57 */
    /* ----0-----0----- V60 */
    /* ---1----0------- V60 */
    /* ---1------0----- V60 */
    /* ----0---0------- V60 */
    /* ----0---------1- V60 */
    /* ---1----------1- V60 */
    /* ----0----------1 V60 */
    /* ---1-----------1 V60 */
    	if (TTFF(i,k,o,p)) {
    		if (TF(e,d))
    			return V21;
    		else
    			return V23;
    	} else {
    		if (TF(e,d))
    			return V57;
    		else
    			return V60;
    	}
    case 53:
    /* abcdefghijklmnop */
    /* --------1-1---00 V21 */
    /* 1----0----0----- V27 */
    /* 1----0--0------- V27 */
    /* 1----0--------1- V27 */
    /* 1----0---------1 V27 */
    /* 0---------0----- V57 */
    /* -----1--0------- V57 */
    /* -----1----0----- V57 */
    /* 0-------0------- V57 */
    /* 0-------------1- V57 */
    /* -----1--------1- V57 */
    /* 0--------------1 V57 */
    /* -----1---------1 V57 */
    	if (TTFF(i,k,o,p))
    		return V21;
    	else if(TF(a,f))
    		return V27;
    	else
    		return V57;
    case 54:
    /* abcdefghijklmnop */
    /* 011--0--1-1---00 V22 */
    /* --0-----1-1---00 V23 */
    /* -0------1-1---00 V23 */
    /* 1-------1-1---00 V23 */
    /* -----1--1-1---00 V23 */
    /* 011--0----0----- V28 */
    /* 011--0--0------- V28 */
    /* 011--0--------1- V28 */
    /* 011--0---------1 V28 */
    /* --0-------0----- V60 */
    /* -0------0------- V60 */
    /* 1---------0----- V60 */
    /* -----1--0------- V60 */
    /* -0--------0----- V60 */
    /* -----1----0----- V60 */
    /* --0-----0------- V60 */
    /* 1-------0------- V60 */
    /* --0-----------1- V60 */
    /* -0------------1- V60 */
    /* 1-------------1- V60 */
    /* -----1--------1- V60 */
    /* --0------------1 V60 */
    /* -0-------------1 V60 */
    /* 1--------------1 V60 */
    /* -----1---------1 V60 */
    	if (TTFF(i,k,o,p)) {
    		if (TTFF(b,c,a,f))
    			return V22;
    		else
    			return V23;
    	} else {
    		if (TTFF(b,c,a,f))
    			return V28;
    		else
    			return V60;
    	}
    case 55:
    /* abcdefghijklmnop */
    /* -----1-1--0----- V60 */
    /* -----1-10------- V60 */
    /* -----1-1------1- V60 */
    /* -----1-1-------1 V60 */
    /* -------0-------- V23 */
    /* -----0---------- V23 */
    /* --------1-1---00 V23 */
    	if (TT(f,h) && ANYTTFF(o,p,i,k))
    		return V60;
    	else
    		return V23;
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
        return V60;
    case 64:
    case 65:
    case 66:
    case 67:
    case 68:
    case 69:
    case 70:
    case 71:
    case 72:
    case 73:
    case 74:
        return V0;
    case 75:
    /* abcdefghijklmnop */
    /* ------------11-- V2 */
    /* -------------0-- V15 */
    /* ------------0--- V15 */
    	if (TT(m,n))
    		return V2;
    	else
    		return V15;
    case 76:
    case 77:
    case 78:
    case 79:
        return V0;
    case 80:
    /* abcdefghijklmnop */
    /* ---------0-10--- V10 */
    /* ---------1-10--- V14 */
    /* ---------0-11--- V27 */
    /* -----------0---- V29 */
    /* ---------1--1--- V29 */
    	if (TF(l,m)) {
    		if (T(j))
    			return V14;
    		else
    			return V10;
    	} else {
    		if (TTF(l,m,j))
    			return V27;
    		else
    			return V29;
    	}
    case 81:
    /* abcdefghijklmnop */
    /* 10---------10--- V8 */
    /* 0----------10--- V10 */
    /* -1---------10--- V10 */
    /* 10---------0---- V25 */
    /* 10----------1--- V25 */
    /* 0----------0---- V27 */
    /* -1---------0---- V27 */
    /* 0-----------1--- V27 */
    /* -1----------1--- V27 */
    	if (TF(a,b)) {
    		if (TF(l,m))
    			return V8;
    		else
    			return V25;
    	} else {
    		if (TF(l,m))
    			return V10;
    		else
    			return V27;
    	}
    case 82:
    /* abcdefghijklmnop */
    /* --110-0--------- V13 */
    /* ---0-------10--- V14 */
    /* --0--------10--- V14 */
    /* ----1------10--- V14 */
    /* ------1----10--- V14 */
    /* ---0-------0---- V29 */
    /* --0--------0---- V29 */
    /* ----1------0---- V29 */
    /* ------1----0---- V29 */
    /* ---0--------1--- V29 */
    /* --0---------1--- V29 */
    /* ----1-------1--- V29 */
    /* ------1-----1--- V29 */
    	/* pass through */
    case 83:
    /* abcdefghijklmnop */
    /* --110-0--------- V13 */
    /* ---0-------10--- V14 */
    /* --0--------10--- V14 */
    /* ----1------10--- V14 */
    /* ------1----10--- V14 */
    /* ---0-------0---- V29 */
    /* --0--------0---- V29 */
    /* ----1------0---- V29 */
    /* ------1----0---- V29 */
    /* ---0--------1--- V29 */
    /* --0---------1--- V29 */
    /* ----1-------1--- V29 */
    /* ------1-----1--- V29 */
    	if (TTFF(c,d,e,g))
    		return V13;
    	else if (TF(l,m))
    		return V14;
    	else
    		return V29;
    case 84:
        return V8;
    case 85:
        return V8;
    case 86:
        return V14;
    case 87:
        return V14;
    case 88:
    /* abcdefghijklmnop */
    /* 00---1-1---10--- V42 */
    /* 00---1-1---0---- V58 */
    /* 00---1-1----1--- V58 */
    /* -------0---10--- V45 */
    /* -----0-----10--- V45 */
    /* 1----------10--- V45 */
    /* -1---------10--- V45 */
    /* -------0---0---- V60 */
    /* -----0-----0---- V60 */
    /* 1----------0---- V60 */
    /* -1---------0---- V60 */
    /* -------0----1--- V60 */
    /* -----0------1--- V60 */
    /* 1-----------1--- V60 */
    /* -1----------1--- V60 */
    	if (TTFF(f,h,a,b)) {
    		if (TF(l,m))
    			return V42;
    		else
    			return V58;
    	} else {
    		if (TF(l,m))
    			return V45;
    		else
    			return V60;
    	}
    case 89:
    /* abcdefghijklmnop */
    /* 10---------10--- V43 */
    /* 0----------10--- V45 */
    /* -1---------10--- V45 */
    /* 10---------0---- V59 */
    /* 10----------1--- V59 */
    /* 0----------0---- V60 */
    /* -1---------0---- V60 */
    /* 0-----------1--- V60 */
    /* -1----------1--- V60 */
    	if (TF(l,m)) {
    		if (TF(a,b))
    			return V43;
    		else
    			return V45;
    	} else {
    		if (TF(a,b))
    			return V59;
    		else
    			return V60;
    	}
    case 90:
    /* abcdefghijklmnop */
    /* ---0--------11-- V60 */
    /* --0---------11-- V60 */
    /* ----1-------11-- V60 */
    /* ------1-----11-- V60 */
    /* -------------0-- V44 */
    /* ------------0--- V44 */
    /* --110-0--------- V44 */
    	/* pass through */
    case 91:
    /* abcdefghijklmnop */
    /* ---0--------11-- V60 */
    /* --0---------11-- V60 */
    /* ----1-------11-- V60 */
    /* ------1-----11-- V60 */
    /* -------------0-- V44 */
    /* ------------0--- V44 */
    /* --110-0--------- V44 */
    	if (TT(m,n) && ANYTTFF(e,g,c,d))
    		return V60;
    	else
    		return V44;
    case 92:
    case 93:
        return V43;
    case 94:
    case 95:
        return V45;
    case 96:
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
        return V0;
    case 102:
        return V1;
    case 103:
    /* abcdefghijklmnop */
    /* -----1-1-------- V1 */
    /* -------0-------- V4 */
    /* -----0---------- V4 */
    	if (TT(f,h))
    		return V1;
    	else
    		return V4;
    case 104:
    case 105:
    case 106:
        return V0;
    case 107:
        return V15;
    case 108:
    case 109:
        return V0;
    case 110:
        return V1;
    case 111:
    /* abcdefghijklmnop */
    /* ----------0----- V0 */
    /* ----------1----- V1 */
    	if (T(k))
    		return V1;
    	else
    		return V0;
    case 112:
    /* abcdefghijklmnop */
    /* ---00-1-1------- V26 */
    /* --------00-1---- V27 */
    /* ------0--0-1---- V27 */
    /* ---1-----0-1---- V27 */
    /* ----1----0-1---- V27 */
    /* --------0--0---- V29 */
    /* ------0----0---- V29 */
    /* ---1-------0---- V29 */
    /* ----1------0---- V29 */
    /* --------01------ V29 */
    /* ------0--1------ V29 */
    /* ---1-----1------ V29 */
    /* ----1----1------ V29 */
    	if (TTFF(g,i,d,e))
    		return V26;
    	else if(TF(l,j))
    		return V27;
    	else
    		return V29;
    case 113:
        return V27;
    case 114:
    /* abcdefghijklmnop */
    /* -------0-1--10-- V60 */
    /* ------------0--- V29 */
    /* ---------0------ V29 */
    /* -------1-------- V29 */
    /* -------------1-- V29 */
    	if (TTFF(j,m,h,n))
    		return V60;
    	else
    		return V29;
    case 115:
        return V23;
    case 116:
    case 117:
        return V27;
    case 118:
    /* abcdefghijklmnop */
    /* ---------0---0-- V29 */
    /* ------------00-- V29 */
    /* -------0-1--10-- V60 */
    /* -------1-----1-- V7 */
    /* -------1-----0-- V29 */
    /* -------0-----1-- V29 */
    	if (TTFF(j,m,h,n))
    		return V60;
    	else if (TT(h,n))
    		return V7;
    	else
    		return V29;
    case 119:
        return V23;
    case 120:
    case 121:
    case 122:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
        return V60;
    case 128:
    case 129:
    case 130:
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:
    case 137:
    case 138:
        return V0;
    case 139:
        return V2;
    case 140:
    case 141:
    case 142:
        return V0;
    case 143:
        return V5;
    case 144:
    /* abcdefghijklmnop */
    /* ---------0001110 V48 */
    /* ---------0-0110- V51 */
    /* ---------01011-- V51 */
    /* ---------0-011-1 V51 */
    /* ----------0-0110 V54 */
    /* ---------10--110 V54 */
    /* ----------01-110 V54 */
    /* -------------0-- V60 */
    /* ------------0-0- V60 */
    /* ---------1----0- V60 */
    /* -----------1--0- V60 */
    /* ----------1-0--- V60 */
    /* ---------11----- V60 */
    /* ----------11---- V60 */
    /* ------------0--1 V60 */
    /* ---------1-----1 V60 */
    /* -----------1---1 V60 */
    	if (TTFF(m,n,j,l)) {
    		if (TFF(o,k,p))
    			return V48;
    		else
    			return V51;
    	} else {
    		if (TTFF(n,o,k,p))
    			return V54;
    		else
    			return V60;
    	}
    case 145:
    /* abcdefghijklmnop */
    /* ----------0--110 V52 */
    /* 10------------0- V55 */
    /* 10-----------0-- V55 */
    /* 10--------1----- V55 */
    /* 10-------------1 V55 */
    /* 0-------------0- V57 */
    /* -1-----------0-- V57 */
    /* -1------------0- V57 */
    /* 0------------0-- V57 */
    /* 0---------1----- V57 */
    /* -1--------1----- V57 */
    /* 0--------------1 V57 */
    /* -1-------------1 V57 */
    	if (TTFF(n,o,k,p))
    		return V52;
    	else if(TF(a,b))
    		return V55;
    	else
    		return V57;
    case 146:
    case 147:
        return V60;
    case 148:
    /* abcdefghijklmnop */
    /* ---------0-011-- V49 */
    /* ---01--------0-- V55 */
    /* ---01-------0--- V55 */
    /* ---01----1------ V55 */
    /* ---01------1---- V55 */
    /* ----0--------0-- V59 */
    /* ---1--------0--- V59 */
    /* ---1---------0-- V59 */
    /* ----0-------0--- V59 */
    /* ----0----1------ V59 */
    /* ---1-----1------ V59 */
    /* ----0------1---- V59 */
    /* ---1-------1---- V59 */
    	if (TTFF(m,n,j,l))
    		return V49;
    	else if(TF(e,d))
    		return V55;
    	else
    		return V59;
    case 149:
        return V55;
    case 150:
    case 151:
        return V60;
    case 152:
    /* abcdefghijklmnop */
    /* 00---1-1--0--110 V53 */
    /* -------0--0--110 V54 */
    /* -----0----0--110 V54 */
    /* 1---------0--110 V54 */
    /* -1--------0--110 V54 */
    /* 00---1-1------0- V58 */
    /* 00---1-1-----0-- V58 */
    /* 00---1-1--1----- V58 */
    /* 00---1-1-------1 V58 */
    /* -------0------0- V60 */
    /* -----0-------0-- V60 */
    /* 1-------------0- V60 */
    /* -1-----------0-- V60 */
    /* -----0--------0- V60 */
    /* -1------------0- V60 */
    /* -------0-----0-- V60 */
    /* 1------------0-- V60 */
    /* -------0--1----- V60 */
    /* -----0----1----- V60 */
    /* 1---------1----- V60 */
    /* -1--------1----- V60 */
    /* -------0-------1 V60 */
    /* -----0---------1 V60 */
    /* 1--------------1 V60 */
    /* -1-------------1 V60 */
    	if (TTFF(n,o,k,p)) {
    		if (TTFF(f,h,a,b))
    			return V53;
    		else
    			return V54;
    	} else {
    		if (TTFF(f,h,a,b))
    			return V58;
    		else
    			return V60;
    	}
    case 153:
    /* abcdefghijklmnop */
    /* -11-----------0- V60 */
    /* -11----------0-- V60 */
    /* -11-------1----- V60 */
    /* -11------------1 V60 */
    /* --0------------- V54 */
    /* -0-------------- V54 */
    /* ----------0--110 V54 */
    	if (TT(b,c) && ANYTTFF(k,p,n,o))
    		return V60;
    	else
    		return V54;
    case 154:
    case 155:
        return V60;
    case 156:
    /* abcdefghijklmnop */
    /* --01--1-0------- V60 */
    /* ------0--------- V59 */
    /* ---0------------ V59 */
    /* --1------------- V59 */
    /* --------1------- V59 */
    	if (TTFF(d,g,c,i))
    		return V60;
    	else
    		return V59;
    case 157:
        return V54;
    case 158:
    case 159:
        return V60;
    case 160:
    case 161:
    case 162:
    case 163:
    case 164:
    case 165:
        return V0;
    case 166:
        return V1;
    case 167:
        return V4;
    case 168:
    case 169:
    case 170:
        return V0;
    case 171:
        return V2;
    case 172:
    case 173:
        return V0;
    case 174:
        return V1;
    case 175:
        return V3;
    case 176:
    /* abcdefghijklmnop */
    /* ---00-1-10-011-- V50 */
    /* --------00-011-- V51 */
    /* ------0--0-011-- V51 */
    /* ---1-----0-011-- V51 */
    /* ----1----0-011-- V51 */
    /* ---00-1-1----0-- V56 */
    /* ---00-1-1---0--- V56 */
    /* ---00-1-11------ V56 */
    /* ---00-1-1--1---- V56 */
    /* --------0----0-- V60 */
    /* ------0-----0--- V60 */
    /* ---1---------0-- V60 */
    /* ----1-------0--- V60 */
    /* ------0------0-- V60 */
    /* ----1--------0-- V60 */
    /* --------0---0--- V60 */
    /* ---1--------0--- V60 */
    /* --------01------ V60 */
    /* ------0--1------ V60 */
    /* ---1-----1------ V60 */
    /* ----1----1------ V60 */
    /* --------0--1---- V60 */
    /* ------0----1---- V60 */
    /* ---1-------1---- V60 */
    /* ----1------1---- V60 */
    	if (TTFF(m,n,j,l)) {
    		if (TTFF(g,i,d,e))
    			return V50;
    		else
    			return V51;
    	} else {
    		if (TTFF(g,i,d,e))
    			return V56;
    		else
    			return V60;
    	}
    case 177:
    /* abcdefghijklmnop */
    /* -10--1-0-------- V60 */
    /* -----0---------- V57 */
    /* -0-------------- V57 */
    /* --1------------- V57 */
    /* -------1-------- V57 */
    	if (TTFF(b,f,c,h))
    		return V60;
    	else
    		return V57;
    case 178:
    case 179:
        return V60;
    case 180:
    /* abcdefghijklmnop */
    /* --11---------0-- V60 */
    /* --11--------0--- V60 */
    /* --11-----1------ V60 */
    /* --11-------1---- V60 */
    /* ---0------------ V51 */
    /* --0------------- V51 */
    /* ---------0-011-- V51 */
    	if (TT(c,d) && ANYTTFF(j,l,m,n))
    		return V60;
    	else
    		return V51;
    case 181:
        return V51;
    case 182:
    case 183:
    case 184:
    case 185:
    case 186:
    case 187:
    case 188:
    case 189:
    case 190:
    case 191:
        return V60;
    case 192:
    case 193:
    case 194:
    case 195:
    case 196:
    case 197:
    case 198:
    case 199:
        return V0;
    case 200:
        return V32;
    case 201:
    /* abcdefghijklmnop */
    /* -11------------- V32 */
    /* --0------------- V40 */
    /* -0-------------- V40 */
    	if (TT(b,c))
    		return V32;
    	else
    		return V40;
    case 202:
        return V32;
    case 203:
    /* abcdefghijklmnop */
    /* ---0----------0- V0 */
    /* ---1----------0- V2 */
    /* ---0----------1- V32 */
    /* ---1----------1- V34 */
    	if (T(o)) {
    		if (T(d))
    			return V34;
    		else
    			return V32;
    	} else {
    		if (T(d))
    			return V2;
    		else
    			return V0;
    	}
    case 204:
        return V32;
    case 205:
    /* abcdefghijklmnop */
    /* -11------------- V32 */
    /* --0------------- V40 */
    /* -0-------------- V40 */
    	if (TT(b,c))
    		return V32;
    	else
    		return V40;
    case 206:
        return V32;
    case 207:
    /* abcdefghijklmnop */
    /* --------------0- V0 */
    /* --------------1- V32 */
    	if (F(o))
    		return V0;
    	else
    		return V32;
    case 208:
    /* abcdefghijklmnop */
    /* ---------001-110 V52 */
    /* ----------00-110 V54 */
    /* ---------10--110 V54 */
    /* ---------0-1--0- V57 */
    /* ---------0-1-0-- V57 */
    /* ---------011---- V57 */
    /* ---------0-1---1 V57 */
    /* -----------0--0- V60 */
    /* ---------1---0-- V60 */
    /* ---------1----0- V60 */
    /* -----------0-0-- V60 */
    /* ----------10---- V60 */
    /* ---------11----- V60 */
    /* -----------0---1 V60 */
    /* ---------1-----1 V60 */
    	if (TTFF(n,o,k,p)) {
    		if (TF(l,j))
    			return V52;
    		else
    			return V54;
    	} else {
    		if (TF(l,j))
    			return V57;
    		else
    			return V60;
    	}
    case 209:
    /* abcdefghijklmnop */
    /* ----------0--110 V52 */
    /* 10------------0- V55 */
    /* 10-----------0-- V55 */
    /* 10--------1----- V55 */
    /* 10-------------1 V55 */
    /* 0-------------0- V57 */
    /* -1-----------0-- V57 */
    /* -1------------0- V57 */
    /* 0------------0-- V57 */
    /* 0---------1----- V57 */
    /* -1--------1----- V57 */
    /* 0--------------1 V57 */
    /* -1-------------1 V57 */
    	if (TTFF(n,o,k,p))
    		return V52;
    	else if (TF(a,b))
    		return V55;
    	else
    		return V57;
    case 210:
    case 211:
        return V60;
    case 212:
    case 213:
        return V55;
    case 214:
    case 215:
        return V60;
    case 216:
    /* abcdefghijklmnop */
    /* 00---1-1--0--110 V53 */
    /* -------0--0--110 V54 */
    /* -----0----0--110 V54 */
    /* 1---------0--110 V54 */
    /* -1--------0--110 V54 */
    /* 00---1-1------0- V58 */
    /* 00---1-1-----0-- V58 */
    /* 00---1-1--1----- V58 */
    /* 00---1-1-------1 V58 */
    /* -------0------0- V60 */
    /* -----0-------0-- V60 */
    /* 1-------------0- V60 */
    /* -1-----------0-- V60 */
    /* -----0--------0- V60 */
    /* -1------------0- V60 */
    /* -------0-----0-- V60 */
    /* 1------------0-- V60 */
    /* -------0--1----- V60 */
    /* -----0----1----- V60 */
    /* 1---------1----- V60 */
    /* -1--------1----- V60 */
    /* -------0-------1 V60 */
    /* -----0---------1 V60 */
    /* 1--------------1 V60 */
    /* -1-------------1 V60 */
    	if (TTFF(n,o,k,p)) {
    		if (TTFF(f,h,a,b))
    			return V53;
    		else
    			return V54;
    	} else {
    		if (TTFF(f,h,a,b))
    			return V58;
    		else
    			return V60;
    	}
    case 217:
    /* abcdefghijklmnop */
    /* -11-----------0- V60 */
    /* -11----------0-- V60 */
    /* -11-------1----- V60 */
    /* -11------------1 V60 */
    /* --0------------- V54 */
    /* -0-------------- V54 */
    /* ----------0--110 V54 */
    	if (TT(b,c) && ANYTTFF(k,p,n,o))
    		return V60;
    	else
    		return V54;
    case 218:
        return V60;
    case 219:
        return V60;
    case 220:
    /* abcdefghijklmnop */
    /* ---0----0------- V59 */
    /* ------0-0------- V59 */
    /* --01--1-0------- V60 */
    /* --1-----1------- V47 */
    /* --1-----0------- V59 */
    /* --0-----1------- V59 */
    	if (TT(c,i))
    		return V47;
    	else if(TTFF(d,g,c,i))
    		return V60;
    	else
    		return V59;
    case 221:
        return V54;
    case 222:
    case 223:
        return V60;
    case 224:
    case 225:
    case 226:
    case 227:
    case 228:
    case 229:
        return V0;
    case 230:
        return V1;
    case 231:
        return V4;
    case 232:
        return V32;
    case 233:
        return V40;
    case 234:
        return V32;
    case 235:
        return V34;
    case 236:
        return V32;
    case 237:
        return V40;
    case 238:
    case 239:
        return V33;
    case 240:
    /* abcdefghijklmnop */
    /* -------101------ V60 */
    /* ------01-1------ V60 */
    /* ---1---1-1------ V60 */
    /* ----1--1-1------ V60 */
    /* ---------0------ V56 */
    /* -------0-------- V56 */
    /* ---00-1-1------- V56 */
    	if (TT(h,j) && ANYTTFF(d,e,g,i))
    		return V60;
    	else
    		return V56;
    case 241:
        return V56;
    case 242:
    case 243:
        return V60;
    case 244:
    case 245:
        return V57;
    case 246:
    case 247:
    case 248:
    case 249:
    case 250:
    case 251:
    case 252:
    case 253:
    case 254:
    case 255:
        return V60;
    case 256:
    case 257:
    case 258:
    case 259:
    case 260:
    case 261:
    case 262:
    case 263:
    case 264:
    case 265:
    case 266:
        return V0;
    case 267:
        return V2;
    case 268:
    case 269:
    case 270:
        return V0;
    case 271:
    /* abcdefghijklmnop */
    /* ------1-1------- V2 */
    /* --------0------- V5 */
    /* ------0--------- V5 */
    	if (TT(g,i))
    		return V2;
    	else
    		return V5;
    case 272:
    /* abcdefghijklmnop */
    /* ----------0---01 V12 */
    /* ----------1---01 V14 */
    /* ----------0---11 V43 */
    /* ---------------0 V45 */
    /* ----------1---1- V45 */
    	if (TF(p,o)) {
    		if (T(k))
    			return V14;
    		else
    			return V12;
    	} else {
    		if (TTF(o,p,k))
    			return V43;
    		else
    			return V45;
    	}
    case 273:
        return V8;
    case 274:
    /* abcdefghijklmnop */
    /* 011--0---------- V11 */
    /* --0-----------01 V14 */
    /* -0------------01 V14 */
    /* 1-------------01 V14 */
    /* -----1--------01 V14 */
    /* --0------------0 V45 */
    /* -0-------------0 V45 */
    /* 1--------------0 V45 */
    /* -----1---------0 V45 */
    /* --0-----------1- V45 */
    /* -0------------1- V45 */
    /* 1-------------1- V45 */
    /* -----1--------1- V45 */
    	if (TTFF(b,c,a,f))
    		return V11;
    	else if (TF(p,o))
    		return V14;
    	else
    		return V45;
    case 275:
        return V14;
    case 276:
    /* abcdefghijklmnop */
    /* ---01---------01 V8 */
    /* ----0---------01 V12 */
    /* ---1----------01 V12 */
    /* ---01----------0 V41 */
    /* ---01---------1- V41 */
    /* ----0----------0 V43 */
    /* ---1-----------0 V43 */
    /* ----0---------1- V43 */
    /* ---1----------1- V43 */
    	if (TF(p,o)) {
    		if (TF(e,d))
    			return V8;
    		else
    			return V12;
    	} else {
    		if (TF(e,d))
    			return V41;
    		else
    			return V43;
    	}
    case 277:
        return V8;
    case 278:
    /* abcdefghijklmnop */
    /* 011--0---------- V11 */
    /* --0-----------01 V14 */
    /* -0------------01 V14 */
    /* 1-------------01 V14 */
    /* -----1--------01 V14 */
    /* --0------------0 V45 */
    /* -0-------------0 V45 */
    /* 1--------------0 V45 */
    /* -----1---------0 V45 */
    /* --0-----------1- V45 */
    /* -0------------1- V45 */
    /* 1-------------1- V45 */
    /* -----1--------1- V45 */
    	if (TTFF(b,c,a,f))
    		return V11;
    	else if (TF(p,o))
    		return V14;
    	else
    		return V45;
    case 279:
        return V14;
    case 280:
    /* abcdefghijklmnop */
    /* 00---1-1-------- V42 */
    /* -------0--0----1 V43 */
    /* -----0----0----1 V43 */
    /* 1---------0----1 V43 */
    /* -1--------0----1 V43 */
    /* -------0-------0 V45 */
    /* -----0---------0 V45 */
    /* 1--------------0 V45 */
    /* -1-------------0 V45 */
    /* -------0--1----- V45 */
    /* -----0----1----- V45 */
    /* 1---------1----- V45 */
    /* -1--------1----- V45 */
    	if (TTFF(f,h,a,b))
    		return V42;
    	else if (TF(p,k))
    		return V43;
    	else
    		return V45;
    case 281:
        return V43;
    case 282:
    /* abcdefghijklmnop */
    /* --------0-1--01- V60 */
    /* --------------0- V45 */
    /* ----------0----- V45 */
    /* --------1------- V45 */
    /* -------------1-- V45 */
    	if (TTFF(k,o,i,n))
    		return V60;
    	else
    		return V45;
    case 283:
    /* abcdefghijklmnop */
    /* ----------0--0-- V45 */
    /* -------------00- V45 */
    /* --------0-1--01- V60 */
    /* --------1----1-- V16 */
    /* --------0----1-- V45 */
    /* --------1----0-- V45 */
    	if (TTFF(k,o,i,n))
    		return V60;
    	else if(TT(i,n))
    		return V16;
    	else
    		return V45;
    case 284:
    case 285:
        return V43;
    case 286:
    case 287:
        return V38;
    case 288:
    case 289:
    case 290:
    case 291:
    case 292:
    case 293:
        return V0;
    case 294:
    /* abcdefghijklmnop */
    /* -------------11- V1 */
    /* --------------0- V6 */
    /* -------------0-- V6 */
    	if (TT(n,o))
    		return V1;
    	else
    		return V6;
    case 295:
    case 296:
    case 297:
    case 298:
        return V0;
    case 299:
        return V2;
    case 300:
    case 301:
        return V0;
    case 302:
        return V6;
    case 303:
    /* abcdefghijklmnop */
    /* ---------0------ V0 */
    /* ---------1------ V2 */
    	if (T(j))
    		return V2;
    	else
    		return V0;
    case 304:
    /* abcdefghijklmnop */
    /* ---00-1-1-----01 V26 */
    /* ---00-1-1------0 V56 */
    /* ---00-1-1-----1- V56 */
    /* --------0-----01 V29 */
    /* ------0-------01 V29 */
    /* ---1----------01 V29 */
    /* ----1---------01 V29 */
    /* --------0------0 V60 */
    /* ------0--------0 V60 */
    /* ---1-----------0 V60 */
    /* ----1----------0 V60 */
    /* --------0-----1- V60 */
    /* ------0-------1- V60 */
    /* ---1----------1- V60 */
    /* ----1---------1- V60 */
    	if (TTFF(g,i,d,e)) {
    		if (TF(p,o))
    			return V26;
    		else
    			return V56;
    	} else {
    		if (TF(p,o))
    			return V29;
    		else
    			return V60;
    	}
    case 305:
        return V27;
    case 306:
    /* abcdefghijklmnop */
    /* --0----------11- V60 */
    /* -0-----------11- V60 */
    /* 1------------11- V60 */
    /* -----1-------11- V60 */
    /* --------------0- V28 */
    /* -------------0-- V28 */
    /* 011--0---------- V28 */
    	if (TT(n,o) && ANYTTFF(a,f,b,c))
    		return V60;
    	else
    		return V28;
    case 307:
        return V29;
    case 308:
    /* abcdefghijklmnop */
    /* ---01---------01 V27 */
    /* ----0---------01 V29 */
    /* ---1----------01 V29 */
    /* ---01----------0 V57 */
    /* ---01---------1- V57 */
    /* ----0----------0 V60 */
    /* ---1-----------0 V60 */
    /* ----0---------1- V60 */
    /* ---1----------1- V60 */
    	if (TF(p,o)) {
    		if (TF(e,d))
    			return V27;
    		else
    			return V29;
    	} else {
    		if (TF(e,d))
    			return V57;
    		else
    			return V60;
    	}
    case 309:
        return V27;
    case 310:
    /* abcdefghijklmnop */
    /* --0----------11- V60 */
    /* -0-----------11- V60 */
    /* 1------------11- V60 */
    /* -----1-------11- V60 */
    /* --------------0- V28 */
    /* -------------0-- V28 */
    /* 011--0---------- V28 */
    	if (TT(n,o) && ANYTTFF(a,f,b,c))
    		return V60;
    	else
    		return V28;
    case 311:
        return V29;
    case 312:
    case 313:
    case 314:
    case 315:
    case 316:
    case 317:
    case 318:
    case 319:
        return V60;
    case 320:
    case 321:
    case 322:
    case 323:
    case 324:
    case 325:
    case 326:
    case 327:
    case 328:
    case 329:
    case 330:
        return V0;
    case 331:
    /* abcdefghijklmnop */
    /* ------------11-- V2 */
    /* -------------0-- V15 */
    /* ------------0--- V15 */
    	if (TT(m,n))
    		return V2;
    	else
    		return V15;
    case 332:
    case 333:
    case 334:
    case 335:
        return V0;
    case 336:
    /* abcdefghijklmnop */
    /* ---------001---1 V8 */
    /* ---------0-1---0 V10 */
    /* ---------011---- V10 */
    /* ----------00---1 V12 */
    /* ---------10----1 V12 */
    /* -----------0---0 V14 */
    /* ---------1-----0 V14 */
    /* ----------10---- V14 */
    /* ---------11----- V14 */
    	if (TF(l,j)) {
    		if (TF(p,k))
    			return V8;
    		else
    			return V10;
    	} else {
    		if (TF(p,k))
    			return V12;
    		else
    			return V14;
    	}
    case 337:
        return V8;
    case 338:
    case 339:
        return V14;
    case 340:
        return V8;
    case 341:
        return V60;
    case 342:
    case 343:
        return V14;
    case 344:
    /* abcdefghijklmnop */
    /* 00---1-1-------- V42 */
    /* -------0--0----1 V43 */
    /* -----0----0----1 V43 */
    /* 1---------0----1 V43 */
    /* -1--------0----1 V43 */
    /* -------0-------0 V45 */
    /* -----0---------0 V45 */
    /* 1--------------0 V45 */
    /* -1-------------0 V45 */
    /* -------0--1----- V45 */
    /* -----0----1----- V45 */
    /* 1---------1----- V45 */
    /* -1--------1----- V45 */
    	if (TTFF(f,h,a,b))
    		return V42;
    	else if (TF(p,k))
    		return V43;
    	else
    		return V45;
    case 345:
        return V43;
    case 346:
    case 347:
        return V44;
    case 348:
    case 349:
        return V43;
    case 350:
    case 351:
        return V45;
    case 352:
    case 353:
    case 354:
    case 355:
    case 356:
    case 357:
        return V0;
    case 358:
    /* abcdefghijklmnop */
    /* -------------11- V1 */
    /* --------------0- V6 */
    /* -------------0-- V6 */
    	if (TT(n,o))
    		return V1;
    	else
    		return V6;
    case 359:
    case 360:
    case 361:
    case 362:
        return V0;
    case 363:
        return V15;
    case 364:
    case 365:
        return V0;
    case 366:
        return V6;
    case 367:
        return V0;
    case 368:
    /* abcdefghijklmnop */
    /* ---00-1-1------- V26 */
    /* --------00-1---- V27 */
    /* ------0--0-1---- V27 */
    /* ---1-----0-1---- V27 */
    /* ----1----0-1---- V27 */
    /* --------0--0---- V29 */
    /* ------0----0---- V29 */
    /* ---1-------0---- V29 */
    /* ----1------0---- V29 */
    /* --------01------ V29 */
    /* ------0--1------ V29 */
    /* ---1-----1------ V29 */
    /* ----1----1------ V29 */
    	if (TTFF(g,i,d,e))
    		return V26;
    	else if (TF(l,j))
    		return V27;
    	else
    		return V29;
    case 369:
        return V27;
    case 370:
        return V28;
    case 371:
        return V29;
    case 372:
    case 373:
        return V27;
    case 374:
        return V28;
    case 375:
        return V29;
    case 376:
    case 377:
    case 378:
    case 379:
    case 380:
    case 381:
    case 382:
    case 383:
        return V60;
    case 384:
    case 385:
    case 386:
    case 387:
    case 388:
    case 389:
    case 390:
    case 391:
    case 392:
    case 393:
    case 394:
        return V0;
    case 395:
        return V2;
    case 396:
    case 397:
    case 398:
        return V0;
    case 399:
        return V5;
    case 400:
    /* abcdefghijklmnop */
    /* ---------00011-1 V49 */
    /* ---------0-011-0 V51 */
    /* ---------01011-- V51 */
    /* ----------0--0-1 V59 */
    /* ----------0-0--1 V59 */
    /* ---------10----1 V59 */
    /* ----------01---1 V59 */
    /* -------------0-0 V60 */
    /* ------------0--0 V60 */
    /* ---------1-----0 V60 */
    /* -----------1---0 V60 */
    /* ----------1--0-- V60 */
    /* ----------1-0--- V60 */
    /* ---------11----- V60 */
    /* ----------11---- V60 */
    	if (TTFF(m,n,j,l)) {
    		if (TF(p,k))
    			return V49;
    		else
    			return V51;
    	} else {
    		if (TF(p,k))
    			return V59;
    		else
    			return V60;
    	}
    case 401:
        return V55;
    case 402:
    case 403:
        return V60;
    case 404:
    /* abcdefghijklmnop */
    /* ---------0-011-- V49 */
    /* ---01--------0-- V55 */
    /* ---01-------0--- V55 */
    /* ---01----1------ V55 */
    /* ---01------1---- V55 */
    /* ----0--------0-- V59 */
    /* ---1--------0--- V59 */
    /* ---1---------0-- V59 */
    /* ----0-------0--- V59 */
    /* ----0----1------ V59 */
    /* ---1-----1------ V59 */
    /* ----0------1---- V59 */
    /* ---1-------1---- V59 */
    	if (TTFF(m,n,j,l))
    		return V49;
    	else if (TF(e,d))
    		return V55;
    	else
    		return V59;
    case 405:
        return V55;
    case 406:
    case 407:
        return V60;
    case 408:
    /* abcdefghijklmnop */
    /* -------01-1----- V60 */
    /* -----0--1-1----- V60 */
    /* 1-------1-1----- V60 */
    /* -1------1-1----- V60 */
    /* ----------0----- V58 */
    /* --------0------- V58 */
    /* 00---1-1-------- V58 */
    	if (TT(i,k) && ANYTTFF(a,b,f,h))
    		return V60;
    	else
    		return V58;
    case 409:
        return V59;
    case 410:
    case 411:
        return V60;
    case 412:
        return V58;
    case 413:
        return V59;
    case 414:
    case 415:
        return V60;
    case 416:
    case 417:
    case 418:
    case 419:
        return V17;
    case 420:
    /* abcdefghijklmnop */
    /* --11------------ V17 */
    /* ---0------------ V24 */
    /* --0------------- V24 */
    	/* pass through */
    case 421:
    /* abcdefghijklmnop */
    /* --11------------ V17 */
    /* ---0------------ V24 */
    /* --0------------- V24 */
    	if (TT(c,d))
    		return V17;
    	else
    		return V24;
    case 422:
    /* abcdefghijklmnop */
    /* -0----------0--- V0 */
    /* -1----------0--- V1 */
    /* -0----------1--- V17 */
    /* -1----------1--- V18 */
    	if (T(m)) {
    		if (T(b))
    			return V18;
    		else
    			return V17;
    	} else {
    		if (T(b))
    			return V1;
    		else
    			return V0;
    	}
    case 423:
    /* abcdefghijklmnop */
    /* ------------0--- V0 */
    /* ------------1--- V17 */
    	if (T(m))
    		return V17;
    	else
    		return V0;
    case 424:
    case 425:
    case 426:
        return V17;
    case 427:
        return V19;
    case 428:
    case 429:
        return V24;
    case 430:
        return V18;
    case 431:
        return V19;
    case 432:
    /* abcdefghijklmnop */
    /* ---00-1-10-011-- V50 */
    /* --------00-011-- V51 */
    /* ------0--0-011-- V51 */
    /* ---1-----0-011-- V51 */
    /* ----1----0-011-- V51 */
    /* ---00-1-1----0-- V56 */
    /* ---00-1-1---0--- V56 */
    /* ---00-1-11------ V56 */
    /* ---00-1-1--1---- V56 */
    /* --------0----0-- V60 */
    /* ------0-----0--- V60 */
    /* ---1---------0-- V60 */
    /* ----1-------0--- V60 */
    /* ------0------0-- V60 */
    /* ----1--------0-- V60 */
    /* --------0---0--- V60 */
    /* ---1--------0--- V60 */
    /* --------01------ V60 */
    /* ------0--1------ V60 */
    /* ---1-----1------ V60 */
    /* ----1----1------ V60 */
    /* --------0--1---- V60 */
    /* ------0----1---- V60 */
    /* ---1-------1---- V60 */
    /* ----1------1---- V60 */
    	if (TTFF(m,n,j,l)) {
    		if (TTFF(g,i,d,e))
    			return V50;
    		else
    			return V51;
    	} else {
    		if (TTFF(g,i,d,e))
    			return V56;
    		else
    			return V60;
    	}
    case 433:
    /* abcdefghijklmnop */
    /* -0-----0-------- V57 */
    /* -----0-0-------- V57 */
    /* -10--1-0-------- V60 */
    /* --1----1-------- V31 */
    /* --1----0-------- V57 */
    /* --0----1-------- V57 */
    	if (TTFF(b,f,c,h))
    		return V60;
    	else if (TT(c,h))
    		return V31;
    	else
    		return V57;
    case 434:
    case 435:
        return V60;
    case 436:
    /* abcdefghijklmnop */
    /* --11---------0-- V60 */
    /* --11--------0--- V60 */
    /* --11-----1------ V60 */
    /* --11-------1---- V60 */
    /* ---0------------ V51 */
    /* --0------------- V51 */
    /* ---------0-011-- V51 */
    	if (TT(c,d) && ANYTTFF(j,l,m,n))
    		return V60;
    	else
    		return V51;
    case 437:
        return V51;
    case 438:
    case 439:
    case 440:
    case 441:
    case 442:
    case 443:
    case 444:
    case 445:
    case 446:
    case 447:
        return V60;
    case 448:
    case 449:
    case 450:
    case 451:
    case 452:
    case 453:
    case 454:
    case 455:
        return V0;
    case 456:
    /* abcdefghijklmnop */
    /* --------1-1----- V32 */
    /* ----------0----- V46 */
    /* --------0------- V46 */
    	if (TT(i,k))
    		return V32;
    	else
    		return V46;
    case 457:
        return V0;
    case 458:
        return V46;
    case 459:
    /* abcdefghijklmnop */
    /* ---0------------ V0 */
    /* ---1------------ V2 */
    	if (T(d))
    		return V2;
    	else
    		return V0;
    case 460:
    /* abcdefghijklmnop */
    /* --------1-1----- V32 */
    /* ----------0----- V46 */
    /* --------0------- V46 */
    	if (TT(i,k))
    		return V32;
    	else
    		return V46;
    case 461:
        return V0;
    case 462:
        return V46;
    case 463:
        return V0;
    case 464:
    /* abcdefghijklmnop */
    /* ---------001---1 V55 */
    /* ---------0-1---0 V57 */
    /* ---------011---- V57 */
    /* ----------00---1 V59 */
    /* ---------10----1 V59 */
    /* -----------0---0 V60 */
    /* ---------1-----0 V60 */
    /* ----------10---- V60 */
    /* ---------11----- V60 */
    	if (TF(l,j)) {
    		if (TF(p,k))
    			return V55;
    		else
    			return V57;
    	} else {
    		if (TF(p,k))
    			return V59;
    		else
    			return V60;
    	}
    case 465:
        return V55;
    case 466:
    case 467:
        return V60;
    case 468:
    case 469:
        return V55;
    case 470:
    case 471:
        return V60;
    case 472:
    /* abcdefghijklmnop */
    /* -------01-1----- V60 */
    /* -----0--1-1----- V60 */
    /* 1-------1-1----- V60 */
    /* -1------1-1----- V60 */
    /* ----------0----- V58 */
    /* --------0------- V58 */
    /* 00---1-1-------- V58 */
    	if (TT(i,k) && ANYTTFF(a,b,f,h))
    		return V60;
    	else
    		return V58;
    case 473:
        return V59;
    case 474:
    case 475:
        return V60;
    case 476:
        return V58;
    case 477:
        return V59;
    case 478:
    case 479:
        return V60;
    case 480:
    /* abcdefghijklmnop */
    /* -------1-1------ V17 */
    /* ---------0------ V30 */
    /* -------0-------- V30 */
    	/* pass through */
    case 481:
    /* abcdefghijklmnop */
    /* -------1-1------ V17 */
    /* ---------0------ V30 */
    /* -------0-------- V30 */
    	if (TT(h,j))
    		return V17;
    	else
    		return V30;
    case 482:
    case 483:
        return V30;
    case 484:
    case 485:
        return V0;
    case 486:
    /* abcdefghijklmnop */
    /* -0-------------- V0 */
    /* -1-------------- V1 */
    	if (T(b))
    		return V1;
    	else
    		return V0;
    case 487:
        return V0;
    case 488:
    /* abcdefghijklmnop */
    /* -----00--------- V0 */
    /* -----01--------- V17 */
    /* -----10--------- V32 */
    /* -----11--------- V39 */
    	if (T(f)) {
    		if (T(g))
    			return V39;
    		else
    			return V32;
    	} else {
    		if (T(g))
    			return V17;
    		else
    			return V0;
    	}
    case 489:
    /* abcdefghijklmnop */
    /* ------0--------- V0 */
    /* ------1--------- V17 */
    	if (T(g))
    		return V17;
    	else
    		return V0;
    case 490:
        return V39;
    case 491:
        return V19;
    case 492:
    /* abcdefghijklmnop */
    /* -----0---------- V0 */
    /* -----1---------- V32 */
    	if (T(f))
    		return V32;
    	else
    		return V0;
    case 493:
        return V0;
    case 494:
        return V33;
    case 495:
        return V0;
    case 496:
    /* abcdefghijklmnop */
    /* -------101------ V60 */
    /* ------01-1------ V60 */
    /* ---1---1-1------ V60 */
    /* ----1--1-1------ V60 */
    /* ---------0------ V56 */
    /* -------0-------- V56 */
    /* ---00-1-1------- V56 */
    	if (TT(h,j) && ANYTTFF(d,e,g,i))
    		return V60;
    	else
    		return V56;
    case 497:
        return V56;
    case 498:
    case 499:
        return V60;
    case 500:
    case 501:
        return V57;
    case 502:
    case 503:
    case 504:
    case 505:
    case 506:
    case 507:
    case 508:
    case 509:
    case 510:
    case 511:
        return V60;
    }
    /* Unreachable, returning an impossible value to irk the unit test. */
    return 3;
}
