

#include "qrb.h"
/* Compute the Bearing and Range */

int qrb (void) {

extern char C_QTH_Lat[];
extern char C_QTH_Long[];
extern char C_DEST_Lat[];
extern char C_DEST_Long[];
extern char hiscall[];

extern double range;
extern double bearing;

double  tmp;
double  dist;
double  Delta_Long;
double  QTH_Lat;
double  QTH_Long;
double  DEST_Lat;
double  DEST_Long;

        if (strlen(hiscall) < 1)
        	return(0);

        QTH_Lat = atof(C_QTH_Lat);
        QTH_Long  = atof(C_QTH_Long);
        DEST_Lat = atof(C_DEST_Lat);
        DEST_Long = atof(C_DEST_Long);

        Delta_Long = DEST_Long - QTH_Long;



        QTH_Lat    /= RADIAN;   /* Convert variables to Radians */
        QTH_Long   /= RADIAN;
        DEST_Lat   /= RADIAN;
        DEST_Long  /= RADIAN;
        Delta_Long /= RADIAN;


        tmp = (sin(QTH_Lat) * sin(DEST_Lat)) +(cos(QTH_Lat) * cos(DEST_Lat) * cos(Delta_Long));

        dist = acos(tmp);
	     range = 60.0 * (dist * RADIAN) * 1.8;

        tmp = (sin(DEST_Lat) - (sin(QTH_Lat) * cos(dist))) /
                (sin(dist) * cos(QTH_Lat));

        bearing = acos(tmp) * RADIAN;

        if (Delta_Long > 0.0)
                bearing = 360.0 - bearing;

        return(0);
}


