#ifndef _CWDAEMON_H
#define _CWDAEMON_H

#include <stdio.h>
#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif
#if HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif
#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif
#if HAVE_STRING_H
# if !STDC_HEADERS && HAVE_MEMORY_H
#  include <memory.h>
# endif
# include <string.h>
#endif
#if HAVE_UNISTD_H
# include <unistd.h>
#endif
#if DHAVE_ARPA_INET
# include <arpa/inet.h>
#endif
#if HAVE_FCNTL_H
# include <fcntl.h>
#endif
#if HAVE_LIMITS_H
# include <limits.h>
#endif
#if HAVE_NETDB
# include <netdb.h>
#endif
#if HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif
#if HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>
#endif
#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif
#if HAVE_SYSLOG_H
# include <syslog.h>
#endif
#if HAVE_ERRNO_H
# include <errno.h>
#endif
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include <sys/io.h>
#include <sys/kd.h>
#include <signal.h>
#include <ctype.h>
#include <stdarg.h>

#define MAXMORSE 4000

typedef struct
{
  char code;
  enum
  {
    NIL,
    DIH,
    DAH,
  }
  data[8];
}
morse;


typedef struct cwdev_s
{
    int (*init)(struct cwdev_s *);
    int (*free)(struct cwdev_s *);
    int (*reset)(struct cwdev_s *);
    int (*cw_on)(struct cwdev_s *);
    int (*cw_off)(struct cwdev_s *);
    int (*ptt_on)(struct cwdev_s *);
    int (*ptt_off)(struct cwdev_s *);
    int (*ssbway_soundcard)(struct cwdev_s *);
    int (*ssbway_mic)(struct cwdev_s *);

    int base;
    char *desc;
}
cwdevice;

void errmsg (char *info, ...);
void debug (char *info, ...);

int lp_init(cwdevice *dev);
int lp_free(cwdevice *dev);
int lp_reset(cwdevice *dev);
int lp_cw_on(cwdevice *dev);
int lp_cw_off(cwdevice *dev);
int lp_ptt_on(cwdevice *dev);
int lp_ptt_off(cwdevice *dev);
int lp_ssbway_soundcard(cwdevice *dev);
int lp_ssbway_mic(cwdevice *dev);



int ttys_init(cwdevice *dev);
int ttys_free(cwdevice *dev);
int ttys_reset(cwdevice *dev);
int ttys_cw_on(cwdevice *dev);
int ttys_cw_off(cwdevice *dev);
int ttys_ptt_on(cwdevice *dev);
int ttys_ptt_off(cwdevice *dev);

#endif /* _CWDAEMON_H */
