/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OsPipe {
    private static Logger log = Logger.getLogger(OsPipe.class);
    private Process process;
    private List<String> stdOut = new LinkedList<String>();
    private List<String> stdErr = new LinkedList<String>();
    private int exitCode;
    private long startTime = System.currentTimeMillis();
    private long elapsed;

    public OsPipe(String[] cmd) throws IOException {
        this.process = Runtime.getRuntime().exec(cmd);
        String cmdS = OsPipe.concatCmdArray(cmd);
        new IOReader(cmdS, "stdout", this.process.getInputStream(), this.stdOut).start();
        new IOReader(cmdS, "stderr", this.process.getErrorStream(), this.stdErr).start();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public long getElapsedTime() {
        return this.elapsed;
    }

    public String[] readLines() throws InterruptedException {
        this.waitFor();
        return this.stdOut.toArray(new String[0]);
    }

    public String[] readErrLines() throws InterruptedException {
        this.waitFor();
        return this.stdErr.toArray(new String[0]);
    }

    private void waitFor() throws InterruptedException {
        if (this.process == null) {
            return;
        }
        this.exitCode = this.process.waitFor();
        this.elapsed = System.currentTimeMillis() - this.startTime;
        this.process = null;
    }

    public static String concatCmdArray(String[] cmd) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            sb.append('\"');
            sb.append(cmd[i]);
            sb.append('\"');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            OsPipe pipe = new OsPipe(new String[]{"/bin/ls", "/tmp"});
            System.out.println("Exit code: " + pipe.getExitCode());
            String[] lines = pipe.readLines();
            for (int i = 0; i < lines.length; ++i) {
                System.out.println("> " + lines[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IOReader
    extends Thread {
        private BufferedReader is;
        private List<String> lines;
        private String cmd;
        private Object streamName;

        IOReader(String cmd, String streamName, InputStream is, List<String> lines) {
            super(streamName + " reader");
            this.setDaemon(true);
            this.cmd = cmd;
            this.streamName = streamName;
            this.is = new BufferedReader(new InputStreamReader(is));
            this.lines = lines;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.is.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            catch (IOException e) {
                log.error((Object)("Error reading " + this.streamName + " for [" + this.cmd + "]"));
            }
        }
    }
}

