/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.Layout;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class LayoutProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedLayout = false;

    private void initializeLayout(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.strict.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.lax.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.laxTsFirst.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.laxTsLast.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doLayout(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (!this.initializedLayout) {
                    try {
                        this.initializeLayout(spt);
                        this.initializedLayout = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                this.log.debug((Object)spt.getTokenName());
                PrimitiveAssertion pa = spc.getAssertion();
                String text = pa.getStrValue();
                if (text != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doStrict(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        try {
            if (spc.getAction() == 1) {
                Layout layout = (Layout)spc.readCurrentPolicyEngineData();
                layout.setValue(spc.getAssertion().getName().getLocalPart());
                ((Binding)spc.readPreviousPolicyEngineData()).setLayout(layout);
            }
        }
        catch (WSSPolicyException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public Object doLax(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        try {
            if (spc.getAction() == 1) {
                Layout layout = (Layout)spc.readCurrentPolicyEngineData();
                layout.setValue(spc.getAssertion().getName().getLocalPart());
                ((Binding)spc.readPreviousPolicyEngineData()).setLayout(layout);
            }
        }
        catch (WSSPolicyException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public Object doLaxTsFirst(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        try {
            if (spc.getAction() == 1) {
                Layout layout = (Layout)spc.readCurrentPolicyEngineData();
                layout.setValue(spc.getAssertion().getName().getLocalPart());
                ((Binding)spc.readPreviousPolicyEngineData()).setLayout(layout);
            }
        }
        catch (WSSPolicyException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return new Boolean(false);
        }
        return new Boolean(true);
    }

    public Object doLaxTsLast(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        try {
            if (spc.getAction() == 1) {
                Layout layout = (Layout)spc.readCurrentPolicyEngineData();
                layout.setValue(spc.getAssertion().getName().getLocalPart());
                ((Binding)spc.readPreviousPolicyEngineData()).setLayout(layout);
            }
        }
        catch (WSSPolicyException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            return new Boolean(false);
        }
        return new Boolean(true);
    }
}

