/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * fs210x.h -- Driver for the FS2104/5S Audio Amplifier
 *
 * Copyright (C) 2016-2025 Shanghai FourSemi Semiconductor Co.,Ltd.
 */

#ifndef __FS210X_H__
#define __FS210X_H__

#define FS210X_00H_STATUS		0x00
#define FS210X_03H_DEVID		0x03
#define FS210X_05H_ANASTAT		0x05
#define FS210X_06H_DIGSTAT		0x06
#define FS210X_0BH_ACCKEY		0x0B
#define FS210X_0FH_I2CADDR		0x0F
#define FS210X_10H_PWRCTRL		0x10
#define FS210X_11H_SYSCTRL		0x11
#define FS210X_17H_I2SCTRL		0x17
#define FS210X_30H_DACCTRL		0x30
#define FS210X_39H_LVOLCTRL		0x39
#define FS210X_3AH_RVOLCTRL		0x3A
#define FS210X_42H_DACEQWL		0x42
#define FS210X_46H_DACEQA		0x46
#define FS210X_A1H_PLLCTRL1		0xA1
#define FS210X_A2H_PLLCTRL2		0xA2
#define FS210X_A3H_PLLCTRL3		0xA3
#define FS210X_ABH_INTSTAT		0xAB
#define FS210X_ACH_INTSTATR		0xAC

#define FS210X_05H_PVDD_SHIFT		14
#define FS210X_05H_PVDD_MASK		BIT(14)
#define FS210X_05H_OCDL_SHIFT		13
#define FS210X_05H_OCDL_MASK		BIT(13)
#define FS210X_05H_UVDL_SHIFT		12
#define FS210X_05H_UVDL_MASK		BIT(12)
#define FS210X_05H_OVDL_SHIFT		11
#define FS210X_05H_OVDL_MASK		BIT(11)
#define FS210X_05H_OTPDL_SHIFT		10
#define FS210X_05H_OTPDL_MASK		BIT(10)
#define FS210X_05H_OCRDL_SHIFT		9
#define FS210X_05H_OCRDL_MASK		BIT(9)
#define FS210X_05H_OCLDL_SHIFT		8
#define FS210X_05H_OCLDL_MASK		BIT(8)
#define FS210X_05H_DCRDL_SHIFT		7
#define FS210X_05H_DCRDL_MASK		BIT(7)
#define FS210X_05H_DCLDL_SHIFT		6
#define FS210X_05H_DCLDL_MASK		BIT(6)
#define FS210X_05H_SRDL_SHIFT		5
#define FS210X_05H_SRDL_MASK		BIT(5)
#define FS210X_05H_OTWDL_SHIFT		4
#define FS210X_05H_OTWDL_MASK		BIT(4)
#define FS210X_05H_AMPS_SHIFT		3
#define FS210X_05H_AMPS_MASK		BIT(3)
#define FS210X_05H_PLLS_SHIFT		1
#define FS210X_05H_PLLS_MASK		BIT(1)
#define FS210X_05H_ANAS_SHIFT		0
#define FS210X_05H_ANAS_MASK		BIT(0)
#define FS210X_17H_I2SSR_SHIFT		12
#define FS210X_17H_I2SSR_MASK		GENMASK(15, 12)
#define FS210X_30H_RMUTE_SHIFT		8
#define FS210X_30H_LMUTE_SHIFT		4

#define FS210X_0BH_ACCKEY_ON		0x0091
#define FS210X_0BH_ACCKEY_OFF		0x0000
#define FS210X_10H_I2C_RESET		0x0002
#define FS210X_11H_DPS_HIZ		0x0100
#define FS210X_11H_DPS_PWDN		0x0000
#define FS210X_11H_DPS_PLAY		0x0300
#define FS210X_46H_CAM_BURST_L		0x8000
#define FS210X_46H_CAM_BURST_R		0x8200
#define FS2105S_46H_CAM_BURST_W		0x8400
#define FS210X_46H_CAM_CLEAR		0x0000

#endif /* __FS210X_H__ */
