### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++17
* Header-Only

### Build Status

Branch          | GH Actions | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ---------- | -------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/jll63/openmethod/tree/master)   | [![CI](https://github.com/jll63/openmethod/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/jll63/openmethod/actions/workflows/ci.yml) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/32486/badge.svg)](https://scan.coverity.com/projects/boostorg-openmethod) | [![codecov](https://codecov.io/gh/jll63/openmethod/branch/master/graph/badge.svg)](https://codecov.io/gh/jll63/openmethod/branch/master)   | [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/openmethod.html)   | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](https://www.boost.org/doc/libs/master/libs/openmethod/doc/html/openmethod.html)   | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/openmethod.html)
[`develop`](https://github.com/jll63/openmethod/tree/develop) | [![CI](https://github.com/jll63/openmethod/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/jll63/openmethod/actions/workflows/ci.yml) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/32486/badge.svg)](https://scan.coverity.com/projects/boostorg-openmethod) | [![codecov](https://codecov.io/gh/jll63/openmethod/branch/develop/graph/badge.svg)](https://codecov.io/gh/jll63/openmethod/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/openmethod.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](https://www.boost.org/doc/libs/develop/libs/openmethod/doc/html/openmethod.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/openmethod.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `example`   | examples                       |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-openmethod)
* [Report bugs](https://github.com/jll63/openmethod/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[openmethod]` tag at the beginning of the subject line.
