<?php
##### LICENSE
##### Public domain.
##### Use, reproduction, adaptation, and distribution of this php script 
##### and included web content have no known restrictions.

##### DESCRIPTION
##### It is based on the html 'newhelpindex.html' page by Keith Refson
##### distributed with teTeX 1.0 and 2.0 and possibly changed by 
##### Thomas Esser.
##### Additional material for 
##### teTeX 2.0, 2.96, ..., 3.x and php code by Joao P Matos
##### with additional changes by Thomas Esser.
##### The php code is basically the checkurl function below, a redirect script
##### and the building of a search form. It is intended mainly as a way to 
##### simplify maintenance and allowing merges of local material.
##### The checkurl function tries to guess the best possible documentation 
##### file from the possibilities available in $TEXMF, $TEXMFDIST and 
##### $TEXMFLOCAL and tries to allow for format changes between teTeX releases.
##### Broken links due to changes in the underlying texmf trees should appear 
##### in red.

##### REQUESTS
##### You are under no obligation to abide by these requests but the maintainer
##### would appreciate that:
##### -- any changes to the script follow the original idea
#####    of providing either the unaltered teTeX documentation or
#####    the teTeX documentation plus clearly marked local documentation;
##### -- submit your suggestions for improving the script and content.

##### TO DO
##### -- when generating the static html version pass texdoc=no in the URL;
#####    there is no static version of the php texdoc emulator;
#####    a good and simple automated way to create it is needed.
##### -- perhaps checkurl should deal with directories better; if a directory 
#####    exists in several trees, links to all should appear.
##### -- it is reasonable to assume that in non local mode (local=no) 
#####    a non existing file in distribution
#####    or build trees, but available in the local tree, might appear 
#####    with a red link to the local tree; this would break generating 
#####    the html version unless it is a non default otpion.


##### Tested on PHP 4.3.4 and later.

##### 
error_reporting(1);

##### CUSTOMIZING THE SEARCH FORM
##### Search form data; redefine in $our_conf (see below) 
##### keeping the 3 arrays with identical indices
##### and don't forget to put $form_script="" so that this script
##### submits to itself instead of using lcr.math.ist.utl.pt
##### 


##### $query contains URLs before the search string
$query = array (
		  "catalogue" => "http://www.ctan.org/tools/cataloguesearch?preferredCTAN=dante.de&action=/search/&catstring=",
		  "faq" => "http://www.tex.ac.uk/cgi-bin/texfaq2html?keyword=",
		  "ctan" => "http://www.ctan.org/tools/filesearch?preferredCTAN=dante.de&action=/search/&filename=",
		  "latexproject" => "http://www.latex-project.org/search.html?q=",
                  "pragma" => "http://www.google.com/search?q=",
		  "tug" => "http://www.tug.org/cgi-bin/htsearch?words=",
		  "ctt" => "http://www.google.com/groups?as_epq=",
      "cambridge" => "http://www-h.eng.cam.ac.uk/cgi-bin/latexsearch.pl?query=",
      "loria" => "http://ctan.loria.fr/cgi-bin/htsearch?config=lat-nav&restrict=&exclude=&words="
      );
##### $pquery contains URLs after the search string so that some queries
##### look their usual self; just for looks
$pquery = array (
		   "catalogue" => "",
		   "faq" => "",
		   "ctan" => "",
		   "latexproject" => "",
                   "pragma" => "+site:www.pragma-ade.com",
		   "tug" => "",
		   "ctt" => "&as_ugroup=comp.text.tex",
		   "cambridge" => "&results=25",
                   "loria" => ""
		   );
##### Data for the menu in the form
$metabusca = array (
		    "ctan" => "CTAN files",
		    "latexproject" => "LaTeX project",
                    "pragma" => "PRAGMA (ConTeXt)",
		    "tug" => "TeX User's Group",
		    "catalogue" => "Catalogue",
		    "ctt" => "comp.text.tex",
		    "faq" => "UK TeX FAQ",
		    "cambridge" => "Cambridge",
                    "loria" => "LaTeX Navigator"
		    );
##### Handle query redirecting if this script has submitted data to itself
##### This needs $form_script="" below or in $our_conf
##### We take care of this now due to redirecting header
##### and immediately exit

##### Are we searching?
$searchdefault=$_POST['searchdefault'];
$SelectSearch=$_POST['SelectSearch'];
if (! $searchdefault or ! $SelectSearch)
{
  $searchdefault == 'false';
  $SelectSearch == "";
}
##### Remember the choice with a Cookie
if (  $searchdefault == "true" and $SelectSearch <> "" )
{
  SetCookie("teTeXSearch","$SelectSearch",time()+15768000);
}
##### Redirect
if ( $_POST['SelectSearch'] <> "")
{
  if ( $_POST['words'] <> "" )
    {
      $fullquery=$query[$_POST['SelectSearch']] . $_POST['words'] . $pquery[$_POST['SelectSearch']];
      header("Location: " . $fullquery );
      exit;
    }
  else
    {
      echo "<html>Non empty search string required. Please press <b>Back</b> and try again.</html>";
    }
}

############################################################################
##### CUSTOMIZE the following definition for the location of the
##### newhelpindex.conf configuration file
$ourconf="/usr/local/teTeX/share/texmf-local/doc/newhelpindex.conf";
#####################################################################
##### network.php is only used to hide validation buttons at the end of 
##### the document; comment the following line and that section 
##### at the end if needed
include("network.php");
###########################################################################
##### All other configuration should be done in $ourconf except that to add
##### your local information for your host or site you need to
##### look for includes below
##### pointing to $texmflocaldoc . "nhi/somefile.txt"
##### with various possibilities for somefile
##### and go to 
##### http://www.math.ist.utl.pt/tetexbeta/texmf-dist/doc/index.phtml?local=yes
##### to see how that is supposed to work

##### The structure of one of the somefile.txt files
##### used in the example is typically
##### <p>text</p>
##### <p>text</p>
##### ...
##### or
#####
##### <dt>...</dt>
##### <dd>Short description</dd>
##### <dt>...</dt>
##### <dd>Short description</dd>
##### ...
##### 
############################################################################
##### END OF CUSTOMIZATION
############################################################################
##### Default configuration values to be overriden in $ourconf
$texmflocaldoc="/usr/local/teTeX/share/texmf-local/doc/"; # file system location for the documentation in the local texmf tree ($TEXMFLOCAL/doc/)
$texmfdoc="/usr/local/teTeX/share/texmf-dist/doc/"; # file system location for the distribution documentation tree ($TEXMFDIST/doc/)
$texmf2doc="/usr/local/teTeX/share/texmf/doc/"; # file system location for the distribution generated documentation tree ($TEXMF/doc/)
$texmf="/usr/local/teTeX/share/texmf/"; # file system location for the distribution generated tree ($TEXMF/)
$texmfdist="/usr/local/teTeX/share/texmf-dist/"; # file system location for the distribution tree ($TEXMFDIST/)
$urllocaldoc="/texmf-local/doc/"; # if it is empty this makes the URL for the local tree relative to our current url location
#$urldoc="/texmf/doc/";
$urldoc=""; # abbreviated URL for the doc distribution tree ; if it is empty this makes the URL for the distribution tree relative to our current url location
$url2doc="../../texmf/doc/"; # abbreviated URL for the distribution generated tree ; if it is empty this makes the URL for the distribution tree relative to our current url location
$urltexmfdist = "../"; # abbreviated URL for the texmf-dist tree
# If this file resides in the local tree redefine in the configuration file
# to 
# $urltexmfdist = "../../texmf-dist/";
$urltexmf = "../../texmf/"; # abbreviated URL for the texmf tree
$extensions = array(".pdf", ".ps", ".dvi", ".tex", ".txt",".html", ""); # file extension preference
$extensionz = array(".bz2",".gz",""); # compressed file extension preference to be able to regenerate on Debian or other packaged teTeX with compressed docs
$man_info_browsers = array("Konqueror"); # strings identifying browsers with man and info capabilities
# $man_info_browsers = array("Konqueror", "Epiphany"); # Epiphany and yelp seem prone to misconfigurations
$texman = "/usr/local/teTeX/man/"; # the teTeX $MANDIR
#$texman = ""; # this will suppress the man pages section
#$texmanhtml = "/usr/local/teTeX/share/texmf-local/doc/man/"; # the teTeX $MANDIR but in html format (EXPERIMENTAL!)
$texmanhtml = ""; # this will suppress trying to look for the html versions of the man pages (EXPERIMENTAL!)
# $tetexrelease = ""; 
# a + sign means adjustements for an upcoming release;
# this may create a few temporarily broken links or missing files.
$localmaintainer = ""; ##### redefined in newhelpindex.conf for obvious reasons
# Redirect script for the search form
# If left empty this script will query itself
# $form_script = "";
$form_script="http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/tdg.php";
# The full path to kpsewhich; used for *.sty and *.ltx files
$kpsewhich="/usr/local/teTeX/bin/i686-pc-linux-gnu/kpsewhich";
# The full path to the texdoc data file or some other 
# alternative file in the same format
$texdocdat="/usr/local/teTeX/share/texmf-dist/texdoctk/texdoctk.dat";
############################################################################
include($ourconf);
############################################################################
##### Determining $tetexrelease from the distribution
$versionfile = $texmfdist . "release-tetex-texmf.txt" ;
$handle= fopen($versionfile,"rt") ;
##### Due to some strange reason php adds a newline...
$tetexrelease=str_replace("\n","",fread($handle,filesize($versionfile)));
$resread = fclose($handle);


##### Are we going to call ourselves?
if (! $form_script or $form_script == "")
{
  $form_script = basename($_SERVER["SCRIPT_FILENAME"]) ;
}



##### Merge of local material. Default is _not_ merging.
$local="no";
if ( $_GET["local"]=="yes" )
{
  $local="yes";
}
# number of extensions and compression (none counts as one)
$nums = count($extensions);
$numz = count($extensionz); 

##### checktd checks the texdoc database file; 
##### given a package name determines its
##### location according to texdoc and calls checkurl
##### Not used currently as the texdoc database file is too 
##### unpredictable to use during betas.

function checktd($package)
{
  global $mydata;
  return checkurl($mydata[$package]);  
}

##### checkurl generates a string of the form <a href="url" style="css">
##### where css adds some visual formatting for easy detection of broken links
##### If nothing wrong is detected  style="css" is omitted.
##### $file should be a file name with or without extension.
##### The last possibility tries to allow for format changes between 
##### package or tetex versions.


function checkurl($file)
{
  global $urllocaldoc, $urldoc, $url2doc, $texmfdoc , $texmf2doc , $texmflocaldoc , $extensions , $extensionz, $nums, $numz , $local , $texmfdist, $texmf, $urltexmfdist, $urltexmf, $kpsewhich;

  $filenamebits = explode(".", $file);
  $numbits = count($filenamebits);
  $prefix = "<a href=\"";
  $suffix = "\">";
### If the name ends in one of the canonical extensions
### First try the local texmf tree
  if (in_array($filenamebits[$numbits - 1],$extensions))
    {
      $nz=0;
      while ($nz < $numz)
      {
	if ($local=="yes" and file_exists($texmflocaldoc .  $file . $extensionz[$nz] ))
        {
          return $prefix . $urllocaldoc . $file . $extensionz[$nz] . $suffix ;
        }
	$nz++;
      }
### Try the distribution generated texmf tree
      $nz=0;
      while ($nz < $numz)
	{

	  if ( file_exists($texmf2doc .  $file . $extensionz[$nz] ))
	    {
	      return $prefix . $url2doc . $file . $extensionz[$nz]  . $suffix ;
	    }
	  $nz++;
	}
### Try the distribution texmf tree
      $nz=0;
      while ($nz < $numz)
	{

	  if ( file_exists($texmfdoc .  $file . $extensionz[$nz] ))
	    {
	      return $prefix . $urldoc . $file . $extensionz[$nz]  . $suffix ;
	    }
	  $nz++;
	}
### otherwise assume the distribution texmf tree should have contained the file without compression extensions
### (if one gets here the file is not there)
      return $prefix . $urldoc . $file . $suffix;
    }
  else
### If no extension is given
    {
      $j=0;
      while ($j < $numz )
	{
	  $i=0;
	  while ($i < $nums )
### look for the file with one of the extensions in the local texmf tree
	    {
	      if ($local=="yes" and file_exists($texmflocaldoc . $file  . $extensions[$i] . $extensionz[$j]))
		{
		  return $prefix . $urllocaldoc . $file  . $extensions[$i] . $extensionz[$j] . $suffix ;
		}
	      $i++;
	    }
### then without an extension
	  if ($local=="yes" and file_exists($texmflocaldoc . $file . $extensionz[$j]))
	    {
	      return $prefix . $urllocaldoc . $file . $extensionz[$j]  . $suffix ;
	    }
	  $j++;
	}

### Repeat for the distribution generated tree
      $j=0;
      while ($j < $numz )
	{
	  $i=0;

	  while ($i < $nums)
	    {
	      if (file_exists($texmf2doc . $file . $extensions[$i]  .  $extensionz[$j]))
		{
		  return $prefix .  $url2doc . $file  . $extensions[$i] .  $extensionz[$j] . $suffix ;
		}
	      $i++;
	    }
### then without an extension
	  if ($local=="yes" and file_exists($texmf2doc . $file . $extensionz[$j]))
	    {
	      return $prefix . $url2doc . $file . $extensionz[$j]  . $suffix ;
	    }
	  $j++;
	}

### Repeat for the distribution tree
      $j=0;
      while ($j < $numz )
	{
	  $i=0;

	  while ($i < $nums)
	    {
	      if (file_exists($texmfdoc . $file . $extensions[$i]  .  $extensionz[$j]))
		{
		  return $prefix .  $urldoc . $file  . $extensions[$i] .  $extensionz[$j] . $suffix ;
		}
	      $i++;
	    }
### then without an extension
	  if ($local=="yes" and file_exists($texmfdoc . $file . $extensionz[$j]))
	    {
	      return $prefix . $urldoc . $file . $extensionz[$j]  . $suffix ;
	    }
	  $j++;
	}
##### One last ditch effort if it is one of those pesky *.sty or *.ltx files 
##### which is its own documentation; there aren't many so we feel 
##### free to invoke kpsewhich
      if ( $filenamebits[$numbits - 1] == "sty" or $filenamebits[$numbits - 1] == "ltx")
	{
	  $location = exec($kpsewhich . " latex " . $file);
	  if ( trim($location) <> "" )
	    {
	      if ( strpos( $location, $texmfdist) === false )
		{
		  if (  strpos($location,$texmf ) === false )
		    {
		      
		    }
		  else
		    {
		      return $prefix .  str_replace($texmf , $urltexmf, $location)  . $suffix ;
		    }
		}
	      else
		{
		  return $prefix .  str_replace($texmfdist , $urltexmfdist, $location) . $suffix ;
		}
	    }
	}

      ### If all fails give the plainest interpretation which will return
      ### some error
      return $prefix . $urldoc . $file . "\" style=\"color:red;" . $suffix;
    }
}

##### Parse the texdoc data file?

$row = 0;
$numsec=0;

$handle = fopen ($texdocdat,"r");
while ($data[$row] = fgetcsv ($handle, 1000, ";")) 
{
    if ( strpos($data[$row][0],"#") === false )
      {
        if ( count($data[$row]) == 1 )
          {
            $section[$numsec] = str_replace("@", "", $data[$row][0]);
            $numsec=$numsec+1;
          }
        else
          {
            $mydata[$data[$row][0]] = $data[$row][2];
#            $num = count($data[$row]) + 1;
#            print $data[$row][0] . " " .$mydata[$data[$row][0]] . " ";
#            print "<br>\n";
          }
      }
    $row++;
}
fclose ($handle);


##### User agent detection
$browser_user_agent = $_SERVER["HTTP_USER_AGENT"];
#echo $browser_user_agent;
$num_browsers = count($man_info_browsers);
$nb=0;
$mancapable=FALSE;
$infocapable=FALSE;
while ($nb < $num_browsers)
{
  if ( strstr($browser_user_agent,$man_info_browsers[$nb]))
    {
      $mancapable=TRUE;
      $infocapable=TRUE;
      break;
    }
  $nb++;
}



?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html lang="en">
<!--
##### LICENSE:
##### Public domain.
##### Use, reproduction, adaptation, and distribution of this web page 
##### have no known restrictions.

##### It is based on the html page distributed with teTeX 1.0 by Keith Refson
##### possibly changed by Thomas Esser for teTeX 2.0.x.
##### Maintainer for teTeX 3.0: Joao P Matos.
##### Additional changes by Thomas Esser.
##### This is based on a php script used for merging the 
##### distribution and local teTeX doc trees information at
##### http://lcr.math.ist.utl.pt/tetex/texmf-local/doc/index.phtml
#####
##### Please refer any feedback to the teTeX pretest 
##### (http://www.mail-archive.com/tetex-pretest@informatik.uni-hannover.de/)
##### mailing list.
#####
##### The html prototype for inclusion in teTeX can be obtained as
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.phtml
#####
##### The html version included in the latest teTeX beta installed
##### at math.ist.utl.pt can be obtained as
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.html
##### 
##### The output of the php version included in the latest teTeX(beta)
##### is available as
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.php
#####
##### The current version of the php script generating the html prototype is
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.txt
##### or (with fancy formatting if you just want to look at the code)
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.phps
##### It will be included in teTeX 3 allowing to serve this
##### documentation and local material to a small network or just to one host
##### To understand the idea compare:

##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.phtml
##### http://lcr.math.ist.utl.pt/tetex-beta/texmf-dist/doc/index.phtml?local=yes
##### Check the dates at the bottom of the *html pages to the identify the
##### latest version.

##### -------------------------------------
##### To serve this page and the teTeX documentation through http you need 
##### to enable directory indexes in the corresponding tree on your web server 
##### as some of the links point to directories. 
##### Also, if you plan on serving the php script itself you need to make sure
##### that files with the extension you choose for php parsed 
##### scripts (.php, .phtml,...) are indeed parsed as php.
##### Adaptation of php.ini and a sufficiently recent version of PHP 
##### may also be necessary.

-->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<title>Guide to teTeX Documentation</title>
<style type="text/css">
       a:link { color: #0000ee }
       a:visited { color: #001a8b }
       a:active { color: #ff0000 ; background: #ffffcc}
       p,dd,li {font-family: Times, Palatino, serif;}
       h1,h2,h3,h4,table { font-family: "bitstream vera sans", Verdana, Helvetica, Arial, sans-serif; }
       dt {font-family: courier,monospaced; }
       table { font-size: x-small;}
       option { font-size:10pt; color:blue; }
       .local {
	 <?php
	     if ($local == "no")
	       {
		 echo "display: none;";
	       }
	     else
	       {
		 echo "
            background: rgb(100,255,255);
            ";
	       }
	   ?>
	     }
       body *:target {color: red;}
</style>
</head>

<body link="#CC0000" vlink="#0000FF" bgcolor="#FFFFFF">

<?php
       echo "<table width=\"100%\" cellpadding=\"20\"><tr><td><h1><img src=\"tetex.png\" alt=\"teTeX\">Documentation&nbsp;Guide</h1></td><td style=\"font-size:small; vertical-align: middle; border:outset ; border-color:blue; \" align=\"center\">";

##### Build the search form
if ( $SelectSearch == "" and $_COOKIE['teTeXSearch'] <> "")
{
  $SelectSearch = $_COOKIE['teTeXSearch'];
}

$titulo_busca = "Choose search type";
$conteudo_busca = "Enter your search terms";
echo "<form method=\"post\"  style=\"display: inline; \" action=\"" . $form_script . "\">";
?>

<p style="font-family: Arial,Helvetica,sans-serif">Search&nbsp;
<select style=" font-family: Arial,Helvetica,sans-serif; color:blue" name="SelectSearch" size="1" title="<?php echo $titulo_busca ?>">
<?php
reset($metabusca);
while (list($key,$val) = each($metabusca))
{
  echo "<option ";
  if ( $SelectSearch == $key )
    {
      echo "selected=\"selected\"";
    }
  echo " value=\"" . $key . "\" >" . $val . "</option>\n";
}
?>
</select></p>
<p style="font-family: Arial,Helvetica,sans-serif">for&nbsp;
<input style="font-family: Arial,Helvetica,sans-serif; color:blue" type="text" size="20" name="words" value="" title="<?php echo $conteudo_busca ?>" /></p>
<p>
<input style="font-family: Arial,Helvetica,sans-serif; color:blue" type="submit" value="Search"/>
<input type="hidden" name="searchdefault" value="true" /></p>

</form>
</td></tr></table><br/><br/>


<table style="border:outset; border-color:blue"  cellpadding="5pt" align="center" width="80%" border="1"><tr><th><a href="#features">Features and News</a></th><th><a href="#web2c">Web2c and configuration</a></th><th><a href="#newprogs">TeX variants</a></th><th><a href="#guides">Guides</a></th><th><a href="#graphics">Graphics</a></th><th><a href="#diagrams">Diagrams</a></th><th><a href="#packages">LaTeX packages</a></th><th><a href="#ancillary">Ancillary programs</a></th><?php if ($texman <> "") echo "<th><a href=\"#man\">Man pages</a></th>"; ?><th><a href="#more">More...</a></th><?php if ($local<> "no") echo "<th class=\"local\"><a href=\"#local\">Local additions</a></th>"; ?></tr>
</table>
<p>This page is an attempt at a guided tour around the TeX and LaTeX documentation which is<?php if ($local<> "no") echo " either"; ?> distributed with teTeX<?php if ($local<> "no") echo " (white background) <a class=\"local\"> or has been added or updated locally (light blue background)</a>"; ?>.</p>

<p>teTeX is a unix TeX and LaTeX system assembled by Thomas Esser since <a href="http://tinyurl.com/6de5k">1994</a>. Its home page is located at <a href="http://www.tug.org/tetex/">http://www.tug.org/tetex/</a>. The <?php echo checkurl("tetex/TETEXDOC") ; ?><em>teTeX Manual</em></a> is the main reference for teTeX specific information including configuration. A few notes on teTeX configuration are available below but are not intended to replace the manual.</p>

<?php 
if ($local<>"no") 
{
  echo "<p class=\"local\">The locally installed teTeX version is <em>" . $tetexrelease . "</em>"; 
  if (strstr($tetexrelease, "+"))
  {
    echo " (a <em>+</em> sign means adjustements for an upcoming release have been made; this may result in broken links)"; 
  }
  echo ". Queries and requests about local additions should be addressed to <tt><a href=\"mailto:" . $localmaintainer . "\">" . $localmaintainer . "</a></tt>.</p>"; 
}
?>

<p>Queries about installing and maintaining the teTeX installation itself should be directed to the <em>teTeX mailing list</em>: (see the <a href="http://www.tug.org/tetex/">teTeX Homepage</a> for instructions) - but check the <?php echo checkurl("tetex/teTeX-FAQ"); ?>frequently-asked questions</a> list first. Questions about <em>using</em> LaTeX, TeX, etc., are best posted to the usenet newsgroup <tt><a href="news:comp.text.tex">comp.text.tex</a></tt> where they will receive attention from a worldwide readership.</p>

<p>The documentation available through this page is provided as either plain text, html or in one of the 3 common formats for TeX related output described in the table below. Note that only the <tt>xdvi*</tt> software is distributed with teTeX.</p>

<table align="center" width="70%" border="1">
<tr>
<th>File suffix</th><th>Format name</th>
<th>Viewers</th>
</tr>
<tr>
<td>*.dvi</td>
<td><b>D</b>e<b>v</b>ice <b>I</b>ndependent</td>
<td><em><a href="http://math.berkeley.edu/~vojta/xdvi.html">xdvi</a></em>, <em><a href="http://sourceforge.net/projects/xdvi">xdvik</a></em>, <em><a href="http://www.kde.org/">kdvi</a></em>,...</td></tr><tr><td>*.ps</td>
<td><b>P</b>ost<b>S</b>cript</td><td><a href="http://www.cs.wisc.edu/~ghost/gv/index.htm"><em>ghostview</em>, <em>gv</em></a>, <em><a href="http://www.gnome.org/">ggv</a></em>, <em><a href="http://www.kde.org/">kghostview</a></em>,...</td>
</tr>
<tr>
<td>*.pdf</td>
<td><b>P</b>ortable <b>D</b>ocument <b>F</b>ormat</td>
<td><a href="http://www.adobe.com"><em>Acrobat Reader (acroread)</em></a>, <a href="http://www.foolabs.com/xpdf/"><em>xpdf</em></a>, <em><a href="http://www.gnome.org/">ggv</a></em>, <em><a href="http://www.kde.org/">kdf</a></em>,...</td>
</tr>
</table>
<p>All these file types may be viewed from a properly configured web browser such as those from the <a href="http://www.mozilla.org/">Mozilla</a> family (with appropriate plugins such as <a href="http://mozplugger.mozdev.org/">MozPlugger</a>, the Acrobat Reader plugin,...), or <a href="http://konqueror.kde.org/">Konqueror</a>, or ... Most of the original LaTeX sources can be found in the documentation tree which is rooted at <tt>$TEXMFDIST/doc</tt> or <tt>$TEXMFLOCAL/doc</tt>.</p>
<p>teTeX makes available the traditional <kbd>man</kbd> and <kbd>info</kbd> pages. The former are listed in the <a href="#man">man pages</a> section below.</p>
<p>Other interfaces to documentation include the <code><?php if ($mancapable)
{
  echo  "<a href=\"man:texdoc\">texdoc</a>";
}
else
{
  echo "texdoc";
} ?></code> and <code><?php if ($mancapable)
{
  echo  "<a href=\"man:texdoctk\">texdoctk</a>";
}
else
{
  echo "texdoctk";
} 
if ($local == "no")
     {
       $texdocurl = "texdoc.php?local=no";
     }
else
     {
       $texdocurl = "texdoc.php";
     }
?></code> tools. 
<?php 

if (! $_GET['texdoc'] or $_GET['texdoc'] == "php" or $_GET['texdoc'] == "" ) 
{
##### Defaults for the link to the texdoc emulator
  echo "A <a href=\"" . $texdocurl . "\">php texdoc emulator</a> is available.</p>\n";
}
elseif ( $_GET['texdoc'] == "html" )
{
##### Link to the static version of the texdoc emulator (NOT YET AVAILABLE!)
  echo "A <a href=\"texdoc.html\">set of static html files</a> emulating texdoc is available.</p>\n";
}
##### With all other values of $_GET['texdoc'] no link will show up.
##### Use texdoc=no to create the static version.
?>
<p>Note that teTeX does <b>not</b> contain a graphical interface for editing and processing *.tex documents. Choices in a unix environment for this include (<a href="http://www.xemacs.org">x</a>)<a href="http://www.gnu.org/software/emacs/emacs.html">emacs</a> (with <a href="http://www.gnu.org/software/auctex/">auctex</a> or <a href="http://preview-latex.sourceforge.net/">preview-latex</a>), <a href="http://kile.sourceforge.net/">kile</a>, <a href="http://nedit.gmxhome.de/">nedit</a> and its LaTeX mode, <a href="http://vim-latex.sourceforge.net/">vim</a>,...</p>


<?php if ($local<>"no") echo "<p class=\"local\">The document you are reading updates the version distributed with teTeX and merges additional or local information where appropriate. If you do not want to see the local additions access it using <a href=\"index.phtml?local=no\">index.phtml?local=no</a>.</p>"; ?>

<h2><a name="features">Main features in the <?php echo $tetexrelease; ?> release</a></h2>
<ul>
<li>teTeX is <a href="http://www.fsf.org/philosophy/free-sw.html">free software</a>.</li>
<li>Included programs: web2c, xdvik, dvipsk, texinfo, pdfetex, Omega,
		       dvipng, aleph, dviljk, ps2pk, makeindex,
  texconfig, fmtutil, updmap, texdoc, texdoctk.</li>
<li>TDS (TeX Directory Structure) compliant support tree
  with fonts / macros / documentation: 226 MB, &gt;13000 files.</li>
<li>Updated texmf tree with many updated or added packages. Most
  notably: LaTeX2e, ConTeXt, Latin Modern
  fonts, beamer, koma-script and memoir package.</li>
<li>Easy to install and to customize, even for a multi-platform setup.</li>
<li>Ready for producing resolution independent (bitmap free) postscript or
  pdf documents (including thumbnails, hyperlinks and bookmarks).</li>
</ul>

<h2>What is new in <?php echo $tetexrelease; ?>?</h2>
<ul>
<li><b>Updated programs</b>: web2c 7.5.4, xdvik 22.84.9, dvipsk 5.95a, texinfo 4.8, pdfetex 1.21a (based on TeX-3.141592 and eTeX-2.2), Omega 1.23.2.3, dviljk 2.6p2, ps2pk 1.5, makeindex 2.14, texi2html 1.76, texconfig, fmtutil, updmap, texdoc, texdoctk v0.6.0a.</li>
<li><b>Restructured texmf trees</b>: cached runtime data or updated configuration files are no longer mixed with the distributed tree.</li>
<li><b>Added programs</b>: dvipng 1.5 (convert dvi -> png) and aleph 3.141592-1.15-2.1-0.0-rc4 (combines a stable omega version with features of eTeX).</li>
<li><b>Updated texmf tree</b>: LaTeX2e <2003/12/01>, ConTeXt version 2005.01.31, Latin Modern fonts, beamer, memoir, and many others.</li>
<li><b>TDS</b>: the distributed texmf tree was rearranged to follow revision 1.1 of the TDS.</li>
<li><b>Default engine</b>: pdfetex is now the default engine used for most formats (including latex).</li>
<li><b>Multi-user</b>: texconfig / updmap / fmtutil can now be used in a multi-user environment.</li>
</ul>
<p>Refer to the <?php echo checkurl("tetex/TETEXDOC") ; ?><em>teTeX Manual</em></a> for further details.
</p>
<h2><a name="features2">Main features in the 2.0 release</a></h2>
<ul>
<li>included files reviewed for license problems; teTeX now is free software!</li>
<li>program packages: web2c 7.4.5, pdfTeX 1.10a, e-TeX 2.1,  Omega 1.23.2.1, xdvik 22.40v, dvipsk 5.92b, dviljk 2.6p2, dvipdfm 0.13.2c, ps2pk 1.5, makeindex 2.14, texinfo 4.4, texconfig 2.0, updmap 2.0, texdoctk.</li>
<li>main TeX formats:
  plain.tex 3.14159265, LaTeX2e &lt;2001/06/01&gt;, ConTeXt 2003.1.31</li>
<li>TDS (TeX Directory Structure) compliant support tree
  with fonts / macros / documentation: 150 MB, &gt;11000 files</li>
<li>easy to install and to customize, even for a multi-platform setup
ready for producing resolution independent (bitmap free) postscript or
pdf documents (including thumbnails, hyperlinks and bookmarks)</li>
</ul>

<h2><a name="news2">What else was new in teT<sub>E</sub>X 2</a></h2>
<ul>
<li>The <a href="http://gaspra.kettering.edu/dvipdfm/">dvipdfm</a> application by Mark A. Wicks</li>
<li> The command <kbd>texdoc</kbd> <em>[package-name]</em> will attempt to display documentation for that package from the shell command line.</li>
<li>pazo and tx/px fonts added (to supplement times / palatino).</li>
<li>Many fonts and macro packages updated or added, e.g., <i>pdfpages</i> or <i><a href="#framed">framed</a></i>.</li>
</ul>

<h2>What was new in teT<sub>E</sub>X 1</h2>
    <ul>
      <li>New TeX-like programs, <a href="#newprogs">e-tex, omega,
	  pdftex</a> and their LaTeX variants.</li>
      <li>New format <a href="#newprogs">ConTeXt</a>.</li>
      <li>Computer Modern fonts in Adobe Postscript Type 1 form (courtesy
	of Blue Sky Research.) See the entry for <a href="#dvips">dvips</a>.</li>
      <li>Based on Web2C 7.3.  This allows the size of TeX&rsquo;s tables to
	be set in the configuration file <code>texmf.cnf</code> and easily adjusted.</li>
      <li>Updated release of LaTeX and many of its packages.</li>
      <li>Xdvi is now hypertext-capable. Especially useful in
	conjunction with the new <a href="#hyperref">hyperref</a>
	package.</li>
      <li>Many new packages including <a href="#bm">bm</a>,
	<a href="#colortbl">colortbl</a>,
	<a href="#fancyvrb">fancyvrb</a>, <a href="#hyperref">hyperref</a>,
	<a href="#picins">picins</a>, <a
	  href="#sidecap">sidecap</a>, <a href="#footmisc">footmisc</a>, and
	the <a href="#mdwtools">MDW tools</a> (at, cmtt, doafter, mathenv,...).</li>
      <li>T2 font encoding, support for <a href="#cyrillic">Cyrillic</a> and LH fonts.</li>
      <li>Better support for <a name="newfonts">installing new fonts</a>.</li>
    </ul>

<h2><a name="web2c">Web2c and configuration</a></h2>

<p>teTeX is based on the <em>web2c</em>
implementation of TeX, metafont, etc.
Information on running the various programs is contained in 
<?php echo checkurl("programs/web2c.pdf"); ?>web2c.pdf</a>. 
All programs use a common, configurable, library for searching for 
files. The file 
<?php echo checkurl("programs/kpathsea.pdf"); ?>kpathsea.pdf</a> 
gives details. Data file system trees for tex, metafont and related programs (texmf trees) in teTeX are structured according to the 
<em><?php echo checkurl("help/tds"); ?>TeX Directory 
Structure (TDS)</a></em>. Available texmf trees, their location and 
purpose are set in the web2c configuration file <code><a href="../../texmf/web2c/texmf.cnf">texmf.cnf</a></code> and described there and in the <?php echo checkurl("tetex/TETEXDOC") ; ?>manual</a>.</p>

<p>Configuration options in teTeX can be set system-wide using the <code><?php if ($mancapable) echo "<a href=\"man:texconfig\">" ?>texconfig-sys<?php if ($mancapable) echo "</a>" ?></code> utility, or at the user level by <code><?php if ($mancapable) echo "<a href=\"man:texconfig\">" ?>texconfig<?php if ($mancapable) echo "</a>" ?></code>. This <code>*-sys</code> convention is also followed for created map files (<code><?php if ($mancapable) echo "<a href=\"man:udpmap\">" ?>udpmap<?php if ($mancapable) echo "</a>" ?></code>) and format files (<code><?php if ($mancapable) echo "<a href=\"man:texconfig\">" ?>fmtutil<?php if ($mancapable) echo "</a>" ?></code>). Files created by these utilities are stored in the appropriate texmf tree.</p>

<p>To speed up file search file name databases named <code>ls-R</code> are used. They are located at the root of each texmf tree and need to be updated with the <code>texhash</code> command after the addition of files to the texmf trees except in the cases of automatic font generation or when using <code>texconfig</code>.</p>


<h2><a name="newprogs">TeX and its variants</a></h2>
<table style="border:outset; border-color:blue" cellpadding="5pt" align="center" width="80%" border="1">
<tr>
<th><a href="#tex">TeX</a></th>
<th><a href="#enctex">encTeX</a></th>
<th><a href="#plain">plain TeX</a></th>
<th><a href="#eplain">eplain</a></th>
<th><a href="#latex">LaTeX</a></th>
<th><a href="#pdftex">PDFTeX and PDFLaTeX</a></th>
<th><a href="#omega">Omega and Lambda</a></th>
<th><a href="#etex">ETex and ELaTeX</a></th>
<th><a href="#aleph">Aleph</a></th>
<th><a href="#context">ConTeXt</a></th>
</tr>
</table>
    <p>This distribution includes the classical <em>plain</em> and <em>LaTeX</em> macro packages as well as several more recent developments of TeX (and LaTeX).</p>
<h3><a name="tex"><strong>TeX</strong></a></h3>
<p>The original TeX described in the <cite>TeXbook</cite> by Donald E. Knuth.</p>
<h3 id="enctex"><?php echo checkurl("generic/enctex/encdoc-e"); ?>encTeX</a></h3>
<p>A backwards compatible extension to the original TeX allowing UTF-8 processing in 8-bit TeX.</p>
<h3><a name="plain"><strong>plain</strong> TeX</a></h3>
<p>The format described in the <cite>TeXbook</cite>.</p>
      <h3 id="eplain"><a href="http://www.ccs.neu.edu/home/dorai/eplain/">Eplain</a></h3>
      <p><?php echo checkurl("eplain/eplain"); ?>Eplain</a> is an extended version of plain TeX format.</p>
    <h3><a name="latex"><strong>LaTeX</strong></a></h3>
<p>The extremely popular macro package originally by Leslie Lamport and described in <cite><a href="http://www.awprofessional.com/titles/0201529831">LaTeX, a document preparation system (2<sup>nd</sup> edition) </a></cite>. Currently LaTeX is developed by the <a href="http://www.latex-project.org/">LaTeX project</a> which has recently updated its description of additional capabilities in the <a href="http://www.awprofessional.com/titles/0201362996"><cite>LaTeX Companion (2<sup>nd</sup> edition)</cite></a>. Most entries below deal with LaTeX functionality.</p>
    <h3><a name="pdftex"><strong>PDFTeX</strong> and <strong>PDFLaTeX</strong></a></h3>
<p>Han The Thanh&rsquo;s TeX variant which can generate output in Adobe PDF
	format.  Documentation is in the 
        <?php echo checkurl("pdftex/manual/pdftex-a"); ?>PDFTeX manual</a>.    
<h3><a name="omega"><strong>Omega</strong> and <strong>Lambda</strong></a></h3>
<p>The <?php echo checkurl("omega/base/doc-1.12"); ?>Omega</a> 
system and the corresponding LaTeX format Lambda extend TeX for mixed multi-lingual typesetting using unicode. See the <a href="http://omega.enstb.org/">omega home page</a>.</p>
<h3><a name="etex"><strong>ETeX</strong> and <strong>ELaTeX</strong></a></h3>
<p><?php echo checkurl("etex/base/etex-man"); ?>e-TeX</a> adds several extensions
           to TeX notably right-to-left typesetting.</p>
<h3><a name="aleph">Aleph</a></h3>
<p>The <a href="http://www.tex.ac.uk/cgi-bin/texfaq2html?label=aleph">Aleph</a> project aims to build a &quot;usable&quot; version of Omega, incorporating ETeX extensions.</p>
<h3><a name="context">ConTeXt</a></h3>
<p>A relatively recent macro package for TeX by Hans Hagen. A ConTeXt specific package is included: <?php echo checkurl("context/ppchtex/mp-ch-en"); ?>PPCH<sub>TEX</sub></a> which allows typesetting chemical structure-formulas.</p>


    <h2><a name="guides">Guides</a></h2>

    <p>Useful information in a questions and answers format is provided by the UK TeX users group <?php echo checkurl("help/faq/uktug-faq/index.html") ; ?>Frequently Asked Questions</a> list.</p>

    <h3>LaTeX guides</h3>

    <p>LaTeX2e is the recommended version of LaTeX, and the older version LaTeX 2.09 is obsolete.  If you know LaTeX2.09 read about <?php echo checkurl("latex/base/usrguide") ; ?>LaTeX2e vs LaTeX2.09</a> and why you should switch. There is one manual describing the LaTeX language itself, which may at a pinch substitute for a book, the <em><?php echo checkurl("latex/general/lshort") ; ?>Not so short Introduction to LaTeX2e</a></em>. There is also a <?php echo checkurl("latex/tex-refs/latex") ; ?>full reference manual</a> of LaTeX2e commands -- ideal for looking up a particular piece of formatting while writing a document (also available in <?php echo checkurl("latex/general/latex2e") ; ?>dvi</a> format) and a table of <?php echo checkurl("latex/general/symbols") ; ?>available mathematical symbols</a>. Either new or old users of LaTeX 2e should benefit from checking the <em><?php echo checkurl("latex/general/l2tabuen") ; ?>Dos and don&rsquo;ts of LaTeX 2e</a></em>.</p>

    <p>Most LaTeX books refer to a <em>local guide</em> to describe operating-system and implementation-dependent aspects, notably the commands to invoke LaTeX and how to preview and print documents. The document <em><?php echo checkurl("latex/general/guide.dvi") ; ?>Running LaTeX and utilities on a Unix system</a></em> (also in <?php echo checkurl("latex/general/guide.ps") ; ?>PostScript</a> form) is a good introduction to most of these topics.</p>

    <p>There are <em>errata lists</em> available for two well-known books, the <?php echo checkurl("latex/base/manual.err") ; ?><em>LaTeX Book</em></a> and the <em>LaTeX Companion</em> <?php echo checkurl("latex/base/compan.err") ; ?>(1st edition)</a> <a href="http://www.latex-project.org/guides/tlc2.err">(2nd edition)</a>.</p>

<p>The LaTeX project maintains a <a href="http://www.latex-project.org/guides/">documentation page</a> listing guides available through the web or in book form.</p>

<h3>ConTeXt guides</h3>

<p>teTeX includes a few ConTeXt guides: the main <?php echo checkurl("context/manual/cont-eni.pdf"); ?>ConTeXt manual</a>, a <?php echo checkurl("context/base/mreadme"); ?>readme</a> document, an <?php echo checkurl("context/base/minstall"); ?>installation guide</a> with information on the command line interface <code>texexec</code>, <?php echo checkurl("context/base/mtexexec"); ?>additional information on texexec</a>, an <?php echo checkurl("context/base/ms-cb-en"); ?>introductory document</a> and a <?php echo checkurl("context/base/setup-en"); ?>full list of commands</a>. Further documentation on ConTeXt is available from the <a href="http://www.pragma-ade.com/">PRAGMA</a> site.</p>

<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/guides.txt");
?>
<h2><a name="graphics">Graphics and Colour</a></h2> 
<p>A very common requirement is to include some kind of graphics as an external file (usually PostScript) into a LaTeX document.  The definitive manual on how to do this is Keith Reckdahl&rsquo;s excellent <em><?php echo checkurl("latex/graphics/epslatex") ; ?>Using imported graphics in LaTeX2e</a></em>. The document <em><?php echo checkurl("latex/graphics/grfguide") ; ?>Packages in the &lsquo;graphics&rsquo; bundle</a></em> is the documentation on the recommended LaTeX2e <em>graphics</em> package, which includes information on how to use colours in the output.</p>


<p>Other graphics related packages include:</p>
<dl>
<dt><?php echo checkurl("latex/psfrag/pfgguide") ; ?>psfrag</a></dt>
<dd>
Allows importing PostScript figures from any other package, but use LaTeX&rsquo;s power for all of the mathematical and textual annotations.  (But note that <tt>
<?php
if ($mancapable)
{
  echo  "<a href=\"man:xfig\">xfig</a>";
}
else
{
  echo "xfig";
}
?>
</tt> allows you to do this anyway).
</dd>
<dt>
<?php echo checkurl("generic/tex-ps/poligraf/README") ; ?>poligraf</a>
</dt>
<dd>Provides preparation of pages for prepress, color separation, cropmarks, color and gray scale bars, and mirror print. <?php echo checkurl("generic/tex-ps/poligraf/samplelx") ; ?>An example for LaTeX</a> and <?php echo checkurl("generic/tex-ps/poligraf/sample") ; ?>an example for plain</a> are available.
</dd>
<dt>
<?php echo checkurl("latex/preview/preview") ; ?>preview</a>
</dt>
<dd>
This package is used by <a href="http://preview-latex.sourceforge.net/">preview-latex</a> for (x)emacs. It allows to produce tight (meaning with correct bounding box) eps images of typeset fragments like displayed formulas.
</dd>
<dt>
<?php echo checkurl("latex/ps4pdf/README") ; ?>ps4pdf</a>
</dt>
<dd>
A new way of dealing with Postscript commands (e.g. PSTricks graphics, PSfrag replacements, EPS graphics) inside pdflatex documents. See the <?php echo checkurl("latex/ps4pdf/ps4pdf-test.tex") ?>test file</a>.
</dd>
<dt>
<?php echo checkurl("latex/xcolor/xcolor") ; ?>xcolor</a>
</dt>
<dd>
Allows a user to select a document-wide target color model and offers tools for conversion between color models.
</dd>
<dt>
<?php echo checkurl("epstopdf.sty") ; ?>epstopdf.sty</a>
</dt>
<dd>
PDF output through pdftex and the graphicx (or graphics) package implies graphics inclusions as <tt>*.pdf</tt> files (or other formats but not <tt>.eps</tt>). A change in output format normally implies using the <tt>epstopdf</tt> program to convert graphics inclusions. You may find the epstopdf style convenient as it automates such a procedure.
</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/graphics.txt");
?>
</dl>


<h2><a name="diagrams">Graph and Diagram Drawing</a></h2>

<p>Probably the best way to draw a simple diagram is to use the <em>
<?php
if ($mancapable)
{
  echo  "<a href=\"man:xfig\">xfig</a>";
}
else
{
  echo "xfig";
}
?>
</em> program (see the unix man page for details). However
there are programmatic ways for more sophisticated work.  These include:</p>
<dl>
   <dt><?php echo checkurl("latex/eepic/eepic") ; ?>eepic</a></dt>
   <dd>A macro package for a much enhanced LaTeX &quot;picture mode&quot;. Requires driver support for tpic <kbd>\special</kbd>s.  Some drawing programs such as <em>
<?php
if ($mancapable)
{
  echo  "<a href=\"man:xfig\">xfig</a>";
}
else
{
  echo "xfig";
}
?>
</em> can write their output as <b>eepic</b> macros.</dd>
   <dt><?php echo checkurl("latex/pict2e/pict2e") ; ?>pict2e</a></dt>
   <dd>A redefinition of commands in the picture environment 
</dd>
   <dt><?php echo checkurl("latex/curves/curves") ; ?>curves</a></dt>
   <dd>An enhancement of LaTeX&rsquo;s picture mode to improve curve drawing.</dd>
   <dt><?php echo checkurl("generic/xypic/xyguide.pdf") ; ?>xypic</a></dt>
   <dd>there is also a <?php echo checkurl("generic/xypic/xyrefer.pdf") ; ?>reference manual</a>.</dd>
   <dt><?php echo checkurl("generic/texdraw/texdraw") ; ?>texdraw</a></dt>
   <dd>There are examples in the directory <?php echo checkurl("generic/texdraw/") ; ?>generic/texdraw/</a>.</dd>
   <dt><?php echo checkurl("latex/carlisle/pspicture") ; ?>pspicture</a></dt>
   <dd>Extend LaTeX <kbd>picture</kbd> drawing environment using PostScript \specials.</dd>
   <dt><?php echo checkurl("multibox.sty") ; ?>multibox</a></dt>
   <dd>Multiple boxes in pictures.</dd>   
   <dt>Pstricks</dt>
   <dd>a set of macros for performing fancy twiddles
       using PostScript, such as drawing of geometrical objects, diagrams,
       fancy boxes, grayscales, etc. There is a <em>User Guide</em> (
       <?php echo checkurl("generic/pstricks/obsolete/pst-usr1") ; ?>part 1</a>,
       <?php echo checkurl("generic/pstricks/obsolete/pst-usr2") ; ?>part 2</a>,
       <?php echo checkurl("generic/pstricks/obsolete/pst-usr3") ; ?>part 3</a>,
       <?php echo checkurl("generic/pstricks/obsolete/pst-usr4") ; ?>part 4</a>),
       a <?php echo checkurl("generic/pstricks/obsolete/pst-quik") ; ?>quick
       reference</a> card, and lots of documentation in the <?php echo checkurl("generic/pstricks/") ; ?>doc/generic/pstricks</a> directory. Documents inside the <tt>obsolete</tt> directory, including the manual and reference card, are indeed obsolete but still useful. See also the Pstricks web pages by <a href="http://www.tug.org/applications/PSTricks/">Denis Girou</a> and <a href="http://pstricks.de/">Herbert Voss</a>. Several additions to Pstricks are available:
       <dl>
       <dt><?php echo checkurl("generic/pstricks/pstricks-add-doc") ?>pstricks-add</a></dt>
       <dd>Various additions to the Pstricks macros.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-3dplot-doc") ?>pst-3dplot</a></dt>
       <dd>3d plotting.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-gr3d") ?>pst-gr3d</a></dt>
       <dd>3d grids.</dd>
       <dt><?php echo checkurl("generic/pstricks/vue3d-e") ?>pst-vue3d</a></dt>
       <dd>3d views.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-blur") ?>pst-blur</a></dt>
       <dd>Blurred shadows.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-circ-doc") ?>pst-circ</a></dt>
       <dd>Electric circuits.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-fill-doc") ?>pst-fill</a></dt>
       <dd>Filling and tiling.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-lens") ?>pst-lens</a></dt>
       <dd>Simulating a lens over a graphic.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-math") ?>pst-math</a></dt>
       <dd>Extra mathematical functions.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-osci") ?>pst-osci</a></dt>
       <dd>Oscilloscope screenshots.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-poly") ?>pst-poly</a></dt>
       <dd>Polygonal shapes.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-slpe") ?>pst-slpe</a></dt>
       <dd>Color gradient extensions.</dd>
       <dt><?php echo checkurl("generic/pstricks/pst-uml-doc") ?>pst-uml</a></dt>
       <dd>UML diagrams.</dd>
       <dt><?php echo checkurl("generic/pstricks/psgomanual") ?>psgo</a></dt>
       <dd>GO diagrams.</dd>
       </dl>
</dd>

     <dt><em>METAPOST</em></dt>
    <dd>a development of Donald Knuth&rsquo;s <em>METAFONT</em> program
        which produces PostScript rendition of fonts, diagrams, etc., rather than
        bitmapped versions. Documentation includes a 
       <?php echo checkurl("metapost/base/mpman") ; ?>manual</a> and a guide to 
       <?php echo checkurl("metapost/base/mpgraph.pdf") ; ?>plotting graphs</a> using <em>METAPOST</em>.</dd>
      <dt><?php echo checkurl("latex/treesvr/treedoc") ; ?>trees</a></dt>
      <dd>Macros for drawing &quot;tree&quot; diagrams.</dd>
      <dt>overpic</dt>
      <dd>This package defines the <kbd>overpic</kbd> environment for
	overlaying a picture environment on top of an included graphic
	defined by an includegraphics command.
	Examples in
	<?php echo checkurl("latex/overpic/opic-abs.tex") ; ?>opic-abs.tex</a> and
	<?php echo checkurl("latex/overpic/opic-rel.tex") ; ?>opic-rel.tex</a>.</dd>
      <dt><?php echo checkurl("latex/pb-diagram/pb-manual") ; ?>pb-diagram</a></dt>
      <dd>Commutative diagrams using an adaptative grid and variable arrows. Source <?php echo checkurl("latex/pb-diagram/pb-examples.tex") ; ?>example</a> available.</dd>
<dt><?php echo checkurl("latex/eclbip/ecltreesample") ; ?>ecltree</a></dt>
<dd>Tree like structures with words on nodes.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/diagrams.txt");
?>
</dl>


    <h2><a name="packages">LaTeX Packages</a></h2>

<table style="border:outset; border-color:blue" cellpadding="5pt" align="center" width="80%" border="1"><tr><th><a href="#general">Alternative classes</a></th><th><a href="#structure">Document structure</a></th><th><a href="#formatting">Formatting tools</a></th><th><a href="#layout">Page layout</a></th><th><a href="#appearance">Document appearance</a></th><th><a href="#tables">Tables</a></th><th><a href="#floats">Floats</a></th><th><a href="#fonts">Fonts</a></th><th><a href="#math">Mathematics</a></th><th><a href="#languages">Languages</a></th><th><a href="#alternative">Alternative Doc Types</a></th><th><a href="#packageprogramming">Package programming</a></th><th><a href="#utilities">Utilities</a></th></tr>
</table>

<p>  The main LaTeX classes included with the core distribution are <code>article</code>, <code>book</code>, <code>report</code>, <code>letter</code> and <code>slides</code>. They are describeb in <cite>LaTeX, a document preparation system</cite>.</p>
<p>LaTeX packages offer additional control and alternatives to the visual appearance and formatting of LaTeX documents. Many are described in  
    <a href="http://www.aw-bc.com/catalog/academic/product/0,1144,0201362996,00.html">
    <cite>The LaTeX Companion</cite></a><!-- and they are grouped here in 
    accordance with the headings defined there -->.
      The majority of packages included in teTeX are listed below. 
      Many more have been written to provide additional capabilities and are
      available for download from the Comprehensive TeX Archive
      Network servers, abbreviated to <a href="http://www.ctan.org/search/?action=/search/">CTAN</a> (<a href="http://theory.uwinnipeg.ca/scripts/CTAN/">locate a nearby CTAN node</a>).  
      Here is the <?php echo checkurl("help/Catalogue/index.html"); ?>Catalogue</a>
      of packages available from CTAN.  LaTeX itself and most of these packages
      are released under the <?php echo checkurl("latex/base/lppl.txt") ; ?>LaTeX
      Project Public License</a>.</p>



    <h3><a name="general">Alternative classes and bundles</a></h3>
    <p>Most additional LaTeX classes and bundles listed in the following sections have a narrow scope and try to solve a very specific problem. A few try to offer full alternatives with respect to document design to the main LaTeX classes. Two examples with such a generic nature:</p>
<dl>
      <dt><?php echo checkurl("latex/koma-script/scrguien") ; ?>KOMA-script</a></dt>
      <dd>Provides drop-in replacements for the standard classes but also additional packages usable with LaTeX or KOMA-script classes. Inspired by german typographical traditions.</dd>
      <dt><?php echo checkurl("latex/memoir/memman") ; ?>memoir</a></dt><dd>A bundle by Peter Wilson of some of his packages and other material allowing page, chapter and caption styles, typewriter appearance, facilities aimed at e-books,...</dd>
</dl>
      <p>A large number of publishers of scientific books and journals provide their own latex styles, some of these under licenses that allow using them freely. Two such cases are included in teTeX:</p>
 <dl><dt><a href="#amsmath">amsmath</a>, <a href="#amsfonts">amsfonts</a>, <a href="#amscls">amsart</a>, <a href="#amscls">amsbook</a>, <a href="#amscls">amsproc</a>...</dt><dd>The <a href="http://www.ams.org/tex/amslatex.html">American Mathematical Society AMS-Math (AMS-LaTeX)</a> packages (see the <a href="#math">Mathematics</a> section below and the online <a href="http://www.ams.org/tex/amsmath-faq.html">FAQ</a>).</dd>
<dt>REVTeX 4</dt><dd>From the American Physical Society. Check the <a href="http://publish.aps.org/revtex4/">webpage</a> and the <?php echo checkurl("latex/revtex4") ; ?>documents included with teTeX</a>.</dd>
</dl>

    <h3><a name="structure">Document Structure</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/tools/xr") ; ?>xr</a></dt>
      <dd> Page references to external documents.</dd>
      <dt><?php echo checkurl("latex/tools/varioref") ; ?>varioref</a></dt>
      <dd> &quot;Intelligent&quot; page references.</dd>
      <dt><?php echo checkurl("latex/lastpage/lastpage"); ?>lastpage</a></dt>
      <dd> Reference the number of pages in your LaTeX document (as in a
	page footer that says: Page N of M).</dd>
      <dt><?php echo checkurl("latex/totpages/totpages"); ?>totpages</a></dt>
      <dd> Reference the <em>total</em> number of pages in your dvi document.</dd>
      <dt id="hyperref"><?php echo checkurl("latex/hyperref/manual.pdf"); ?>hyperref</a></dt>
      <dd>Create hypertext documents in dvi, postscript or PDF form.
	Contents listings, references, bibliographic citations and URLs are
	converted to hyperlinks.</dd>
      <dt><?php echo checkurl("latex/dinbrief/dinbrief"); ?>dinbrief</a></dt>
      <dd>The <kbd>dinbrief</kbd> document class (in German).</dd>
      <dt><?php echo checkurl("generic/german/gerdoc"); ?>german</a></dt>
      <dd>The <kbd>german</kbd> and <kbd>ngerman</kbd> document classes.</dd>
      <dt><?php echo checkurl("latex/ntgclass/ntgclass"); ?>ntgclass</a></dt>
      <dd>Dutch document classes.</dd>
      <dt><?php echo checkurl("latex/minitoc/minitoc"); ?>minitoc</a></dt>
      <dd>Package to add a mini-&quot;table of contents&quot; to each chapter.
	<?php echo checkurl("latex/minitoc/mini-art.tex"); ?>Example 1</a>,
	<?php echo checkurl("latex/minitoc/minitoc-ex.tex"); ?>example 2</a>.</dd>
      <dt><?php echo checkurl("latex/titlesec/titlesec"); ?>titlesec</a> </dt>
      <dd>Customize the sectioning format of a document. </dd>
      <dt><?php echo checkurl("latex/index/index"); ?>index</a> </dt>
      <dd>A different implementation of the LaTeX indexing commands. An <?php echo checkurl("latex/index/sample"); ?>example</a> is included.</dd>
      <dt><?php echo checkurl("latex/abstract/abstract"); ?>abstract</a> </dt>
      <dd>Extra options for the abstract, e.g. a one column abstract in a 2 column document.</dd>
      <dt><?php echo checkurl("latex/appendix/appendix"); ?>appendix</a> </dt>
      <dd>Provides extra facilities for typesetting appendices.</dd>
      <dt><?php echo checkurl("latex/sectsty/sectsty"); ?>sectsty</a> </dt>
      <dd>Macros to customize sectional headings (section, chapter, etc.)</dd>
      <dt><?php echo checkurl("latex/tocloft/tocloft"); ?>tocloft</a> 
      <dd>Customize the table of contents or lists of figures or tables.</dd>
      <dt><?php echo checkurl("latex/tocbibind/tocbibind"); ?>tocbibind</a></dt>
      <dd>Add document elements such as a bibliography or index to the table of contents.</dd>
     <dt><?php echo checkurl("latex/comment/comm_latest.tex"); ?>comment</a></dt>
      <dd>Test file for customizable comments using <tt>comment.sty</tt>.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/structure.txt");
?>
    </dl>

    <h3><a name="formatting">Formatting Tools</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/was/upgreek"); ?>upgreek</a></dt>
      <dd>Upright lower case greek letters.</dd>
      <dt><?php echo checkurl("latex/tools/xspace"); ?>xspace</a></dt>
      <dd>Define commands that don&rsquo;t eat spaces.</dd>
      <dt><?php echo checkurl("latex/tools/verbatim"); ?>verbatim</a><a
	  name="verbatim">&nbsp;</a></dt>
      <dd>A more robust implementation of the <kbd>verbatim</kbd> environment.</dd> 
      <dt><?php echo checkurl("latex/moreverb/moreverb"); ?>moreverb</a></dt>
      <dd>An extension to the <a href="#verbatim">verbatim</a> package that
	can handle <kbd>TAB</kbd> expansion, can number lines in an
	included file, can produce boxed verbatims, etc.</dd>
      <dt id="fancyvrb"><?php echo checkurl("latex/fancyvrb/fancyvrb"); ?>fancyvrb</a></dt>
      <dd>A comprehensive and customizable re-implementation of the
	<kbd>verbatim</kbd> environment.  Allows specification of fonts,
	colours, <em>etc.</em>, line numbering, framing, <kbd>TAB</kbd>
	handling and conditional processing.</dd>
      <dt><?php echo checkurl("latex/fancyvrb/fvrb-ex"); ?>fvrb-ex</a></dt>
      <dd>An extension to <a href="#fancyvrb">fancyvrb</a>.</dd>
      <dt><?php echo checkurl("latex/tools/enumerate"); ?>enumerate</a></dt>
      <dd>Adds an optional argument to the enumerate environment which
	determines the style in which the counter is printed.</dd>
      <dt><?php echo checkurl("latex/was/icomma"); ?>icomma</a></dt>
      <dd>Intelligent spacing around commas which corrects problems when the comma is used as a decimal separator.</dd>
     <dt><?php echo checkurl("comma.sty"); ?>comma</a></dt>
      <dd><kbd>\usepackage{comma}</kbd> defines the command
	<kbd>\commaform{<em>number</em>}</kbd> which typesets
	<em>number</em> with a comma every third digit. If you want
	something other than a comma, for instance a thin 
	space, or a full word space, redefine <kbd>\commaformtoken</kbd>
	for instance <kbd>\renewcommand\commaformtoken{\,}</kbd>.</dd>
      <dt><?php echo checkurl("latex/tools/indentfirst"); ?>indentfirst</a></dt>
      <dd>Indent first paragraph after section header.</dd>
      <dt><?php echo checkurl("latex/program/program"); ?>program</a></dt>
      <dd>This package is for typesetting computer programs and
	algorithms. There is an example in
	<?php echo checkurl("latex/program/program-demo.tex"); ?>program-demo.tex</a>.</dd>
      <dt><?php echo checkurl("latex/textfit/textfit"); ?>textfit</a></dt>
      <dd>Package to support fitting of text to a given width of height
	by scaling the font.</dd>
      <dt><?php echo checkurl("latex/carlisle/typehtml"); ?>typehtml</a></dt>
      <dd>Typeset HTML (i.e., World Wide Web documents) directly from
	LaTeX.</dd>
      <dt><?php echo checkurl("latex/carlisle/plain.txt"); ?>plain</a></dt>
      <dd>Allows the inclusion of plain tex markup in a LaTeX document. It
	defines the LaTeX environment <kbd>plain</kbd> which is used to
	enclose the plain tex to be included. </dd>
      <dt><?php echo checkurl("latex/amscls/amsrefs"); ?>amsrefs</a></dt>
      <dd>An alternative to BibTeX included in the AMS classes allowing typesetting of bibliographic entries directly from LaTeX with records in a format similar to the one used in BibTeX .bib files. Extra documentation in the <?php echo checkurl("latex/amscls"); ?>latex/amscls</a> directory.</dd>
      <dt id='natbib'><?php echo checkurl("latex/natbib/natbib"); ?>natbib</a></dt>
      <dd>Customizable citations.  Can do almost any variant of
	numerical or author-date style citations.  There&rsquo;s also a <?php echo checkurl("latex/natbib/natnotes"); ?>quick reference</a>.</dd>
      <dt><?php echo checkurl("latex/footbib/footbib"); ?>footbib</a></dt>
      <dd>Citations as footnotes.</dd>
      <dt><?php echo checkurl("latex/natbib/bibentry"); ?>bibentry</a></dt>
      <dd>Insert formatted bibliographic references inline in the text.</dd>
      <dt><?php echo checkurl("latex/paralist/paralist"); ?>paralist</a></dt>
      <dd>Typeset lists within paragraphs.</dd>
      <dt id="mdwtools"><?php echo checkurl("latex/mdwtools/README"); ?>MDW tools</a></dt>
      <dd>A collection of packages written by Mark Wooding including the next five entries. Documentation for other components can be found in the appropriate section in this document.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/mdwlist"); ?>mdwlist</a></dt>
	  <dd>Various list related environments.  There is a more
	    versatile <code>description</code> environment, and some stuff for
	    making <code>compacted</code> lists (with no extra space between
	    items).</dd>
	  <dt><?php echo checkurl("latex/mdwtools/mdwtab"); ?>mdwtab</a></dt>
	  <dd>A complete ground-up rewrite of LaTeX&rsquo;s <code>tabular</code> and
	    <code>array</code> environments.  Has lots of advantages over
	    the standard version, and over the version in <code>array.sty</code>.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/footnote"); ?>footnote</a></dt>
	  <dd>Provides commands for saving executing footnotes.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/sverb"); ?>sverb</a></dt>
	  <dd>A bunch of macros for doing verbatim things.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/syntax"); ?>syntax</a></dt>
	  <dd>A load of commands for describing syntax.  There is an
	    environment for typesetting BNF grammars. </dd>
	
      <dt><?php echo checkurl("latex/acronym/acronym"); ?>acronym</a></dt>	
      <dd>Make sure all acronyms used are spelt out at least once.</dd>
      <dt><?php echo checkurl("latex/hyphenat/hyphenat"); ?>hyphenat</a></dt>
      <dd>Improved control over hyphenation.</dd>
      <dt><?php echo checkurl("latex/ms/ragged2e"); ?>ragged2e</a></dt>
      <dd>Provides commands and environments for setting ragged text
	which are easy to configure to allow hyphenation.</dd>
      <dt><?php echo checkurl("latex/nomencl/nomencl"); ?>nomencl</a></dt>
      <dd>Package for preparing tables of nomenclature or glossaries.</dd>
      <dt><?php echo checkurl("latex/SIunits/SIunits.pdf"); ?>SIunits</a> </dt>
      <dd>Macros for typesetting SI units.</dd>
      <dt><?php echo checkurl("latex/units/units"); ?>units</a></dt>
      <dd>Typesetting of physical/metric units.</dd>
      <dt><?php echo checkurl("latex/was/gensymb"); ?>gensymb</a></dt>
      <dd>Unifying typographical conventions for measurement units in text and formulas.</dd>
      <dt><?php echo checkurl("latex/soul/soul"); ?>soul</a> </dt>
      <dd>Typeset text in a spaced-out or underlined fashion.</dd>
      <dt><?php echo checkurl("ulem.sty"); ?>ulem</a></dt>
      <dd>Underlining styles.</dd>
<dt id="framed"><?php echo checkurl("framed.sty"); ?>framed</a></dt>
<dd>Allows defining framed or shaded regions that can be divided between different pages. The shaded environment requires the <i>color</i> package and the definition of <i>shadecolor</i>, e.g., <tt>\definecolor{shadecolor}{gray}{.9}</tt>. </dd>
<dt><?php echo checkurl("latex/lettrine/lettrine"); ?>lettrine</a></dt>
<dd>Allows dropped capitals at the beginning of a paragraph in different styles and adjustements. A <?php echo checkurl("latex/lettrine/demo"); ?>demo file</a> is available.</dd>
<dt><?php echo checkurl("latex/listings/listings"); ?>listings</a></dt>
<dd>A source code printer.</dd>
<dt><?php echo checkurl("latex/oberdiek/alphalph"); ?>alphalph</a></dt>
      <dd>Numbering using letters.</dd>
<dt><?php echo checkurl("latex/preprint/sublabel"); ?>sublabel</a></dt>
      <dd>Subnumbering as in <em>4a, 4b, 4c, 4d</em>.</dd>
<dt><?php echo checkurl("latex/preprint/authblk"); ?>authblk</a></dt>
      <dd>A more versatile way to indicate author names and affiliations.</dd>
<dt><?php echo checkurl("latex/shapepar/shapepar"); ?>shapepar</a></dt>
      <dd>A macro to typeset paragraphs in a specific shape. Check the same directory for examples and a shape generating python script.</dd>
<dt><?php echo checktd("texnames.sty"); ?>texnames</a></dt>
      <dd>Macros to typeset the names of the TeX and METAFONT programs.</dd>
<dt><?php echo checktd("url.sty"); ?>url</a></dt>
<dd>Typesetting URLs, e.g., <code>\url{http://www.tug.org/}</code>.</dd> 
    <dt><?php echo checktd("aeguill.sty"); ?>aeguill</a></dt>
<dd>French guillemets (&laquo;&raquo;) in several fonts.</dd>   
<?php if ($local<>"no")  
     include($localtexmf . "nhi/formatting.txt");
?>
</dl>

    <h3><a name="layout">Page Layout</a></h3>
    <dl>
      <dt id="geometry"><?php echo checkurl("latex/geometry/geometry.pdf"); ?>geometry</a></dt>
      <dd>Customize page layout (page sizes) using an easy and flexible user interface.  Example  <?php echo checkurl("latex/geometry/sample.tex"); ?>sample.tex</a> generates a testpage.</dd>
      <dt><?php echo checkurl("latex/fancyhdr/fancyhdr"); ?>fancyhdr</a></dt>
      <dd>Support for sophisticated control of page headers and footers
	in LaTeX2e. It supercedes fancyheadings.
      <dt id="footmisc"><?php echo checkurl("latex/footmisc/footmisc"); ?>footmisc</a></dt>
      <dd>Customize footnote numbering, style and presentation. </dd>
      <dt><?php echo checkurl("latex/footnpag/footnpag-user"); ?>footnpag</a></dt>
      <dd>Allows footnotes on individual pages to be numbered from 1,
	rather than being numbered sequentially through the document.</dd>
      <dt><?php echo checkurl("nopageno.sty"); ?>nopageno</a></dt>
      <dd><kbd>\usepackage{nopageno}</kbd> suppresses <strong>all</strong>
	page numbering including that on title and frontmatter pages.</dd>
      <dt><?php echo checkurl("latex/chappg/chappg.txt"); ?>chappg</a></dt>
      <dd>The <kbd>chappg</kbd> package causes pages to be numbered
	in the style <em>chapter</em>-<em>pagenumber</em>. So the pages
	of chapter 3 will be numbered 3-1, 3-2, ..., and the pages of
	appendix B will be numbered B-1, B-2, ...</dd>
      <dt><?php echo checkurl("latex/tools/layout"); ?>layout</a></dt>
      <dd>Generate a test page showing the page layout.</dd>
      <dt><?php echo checkurl("latex/layouts/layman"); ?>layouts</a></dt>
      <dd>Draw display of page layout parameters.</dd>
      <dt><?php echo checkurl("latex/scale/scale"); ?>scale</a></dt>
      <dd>Rescales an entire document by 1.414 for photographic reduction.</dd>
      <dt><?php echo checkurl("latex/anysize/anysize"); ?>anysize</a></dt>
      <dd>Another package to set page sizes. Superceded by <a href="#geometry">geometry</a>.</dd>
      <dt><?php echo checkurl("latex/carlisle/fix2col"); ?>fix2col</a></dt>
      <dd>Improves some deficiencies in LaTeX&rsquo;s built-in two column output.</dd>
      <dt><?php echo checkurl("latex/mparhack/mparhack"); ?>mparhack</a></dt>
      <dd>Corrects some anomalies of <code>\marginpar</code>.</dd>
      <dt><?php echo checkurl("latex/tools/multicol"); ?>multicol</a></dt>
      <dd>LaTeX package to mix single and multiple columns. Allows you
	to shift between two and one columns anywhere.</dd>
      <dt><?php echo checkurl("latex/ms/multitoc"); ?>multitoc</a></dt>
      <dd>Typeset tables of contents and lists of figures and tables
	in multi-column mode.</dd>
      <dt><?php echo checkurl("latex/tools/ftnright"); ?>ftnright</a></dt>
      <dd>Customize placement of footnotes in two column documents.</dd>
      <dt><?php echo checkurl("latex/picinpar/picinpar"); ?>picinpar</a></dt>
      <dd>Insert pictures into paragraphs. (NOTE: Piet van Oostrum does
	not recommend this package. <a href="#picins">Picins</a> is recommended instead.)</dd>
      <dt id="picins"><?php echo checkurl("latex/picins/picins"); ?>picins</a></dt>
      <dd>Insert pictures into paragraphs.</dd>
      <dt id="rotating"><?php echo checkurl("latex/rotating/rotating"); ?>rotating</a></dt>
      <dd>Environment to rotate text, figures etc. There are examples, as
	<?php echo checkurl("latex/rotating/examples.tex"); ?>LaTeX</a> source and
	<?php echo checkurl("latex/rotating/examples.dvi"); ?>dvi</a> or 
	<?php echo checkurl("latex/rotating/examples.ps"); ?>PostScript</a> output.</dd>
      <dt><?php echo checkurl("wrapfig.sty"); ?>wrapfig</a></dt>
      <dd>Wrap text around a figure or table.</dd>
      <dt><?php echo checkurl("latex/eso-pic/eso-pic"); ?>eso-pic</a></dt>
      <dd>This package makes it easy to add some picture commands to every page.</dd>
      <dt><?php echo checkurl("latex/pdfpages/pdfpages"); ?>pdfpages</a></dt>
      <dd>A pdflatex macro package for inclusion of external document pdf pages.</dd>
      <dt><?php echo checkurl("latex/extsizes/readme.extsizes"); ?>extsizes</a></dt>
      <dd>Extends LaTeX classes from the traditional 10pt, 11pt or 12pt text to 8pt, 9pt, 14pt, 17pt, or 20pt text needed in special circunstances.</dd>
      <dt><?php echo checkurl("latex/preprint/fullpage"); ?>fullpage</a></dt>
      <dd>A package to fully use a page leaving minimal margins.</dd>
      <dt><?php echo checktd("vmargin.sty"); ?>vmargin</a></dt>
      <dd>An alternative way for dealing with paper sizes and margins.</dd>
      <dt><?php echo checkurl("latex/textpos/textpos"); ?>textpos</a></dt>
      <dd>Absolute positioning on the page. Useful for posters.</dd>
      <dt><?php echo checkurl("chngpage.sty"); ?>chngpage</a></dt>
      <dd>Allows changing page layout in the middle of a document.</dd>
      <dt><?php echo checkurl("portland.sty"); ?>portland</a></dt>
      <dd>Allows changes between portrait and landscape.</dd>
      <dt><?php echo checkurl("portland.sty"); ?>setspace</a></dt>
      <dd>Double, one and a half spacing, any line spacing...</dd>
      <dt><?php echo checkurl("parskip.sty"); ?>parskip</a></dt>
      <dd>No parindent, some parskip.</dd>
      <dt><?php echo checkurl("nextpage.sty"); ?>nextpage</a></dt>
      <dd>Provides additional <tt>\clearpage</tt> like commands, allowing such things as clearing to the next even numbered page without flushing floats.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/layout.txt");
?>
    </dl>


    <h3><a name="appearance">Modifying document appearance</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/tools/showkeys"); ?>showkeys</a></dt>
      <dd>Print label, ref, cite and bib keys.</dd>
      <dt><?php echo checkurl("latex/showlabels/showlabels"); ?>showlabels</a></dt>
      <dd>Print <kbd>\label</kbd> arguments or equation numbers in margin
	at point of definition.</dd>
      <dt><?php echo checkurl("latex/changebar/changebar"); ?>changebar</a></dt>
      <dd>Add &quot;change bars&quot; in a document margin using dvi \specials.</dd>
      <dt><?php echo checkurl("latex/crop/crop"); ?>crop</a></dt>
      <dd>Print crop marks.</dd>
      <dt><?php echo checkurl("latex/draftcopy/draftcopy"); ?>draftcopy</a></dt>
      <dd>Overprint <kbd>DRAFT</kbd> on each page of document to
	indicate draft copy. The directory
	<?php echo checkurl("latex/draftcopy"); ?>latex/draftcopy/</a> has a number of
	examples.</dd>
      <dt><?php echo checkurl("latex/ms/count1to"); ?>count1to</a></dt>
      <dd>Sets some new counters for section selection.</dd>
      <dt><?php echo checkurl("latex/ms/prelim2e"); ?>prelim2e</a></dt>
      <dd>Allows marking of preliminary versions of a document in the
	output.</dd>
      <dt><?php echo checkurl("generic/thumbpdf/readme.txt"); ?>thumbpdf</a></dt>
      <dd>Support of thumbnails with pdfTeX, plain/LaTeX formats.</dd>
      <dt><?php echo checkurl("latex/oberdiek/hypbmsec"); ?>hypbmsec</a></dt>
      <dd>Expands sectioning commands to allow replacing bookmarks in pdf documents if section titles are not suitable for that purpose.</dd>
      <dt><?php echo checkurl("latex/oberdiek/pagesel"); ?>pagesel</a></dt>
      <dd>Output a subset of the pages in the document.</dd>
      <dt><?php echo checkurl("latex/oberdiek/hypcap"); ?>hypcap</a></dt>
      <dd>Adjusting the anchor point of captions when using hyperref.</dd>
    </dl>

    <h3><a name="tables">Tables</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/tools/array"); ?>array</a></dt>
      <dd>An extended implementation of the array and tabular
	environments which implements options to format columns.</dd>
      <dt><?php echo checkurl("latex/tools/longtable"); ?>longtable</a></dt>
      <dd>Support for tables longer than a page.</dd>
      <dt><?php echo checkurl("latex/tools/delarray"); ?>delarray</a></dt>
      <dd>Add delimiters (parentheses, etc.) around arrays.</dd>
      <dt><?php echo checkurl("latex/supertab/supertabular"); ?>supertabular</a></dt>
      <dd>A multi-page tables package.</dd>
<dt><?php echo checkurl("latex/xtab/xtab"); ?>xtab</a></dt>
      <dd>Another multi-page tables package extending <code>supertabular</code>.</dd>
      <dt><?php echo checkurl("latex/tools/dcolumn"); ?>dcolumn</a></dt>
      <dd>Align on the decimal point of numbers in tabulars.</dd>
      <dt><?php echo checkurl("latex/tools/hhline"); ?>hhline</a></dt>
      <dd>Better horizontal lines in tabulars and arrays. 
      <dt><?php echo checkurl("latex/tools/tabularx"); ?>tabularx</a>
      <dd>Tabulars that widen automatically. 
      <dt><?php echo checkurl("latex/carlisle/ltxtable"); ?>ltxtable</a>
      <dd>Longtable combined with tabularx.
      <dt><?php echo checkurl("latex/carlisle/colortbl"); ?>colortbl</a><a name="colortbl">&nbsp;</a>
      <dd>Add colour to LaTeX tables.
      <dt><?php echo checkurl("latex/booktabs/booktabs"); ?>booktabs</a>
      <dd>A package to lay out tables in high-quality (according to the
	author&rsquo;s opinion) book form. 
      <dt><?php echo checkurl("latex/slashbox/slashbox.tex"); ?>slashbox</a></dt> 
      <dd>Typeset a box with a diagonal divider for table headings.</dd>
      <dt><?php echo checkurl("latex/carlisle/blkarray"); ?>blkarray</a></dt> 
      <dd>A new and experimental way of dealing with arrays.</dd>
      <dt><?php echo checkurl("threeparttable.sty"); ?>threeparttable</a></dt> 
      <dd>Tables with captions and notes.</dd>
      <dt><?php echo checkurl("multirow.sty"); ?>multirow</a></dt> 
      <dd>Make an entry that will span multiple rows of a table.</dd>
      <dt><?php echo checkurl("tabls.sty"); ?>tabls</a></dt> 
      <dd>Modifies the array and tabular of LaTeX to keep text from touching other text or lines.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/appearance.txt");
?>
    </dl>

    <h3><a name="floats">Floats</a></h3>
    <p><em>Floats</em> are environments like <kbd>figure</kbd> and <kbd>table</kbd> which move text, <em>etc.</em>, around in the document.</p>

    <dl>
      <dt><?php echo checkurl("latex/tools/afterpage"); ?>afterpage</a>
      <dd>Implements a command that causes the commands specified in its
	argument to be expanded after the current page is
	output. Useful to flush floats, for example 
      <dt><?php echo checkurl("latex/float/float"); ?>float</a><a name="float">&nbsp;</a>
      <dd>Improves the interface for defining floating objects such as
	figures and tables. Introduces the boxed float and the ruled float.
      <dt><?php echo checkurl("latex/subfig/subfig"); ?>subfig</a> (and <?php echo checkurl("latex/subfigure/subfigure"); ?>subfigure</a>)</dt>
      <dd>Figures divided into subfigures. Due to lack of full backward compatibility of <code>subfig</code>, relatively to the currently <?php echo checkurl("latex/subfigure/README.obsolete"); ?>obsolete</a> and differently named version (<code>subfigure</code>), both are available. In new documents use <code>subfig</code>. Examples for <code>subfig</code> in the same <?php echo checkurl("latex/subfig"); ?>directory</a>.</dd>
      <dt><?php echo checkurl("latex/endfloat/endfloat"); ?>endfloat</a>
      <dd>Place all figures on pages by themselves at the end of the document.
      <dt><?php echo checkurl("latex/placeins/placeins"); ?>placeins</a>
      <dd>Keeps floats &quot;in their place&quot;, preventing them from
	floating past a <code>\FloatBarrier</code> command into another
	section. 
      <dt><?php echo checkurl("latex/caption/manual"); ?>caption</a></dt>
      <dd>Extend caption capabilities for figures and tables, such as
	the caption width, style, font.</dd>
      <dt><?php echo checkurl("latex/ccaption/ccaption"); ?>ccaption</a></dt>
      <dd>Commands for <em>continuation captions</em>,
unnumbered captions, and a legend heading for any environment.</dd>
      <dt id="sidecap"><?php echo checkurl("latex/sidecap/sidecap"); ?>sidecap</a>
      <dd>Defines new LaTeX environments called SCfigure and SCtable
	(analogous to figure and table), to typeset captions sideways.
	leftcaption and rightcaption.
      <dt><?php echo checkurl("latex/floatflt/floatflt"); ?>floatflt</a> 
      <dd>Float text around figures and tables which do not span the
      full width of a page. This is an improved version of floatfig.
	<?php echo checkurl("latex/floatflt/floatexm.dvi"); ?>Examples</a>, latex 
	<?php echo checkurl("latex/floatflt/floatexm.tex"); ?>source</a>, precursor package
	<?php echo checkurl("latex/floatflt/floatfge"); ?>floatfig</a>.
      <dt><?php echo checkurl("latex/rotfloat/rotfloat"); ?>rotfloat</a>
      <dd>Combines <a href="#rotating"><kbd>rotating</kbd></a> package
	with enhanced float facilities of <a href="#float"><kbd>float</kbd></a>.
	Examples:
	LaTeX <?php echo checkurl("latex/rotfloat/examples.tex"); ?>source</a> and
	<?php echo checkurl("latex/rotfloat/examples.ps"); ?>output</a>.
<dt><?php echo checkurl("latex/preprint/figcaps"); ?>figcaps</a></dt>
      <dd>A package to put figures and tables at the end of an article.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/floats.txt");
?>
    </dl>

    <h3><a name="fonts">Fonts and Supporting Packages</a></h3>
<p>In addition to the preinstalled fonts, see the section on using <?php echo checkurl("fontinst/fontinstallationguide"); ?>fontinst</a> to install new fonts, especially PostScript Type 1 fonts and the <?php echo checkurl("fonts/fontname/fontname"); ?>font naming conventions</a>.</p>
    <dl>
      <dt><?php echo checkurl("latex/psnfss/psnfss2e"); ?>psnfss</a></dt>
      <dd>A package collection providing the LaTeX2e font selection scheme for standard Postscript fonts. Includes how to invoke several styles using standard Postscript fonts (Times, Helvetica, Palatino,...) and some free fonts (Charter, Utopia, Pazo) instead of the cm font family.</dd>
      <dt><?php echo checkurl("fonts/lm/0info092"); ?>Latin Modern (LM)</a></dt>
      <dd>A pre-release version of the Latin Modern family of Postscript type 1 fonts wich extentends the CM family with lots of additional (mainly accented) characters.</dd>
      <dt><?php echo checkurl("fonts/ae/README"); ?>ae</a>
      <dd>A set of virtual fonts designed to be a close approximation to
	a T1-encoded set based on the CM fonts.  This should make it
	possible to use the existing Type1 versions of the CM fonts to
	produce PDF files even when one needs hyphenation patterns other
	than English. See also <?php echo checkurl("fonts/ae/README2"); ?>aecompl</a>      
      <dt><?php echo checkurl("latex/tools/fontsmpl"); ?>fontsmpl</a>
      <dd>Print a sample of a font. 
      <dt><?php echo checkurl("latex/tools/rawfonts"); ?>rawfonts</a>
      <dd>Emulation of LaTeX 2.09 low-level font commands, eg \tenrm.
      <dt><?php echo checkurl("latex/pslatex/00readme"); ?>pslatex</a></dt>
      <dd>LaTeX with a mix of the standard Postscript fonts. Available as a package or a command.</dd>
      <dt id="beton"><?php echo checkurl("latex/beton/beton"); ?>beton</a>
      <dd>Typeset a LaTeX2e document with the Concrete fonts designed by
	Don Knuth and used in his book <em>Concrete Mathematics</em>.
      <dt><?php echo checkurl("latex/ccfonts/ccfonts"); ?>ccfonts</a>
      <dd>LaTeX font definition files for the Concrete fonts and a LaTeX
	package for typesetting documents using Concrete as the
	default font family.
      <dt><?php echo checkurl("fonts/cmbright/cmbright"); ?>cmbright</a></dt>
      <dd>Use the &quot;Computer Modern bright&quot; font family.</dd>
      <dt>Y&amp;Y support</dt>
      <dd>teTeX contains support for several font families from <a href="http://www.yandy.com/">Y&amp;Y</a>. Such fonts are <b>not</b> a part of teTeX and must be purchased separately. Support packages include:
      <dl>
      <dt id="mathtime"><?php echo checkurl("latex/mathtime/mathtime"); ?>mathtime</a></dt>
      <dd>Support for the Mathtime fonts. Note that if you really want to use the mathtime fonts you need to reverse the change described in the <?php echo checkurl("fonts/belleek/README"); ?>belleek fonts README</a> file.</dd>
      <dt><?php echo checkurl("latex/mt11p/mt11p"); ?>mt11p</a></dt>
      <dd>Support for the Mathtime and MathtimePlus fonts.</dd>
      <dt><?php echo checkurl("latex/psnfssx/lucidabr"); ?>lucidabr</a></dt>
      <dd>Support for the Lucida Bright fonts. See also <?php echo checkurl("fonts/bh/lucida"); ?>lucida</a>.</dd>
      <dt><?php echo checkurl("latex/psnfssx/ly1"); ?>LY1</a>
      <dd>Support for the <tt><em>texnansi</em></tt> encoding as used by default in the Y&amp;Y TeX system. There is also an option to support the <tt><em>ansinew</em></tt> encoding that is the default encoding in Microsoft Windows.</dd>
      </dl>
</dd>
      <dt><?php echo checkurl("fonts/belleek/README"); ?>belleek</a>
      <dd>teTeX includes the belleek fonts as a drop-in replacement for the <a href="#mathtime">mathtime</a> fonts.</dd>
      <dt><?php echo checkurl("dotlessj.sty"); ?>dotlessj</a></dt>
      <dd>This package declares the macros
      <kbd>\j</kbd> and <kbd>\jmath</kbd> to insert a dotless j in
      text and math mode.</dd>
      <dt><?php echo checkurl("dotlessi.sty"); ?>dotlessi</a></dt>
      <dd>Provides dotless i&rsquo;s and j&rsquo;s for use in any math font.</dd>
      <dt><?php echo checkurl("latex/mflogo/mflogo"); ?>mflogo</a> <dd>LaTeX package and
      font definition file to access the Knuthian <tt>logo</tt> fonts
      described in <em>The MetaFontbook</em> and the MetaFont and MetaPost logos in
      LaTeX documents.  
      <dt><?php echo checkurl("latex/concmath/concmath"); ?>Concrete Math</a> fonts <dd>A set of math fonts for use with Donald Knuth&rsquo;s <a href="#beton">concrete</a> text fonts.  <dt>concrete
      <dd>This package simply includes the <a href="#beton">beton</a>
      and <a href="#euler">euler</a> packages for an approximation of
      the style in <cite>Concrete Mathematics</cite>.  
      <dt><?php echo checkurl("latex/mathcomp/mathcomp"); ?>mathcomp</a> 
      <dd>A package for using the <em>Text Companion</em> fonts in math mode. 
      (For example to get an upright &quot;mu&quot;.)  
      <dt><?php echo checkurl("latex/type1cm/type1cm"); ?>type1cm</a> 
      <dd>Allows the use
      of Computer Modern fonts at arbitrary type sizes instead of the
      usual discrete magsteps.  
      <dt><?php echo checkurl("scalefnt.sty"); ?>scalefnt</a></dt>
      <dd>Makes available the <code>\scalefont</code> command to scale the current font and baselineskip.</dd>
      <dt><?php echo checkurl("relsize.sty"); ?>relsize</a></dt>
      <dd>Several ways to rescale fonts.</dd>
      <dt><?php echo checkurl("latex/yfonts/readme"); ?>yfonts</a> 
      <dd>A LaTeX
      interface to the old-german fonts designed by Yannis
      Haralambous.  <dt><?php echo checkurl("latex/mfnfss/oldgerm"); ?>oldgerm</a></dt>
      <dd>German handwriting fonts.</dd>
      <dt><?php echo checkurl("latex/wasysym/wasysym"); ?>wasysym</a></dt>
      <dd>This package defines LaTeX commands to insert the symbols in
      the <?php echo checkurl("latex/wasysym/wasydoc"); ?>wasysym</a> font set.</dd>
      <dt><?php echo checkurl("latex/stmaryrd/stmaryrd"); ?>stmaryrd</a></dt>
      <dd>The &quot;St Mary&rsquo;s Road&quot; symbol fonts.</dd>
      <dt><?php echo checkurl("fonts/marvosym/marvodoc"); ?>marvodoc</a></dt>
      <dd>The Martin Vogel symbol fonts.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/cmtt"); ?>cmtt</a></dt>
	  <dd>Provides an <code>mTT</code> encoding for the Computer Modern
	    Typewriter font, which solves lots of messy problems.</dd>
      <dt><?php echo checkurl("fonts/mathpazo/README"); ?>mathpazo</a></dt>
      <dd>The mathpazo fonts and style. This allows mixing the Palatino font for text with suitable fonts in formulas.</dd>
      <dt><?php echo checkurl("fonts/pxfonts/pxfontsdocA4.pdf"); ?>pxfonts</a></dt>
      <dd>Another fonts and style package centered on Palatino for roman text, Helvetica for sans serif, extra or modified fonts for math,..., offering a full alternative to the use of the <em>cm</em> font family.</dd>
      <dt><?php echo checkurl("fonts/txfonts/txfontsdocA4.pdf"); ?>txfonts</a></dt>
      <dd>Another fonts and style package centered on Times for roman text,..., offering a full alternative to the use of the <em>cm</em> font family.</dd>
<dt><?php echo checkurl("fonts/cbgreek/cbgreek"); ?>cbgreek</a></dt>
      <dd>Greek text fonts.</dd>
<dt><?php echo checkurl("fonts/eurosym/testeuro.dvi"); ?>eurosym</a></dt>
<dd>An officially looking euro currency symbol. Typeset the <?php echo checkurl("fonts/eurosym/testeuro.tex"); ?>documentation</a> for testing.</dd>
<dt><?php echo checkurl("latex/microtype/microtype"); ?>microtype</a></dt>
<dd>Micro typographic adjustements with pdflatex. A <?php echo checkurl("latex/microtype/test-microtype"); ?>test file</a> is included.</dd>

<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/fonts.txt");
?>
    </dl>
    <p>For special purpose math fonts see also the next section.</p>

    <h3><a name="math">Mathematics including AMS extensions</a></h3>

    <p>A very useful guide to the American Mathematical Society extensions to
    LaTeX is provided in Chapter 8 of
    <cite>The LaTeX Companion, 2<sup>nd</sup> edition</cite> (<a href="http://www.latex-project.org/guides/tlc2-ch0.pdf">table of contents</a>).</p>

    <dl>
      <dt id='amsmath'><?php echo checkurl("latex/amsmath/amsldoc"); ?>amsmath</a></dt>
      <dd>User guide for AMS-LaTeX as implemented in the amsmath
	package. Also see the documents in the directory <?php echo checkurl("latex/amsmath/"); ?>latex/amsmath/</a>.</dd>
      <dt id='amscls'><?php echo checkurl("latex/amscls/instr-l"); ?>amsart, amsbook, amsproc</a></dt>
      <dd>Instructions for the AMS classes used in its journals and monographs. Templates are available for <?php echo checkurl("latex/amscls/amsart.template"); ?>articles</a>, <?php echo checkurl("latex/amscls/amsbook.template"); ?>books</a> and <?php echo checkurl("latex/amscls/amsproc.template"); ?>proceedings</a>.</dd>
      <dt><?php echo checkurl("latex/tools/theorem"); ?>theorem</a></dt>
      <dd>Enhancements to the theorem environments, giving more choice
	in theorem layout.</dd>
      <dt><?php echo checkurl("latex/ntheorem/ntheorem"); ?>ntheorem</a></dt>
      <dd>Additional enhancements to the theorem environments, including endmark placement and creation of theorem lists.</dd>
     <dt><?php echo  checkurl("latex/amscls/amsthdoc") ?>amsthm</a></dt>
       <dd>An alternative theorem package which is part of the AMS classes and is different from the theorem package above providing several useful enhancements. A test file (<?php echo  checkurl("latex/amscls/thmtest.tex") ?>source</a>, <?php echo checkurl("latex/amscls/thmtest.pdf") ?>output</a>) is available.</dd>
      <dt id='amsfonts'><?php echo checkurl("fonts/amsfonts/amsfndoc"); ?>amsfonts</a>
      <dd>Documentation for the AMS mathematical font set.  See also the <?php echo checkurl("fonts/amsfonts/amsfonts"); ?>package documentation</a>, the <?php echo checkurl("fonts/amsfonts/amsfonts.bug"); ?>bug list</a> and the <?php echo checkurl("fonts/amsfonts/amsfonts.faq"); ?>frequently-asked questions list</a>.</dd>
      <dt id='empheq'><?php echo checkurl("latex/mh/empheq"); ?>empheq</a></dt>
      <dd>Visual markup extensions to amsmath.</dd>
      <dt id='mathtools'><?php echo checkurl("latex/mh/mathtools"); ?>mathtools</a></dt>
      <dd>Additional extensions and improvements to amsmath.</dd>
      <dt id="bm"><?php echo checkurl("latex/tools/bm"); ?>bm</a><a name="bm">&nbsp;</a></dt>
      <dd>The <strong>right</strong> way to make bold mathematical symbols.</dd>      
      <dt><?php echo checkurl("latex/bbold/bbold"); ?>bbold</a></dt>
      <dd>Blackboard variant fonts for Computer Modern, with LaTeX support.</dd>
      <dt><?php echo checkurl("fonts/dstroke/dsdoc"); ?>dstroke</a></dt>
      <dd>Double stroke fonts designed to be similar to Computer Modern.</dd>
      <dt><?php echo checkurl("fonts/dstroke/dsdoc"); ?>dsfont</a></dt>
      <dd>Double-stroke maths fonts. Declares the macro
      <kbd>\mathds{}</kbd> to use double-stroke roman fonts. Package
      option <kbd>sans</kbd> uses sans-serif version.</dd>
      <dt><?php echo checkurl("latex/bezos/accents"); ?>accents</a></dt>
      <dd>Various extensions for mathematical accents.</dd>
     <dt><?php echo checkurl("latex/euler/euler"); ?>euler</a><a name="euler">&nbsp;</a> 
      <dd>Provides a setup for using the AMS Euler family of fonts for
	math in LaTeX documents. 
      <dt><?php echo checkurl("fonts/amsfonts/eufrak"); ?>eufrak</a>
      <dd>Use the Euler Fraktur symbols.
      <dt><?php echo checkurl("fonts/amsfonts/euscript"); ?>euscript</a>
      <dd>Substitute the usual math calligraphic characters with Euler
	script equivalents.
      <dt><?php echo checkurl("latex/jknappen/mathrsfs.rme"); ?>mathrsfs</a>
      <dd>This package defines the command <kbd>\mathscr{ABC}</kbd>
	which typesets symbols such as Hamiltonians using the Ralph
	Smith Formal Script (rsfs) calligraphic fonts.
      <dt><?php echo checkurl("amstex/amsguide"); ?>amsguide</a>
       <dd>User guide for AMS-TeX (the original plain TeX mathematics package). See also the <?php echo checkurl("amstex/joyerr.tex"); ?>errata for its manual</a>, <em>The Joy of TeX</em>.
       <dt><?php echo checkurl("latex/leftidx/leftidx"); ?>leftidx</a></dt>
       <dd>Left sub and superscripts in mathematical mode. Their vertical position is adjusted according to the height of the symbol they precede.</dd>
     <dt><?php echo checkurl("latex/was/fixmath"); ?>fixmath</a></dt>
       <dd>Uppercase greek letters in italics inside formulas.</dd>
	  <dt><?php echo checkurl("latex/mdwtools/mdwtab"); ?>mathenv</a></dt>
	  <dd>A collection of mathematical environments with
	    a theme of aligning things in columns.</dd>
	    <dt><?php echo checkurl("latex/mdwtools/mdwmath"); ?>mdwmath</a></dt>
	  <dd>Contains a few trivial definitions for mathematical
	    things.  The main thing is that the <code>\sqrt</code> command for
	    doing square roots has been improved.</dd>
        <dt><?php echo checkurl("latex/esint/esint") ; ?>esint</a></dt>
        <dd>Generalization of a number of integral signs using cm fonts.</dd>
    </dl>
	    <?php if ( $local == "yes" ) include($texmflocaldoc . "nhi/math.txt"); ?>

    <h3><a name="languages">Multilingual LaTeX</a></h3>
    <dl>
      <dt><?php echo checkurl("generic/babel/user"); ?>babel</a></dt>
      <dd>This package supports multilingual documents in many
      languages. Some articles on babel that appeared in <a href="http://www.tug.org/TUGboat/">TUGBoat</a>: <?php echo checkurl("generic/babel/tb1202"); ?>tb1202</a>, <?php echo checkurl("generic/babel/tb1401"); ?>tb1401</a>, <?php echo checkurl("generic/babel/tb1604"); ?>tb1604</a>.</dd>
      <dt><?php echo checkurl("latex/platex/polski"); ?>platex</a></dt>
      <dd>Polish support. See also <?php echo checkurl("latex/platex/platex"); ?>html documentation</a>.</dd>
      <dt><?php echo checkurl("latex/mwcls/mwclsdoc"); ?>mwcls</a></dt>
      <dd>Styles supporting polish typographical conventions.</dd>
<dt><?php echo checkurl("latex/eo/readme"); ?>eo</a></dt>
      <dd>Esperanto support in LaTeX. See other files in the same directory.</dd>
      <dt><?php echo checkurl("latex/base/inputenc"); ?>inputenc</a>
      <dd>Allows use of 8-bit character sets in source documents.
      <dt><?php echo checkurl("latex/base/cyrguide"); ?>cyrillic</a><a name="cyrillic">&nbsp;</a>
      <dd>Package for using cyrillic fonts.  <dt>T2 <dd>Another font
      encoding for Cyrillic.  
      <dt>MLTeX</dt>
      <dd>MLTeX is a modification of TeX version that allows
      the hyphenation of words with accented letters using ordinary
      Computer Modern (CM) fonts.  There are instructions on <?php echo checkurl("latex/mltex/mltex.txt"); ?>how to use MLTeX&rsquo; \charsubdef extension with LaTeX</a>.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/languages.txt");
?>
    </dl>

    <h3><a name="alternative">Additional or alternative &quot;document&quot; types</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/beamer/beameruserguide"); ?>beamer</a></dt>
      <dd>A LaTeX style for presentations using a projector or transparencies. Besides the userguide look at the contents of the <?php echo checkurl("latex/beamer/examples"); ?>examples</a> and <?php echo checkurl("latex/beamer/solutions"); ?>solutions</a> (templates) directories.</dd>
      <dt><?php echo checkurl("latex/seminar/sem-user"); ?>seminar</a></dt>
      <dd>A LaTeX style for overhead transparencies and notes. <?php echo checkurl("latex/seminar/semsamp1.tex"); ?>Example 1</a>, <?php echo checkurl("latex/seminar/semsamp2.tex"); ?>Example 2</a>. List of <?php echo checkurl("latex/seminar/Seminar-FAQ.html"); ?>frequently asked questions</a>. List of <?php echo checkurl("latex/seminar/Seminar-Bugs.html"); ?>known bugs</a>.</dd>
      <dt><?php echo checkurl("latex/exam/examdoc"); ?>examdoc</a></dt>
      <dd>Style for preparing examination papers.</dd>
      <dt><?php echo checkurl("latex/currvita/currvita"); ?>currvita</a></dt>
      <dd>Style for preparing <em>curriculum vitae</em>. A <?php echo checkurl("latex/currvita/cvtest.tex"); ?>test file</a> is included.</dd>
      <dt><?php echo checkurl("latex/labels/labels"); ?>labels</a>
      <dd>A package for making sticky labels in LaTeX.
      <dt><?php echo checkurl("latex/textmerg/textmerg"); ?>textmerg</a>
      <dd>Package for creating &quot;text merges&quot; (like wordprocessor mail
	merge letters) in LaTeX. The directory
	<?php echo checkurl("latex/textmerg/"); ?>latex/textmerg</a>
	contains examples.
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/additional.txt");
?>
    </dl>

    <h3><a name="packageprogramming">Programming, Package Authoring</a></h3>
    <dl>
      <dt><?php echo checkurl("latex/mdwtools/at"); ?>at</a></dt>
	  <dd>Allows you to use &lsquo;@&rsquo; as a sort of &quot;command-introducing&quot; character, a bit like &lsquo;\&rsquo; is already.</dd>
      <dt><?php echo checkurl("latex/mdwtools/doafter"); ?>doafter</a></dt>
	  <dd>Provides a TeX programmer&rsquo;s utility \doafter &lt;token&gt;
	    &lt;group&gt; which does the &lt;token&gt; after the group
	    is complete, including any \aftergroup things.</dd>
      <dt><?php echo checkurl("latex/base/ifthen"); ?>ifthen</a>
      <dd>Defines <em>if/then/else</em> macros for conditional text.
      <dt><?php echo checkurl("latex/tools/calc"); ?>calc</a>
      <dd>Package for infix arithmetic notation in LaTeX.
      <dt><?php echo checkurl("latex/fp/readme.fp"); ?>fp</a> 
      <dd>Fixed-point arithmetic package for TeX and LaTeX
      <dt><?php echo checkurl("latex/graphics/keyval"); ?>keyval</a>
      <dd>Provides support for writing keyword-style arguments to
	packages.  Used by <a href="#graphics">graphics</a>.
      <dt><?php echo checkurl("latex/tools/somedefs"); ?>somedefs</a>
      <dd>A &quot;programmer&rsquo;s toolkit&quot; for package writers.
      <dt><?php echo checkurl("latex/tools/fileerr"); ?>fileerr</a>
      <dd>Implementation of an error handler for &quot;file-not-found&quot;
	errors.
      <dt><?php echo checkurl("generic/localloc/localloc"); ?>localloc</a>
      <dd>Enhanced register-allocation macros.
      <dt><?php echo checkurl("latex/base/doc"); ?>doc</a>
      <dd>Literate Programming for package writers --
	The combined LaTeX package-code/documentation suite.
      <dt><?php echo checkurl("latex/base/docstrip"); ?>docstrip</a>
      <dd>Package to build stripped-down version of package files for
	speed.
      <dt><?php echo checkurl("latex/ms/everysel"); ?>everysel</a>
      <dd>This package provides hooks into the NFSS command
	\selectfont called <tt>\EverySelectfont</tt> and 
        <tt>\AtNextSelectfont</tt> analogous to <tt>\AtBeginDocument</tt>.
      <dt><?php echo checkurl("latex/ms/everyshi"); ?>everyshi</a>
      <dd>This package defines a new command <tt>\EveryShipout</tt> analogous to <tt>\AtBeginDocument</tt>.
      <dt><?php echo checkurl("latex/stdclsdv/stdclsdv"); ?>stdclsdv</a>
      <dd>Macros to interact with sectional divisions of standard LaTeX classes.
      <dt><?php echo checkurl("latex/oberdiek/twoopt"); ?>twoopt</a></dt>
      <dd>Enables macros with <em>two</em> optional arguments.</dd>
      <dt><?php echo checkurl("latex/mh/mhsetup"); ?>mhsetup</a></dt>
      <dd>Programming tools used in the mh bundle which also includes <a href="#empheq">empheq</a> and <a href="#mathtools">mathtools</a>.</dd>
      <dt><?php echo checkurl("latex/onlyamsmath/onlyamsmath"); ?>onlyamsmath</a></dt>
      <dd>Allows class writers to force their users to use the environments provided by the amsmath package instead of plain or standard LaTeX math environments.</dd>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/package.txt");
?>
    </dl>

    <h3><a name="utilities">Utilities</a></h3>
    <dl>
      <dt><?php echo checkurl("checkend.sty"); ?>checkend</a></dt>
	  <dd>Improves LaTeX error messages with respect to environments which are accidentally left open.</dd>
      <dt><?php echo checkurl("mylatex.ltx"); ?>mylatex</a></dt>
	  <dd>Make a format from the preamble of any LaTeX file.</dd>
      <dt><?php echo checkurl("latex/amscls/textcmds");  ?>textcmds</a></dt>
          <dd>Shorthand commands for all the text symbols produced in LaTeX by non-letter ligatures.</dd>
      <dt><?php echo checkurl("ifpdf.sty");  ?>ifpdf</a></dt>
          <dd>A switch to deal with commands specific to pdf output.</dd>
</dl>

<h2><a name="ancillary">Ancillary Programs</a></h2>


<table style="border:outset; border-color:blue" cellpadding="5pt" align="center" width="80%" border="1">
<tr>
<th><a href="#bibtex">Bibtex</a></th>
<th><a href="#makeindex">Makeindex</a></th>
<th><a href="#dvips">Dvips</a></th>
<th><a href="#dvipdfm">Dvipdfm</a></th>
<th><a href="#dvipng">Dvipng</a></th>
<th><a href="#epstopdf">Epstopdf</a></th>
<th><a href="#xdvi">Xdvi</a></th>
<th><a href="#texinfo">Texinfo</a></th>
</tr>
</table>
    <h3><a name="bibtex">Bibtex</a></h3>
    <p><tt>
<?php
if ($mancapable)
{
  echo  "<a href=\"man:bibtex\">bibtex</a>";
}
else
{
  echo "bibtex";
}
?>
</tt>
   is a separate program for managing databases of bibliographic references
    and selecting for citation in a LaTeX document.  It is described in
    Appendix B of <cite>LaTeX: a Document Preparation System</cite> and chapter 13 of 
    <a href="http://cseng.awl.com/bookdetail.qry?ISBN=0-201-54199-8&amp;ptype=0"><em>The LaTeX Companion</em></a> and online in the documents entitled 
    <?php echo checkurl("bibtex/base/btxdoc"); ?>BibTexing</a> and 
    <?php echo checkurl("bibtex/base/btxhak"); ?>Designing BibTeX Styles</a>.</p>

    <p>The latter document, 
      <?php echo checkurl("bibtex/base/btxhak"); ?>Designing 
      BibTeX Styles</a> is a guide
      to customizing the format of the reference list.  The non-expert may
      find it more useful to use the ancillary program 
      <tt><?php echo checkurl("latex/custom-bib/makebst"); ?>makebst</a></tt>
      which semi-automates the design of a new bibliography style.</p>

    <p><tt><a href="#natbib">natbib</a></tt> is a LaTeX package which
      allows customization of the citation style in the text (rather than
      the format of the reference list).  It works with almost all
      bibliography styles, even those which define their own citation
      macros.</p>

    <p>Additional capabilities are provided by the <?php echo checkurl("latex/bibunits/bibunits"); ?>bibunits</a> package which allows defining separate bibliographies for different document parts or <?php echo checkurl("latex/multibib/multibib"); ?>multibib</a> which allows referencing multiple bibliographies.</p>

    <p>Usage of BibTeX can also be adpted to other ends. A <?php echo checkurl("latex/adrconv/adrguide"); ?>LaTeX style</a> for address databases using BibTeX is also included.</p>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/bibtex.txt");
?>

    <h3><a name="makeindex">Makeindex</a></h3>
    <p>The <tt>makeindex</tt> program which provides facilities for
    generating an index is described in the documents
    <?php echo checkurl("makeindex/ind"); ?>Index Preparation and Processing</a> and the
    <?php echo checkurl("makeindex/makeindex"); ?>Makeindex  user guide</a>.</p>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/makeindex.txt");
?>
    <h3><a name="dvips">Dvips</a></h3>
    <p>The full documentation for the 
    <?php echo checkurl("programs/dvips.pdf"); ?>dvips</a> DVI -&gt; PostScript
    translator. N.B. The advice concerning including PostScript graphics
    has been superceded by the standard LaTeX2e
    <?php echo checkurl("latex/graphics/grfguide"); ?>graphics</a> package.</p>
    
    <p>Type I versions of the computer-modern fonts are used by default when invoking <kbd>dvips</kbd> in teTeX. Command arguments such as <kbd>-Pcmz</kbd> or <kbd>-Pamz</kbd> are no longer needed. Type 1 fonts are scaleable so the resulting PostScript does not
    include bitmapped fonts and is therefore resolution-independent.
    This is very useful if the postscript is to be scaled up or down
    or the final destination printer is not known.</p>
<?php if ($local<>"no") 
include ($texmflocaldoc . "nhi/dvips.txt");
?>
    <h3><a name="dvipdfm">Dvipdfm</a></h3>
<p>A dvi to pdf translator with extra features and its <?php echo checkurl("programs/dvipdfm"); ?>documentation</a>. Web page at <tt><a href="http://gaspra.kettering.edu/dvipdfm/">http://gaspra.kettering.edu/dvipdfm/</a></tt>.</p>
    <h3><a name="dvipng">Dvipng</a></h3>
<p>A fast <tt>dvi</tt> to <tt>png</tt> converter. Developed within the <a href="http://freshmeat.net/redir/dvipng/38256/url_homepage/preview-latex">preview-latex</a> project. Information on using dvipng is available from its <?php
 if ($mancapable)
{
  echo  " <a href=\"man:dvipng\">unix &quot;man&quot; page</a>.";
}
else
{
  echo " unix &quot;man&quot; page. Use <kbd>man dvipng</kbd> to read it.";
}
    ?></p>
    <h3><a name="epstopdf">Epstopdf</a></h3>
    <p>The <kbd>epstopdf</kbd> program converts <tt>*.eps</tt> files to <tt>*.pdf</tt> preserving page size and coordinates. <?php
 if ($mancapable)
{
  echo  " See the <a href=\"man:epstopdf\">unix &quot;man&quot; page</a>.";
}
else
{
  echo " Use <kbd>man epstopdf</kbd> to read the unix &quot;man&quot; page.";
}
    ?></p>
    <h3><a name="xdvi">Xdvi</a></h3>
    <p>A dvi viewer. The online documentation for <kbd>xdvi</kbd> is available as a 
<?php
 if ($mancapable)
{
  echo  " <a href=\"man:xdvi\">unix &quot;man&quot; page</a>.";
}
else
{
  echo " unix &quot;man&quot; page. Use <kbd>man xdvi</kbd> to read it.";
}
    ?></p>
    
    <h3><a name="texinfo">Texinfo</a></h3>
    <p><?php echo checkurl("programs/texinfo"); ?>Texinfo</a> is a macro package for TeX used by the GNU system for producing manuals in different formats including the online 
<?php
if ($infocapable=="yes")
{
  echo  " <a href=\"info:texinfo\">info</a> ";
}
else
{
  echo " info ";
}
?>
system and printed manuals. Also included is <?php
 if ($mancapable)
{
  echo  " <a href=\"man:texi2html\"><code>texi2html</code></a>";
}
else
{
  echo " <code>texi2html</code>";
}
    ?> which will convert texinfo files to html.</p>




<?php
if ($local <> "no")
{
include($texmflocaldoc . "nhi/local.txt"); 
}
?>

<?php
if ($texman <> "" and $texmanhtml == "")
{
  echo "<h2><a name=\"man\">Man pages</a></h2>
<p>Unix man pages included with teTeX range from being little more than a pointer to other documentation to being the main or sometimes unique source of information about a given application. For reference, a full list follows.</p>";
  echo "&nbsp;";
##### Needs simplifying
  if ( ! $mancapable )
    {
      foreach (glob($texman . "man*/*") as $manpage) 
	{
	  $manbits=explode(".",basename($manpage));
	  $nummanbits=count($manbits);
	  $section=$manbits[$nummanbits-1];
	  $manbase=$manbits[0];
	  $k=1;
	  while ($k<$nummanbits - 1)
	    {
	      $manbase=$manbase . "." . $manbits[$k];
	      $k++;
	    }
	  echo "&nbsp;<kbd><b>" . $manbase . "(" . $section . ")</b></kbd> &nbsp;";
	}
    }
  else
    {
      foreach (glob($texman . "man*/*") as $manpage) 
	{
	  $manbits=explode(".",basename($manpage));
	  $nummanbits=count($manbits);
	  $section=$manbits[$nummanbits-1];
	  $manbase=$manbits[0];
	  $k=1;
	  while ($k<$nummanbits - 1)
	    {
	      $manbase=$manbase . "." . $manbits[$k];
	      $k++;
	    }
	  echo "&nbsp;<kbd><b><a href=\"man:" . $manbase . "(" . $section . ")\">" . $manbase . "(" . $section . ")</a></b></kbd> &nbsp;";
	}
    }
  echo "
<p>A few of these are also available using the <kbd>info</kbd> system.</p>
<p>On a terminal window type <kbd>man <em>application_name</em></kbd> (or <kbd>info <em>application_name</em></kbd>) followed by <kbd>&lt;return&gt;</kbd> as appropriate. If a man page number appears more than once in the above list you may need to use <kbd>man <em>section application_name</em></kbd> where <kbd>section</kbd> refers to what is indicated inside ().</p>";
}	
?>

<?php
if ($texman == "" and $texmanhtml <> "")
{
  echo "<h2><a name=\"man\">Man pages</a></h2>
<p>Unix man pages included with teTeX range from being little more than a pointer to other documentation to being the main or sometimes unique source of information about a given application. For reference, a full list follows.</p>";
  echo "&nbsp;";
      foreach (glob($texmanhtml . "man*/*") as $manpage) 
	{
	  $manbits=explode(".",basename($manpage));
	  $nummanbits=count($manbits);
	  $section=$manbits[$nummanbits-2];
	  $manbase=$manbits[0];
	  $k=1;
	  while ($k<$nummanbits - 2)
	    {
	      $manbase=$manbase . "." . $manbits[$k];
	      $k++;
	    }
	  echo "&nbsp;<kbd><b><a href=\"../../texmf-local/doc/man/man" . $section . "/" . $manbase . "." . $section . ".html\">" . $manbase . "(" . $section . ")</a></b></kbd> &nbsp;";
	}
  echo "
<p>A few of these are also available using the <kbd>info</kbd> system.</p>
<p>On a terminal window type <kbd>man <em>application_name</em></kbd> (or <kbd>info <em>application_name</em></kbd>) followed by <kbd>&lt;return&gt;</kbd> as appropriate. If a man page number appears more than once in the above list you may need to use <kbd>man <em>section application_name</em></kbd> where <kbd>section</kbd> refers to what is indicated inside ().</p>";
}	
?>


    <h2><a name="more">Other sources of Information</a></h2>

    <p>Here are some other useful sources of information on LaTeX, TeX and
    related programs on the World-Wide Web.</p>

    <ul>
      <li>The <a href="http://www.tug.org/">TeX user&rsquo;s group</a>.
      <li>Cambridge university&rsquo;s <a
	  href="http://www-h.eng.cam.ac.uk/help/tpl/textprocessing/">Text
	  Processing using LaTeX</a> site.  This contains a mine of useful
	information.
      <li>The <a
	  href="http://tex.loria.fr/">LaTeX
	  Navigator</a>.
    </ul>
<p>Your local installation may have details about local additions at <a href="../../texmf-local/doc/"><tt>$TEXMFLOCAL/doc</tt></a> or <a href="<?php echo $urldoc . $PHP_SELF . "?local=yes" ; ?>">by accessing this page with the <tt>?local=yes</tt> modifier</a>.</p>
<hr />
<table width="100%" border="0">
<tr><td><p style="font-size:smaller; font-family:Arial, Helvetica, sans-serif;">Last update: <em>
<?php
setlocale("LC_TIME","en_US"); 
echo strftime("%B %d, %Y, %Hh %Mm WET", filemtime($_SERVER['SCRIPT_FILENAME']));
?>
</em>.</p>


<p style="font-size:smaller; font-family:Arial, Helvetica, sans-serif;">Originally by Keith Refson. 
Currently maintained by Joo P Matos.
</p></td>
<td align="right">

<!-- Validation buttons only from the local network; 
COMMENT out if necessary -->
<?php
if ($network  == "math.ist.utl.pt" )
echo "
<p>
<a href=\"http://jigsaw.w3.org/css-validator/\">
<img style=\"border:0;width:88px;height:31px\"
     src=\"http://jigsaw.w3.org/css-validator/images/vcss\" 
     alt=\"Valid CSS!\">
</a>
</p>
<p>
<a href=\"http://validator.w3.org/check/referer\"><img border=\"0\"
     src=\"http://www.w3.org/Icons/valid-html401\"
     alt=\"Valid HTML 4.01!\" height=\"31\" width=\"88\"></a>
</p>
";
?>

<!-- End of validation buttons section -->

</td>
</tr>
</table>
</body>
</html>
