/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.walls;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.antcontrib.walls.Package;

public class Walls {
    private List packages = new LinkedList();
    private Map nameToPackage = new HashMap();

    public Package getPackage(String name) {
        return (Package)this.nameToPackage.get(name);
    }

    public void addConfiguredPackage(Package p) {
        String[] depends;
        String pack = p.getPackage();
        if (!pack.endsWith(".*") && !pack.endsWith(".**")) {
            p.setFaultReason("The package='" + pack + "' must end with " + ".* or .** such as biz.xsoftware.* or " + "biz.xsoftware.**");
        }
        if ((depends = p.getDepends()) == null) {
            this.nameToPackage.put(p.getName(), p);
            this.packages.add(p);
            return;
        }
        for (int i = 0; i < depends.length; ++i) {
            Package dependsPackage = (Package)this.nameToPackage.get(depends[i]);
            if (dependsPackage != null) continue;
            p.setFaultReason("package name=" + p.getName() + " did not have " + depends[i] + " listed before it and cannot compile without it");
        }
        this.nameToPackage.put(p.getName(), p);
        this.packages.add(p);
    }

    public Iterator getPackagesToCompile() {
        return this.packages.iterator();
    }
}

