/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class OneItemGoneIterator
implements SequenceIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private SequenceIterator baseIterator;
    private boolean catchingUp;

    public OneItemGoneIterator(SequenceIterator baseIterator) {
        this.baseIterator = baseIterator;
        if (baseIterator.position() != 1) {
            throw new IllegalStateException();
        }
        this.catchingUp = true;
    }

    public Item next() throws XPathException {
        if (this.catchingUp) {
            this.catchingUp = false;
            return this.baseIterator.current();
        }
        return this.baseIterator.next();
    }

    public Item current() {
        return this.catchingUp ? null : this.baseIterator.current();
    }

    public int position() {
        return this.catchingUp ? 0 : this.baseIterator.position();
    }

    public void close() {
        this.baseIterator.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return this.baseIterator.getAnother();
    }

    public int getProperties() {
        return this.baseIterator.getProperties();
    }

    public int getLastPosition() throws XPathException {
        return ((LastPositionFinder)((Object)this.baseIterator)).getLastPosition();
    }

    public GroundedValue materialize() throws XPathException {
        return ((GroundedIterator)this.baseIterator).materialize();
    }

    public boolean hasNext() {
        return this.catchingUp || ((LookaheadIterator)this.baseIterator).hasNext();
    }
}

