/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Code to implement the __has_attribute logic                                *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: Attr.td                                                              *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

const llvm::Triple &T = Target.getTriple();
switch (Syntax) {
case AttributeCommonInfo::Syntax::AS_GNU:
  return llvm::StringSwitch<int>(Name)
    .Case("aarch64_sve_pcs", 1)
    .Case("aarch64_vector_pcs", 1)
    .Case("amdgpu_flat_work_group_size", 1)
    .Case("amdgpu_kernel", 1)
    .Case("amdgpu_max_num_work_groups", 1)
    .Case("amdgpu_num_sgpr", 1)
    .Case("amdgpu_num_vgpr", 1)
    .Case("amdgpu_waves_per_eu", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("signal", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("abi_tag", 1)
    .Case("acquire_capability", 1)
    .Case("acquire_shared_capability", 1)
    .Case("exclusive_lock_function", 1)
    .Case("shared_lock_function", 1)
    .Case("acquire_handle", 1)
    .Case("acquired_after", 1)
    .Case("acquired_before", 1)
    .Case("address_space", 1)
    .Case("alias", 1)
    .Case("align_value", 1)
    .Case("aligned", 1)
    .Case("alloc_align", 1)
    .Case("alloc_size", 1)
    .Case("allocating", 1)
    .Case("always_destroy", 1)
    .Case("always_inline", 1)
    .Case("analyzer_noreturn", 1)
    .Case("annotate", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("no_caller_saved_registers", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("nocf_check", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("objc_arc_weak_reference_unavailable", 1)
    .Case("argument_with_type_tag", 1)
    .Case("pointer_with_type_tag", 1)
    .Case("__clang_arm_builtin_alias", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb || T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32) ? 1 : 0)
    .Case("__clang_arm_mve_strict_polymorphism", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("arm_sve_vector_bits", 1)
    .Case("artificial", 1)
    .Case("assert_capability", 1)
    .Case("assert_shared_capability", 1)
    .Case("assert_exclusive_lock", 1)
    .Case("assert_shared_lock", 1)
    .Case("assume_aligned", 1)
    .Case("availability", 1)
    .Case("available_only_in_default_eval_method", 1)
    .Case("bpf_fastcall", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_access_index", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_static_offset", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("btf_decl_tag", 1)
    .Case("btf_type_tag", 1)
    .Case("blocking", 1)
    .Case("blocks", 1)
    .Case("bounded", 1)
    .Case("clang_builtin_alias", 1)
    .Case("cdecl", 1)
    .Case("cf_audited_transfer", 1)
    .Case("cf_consumed", 1)
    .Case("guard", true && (T.getOS() == llvm::Triple::Win32) ? 1 : 0)
    .Case("cfi_canonical_jump_table", 1)
    .Case("cf_returns_not_retained", 1)
    .Case("cf_returns_retained", 1)
    .Case("cf_unknown_transfer", 1)
    .Case("cpu_dispatch", 1)
    .Case("cpu_specific", 1)
    .Case("constant", 1)
    .Case("cudart_builtin", 1)
    .Case("device", 1)
    .Case("device_builtin", 1)
    .Case("device_builtin_surface_type", 1)
    .Case("device_builtin_texture_type", 1)
    .Case("global", 1)
    .Case("grid_constant", 1)
    .Case("host", 1)
    .Case("launch_bounds", 1)
    .Case("shared", 1)
    .Case("assume", 1)
    .Case("callable_when", 1)
    .Case("callback", 1)
    .Case("called_once", 1)
    .Case("capability", 1)
    .Case("shared_capability", 1)
    .Case("carries_dependency", 1)
    .Case("cleanup", 1)
    .Case("clspv_libclc_builtin", 1)
    .Case("cmse_nonsecure_call", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("cmse_nonsecure_entry", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("code_align", 1)
    .Case("model", true && (T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64) ? 1 : 0)
    .Case("cold", 1)
    .Case("common", 1)
    .Case("const", 1)
    .Case("__const", 1)
    .Case("require_constant_initialization", 1)
    .Case("constructor", 1)
    .Case("consumable", 1)
    .Case("consumable_auto_cast_state", 1)
    .Case("consumable_set_state_on_read", 1)
    .Case("convergent", 1)
    .Case("coro_await_elidable", 1)
    .Case("coro_await_elidable_argument", 1)
    .Case("coro_disable_lifetimebound", 1)
    .Case("coro_lifetimebound", 1)
    .Case("coro_only_destroy_when_complete", 1)
    .Case("coro_return_type", 1)
    .Case("coro_wrapper", 1)
    .Case("counted_by", 1)
    .Case("counted_by_or_null", 1)
    .Case("dllexport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("dllimport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("deprecated", 1)
    .Case("destructor", 1)
    .Case("diagnose_as_builtin", 1)
    .Case("diagnose_if", 1)
    .Case("disable_sanitizer_instrumentation", 1)
    .Case("disable_tail_calls", 1)
    .Case("enable_if", 1)
    .Case("enforce_tcb", 1)
    .Case("enforce_tcb_leaf", 1)
    .Case("enum_extensibility", 1)
    .Case("error", 1)
    .Case("warning", 1)
    .Case("exclude_from_explicit_instantiation", 1)
    .Case("exclusive_trylock_function", 1)
    .Case("require_explicit_initialization", 1)
    .Case("ext_vector_type", 1)
    .Case("external_source_symbol", 20230206)
    .Case("fallthrough", 1)
    .Case("fastcall", 1)
    .Case("flag_enum", 1)
    .Case("flatten", 1)
    .Case("format", 1)
    .Case("format_arg", 1)
    .Case("function_return", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("gnu_inline", 1)
    .Case("guarded_by", 1)
    .Case("guarded_var", 1)
    .Case("managed", 1)
    .Case("hot", 1)
    .Case("hybrid_patchable", true && ( Target.getTriple().isWindowsArm64EC() ) ? 1 : 0)
    .Case("ibaction", 1)
    .Case("iboutlet", 1)
    .Case("iboutletcollection", 1)
    .Case("ifunc", true && ( Target.supportsIFunc() ) ? 1 : 0)
    .Case("init_priority", true && ( !Target.getTriple().isOSzOS() ) ? 1 : 0)
    .Case("intel_ocl_bicc", 1)
    .Case("internal_linkage", 1)
    .Case("lto_visibility_public", 1)
    .Case("leaf", 1)
    .Case("lifetimebound", 1)
    .Case("lifetime_capture_by", 1)
    .Case("loader_uninitialized", 1)
    .Case("lock_returned", 1)
    .Case("lockable", 1)
    .Case("locks_excluded", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::m68k) ? 1 : 0)
    .Case("m68k_rtd", 1)
    .Case("mig_server_routine", 1)
    .Case("ms_abi", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::msp430) ? 1 : 0)
    .Case("ms_struct", 1)
    .Case("matrix_type", 1)
    .Case("may_alias", 1)
    .Case("maybe_undef", 1)
    .Case("micromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("minsize", 1)
    .Case("min_vector_width", 1)
    .Case("mips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("long_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("far", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("short_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("near", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("mode", 1)
    .Case("musttail", 1)
    .Case("ns_consumed", 1)
    .Case("ns_consumes_self", 1)
    .Case("ns_error_domain", 1)
    .Case("ns_returns_autoreleased", 1)
    .Case("ns_returns_not_retained", 1)
    .Case("ns_returns_retained", 1)
    .Case("nvptx_kernel", true && (T.getArch() == llvm::Triple::nvptx || T.getArch() == llvm::Triple::nvptx64) ? 1 : 0)
    .Case("naked", 1)
    .Case("neon_polyvector_type", 1)
    .Case("neon_vector_type", 1)
    .Case("no_builtin", 1)
    .Case("nocommon", 1)
    .Case("noconvergent", 1)
    .Case("nodebug", 1)
    .Case("noderef", 1)
    .Case("no_destroy", 1)
    .Case("noduplicate", 1)
    .Case("noescape", 1)
    .Case("noinline", 1)
    .Case("no_instrument_function", 1)
    .Case("nomerge", 1)
    .Case("nomicromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("nomips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("no_profile_instrument_function", 1)
    .Case("no_randomize_layout", 1)
    .Case("noreturn", 1)
    .Case("no_sanitize", 1)
    .Case("no_address_safety_analysis", 1)
    .Case("no_sanitize_address", 1)
    .Case("no_sanitize_thread", 1)
    .Case("no_sanitize_memory", 1)
    .Case("no_specializations", 1)
    .Case("no_speculative_load_hardening", 1)
    .Case("no_split_stack", 1)
    .Case("no_stack_protector", 1)
    .Case("no_thread_safety_analysis", 1)
    .Case("nothrow", 1)
    .Case("nouwtable", 1)
    .Case("nonallocating", 1)
    .Case("nonblocking", 1)
    .Case("nonnull", 1)
    .Case("not_tail_called", 1)
    .Case("nv_weak", 1)
    .Case("os_consumed", 1)
    .Case("os_consumes_this", 1)
    .Case("os_returns_not_retained", 1)
    .Case("os_returns_retained", 1)
    .Case("os_returns_retained_on_non_zero", 1)
    .Case("os_returns_retained_on_zero", 1)
    .Case("objc_boxable", 1)
    .Case("objc_bridge", 1)
    .Case("objc_bridge_mutable", 1)
    .Case("objc_bridge_related", 1)
    .Case("objc_class_stub", 1)
    .Case("objc_designated_initializer", 1)
    .Case("objc_direct", 1)
    .Case("objc_direct_members", 1)
    .Case("objc_exception", 1)
    .Case("objc_protocol_requires_explicit_implementation", 1)
    .Case("objc_externally_retained", 1)
    .Case("objc_gc", 1)
    .Case("objc_independent_class", 1)
    .Case("objc_method_family", 1)
    .Case("NSObject", 1)
    .Case("objc_nonlazy_class", 1)
    .Case("objc_non_runtime_protocol", 1)
    .Case("objc_ownership", 1)
    .Case("objc_precise_lifetime", 1)
    .Case("objc_requires_property_definitions", 1)
    .Case("objc_requires_super", 1)
    .Case("objc_returns_inner_pointer", 1)
    .Case("objc_root_class", 1)
    .Case("objc_runtime_name", 1)
    .Case("objc_runtime_visible", 1)
    .Case("objc_subclassing_restricted", 1)
    .Case("opencl_constant", 1)
    .Case("opencl_generic", 1)
    .Case("opencl_global", 1)
    .Case("opencl_global_device", 1)
    .Case("opencl_global_host", 1)
    .Case("intel_reqd_sub_group_size", 1)
    .Case("opencl_local", 1)
    .Case("nosvm", 1)
    .Case("opencl_private", 1)
    .Case("opencl_unroll_hint", 1)
    .Case("optnone", 1)
    .Case("overloadable", 1)
    .Case("ownership_holds", 1)
    .Case("ownership_returns", 1)
    .Case("ownership_takes", 1)
    .Case("packed", 1)
    .Case("param_typestate", 1)
    .Case("pascal", 1)
    .Case("pass_object_size", 1)
    .Case("pass_dynamic_object_size", 1)
    .Case("patchable_function_entry", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::ppc || T.getArch() == llvm::Triple::ppc64) ? 1 : 0)
    .Case("pcs", 1)
    .Case("preferred_name", 1)
    .Case("preferred_type", 1)
    .Case("preserve_all", 1)
    .Case("preserve_most", 1)
    .Case("preserve_none", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("pt_guarded_by", 1)
    .Case("pt_guarded_var", 1)
    .Case("pure", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("riscv_rvv_vector_bits", 1)
    .Case("riscv_vector_cc", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("randomize_layout", 1)
    .Case("enforce_read_only_placement", 1)
    .Case("regcall", 1)
    .Case("regparm", 1)
    .Case("reinitializes", 1)
    .Case("release_capability", 1)
    .Case("release_shared_capability", 1)
    .Case("release_generic_capability", 1)
    .Case("unlock_function", 1)
    .Case("release_handle", 1)
    .Case("reqd_work_group_size", 1)
    .Case("requires_capability", 1)
    .Case("exclusive_locks_required", 1)
    .Case("requires_shared_capability", 1)
    .Case("shared_locks_required", 1)
    .Case("malloc", 1)
    .Case("retain", 1)
    .Case("return_typestate", 1)
    .Case("returns_nonnull", 1)
    .Case("returns_twice", 1)
    .Case("sycl_kernel", 1)
    .Case("sycl_kernel_entry_point", 1)
    .Case("sycl_special_class", 1)
    .Case("scoped_lockable", 1)
    .Case("section", 1)
    .Case("selectany", 1)
    .Case("sentinel", 1)
    .Case("set_typestate", 1)
    .Case("shared_trylock_function", 1)
    .Case("sized_by", 1)
    .Case("sized_by_or_null", 1)
    .Case("speculative_load_hardening", 1)
    .Case("standalone_debug", 1)
    .Case("stdcall", 1)
    .Case("suppress", 1)
    .Case("swift_async", 1)
    .Case("swiftasynccall", 1)
    .Case("swift_async_context", 1)
    .Case("swift_async_error", 1)
    .Case("swift_async_name", 1)
    .Case("swift_attr", 1)
    .Case("swift_bridge", 1)
    .Case("swift_bridged_typedef", 1)
    .Case("swiftcall", 1)
    .Case("swift_context", 1)
    .Case("swift_error", 1)
    .Case("swift_error_result", 1)
    .Case("swift_indirect_result", 1)
    .Case("swift_name", 1)
    .Case("swift_newtype", 1)
    .Case("swift_wrapper", 1)
    .Case("swift_objc_members", 1)
    .Case("swift_private", 1)
    .Case("sysv_abi", 1)
    .Case("tls_model", 1)
    .Case("target", 1)
    .Case("target_clones", 1)
    .Case("target_version", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("test_typestate", 1)
    .Case("thiscall", 1)
    .Case("transparent_union", 1)
    .Case("trivial_abi", 1)
    .Case("try_acquire_capability", 1)
    .Case("try_acquire_shared_capability", 1)
    .Case("type_tag_for_datatype", 1)
    .Case("type_visibility", 1)
    .Case("unavailable", 1)
    .Case("uninitialized", 1)
    .Case("unsafe_buffer_usage", 1)
    .Case("unused", 1)
    .Case("use_handle", 1)
    .Case("used", 1)
    .Case("using_if_exists", 1)
    .Case("ptrauth_vtable_pointer", 1)
    .Case("vecreturn", 1)
    .Case("vec_type_hint", 1)
    .Case("vectorcall", 1)
    .Case("vector_size", 1)
    .Case("visibility", 1)
    .Case("warn_unused", 1)
    .Case("warn_unused_result", 1)
    .Case("weak", 1)
    .Case("weak_import", 1)
    .Case("weakref", 1)
    .Case("export_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_module", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("work_group_size_hint", 1)
    .Case("force_align_arg_pointer", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("xray_always_instrument", 1)
    .Case("xray_never_instrument", 1)
    .Case("xray_log_args", 1)
    .Case("zero_call_used_regs", 1)
    .Default(0);
case AttributeCommonInfo::Syntax::AS_Declspec:
  return llvm::StringSwitch<int>(Name)
    .Case("align", 1)
    .Case("guard", true && (T.getOS() == llvm::Triple::Win32) ? 1 : 0)
    .Case("cpu_dispatch", 1)
    .Case("cpu_specific", 1)
    .Case("__constant__", 1)
    .Case("__cudart_builtin__", 1)
    .Case("__device__", 1)
    .Case("__device_builtin__", 1)
    .Case("__device_builtin_surface_type__", 1)
    .Case("__device_builtin_texture_type__", 1)
    .Case("__global__", 1)
    .Case("__grid_constant__", 1)
    .Case("__host__", 1)
    .Case("__launch_bounds__", 1)
    .Case("__shared__", 1)
    .Case("code_seg", 1)
    .Case("dllexport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("dllimport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("deprecated", 1)
    .Case("empty_bases", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::aarch64) && ( Target.getCXXABI().isMicrosoft() ) ? 1 : 0)
    .Case("__managed__", 1)
    .Case("hybrid_patchable", true && ( Target.getTriple().isWindowsArm64EC() ) ? 1 : 0)
    .Case("layout_version", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::aarch64) && ( Target.getCXXABI().isMicrosoft() ) ? 1 : 0)
    .Case("allocator", 1)
    .Case("novtable", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::aarch64) && ( Target.getCXXABI().isMicrosoft() ) ? 1 : 0)
    .Case("naked", 1)
    .Case("noalias", 1)
    .Case("noconvergent", 1)
    .Case("noinline", 1)
    .Case("noreturn", 1)
    .Case("safebuffers", 1)
    .Case("nothrow", 1)
    .Case("no_init_all", 1)
    .Case("restrict", 1)
    .Case("allocate", 1)
    .Case("selectany", 1)
    .Case("strict_gs_check", 1)
    .Case("thread", 1)
    .Case("uuid", 1)
    .Case("property", 1)
    .Default(0);
case AttributeCommonInfo::Syntax::AS_Microsoft:
  return llvm::StringSwitch<int>(Name)
    .Case("branch", 1)
    .Case("flatten", 1)
    .Case("unroll", 1)
    .Case("loop", 1)
    .Case("numthreads", 1)
    .Case("shader", 1)
    .Case("WaveSize", 1)
    .Case("uuid", 1)
    .Default(0);
case AttributeCommonInfo::Syntax::AS_Pragma:
  return llvm::StringSwitch<int>(Name)
    .Case("init_seg", 1)
    .Case("loop", 1)
    .Case("unroll", 1)
    .Case("nounroll", 1)
    .Case("unroll_and_jam", 1)
    .Case("nounroll_and_jam", 1)
    .Case("declare simd", 1)
    .Case("declare target", 1)
    .Case("declare variant", 1)
    .Default(0);
case AttributeCommonInfo::Syntax::AS_HLSLAnnotation:
  return llvm::StringSwitch<int>(Name)
    .Case("packoffset", 1)
    .Case("register", 1)
    .Case("SV_DispatchThreadID", 1)
    .Case("SV_GroupID", 1)
    .Case("SV_GroupIndex", 1)
    .Case("SV_GroupThreadID", 1)
    .Default(0);
case AttributeCommonInfo::Syntax::AS_CXX11: {
if (ScopeName == "") {
  return llvm::StringSwitch<int>(Name)
    .Case("noreturn", 200809)
    .Case("assume", 202207)
    .Case("carries_dependency", 200809)
    .Case("deprecated", 201309)
    .Case("fallthrough", 201603)
    .Case("likely", 201803)
    .Case("no_unique_address", true && ( Target.getCXXABI().isItaniumFamily() ) ? 201803 : 0)
    .Case("unlikely", 201803)
    .Case("maybe_unused", 201603)
    .Case("nodiscard", 201907)
    .Default(0);
} else if (ScopeName == "clang") {
  return llvm::StringSwitch<int>(Name)
    .Case("aarch64_sve_pcs", 1)
    .Case("aarch64_vector_pcs", 1)
    .Case("amdgpu_flat_work_group_size", 1)
    .Case("amdgpu_kernel", 1)
    .Case("amdgpu_max_num_work_groups", 1)
    .Case("amdgpu_num_sgpr", 1)
    .Case("amdgpu_num_vgpr", 1)
    .Case("amdgpu_waves_per_eu", 1)
    .Case("acquire_capability", 1)
    .Case("acquire_shared_capability", 1)
    .Case("acquire_handle", 1)
    .Case("address_space", 1)
    .Case("allocating", 1)
    .Case("always_destroy", 1)
    .Case("always_inline", 1)
    .Case("annotate", 1)
    .Case("annotate_type", 1)
    .Case("objc_arc_weak_reference_unavailable", 1)
    .Case("argument_with_type_tag", 1)
    .Case("pointer_with_type_tag", 1)
    .Case("__clang_arm_builtin_alias", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb || T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32) ? 1 : 0)
    .Case("__clang_arm_mve_strict_polymorphism", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("assert_capability", 1)
    .Case("assert_shared_capability", 1)
    .Case("availability", 1)
    .Case("available_only_in_default_eval_method", 1)
    .Case("bpf_fastcall", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_access_index", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_static_offset", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("btf_decl_tag", 1)
    .Case("btf_type_tag", 1)
    .Case("blocking", 1)
    .Case("blocks", 1)
    .Case("builtin_alias", 1)
    .Case("cf_audited_transfer", 1)
    .Case("cf_consumed", 1)
    .Case("guard", true && (T.getOS() == llvm::Triple::Win32) ? 1 : 0)
    .Case("cfi_canonical_jump_table", 1)
    .Case("cf_returns_not_retained", 1)
    .Case("cf_returns_retained", 1)
    .Case("cf_unknown_transfer", 1)
    .Case("cpu_dispatch", 1)
    .Case("cpu_specific", 1)
    .Case("assume", 1)
    .Case("callable_when", 1)
    .Case("callback", 1)
    .Case("called_once", 1)
    .Case("capability", 1)
    .Case("shared_capability", 1)
    .Case("clspv_libclc_builtin", 1)
    .Case("code_align", 1)
    .Case("require_constant_initialization", 1)
    .Case("consumable", 1)
    .Case("consumable_auto_cast_state", 1)
    .Case("consumable_set_state_on_read", 1)
    .Case("convergent", 1)
    .Case("coro_await_elidable", 1)
    .Case("coro_await_elidable_argument", 1)
    .Case("coro_disable_lifetimebound", 1)
    .Case("coro_lifetimebound", 1)
    .Case("coro_only_destroy_when_complete", 1)
    .Case("coro_return_type", 1)
    .Case("coro_wrapper", 1)
    .Case("counted_by", 1)
    .Case("counted_by_or_null", 1)
    .Case("diagnose_as_builtin", 1)
    .Case("disable_sanitizer_instrumentation", 1)
    .Case("disable_tail_calls", 1)
    .Case("enforce_tcb", 1)
    .Case("enforce_tcb_leaf", 1)
    .Case("enum_extensibility", 1)
    .Case("exclude_from_explicit_instantiation", 1)
    .Case("require_explicit_initialization", 1)
    .Case("external_source_symbol", 20230206)
    .Case("fallthrough", 1)
    .Case("flag_enum", 1)
    .Case("guarded_var", 1)
    .Case("hybrid_patchable", true && ( Target.getTriple().isWindowsArm64EC() ) ? 1 : 0)
    .Case("ibaction", 1)
    .Case("iboutlet", 1)
    .Case("iboutletcollection", 1)
    .Case("intel_ocl_bicc", 1)
    .Case("internal_linkage", 1)
    .Case("lto_visibility_public", 1)
    .Case("lifetimebound", 1)
    .Case("lifetime_capture_by", 1)
    .Case("loader_uninitialized", 1)
    .Case("m68k_rtd", 1)
    .Case("mig_server_routine", 1)
    .Case("matrix_type", 1)
    .Case("maybe_undef", 1)
    .Case("minsize", 1)
    .Case("min_vector_width", 1)
    .Case("musttail", 1)
    .Case("ns_consumed", 1)
    .Case("ns_consumes_self", 1)
    .Case("ns_returns_autoreleased", 1)
    .Case("ns_returns_not_retained", 1)
    .Case("ns_returns_retained", 1)
    .Case("nvptx_kernel", true && (T.getArch() == llvm::Triple::nvptx || T.getArch() == llvm::Triple::nvptx64) ? 1 : 0)
    .Case("neon_polyvector_type", 1)
    .Case("neon_vector_type", 1)
    .Case("no_builtin", 1)
    .Case("noconvergent", 1)
    .Case("noderef", 1)
    .Case("no_destroy", 1)
    .Case("noduplicate", 1)
    .Case("noescape", 1)
    .Case("noinline", 1)
    .Case("nomerge", 1)
    .Case("no_sanitize", 1)
    .Case("no_sanitize_memory", 1)
    .Case("no_specializations", 1)
    .Case("no_speculative_load_hardening", 1)
    .Case("no_stack_protector", 1)
    .Case("no_thread_safety_analysis", 1)
    .Case("nouwtable", 1)
    .Case("nonallocating", 1)
    .Case("nonblocking", 1)
    .Case("not_tail_called", 1)
    .Case("os_consumed", 1)
    .Case("os_consumes_this", 1)
    .Case("os_returns_not_retained", 1)
    .Case("os_returns_retained", 1)
    .Case("os_returns_retained_on_non_zero", 1)
    .Case("os_returns_retained_on_zero", 1)
    .Case("objc_boxable", 1)
    .Case("objc_bridge", 1)
    .Case("objc_bridge_mutable", 1)
    .Case("objc_bridge_related", 1)
    .Case("objc_class_stub", 1)
    .Case("objc_designated_initializer", 1)
    .Case("objc_direct", 1)
    .Case("objc_direct_members", 1)
    .Case("objc_exception", 1)
    .Case("objc_protocol_requires_explicit_implementation", 1)
    .Case("objc_externally_retained", 1)
    .Case("objc_gc", 1)
    .Case("objc_independent_class", 1)
    .Case("objc_method_family", 1)
    .Case("NSObject", 1)
    .Case("objc_nonlazy_class", 1)
    .Case("objc_non_runtime_protocol", 1)
    .Case("objc_ownership", 1)
    .Case("objc_precise_lifetime", 1)
    .Case("objc_requires_property_definitions", 1)
    .Case("objc_requires_super", 1)
    .Case("objc_returns_inner_pointer", 1)
    .Case("objc_root_class", 1)
    .Case("objc_runtime_name", 1)
    .Case("objc_runtime_visible", 1)
    .Case("objc_subclassing_restricted", 1)
    .Case("opencl_constant", 1)
    .Case("opencl_generic", 1)
    .Case("opencl_global", 1)
    .Case("opencl_global_device", 1)
    .Case("opencl_global_host", 1)
    .Case("opencl_local", 1)
    .Case("opencl_private", 1)
    .Case("optnone", 1)
    .Case("overloadable", 1)
    .Case("ownership_holds", 1)
    .Case("ownership_returns", 1)
    .Case("ownership_takes", 1)
    .Case("param_typestate", 1)
    .Case("pascal", 1)
    .Case("pass_object_size", 1)
    .Case("pass_dynamic_object_size", 1)
    .Case("preferred_name", 1)
    .Case("preferred_type", 1)
    .Case("preserve_all", 1)
    .Case("preserve_most", 1)
    .Case("preserve_none", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("pt_guarded_var", 1)
    .Case("riscv_vector_cc", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("enforce_read_only_placement", 1)
    .Case("reinitializes", 1)
    .Case("release_capability", 1)
    .Case("release_shared_capability", 1)
    .Case("release_generic_capability", 1)
    .Case("unlock_function", 1)
    .Case("release_handle", 1)
    .Case("requires_capability", 1)
    .Case("exclusive_locks_required", 1)
    .Case("requires_shared_capability", 1)
    .Case("shared_locks_required", 1)
    .Case("return_typestate", 1)
    .Case("sycl_kernel", 1)
    .Case("sycl_kernel_entry_point", 1)
    .Case("sycl_special_class", 1)
    .Case("scoped_lockable", 1)
    .Case("set_typestate", 1)
    .Case("sized_by", 1)
    .Case("sized_by_or_null", 1)
    .Case("speculative_load_hardening", 1)
    .Case("standalone_debug", 1)
    .Case("suppress", 1)
    .Case("swift_async", 1)
    .Case("swiftasynccall", 1)
    .Case("swift_async_context", 1)
    .Case("swift_async_error", 1)
    .Case("swiftcall", 1)
    .Case("swift_context", 1)
    .Case("swift_error_result", 1)
    .Case("swift_indirect_result", 1)
    .Case("test_typestate", 1)
    .Case("trivial_abi", 1)
    .Case("try_acquire_capability", 1)
    .Case("try_acquire_shared_capability", 1)
    .Case("type_tag_for_datatype", 1)
    .Case("type_visibility", 1)
    .Case("unavailable", 1)
    .Case("uninitialized", 1)
    .Case("unsafe_buffer_usage", 1)
    .Case("use_handle", 1)
    .Case("using_if_exists", 1)
    .Case("ptrauth_vtable_pointer", 1)
    .Case("vecreturn", 1)
    .Case("vectorcall", 1)
    .Case("warn_unused_result", 1)
    .Case("weak_import", 1)
    .Case("export_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_module", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("xray_always_instrument", 1)
    .Case("xray_never_instrument", 1)
    .Case("xray_log_args", 1)
    .Default(0);
} else if (ScopeName == "gnu") {
  return llvm::StringSwitch<int>(Name)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("signal", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("abi_tag", 1)
    .Case("alias", 1)
    .Case("aligned", 1)
    .Case("alloc_align", 1)
    .Case("alloc_size", 1)
    .Case("always_inline", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("no_caller_saved_registers", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("nocf_check", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("artificial", 1)
    .Case("assume_aligned", 1)
    .Case("cdecl", 1)
    .Case("cleanup", 1)
    .Case("model", true && (T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64) ? 1 : 0)
    .Case("cold", 1)
    .Case("common", 1)
    .Case("const", 1)
    .Case("__const", 1)
    .Case("constructor", 1)
    .Case("dllexport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("dllimport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("deprecated", 1)
    .Case("destructor", 1)
    .Case("error", 1)
    .Case("warning", 1)
    .Case("fallthrough", 1)
    .Case("fastcall", 1)
    .Case("flatten", 1)
    .Case("format", 1)
    .Case("format_arg", 1)
    .Case("function_return", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("gnu_inline", 1)
    .Case("hot", 1)
    .Case("ifunc", true && ( Target.supportsIFunc() ) ? 1 : 0)
    .Case("init_priority", true && ( !Target.getTriple().isOSzOS() ) ? 1 : 0)
    .Case("leaf", 1)
    .Case("ms_abi", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::msp430) ? 1 : 0)
    .Case("ms_struct", 1)
    .Case("may_alias", 1)
    .Case("micromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("mips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("long_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("far", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("short_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("near", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("mode", 1)
    .Case("naked", 1)
    .Case("nocommon", 1)
    .Case("nodebug", 1)
    .Case("noinline", 1)
    .Case("no_instrument_function", 1)
    .Case("nomicromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("nomips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("no_profile_instrument_function", 1)
    .Case("no_randomize_layout", 1)
    .Case("noreturn", 1)
    .Case("no_address_safety_analysis", 1)
    .Case("no_sanitize_address", 1)
    .Case("no_sanitize_thread", 1)
    .Case("no_split_stack", 1)
    .Case("no_stack_protector", 1)
    .Case("nothrow", 1)
    .Case("nonnull", 1)
    .Case("packed", 1)
    .Case("patchable_function_entry", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::ppc || T.getArch() == llvm::Triple::ppc64) ? 1 : 0)
    .Case("pcs", 1)
    .Case("pure", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("randomize_layout", 1)
    .Case("regcall", 1)
    .Case("regparm", 1)
    .Case("malloc", 1)
    .Case("retain", 1)
    .Case("returns_nonnull", 1)
    .Case("returns_twice", 1)
    .Case("section", 1)
    .Case("selectany", 1)
    .Case("sentinel", 1)
    .Case("stdcall", 1)
    .Case("sysv_abi", 1)
    .Case("tls_model", 1)
    .Case("target", 1)
    .Case("target_clones", 1)
    .Case("target_version", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("thiscall", 1)
    .Case("transparent_union", 1)
    .Case("unused", 1)
    .Case("used", 1)
    .Case("vector_size", 1)
    .Case("visibility", 1)
    .Case("warn_unused", 1)
    .Case("warn_unused_result", 1)
    .Case("weak", 1)
    .Case("weakref", 1)
    .Case("force_align_arg_pointer", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("zero_call_used_regs", 1)
    .Default(0);
} else if (ScopeName == "gsl") {
  return llvm::StringSwitch<int>(Name)
    .Case("Owner", 1)
    .Case("Pointer", 1)
    .Case("suppress", 1)
    .Default(0);
} else if (ScopeName == "hlsl") {
  return llvm::StringSwitch<int>(Name)
    .Case("contained_type", 1)
    .Case("is_rov", 1)
    .Case("raw_buffer", 1)
    .Case("resource_class", 1)
    .Default(0);
} else if (ScopeName == "msvc") {
  return llvm::StringSwitch<int>(Name)
    .Case("constexpr", 1)
    .Case("noinline", 1)
    .Case("no_unique_address", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::aarch64) && ( Target.getCXXABI().isMicrosoft() ) ? 201803 : 0)
    .Default(0);
} else if (ScopeName == "omp") {
  return llvm::StringSwitch<int>(Name)
    .Case("assume", 1)
    .Default(0);
} else if (ScopeName == "riscv") {
  return llvm::StringSwitch<int>(Name)
    .Case("vector_cc", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Default(0);
}
} break;
case AttributeCommonInfo::Syntax::AS_C23: {
if (ScopeName == "") {
  return llvm::StringSwitch<int>(Name)
    .Case("noreturn", 202202)
    .Case("_Noreturn", 202202)
    .Case("deprecated", 201904)
    .Case("fallthrough", 201910)
    .Case("maybe_unused", 202106)
    .Case("nodiscard", 202003)
    .Default(0);
} else if (ScopeName == "clang") {
  return llvm::StringSwitch<int>(Name)
    .Case("aarch64_sve_pcs", 1)
    .Case("aarch64_vector_pcs", 1)
    .Case("amdgpu_kernel", 1)
    .Case("acquire_handle", 1)
    .Case("address_space", 1)
    .Case("allocating", 1)
    .Case("always_inline", 1)
    .Case("annotate", 1)
    .Case("annotate_type", 1)
    .Case("objc_arc_weak_reference_unavailable", 1)
    .Case("argument_with_type_tag", 1)
    .Case("pointer_with_type_tag", 1)
    .Case("__clang_arm_builtin_alias", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb || T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32) ? 1 : 0)
    .Case("__clang_arm_mve_strict_polymorphism", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("availability", 1)
    .Case("available_only_in_default_eval_method", 1)
    .Case("bpf_fastcall", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_access_index", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("preserve_static_offset", true && (T.getArch() == llvm::Triple::bpfel || T.getArch() == llvm::Triple::bpfeb) ? 1 : 0)
    .Case("btf_decl_tag", 1)
    .Case("btf_type_tag", 1)
    .Case("blocking", 1)
    .Case("blocks", 1)
    .Case("builtin_alias", 1)
    .Case("cf_audited_transfer", 1)
    .Case("cf_consumed", 1)
    .Case("guard", true && (T.getOS() == llvm::Triple::Win32) ? 1 : 0)
    .Case("cfi_canonical_jump_table", 1)
    .Case("cf_returns_not_retained", 1)
    .Case("cf_returns_retained", 1)
    .Case("cf_unknown_transfer", 1)
    .Case("cpu_dispatch", 1)
    .Case("cpu_specific", 1)
    .Case("assume", 1)
    .Case("callback", 1)
    .Case("called_once", 1)
    .Case("clspv_libclc_builtin", 1)
    .Case("code_align", 1)
    .Case("convergent", 1)
    .Case("coro_await_elidable", 1)
    .Case("coro_await_elidable_argument", 1)
    .Case("coro_disable_lifetimebound", 1)
    .Case("coro_lifetimebound", 1)
    .Case("coro_only_destroy_when_complete", 1)
    .Case("coro_return_type", 1)
    .Case("coro_wrapper", 1)
    .Case("counted_by", 1)
    .Case("counted_by_or_null", 1)
    .Case("diagnose_as_builtin", 1)
    .Case("disable_sanitizer_instrumentation", 1)
    .Case("disable_tail_calls", 1)
    .Case("enforce_tcb", 1)
    .Case("enforce_tcb_leaf", 1)
    .Case("enum_extensibility", 1)
    .Case("exclude_from_explicit_instantiation", 1)
    .Case("require_explicit_initialization", 1)
    .Case("external_source_symbol", 20230206)
    .Case("flag_enum", 1)
    .Case("hybrid_patchable", true && ( Target.getTriple().isWindowsArm64EC() ) ? 1 : 0)
    .Case("ibaction", 1)
    .Case("iboutlet", 1)
    .Case("iboutletcollection", 1)
    .Case("internal_linkage", 1)
    .Case("lto_visibility_public", 1)
    .Case("likely", 1)
    .Case("loader_uninitialized", 1)
    .Case("m68k_rtd", 1)
    .Case("mig_server_routine", 1)
    .Case("matrix_type", 1)
    .Case("maybe_undef", 1)
    .Case("minsize", 1)
    .Case("min_vector_width", 1)
    .Case("musttail", 1)
    .Case("ns_consumed", 1)
    .Case("ns_consumes_self", 1)
    .Case("ns_returns_autoreleased", 1)
    .Case("ns_returns_not_retained", 1)
    .Case("ns_returns_retained", 1)
    .Case("nvptx_kernel", true && (T.getArch() == llvm::Triple::nvptx || T.getArch() == llvm::Triple::nvptx64) ? 1 : 0)
    .Case("neon_polyvector_type", 1)
    .Case("neon_vector_type", 1)
    .Case("no_builtin", 1)
    .Case("noconvergent", 1)
    .Case("noderef", 1)
    .Case("noduplicate", 1)
    .Case("noescape", 1)
    .Case("noinline", 1)
    .Case("nomerge", 1)
    .Case("no_sanitize", 1)
    .Case("no_sanitize_memory", 1)
    .Case("no_speculative_load_hardening", 1)
    .Case("no_stack_protector", 1)
    .Case("no_thread_safety_analysis", 1)
    .Case("nouwtable", 1)
    .Case("nonallocating", 1)
    .Case("nonblocking", 1)
    .Case("not_tail_called", 1)
    .Case("os_consumed", 1)
    .Case("os_consumes_this", 1)
    .Case("os_returns_not_retained", 1)
    .Case("os_returns_retained", 1)
    .Case("os_returns_retained_on_non_zero", 1)
    .Case("os_returns_retained_on_zero", 1)
    .Case("objc_boxable", 1)
    .Case("objc_bridge", 1)
    .Case("objc_bridge_mutable", 1)
    .Case("objc_bridge_related", 1)
    .Case("objc_class_stub", 1)
    .Case("objc_designated_initializer", 1)
    .Case("objc_direct", 1)
    .Case("objc_direct_members", 1)
    .Case("objc_exception", 1)
    .Case("objc_protocol_requires_explicit_implementation", 1)
    .Case("objc_externally_retained", 1)
    .Case("objc_gc", 1)
    .Case("objc_independent_class", 1)
    .Case("objc_method_family", 1)
    .Case("NSObject", 1)
    .Case("objc_nonlazy_class", 1)
    .Case("objc_non_runtime_protocol", 1)
    .Case("objc_ownership", 1)
    .Case("objc_precise_lifetime", 1)
    .Case("objc_requires_property_definitions", 1)
    .Case("objc_requires_super", 1)
    .Case("objc_returns_inner_pointer", 1)
    .Case("objc_root_class", 1)
    .Case("objc_runtime_name", 1)
    .Case("objc_runtime_visible", 1)
    .Case("objc_subclassing_restricted", 1)
    .Case("opencl_constant", 1)
    .Case("opencl_generic", 1)
    .Case("opencl_global", 1)
    .Case("opencl_global_device", 1)
    .Case("opencl_global_host", 1)
    .Case("opencl_local", 1)
    .Case("opencl_private", 1)
    .Case("optnone", 1)
    .Case("overloadable", 1)
    .Case("ownership_holds", 1)
    .Case("ownership_returns", 1)
    .Case("ownership_takes", 1)
    .Case("pascal", 1)
    .Case("pass_object_size", 1)
    .Case("pass_dynamic_object_size", 1)
    .Case("preferred_type", 1)
    .Case("preserve_all", 1)
    .Case("preserve_most", 1)
    .Case("preserve_none", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("riscv_vector_cc", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("enforce_read_only_placement", 1)
    .Case("release_handle", 1)
    .Case("sycl_kernel", 1)
    .Case("sycl_kernel_entry_point", 1)
    .Case("sycl_special_class", 1)
    .Case("sized_by", 1)
    .Case("sized_by_or_null", 1)
    .Case("speculative_load_hardening", 1)
    .Case("suppress", 1)
    .Case("swift_async", 1)
    .Case("swiftasynccall", 1)
    .Case("swift_async_context", 1)
    .Case("swift_async_error", 1)
    .Case("swiftcall", 1)
    .Case("swift_context", 1)
    .Case("swift_error_result", 1)
    .Case("swift_indirect_result", 1)
    .Case("type_tag_for_datatype", 1)
    .Case("type_visibility", 1)
    .Case("unavailable", 1)
    .Case("unlikely", 1)
    .Case("unsafe_buffer_usage", 1)
    .Case("use_handle", 1)
    .Case("ptrauth_vtable_pointer", 1)
    .Case("vectorcall", 1)
    .Case("weak_import", 1)
    .Case("export_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_module", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("import_name", true && (T.getArch() == llvm::Triple::wasm32 || T.getArch() == llvm::Triple::wasm64) ? 1 : 0)
    .Case("xray_always_instrument", 1)
    .Case("xray_never_instrument", 1)
    .Case("xray_log_args", 1)
    .Default(0);
} else if (ScopeName == "gnu") {
  return llvm::StringSwitch<int>(Name)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::arm || T.getArch() == llvm::Triple::thumb || T.getArch() == llvm::Triple::armeb || T.getArch() == llvm::Triple::thumbeb) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("signal", true && (T.getArch() == llvm::Triple::avr) ? 1 : 0)
    .Case("alias", 1)
    .Case("aligned", 1)
    .Case("alloc_align", 1)
    .Case("alloc_size", 1)
    .Case("always_inline", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("no_caller_saved_registers", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("nocf_check", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("artificial", 1)
    .Case("assume_aligned", 1)
    .Case("cdecl", 1)
    .Case("cleanup", 1)
    .Case("model", true && (T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64) ? 1 : 0)
    .Case("cold", 1)
    .Case("common", 1)
    .Case("const", 1)
    .Case("__const", 1)
    .Case("constructor", 1)
    .Case("dllexport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("dllimport", true && ( Target.getTriple().hasDLLImportExport() ) ? 1 : 0)
    .Case("deprecated", 1)
    .Case("destructor", 1)
    .Case("error", 1)
    .Case("warning", 1)
    .Case("fallthrough", 1)
    .Case("fastcall", 1)
    .Case("flatten", 1)
    .Case("format", 1)
    .Case("format_arg", 1)
    .Case("function_return", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("gnu_inline", 1)
    .Case("hot", 1)
    .Case("ifunc", true && ( Target.supportsIFunc() ) ? 1 : 0)
    .Case("leaf", 1)
    .Case("ms_abi", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::msp430) ? 1 : 0)
    .Case("ms_struct", 1)
    .Case("may_alias", 1)
    .Case("micromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("mips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("long_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("far", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("short_call", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("near", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel || T.getArch() == llvm::Triple::mips64 || T.getArch() == llvm::Triple::mips64el) ? 1 : 0)
    .Case("mode", 1)
    .Case("naked", 1)
    .Case("nocommon", 1)
    .Case("nodebug", 1)
    .Case("noinline", 1)
    .Case("no_instrument_function", 1)
    .Case("nomicromips", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("nomips16", true && (T.getArch() == llvm::Triple::mips || T.getArch() == llvm::Triple::mipsel) ? 1 : 0)
    .Case("no_profile_instrument_function", 1)
    .Case("no_randomize_layout", 1)
    .Case("noreturn", 1)
    .Case("no_address_safety_analysis", 1)
    .Case("no_sanitize_address", 1)
    .Case("no_sanitize_thread", 1)
    .Case("no_split_stack", 1)
    .Case("no_stack_protector", 1)
    .Case("nothrow", 1)
    .Case("nonnull", 1)
    .Case("packed", 1)
    .Case("patchable_function_entry", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::loongarch32 || T.getArch() == llvm::Triple::loongarch64 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64 || T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64 || T.getArch() == llvm::Triple::ppc || T.getArch() == llvm::Triple::ppc64) ? 1 : 0)
    .Case("pcs", 1)
    .Case("pure", 1)
    .Case("interrupt", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("randomize_layout", 1)
    .Case("regcall", 1)
    .Case("regparm", 1)
    .Case("malloc", 1)
    .Case("retain", 1)
    .Case("returns_nonnull", 1)
    .Case("returns_twice", 1)
    .Case("section", 1)
    .Case("selectany", 1)
    .Case("sentinel", 1)
    .Case("stdcall", 1)
    .Case("sysv_abi", 1)
    .Case("tls_model", 1)
    .Case("target", 1)
    .Case("target_clones", 1)
    .Case("target_version", true && (T.getArch() == llvm::Triple::aarch64 || T.getArch() == llvm::Triple::aarch64_be || T.getArch() == llvm::Triple::aarch64_32 || T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Case("thiscall", 1)
    .Case("transparent_union", 1)
    .Case("unused", 1)
    .Case("used", 1)
    .Case("vector_size", 1)
    .Case("visibility", 1)
    .Case("warn_unused", 1)
    .Case("warn_unused_result", 1)
    .Case("weak", 1)
    .Case("weakref", 1)
    .Case("force_align_arg_pointer", true && (T.getArch() == llvm::Triple::x86 || T.getArch() == llvm::Triple::x86_64) ? 1 : 0)
    .Case("zero_call_used_regs", 1)
    .Default(0);
} else if (ScopeName == "msvc") {
  return llvm::StringSwitch<int>(Name)
    .Case("noinline", 1)
    .Default(0);
} else if (ScopeName == "riscv") {
  return llvm::StringSwitch<int>(Name)
    .Case("vector_cc", true && (T.getArch() == llvm::Triple::riscv32 || T.getArch() == llvm::Triple::riscv64) ? 1 : 0)
    .Default(0);
}
} break;
case AttributeCommonInfo::Syntax::AS_Keyword:
case AttributeCommonInfo::Syntax::AS_ContextSensitiveKeyword:
  llvm_unreachable("hasAttribute not supported for keyword");
  return 0;
case AttributeCommonInfo::Syntax::AS_Implicit:
  llvm_unreachable ("hasAttribute not supported for AS_Implicit");
  return 0;
}
