#ifndef CPPUNIT_EXTENSIONS_TESTCASEDECORATOR_H
#define CPPUNIT_EXTENSIONS_TESTCASEDECORATOR_H

#include <cppunit/Portability.h>
#include <cppunit/TestCase.h>

CPPUNIT_NS_BEGIN


/*! \brief  Decorator for Test cases.
 *
 * TestCaseDecorator provides an alternate means to extend functionality
 * of a test class without subclassing the test.  Instead, one can
 * subclass the decorater and use it to wrap the test class.
 *
 * Assumes ownership of the test it decorates
 */ 
class CPPUNIT_API TestCaseDecorator : public TestCase
{
public:
  TestCaseDecorator( TestCase *test );
  ~TestCaseDecorator() override;

  std::string getName() const override;

  void setUp() override;

  void tearDown() override;

  void runTest() override;

protected:
  TestCase *m_test;

private:

  //prevent the creation of copy c'tor and operator=
  TestCaseDecorator( const TestCaseDecorator& );
  TestCaseDecorator& operator=( const TestCaseDecorator& );

};


CPPUNIT_NS_END

#endif

