Copyright (c) 1997-2000, Didier Verna <didier@xemacs.org>. -*- coding: iso-8859-1 -*-
Se reporter  la fin du document pour les conditions.

Vous lisez actuellement la version franaise du tutoriel d'Emacs.

Cette version a t produite  partir de la version anglaise, qui est
Copyright (c) 1985, 1996 Free Software Foundation, Inc.



             Bienvenue dans le tutoriel d'Emacs en Franais !!


La plupart des commandes d'Emacs utilisent la touche <Control>
(galement note <Ctrl> ou <Ctl>), ou la touche <Meta>. Sur certains
claviers, la touche <Meta> s'appelle <Alt>, <Edit> ou autre chose (sur
les claviers des stations Sun par exemple, il s'agit de la touche 
gauche de la barre espace, celle avec un petit losange). Si vous ne
disposez pas de la touche <Meta>, il est possible d'utiliser la touche
<Esc>  la place. Afin de dcrire les combinaisons de touches
disponibles dans Emacs, les conventions suivantes sont utilises:

 C-<chr> signifie maintenir la touche <Control> enfonce tout en tapant
         le caractre <chr>. Ainsi, C-f signifie maintenir la touche
         <Control> enfonce, et taper 'f'.
 M-<chr> signifie maintenir la touche <Meta> enfonce tout en tapant le
         caractre <chr>. Si la touche <Meta> n'est pas disponible,
         tapez d'abord <Esc>, relchez la, puis tapez <chr>.

NOTE IMPORTANTE: pour quitter Emacs, tapez C-x C-c (deux caractres).

Quand vous trouvez les caractres >> au dbut d'une ligne, cette ligne
vous donne des directives pour essayer une commande. Par exemple:
<<Lignes blanches  but pdagogique. Le texte continue ci-dessous.>>
>> Maintenant, tapez C-v (view next screen) pour passer  l'cran
   suivant. (Faites le vraiment! Maintenez la touche <Control>
   enfonce et tapez 'v').  partir de maintenant, refaites la mme
   chose quand vous avez fini de lire tout l'cran.

Remarquez que quand vous changez d'cran, les deux dernires lignes de
l'cran prcdent sont conserves, ceci afin de conserver un minimum
de continuit dans la lecture.

Une des premires choses  savoir dans Emacs est comment se dplacer
dans un texte. Vous savez dj comment changer d'cran avec C-v. Pour
revenir d'un cran en arrire, tapez M-v (maintenez la touche <Meta>
enfonce tout en appuyant sur 'v', ou encore tapez <Esc>-v si vous ne
disposez pas de <Meta>, <Edit> ou <Alt>).

>> Essayez de taper M-v puis C-v un certain nombre de fois.


* RSUM
--------

Les commandes suivantes sont utiles pour voir des crans entiers:

	C-v	Passer  l'cran suivant
	M-v	Revenir  l'cran prcdent
	C-l	Effacer l'cran et tout retracer, en mettant la ligne
                o se trouve le curseur au centre (C'est bien la
                touche 'L', pas la touche 'un'

>> Trouvez le curseur et rappelez vous bien du texte qui l'entoure.
   Tapez C-l
   Trouvez le curseur  nouveau, et remarquez qu'il s'agit bien du
   mme texte autour de lui.


* MOUVEMENTS DE BASE DU CURSEUR
-------------------------------

Passer d'un cran  l'autre, c'est bien ... mais comment faire pour se
dplacer dans le texte d'un seul cran?

Il existe plusieurs manires de faire. La plus simple est d'utiliser
les commandes C-p, C-b, C-f et C-n. Chacune de ces commandes dplace
le curseur d'une ligne ou d'une colonne dans une direction donne,
comme illustr sur le diagramme suivant:


                         Ligne prcdente, C-p
                                  :
                                  :
     En arrire, C-b .... Position courante .... En avant, C-f
                                  :
                                  :
			  Ligne suivante, C-n

>> Dplacez le curseur au centre de ce diagramme en utilisant C-n ou
   C-p, puis placez le au centre de l'cran avec C-l.


Pour vous rappeler ces commandes, pensez  leur signification en
anglais (et oui, pas en franais ...): F pour Forward, B pour
Backward, N pour Next, P pour Previous. Retenez bien ces commandes,
car vous vous en servirez trs souvent.

>> Amenez le curseur sur cette ligne avec quelques C-n.

>> Dplacez vous sur la ligne avec des C-f, puis vers le haut avec des
   C-p. Remarquez ce que fait C-p quand le curseur est au milieu de la
   ligne.

Chaque ligne de texte se termine avec un caractre nomm Newline, qui
sert  sparer les lignes entre elles. La dernire ligne du fichier
est cense avoir un tel caractre  la fin (bien qu'Emacs n'ait pas
particulirement besoin de sa prsence).

>> Placez vous au dbut d'une ligne, et tapez C-b. Cela devrait vous
   placer  la fin de la ligne prcdente. En fait, on a juste recul
   d'un caractre,  travers le caractre Newline.

C-f vous dplace  travers Newline, exactement comme C-b.

>> Faites encore quelques C-b, pour bien sentir comment se dplace le
   curseur, puis des C-f pour retourner  la fin de la ligne, et pour
   finir encore un C-f pour aller au dbut de la ligne suivante.

Si vous vous dplacez en dehors de l'cran, le texte se dplace de
manire  ce que la position du curseur redevienne visible. Cette
opration est appele scrolling.

>> Dplacez le curseur jusqu'en bas de l'cran, et remarquez ce qu'il
   se passe.

Si vous trouvez que le dplacement caractre par caractre est trop
lent, vous pouvez vous dplacer mot par mot. M-f et M-b vous dplacent
respectivement d'un mot en avant et en arrire.

>> Tapez quelques M-f et M-b.

Si vous tes au milieu d'un mot, M-f vous dplace  la fin du mot.
Si vous tes entre deux mots, M-f vous dplace  la fin du mot
suivant. M-b produit le mme comportement, en sens inverse.

>> Mlangez quelques M-f et M-b avec quelques C-f et C-b pour bien
noter les diffrences de comportement suivant l'endroit o vous tes.

Remarquez le parallle qui existe entre C-f et C-b d'un ct, et M-f
et M-b de l'autre. Trs souvent, les commandes Meta agissent sur des
units de langage (mots, phrases, paragraphes etc.) tandis que les
commandes Control agissent sur des units plus primaires (caractres,
lignes etc.).

Ce parallle existe encore entre les lignes et les phrases: C-a et C-e
vous positionnent au dbut ou  la fin d'une ligne, tandis que M-a et
M-e vous dplacent au dbut ou  la fin d'une phrase.

>> Tapez quelques C-a et quelques C-e.
   Puis tapez quelques M-a et quelques M-e.

Remarquez que plusieurs C-a ne font rien, mais que plusieurs M-a
n'arrtent pas de vous faire remonter de phrase en phrase.

La position du curseur sur dans le texte est aussi appele le
point. En d'autres termes, le curseur  l'cran se trouve o le
point est dans le texte.

Voici un rsum des commandes simples de dplacement, y compris celles
relatives aux mots et aux phrases:

	C-f	En avant d'un caractre
	C-b	En arrire d'un caractre

	M-f	En avant d'un mot
	M-b	En arrire d'un mot

	C-n	Ligne suivante
	C-p	Ligne prcdente

	C-a	Dbut de ligne
	C-e	Fin de ligne

	M-a	Dbut de phrase
	M-e	Fin de phrase

>> Entranez vous un peu  la pratique de ces commandes. Elles sont
   trs souvent utilises.

Deux autres commandes importantes pour le dplacement sont M-<
(Meta-Infrieur) et M-> (Meta-Suprieur). Elles vous dplacent
respectivement au dbut et  la fin de tout le texte.

Sur la plupart des terminaux, '<' se trouve au dessus de la
virgule. Il faut donc utiliser la touche <Shift> pour l'obtenir, sans
quoi vous obtiendrez M-'virgule'.

>> Tapez M-< pour retourner au dbut du texte.
   Puis tapez plusieurs C-v pour revenir ici.

>> Tapez M-> pour aller  la fin du texte.
   Puis tapez plusieurs M-v pour revenir ici.

Vous pouvez aussi dplacer le curseur avec les flches, si votre
clavier en possde. Il est cependant prfrable d'utiliser C-b C-f C-n
et C-p pour trois raisons: premirement, ces commandes fonctionnent
sur tous les terminaux. Deuximement, quand vous vous serez habitu 
Emacs, vous dcouvrirez que ces touches sont plus rapides car vous
n'avez pas besoin de dplacer vos mains loin des lettres du
clavier. Enfin, quand vous aurez l'habitude d'utiliser la touche
<Control>, vous apprendrez plus facilement d'autres commandes de
dplacement plus complexes.

La plupart des commandes d'Emacs acceptent un argument numrique, qui
sert souvent comme compteur de rptition. Pour donner un tel argument
 une fonction, tapez C-u puis les chiffres, et enfin entrez la
commande. Si vous disposez de la touche <Meta> (ou <Edit> ou <Alt>), vous
pouvez aussi tapez directement les chiffres tout en maintenant la
touche <Meta> enfonce. Il est prfrable d'apprendre la mthode C-u car
elle fonctionne sur tous les terminaux.

Par exemple, C-u 8 C-f vous dplace de huit caractres en avant.

>> Essayez d'utiliser C-n avec un argument numrique pour vous
   dplacer d'un seul coup sur une autre ligne.

Certaines commandes n'interprtent pas leur argument numrique comme
un compteur de rptition. C'est le cas de C-v et M-v qui dplacent le
texte d'autant de lignes plutt que d'crans entiers. Par exemple, C-u
4 C-v droulera l'cran de 4 lignes.

>> Essayez C-u 8 C-v.

Cela a du dplacer l'cran de 8 lignes. Pour faire la manoeuvre
inverse, donnez le mme argument a M-v.

Si vous travaillez sous X Window, il y a sans doute une scrollbar sur
le ct droit de la fentre d'Emacs. Vous pouvez aussi vous en servir
avec la souris pour dplacer le texte.

>> Essayer de cliquer avec le deuxime bouton au dessus du bouton de
   la scrollbar. Cela devrait drouler le texte jusqu' une position
   dtermine par l'endroit o vous avez cliqu.

>> Cliquez maintenant avec le premier bouton  quelques lignes du
   sommet dans la scrollbar.


* CONTRLE DU CURSEUR AVEC UN TERMINAL X
----------------------------------------

Si vous travaillez sur un terminal X, vous trouverez surement plus
facile d'utiliser les flches du pav numrique pour dplacer le
curseur. Les quatre flches fonctionnent exactement comme C-f C-b C-n
et C-p mais sont plus faciles  retenir. Vous pouvez aussi les
combiner avec la touche <Control> pour vous dplacer par bloc (par
exemple par paragraphe dans un texte). Si votre pav numrique dispose
de touches <Home> (ou <Begin>) et <End>, elles vous dplaceront
respectivement en dbut et en fin de ligne. Combines avec la touche
<Control>, elles vous dplaceront respectivement en dbut et en fin de
fichier. Si enfin votre pav numrique dispose des touches <PgUp> et
<PgDn>, celles-ci vous dplaceront d'cran en cran comme C-v et M-v.

Toutes ces commandes acceptent des arguments numriques comme dcrit
prcdemment.


* QUAND EMACS EST BLOQU
------------------------

Si jamais Emacs ne rpond plus  vos ordres, vous pouvez l'arrter en
toute scurit en tapant C-g. C-g peut aussi tre utilis pour stopper
une commande qui met trop de temps  s'excuter.

C-g sert galement  annuler un argument numrique, ou une commande
que vous ne voulez plus mener  terme.

>> Tapez C-u 1 0 0 pour produire un argument numrique de 100, puis
   tapez C-g.
   Maintenant, tapez C-f. Le curseur doit finalement ne bouger que
   d'un seul caractre, puisque vous avez annul l'argument.

Si vous avez tap un <Esc> par erreur, vous pourrez toujours l'annuler
avec C-g.


* COMMANDES DSACTIVES
-----------------------

Quelques commandes sont dsactives pour empcher les nouveaux
utilisateurs de les appeler par accident.

Si vous tapez une de ces commandes, Emacs ouvrira un message vous
disant quelle tait cette commande, et vous demandant si vous voulez
vraiment poursuivre son excution.

Si vous souhaitez effectivement l'essayer, appuyez sur la barre
espace. Sinon, rpondez  la question en tapant 'n'.

>> Tapez `C-x n p' (commande dsactive), puis rpondez par 'n'.


* FENTRES
----------

Emacs peut afficher plusieurs fentres, chacune avec un texte
diffrent. Le terme fentre signifie ici une zone particulire dans
la fentre d'Emacs; il ne s'agit pas de fentres pouvant se superposer
dans votre systme de multifentrage. Emacs peut aussi ouvrir
plusieurs fentres X (appeles frames en jargon Emacsien), mais ceci
est dcrit ultrieurement.

Pour l'instant, mieux vaut ne pas trop s'occuper de plusieurs fentres
simultanes, sauf peut-tre pour savoir les liminer toutes sauf
une. Ceci est effectu par la commande C-x 1 ('un', pas 'L'). Cette
commande tue toutes les fentres sauf celle dans laquelle vous vous
trouvez, et s'arrange pour que la fentre restante occupe toute la place.

>> Amenez le curseur ici, puis tapez C-u 0 C-l.

(Rappelez vous que C-l recentre le curseur au milieu de la
fentre. Avec un argument numrique, elle place la ligne courante 
autant de lignes du sommet de la fentre. Avec 0 comme argument, on
raffiche donc le texte, en plaant la ligne courante en haut.)

>> Tapez Control-x 2
   Notez que cette fentre diminue (de moiti), et qu'une nouvelle
   fentre apparat (avec le mme texte).

>> Tapez C-x 1 pour faire  nouveau disparatre la deuxime fentre.


* INSRER ET EFFACER
--------------------

Pour insrer du texte, il suffit de le taper. Tous les caractres que
vous pouvez voir  l'cran (A, %, - etc.) sont considrs comme du
texte et sont insrs. Pour insrer le caractre Newline, tapez
<Return> (retour chariot).

Vous pouvez effacer le dernier caractre que vous avez tap avec la
touche <Delete> parfois nomme Del. La touche <Backspace> peut
quelques fois tre utilise de la mme manire, mais pas tout le
temps!

Plus gnralement, <Delete> efface le caractre situ juste avant le
curseur.

>> Maintenant, tapez quelques caractres, puis effacez-les avec
   <Delete>. Ne vous inquitez pas pour le contenu de ce tutoriel, ce
   que vous avez  l'cran n'est que votre copie personnelle du
   fichier, pas le fichier d'origine.

Si une ligne de texte devient trop grande, elle se poursuit sur une
seconde ligne. Un Backslash ('\') situ tout  fait  droite de la
ligne indique que celle-ci continue sur la ligne suivante.

>> Insrez des caractres jusqu' ce que la ligne devienne trop
   grande, et notez l'apparition du '\'.

>> Utilisez <Delete> pour effacer des caractres jusqu' ce que la
   ligne reprenne une taille raisonnable. Vous remarquerez que le '\'
   disparat.

Le caractre Newline s'efface exactement comme les autres. L'effacer
revient  ne faire qu'une seule ligne  partir de deux. Si cette
nouvelle ligne est trop grande, le '\' apparatra a nouveau.

>> Dplacez le curseur au dbut d'une ligne et tapez <Delete>. Le
caractre Newline sera effac et cette ligne sera ajoute  la ligne
prcdente.

>> Tapez <Return> pour rinsrer le Newline que vous avez effac.

Rappelez-vous bien que la plupart des commandes acceptent un argument
numrique, y compris l'insertion de caractres:

>>  Tapez C-u 8 *, vous obtiendrez "********".

Vous connaissez maintenant les commandes de base pour insrer du texte
et corriger des erreurs. Toujours grce aux touches <Control> et
<Meta>, vous pouvez aussi effacer du texte par mot ou par ligne:

	<Delete>     efface le caractre juste avant le curseur
	C-d   	     efface le caractre juste aprs le curseur

	M-<Delete>   supprime le mot juste avant le curseur
	M-d	     supprime le mot juste aprs le curseur

	C-k	     supprime tout du curseur jusqu' la fin de ligne
	M-k	     supprime tout du curseur jusqu' la fin de phrase


Quand vous supprimez plus d'un caractre  la fois, Emacs sauvegarde le
texte pour vous donner la possibilit de le rintroduire. L'opration
de rintroduction s'appelle le yanking. Vous pouvez rintroduire le
texte  la mme place ou ailleurs. Vous pouvez mme le rintroduire
plusieurs fois, pourquoi pas  des endroits diffrents. La commande de
yanking est C-y.

Notez bien la diffrence entre effacer et supprimer. Un texte
supprim est sauvegard, tandis qu'un caractre effac ne l'est
pas. De mme, les commandes effaant juste des blancs ou des lignes
vides ne sauvegardent rien.

>> Placez le curseur au dbut d'une ligne non vide.
   Tapez C-k pour supprimer le texte sur cette ligne.
>> Tapez C-k une deuxime fois. Vous remarquerez que cette fois-ci, la
   ligne elle-mme est supprime (le caractre Newline).

C-k traite son argument numrique de manire spciale: il supprime
autant de lignes Y COMPRIS LE CARACTRE NEWLINE. Taper C-k deux fois
de suite ne produirait pas le mme rsultat.

>> Pour rcuprer le texte dernirement supprim, tapez C-y. Celui-ci
   sera plac o se trouve le curseur.

Notez galement que si vous faites plusieurs C-k  la suite, tout les
morceaux supprims seront concatns, et un seul C-y suffira  tout
ramener.

>> Faites-le. C-k plusieurs fois, puis C-y.

>> Dplacez le curseur  un autre endroit puis tapez  nouveau C-y.
   Voil comment on copie du texte!

C-y restaure le dernier morceau de texte  avoir t supprim, mais
les suppressions prcdentes ne sont pas perdues pour autant. Aprs
avoir tap C-y, la commande M-y remplace le texte restaur par l'avant
dernire suppression. Tapez  nouveau M-y et vous obtiendrez
l'avant-avant dernire suppression et ainsi de suite. Quand vous avez
rcupr le texte que vous cherchiez, rien de plus  faire: continuez
simplement votre dition.

Si vous tapez M-y assez longtemps, vous retomberez sur la suppression
la plus rcente.

>> Supprimez une ligne, dplacez vous et supprimez-en une autre.
   Tapez C-y pour rcuprer la dernire ligne.
   Puis tapez M-y, ce qui restaurera la premire ligne supprime.
   Tapez encore M-y pour voir ce qu'il se passe, et continuez jusqu'
   rcuprer  nouveau la deuxime ligne.
   Si a vous amuse, donnez des arguments positifs et ngatifs  M-y.


* ANNULATION
------------

Si vous changez du texte, et que finalement vous dcidez que ce
n'tait pas une bonne ide, vous pouvez annuler les changements grce
 la commande C-x u.

C-x u annule les changements produits par la dernire commande. Taper
C-x u plusieurs fois annule de plus en plus de commandes prcdentes.

Il existe cependant quelques exceptions: les commandes qui ne changent
pas le texte ne comptent pas (par exemple les commandes de
dplacement). Les commandes qui insrent juste un caractre sont
souvent regroupes jusqu' une vingtaine, ceci pour rduire le nombre
de C-x u  taper ensuite.

>> Supprimez cette ligne avec C-k, puis tapez C-x u. Elle devrait
   revenir ...

Une alternative  C-x u est C-_. C-x u existe car c'est plus facile 
taper sur certains claviers. Sur d'autres vous pouvez galement
obtenir C-_ en tapant C-/.

Enfin, la commande d'annulation accepte les argument numriques.


* FICHIERS
----------

Pour sauver votre texte, vous avez besoin de le mettre dans un
fichier, sans quoi il disparatra quand vous quitterez Emacs. On dit
trouver un fichier (finding), ou encore visiter un fichier
(visiting), ou bien ouvrir.

Visiter un fichier revient  voir son contenu dans Emacs. Si vous
modifiez le texte du fichier dans Emacs, ces changements ne deviennent
pas permanent, sauf si vous sauvez le fichier. Cela permet de ne pas
avoir des fichiers  moiti modifis sur votre systme,  moins que
vous ne le souhaitiez vraiment. D'autre part, quand Emacs sauve un
fichier, il commence par copier l'ancienne version sous un nouveau nom
afin que vous puissiez toujours revenir en arrire.

Regardez en bas de la fentre d'Emacs. Vous trouverez une ligne
contenant des tirets '-', et la chane de caractres
Emacs: TUTORIAL.FRANCAIS. Cela vous donne le nom du fichier que vous
tes en train de visiter. En ce moment, vous visitez le fichier
TUTORIAL.FRANCAIS qui correspond au Tutoriel d'Emacs, version
franaise. Ceci est votre copie personnelle du fichier. Pour chaque
fichier que vous visitez, son nom apparat exactement  cet endroit.

La plupart des commandes relatives aux fichiers sont des commandes 
deux caractres, commenant par C-x. Il y a toute une srie de
commandes commenant par C-x, beaucoup concernant les fichiers et les
buffers, et longues de 2 caractres ou plus.

Une autre chose importante pour visiter un fichier est que vous devez
spcifier le nom du fichier  visiter. On dit que cette commande lis
un argument depuis le terminal. Dans le cas prsent, l'argument est
le nom du fichier. Aprs avoir tap la commande

C-x C-f (find)

Emacs vous demande son nom. Le nom que vous tapez apparat tout en bas
de la fentre. Quand cette ligne sert  entrer des donnes de cette
manire, on l'appelle minibuffer. Les commandes d'dition ordinaires
peuvent tre utilises pour diter le nom du fichier.

Pendant que vous tes en train de taper le nom du fichier, vous pouvez
annuler la commande grce  C-g.

>> Tapez C-x C-f puis C-g. Cela annule le minibuffer ainsi que la
   commande C-x C-f. Vous n'allez finalement pas visiter de fichier.

Quand le nom du fichier est correct, tapez <Return>. La commande
prendra alors effet et ira chercher le fichier. Aprs avoir termin la
saisie du nom, le minibuffer disparat.

Au bout d'un petit moment, le contenu du fichier apparat et vous
pouvez commencer votre dition. Quand vous tes satisfait des
changements apports au texte, tapez

C-x C-s (save)

Cette commande copie le texte contenu dans Emacs vers le fichier
lui-mme. La premire fois que vous le faites, Emacs sauvegarde la
version initiale du fichier sous un autre nom, en ajoutant un '~'  la
fin du nom.

Quand la sauvegarde est termine, Emacs affiche le nom du fichier dans
lequel on vient d'crire. Il est fortement conseill de sauver assez
souvent les fichiers pour viter de tout perdre en cas de crash
systme (non pas qu'Emacs ne puisse jamais crasher lui-mme ...).

>> Tapez C-x C-s pour sauver votre copie du tutoriel.
   Vous devriez voir apparatre Wrote ...TUTORIAL.FRANCAIS" tout en bas
   de la fentre.

NOTE: Sur certains systmes, C-x C-s bloque l'cran et Emacs ne dit
plus rien. Cela signifie qu'une fonctionnalit systme que l'on
appelle le flow control intercepte le C-s et l'empche de parvenir 
Emacs. Pour dbloquer la situation, tapez C-q. Reportez-vous dans ce
cas  la section Spontaneous Entry to Incremental Search du manuel
d'Emacs pour plus d'information sur cette ... particularit.

Vous pouvez visiter des fichiers existant, mais aussi des fichiers qui
n'existent pas. C'est en fait comme cela que l'on cre un nouveau
fichier dans Emacs. Initialement, le fichier sera inexistant, et la
premire fois que vous demanderez  Emacs de le sauver, il crera
effectivement le fichier correspondant.


* BUFFERS
---------

Si vous ouvrez un nouveau fichier avec C-x C-f, le prcdent reste
dans Emacs. Pour retravailler dessus, retapez simplement C-x C-f. De
cette manire, vous pouvez avoir un nombre important de fichiers
ouverts dans Emacs.

>> Crez un fichier nomm foo en tapant C-x C-f foo<Return>.
   Insrez un peu de texte puis sauvez-le en tapant C-x C-s.
   Enfin, tapez C-x C-f TUTORIAL.FRANCAIS<Return> pour revenir ici.

Emacs conserve le contenu de chaque fichier dans un objet appel
buffer. Visiter un fichier revient  crer un nouveau buffer et y
placer le contenu du fichier. Pour obtenir la liste des buffers qui
existent actuellement dans votre session Emacs, tapez la commande
suivante:

>> Tapez C-x C-b pour obtenir la liste des buffers.

Remarquez que chaque buffer a un nom, et qu'il peut aussi avoir un nom
de fichier dans le cas o un fichier lui est associ. Il extsite des
buffers non attachs  des fichiers, par exemple, le buffer nomm
*Buffer List*. C'est le buffer qui a t cr par la commande C-x
C-b. Par contre, TOUT texte que vous pouvez voir dans Emacs appartient
 un buffer.

>> Tapez C-x 1 pour faire disparatre le buffer contenant la liste des
   buffers.

Quand vous ditez un fichier, puis que vous en ouvrez un autre, le
fichier prcdent n'a pas t sauv. Tous les changements effectus
sont conservs dans le buffer associ au fichier, mais l'ouverture
et l'dition d'un nouveau fichier n'ont aucun effet sur le
premier. Vous constatez donc qu'il serait ennuyeux d'avoir  revenir
au premier fichier pour le sauver avec C-x C-s. Pour viter ce
dsagrment, il existe une autre commande:

	C-x s (Sauver certains buffers)

C-x s vous demandera, pour chaque buffer contenant des modifications
non sauvegardes, si vous dsirez le sauver ou non.

>> Insrez une ligne de texte, puis tapez C-x s
   Emacs vous demandera si vous dsirez sauver le buffer nomm
   TUTORIAL.FRANCAIS.
   Rpondez oui  la question en tapant 'y'.


* UTILISATION DES MENU
----------------------

Si vous travaillez sur un terminal X, vous avez dj remarqu une
barre de menu en haut de la fentre d'Emacs. Cette barre de menu vous
permet d'accder  la plupart des commandes d'Emacs comme celles
permettant d'ouvrir ou de sauver un fichier. L'utilisation de la barre
de menu vous semblera plus facile au dbut, puis quand vous serez
habitu  Emacs, il vous sera facile d'utiliser les commandes au
clavier, car chaque commande figurant dans un menu affiche galement
son quivalent clavier sur le bouton.

Remarquez qu'il existe des boutons n'ayant aucun quivalent
clavier. Par exemple, le menu Buffers donne la liste de tous les
buffers par ordre de plus rcente utilisation. Vous pouvez passer d'un
buffer  l'autre en les slectionnant par leur nom dans ce menu.


* UTILISATION DE LA SOURIS
--------------------------

Quand vous travaillez sous X, Emacs utilise pleinement la souris. Vous
pouvez vous positionner dans le texte en cliquant avec le bouton de
gauche  l'endroit souhait, vous pouvez slectionner du texte en
dplaant la souris avec le bouton de gauche enfonc, ou bien en
cliquant le bouton de gauche au dbut de la portion  slectionner,
puis en Shift-cliquant  l'autre bout.

Pour supprimer un morceau de texte, utilisez C-w ou le bouton Cut du
menu Edit. Notez bien que ces deux commandes ne sont pas
quivalentes: C-w ne fait que supprimer le texte en le sauvegardant de
manire interne (comme C-k), mais Cut sauvegarde en plus le texte
dans le clipboard de X Window, o il pourra tre accd par d'autres
applications.

Pour rcuprer du texte en provenance d'autres applications, utilisez
Paste du menu Edit.

Le bouton du milieu sert principalement  choisir des objets visibles
dans les fentres d'Emacs. Par exemple, si vous entrez dans Info (le
systme de documentation en ligne) en tapant C-h i ou en utilisant le
menu Help, vous pourrez suivre un lien surlign en cliquant dessus
avec le bouton du milieu. De la mme manire, si vous commencez 
taper un nom de fichier aprs avoir fait C-x C-f, et que vous appuyez
sur <Tab> en cours de route, Emacs vous ouvrira une fentre avec
toutes les compltions possibles, et vous pourrez en slectionner une
grce au bouton du milieu.

Le bouton droit fait apparatre un menu. Le contenu de ce menu varie
en fonction du mode dans lequel vous vous trouvez, et contient en
gnral quelques commandes frquemment utilises.

>> Cliquez avec le bouton de droite pour voir le menu en question.

Si vous relchez le bouton, le menu disparat.


* EXTENSION DE L'ENSEMBLE DES COMMANDES
---------------------------------------

Il existe bien plus de commandes dans Emacs que l'on ne pourrait en
associer aux touches <Control> et <Meta>. Pour remdier  cela, Emacs
utilise la commande X (eXtension) qui se prsente sous deux aspects:

	C-x	Extension par caractre (suivit d'un caractre).
	M-x	Extension par nom (suivit d'un nom de commande).

Ces commandes, bien que trs utiles, sont utilises moins souvent que
celles que vous avez dj apprises. Vous en connaissez dj deux: les
commandes relatives aux fichiers (C-x C-f et C-x C-s). Un autre
exemple est la commande pour quitter dfinitivement Emacs, C-x C-c (ne
vous inquitez pas des ventuels changements qui seraient perdus, C-x
C-c vous propose de sauver ces changements avant de tuer Emacs).

C-z est la commande qui vous permet de quitter Emacs temporairement,
pour que vous puissiez y revenir plus tard.

Sur les systmes le permettant, C-z suspend Emacs, ce qui signifie
que l'on retourne au shell sans tuer Emacs. Dans la plupart des cas,
vous pouvez revenir  Emacs en tapant 'fg' ou '%emacs'.

Sur les systmes ne permettant pas la suspension de processus, cette
commande cr un sous-shell qui continue  excuter Emacs, vous
donnant ainsi la possibilit de faire tourner d'autres programmes et
revenir  Emacs plus tard. Dans ce cas, la commande shell 'exit' est
la manire habituelle de retourner au sous-shell d'Emacs.

Vous utiliserez C-x C-c quand le moment sera venu de vous dloguer ou
d'teindre la machine. C'est aussi la bonne manire de sortir d'Emacs
si celui-ci a t lanc depuis un maileur ou tout autre utilitaire,
ceux-ci ne sachant pas forcment comment grer les suspensions. Dans
des circonstances o vous ne vous dloguez pas, mieux vaut suspendre
par C-z au lieu de sortir vritablement d'Emacs.

Il existe de nombreuses commandes sous C-x. Voici celles que vous avez
apprises jusque l:

	C-x C-f		Visiter un fichier (Find File).
	C-x C-s		Sauver un fichier (Save File).
	C-x C-b		Lister les buffers (List buffers).
	C-x C-c		Quitter Emacs (Quit Emacs).
	C-x u		Annuler Opration (Undo).

Les commandes tendues par nom sont des commandes utilises trs peu
souvent, ou disponibles seulement sous certains modes. Par exemple, la
commande replace-string substitue globalement une chane de
caractres par une autre. Si vous tapez M-x, Emacs vous affichera M-x
en bas de la fentre et vous pourrez alors taper le nom d'une
commande, ici replace-string. Tapez simplement 'repl <Espace> s <Tab>'
et Emacs compltera le nom pour vous. Terminez le nom avec <Return>

La commande replace-string requiert deux arguments: la chane 
remplacer et la chane de remplacement. Terminez chacune de ces
chanes par <Return>.

>> Dplacez le curseur sur la ligne blanche en dessous de ce
   paragraphe, puis tapez
   M-x repl<Return>s<Return>Remarquez<Return>Notez<Return>.

   Remarquez comme cette ligne a chang: le mot R-e-m-a-r-q-u-e-z a
   t remplac par N-o-t-e-z partout o il est apparu aprs le
   curseur.


* SAUVEGARDE AUTOMATIQUE
------------------------

Si votre systme crashe alors que certaines modifications n'taient
pas sauves, vous perdez des donns. Pour remdier  ce problme,
Emacs sauvegarde priodiquement tous vous fichiers, et cela de manire
automatique. Ce fichier de sauvegarde est appel auto save. Son nom
commence et se termine par un '#'. Par exemple, un fichier auto save
de 'hello.c' a pour nom '#hello.c#'. Quand vous sauvez le fichier de
manire normale, le fichier auto save est effac.

Si votre ordinateur crashe, vous pouvez restaurer la sauvegarde en
ouvrant le fichier normalement (le VRAI fichier, pas l'auto save),
puis en tapant M-x recover-file<Return>. Rpondez 'yes<Return>'  la
question.


* ZONE D'CHO
-------------

Quand Emacs constate que vous tapez lentement, il vous montre ce que
vous avez tapez en bas de la fentre, dans la zone d'cho (echo
area). Cette zone contient la dernire ligne de la fentre d'Emacs.


* LIGNE DE MODE
---------------

La ligne juste au dessus de la zone d'cho s'appelle ligne de mode
(modeline). Elle dit actuellement quelque chose comme a:

--**-XEmacs: TUTORIAL.FRANCAIS     (Fundamental)--L752--67%---------

Cette ligne fournit des renseignements utiles sur le status d'Emacs et
le texte que vous ditez.

Vous connaissez dj la signification du nom de fichier: c'est celui
que vous tes en train d'diter. -xx%- indique le pourcentage de texte
situ au dessus du curseur. Si vous pouvez voir le dbut du fichier 
l'cran, --Top-- sera indiqu au lieu de --00%--. Si le bas du fichier
est visible, il y aura --Bot--  la place. Si votre texte est tout
entier contenu dans la fentre, vous verrez --All--.

Les toiles '*' au dbut signifient que vous avez fait des changements
au texte. Quand vous ouvrez le fichier, ou aprs l'avoir sauv, il n'y
aura plus d'toiles, mais juste des tirets.

La partie entre parenthses vous indique dans quel mode d'dition vous
vous trouvez. Le dfaut (que vous utilisez en ce moment) est le mode
Fundamental. C'est un exemple de Mode Majeur (major mode).

Il existe de nombreux modes majeurs. Certains sont faits pour diter
diffrents langages, diffrentes sortes de texte, du Lisp, du C etc.
Il ne peut y avoir qu'un mode majeur actif  la fois, et son nom se
trouve sur la ligne de mode (l ou vous voyez Fundamental en ce
moment).

Chaque mode fait certaines commandes se comporter diffremment. Par
exemple, la commande pour crer des commentaires dans un programme
tient compte des diffrents caractres de commentaire des
langages. Chaque mode majeur est le nom d'une commande tendue. Par
exemple la commande M-x fundamental-mode vous place en mode
fondamental.

Si vous voulez diter du texte en franais, vous devriez plutt
choisir le mode Text.

>> Tapez M-x text-mode<Return>

Pas d'inquitude: les commandes que vous avez apprises jusqu'ici ne
sont pas radicalement diffrentes d'un mode  l'autre. Mais vous
pouvez constater par exemple que M-b et M-f traitent les apostrophes
comme faisant partie des mots. Auparavant, ces caractres taient
considrs comme des sparateurs de mots. En gnral, les modes
majeurs ne changent que trs peu le comportement des commandes
habituelles.

Pour voir la documentation du mode majeur courant, tapez C-h m.

>> Utilisez C-u C-v pour amener cette ligne vers le haut de l'cran.
>> Tapez C-h m, pour voir les diffrences entre les mode Fundamental
   et Text.
>> Tapez 'q' pour faire disparatre la documentation.

Les modes majeurs sont appels majeurs parce qu'il y en a aussi des
mineurs. Les modes mineurs n'altrent que partiellement le
comportement de tel ou tel mode majeur. Ils peuvent tre activs ou
dsactivs indpendamment du mode majeur courant. Vous pouvez en
utiliser autant que possible en mme temps.

Un mode mineur trs utile pour diter du texte est le mode
Auto Fill. Quand ce mode est activ, Emacs coupe lui-mme les lignes
si vous tapez du texte trop long pour tre contenu sur une seule.

Pour activer ce mode, tapez M-x auto-fill-mode<Return>. Cette commande
sert  le dsactiver ou  l'activer selon son status actuel; elle
intervertit son tat d'activation.

>> Tapez M-x auto-fill-mode<Return>. Insrez maintenant une quantit
   de aslidfhw jusqu' voir que votre ligne se divise
   automatiquement en deux,  un endroit o il y avait un espace.

La marge est en gnral  70 caractres, mais vous pouvez la changer
grce  la commande C-x f. Donner la marge requise comme argument
numrique.

>> Tapez C-x f avec un argument de 20 (C-u 2 0 C-x f).
   Tapez du texte jusqu' ce que la ligne soit coupe, puis replacez
   la marge  70.

Si vous faites des changements au milieu d'un paragraphe, le mode Auto
Fill ne recoupera pas les lignes tout seul. Pour rajuster les lignes
d'un tel paragraphe, tapez M-q avec le curseur n'importe o dans le
paragraphe.

>> Dplacez le curseur dans le paragraphe prcdent, et tapez M-q.


* RECHERCHE
-----------

Emacs est capable de rechercher des chanes de caractres aussi bien
en avant qu'en arrire dans un texte. Ces commandes sont en fait des
commandes de dplacement du curseur. Elles dplacent le curseur au
prochain (ou prcdent) endroit ou la chane apparat.

La commande de recherche d'Emacs est un peu diffrente de celle des
autres diteurs de texte dans la mesure o elle est incrmentale: la
recherche intervient au fur et   mesure que vous tapez la chane 
rechercher.

Pour dmarrer une recherche, tapez C-s (en avant) ou C-r (en
arrire). MAIS PAS TOUT DE SUITE !! Attendez un peu pour tester ...

Aprs avoir tap C-s, vous constaterez que la chane I-search
apparat comme prompt dans la zone d'cho. Cela vous indique qu'Emacs
est en mode de recherche incrmentale, et qu'il attend que vous
entriez la chane  rechercher. <Return> termine la chane.

>> Tapez C-s, et entrez LENTEMENT, une lettre  la fois, le mot
   curseur, en regardant bien ce qu'il se produit.
    ce stade, vous avez cherch le mot curseur une fois.
>> Tapez C-s  nouveau, pour chercher la prochaine occurrence du mot.
>> Maintenant, tapez <Delete> quatre fois et regardez comment le
   curseur se dplace.
>> Tapez <Return> pour terminer la recherche.

En mode incrmental, Emacs recherche ce que vous avez tap jusqu'ici,
en surlignant les occurrences trouves. Si aucune (nouvelle) occurrence
n'existe, C-s produira un bip, et la zone d'cho affichera
failing. C-g terminerait aussi bien la recherche.

NOTE: Sur certains systmes, C-x C-s bloque l'cran et Emacs ne dit
plus rien. Cela signifie qu'une fonctionnalit systme que l'on
appelle le flow control intercepte le C-s et l'empche de parvenir 
Emacs. Pour dbloquer la situation, tapez C-q. Reportez-vous dans ce
cas  la section Spontaneous Entry to Incremental Search du manuel
d'Emacs pour plus d'information sur cette ... particularit.

Si vous tes au milieu d'une recherche incrmentale et que vous tapez
<Delete>, vous constaterez que le dernier caractre de la chane est
effac, et que Emacs retourne  l'occurrence prcdente. Si d'autre
part vous tapez un caractre <Control> ou <Meta> (mises  part
quelques exceptions comme les caractres spciaux pour la recherche,
C-s et C-r), la recherche sera termine.

Rappelez vous que si C-s cherche une chane APRS le curseur, C-r la
recherche AVANT. Tout ce que nous venons de dire sur C-s s'applique 
C-r.


* FENTRES MULTIPLES
--------------------

Un des avantages d'Emacs est que vous pouvez afficher plusieurs
fentres  la fois sur l'cran.

>> Dplacez le curseur sur cette ligne, et tapez C-u 0 C-l ('L' pas '1')

>> Maintenant tapez C-x 2 pour obtenir deux fentres.
   Les deux fentres affichent le tutoriel. Le curseur reste en haut.

>> Tapez C-M-v (ou <Esc> C-v) pour drouler la fentre du bas.

>> Tapez C-x o (o pour tre ...) pour placer le curseur dans la
   fentre du bas.
>> Utilisez C-v et M-v pour drouler la fentre.
   Continuez de lire dans celle du haut.

>> Tapez C-x o pour retourner dans la fentre du haut.
   Le curseur est exactement  la mme place que quand vous aviez
   quitt cette fentre.

Vous pouvez continuer d'utiliser C-x o pour passer d'une fentre 
l'autre. Chaque fentre a sa propre position du curseur, mais une
seule fentre a la fois contient rellement le curseur. Toutes les
commandes ordinaires d'dition prennent effet dans la fentre qui
contient le curseur. On dit que cette fentre est slectionne.

La commande C-M-v est trs utile quand vous ditez un texte dans une
fentre et que vous vous servez d'une autre en guise de
rfrence. Vous pouvez avancer dans l'autre grce  C-M-v.

C-M-v (ou <Esc> C-v si vous n'avez pas de touche <Meta>) est un
exemple de Control-Mta caractre. L'ordre dans lequel les touches
<Control> et <Meta> sont enfonces n'a pas d'importance. Ce sont juste
des modificateurs. Par contre, <Esc> n'est pas un modificateur, donc
vous tes obligs de taper d'abord <Esc>, et C-v ensuite.

>> Tapez C-x 1 dans la fentre du haut pour liminer celle du bas.

C-x 1 limine en fait toutes les fentres non slectionnes.

Les fentres peuvent bien entendu contenir des buffers diffrents. Si
vous utilisez C-x C-f pour ouvrir un fichier dans l'une des fentres,
l'autre ne change pas. Elles sont totalement indpendantes.

Voici une autre manire d'ouvrir un fichier dans l'autre fentre:

>> Tapez C-x 4 C-f suivit du nom d'un fichier, puis <Return>.
   Vous verrez le fichier apparatre dans l'autre fentre. Le curseur
   ira galement dans cette fentre.

>> Tapez C-x o pour remonter  la fentre du haut, puis C-x 1 pour
   liminer celle du bas.


* NIVEAUX D'DITION RCURSIFS
-----------------------------

De temps en temps, vous vous trouverez dans ce qu'on appelle des
niveaux d'dition rcursifs. Ceci est indiqu dans la ligne de mode
par des crochets autour des parenthses qui englobent le nom du mode
majeur. Par exemple, vous pouvez voir [(Fundamental)] au lieu de
(Fundamental).

Pour sortir d'un niveau rcursif d'dition, tapez <Esc> <Esc>
<Esc>. C'est un sige jectable  usage multiple. Vous pouvez aussi
l'utiliser pour sortir du minibuffer ou liminer des fentres
superflues.

>> Tapez M-x pour vous rendre dans le minibuffer, puis tapez
   <Esc> <Esc> <Esc> pour en sortir.

Il n'est pas possible d'utiliser C-g pour sortir d'un niveau rcursif
d'dition. La raison en est que C-g sert  annuler des commandes au
sein mme d'un niveau rcursif d'dition.


* POUR OBTENIR PLUS D'AIDE
--------------------------

Dans ce tutoriel, nous avons essay de vous fournir assez de
connaissance pour commencer  utiliser Emacs. Emacs est tellement
riche en possibilits qu'il serait impossible de tout dire
ici. Cependant, vous souhaiterez surement  un moment ou un autre
avoir plus de renseignements sur ses normes possibilits. Emacs
comprend entre autres des commandes d'aide sur sa propre
utilisation. Toutes ces commandes d'aide commencent par le prfixe
C-h, le caractre d'aide.

Typiquement, vous tapez C-h, puis un caractre indiquant quelle aide
vous souhaitez obtenir. Si vous tes VRAIMENT perdu, tapez C-h ? et
Emacs vous indiquera quelles sortes d'aide il peut vous fournir. Si
vous ne dsirez finalement pas d'aide aprs avoir tap C-h, tapez
simplement C-g.

(Quelques sites redfinissent la commande C-h. Cela ne devrait vraiment
pas tre fait, donc allez vous plaindre  votre administrateur systme.
Si C-h ne marche pas, tapez M-x help<Return>.)

L'aide de base est C-h c. Tapez C-h c puis une commande (mme une
squence comme C-x f), et Emacs vous donnera une brve description de
la commande en question.

>> Tapez C-h c C-p.
   Le message doit ressembler  quelque chose comme

	C-p runs the command previous-line

Cela vous donne le nom de la fonction. Les noms de fonctions sont
principalement utiliss pour customiser Emacs, mais comme en gnral
ils sont choisi de manire  indiquer ce que fait la commande, ils
peuvent servir de courte documentation (au moins pour vous rappeler
les commandes que vous avez dj apprises).

Pour de plus amples informations sur les commandes, utilisez C-h k au
lieu de C-h c.

>> Tapez C-h k C-p.

Ceci affiche la documentation sur la fonction, ainsi que son nom dans
une autre fentre. Quand vous avez fini de lire, tapez 'q' pour
liminer la fentre d'aide.

Voici d'autres aides utiles:

   C-h f	Dcrire une fonction. Vous donnez son nom.

>> Tapez C-h f previous-line<Return>.
   Cela vous donne toute l'information dont Emacs dispose sur la
   fonction appele par la commande C-p.

   C-h a	Hyper Apropos. Tapez un mot-cl et Emacs vous
                affichera toutes les fonctions ou variables contenant
                ce mot-cl. Les commandes que vous pouvez appeler
                grce  M-x ont un astrisque  gauche de leur nom.

>> Tapez C-h a newline<Return>.

Tapez <Return> pour effacer l'-propos, ou cliquez avec le bouton du
milieu sur un nom pour obtenir l'aide sur cette fonction ou variable.


* CONCLUSION
------------

Rappelez-vous bien, pour quitter dfinitivement Emacs, tapez C-x
C-c. Pour quitter temporairement (et pour pouvoir revenir), tapez C-z
(sous X Windows, C-z iconifie la fentre).

Ce tutoriel est fait pour tre comprhensible par tout nouvel
utilisateur. Donc si quelque chose n'est pas clair, n'hsitez pas 
vous plaindre !!

Si vous avez plus particulirement des remarques  faire sur la
version franaise, vous pouvez aussi me contacter directement
(Didier Verna <didier@xemacs.org>).


COPIES / DISTRIBUTION
---------------------

Un peu d'histoire ...

* Le premier tutoriel pour l'Emacs d'origine fut crit par Stuart
  Cracraft.
* Ben Wing l'a mis  jour pour X Windows.
* Martin Buchholz et Hrvoje Niksic y ont apport des corrections pour
  XEmacs.
* J'en (Didier Verna) ai fait une version franaise un beau jour de 1997.

Cette version du tutoriel, tout comme Emacs, est copyrighte, et vous
est fournie avec la permission d'en distribuer des copies sous
certaines conditions (je laisse la notice du copyright en anglais):

Copyright (c) 1997, Didier Verna.

   Permission is granted to anyone to make or distribute verbatim copies
   of this document as received, in any medium, provided that the
   copyright notice and permission notice are preserved,
   and that the distributor grants the recipient permission
   for further redistribution as permitted by this notice.

   Permission is granted to distribute modified versions
   of this document, or of portions of it,
   under the above conditions, provided also that they
   carry prominent notices stating who last altered them.

Les conditions pour copier Emacs lui-mme sont plus complexes, mais
dans le mme tat d'esprit. Vous tes convis  lire le fichier
COPYING et  distribuer Emacs  vos amis. Aidez-nous  tuer
l'obstructionnisme logiciel en utilisant, crivant et partageant du
logiciel libre!
