type token =
  | MSGSTR
  | MSGID
  | MSGID_PLURAL
  | DOMAIN
  | LBRACKET
  | RBRACKET
  | NUMBER of (int)
  | STRING of (string)
  | EOF
  | COMMENT_FILEPOS of (string)
  | COMMENT_SPECIAL of (string)

open Parsing;;
let _ = parse_error;;
# 24 "src/lib/gettext/extension/gettextPo_parser.mly"

open GettextTypes;;
open GettextPo_utils;;

type comment =
  | CommentFilePos of po_filepos list
  | CommentSpecial of string list
;;

let check_string_format _ref str =
  str
;;

let rec add_comment comments po_commented_translation =
  match comments with
  | CommentFilePos e :: comments_tl ->
      add_comment
        comments_tl
        {
          po_commented_translation with
            po_comment_filepos =
              List.append
                e
                po_commented_translation.po_comment_filepos
        }
  | CommentSpecial e :: comments_tl ->
      add_comment
        comments_tl
        {
          po_commented_translation with
            po_comment_special =
              List.append
                e
                po_commented_translation.po_comment_special
        }
  | [] ->
      po_commented_translation
;;

let check_plural id id_plural lst =
  let check_plural_one index lst =
    List.rev (
      snd (
        List.fold_left ( fun (index,lst) (cur_index,cur_elem) ->
          if index + 1 = cur_index then
            (cur_index, (check_string_format id cur_elem) :: lst)
          else
            raise (PoFileInvalidIndex(String.concat "" id,cur_index))
        ) (index,[]) lst
      )
    )
  in
  {
    po_comment_special = [];
    po_comment_filepos = [];
    po_comment_translation =
      PoPlural(id, (check_string_format id id_plural), (check_plural_one (-1) lst));
  }
;;

let check_singular id str =
  {
    po_comment_special = [];
    po_comment_filepos = [];
    po_comment_translation =
      PoSingular(id, check_string_format id str)
  }
;;

# 87 "src/lib/gettext/extension/gettextPo_parser.ml"
let yytransl_const = [|
  257 (* MSGSTR *);
  258 (* MSGID *);
  259 (* MSGID_PLURAL *);
  260 (* DOMAIN *);
  261 (* LBRACKET *);
  262 (* RBRACKET *);
    0 (* EOF *);
    0|]

let yytransl_block = [|
  263 (* NUMBER *);
  264 (* STRING *);
  265 (* COMMENT_FILEPOS *);
  266 (* COMMENT_SPECIAL *);
    0|]

let yylhs = "\255\255\
\001\000\001\000\001\000\001\000\001\000\004\000\004\000\005\000\
\005\000\002\000\002\000\003\000\003\000\006\000\006\000\006\000\
\006\000\008\000\009\000\009\000\010\000\007\000\007\000\000\000"

let yylen = "\002\000\
\002\000\001\000\002\000\001\000\001\000\001\000\001\000\002\000\
\001\000\003\000\002\000\002\000\001\000\005\000\004\000\005\000\
\004\000\002\000\002\000\001\000\005\000\002\000\001\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\005\000\006\000\007\000\000\000\
\002\000\000\000\009\000\000\000\013\000\023\000\000\000\000\000\
\001\000\000\000\012\000\000\000\008\000\000\000\000\000\022\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\020\000\
\000\000\000\000\000\000\019\000\000\000\000\000\000\000\000\000\
\000\000"

let yydgoto = "\002\000\
\008\000\009\000\010\000\011\000\012\000\013\000\015\000\025\000\
\031\000\032\000"

let yysindex = "\255\255\
\004\000\000\000\250\254\013\255\000\000\000\000\000\000\022\255\
\000\000\009\255\000\000\027\255\000\000\000\000\032\255\009\255\
\000\000\009\255\000\000\250\254\000\000\250\254\250\254\000\000\
\016\255\009\255\038\255\026\255\026\255\025\255\016\255\000\000\
\250\254\016\255\031\255\000\000\026\255\016\255\037\255\250\254\
\026\255"

let yyrindex = "\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\044\000\
\000\000\003\000\000\000\000\000\000\000\000\000\000\000\005\000\
\000\000\008\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\012\000\000\000\013\000\044\255\000\000\016\000\000\000\
\000\000\000\000\000\000\000\000\025\000\028\000\000\000\000\000\
\001\000"

let yygindex = "\000\000\
\000\000\039\000\007\000\036\000\000\000\252\255\243\255\023\000\
\017\000\011\000"

let yytablesize = 294
let yytable = "\001\000\
\021\000\014\000\004\000\005\000\011\000\019\000\027\000\003\000\
\028\000\029\000\003\000\010\000\015\000\019\000\018\000\017\000\
\030\000\006\000\007\000\037\000\016\000\019\000\026\000\003\000\
\014\000\004\000\041\000\016\000\020\000\035\000\006\000\007\000\
\022\000\024\000\023\000\006\000\007\000\039\000\033\000\024\000\
\023\000\036\000\040\000\024\000\018\000\024\000\017\000\021\000\
\036\000\034\000\038\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\021\000\021\000\000\000\021\000\003\000\004\000\004\000\
\011\000\021\000\021\000\003\000\006\000\007\000\015\000\010\000\
\015\000\017\000\000\000\017\000\000\000\015\000\015\000\000\000\
\017\000\017\000\014\000\000\000\014\000\016\000\000\000\016\000\
\000\000\014\000\014\000\000\000\016\000\016\000"

let yycheck = "\001\000\
\000\000\008\001\000\000\000\000\000\000\010\000\020\000\000\000\
\022\000\023\000\002\001\000\000\000\000\018\000\008\000\000\000\
\001\001\009\001\010\001\033\000\008\001\026\000\016\000\002\001\
\000\000\004\001\040\000\000\000\002\001\005\001\009\001\010\001\
\001\001\008\001\003\001\009\001\010\001\007\001\001\001\008\001\
\003\001\031\000\006\001\000\000\001\001\008\001\008\000\012\000\
\038\000\027\000\034\000\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\001\001\002\001\255\255\004\001\002\001\004\001\004\001\
\004\001\009\001\010\001\004\001\009\001\010\001\002\001\004\001\
\004\001\002\001\255\255\004\001\255\255\009\001\010\001\255\255\
\009\001\010\001\002\001\255\255\004\001\002\001\255\255\004\001\
\255\255\009\001\010\001\255\255\009\001\010\001"

let yynames_const = "\
  MSGSTR\000\
  MSGID\000\
  MSGID_PLURAL\000\
  DOMAIN\000\
  LBRACKET\000\
  RBRACKET\000\
  EOF\000\
  "

let yynames_block = "\
  NUMBER\000\
  STRING\000\
  COMMENT_FILEPOS\000\
  COMMENT_SPECIAL\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : GettextTypes.po_content) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'domain) in
    Obj.repr(
# 113 "src/lib/gettext/extension/gettextPo_parser.mly"
                        ( let (d,l) = _2 in List.fold_left (add_po_translation_domain d) _1 l )
# 251 "src/lib/gettext/extension/gettextPo_parser.ml"
               : GettextTypes.po_content))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'domain) in
    Obj.repr(
# 114 "src/lib/gettext/extension/gettextPo_parser.mly"
                        ( let (d,l) = _1 in List.fold_left (add_po_translation_domain d) empty_po l )
# 258 "src/lib/gettext/extension/gettextPo_parser.ml"
               : GettextTypes.po_content))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : GettextTypes.po_content) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'message_list) in
    Obj.repr(
# 115 "src/lib/gettext/extension/gettextPo_parser.mly"
                        ( List.fold_left add_po_translation_no_domain _1 _2 )
# 266 "src/lib/gettext/extension/gettextPo_parser.ml"
               : GettextTypes.po_content))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'message_list) in
    Obj.repr(
# 116 "src/lib/gettext/extension/gettextPo_parser.mly"
                        ( List.fold_left add_po_translation_no_domain empty_po _1 )
# 273 "src/lib/gettext/extension/gettextPo_parser.ml"
               : GettextTypes.po_content))
; (fun __caml_parser_env ->
    Obj.repr(
# 117 "src/lib/gettext/extension/gettextPo_parser.mly"
                        ( empty_po )
# 279 "src/lib/gettext/extension/gettextPo_parser.ml"
               : GettextTypes.po_content))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 122 "src/lib/gettext/extension/gettextPo_parser.mly"
  (
    let lexbuf =
      Lexing.from_string _1
    in
    let lst =
      GettextPoComment_parser.comment_filepos
        GettextPoComment_lexer.comment_filepos
        lexbuf
    in
      CommentFilePos lst
  )
# 296 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'comment))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 134 "src/lib/gettext/extension/gettextPo_parser.mly"
  (
    let lexbuf =
      Lexing.from_string _1
    in
    let lst =
      GettextPoComment_parser.comment_special
        GettextPoComment_lexer.comment_special
        lexbuf
    in
    CommentSpecial lst
  )
# 313 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'comment))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'comment_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'comment) in
    Obj.repr(
# 148 "src/lib/gettext/extension/gettextPo_parser.mly"
                       ( _2 :: _1 )
# 321 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'comment_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'comment) in
    Obj.repr(
# 149 "src/lib/gettext/extension/gettextPo_parser.mly"
                       ( [_1] )
# 328 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'comment_list))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'message_list) in
    Obj.repr(
# 153 "src/lib/gettext/extension/gettextPo_parser.mly"
                             ( (_2,_3) )
# 336 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'domain))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 154 "src/lib/gettext/extension/gettextPo_parser.mly"
                             ( (_2,[]) )
# 343 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'domain))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'message_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'message) in
    Obj.repr(
# 158 "src/lib/gettext/extension/gettextPo_parser.mly"
                       ( _2 :: _1 )
# 351 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'message) in
    Obj.repr(
# 159 "src/lib/gettext/extension/gettextPo_parser.mly"
                       ( [_1] )
# 358 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'comment_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'string_list) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 164 "src/lib/gettext/extension/gettextPo_parser.mly"
    ( add_comment _1 (check_singular  (List.rev _3) (List.rev _5)) )
# 367 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'string_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 166 "src/lib/gettext/extension/gettextPo_parser.mly"
    ( (check_singular (List.rev _2) (List.rev _4)) )
# 375 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : 'comment_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 2 : 'string_list) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'msgid_pluralform) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'pluralform_list) in
    Obj.repr(
# 168 "src/lib/gettext/extension/gettextPo_parser.mly"
    ( add_comment _1 (check_plural (List.rev _3) _4 (List.rev _5)) )
# 385 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 2 : 'string_list) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'msgid_pluralform) in
    let _4 = (Parsing.peek_val __caml_parser_env 0 : 'pluralform_list) in
    Obj.repr(
# 170 "src/lib/gettext/extension/gettextPo_parser.mly"
    ( (check_plural (List.rev _2) _3 (List.rev _4)) )
# 394 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'message))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 174 "src/lib/gettext/extension/gettextPo_parser.mly"
                           ( (List.rev _2) )
# 401 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'msgid_pluralform))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'pluralform_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'pluralform) in
    Obj.repr(
# 178 "src/lib/gettext/extension/gettextPo_parser.mly"
                              ( _2 :: _1 )
# 409 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'pluralform_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'pluralform) in
    Obj.repr(
# 179 "src/lib/gettext/extension/gettextPo_parser.mly"
                              ( [_1] )
# 416 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'pluralform_list))
; (fun __caml_parser_env ->
    let _3 = (Parsing.peek_val __caml_parser_env 2 : int) in
    let _5 = (Parsing.peek_val __caml_parser_env 0 : 'string_list) in
    Obj.repr(
# 183 "src/lib/gettext/extension/gettextPo_parser.mly"
                                              ( (_3,(List.rev _5)) )
# 424 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'pluralform))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'string_list) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 187 "src/lib/gettext/extension/gettextPo_parser.mly"
                     ( _2 :: _1 )
# 432 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'string_list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 188 "src/lib/gettext/extension/gettextPo_parser.mly"
                     ( [_1] )
# 439 "src/lib/gettext/extension/gettextPo_parser.ml"
               : 'string_list))
(* Entry msgfmt *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let msgfmt (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : GettextTypes.po_content)
