#ifndef __LIBXL_TYPES_H
#define __LIBXL_TYPES_H

/*
 * DO NOT EDIT.
 *
 * This file is autogenerated by
 * "gentypes.py libxl_types.idl __libxl_types.h __libxl_types_private.h __libxl_types_json.h __libxl_types.c"
 */

typedef enum libxl_error {
    ERROR_NONSPECIFIC = -1,
    ERROR_VERSION = -2,
    ERROR_FAIL = -3,
    ERROR_NI = -4,
    ERROR_NOMEM = -5,
    ERROR_INVAL = -6,
    ERROR_BADFAIL = -7,
    ERROR_GUEST_TIMEDOUT = -8,
    ERROR_TIMEDOUT = -9,
    ERROR_NOPARAVIRT = -10,
    ERROR_NOT_READY = -11,
    ERROR_OSEVENT_REG_FAIL = -12,
    ERROR_BUFFERFULL = -13,
    ERROR_UNKNOWN_CHILD = -14,
    ERROR_LOCK_FAIL = -15,
    ERROR_JSON_CONFIG_EMPTY = -16,
    ERROR_DEVICE_EXISTS = -17,
    ERROR_CHECKPOINT_DEVOPS_DOES_NOT_MATCH = -18,
    ERROR_CHECKPOINT_DEVICE_NOT_SUPPORTED = -19,
    ERROR_VNUMA_CONFIG_INVALID = -20,
    ERROR_DOMAIN_NOTFOUND = -21,
    ERROR_ABORTED = -22,
    ERROR_NOTFOUND = -23,
    ERROR_DOMAIN_DESTROYED = -24,
    ERROR_FEATURE_REMOVED = -25,
    ERROR_PROTOCOL_ERROR_QMP = -26,
    ERROR_UNKNOWN_QMP_ERROR = -27,
    ERROR_QMP_GENERIC_ERROR = -28,
    ERROR_QMP_COMMAND_NOT_FOUND = -29,
    ERROR_QMP_DEVICE_NOT_ACTIVE = -30,
    ERROR_QMP_DEVICE_NOT_FOUND = -31,
    ERROR_QEMU_API = -32,
} libxl_error;
char *libxl_error_to_json(libxl_ctx *ctx, libxl_error p);
int libxl_error_from_json(libxl_ctx *ctx, libxl_error *p, const char *s);
const char *libxl_error_to_string(libxl_error p);
int libxl_error_from_string(const char *s, libxl_error *e);
extern libxl_enum_string_table libxl_error_string_table[];

typedef enum libxl_domain_type {
    LIBXL_DOMAIN_TYPE_INVALID = -1,
    LIBXL_DOMAIN_TYPE_HVM = 1,
    LIBXL_DOMAIN_TYPE_PV = 2,
    LIBXL_DOMAIN_TYPE_PVH = 3,
} libxl_domain_type;
char *libxl_domain_type_to_json(libxl_ctx *ctx, libxl_domain_type p);
int libxl_domain_type_from_json(libxl_ctx *ctx, libxl_domain_type *p, const char *s);
const char *libxl_domain_type_to_string(libxl_domain_type p);
int libxl_domain_type_from_string(const char *s, libxl_domain_type *e);
extern libxl_enum_string_table libxl_domain_type_string_table[];

typedef enum libxl_rdm_reserve_strategy {
    LIBXL_RDM_RESERVE_STRATEGY_IGNORE = 0,
    LIBXL_RDM_RESERVE_STRATEGY_HOST = 1,
} libxl_rdm_reserve_strategy;
char *libxl_rdm_reserve_strategy_to_json(libxl_ctx *ctx, libxl_rdm_reserve_strategy p);
int libxl_rdm_reserve_strategy_from_json(libxl_ctx *ctx, libxl_rdm_reserve_strategy *p, const char *s);
const char *libxl_rdm_reserve_strategy_to_string(libxl_rdm_reserve_strategy p);
int libxl_rdm_reserve_strategy_from_string(const char *s, libxl_rdm_reserve_strategy *e);
extern libxl_enum_string_table libxl_rdm_reserve_strategy_string_table[];

typedef enum libxl_rdm_reserve_policy {
    LIBXL_RDM_RESERVE_POLICY_INVALID = -1,
    LIBXL_RDM_RESERVE_POLICY_STRICT = 0,
    LIBXL_RDM_RESERVE_POLICY_RELAXED = 1,
} libxl_rdm_reserve_policy;
char *libxl_rdm_reserve_policy_to_json(libxl_ctx *ctx, libxl_rdm_reserve_policy p);
int libxl_rdm_reserve_policy_from_json(libxl_ctx *ctx, libxl_rdm_reserve_policy *p, const char *s);
const char *libxl_rdm_reserve_policy_to_string(libxl_rdm_reserve_policy p);
int libxl_rdm_reserve_policy_from_string(const char *s, libxl_rdm_reserve_policy *e);
extern libxl_enum_string_table libxl_rdm_reserve_policy_string_table[];

typedef enum libxl_channel_connection {
    LIBXL_CHANNEL_CONNECTION_UNKNOWN = 0,
    LIBXL_CHANNEL_CONNECTION_PTY = 1,
    LIBXL_CHANNEL_CONNECTION_SOCKET = 2,
} libxl_channel_connection;
char *libxl_channel_connection_to_json(libxl_ctx *ctx, libxl_channel_connection p);
int libxl_channel_connection_from_json(libxl_ctx *ctx, libxl_channel_connection *p, const char *s);
const char *libxl_channel_connection_to_string(libxl_channel_connection p);
int libxl_channel_connection_from_string(const char *s, libxl_channel_connection *e);
extern libxl_enum_string_table libxl_channel_connection_string_table[];

typedef enum libxl_device_model_version {
    LIBXL_DEVICE_MODEL_VERSION_UNKNOWN = 0,
    LIBXL_DEVICE_MODEL_VERSION_QEMU_XEN_TRADITIONAL = 1,
    LIBXL_DEVICE_MODEL_VERSION_QEMU_XEN = 2,
} libxl_device_model_version;
char *libxl_device_model_version_to_json(libxl_ctx *ctx, libxl_device_model_version p);
int libxl_device_model_version_from_json(libxl_ctx *ctx, libxl_device_model_version *p, const char *s);
const char *libxl_device_model_version_to_string(libxl_device_model_version p);
int libxl_device_model_version_from_string(const char *s, libxl_device_model_version *e);
extern libxl_enum_string_table libxl_device_model_version_string_table[];

typedef enum libxl_console_type {
    LIBXL_CONSOLE_TYPE_UNKNOWN = 0,
    LIBXL_CONSOLE_TYPE_SERIAL = 1,
    LIBXL_CONSOLE_TYPE_PV = 2,
    LIBXL_CONSOLE_TYPE_VUART = 3,
} libxl_console_type;
char *libxl_console_type_to_json(libxl_ctx *ctx, libxl_console_type p);
int libxl_console_type_from_json(libxl_ctx *ctx, libxl_console_type *p, const char *s);
const char *libxl_console_type_to_string(libxl_console_type p);
int libxl_console_type_from_string(const char *s, libxl_console_type *e);
extern libxl_enum_string_table libxl_console_type_string_table[];

typedef enum libxl_disk_format {
    LIBXL_DISK_FORMAT_UNKNOWN = 0,
    LIBXL_DISK_FORMAT_QCOW = 1,
    LIBXL_DISK_FORMAT_QCOW2 = 2,
    LIBXL_DISK_FORMAT_VHD = 3,
    LIBXL_DISK_FORMAT_RAW = 4,
    LIBXL_DISK_FORMAT_EMPTY = 5,
    LIBXL_DISK_FORMAT_QED = 6,
} libxl_disk_format;
char *libxl_disk_format_to_json(libxl_ctx *ctx, libxl_disk_format p);
int libxl_disk_format_from_json(libxl_ctx *ctx, libxl_disk_format *p, const char *s);
const char *libxl_disk_format_to_string(libxl_disk_format p);
int libxl_disk_format_from_string(const char *s, libxl_disk_format *e);
extern libxl_enum_string_table libxl_disk_format_string_table[];

typedef enum libxl_disk_backend {
    LIBXL_DISK_BACKEND_UNKNOWN = 0,
    LIBXL_DISK_BACKEND_PHY = 1,
    LIBXL_DISK_BACKEND_TAP = 2,
    LIBXL_DISK_BACKEND_QDISK = 3,
    LIBXL_DISK_BACKEND_STANDALONE = 4,
} libxl_disk_backend;
char *libxl_disk_backend_to_json(libxl_ctx *ctx, libxl_disk_backend p);
int libxl_disk_backend_from_json(libxl_ctx *ctx, libxl_disk_backend *p, const char *s);
const char *libxl_disk_backend_to_string(libxl_disk_backend p);
int libxl_disk_backend_from_string(const char *s, libxl_disk_backend *e);
extern libxl_enum_string_table libxl_disk_backend_string_table[];

typedef enum libxl_disk_specification {
    LIBXL_DISK_SPECIFICATION_UNKNOWN = 0,
    LIBXL_DISK_SPECIFICATION_XEN = 1,
    LIBXL_DISK_SPECIFICATION_VIRTIO = 2,
} libxl_disk_specification;
char *libxl_disk_specification_to_json(libxl_ctx *ctx, libxl_disk_specification p);
int libxl_disk_specification_from_json(libxl_ctx *ctx, libxl_disk_specification *p, const char *s);
const char *libxl_disk_specification_to_string(libxl_disk_specification p);
int libxl_disk_specification_from_string(const char *s, libxl_disk_specification *e);
extern libxl_enum_string_table libxl_disk_specification_string_table[];

typedef enum libxl_disk_transport {
    LIBXL_DISK_TRANSPORT_UNKNOWN = 0,
    LIBXL_DISK_TRANSPORT_MMIO = 1,
} libxl_disk_transport;
char *libxl_disk_transport_to_json(libxl_ctx *ctx, libxl_disk_transport p);
int libxl_disk_transport_from_json(libxl_ctx *ctx, libxl_disk_transport *p, const char *s);
const char *libxl_disk_transport_to_string(libxl_disk_transport p);
int libxl_disk_transport_from_string(const char *s, libxl_disk_transport *e);
extern libxl_enum_string_table libxl_disk_transport_string_table[];

typedef enum libxl_nic_type {
    LIBXL_NIC_TYPE_UNKNOWN = 0,
    LIBXL_NIC_TYPE_VIF_IOEMU = 1,
    LIBXL_NIC_TYPE_VIF = 2,
} libxl_nic_type;
char *libxl_nic_type_to_json(libxl_ctx *ctx, libxl_nic_type p);
int libxl_nic_type_from_json(libxl_ctx *ctx, libxl_nic_type *p, const char *s);
const char *libxl_nic_type_to_string(libxl_nic_type p);
int libxl_nic_type_from_string(const char *s, libxl_nic_type *e);
extern libxl_enum_string_table libxl_nic_type_string_table[];

typedef enum libxl_p9_type {
    LIBXL_P9_TYPE_UNKNOWN = 0,
    LIBXL_P9_TYPE_QEMU = 1,
    LIBXL_P9_TYPE_XEN_9PFSD = 2,
} libxl_p9_type;
char *libxl_p9_type_to_json(libxl_ctx *ctx, libxl_p9_type p);
int libxl_p9_type_from_json(libxl_ctx *ctx, libxl_p9_type *p, const char *s);
const char *libxl_p9_type_to_string(libxl_p9_type p);
int libxl_p9_type_from_string(const char *s, libxl_p9_type *e);
extern libxl_enum_string_table libxl_p9_type_string_table[];

typedef enum libxl_action_on_shutdown {
    LIBXL_ACTION_ON_SHUTDOWN_DESTROY = 1,
    LIBXL_ACTION_ON_SHUTDOWN_RESTART = 2,
    LIBXL_ACTION_ON_SHUTDOWN_RESTART_RENAME = 3,
    LIBXL_ACTION_ON_SHUTDOWN_PRESERVE = 4,
    LIBXL_ACTION_ON_SHUTDOWN_COREDUMP_DESTROY = 5,
    LIBXL_ACTION_ON_SHUTDOWN_COREDUMP_RESTART = 6,
    LIBXL_ACTION_ON_SHUTDOWN_SOFT_RESET = 7,
} libxl_action_on_shutdown;
char *libxl_action_on_shutdown_to_json(libxl_ctx *ctx, libxl_action_on_shutdown p);
int libxl_action_on_shutdown_from_json(libxl_ctx *ctx, libxl_action_on_shutdown *p, const char *s);
const char *libxl_action_on_shutdown_to_string(libxl_action_on_shutdown p);
int libxl_action_on_shutdown_from_string(const char *s, libxl_action_on_shutdown *e);
extern libxl_enum_string_table libxl_action_on_shutdown_string_table[];

typedef enum libxl_trigger {
    LIBXL_TRIGGER_UNKNOWN = 0,
    LIBXL_TRIGGER_POWER = 1,
    LIBXL_TRIGGER_SLEEP = 2,
    LIBXL_TRIGGER_NMI = 3,
    LIBXL_TRIGGER_INIT = 4,
    LIBXL_TRIGGER_RESET = 5,
    LIBXL_TRIGGER_S3RESUME = 6,
} libxl_trigger;
char *libxl_trigger_to_json(libxl_ctx *ctx, libxl_trigger p);
int libxl_trigger_from_json(libxl_ctx *ctx, libxl_trigger *p, const char *s);
const char *libxl_trigger_to_string(libxl_trigger p);
int libxl_trigger_from_string(const char *s, libxl_trigger *e);
extern libxl_enum_string_table libxl_trigger_string_table[];

typedef enum libxl_tsc_mode {
    LIBXL_TSC_MODE_DEFAULT = 0,
    LIBXL_TSC_MODE_ALWAYS_EMULATE = 1,
    LIBXL_TSC_MODE_NATIVE = 2,
    LIBXL_TSC_MODE_NATIVE_PARAVIRT = 3,
} libxl_tsc_mode;
char *libxl_tsc_mode_to_json(libxl_ctx *ctx, libxl_tsc_mode p);
int libxl_tsc_mode_from_json(libxl_ctx *ctx, libxl_tsc_mode *p, const char *s);
const char *libxl_tsc_mode_to_string(libxl_tsc_mode p);
int libxl_tsc_mode_from_string(const char *s, libxl_tsc_mode *e);
extern libxl_enum_string_table libxl_tsc_mode_string_table[];

typedef enum libxl_gfx_passthru_kind {
    LIBXL_GFX_PASSTHRU_KIND_DEFAULT = 0,
    LIBXL_GFX_PASSTHRU_KIND_IGD = 1,
} libxl_gfx_passthru_kind;
char *libxl_gfx_passthru_kind_to_json(libxl_ctx *ctx, libxl_gfx_passthru_kind p);
int libxl_gfx_passthru_kind_from_json(libxl_ctx *ctx, libxl_gfx_passthru_kind *p, const char *s);
const char *libxl_gfx_passthru_kind_to_string(libxl_gfx_passthru_kind p);
int libxl_gfx_passthru_kind_from_string(const char *s, libxl_gfx_passthru_kind *e);
extern libxl_enum_string_table libxl_gfx_passthru_kind_string_table[];

typedef enum libxl_timer_mode {
    LIBXL_TIMER_MODE_UNKNOWN = -1,
    LIBXL_TIMER_MODE_DELAY_FOR_MISSED_TICKS = 0,
    LIBXL_TIMER_MODE_NO_DELAY_FOR_MISSED_TICKS = 1,
    LIBXL_TIMER_MODE_NO_MISSED_TICKS_PENDING = 2,
    LIBXL_TIMER_MODE_ONE_MISSED_TICK_PENDING = 3,
} libxl_timer_mode;
char *libxl_timer_mode_to_json(libxl_ctx *ctx, libxl_timer_mode p);
int libxl_timer_mode_from_json(libxl_ctx *ctx, libxl_timer_mode *p, const char *s);
const char *libxl_timer_mode_to_string(libxl_timer_mode p);
int libxl_timer_mode_from_string(const char *s, libxl_timer_mode *e);
extern libxl_enum_string_table libxl_timer_mode_string_table[];

typedef enum libxl_bios_type {
    LIBXL_BIOS_TYPE_UNKNOWN = 0,
    LIBXL_BIOS_TYPE_ROMBIOS = 1,
    LIBXL_BIOS_TYPE_SEABIOS = 2,
    LIBXL_BIOS_TYPE_OVMF = 3,
} libxl_bios_type;
char *libxl_bios_type_to_json(libxl_ctx *ctx, libxl_bios_type p);
int libxl_bios_type_from_json(libxl_ctx *ctx, libxl_bios_type *p, const char *s);
const char *libxl_bios_type_to_string(libxl_bios_type p);
int libxl_bios_type_from_string(const char *s, libxl_bios_type *e);
extern libxl_enum_string_table libxl_bios_type_string_table[];

typedef enum libxl_scheduler {
    LIBXL_SCHEDULER_UNKNOWN = 0,
    LIBXL_SCHEDULER_SEDF = 4,
    LIBXL_SCHEDULER_CREDIT = 5,
    LIBXL_SCHEDULER_CREDIT2 = 6,
    LIBXL_SCHEDULER_ARINC653 = 7,
    LIBXL_SCHEDULER_RTDS = 8,
    LIBXL_SCHEDULER_NULL = 9,
} libxl_scheduler;
char *libxl_scheduler_to_json(libxl_ctx *ctx, libxl_scheduler p);
int libxl_scheduler_from_json(libxl_ctx *ctx, libxl_scheduler *p, const char *s);
const char *libxl_scheduler_to_string(libxl_scheduler p);
int libxl_scheduler_from_string(const char *s, libxl_scheduler *e);
extern libxl_enum_string_table libxl_scheduler_string_table[];

typedef enum libxl_shutdown_reason {
    LIBXL_SHUTDOWN_REASON_UNKNOWN = -1,
    LIBXL_SHUTDOWN_REASON_POWEROFF = 0,
    LIBXL_SHUTDOWN_REASON_REBOOT = 1,
    LIBXL_SHUTDOWN_REASON_SUSPEND = 2,
    LIBXL_SHUTDOWN_REASON_CRASH = 3,
    LIBXL_SHUTDOWN_REASON_WATCHDOG = 4,
    LIBXL_SHUTDOWN_REASON_SOFT_RESET = 5,
} libxl_shutdown_reason;
char *libxl_shutdown_reason_to_json(libxl_ctx *ctx, libxl_shutdown_reason p);
int libxl_shutdown_reason_from_json(libxl_ctx *ctx, libxl_shutdown_reason *p, const char *s);
const char *libxl_shutdown_reason_to_string(libxl_shutdown_reason p);
int libxl_shutdown_reason_from_string(const char *s, libxl_shutdown_reason *e);
extern libxl_enum_string_table libxl_shutdown_reason_string_table[];

typedef enum libxl_vga_interface_type {
    LIBXL_VGA_INTERFACE_TYPE_UNKNOWN = 0,
    LIBXL_VGA_INTERFACE_TYPE_CIRRUS = 1,
    LIBXL_VGA_INTERFACE_TYPE_STD = 2,
    LIBXL_VGA_INTERFACE_TYPE_NONE = 3,
    LIBXL_VGA_INTERFACE_TYPE_QXL = 4,
} libxl_vga_interface_type;
char *libxl_vga_interface_type_to_json(libxl_ctx *ctx, libxl_vga_interface_type p);
int libxl_vga_interface_type_from_json(libxl_ctx *ctx, libxl_vga_interface_type *p, const char *s);
const char *libxl_vga_interface_type_to_string(libxl_vga_interface_type p);
int libxl_vga_interface_type_from_string(const char *s, libxl_vga_interface_type *e);
extern libxl_enum_string_table libxl_vga_interface_type_string_table[];

typedef enum libxl_vendor_device {
    LIBXL_VENDOR_DEVICE_NONE = 0,
    LIBXL_VENDOR_DEVICE_XENSERVER = 1,
} libxl_vendor_device;
char *libxl_vendor_device_to_json(libxl_ctx *ctx, libxl_vendor_device p);
int libxl_vendor_device_from_json(libxl_ctx *ctx, libxl_vendor_device *p, const char *s);
const char *libxl_vendor_device_to_string(libxl_vendor_device p);
int libxl_vendor_device_from_string(const char *s, libxl_vendor_device *e);
extern libxl_enum_string_table libxl_vendor_device_string_table[];

typedef enum libxl_viridian_enlightenment {
    LIBXL_VIRIDIAN_ENLIGHTENMENT_BASE = 0,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_FREQ = 1,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_TIME_REF_COUNT = 2,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_REFERENCE_TSC = 3,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_HCALL_REMOTE_TLB_FLUSH = 4,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_APIC_ASSIST = 5,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_CRASH_CTL = 6,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_SYNIC = 7,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_STIMER = 8,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_HCALL_IPI = 9,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_EX_PROCESSOR_MASKS = 10,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_NO_VP_LIMIT = 11,
    LIBXL_VIRIDIAN_ENLIGHTENMENT_CPU_HOTPLUG = 12,
} libxl_viridian_enlightenment;
char *libxl_viridian_enlightenment_to_json(libxl_ctx *ctx, libxl_viridian_enlightenment p);
int libxl_viridian_enlightenment_from_json(libxl_ctx *ctx, libxl_viridian_enlightenment *p, const char *s);
const char *libxl_viridian_enlightenment_to_string(libxl_viridian_enlightenment p);
int libxl_viridian_enlightenment_from_string(const char *s, libxl_viridian_enlightenment *e);
extern libxl_enum_string_table libxl_viridian_enlightenment_string_table[];

typedef enum libxl_hdtype {
    LIBXL_HDTYPE_IDE = 1,
    LIBXL_HDTYPE_AHCI = 2,
} libxl_hdtype;
char *libxl_hdtype_to_json(libxl_ctx *ctx, libxl_hdtype p);
int libxl_hdtype_from_json(libxl_ctx *ctx, libxl_hdtype *p, const char *s);
const char *libxl_hdtype_to_string(libxl_hdtype p);
int libxl_hdtype_from_string(const char *s, libxl_hdtype *e);
extern libxl_enum_string_table libxl_hdtype_string_table[];

typedef enum libxl_checkpointed_stream {
    LIBXL_CHECKPOINTED_STREAM_NONE = 0,
    LIBXL_CHECKPOINTED_STREAM_REMUS = 1,
    LIBXL_CHECKPOINTED_STREAM_COLO = 2,
} libxl_checkpointed_stream;
char *libxl_checkpointed_stream_to_json(libxl_ctx *ctx, libxl_checkpointed_stream p);
int libxl_checkpointed_stream_from_json(libxl_ctx *ctx, libxl_checkpointed_stream *p, const char *s);
const char *libxl_checkpointed_stream_to_string(libxl_checkpointed_stream p);
int libxl_checkpointed_stream_from_string(const char *s, libxl_checkpointed_stream *e);
extern libxl_enum_string_table libxl_checkpointed_stream_string_table[];

typedef enum libxl_vuart_type {
    LIBXL_VUART_TYPE_UNKNOWN = 0,
    LIBXL_VUART_TYPE_SBSA_UART = 1,
} libxl_vuart_type;
char *libxl_vuart_type_to_json(libxl_ctx *ctx, libxl_vuart_type p);
int libxl_vuart_type_from_json(libxl_ctx *ctx, libxl_vuart_type *p, const char *s);
const char *libxl_vuart_type_to_string(libxl_vuart_type p);
int libxl_vuart_type_from_string(const char *s, libxl_vuart_type *e);
extern libxl_enum_string_table libxl_vuart_type_string_table[];

typedef enum libxl_vkb_backend {
    LIBXL_VKB_BACKEND_UNKNOWN = 0,
    LIBXL_VKB_BACKEND_QEMU = 1,
    LIBXL_VKB_BACKEND_LINUX = 2,
} libxl_vkb_backend;
char *libxl_vkb_backend_to_json(libxl_ctx *ctx, libxl_vkb_backend p);
int libxl_vkb_backend_from_json(libxl_ctx *ctx, libxl_vkb_backend *p, const char *s);
const char *libxl_vkb_backend_to_string(libxl_vkb_backend p);
int libxl_vkb_backend_from_string(const char *s, libxl_vkb_backend *e);
extern libxl_enum_string_table libxl_vkb_backend_string_table[];

typedef enum libxl_virtio_transport {
    LIBXL_VIRTIO_TRANSPORT_UNKNOWN = 0,
    LIBXL_VIRTIO_TRANSPORT_MMIO = 1,
} libxl_virtio_transport;
char *libxl_virtio_transport_to_json(libxl_ctx *ctx, libxl_virtio_transport p);
int libxl_virtio_transport_from_json(libxl_ctx *ctx, libxl_virtio_transport *p, const char *s);
const char *libxl_virtio_transport_to_string(libxl_virtio_transport p);
int libxl_virtio_transport_from_string(const char *s, libxl_virtio_transport *e);
extern libxl_enum_string_table libxl_virtio_transport_string_table[];

typedef enum libxl_passthrough {
    LIBXL_PASSTHROUGH_DEFAULT = 0,
    LIBXL_PASSTHROUGH_DISABLED = 1,
    LIBXL_PASSTHROUGH_ENABLED = 2,
    LIBXL_PASSTHROUGH_SYNC_PT = 3,
    LIBXL_PASSTHROUGH_SHARE_PT = 4,
} libxl_passthrough;
char *libxl_passthrough_to_json(libxl_ctx *ctx, libxl_passthrough p);
int libxl_passthrough_from_json(libxl_ctx *ctx, libxl_passthrough *p, const char *s);
const char *libxl_passthrough_to_string(libxl_passthrough p);
int libxl_passthrough_from_string(const char *s, libxl_passthrough *e);
extern libxl_enum_string_table libxl_passthrough_string_table[];

typedef struct libxl_ioport_range {
    uint32_t first;
    uint32_t number;
} libxl_ioport_range;
void libxl_ioport_range_dispose(libxl_ioport_range *p);
void libxl_ioport_range_copy(libxl_ctx *ctx, libxl_ioport_range *dst, const libxl_ioport_range *src);
void libxl_ioport_range_init(libxl_ioport_range *p);
char *libxl_ioport_range_to_json(libxl_ctx *ctx, libxl_ioport_range *p);
int libxl_ioport_range_from_json(libxl_ctx *ctx, libxl_ioport_range *p, const char *s);

typedef struct libxl_iomem_range {
    uint64_t start;
    uint64_t number;
    uint64_t gfn;
} libxl_iomem_range;
void libxl_iomem_range_dispose(libxl_iomem_range *p);
void libxl_iomem_range_copy(libxl_ctx *ctx, libxl_iomem_range *dst, const libxl_iomem_range *src);
void libxl_iomem_range_init(libxl_iomem_range *p);
char *libxl_iomem_range_to_json(libxl_ctx *ctx, libxl_iomem_range *p);
int libxl_iomem_range_from_json(libxl_ctx *ctx, libxl_iomem_range *p, const char *s);

typedef struct libxl_vga_interface_info {
    libxl_vga_interface_type kind;
} libxl_vga_interface_info;
void libxl_vga_interface_info_dispose(libxl_vga_interface_info *p);
void libxl_vga_interface_info_copy(libxl_ctx *ctx, libxl_vga_interface_info *dst, const libxl_vga_interface_info *src);
void libxl_vga_interface_info_init(libxl_vga_interface_info *p);
char *libxl_vga_interface_info_to_json(libxl_ctx *ctx, libxl_vga_interface_info *p);
int libxl_vga_interface_info_from_json(libxl_ctx *ctx, libxl_vga_interface_info *p, const char *s);

typedef struct libxl_vnc_info {
    libxl_defbool enable;
    char * listen;
    char * passwd;
    int display;
    libxl_defbool findunused;
} libxl_vnc_info;
void libxl_vnc_info_dispose(libxl_vnc_info *p);
void libxl_vnc_info_copy(libxl_ctx *ctx, libxl_vnc_info *dst, const libxl_vnc_info *src);
void libxl_vnc_info_init(libxl_vnc_info *p);
char *libxl_vnc_info_to_json(libxl_ctx *ctx, libxl_vnc_info *p);
int libxl_vnc_info_from_json(libxl_ctx *ctx, libxl_vnc_info *p, const char *s);

typedef struct libxl_spice_info {
    libxl_defbool enable;
    int port;
    int tls_port;
    char * host;
    libxl_defbool disable_ticketing;
    char * passwd;
    libxl_defbool agent_mouse;
    libxl_defbool vdagent;
    libxl_defbool clipboard_sharing;
    int usbredirection;
    char * image_compression;
    char * streaming_video;
} libxl_spice_info;
void libxl_spice_info_dispose(libxl_spice_info *p);
void libxl_spice_info_copy(libxl_ctx *ctx, libxl_spice_info *dst, const libxl_spice_info *src);
void libxl_spice_info_init(libxl_spice_info *p);
char *libxl_spice_info_to_json(libxl_ctx *ctx, libxl_spice_info *p);
int libxl_spice_info_from_json(libxl_ctx *ctx, libxl_spice_info *p, const char *s);

typedef struct libxl_sdl_info {
    libxl_defbool enable;
    libxl_defbool opengl;
    char * display;
    char * xauthority;
} libxl_sdl_info;
void libxl_sdl_info_dispose(libxl_sdl_info *p);
void libxl_sdl_info_copy(libxl_ctx *ctx, libxl_sdl_info *dst, const libxl_sdl_info *src);
void libxl_sdl_info_init(libxl_sdl_info *p);
char *libxl_sdl_info_to_json(libxl_ctx *ctx, libxl_sdl_info *p);
int libxl_sdl_info_from_json(libxl_ctx *ctx, libxl_sdl_info *p, const char *s);

typedef struct libxl_dominfo {
    libxl_uuid uuid;
    libxl_domid domid;
    uint32_t ssidref;
    char * ssid_label;
    bool running;
    bool blocked;
    bool paused;
    bool shutdown;
    bool dying;
    bool never_stop;
    libxl_shutdown_reason shutdown_reason;
    uint64_t outstanding_memkb;
    uint64_t current_memkb;
    uint64_t shared_memkb;
    uint64_t paged_memkb;
    uint64_t max_memkb;
    uint64_t cpu_time;
    uint32_t vcpu_max_id;
    uint32_t vcpu_online;
    uint32_t cpupool;
    uint8_t gpaddr_bits;
    libxl_domain_type domain_type;
} libxl_dominfo;
void libxl_dominfo_dispose(libxl_dominfo *p);
void libxl_dominfo_copy(libxl_ctx *ctx, libxl_dominfo *dst, const libxl_dominfo *src);
void libxl_dominfo_init(libxl_dominfo *p);
char *libxl_dominfo_to_json(libxl_ctx *ctx, libxl_dominfo *p);
int libxl_dominfo_from_json(libxl_ctx *ctx, libxl_dominfo *p, const char *s);

typedef struct libxl_cpupoolinfo {
    uint32_t poolid;
    char * pool_name;
    libxl_scheduler sched;
    uint32_t n_dom;
    libxl_bitmap cpumap;
} libxl_cpupoolinfo;
void libxl_cpupoolinfo_dispose(libxl_cpupoolinfo *p);
void libxl_cpupoolinfo_copy(libxl_ctx *ctx, libxl_cpupoolinfo *dst, const libxl_cpupoolinfo *src);
void libxl_cpupoolinfo_init(libxl_cpupoolinfo *p);
char *libxl_cpupoolinfo_to_json(libxl_ctx *ctx, libxl_cpupoolinfo *p);
int libxl_cpupoolinfo_from_json(libxl_ctx *ctx, libxl_cpupoolinfo *p, const char *s);

typedef struct libxl_channelinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
    libxl_channel_connection connection;
    union {
        struct {
            char * path;
        } pty;
    } u;
} libxl_channelinfo;
void libxl_channelinfo_dispose(libxl_channelinfo *p);
void libxl_channelinfo_copy(libxl_ctx *ctx, libxl_channelinfo *dst, const libxl_channelinfo *src);
void libxl_channelinfo_init(libxl_channelinfo *p);
void libxl_channelinfo_init_connection(libxl_channelinfo *p, libxl_channel_connection connection);
char *libxl_channelinfo_to_json(libxl_ctx *ctx, libxl_channelinfo *p);
int libxl_channelinfo_from_json(libxl_ctx *ctx, libxl_channelinfo *p, const char *s);

typedef struct libxl_vminfo {
    libxl_uuid uuid;
    libxl_domid domid;
} libxl_vminfo;
void libxl_vminfo_dispose(libxl_vminfo *p);
void libxl_vminfo_copy(libxl_ctx *ctx, libxl_vminfo *dst, const libxl_vminfo *src);
void libxl_vminfo_init(libxl_vminfo *p);
char *libxl_vminfo_to_json(libxl_ctx *ctx, libxl_vminfo *p);
int libxl_vminfo_from_json(libxl_ctx *ctx, libxl_vminfo *p, const char *s);

typedef struct libxl_version_info {
    int xen_version_major;
    int xen_version_minor;
    char * xen_version_extra;
    char * compiler;
    char * compile_by;
    char * compile_domain;
    char * compile_date;
    char * capabilities;
    char * changeset;
    uint64_t virt_start;
    int pagesize;
    char * commandline;
    char * build_id;
} libxl_version_info;
void libxl_version_info_dispose(libxl_version_info *p);
void libxl_version_info_copy(libxl_ctx *ctx, libxl_version_info *dst, const libxl_version_info *src);
void libxl_version_info_init(libxl_version_info *p);
char *libxl_version_info_to_json(libxl_ctx *ctx, libxl_version_info *p);
int libxl_version_info_from_json(libxl_ctx *ctx, libxl_version_info *p, const char *s);

typedef enum libxl_smbios_type {
    LIBXL_SMBIOS_TYPE_BIOS_VENDOR = 1,
    LIBXL_SMBIOS_TYPE_BIOS_VERSION = 2,
    LIBXL_SMBIOS_TYPE_SYSTEM_MANUFACTURER = 3,
    LIBXL_SMBIOS_TYPE_SYSTEM_PRODUCT_NAME = 4,
    LIBXL_SMBIOS_TYPE_SYSTEM_VERSION = 5,
    LIBXL_SMBIOS_TYPE_SYSTEM_SERIAL_NUMBER = 6,
    LIBXL_SMBIOS_TYPE_BASEBOARD_MANUFACTURER = 7,
    LIBXL_SMBIOS_TYPE_BASEBOARD_PRODUCT_NAME = 8,
    LIBXL_SMBIOS_TYPE_BASEBOARD_VERSION = 9,
    LIBXL_SMBIOS_TYPE_BASEBOARD_SERIAL_NUMBER = 10,
    LIBXL_SMBIOS_TYPE_BASEBOARD_ASSET_TAG = 11,
    LIBXL_SMBIOS_TYPE_BASEBOARD_LOCATION_IN_CHASSIS = 12,
    LIBXL_SMBIOS_TYPE_ENCLOSURE_MANUFACTURER = 13,
    LIBXL_SMBIOS_TYPE_ENCLOSURE_SERIAL_NUMBER = 14,
    LIBXL_SMBIOS_TYPE_ENCLOSURE_ASSET_TAG = 15,
    LIBXL_SMBIOS_TYPE_BATTERY_MANUFACTURER = 16,
    LIBXL_SMBIOS_TYPE_BATTERY_DEVICE_NAME = 17,
    LIBXL_SMBIOS_TYPE_OEM = 18,
} libxl_smbios_type;
char *libxl_smbios_type_to_json(libxl_ctx *ctx, libxl_smbios_type p);
int libxl_smbios_type_from_json(libxl_ctx *ctx, libxl_smbios_type *p, const char *s);
const char *libxl_smbios_type_to_string(libxl_smbios_type p);
int libxl_smbios_type_from_string(const char *s, libxl_smbios_type *e);
extern libxl_enum_string_table libxl_smbios_type_string_table[];

typedef struct libxl_smbios {
    libxl_smbios_type key;
    char * value;
} libxl_smbios;
void libxl_smbios_dispose(libxl_smbios *p);
void libxl_smbios_copy(libxl_ctx *ctx, libxl_smbios *dst, const libxl_smbios *src);
void libxl_smbios_init(libxl_smbios *p);
char *libxl_smbios_to_json(libxl_ctx *ctx, libxl_smbios *p);
int libxl_smbios_from_json(libxl_ctx *ctx, libxl_smbios *p, const char *s);

typedef struct libxl_domain_create_info {
    libxl_domain_type type;
    libxl_defbool hap;
    libxl_defbool oos;
    uint32_t ssidref;
    char * ssid_label;
    char * name;
    libxl_domid domid;
    libxl_uuid uuid;
    libxl_key_value_list xsdata;
    libxl_key_value_list platformdata;
    uint32_t poolid;
    char * pool_name;
    libxl_defbool run_hotplug_scripts;
    libxl_defbool driver_domain;
    libxl_passthrough passthrough;
    libxl_defbool xend_suspend_evtchn_compat;
} libxl_domain_create_info;
void libxl_domain_create_info_dispose(libxl_domain_create_info *p);
void libxl_domain_create_info_copy(libxl_ctx *ctx, libxl_domain_create_info *dst, const libxl_domain_create_info *src);
void libxl_domain_create_info_init(libxl_domain_create_info *p);
char *libxl_domain_create_info_to_json(libxl_ctx *ctx, libxl_domain_create_info *p);
int libxl_domain_create_info_from_json(libxl_ctx *ctx, libxl_domain_create_info *p, const char *s);

typedef struct libxl_domain_restore_params {
    int checkpointed_stream;
    uint32_t stream_version;
    char * colo_proxy_script;
    libxl_defbool userspace_colo_proxy;
} libxl_domain_restore_params;
void libxl_domain_restore_params_dispose(libxl_domain_restore_params *p);
void libxl_domain_restore_params_copy(libxl_ctx *ctx, libxl_domain_restore_params *dst, const libxl_domain_restore_params *src);
void libxl_domain_restore_params_init(libxl_domain_restore_params *p);
char *libxl_domain_restore_params_to_json(libxl_ctx *ctx, libxl_domain_restore_params *p);
int libxl_domain_restore_params_from_json(libxl_ctx *ctx, libxl_domain_restore_params *p, const char *s);

typedef struct libxl_sched_params {
    int vcpuid;
    int weight;
    int cap;
    int period;
    int extratime;
    int budget;
} libxl_sched_params;
void libxl_sched_params_dispose(libxl_sched_params *p);
void libxl_sched_params_copy(libxl_ctx *ctx, libxl_sched_params *dst, const libxl_sched_params *src);
void libxl_sched_params_init(libxl_sched_params *p);
char *libxl_sched_params_to_json(libxl_ctx *ctx, libxl_sched_params *p);
int libxl_sched_params_from_json(libxl_ctx *ctx, libxl_sched_params *p, const char *s);

typedef struct libxl_vcpu_sched_params {
    libxl_scheduler sched;
    int num_vcpus;
    libxl_sched_params * vcpus;
} libxl_vcpu_sched_params;
void libxl_vcpu_sched_params_dispose(libxl_vcpu_sched_params *p);
void libxl_vcpu_sched_params_copy(libxl_ctx *ctx, libxl_vcpu_sched_params *dst, const libxl_vcpu_sched_params *src);
void libxl_vcpu_sched_params_init(libxl_vcpu_sched_params *p);
char *libxl_vcpu_sched_params_to_json(libxl_ctx *ctx, libxl_vcpu_sched_params *p);
int libxl_vcpu_sched_params_from_json(libxl_ctx *ctx, libxl_vcpu_sched_params *p, const char *s);

typedef struct libxl_domain_sched_params {
    libxl_scheduler sched;
    int weight;
    int cap;
    int period;
    int budget;
    int extratime;
    int slice;
    int latency;
} libxl_domain_sched_params;
void libxl_domain_sched_params_dispose(libxl_domain_sched_params *p);
void libxl_domain_sched_params_copy(libxl_ctx *ctx, libxl_domain_sched_params *dst, const libxl_domain_sched_params *src);
void libxl_domain_sched_params_init(libxl_domain_sched_params *p);
char *libxl_domain_sched_params_to_json(libxl_ctx *ctx, libxl_domain_sched_params *p);
int libxl_domain_sched_params_from_json(libxl_ctx *ctx, libxl_domain_sched_params *p, const char *s);

typedef struct libxl_vnode_info {
    uint64_t memkb;
    int num_distances;
    uint32_t * distances;
    uint32_t pnode;
    libxl_bitmap vcpus;
} libxl_vnode_info;
void libxl_vnode_info_dispose(libxl_vnode_info *p);
void libxl_vnode_info_copy(libxl_ctx *ctx, libxl_vnode_info *dst, const libxl_vnode_info *src);
void libxl_vnode_info_init(libxl_vnode_info *p);
char *libxl_vnode_info_to_json(libxl_ctx *ctx, libxl_vnode_info *p);
int libxl_vnode_info_from_json(libxl_ctx *ctx, libxl_vnode_info *p, const char *s);

typedef enum libxl_gic_version {
    LIBXL_GIC_VERSION_DEFAULT = 0,
    LIBXL_GIC_VERSION_V2 = 32,
    LIBXL_GIC_VERSION_V3 = 48,
} libxl_gic_version;
char *libxl_gic_version_to_json(libxl_ctx *ctx, libxl_gic_version p);
int libxl_gic_version_from_json(libxl_ctx *ctx, libxl_gic_version *p, const char *s);
const char *libxl_gic_version_to_string(libxl_gic_version p);
int libxl_gic_version_from_string(const char *s, libxl_gic_version *e);
extern libxl_enum_string_table libxl_gic_version_string_table[];

typedef enum libxl_tee_type {
    LIBXL_TEE_TYPE_NONE = 0,
    LIBXL_TEE_TYPE_OPTEE = 1,
    LIBXL_TEE_TYPE_FFA = 2,
} libxl_tee_type;
char *libxl_tee_type_to_json(libxl_ctx *ctx, libxl_tee_type p);
int libxl_tee_type_from_json(libxl_ctx *ctx, libxl_tee_type *p, const char *s);
const char *libxl_tee_type_to_string(libxl_tee_type p);
int libxl_tee_type_from_string(const char *s, libxl_tee_type *e);
extern libxl_enum_string_table libxl_tee_type_string_table[];

typedef enum libxl_sve_type {
    LIBXL_SVE_TYPE_HW = -1,
    LIBXL_SVE_TYPE_DISABLED = 0,
    LIBXL_SVE_TYPE_128 = 128,
    LIBXL_SVE_TYPE_256 = 256,
    LIBXL_SVE_TYPE_384 = 384,
    LIBXL_SVE_TYPE_512 = 512,
    LIBXL_SVE_TYPE_640 = 640,
    LIBXL_SVE_TYPE_768 = 768,
    LIBXL_SVE_TYPE_896 = 896,
    LIBXL_SVE_TYPE_1024 = 1024,
    LIBXL_SVE_TYPE_1152 = 1152,
    LIBXL_SVE_TYPE_1280 = 1280,
    LIBXL_SVE_TYPE_1408 = 1408,
    LIBXL_SVE_TYPE_1536 = 1536,
    LIBXL_SVE_TYPE_1664 = 1664,
    LIBXL_SVE_TYPE_1792 = 1792,
    LIBXL_SVE_TYPE_1920 = 1920,
    LIBXL_SVE_TYPE_2048 = 2048,
} libxl_sve_type;
char *libxl_sve_type_to_json(libxl_ctx *ctx, libxl_sve_type p);
int libxl_sve_type_from_json(libxl_ctx *ctx, libxl_sve_type *p, const char *s);
const char *libxl_sve_type_to_string(libxl_sve_type p);
int libxl_sve_type_from_string(const char *s, libxl_sve_type *e);
extern libxl_enum_string_table libxl_sve_type_string_table[];

typedef struct libxl_rdm_reserve {
    libxl_rdm_reserve_strategy strategy;
    libxl_rdm_reserve_policy policy;
} libxl_rdm_reserve;
void libxl_rdm_reserve_dispose(libxl_rdm_reserve *p);
void libxl_rdm_reserve_copy(libxl_ctx *ctx, libxl_rdm_reserve *dst, const libxl_rdm_reserve *src);
void libxl_rdm_reserve_init(libxl_rdm_reserve *p);
char *libxl_rdm_reserve_to_json(libxl_ctx *ctx, libxl_rdm_reserve *p);
int libxl_rdm_reserve_from_json(libxl_ctx *ctx, libxl_rdm_reserve *p, const char *s);

typedef enum libxl_altp2m_mode {
    LIBXL_ALTP2M_MODE_DISABLED = 0,
    LIBXL_ALTP2M_MODE_MIXED = 1,
    LIBXL_ALTP2M_MODE_EXTERNAL = 2,
    LIBXL_ALTP2M_MODE_LIMITED = 3,
} libxl_altp2m_mode;
char *libxl_altp2m_mode_to_json(libxl_ctx *ctx, libxl_altp2m_mode p);
int libxl_altp2m_mode_from_json(libxl_ctx *ctx, libxl_altp2m_mode *p, const char *s);
const char *libxl_altp2m_mode_to_string(libxl_altp2m_mode p);
int libxl_altp2m_mode_from_string(const char *s, libxl_altp2m_mode *e);
extern libxl_enum_string_table libxl_altp2m_mode_string_table[];

typedef struct libxl_domain_build_info {
    int max_vcpus;
    libxl_bitmap avail_vcpus;
    libxl_bitmap cpumap;
    libxl_bitmap nodemap;
    int num_vcpu_hard_affinity;
    libxl_bitmap * vcpu_hard_affinity;
    int num_vcpu_soft_affinity;
    libxl_bitmap * vcpu_soft_affinity;
    libxl_defbool numa_placement;
    libxl_tsc_mode tsc_mode;
    uint64_t max_memkb;
    uint64_t target_memkb;
    uint64_t video_memkb;
    uint64_t shadow_memkb;
    uint64_t iommu_memkb;
    uint32_t rtc_timeoffset;
    uint32_t exec_ssidref;
    char * exec_ssid_label;
    libxl_defbool localtime;
    libxl_defbool disable_migrate;
    libxl_cpuid_policy_list cpuid;
    char * blkdev_start;
    int num_vnuma_nodes;
    libxl_vnode_info * vnuma_nodes;
    uint32_t max_grant_frames;
    uint32_t max_maptrack_frames;
    int max_grant_version;
    libxl_device_model_version device_model_version;
    libxl_defbool device_model_stubdomain;
    uint64_t stubdomain_memkb;
    char * stubdomain_kernel;
    char * stubdomain_cmdline;
    char * stubdomain_ramdisk;
    char * device_model;
    uint32_t device_model_ssidref;
    char * device_model_ssid_label;
    char * device_model_user;
    libxl_string_list extra;
    libxl_string_list extra_pv;
    libxl_string_list extra_hvm;
    libxl_domain_sched_params sched_params;
    int num_ioports;
    libxl_ioport_range * ioports;
    int num_irqs;
    uint32_t * irqs;
    int num_iomem;
    libxl_iomem_range * iomem;
    libxl_defbool claim_mode;
    uint32_t event_channels;
    char * kernel;
    char * cmdline;
    char * ramdisk;
    char * device_tree;
    libxl_defbool acpi;
    char * bootloader;
    libxl_string_list bootloader_args;
    libxl_defbool bootloader_restrict;
    char * bootloader_user;
    libxl_timer_mode timer_mode;
    libxl_defbool nested_hvm;
    libxl_defbool apic;
    libxl_defbool dm_restrict;
    libxl_tee_type tee;
    libxl_domain_type type;
    union {
        struct {
            char * firmware;
            libxl_bios_type bios;
            libxl_defbool pae;
            libxl_defbool apic;
            libxl_defbool acpi;
            libxl_defbool acpi_s3;
            libxl_defbool acpi_s4;
            libxl_defbool acpi_laptop_slate;
            libxl_defbool nx;
            libxl_defbool viridian;
            libxl_bitmap viridian_enable;
            libxl_bitmap viridian_disable;
            char * timeoffset;
            libxl_defbool hpet;
            libxl_defbool vpt_align;
            uint64_t mmio_hole_memkb;
            libxl_timer_mode timer_mode;
            libxl_defbool nested_hvm;
            libxl_defbool altp2m;
            char * system_firmware;
            char * smbios_firmware;
            int num_smbios;
            libxl_smbios * smbios;
            char * acpi_firmware;
            libxl_hdtype hdtype;
            libxl_defbool nographic;
            libxl_vga_interface_info vga;
            libxl_vnc_info vnc;
            char * keymap;
            libxl_sdl_info sdl;
            libxl_spice_info spice;
            libxl_defbool gfx_passthru;
            libxl_gfx_passthru_kind gfx_passthru_kind;
            char * serial;
            char * boot;
            libxl_defbool usb;
            int usbversion;
            char * usbdevice;
            libxl_defbool vkb_device;
            char * soundhw;
            libxl_defbool xen_platform_pci;
            libxl_string_list usbdevice_list;
            libxl_vendor_device vendor_device;
            libxl_ms_vm_genid ms_vm_genid;
            libxl_string_list serial_list;
            libxl_rdm_reserve rdm;
            uint64_t rdm_mem_boundary_memkb;
            uint64_t mca_caps;
            libxl_defbool pirq;
        } hvm;
        struct {
            char * kernel;
            uint64_t slack_memkb;
            char * bootloader;
            libxl_string_list bootloader_args;
            char * cmdline;
            char * ramdisk;
            const char * features;
            libxl_defbool e820_host;
        } pv;
        struct {
            libxl_defbool pvshim;
            char * pvshim_path;
            char * pvshim_cmdline;
            char * pvshim_extra;
        } pvh;
    } u;
    struct {
        libxl_gic_version gic_version;
        libxl_vuart_type vuart;
        libxl_sve_type sve_vl;
        uint32_t nr_spis;
    } arch_arm;
    struct {
        libxl_defbool msr_relaxed;
    } arch_x86;
    libxl_altp2m_mode altp2m;
    int vmtrace_buf_kb;
    libxl_defbool vpmu;
} libxl_domain_build_info;
void libxl_domain_build_info_dispose(libxl_domain_build_info *p);
int libxl__domain_build_info_copy_deprecated(libxl_ctx *ctx, libxl_domain_build_info *p);
void libxl_domain_build_info_copy(libxl_ctx *ctx, libxl_domain_build_info *dst, const libxl_domain_build_info *src);
void libxl_domain_build_info_init(libxl_domain_build_info *p);
void libxl_domain_build_info_init_type(libxl_domain_build_info *p, libxl_domain_type type);
char *libxl_domain_build_info_to_json(libxl_ctx *ctx, libxl_domain_build_info *p);
int libxl_domain_build_info_from_json(libxl_ctx *ctx, libxl_domain_build_info *p, const char *s);

typedef struct libxl_device_vfb {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    libxl_vnc_info vnc;
    libxl_sdl_info sdl;
    char * keymap;
} libxl_device_vfb;
void libxl_device_vfb_dispose(libxl_device_vfb *p);
void libxl_device_vfb_copy(libxl_ctx *ctx, libxl_device_vfb *dst, const libxl_device_vfb *src);
void libxl_device_vfb_init(libxl_device_vfb *p);
char *libxl_device_vfb_to_json(libxl_ctx *ctx, libxl_device_vfb *p);
int libxl_device_vfb_from_json(libxl_ctx *ctx, libxl_device_vfb *p, const char *s);

typedef struct libxl_device_vkb {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    libxl_vkb_backend backend_type;
    char * unique_id;
    bool feature_disable_keyboard;
    bool feature_disable_pointer;
    bool feature_abs_pointer;
    bool feature_raw_pointer;
    bool feature_multi_touch;
    uint32_t width;
    uint32_t height;
    uint32_t multi_touch_width;
    uint32_t multi_touch_height;
    uint32_t multi_touch_num_contacts;
} libxl_device_vkb;
void libxl_device_vkb_dispose(libxl_device_vkb *p);
void libxl_device_vkb_copy(libxl_ctx *ctx, libxl_device_vkb *dst, const libxl_device_vkb *src);
void libxl_device_vkb_init(libxl_device_vkb *p);
char *libxl_device_vkb_to_json(libxl_ctx *ctx, libxl_device_vkb *p);
int libxl_device_vkb_from_json(libxl_ctx *ctx, libxl_device_vkb *p, const char *s);

typedef struct libxl_device_virtio {
    libxl_domid backend_domid;
    char * backend_domname;
    char * type;
    libxl_virtio_transport transport;
    libxl_defbool grant_usage;
    libxl_devid devid;
    uint32_t irq;
    uint64_t base;
} libxl_device_virtio;
void libxl_device_virtio_dispose(libxl_device_virtio *p);
void libxl_device_virtio_copy(libxl_ctx *ctx, libxl_device_virtio *dst, const libxl_device_virtio *src);
void libxl_device_virtio_init(libxl_device_virtio *p);
char *libxl_device_virtio_to_json(libxl_ctx *ctx, libxl_device_virtio *p);
int libxl_device_virtio_from_json(libxl_ctx *ctx, libxl_device_virtio *p, const char *s);

typedef struct libxl_device_disk {
    libxl_domid backend_domid;
    char * backend_domname;
    char * pdev_path;
    char * vdev;
    libxl_disk_backend backend;
    libxl_disk_format format;
    char * script;
    int removable;
    int readwrite;
    int is_cdrom;
    bool direct_io_safe;
    libxl_defbool discard_enable;
    libxl_disk_specification specification;
    libxl_disk_transport transport;
    uint32_t irq;
    uint64_t base;
    libxl_defbool colo_enable;
    libxl_defbool colo_restore_enable;
    char * colo_host;
    int colo_port;
    char * colo_export;
    char * active_disk;
    char * hidden_disk;
    libxl_defbool trusted;
    libxl_defbool grant_usage;
} libxl_device_disk;
void libxl_device_disk_dispose(libxl_device_disk *p);
void libxl_device_disk_copy(libxl_ctx *ctx, libxl_device_disk *dst, const libxl_device_disk *src);
void libxl_device_disk_init(libxl_device_disk *p);
char *libxl_device_disk_to_json(libxl_ctx *ctx, libxl_device_disk *p);
int libxl_device_disk_from_json(libxl_ctx *ctx, libxl_device_disk *p, const char *s);

typedef struct libxl_device_nic {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    int mtu;
    char * vlan;
    char * model;
    libxl_mac mac;
    char * ip;
    char * bridge;
    char * ifname;
    char * script;
    libxl_nic_type nictype;
    uint64_t rate_bytes_per_interval;
    uint32_t rate_interval_usecs;
    char * gatewaydev;
    char * coloft_forwarddev;
    char * colo_sock_mirror_id;
    char * colo_sock_mirror_ip;
    char * colo_sock_mirror_port;
    char * colo_sock_compare_pri_in_id;
    char * colo_sock_compare_pri_in_ip;
    char * colo_sock_compare_pri_in_port;
    char * colo_sock_compare_sec_in_id;
    char * colo_sock_compare_sec_in_ip;
    char * colo_sock_compare_sec_in_port;
    char * colo_sock_compare_notify_id;
    char * colo_sock_compare_notify_ip;
    char * colo_sock_compare_notify_port;
    char * colo_sock_redirector0_id;
    char * colo_sock_redirector0_ip;
    char * colo_sock_redirector0_port;
    char * colo_sock_redirector1_id;
    char * colo_sock_redirector1_ip;
    char * colo_sock_redirector1_port;
    char * colo_sock_redirector2_id;
    char * colo_sock_redirector2_ip;
    char * colo_sock_redirector2_port;
    char * colo_filter_mirror_queue;
    char * colo_filter_mirror_outdev;
    char * colo_filter_redirector0_queue;
    char * colo_filter_redirector0_indev;
    char * colo_filter_redirector0_outdev;
    char * colo_filter_redirector1_queue;
    char * colo_filter_redirector1_indev;
    char * colo_filter_redirector1_outdev;
    char * colo_compare_pri_in;
    char * colo_compare_sec_in;
    char * colo_compare_out;
    char * colo_compare_notify_dev;
    char * colo_sock_sec_redirector0_id;
    char * colo_sock_sec_redirector0_ip;
    char * colo_sock_sec_redirector0_port;
    char * colo_sock_sec_redirector1_id;
    char * colo_sock_sec_redirector1_ip;
    char * colo_sock_sec_redirector1_port;
    char * colo_filter_sec_redirector0_queue;
    char * colo_filter_sec_redirector0_indev;
    char * colo_filter_sec_redirector0_outdev;
    char * colo_filter_sec_redirector1_queue;
    char * colo_filter_sec_redirector1_indev;
    char * colo_filter_sec_redirector1_outdev;
    char * colo_filter_sec_rewriter0_queue;
    char * colo_checkpoint_host;
    char * colo_checkpoint_port;
    libxl_defbool trusted;
} libxl_device_nic;
void libxl_device_nic_dispose(libxl_device_nic *p);
void libxl_device_nic_copy(libxl_ctx *ctx, libxl_device_nic *dst, const libxl_device_nic *src);
void libxl_device_nic_init(libxl_device_nic *p);
char *libxl_device_nic_to_json(libxl_ctx *ctx, libxl_device_nic *p);
int libxl_device_nic_from_json(libxl_ctx *ctx, libxl_device_nic *p, const char *s);

typedef struct libxl_device_pci {
    uint8_t func;
    uint8_t dev;
    uint8_t bus;
    int domain;
    uint32_t vdevfn;
    uint32_t vfunc_mask;
    bool msitranslate;
    bool power_mgmt;
    bool permissive;
    bool seize;
    libxl_rdm_reserve_policy rdm_policy;
    char * name;
} libxl_device_pci;
void libxl_device_pci_dispose(libxl_device_pci *p);
void libxl_device_pci_copy(libxl_ctx *ctx, libxl_device_pci *dst, const libxl_device_pci *src);
void libxl_device_pci_init(libxl_device_pci *p);
char *libxl_device_pci_to_json(libxl_ctx *ctx, libxl_device_pci *p);
int libxl_device_pci_from_json(libxl_ctx *ctx, libxl_device_pci *p, const char *s);

typedef struct libxl_device_rdm {
    uint64_t start;
    uint64_t size;
    libxl_rdm_reserve_policy policy;
} libxl_device_rdm;
void libxl_device_rdm_dispose(libxl_device_rdm *p);
void libxl_device_rdm_copy(libxl_ctx *ctx, libxl_device_rdm *dst, const libxl_device_rdm *src);
void libxl_device_rdm_init(libxl_device_rdm *p);
char *libxl_device_rdm_to_json(libxl_ctx *ctx, libxl_device_rdm *p);
int libxl_device_rdm_from_json(libxl_ctx *ctx, libxl_device_rdm *p, const char *s);

typedef enum libxl_usbctrl_type {
    LIBXL_USBCTRL_TYPE_AUTO = 0,
    LIBXL_USBCTRL_TYPE_PV = 1,
    LIBXL_USBCTRL_TYPE_DEVICEMODEL = 2,
    LIBXL_USBCTRL_TYPE_QUSB = 3,
} libxl_usbctrl_type;
char *libxl_usbctrl_type_to_json(libxl_ctx *ctx, libxl_usbctrl_type p);
int libxl_usbctrl_type_from_json(libxl_ctx *ctx, libxl_usbctrl_type *p, const char *s);
const char *libxl_usbctrl_type_to_string(libxl_usbctrl_type p);
int libxl_usbctrl_type_from_string(const char *s, libxl_usbctrl_type *e);
extern libxl_enum_string_table libxl_usbctrl_type_string_table[];

typedef enum libxl_usbdev_type {
    LIBXL_USBDEV_TYPE_HOSTDEV = 1,
} libxl_usbdev_type;
char *libxl_usbdev_type_to_json(libxl_ctx *ctx, libxl_usbdev_type p);
int libxl_usbdev_type_from_json(libxl_ctx *ctx, libxl_usbdev_type *p, const char *s);
const char *libxl_usbdev_type_to_string(libxl_usbdev_type p);
int libxl_usbdev_type_from_string(const char *s, libxl_usbdev_type *e);
extern libxl_enum_string_table libxl_usbdev_type_string_table[];

typedef struct libxl_device_usbctrl {
    libxl_usbctrl_type type;
    libxl_devid devid;
    int version;
    int ports;
    libxl_domid backend_domid;
    char * backend_domname;
} libxl_device_usbctrl;
void libxl_device_usbctrl_dispose(libxl_device_usbctrl *p);
void libxl_device_usbctrl_copy(libxl_ctx *ctx, libxl_device_usbctrl *dst, const libxl_device_usbctrl *src);
void libxl_device_usbctrl_init(libxl_device_usbctrl *p);
char *libxl_device_usbctrl_to_json(libxl_ctx *ctx, libxl_device_usbctrl *p);
int libxl_device_usbctrl_from_json(libxl_ctx *ctx, libxl_device_usbctrl *p, const char *s);

typedef struct libxl_device_usbdev {
    libxl_devid ctrl;
    int port;
    libxl_usbdev_type type;
    union {
        struct {
            uint8_t hostbus;
            uint8_t hostaddr;
        } hostdev;
    } u;
} libxl_device_usbdev;
void libxl_device_usbdev_dispose(libxl_device_usbdev *p);
void libxl_device_usbdev_copy(libxl_ctx *ctx, libxl_device_usbdev *dst, const libxl_device_usbdev *src);
void libxl_device_usbdev_init(libxl_device_usbdev *p);
void libxl_device_usbdev_init_type(libxl_device_usbdev *p, libxl_usbdev_type type);
char *libxl_device_usbdev_to_json(libxl_ctx *ctx, libxl_device_usbdev *p);
int libxl_device_usbdev_from_json(libxl_ctx *ctx, libxl_device_usbdev *p, const char *s);

typedef struct libxl_device_dtdev {
    char * path;
} libxl_device_dtdev;
void libxl_device_dtdev_dispose(libxl_device_dtdev *p);
void libxl_device_dtdev_copy(libxl_ctx *ctx, libxl_device_dtdev *dst, const libxl_device_dtdev *src);
void libxl_device_dtdev_init(libxl_device_dtdev *p);
char *libxl_device_dtdev_to_json(libxl_ctx *ctx, libxl_device_dtdev *p);
int libxl_device_dtdev_from_json(libxl_ctx *ctx, libxl_device_dtdev *p, const char *s);

typedef struct libxl_device_vtpm {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    libxl_uuid uuid;
} libxl_device_vtpm;
void libxl_device_vtpm_dispose(libxl_device_vtpm *p);
void libxl_device_vtpm_copy(libxl_ctx *ctx, libxl_device_vtpm *dst, const libxl_device_vtpm *src);
void libxl_device_vtpm_init(libxl_device_vtpm *p);
char *libxl_device_vtpm_to_json(libxl_ctx *ctx, libxl_device_vtpm *p);
int libxl_device_vtpm_from_json(libxl_ctx *ctx, libxl_device_vtpm *p, const char *s);

typedef struct libxl_device_p9 {
    libxl_domid backend_domid;
    char * backend_domname;
    char * tag;
    char * path;
    char * security_model;
    libxl_devid devid;
    libxl_p9_type type;
    int max_space;
    int max_files;
    int max_open_files;
    bool auto_delete;
} libxl_device_p9;
void libxl_device_p9_dispose(libxl_device_p9 *p);
void libxl_device_p9_copy(libxl_ctx *ctx, libxl_device_p9 *dst, const libxl_device_p9 *src);
void libxl_device_p9_init(libxl_device_p9 *p);
char *libxl_device_p9_to_json(libxl_ctx *ctx, libxl_device_p9 *p);
int libxl_device_p9_from_json(libxl_ctx *ctx, libxl_device_p9 *p, const char *s);

typedef struct libxl_device_pvcallsif {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
} libxl_device_pvcallsif;
void libxl_device_pvcallsif_dispose(libxl_device_pvcallsif *p);
void libxl_device_pvcallsif_copy(libxl_ctx *ctx, libxl_device_pvcallsif *dst, const libxl_device_pvcallsif *src);
void libxl_device_pvcallsif_init(libxl_device_pvcallsif *p);
char *libxl_device_pvcallsif_to_json(libxl_ctx *ctx, libxl_device_pvcallsif *p);
int libxl_device_pvcallsif_from_json(libxl_ctx *ctx, libxl_device_pvcallsif *p, const char *s);

typedef struct libxl_device_channel {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    char * name;
    libxl_channel_connection connection;
    union {
        struct {
            char * path;
        } socket;
    } u;
} libxl_device_channel;
void libxl_device_channel_dispose(libxl_device_channel *p);
void libxl_device_channel_copy(libxl_ctx *ctx, libxl_device_channel *dst, const libxl_device_channel *src);
void libxl_device_channel_init(libxl_device_channel *p);
void libxl_device_channel_init_connection(libxl_device_channel *p, libxl_channel_connection connection);
char *libxl_device_channel_to_json(libxl_ctx *ctx, libxl_device_channel *p);
int libxl_device_channel_from_json(libxl_ctx *ctx, libxl_device_channel *p, const char *s);

typedef struct libxl_connector_param {
    char * unique_id;
    uint32_t width;
    uint32_t height;
} libxl_connector_param;
void libxl_connector_param_dispose(libxl_connector_param *p);
void libxl_connector_param_copy(libxl_ctx *ctx, libxl_connector_param *dst, const libxl_connector_param *src);
void libxl_connector_param_init(libxl_connector_param *p);
char *libxl_connector_param_to_json(libxl_ctx *ctx, libxl_connector_param *p);
int libxl_connector_param_from_json(libxl_ctx *ctx, libxl_connector_param *p, const char *s);

typedef struct libxl_device_vdispl {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    bool be_alloc;
    int num_connectors;
    libxl_connector_param * connectors;
} libxl_device_vdispl;
void libxl_device_vdispl_dispose(libxl_device_vdispl *p);
void libxl_device_vdispl_copy(libxl_ctx *ctx, libxl_device_vdispl *dst, const libxl_device_vdispl *src);
void libxl_device_vdispl_init(libxl_device_vdispl *p);
char *libxl_device_vdispl_to_json(libxl_ctx *ctx, libxl_device_vdispl *p);
int libxl_device_vdispl_from_json(libxl_ctx *ctx, libxl_device_vdispl *p, const char *s);

typedef enum libxl_vsnd_pcm_format {
    LIBXL_VSND_PCM_FORMAT_S8 = 1,
    LIBXL_VSND_PCM_FORMAT_U8 = 2,
    LIBXL_VSND_PCM_FORMAT_S16_LE = 3,
    LIBXL_VSND_PCM_FORMAT_S16_BE = 4,
    LIBXL_VSND_PCM_FORMAT_U16_LE = 5,
    LIBXL_VSND_PCM_FORMAT_U16_BE = 6,
    LIBXL_VSND_PCM_FORMAT_S24_LE = 7,
    LIBXL_VSND_PCM_FORMAT_S24_BE = 8,
    LIBXL_VSND_PCM_FORMAT_U24_LE = 9,
    LIBXL_VSND_PCM_FORMAT_U24_BE = 10,
    LIBXL_VSND_PCM_FORMAT_S32_LE = 11,
    LIBXL_VSND_PCM_FORMAT_S32_BE = 12,
    LIBXL_VSND_PCM_FORMAT_U32_LE = 13,
    LIBXL_VSND_PCM_FORMAT_U32_BE = 14,
    LIBXL_VSND_PCM_FORMAT_F32_LE = 15,
    LIBXL_VSND_PCM_FORMAT_F32_BE = 16,
    LIBXL_VSND_PCM_FORMAT_F64_LE = 17,
    LIBXL_VSND_PCM_FORMAT_F64_BE = 18,
    LIBXL_VSND_PCM_FORMAT_IEC958_SUBFRAME_LE = 19,
    LIBXL_VSND_PCM_FORMAT_IEC958_SUBFRAME_BE = 20,
    LIBXL_VSND_PCM_FORMAT_MU_LAW = 21,
    LIBXL_VSND_PCM_FORMAT_A_LAW = 22,
    LIBXL_VSND_PCM_FORMAT_IMA_ADPCM = 23,
    LIBXL_VSND_PCM_FORMAT_MPEG = 24,
    LIBXL_VSND_PCM_FORMAT_GSM = 25,
} libxl_vsnd_pcm_format;
char *libxl_vsnd_pcm_format_to_json(libxl_ctx *ctx, libxl_vsnd_pcm_format p);
int libxl_vsnd_pcm_format_from_json(libxl_ctx *ctx, libxl_vsnd_pcm_format *p, const char *s);
const char *libxl_vsnd_pcm_format_to_string(libxl_vsnd_pcm_format p);
int libxl_vsnd_pcm_format_from_string(const char *s, libxl_vsnd_pcm_format *e);
extern libxl_enum_string_table libxl_vsnd_pcm_format_string_table[];

typedef struct libxl_vsnd_params {
    int num_sample_rates;
    uint32_t * sample_rates;
    int num_sample_formats;
    libxl_vsnd_pcm_format * sample_formats;
    uint32_t channels_min;
    uint32_t channels_max;
    uint32_t buffer_size;
} libxl_vsnd_params;
void libxl_vsnd_params_dispose(libxl_vsnd_params *p);
void libxl_vsnd_params_copy(libxl_ctx *ctx, libxl_vsnd_params *dst, const libxl_vsnd_params *src);
void libxl_vsnd_params_init(libxl_vsnd_params *p);
char *libxl_vsnd_params_to_json(libxl_ctx *ctx, libxl_vsnd_params *p);
int libxl_vsnd_params_from_json(libxl_ctx *ctx, libxl_vsnd_params *p, const char *s);

typedef enum libxl_vsnd_stream_type {
    LIBXL_VSND_STREAM_TYPE_P = 1,
    LIBXL_VSND_STREAM_TYPE_C = 2,
} libxl_vsnd_stream_type;
char *libxl_vsnd_stream_type_to_json(libxl_ctx *ctx, libxl_vsnd_stream_type p);
int libxl_vsnd_stream_type_from_json(libxl_ctx *ctx, libxl_vsnd_stream_type *p, const char *s);
const char *libxl_vsnd_stream_type_to_string(libxl_vsnd_stream_type p);
int libxl_vsnd_stream_type_from_string(const char *s, libxl_vsnd_stream_type *e);
extern libxl_enum_string_table libxl_vsnd_stream_type_string_table[];

typedef struct libxl_vsnd_stream {
    char * unique_id;
    libxl_vsnd_stream_type type;
    libxl_vsnd_params params;
} libxl_vsnd_stream;
void libxl_vsnd_stream_dispose(libxl_vsnd_stream *p);
void libxl_vsnd_stream_copy(libxl_ctx *ctx, libxl_vsnd_stream *dst, const libxl_vsnd_stream *src);
void libxl_vsnd_stream_init(libxl_vsnd_stream *p);
char *libxl_vsnd_stream_to_json(libxl_ctx *ctx, libxl_vsnd_stream *p);
int libxl_vsnd_stream_from_json(libxl_ctx *ctx, libxl_vsnd_stream *p, const char *s);

typedef struct libxl_vsnd_pcm {
    char * name;
    libxl_vsnd_params params;
    int num_vsnd_streams;
    libxl_vsnd_stream * streams;
} libxl_vsnd_pcm;
void libxl_vsnd_pcm_dispose(libxl_vsnd_pcm *p);
void libxl_vsnd_pcm_copy(libxl_ctx *ctx, libxl_vsnd_pcm *dst, const libxl_vsnd_pcm *src);
void libxl_vsnd_pcm_init(libxl_vsnd_pcm *p);
char *libxl_vsnd_pcm_to_json(libxl_ctx *ctx, libxl_vsnd_pcm *p);
int libxl_vsnd_pcm_from_json(libxl_ctx *ctx, libxl_vsnd_pcm *p, const char *s);

typedef struct libxl_device_vsnd {
    libxl_domid backend_domid;
    char * backend_domname;
    libxl_devid devid;
    char * short_name;
    char * long_name;
    libxl_vsnd_params params;
    int num_vsnd_pcms;
    libxl_vsnd_pcm * pcms;
} libxl_device_vsnd;
void libxl_device_vsnd_dispose(libxl_device_vsnd *p);
void libxl_device_vsnd_copy(libxl_ctx *ctx, libxl_device_vsnd *dst, const libxl_device_vsnd *src);
void libxl_device_vsnd_init(libxl_device_vsnd *p);
char *libxl_device_vsnd_to_json(libxl_ctx *ctx, libxl_device_vsnd *p);
int libxl_device_vsnd_from_json(libxl_ctx *ctx, libxl_device_vsnd *p, const char *s);

typedef struct libxl_domain_config {
    libxl_domain_create_info c_info;
    libxl_domain_build_info b_info;
    int num_disks;
    libxl_device_disk * disks;
    int num_nics;
    libxl_device_nic * nics;
    int num_pcidevs;
    libxl_device_pci * pcidevs;
    int num_rdms;
    libxl_device_rdm * rdms;
    int num_dtdevs;
    libxl_device_dtdev * dtdevs;
    int num_vfbs;
    libxl_device_vfb * vfbs;
    int num_vkbs;
    libxl_device_vkb * vkbs;
    int num_virtios;
    libxl_device_virtio * virtios;
    int num_vtpms;
    libxl_device_vtpm * vtpms;
    int num_p9s;
    libxl_device_p9 * p9s;
    int num_pvcallsifs;
    libxl_device_pvcallsif * pvcallsifs;
    int num_vdispls;
    libxl_device_vdispl * vdispls;
    int num_vsnds;
    libxl_device_vsnd * vsnds;
    int num_channels;
    libxl_device_channel * channels;
    int num_usbctrls;
    libxl_device_usbctrl * usbctrls;
    int num_usbdevs;
    libxl_device_usbdev * usbdevs;
    libxl_action_on_shutdown on_poweroff;
    libxl_action_on_shutdown on_reboot;
    libxl_action_on_shutdown on_watchdog;
    libxl_action_on_shutdown on_crash;
    libxl_action_on_shutdown on_soft_reset;
} libxl_domain_config;
void libxl_domain_config_dispose(libxl_domain_config *p);
void libxl_domain_config_copy(libxl_ctx *ctx, libxl_domain_config *dst, const libxl_domain_config *src);
void libxl_domain_config_init(libxl_domain_config *p);
char *libxl_domain_config_to_json(libxl_ctx *ctx, libxl_domain_config *p);
int libxl_domain_config_from_json(libxl_ctx *ctx, libxl_domain_config *p, const char *s);

typedef struct libxl_diskinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
} libxl_diskinfo;
void libxl_diskinfo_dispose(libxl_diskinfo *p);
void libxl_diskinfo_copy(libxl_ctx *ctx, libxl_diskinfo *dst, const libxl_diskinfo *src);
void libxl_diskinfo_init(libxl_diskinfo *p);
char *libxl_diskinfo_to_json(libxl_ctx *ctx, libxl_diskinfo *p);
int libxl_diskinfo_from_json(libxl_ctx *ctx, libxl_diskinfo *p, const char *s);

typedef struct libxl_nicinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref_tx;
    int rref_rx;
} libxl_nicinfo;
void libxl_nicinfo_dispose(libxl_nicinfo *p);
void libxl_nicinfo_copy(libxl_ctx *ctx, libxl_nicinfo *dst, const libxl_nicinfo *src);
void libxl_nicinfo_init(libxl_nicinfo *p);
char *libxl_nicinfo_to_json(libxl_ctx *ctx, libxl_nicinfo *p);
int libxl_nicinfo_from_json(libxl_ctx *ctx, libxl_nicinfo *p, const char *s);

typedef struct libxl_vtpminfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
    libxl_uuid uuid;
} libxl_vtpminfo;
void libxl_vtpminfo_dispose(libxl_vtpminfo *p);
void libxl_vtpminfo_copy(libxl_ctx *ctx, libxl_vtpminfo *dst, const libxl_vtpminfo *src);
void libxl_vtpminfo_init(libxl_vtpminfo *p);
char *libxl_vtpminfo_to_json(libxl_ctx *ctx, libxl_vtpminfo *p);
int libxl_vtpminfo_from_json(libxl_ctx *ctx, libxl_vtpminfo *p, const char *s);

typedef struct libxl_usbctrlinfo {
    libxl_usbctrl_type type;
    libxl_devid devid;
    int version;
    int ports;
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    int state;
    int evtch;
    int ref_urb;
    int ref_conn;
} libxl_usbctrlinfo;
void libxl_usbctrlinfo_dispose(libxl_usbctrlinfo *p);
void libxl_usbctrlinfo_copy(libxl_ctx *ctx, libxl_usbctrlinfo *dst, const libxl_usbctrlinfo *src);
void libxl_usbctrlinfo_init(libxl_usbctrlinfo *p);
char *libxl_usbctrlinfo_to_json(libxl_ctx *ctx, libxl_usbctrlinfo *p);
int libxl_usbctrlinfo_from_json(libxl_ctx *ctx, libxl_usbctrlinfo *p, const char *s);

typedef struct libxl_vcpuinfo {
    uint32_t vcpuid;
    uint32_t cpu;
    bool online;
    bool blocked;
    bool running;
    uint64_t vcpu_time;
    libxl_bitmap cpumap;
    libxl_bitmap cpumap_soft;
} libxl_vcpuinfo;
void libxl_vcpuinfo_dispose(libxl_vcpuinfo *p);
void libxl_vcpuinfo_copy(libxl_ctx *ctx, libxl_vcpuinfo *dst, const libxl_vcpuinfo *src);
void libxl_vcpuinfo_init(libxl_vcpuinfo *p);
char *libxl_vcpuinfo_to_json(libxl_ctx *ctx, libxl_vcpuinfo *p);
int libxl_vcpuinfo_from_json(libxl_ctx *ctx, libxl_vcpuinfo *p, const char *s);

typedef struct libxl_physinfo {
    uint32_t threads_per_core;
    uint32_t cores_per_socket;
    uint32_t max_cpu_id;
    uint32_t nr_cpus;
    uint32_t cpu_khz;
    uint64_t total_pages;
    uint64_t free_pages;
    uint64_t scrub_pages;
    uint64_t outstanding_pages;
    uint64_t sharing_freed_pages;
    uint64_t sharing_used_frames;
    uint64_t max_possible_mfn;
    uint32_t nr_nodes;
    libxl_hwcap hw_cap;
    bool cap_hvm;
    bool cap_pv;
    bool cap_hvm_directio;
    bool cap_hap;
    bool cap_shadow;
    bool cap_iommu_hap_pt_share;
    bool cap_vmtrace;
    bool cap_vpmu;
    bool cap_gnttab_v1;
    bool cap_gnttab_v2;
    uint32_t arch_capabilities;
} libxl_physinfo;
void libxl_physinfo_dispose(libxl_physinfo *p);
void libxl_physinfo_copy(libxl_ctx *ctx, libxl_physinfo *dst, const libxl_physinfo *src);
void libxl_physinfo_init(libxl_physinfo *p);
char *libxl_physinfo_to_json(libxl_ctx *ctx, libxl_physinfo *p);
int libxl_physinfo_from_json(libxl_ctx *ctx, libxl_physinfo *p, const char *s);

typedef struct libxl_connectorinfo {
    char * unique_id;
    uint32_t width;
    uint32_t height;
    int req_evtch;
    int req_rref;
    int evt_evtch;
    int evt_rref;
} libxl_connectorinfo;
void libxl_connectorinfo_dispose(libxl_connectorinfo *p);
void libxl_connectorinfo_copy(libxl_ctx *ctx, libxl_connectorinfo *dst, const libxl_connectorinfo *src);
void libxl_connectorinfo_init(libxl_connectorinfo *p);
char *libxl_connectorinfo_to_json(libxl_ctx *ctx, libxl_connectorinfo *p);
int libxl_connectorinfo_from_json(libxl_ctx *ctx, libxl_connectorinfo *p, const char *s);

typedef struct libxl_vdisplinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    bool be_alloc;
    int num_connectors;
    libxl_connectorinfo * connectors;
} libxl_vdisplinfo;
void libxl_vdisplinfo_dispose(libxl_vdisplinfo *p);
void libxl_vdisplinfo_copy(libxl_ctx *ctx, libxl_vdisplinfo *dst, const libxl_vdisplinfo *src);
void libxl_vdisplinfo_init(libxl_vdisplinfo *p);
char *libxl_vdisplinfo_to_json(libxl_ctx *ctx, libxl_vdisplinfo *p);
int libxl_vdisplinfo_from_json(libxl_ctx *ctx, libxl_vdisplinfo *p, const char *s);

typedef struct libxl_streaminfo {
    int req_evtch;
    int req_rref;
} libxl_streaminfo;
void libxl_streaminfo_dispose(libxl_streaminfo *p);
void libxl_streaminfo_copy(libxl_ctx *ctx, libxl_streaminfo *dst, const libxl_streaminfo *src);
void libxl_streaminfo_init(libxl_streaminfo *p);
char *libxl_streaminfo_to_json(libxl_ctx *ctx, libxl_streaminfo *p);
int libxl_streaminfo_from_json(libxl_ctx *ctx, libxl_streaminfo *p, const char *s);

typedef struct libxl_pcminfo {
    int num_vsnd_streams;
    libxl_streaminfo * streams;
} libxl_pcminfo;
void libxl_pcminfo_dispose(libxl_pcminfo *p);
void libxl_pcminfo_copy(libxl_ctx *ctx, libxl_pcminfo *dst, const libxl_pcminfo *src);
void libxl_pcminfo_init(libxl_pcminfo *p);
char *libxl_pcminfo_to_json(libxl_ctx *ctx, libxl_pcminfo *p);
int libxl_pcminfo_from_json(libxl_ctx *ctx, libxl_pcminfo *p, const char *s);

typedef struct libxl_vsndinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int num_vsnd_pcms;
    libxl_pcminfo * pcms;
} libxl_vsndinfo;
void libxl_vsndinfo_dispose(libxl_vsndinfo *p);
void libxl_vsndinfo_copy(libxl_ctx *ctx, libxl_vsndinfo *dst, const libxl_vsndinfo *src);
void libxl_vsndinfo_init(libxl_vsndinfo *p);
char *libxl_vsndinfo_to_json(libxl_ctx *ctx, libxl_vsndinfo *p);
int libxl_vsndinfo_from_json(libxl_ctx *ctx, libxl_vsndinfo *p, const char *s);

typedef struct libxl_vkbinfo {
    char * backend;
    uint32_t backend_id;
    char * frontend;
    uint32_t frontend_id;
    libxl_devid devid;
    int state;
    int evtch;
    int rref;
} libxl_vkbinfo;
void libxl_vkbinfo_dispose(libxl_vkbinfo *p);
void libxl_vkbinfo_copy(libxl_ctx *ctx, libxl_vkbinfo *dst, const libxl_vkbinfo *src);
void libxl_vkbinfo_init(libxl_vkbinfo *p);
char *libxl_vkbinfo_to_json(libxl_ctx *ctx, libxl_vkbinfo *p);
int libxl_vkbinfo_from_json(libxl_ctx *ctx, libxl_vkbinfo *p, const char *s);

typedef struct libxl_numainfo {
    uint64_t size;
    uint64_t free;
    int num_dists;
    uint32_t * dists;
} libxl_numainfo;
void libxl_numainfo_dispose(libxl_numainfo *p);
void libxl_numainfo_copy(libxl_ctx *ctx, libxl_numainfo *dst, const libxl_numainfo *src);
void libxl_numainfo_init(libxl_numainfo *p);
char *libxl_numainfo_to_json(libxl_ctx *ctx, libxl_numainfo *p);
int libxl_numainfo_from_json(libxl_ctx *ctx, libxl_numainfo *p, const char *s);

typedef struct libxl_cputopology {
    uint32_t core;
    uint32_t socket;
    uint32_t node;
} libxl_cputopology;
void libxl_cputopology_dispose(libxl_cputopology *p);
void libxl_cputopology_copy(libxl_ctx *ctx, libxl_cputopology *dst, const libxl_cputopology *src);
void libxl_cputopology_init(libxl_cputopology *p);
char *libxl_cputopology_to_json(libxl_ctx *ctx, libxl_cputopology *p);
int libxl_cputopology_from_json(libxl_ctx *ctx, libxl_cputopology *p, const char *s);

typedef struct libxl_pcitopology {
    uint16_t seg;
    uint8_t bus;
    uint8_t devfn;
    uint32_t node;
} libxl_pcitopology;
void libxl_pcitopology_dispose(libxl_pcitopology *p);
void libxl_pcitopology_copy(libxl_ctx *ctx, libxl_pcitopology *dst, const libxl_pcitopology *src);
void libxl_pcitopology_init(libxl_pcitopology *p);
char *libxl_pcitopology_to_json(libxl_ctx *ctx, libxl_pcitopology *p);
int libxl_pcitopology_from_json(libxl_ctx *ctx, libxl_pcitopology *p, const char *s);

typedef struct libxl_sched_credit_params {
    int tslice_ms;
    int ratelimit_us;
    int vcpu_migr_delay_us;
} libxl_sched_credit_params;
void libxl_sched_credit_params_copy(libxl_ctx *ctx, libxl_sched_credit_params *dst, const libxl_sched_credit_params *src);
void libxl_sched_credit_params_init(libxl_sched_credit_params *p);
char *libxl_sched_credit_params_to_json(libxl_ctx *ctx, libxl_sched_credit_params *p);
int libxl_sched_credit_params_from_json(libxl_ctx *ctx, libxl_sched_credit_params *p, const char *s);

typedef struct libxl_sched_credit2_params {
    int ratelimit_us;
} libxl_sched_credit2_params;
void libxl_sched_credit2_params_copy(libxl_ctx *ctx, libxl_sched_credit2_params *dst, const libxl_sched_credit2_params *src);
void libxl_sched_credit2_params_init(libxl_sched_credit2_params *p);
char *libxl_sched_credit2_params_to_json(libxl_ctx *ctx, libxl_sched_credit2_params *p);
int libxl_sched_credit2_params_from_json(libxl_ctx *ctx, libxl_sched_credit2_params *p, const char *s);

typedef struct libxl_domain_remus_info {
    int interval;
    libxl_defbool allow_unsafe;
    libxl_defbool blackhole;
    libxl_defbool compression;
    libxl_defbool netbuf;
    char * netbufscript;
    libxl_defbool diskbuf;
    libxl_defbool colo;
    libxl_defbool userspace_colo_proxy;
} libxl_domain_remus_info;
void libxl_domain_remus_info_dispose(libxl_domain_remus_info *p);
void libxl_domain_remus_info_copy(libxl_ctx *ctx, libxl_domain_remus_info *dst, const libxl_domain_remus_info *src);
void libxl_domain_remus_info_init(libxl_domain_remus_info *p);
char *libxl_domain_remus_info_to_json(libxl_ctx *ctx, libxl_domain_remus_info *p);
int libxl_domain_remus_info_from_json(libxl_ctx *ctx, libxl_domain_remus_info *p, const char *s);

typedef enum libxl_event_type {
    LIBXL_EVENT_TYPE_DOMAIN_SHUTDOWN = 1,
    LIBXL_EVENT_TYPE_DOMAIN_DEATH = 2,
    LIBXL_EVENT_TYPE_DISK_EJECT = 3,
    LIBXL_EVENT_TYPE_OPERATION_COMPLETE = 4,
    LIBXL_EVENT_TYPE_DOMAIN_CREATE_CONSOLE_AVAILABLE = 5,
} libxl_event_type;
char *libxl_event_type_to_json(libxl_ctx *ctx, libxl_event_type p);
int libxl_event_type_from_json(libxl_ctx *ctx, libxl_event_type *p, const char *s);
const char *libxl_event_type_to_string(libxl_event_type p);
int libxl_event_type_from_string(const char *s, libxl_event_type *e);
extern libxl_enum_string_table libxl_event_type_string_table[];

typedef struct libxl_event {
    libxl_ev_link link;
    libxl_domid domid;
    libxl_uuid domuuid;
    uint64_t for_user;
    libxl_event_type type;
    union {
        struct {
            uint8_t shutdown_reason;
        } domain_shutdown;
        struct {
            char * vdev;
            libxl_device_disk disk;
        } disk_eject;
        struct {
            int rc;
        } operation_complete;
    } u;
} libxl_event;
void libxl_event_dispose(libxl_event *p);
void libxl_event_copy(libxl_ctx *ctx, libxl_event *dst, const libxl_event *src);
void libxl_event_init(libxl_event *p);
void libxl_event_init_type(libxl_event *p, libxl_event_type type);
char *libxl_event_to_json(libxl_ctx *ctx, libxl_event *p);
int libxl_event_from_json(libxl_ctx *ctx, libxl_event *p, const char *s);

typedef enum libxl_psr_cmt_type {
    LIBXL_PSR_CMT_TYPE_CACHE_OCCUPANCY = 1,
    LIBXL_PSR_CMT_TYPE_TOTAL_MEM_COUNT = 2,
    LIBXL_PSR_CMT_TYPE_LOCAL_MEM_COUNT = 3,
} libxl_psr_cmt_type;
char *libxl_psr_cmt_type_to_json(libxl_ctx *ctx, libxl_psr_cmt_type p);
int libxl_psr_cmt_type_from_json(libxl_ctx *ctx, libxl_psr_cmt_type *p, const char *s);
const char *libxl_psr_cmt_type_to_string(libxl_psr_cmt_type p);
int libxl_psr_cmt_type_from_string(const char *s, libxl_psr_cmt_type *e);
extern libxl_enum_string_table libxl_psr_cmt_type_string_table[];

typedef enum libxl_psr_cbm_type {
    LIBXL_PSR_CBM_TYPE_UNKNOWN = 0,
    LIBXL_PSR_CBM_TYPE_L3_CBM = 1,
    LIBXL_PSR_CBM_TYPE_L3_CBM_CODE = 2,
    LIBXL_PSR_CBM_TYPE_L3_CBM_DATA = 3,
    LIBXL_PSR_CBM_TYPE_L2_CBM = 4,
    LIBXL_PSR_CBM_TYPE_MBA_THRTL = 5,
} libxl_psr_cbm_type;
char *libxl_psr_cbm_type_to_json(libxl_ctx *ctx, libxl_psr_cbm_type p);
int libxl_psr_cbm_type_from_json(libxl_ctx *ctx, libxl_psr_cbm_type *p, const char *s);
const char *libxl_psr_cbm_type_to_string(libxl_psr_cbm_type p);
int libxl_psr_cbm_type_from_string(const char *s, libxl_psr_cbm_type *e);
extern libxl_enum_string_table libxl_psr_cbm_type_string_table[];

typedef struct libxl_psr_cat_info {
    uint32_t id;
    uint32_t cos_max;
    uint32_t cbm_len;
    bool cdp_enabled;
} libxl_psr_cat_info;
void libxl_psr_cat_info_dispose(libxl_psr_cat_info *p);
void libxl_psr_cat_info_copy(libxl_ctx *ctx, libxl_psr_cat_info *dst, const libxl_psr_cat_info *src);
void libxl_psr_cat_info_init(libxl_psr_cat_info *p);
char *libxl_psr_cat_info_to_json(libxl_ctx *ctx, libxl_psr_cat_info *p);
int libxl_psr_cat_info_from_json(libxl_ctx *ctx, libxl_psr_cat_info *p, const char *s);

typedef enum libxl_psr_feat_type {
    LIBXL_PSR_FEAT_TYPE_CAT = 1,
    LIBXL_PSR_FEAT_TYPE_MBA = 2,
} libxl_psr_feat_type;
char *libxl_psr_feat_type_to_json(libxl_ctx *ctx, libxl_psr_feat_type p);
int libxl_psr_feat_type_from_json(libxl_ctx *ctx, libxl_psr_feat_type *p, const char *s);
const char *libxl_psr_feat_type_to_string(libxl_psr_feat_type p);
int libxl_psr_feat_type_from_string(const char *s, libxl_psr_feat_type *e);
extern libxl_enum_string_table libxl_psr_feat_type_string_table[];

typedef struct libxl_psr_hw_info {
    uint32_t id;
    libxl_psr_feat_type type;
    union {
        struct {
            uint32_t cos_max;
            uint32_t cbm_len;
            bool cdp_enabled;
        } cat;
        struct {
            uint32_t cos_max;
            uint32_t thrtl_max;
            bool linear;
        } mba;
    } u;
} libxl_psr_hw_info;
void libxl_psr_hw_info_dispose(libxl_psr_hw_info *p);
void libxl_psr_hw_info_copy(libxl_ctx *ctx, libxl_psr_hw_info *dst, const libxl_psr_hw_info *src);
void libxl_psr_hw_info_init(libxl_psr_hw_info *p);
void libxl_psr_hw_info_init_type(libxl_psr_hw_info *p, libxl_psr_feat_type type);
char *libxl_psr_hw_info_to_json(libxl_ctx *ctx, libxl_psr_hw_info *p);
int libxl_psr_hw_info_from_json(libxl_ctx *ctx, libxl_psr_hw_info *p, const char *s);

#endif /* __LIBXL_TYPES_H */
