/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.Value;

public class IntegerRange
extends Value
implements GroundedValue {
    public long start;
    public long end;

    public IntegerRange(long start, long end) throws XPathException {
        if (end < start) {
            throw new IllegalArgumentException("end < start in IntegerRange");
        }
        if (end - start > Integer.MAX_VALUE) {
            throw new XPathException("Maximum length of sequence in Saxon is 2147483647");
        }
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public SequenceIterator iterate() throws XPathException {
        return new RangeIterator(this.start, this.end);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.INTEGER;
    }

    public int getCardinality() {
        return 32768;
    }

    public Item itemAt(int n) {
        if (n < 0 || (long)n > this.end - this.start) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n);
    }

    public GroundedValue subsequence(int start, int length) {
        if (length <= 0) {
            return EmptySequence.getInstance();
        }
        long newStart = this.start + (long)(start > 0 ? start : 0);
        long newEnd = newStart + (long)length - 1L;
        if (newEnd > this.end) {
            newEnd = this.end;
        }
        if (newEnd >= newStart) {
            try {
                return new IntegerRange(newStart, newEnd);
            }
            catch (XPathException e) {
                throw new IllegalStateException(e);
            }
        }
        return EmptySequence.getInstance();
    }

    public int getLength() throws XPathException {
        return (int)(this.end - this.start + 1L);
    }
}

