// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package paymentcryptographydata

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDecryptData = "DecryptData"

// DecryptDataRequest generates a "aws/request.Request" representing the
// client's request for the DecryptData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DecryptData for more information on using the DecryptData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DecryptDataRequest method.
//	req, resp := client.DecryptDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DecryptData
func (c *PaymentCryptographyData) DecryptDataRequest(input *DecryptDataInput) (req *request.Request, output *DecryptDataOutput) {
	op := &request.Operation{
		Name:       opDecryptData,
		HTTPMethod: "POST",
		HTTPPath:   "/keys/{KeyIdentifier}/decrypt",
	}

	if input == nil {
		input = &DecryptDataInput{}
	}

	output = &DecryptDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DecryptData API operation for Payment Cryptography Data Plane.
//
// Decrypts ciphertext data to plaintext using a symmetric (TDES, AES), asymmetric
// (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information,
// see Decrypt data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/decrypt-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// You can use an encryption key generated within Amazon Web Services Payment
// Cryptography, or you can import your own encryption key by calling ImportKey
// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
// For this operation, the key must have KeyModesOfUse set to Decrypt. In asymmetric
// decryption, Amazon Web Services Payment Cryptography decrypts the ciphertext
// using the private component of the asymmetric encryption key pair. For data
// encryption outside of Amazon Web Services Payment Cryptography, you can export
// the public component of the asymmetric key pair by calling GetPublicCertificate
// (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html).
//
// For symmetric and DUKPT decryption, Amazon Web Services Payment Cryptography
// supports TDES and AES algorithms. For EMV decryption, Amazon Web Services
// Payment Cryptography supports TDES algorithms. For asymmetric decryption,
// Amazon Web Services Payment Cryptography supports RSA.
//
// When you use TDES or TDES DUKPT, the ciphertext data length must be a multiple
// of 8 bytes. For AES or AES DUKPT, the ciphertext data length must be a multiple
// of 16 bytes. For RSA, it sould be equal to the key size unless padding is
// enabled.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - EncryptData
//
//   - GetPublicCertificate (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html)
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation DecryptData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/DecryptData
func (c *PaymentCryptographyData) DecryptData(input *DecryptDataInput) (*DecryptDataOutput, error) {
	req, out := c.DecryptDataRequest(input)
	return out, req.Send()
}

// DecryptDataWithContext is the same as DecryptData with the addition of
// the ability to pass a context and additional request options.
//
// See DecryptData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) DecryptDataWithContext(ctx aws.Context, input *DecryptDataInput, opts ...request.Option) (*DecryptDataOutput, error) {
	req, out := c.DecryptDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEncryptData = "EncryptData"

// EncryptDataRequest generates a "aws/request.Request" representing the
// client's request for the EncryptData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EncryptData for more information on using the EncryptData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the EncryptDataRequest method.
//	req, resp := client.EncryptDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/EncryptData
func (c *PaymentCryptographyData) EncryptDataRequest(input *EncryptDataInput) (req *request.Request, output *EncryptDataOutput) {
	op := &request.Operation{
		Name:       opEncryptData,
		HTTPMethod: "POST",
		HTTPPath:   "/keys/{KeyIdentifier}/encrypt",
	}

	if input == nil {
		input = &EncryptDataInput{}
	}

	output = &EncryptDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// EncryptData API operation for Payment Cryptography Data Plane.
//
// Encrypts plaintext data to ciphertext using a symmetric (TDES, AES), asymmetric
// (RSA), or derived (DUKPT or EMV) encryption key scheme. For more information,
// see Encrypt data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// You can generate an encryption key within Amazon Web Services Payment Cryptography
// by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html).
// You can import your own encryption key by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
// For this operation, the key must have KeyModesOfUse set to Encrypt. In asymmetric
// encryption, plaintext is encrypted using public component. You can import
// the public component of an asymmetric key pair created outside Amazon Web
// Services Payment Cryptography by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
//
// For symmetric and DUKPT encryption, Amazon Web Services Payment Cryptography
// supports TDES and AES algorithms. For EMV encryption, Amazon Web Services
// Payment Cryptography supports TDES algorithms.For asymmetric encryption,
// Amazon Web Services Payment Cryptography supports RSA.
//
// When you use TDES or TDES DUKPT, the plaintext data length must be a multiple
// of 8 bytes. For AES or AES DUKPT, the plaintext data length must be a multiple
// of 16 bytes. For RSA, it sould be equal to the key size unless padding is
// enabled.
//
// To encrypt using DUKPT, you must already have a BDK (Base Derivation Key)
// key in your account with KeyModesOfUse set to DeriveKey, or you can generate
// a new DUKPT key by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html).
// To encrypt using EMV, you must already have an IMK (Issuer Master Key) key
// in your account with KeyModesOfUse set to DeriveKey.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DecryptData
//
//   - GetPublicCertificate (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html)
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
//   - ReEncryptData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation EncryptData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/EncryptData
func (c *PaymentCryptographyData) EncryptData(input *EncryptDataInput) (*EncryptDataOutput, error) {
	req, out := c.EncryptDataRequest(input)
	return out, req.Send()
}

// EncryptDataWithContext is the same as EncryptData with the addition of
// the ability to pass a context and additional request options.
//
// See EncryptData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) EncryptDataWithContext(ctx aws.Context, input *EncryptDataInput, opts ...request.Option) (*EncryptDataOutput, error) {
	req, out := c.EncryptDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateCardValidationData = "GenerateCardValidationData"

// GenerateCardValidationDataRequest generates a "aws/request.Request" representing the
// client's request for the GenerateCardValidationData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateCardValidationData for more information on using the GenerateCardValidationData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateCardValidationDataRequest method.
//	req, resp := client.GenerateCardValidationDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GenerateCardValidationData
func (c *PaymentCryptographyData) GenerateCardValidationDataRequest(input *GenerateCardValidationDataInput) (req *request.Request, output *GenerateCardValidationDataOutput) {
	op := &request.Operation{
		Name:       opGenerateCardValidationData,
		HTTPMethod: "POST",
		HTTPPath:   "/cardvalidationdata/generate",
	}

	if input == nil {
		input = &GenerateCardValidationDataInput{}
	}

	output = &GenerateCardValidationDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateCardValidationData API operation for Payment Cryptography Data Plane.
//
// Generates card-related validation data using algorithms such as Card Verification
// Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card
// Security Codes (CSC). For more information, see Generate card data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/generate-card-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// This operation generates a CVV or CSC value that is printed on a payment
// credit or debit card during card production. The CVV or CSC, PAN (Primary
// Account Number) and expiration date of the card are required to check its
// validity during transaction processing. To begin this operation, a CVK (Card
// Verification Key) encryption key is required. You can use CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// or ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
// to establish a CVK within Amazon Web Services Payment Cryptography. The KeyModesOfUse
// should be set to Generate and Verify for a CVK encryption key.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
//   - VerifyCardValidationData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation GenerateCardValidationData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GenerateCardValidationData
func (c *PaymentCryptographyData) GenerateCardValidationData(input *GenerateCardValidationDataInput) (*GenerateCardValidationDataOutput, error) {
	req, out := c.GenerateCardValidationDataRequest(input)
	return out, req.Send()
}

// GenerateCardValidationDataWithContext is the same as GenerateCardValidationData with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateCardValidationData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) GenerateCardValidationDataWithContext(ctx aws.Context, input *GenerateCardValidationDataInput, opts ...request.Option) (*GenerateCardValidationDataOutput, error) {
	req, out := c.GenerateCardValidationDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateMac = "GenerateMac"

// GenerateMacRequest generates a "aws/request.Request" representing the
// client's request for the GenerateMac operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateMac for more information on using the GenerateMac
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GenerateMacRequest method.
//	req, resp := client.GenerateMacRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GenerateMac
func (c *PaymentCryptographyData) GenerateMacRequest(input *GenerateMacInput) (req *request.Request, output *GenerateMacOutput) {
	op := &request.Operation{
		Name:       opGenerateMac,
		HTTPMethod: "POST",
		HTTPPath:   "/mac/generate",
	}

	if input == nil {
		input = &GenerateMacInput{}
	}

	output = &GenerateMacOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateMac API operation for Payment Cryptography Data Plane.
//
// Generates a Message Authentication Code (MAC) cryptogram within Amazon Web
// Services Payment Cryptography.
//
// You can use this operation to authenticate card-related data by using known
// data values to generate MAC for data validation between the sending and receiving
// parties. This operation uses message data, a secret encryption key and MAC
// algorithm to generate a unique MAC value for transmission. The receiving
// party of the MAC must use the same message data, secret encryption key and
// MAC algorithm to reproduce another MAC value for comparision.
//
// You can use this operation to generate a DUPKT, CMAC, HMAC or EMV MAC by
// setting generation attributes and algorithm to the associated values. The
// MAC generation encryption key must have valid values for KeyUsage such as
// TR31_M7_HMAC_KEY for HMAC generation, and they key must have KeyModesOfUse
// set to Generate and Verify.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - VerifyMac
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation GenerateMac for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GenerateMac
func (c *PaymentCryptographyData) GenerateMac(input *GenerateMacInput) (*GenerateMacOutput, error) {
	req, out := c.GenerateMacRequest(input)
	return out, req.Send()
}

// GenerateMacWithContext is the same as GenerateMac with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateMac for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) GenerateMacWithContext(ctx aws.Context, input *GenerateMacInput, opts ...request.Option) (*GenerateMacOutput, error) {
	req, out := c.GenerateMacRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGeneratePinData = "GeneratePinData"

// GeneratePinDataRequest generates a "aws/request.Request" representing the
// client's request for the GeneratePinData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GeneratePinData for more information on using the GeneratePinData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GeneratePinDataRequest method.
//	req, resp := client.GeneratePinDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GeneratePinData
func (c *PaymentCryptographyData) GeneratePinDataRequest(input *GeneratePinDataInput) (req *request.Request, output *GeneratePinDataOutput) {
	op := &request.Operation{
		Name:       opGeneratePinData,
		HTTPMethod: "POST",
		HTTPPath:   "/pindata/generate",
	}

	if input == nil {
		input = &GeneratePinDataInput{}
	}

	output = &GeneratePinDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GeneratePinData API operation for Payment Cryptography Data Plane.
//
// Generates pin-related data such as PIN, PIN Verification Value (PVV), PIN
// Block, and PIN Offset during new card issuance or reissuance. For more information,
// see Generate PIN data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/generate-pin-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// PIN data is never transmitted in clear to or from Amazon Web Services Payment
// Cryptography. This operation generates PIN, PVV, or PIN Offset and then encrypts
// it using Pin Encryption Key (PEK) to create an EncryptedPinBlock for transmission
// from Amazon Web Services Payment Cryptography. This operation uses a separate
// Pin Verification Key (PVK) for VISA PVV generation.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GenerateCardValidationData
//
//   - TranslatePinData
//
//   - VerifyPinData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation GeneratePinData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/GeneratePinData
func (c *PaymentCryptographyData) GeneratePinData(input *GeneratePinDataInput) (*GeneratePinDataOutput, error) {
	req, out := c.GeneratePinDataRequest(input)
	return out, req.Send()
}

// GeneratePinDataWithContext is the same as GeneratePinData with the addition of
// the ability to pass a context and additional request options.
//
// See GeneratePinData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) GeneratePinDataWithContext(ctx aws.Context, input *GeneratePinDataInput, opts ...request.Option) (*GeneratePinDataOutput, error) {
	req, out := c.GeneratePinDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReEncryptData = "ReEncryptData"

// ReEncryptDataRequest generates a "aws/request.Request" representing the
// client's request for the ReEncryptData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReEncryptData for more information on using the ReEncryptData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReEncryptDataRequest method.
//	req, resp := client.ReEncryptDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/ReEncryptData
func (c *PaymentCryptographyData) ReEncryptDataRequest(input *ReEncryptDataInput) (req *request.Request, output *ReEncryptDataOutput) {
	op := &request.Operation{
		Name:       opReEncryptData,
		HTTPMethod: "POST",
		HTTPPath:   "/keys/{IncomingKeyIdentifier}/reencrypt",
	}

	if input == nil {
		input = &ReEncryptDataInput{}
	}

	output = &ReEncryptDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReEncryptData API operation for Payment Cryptography Data Plane.
//
// Re-encrypt ciphertext using DUKPT, Symmetric and Asymmetric Data Encryption
// Keys.
//
// You can either generate an encryption key within Amazon Web Services Payment
// Cryptography by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// or import your own encryption key by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
// The KeyArn for use with this operation must be in a compatible key state
// with KeyModesOfUse set to Encrypt. In asymmetric encryption, ciphertext is
// encrypted using public component (imported by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html))
// of the asymmetric key pair created outside of Amazon Web Services Payment
// Cryptography.
//
// For symmetric and DUKPT encryption, Amazon Web Services Payment Cryptography
// supports TDES and AES algorithms. For asymmetric encryption, Amazon Web Services
// Payment Cryptography supports RSA. To encrypt using DUKPT, a DUKPT key must
// already exist within your account with KeyModesOfUse set to DeriveKey or
// a new DUKPT can be generated by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html).
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - DecryptData
//
//   - EncryptData
//
//   - GetPublicCertificate (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html)
//
//   - ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation ReEncryptData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/ReEncryptData
func (c *PaymentCryptographyData) ReEncryptData(input *ReEncryptDataInput) (*ReEncryptDataOutput, error) {
	req, out := c.ReEncryptDataRequest(input)
	return out, req.Send()
}

// ReEncryptDataWithContext is the same as ReEncryptData with the addition of
// the ability to pass a context and additional request options.
//
// See ReEncryptData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) ReEncryptDataWithContext(ctx aws.Context, input *ReEncryptDataInput, opts ...request.Option) (*ReEncryptDataOutput, error) {
	req, out := c.ReEncryptDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTranslatePinData = "TranslatePinData"

// TranslatePinDataRequest generates a "aws/request.Request" representing the
// client's request for the TranslatePinData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TranslatePinData for more information on using the TranslatePinData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TranslatePinDataRequest method.
//	req, resp := client.TranslatePinDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/TranslatePinData
func (c *PaymentCryptographyData) TranslatePinDataRequest(input *TranslatePinDataInput) (req *request.Request, output *TranslatePinDataOutput) {
	op := &request.Operation{
		Name:       opTranslatePinData,
		HTTPMethod: "POST",
		HTTPPath:   "/pindata/translate",
	}

	if input == nil {
		input = &TranslatePinDataInput{}
	}

	output = &TranslatePinDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TranslatePinData API operation for Payment Cryptography Data Plane.
//
// Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4. For
// more information, see Translate PIN data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/translate-pin-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// PIN block translation involves changing the encrytion of PIN block from one
// encryption key to another encryption key and changing PIN block format from
// one to another without PIN block data leaving Amazon Web Services Payment
// Cryptography. The encryption key transformation can be from PEK (Pin Encryption
// Key) to BDK (Base Derivation Key) for DUKPT or from BDK for DUKPT to PEK.
// Amazon Web Services Payment Cryptography supports TDES and AES key derivation
// type for DUKPT translations.
//
// The allowed combinations of PIN block format translations are guided by PCI.
// It is important to note that not all encrypted PIN block formats (example,
// format 1) require PAN (Primary Account Number) as input. And as such, PIN
// block format that requires PAN (example, formats 0,3,4) cannot be translated
// to a format (format 1) that does not require a PAN for generation.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Amazon Web Services Payment Cryptography currently supports ISO PIN block
// 4 translation for PIN block built using legacy PAN length. That is, PAN is
// the right most 12 digits excluding the check digits.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GeneratePinData
//
//   - VerifyPinData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation TranslatePinData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/TranslatePinData
func (c *PaymentCryptographyData) TranslatePinData(input *TranslatePinDataInput) (*TranslatePinDataOutput, error) {
	req, out := c.TranslatePinDataRequest(input)
	return out, req.Send()
}

// TranslatePinDataWithContext is the same as TranslatePinData with the addition of
// the ability to pass a context and additional request options.
//
// See TranslatePinData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) TranslatePinDataWithContext(ctx aws.Context, input *TranslatePinDataInput, opts ...request.Option) (*TranslatePinDataOutput, error) {
	req, out := c.TranslatePinDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyAuthRequestCryptogram = "VerifyAuthRequestCryptogram"

// VerifyAuthRequestCryptogramRequest generates a "aws/request.Request" representing the
// client's request for the VerifyAuthRequestCryptogram operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyAuthRequestCryptogram for more information on using the VerifyAuthRequestCryptogram
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyAuthRequestCryptogramRequest method.
//	req, resp := client.VerifyAuthRequestCryptogramRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyAuthRequestCryptogram
func (c *PaymentCryptographyData) VerifyAuthRequestCryptogramRequest(input *VerifyAuthRequestCryptogramInput) (req *request.Request, output *VerifyAuthRequestCryptogramOutput) {
	op := &request.Operation{
		Name:       opVerifyAuthRequestCryptogram,
		HTTPMethod: "POST",
		HTTPPath:   "/cryptogram/verify",
	}

	if input == nil {
		input = &VerifyAuthRequestCryptogramInput{}
	}

	output = &VerifyAuthRequestCryptogramOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyAuthRequestCryptogram API operation for Payment Cryptography Data Plane.
//
// Verifies Authorization Request Cryptogram (ARQC) for a EMV chip payment card
// authorization. For more information, see Verify auth request cryptogram (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/data-operations.verifyauthrequestcryptogram.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// ARQC generation is done outside of Amazon Web Services Payment Cryptography
// and is typically generated on a point of sale terminal for an EMV chip card
// to obtain payment authorization during transaction time. For ARQC verification,
// you must first import the ARQC generated outside of Amazon Web Services Payment
// Cryptography by calling ImportKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html).
// This operation uses the imported ARQC and an major encryption key (DUKPT)
// created by calling CreateKey (https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html)
// to either provide a boolean ARQC verification result or provide an APRC (Authorization
// Response Cryptogram) response using Method 1 or Method 2. The ARPC_METHOD_1
// uses AuthResponseCode to generate ARPC and ARPC_METHOD_2 uses CardStatusUpdate
// to generate ARPC.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - VerifyCardValidationData
//
//   - VerifyPinData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation VerifyAuthRequestCryptogram for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - VerificationFailedException
//     This request failed verification.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyAuthRequestCryptogram
func (c *PaymentCryptographyData) VerifyAuthRequestCryptogram(input *VerifyAuthRequestCryptogramInput) (*VerifyAuthRequestCryptogramOutput, error) {
	req, out := c.VerifyAuthRequestCryptogramRequest(input)
	return out, req.Send()
}

// VerifyAuthRequestCryptogramWithContext is the same as VerifyAuthRequestCryptogram with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyAuthRequestCryptogram for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) VerifyAuthRequestCryptogramWithContext(ctx aws.Context, input *VerifyAuthRequestCryptogramInput, opts ...request.Option) (*VerifyAuthRequestCryptogramOutput, error) {
	req, out := c.VerifyAuthRequestCryptogramRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyCardValidationData = "VerifyCardValidationData"

// VerifyCardValidationDataRequest generates a "aws/request.Request" representing the
// client's request for the VerifyCardValidationData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyCardValidationData for more information on using the VerifyCardValidationData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyCardValidationDataRequest method.
//	req, resp := client.VerifyCardValidationDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyCardValidationData
func (c *PaymentCryptographyData) VerifyCardValidationDataRequest(input *VerifyCardValidationDataInput) (req *request.Request, output *VerifyCardValidationDataOutput) {
	op := &request.Operation{
		Name:       opVerifyCardValidationData,
		HTTPMethod: "POST",
		HTTPPath:   "/cardvalidationdata/verify",
	}

	if input == nil {
		input = &VerifyCardValidationDataInput{}
	}

	output = &VerifyCardValidationDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyCardValidationData API operation for Payment Cryptography Data Plane.
//
// Verifies card-related validation data using algorithms such as Card Verification
// Values (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2) and Card
// Security Codes (CSC). For more information, see Verify card data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/verify-card-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// This operation validates the CVV or CSC codes that is printed on a payment
// credit or debit card during card payment transaction. The input values are
// typically provided as part of an inbound transaction to an issuer or supporting
// platform partner. Amazon Web Services Payment Cryptography uses CVV or CSC,
// PAN (Primary Account Number) and expiration date of the card to check its
// validity during transaction processing. In this operation, the CVK (Card
// Verification Key) encryption key for use with card data verification is same
// as the one in used for GenerateCardValidationData.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GenerateCardValidationData
//
//   - VerifyAuthRequestCryptogram
//
//   - VerifyPinData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation VerifyCardValidationData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - VerificationFailedException
//     This request failed verification.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyCardValidationData
func (c *PaymentCryptographyData) VerifyCardValidationData(input *VerifyCardValidationDataInput) (*VerifyCardValidationDataOutput, error) {
	req, out := c.VerifyCardValidationDataRequest(input)
	return out, req.Send()
}

// VerifyCardValidationDataWithContext is the same as VerifyCardValidationData with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyCardValidationData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) VerifyCardValidationDataWithContext(ctx aws.Context, input *VerifyCardValidationDataInput, opts ...request.Option) (*VerifyCardValidationDataOutput, error) {
	req, out := c.VerifyCardValidationDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyMac = "VerifyMac"

// VerifyMacRequest generates a "aws/request.Request" representing the
// client's request for the VerifyMac operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyMac for more information on using the VerifyMac
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyMacRequest method.
//	req, resp := client.VerifyMacRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyMac
func (c *PaymentCryptographyData) VerifyMacRequest(input *VerifyMacInput) (req *request.Request, output *VerifyMacOutput) {
	op := &request.Operation{
		Name:       opVerifyMac,
		HTTPMethod: "POST",
		HTTPPath:   "/mac/verify",
	}

	if input == nil {
		input = &VerifyMacInput{}
	}

	output = &VerifyMacOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyMac API operation for Payment Cryptography Data Plane.
//
// Verifies a Message Authentication Code (MAC).
//
// You can use this operation to verify MAC for message data authentication
// such as . In this operation, you must use the same message data, secret encryption
// key and MAC algorithm that was used to generate MAC. You can use this operation
// to verify a DUPKT, CMAC, HMAC or EMV MAC by setting generation attributes
// and algorithm to the associated values.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GenerateMac
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation VerifyMac for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - VerificationFailedException
//     This request failed verification.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyMac
func (c *PaymentCryptographyData) VerifyMac(input *VerifyMacInput) (*VerifyMacOutput, error) {
	req, out := c.VerifyMacRequest(input)
	return out, req.Send()
}

// VerifyMacWithContext is the same as VerifyMac with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyMac for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) VerifyMacWithContext(ctx aws.Context, input *VerifyMacInput, opts ...request.Option) (*VerifyMacOutput, error) {
	req, out := c.VerifyMacRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyPinData = "VerifyPinData"

// VerifyPinDataRequest generates a "aws/request.Request" representing the
// client's request for the VerifyPinData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyPinData for more information on using the VerifyPinData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the VerifyPinDataRequest method.
//	req, resp := client.VerifyPinDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyPinData
func (c *PaymentCryptographyData) VerifyPinDataRequest(input *VerifyPinDataInput) (req *request.Request, output *VerifyPinDataOutput) {
	op := &request.Operation{
		Name:       opVerifyPinData,
		HTTPMethod: "POST",
		HTTPPath:   "/pindata/verify",
	}

	if input == nil {
		input = &VerifyPinDataInput{}
	}

	output = &VerifyPinDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyPinData API operation for Payment Cryptography Data Plane.
//
// Verifies pin-related data such as PIN and PIN Offset using algorithms including
// VISA PVV and IBM3624. For more information, see Verify PIN data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/verify-pin-data.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// This operation verifies PIN data for user payment card. A card holder PIN
// data is never transmitted in clear to or from Amazon Web Services Payment
// Cryptography. This operation uses PIN Verification Key (PVK) for PIN or PIN
// Offset generation and then encrypts it using PIN Encryption Key (PEK) to
// create an EncryptedPinBlock for transmission from Amazon Web Services Payment
// Cryptography.
//
// For information about valid keys for this operation, see Understanding key
// attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
//   - GeneratePinData
//
//   - TranslatePinData
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Payment Cryptography Data Plane's
// API operation VerifyPinData for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request was denied due to an invalid request error.
//
//   - VerificationFailedException
//     This request failed verification.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The request was denied due to an invalid resource error.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/payment-cryptography-data-2022-02-03/VerifyPinData
func (c *PaymentCryptographyData) VerifyPinData(input *VerifyPinDataInput) (*VerifyPinDataOutput, error) {
	req, out := c.VerifyPinDataRequest(input)
	return out, req.Send()
}

// VerifyPinDataWithContext is the same as VerifyPinData with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyPinData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PaymentCryptographyData) VerifyPinDataWithContext(ctx aws.Context, input *VerifyPinDataInput, opts ...request.Option) (*VerifyPinDataOutput, error) {
	req, out := c.VerifyPinDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type AmexCardSecurityCodeVersion1 struct {
	_ struct{} `type:"structure"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmexCardSecurityCodeVersion1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmexCardSecurityCodeVersion1) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmexCardSecurityCodeVersion1) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmexCardSecurityCodeVersion1"}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *AmexCardSecurityCodeVersion1) SetCardExpiryDate(v string) *AmexCardSecurityCodeVersion1 {
	s.CardExpiryDate = &v
	return s
}

// Card data parameters that are required to generate a Card Security Code (CSC2)
// for an AMEX payment card.
type AmexCardSecurityCodeVersion2 struct {
	_ struct{} `type:"structure"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`

	// The service code of the AMEX payment card. This is different from the Card
	// Security Code (CSC).
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmexCardSecurityCodeVersion2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmexCardSecurityCodeVersion2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmexCardSecurityCodeVersion2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmexCardSecurityCodeVersion2"}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *AmexCardSecurityCodeVersion2) SetCardExpiryDate(v string) *AmexCardSecurityCodeVersion2 {
	s.CardExpiryDate = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *AmexCardSecurityCodeVersion2) SetServiceCode(v string) *AmexCardSecurityCodeVersion2 {
	s.ServiceCode = &v
	return s
}

// Parameters for plaintext encryption using asymmetric keys.
type AsymmetricEncryptionAttributes struct {
	_ struct{} `type:"structure"`

	// The padding to be included with the data.
	PaddingType *string `type:"string" enum:"PaddingType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsymmetricEncryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AsymmetricEncryptionAttributes) GoString() string {
	return s.String()
}

// SetPaddingType sets the PaddingType field's value.
func (s *AsymmetricEncryptionAttributes) SetPaddingType(v string) *AsymmetricEncryptionAttributes {
	s.PaddingType = &v
	return s
}

// Card data parameters that are required to generate Card Verification Values
// (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security
// Codes (CSC).
type CardGenerationAttributes struct {
	_ struct{} `type:"structure"`

	// Card data parameters that are required to generate a Card Security Code (CSC2)
	// for an AMEX payment card.
	AmexCardSecurityCodeVersion1 *AmexCardSecurityCodeVersion1 `type:"structure"`

	// Card data parameters that are required to generate a Card Security Code (CSC2)
	// for an AMEX payment card.
	AmexCardSecurityCodeVersion2 *AmexCardSecurityCodeVersion2 `type:"structure"`

	// Card data parameters that are required to generate a cardholder verification
	// value for the payment card.
	CardHolderVerificationValue *CardHolderVerificationValue `type:"structure"`

	// Card data parameters that are required to generate Card Verification Value
	// (CVV) for the payment card.
	CardVerificationValue1 *CardVerificationValue1 `type:"structure"`

	// Card data parameters that are required to generate Card Verification Value
	// (CVV2) for the payment card.
	CardVerificationValue2 *CardVerificationValue2 `type:"structure"`

	// Card data parameters that are required to generate CDynamic Card Verification
	// Code (dCVC) for the payment card.
	DynamicCardVerificationCode *DynamicCardVerificationCode `type:"structure"`

	// Card data parameters that are required to generate CDynamic Card Verification
	// Value (dCVV) for the payment card.
	DynamicCardVerificationValue *DynamicCardVerificationValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardGenerationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardGenerationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardGenerationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardGenerationAttributes"}
	if s.AmexCardSecurityCodeVersion1 != nil {
		if err := s.AmexCardSecurityCodeVersion1.Validate(); err != nil {
			invalidParams.AddNested("AmexCardSecurityCodeVersion1", err.(request.ErrInvalidParams))
		}
	}
	if s.AmexCardSecurityCodeVersion2 != nil {
		if err := s.AmexCardSecurityCodeVersion2.Validate(); err != nil {
			invalidParams.AddNested("AmexCardSecurityCodeVersion2", err.(request.ErrInvalidParams))
		}
	}
	if s.CardHolderVerificationValue != nil {
		if err := s.CardHolderVerificationValue.Validate(); err != nil {
			invalidParams.AddNested("CardHolderVerificationValue", err.(request.ErrInvalidParams))
		}
	}
	if s.CardVerificationValue1 != nil {
		if err := s.CardVerificationValue1.Validate(); err != nil {
			invalidParams.AddNested("CardVerificationValue1", err.(request.ErrInvalidParams))
		}
	}
	if s.CardVerificationValue2 != nil {
		if err := s.CardVerificationValue2.Validate(); err != nil {
			invalidParams.AddNested("CardVerificationValue2", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamicCardVerificationCode != nil {
		if err := s.DynamicCardVerificationCode.Validate(); err != nil {
			invalidParams.AddNested("DynamicCardVerificationCode", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamicCardVerificationValue != nil {
		if err := s.DynamicCardVerificationValue.Validate(); err != nil {
			invalidParams.AddNested("DynamicCardVerificationValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmexCardSecurityCodeVersion1 sets the AmexCardSecurityCodeVersion1 field's value.
func (s *CardGenerationAttributes) SetAmexCardSecurityCodeVersion1(v *AmexCardSecurityCodeVersion1) *CardGenerationAttributes {
	s.AmexCardSecurityCodeVersion1 = v
	return s
}

// SetAmexCardSecurityCodeVersion2 sets the AmexCardSecurityCodeVersion2 field's value.
func (s *CardGenerationAttributes) SetAmexCardSecurityCodeVersion2(v *AmexCardSecurityCodeVersion2) *CardGenerationAttributes {
	s.AmexCardSecurityCodeVersion2 = v
	return s
}

// SetCardHolderVerificationValue sets the CardHolderVerificationValue field's value.
func (s *CardGenerationAttributes) SetCardHolderVerificationValue(v *CardHolderVerificationValue) *CardGenerationAttributes {
	s.CardHolderVerificationValue = v
	return s
}

// SetCardVerificationValue1 sets the CardVerificationValue1 field's value.
func (s *CardGenerationAttributes) SetCardVerificationValue1(v *CardVerificationValue1) *CardGenerationAttributes {
	s.CardVerificationValue1 = v
	return s
}

// SetCardVerificationValue2 sets the CardVerificationValue2 field's value.
func (s *CardGenerationAttributes) SetCardVerificationValue2(v *CardVerificationValue2) *CardGenerationAttributes {
	s.CardVerificationValue2 = v
	return s
}

// SetDynamicCardVerificationCode sets the DynamicCardVerificationCode field's value.
func (s *CardGenerationAttributes) SetDynamicCardVerificationCode(v *DynamicCardVerificationCode) *CardGenerationAttributes {
	s.DynamicCardVerificationCode = v
	return s
}

// SetDynamicCardVerificationValue sets the DynamicCardVerificationValue field's value.
func (s *CardGenerationAttributes) SetDynamicCardVerificationValue(v *DynamicCardVerificationValue) *CardGenerationAttributes {
	s.DynamicCardVerificationValue = v
	return s
}

// Card data parameters that are required to generate a cardholder verification
// value for the payment card.
type CardHolderVerificationValue struct {
	_ struct{} `type:"structure"`

	// The transaction counter value that comes from a point of sale terminal.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// A random number generated by the issuer.
	//
	// UnpredictableNumber is a required field
	UnpredictableNumber *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardHolderVerificationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardHolderVerificationValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardHolderVerificationValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardHolderVerificationValue"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.UnpredictableNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("UnpredictableNumber"))
	}
	if s.UnpredictableNumber != nil && len(*s.UnpredictableNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnpredictableNumber", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *CardHolderVerificationValue) SetApplicationTransactionCounter(v string) *CardHolderVerificationValue {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *CardHolderVerificationValue) SetPanSequenceNumber(v string) *CardHolderVerificationValue {
	s.PanSequenceNumber = &v
	return s
}

// SetUnpredictableNumber sets the UnpredictableNumber field's value.
func (s *CardHolderVerificationValue) SetUnpredictableNumber(v string) *CardHolderVerificationValue {
	s.UnpredictableNumber = &v
	return s
}

// Card data parameters that are requried to verify Card Verification Values
// (CVV/CVV2), Dynamic Card Verification Values (dCVV/dCVV2), or Card Security
// Codes (CSC).
type CardVerificationAttributes struct {
	_ struct{} `type:"structure"`

	// Card data parameters that are required to generate a Card Security Code (CSC2)
	// for an AMEX payment card.
	AmexCardSecurityCodeVersion1 *AmexCardSecurityCodeVersion1 `type:"structure"`

	// Card data parameters that are required to verify a Card Security Code (CSC2)
	// for an AMEX payment card.
	AmexCardSecurityCodeVersion2 *AmexCardSecurityCodeVersion2 `type:"structure"`

	// Card data parameters that are required to verify a cardholder verification
	// value for the payment card.
	CardHolderVerificationValue *CardHolderVerificationValue `type:"structure"`

	// Card data parameters that are required to verify Card Verification Value
	// (CVV) for the payment card.
	CardVerificationValue1 *CardVerificationValue1 `type:"structure"`

	// Card data parameters that are required to verify Card Verification Value
	// (CVV2) for the payment card.
	CardVerificationValue2 *CardVerificationValue2 `type:"structure"`

	// Card data parameters that are required to verify CDynamic Card Verification
	// Code (dCVC) for the payment card.
	DiscoverDynamicCardVerificationCode *DiscoverDynamicCardVerificationCode `type:"structure"`

	// Card data parameters that are required to verify CDynamic Card Verification
	// Code (dCVC) for the payment card.
	DynamicCardVerificationCode *DynamicCardVerificationCode `type:"structure"`

	// Card data parameters that are required to verify CDynamic Card Verification
	// Value (dCVV) for the payment card.
	DynamicCardVerificationValue *DynamicCardVerificationValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardVerificationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardVerificationAttributes"}
	if s.AmexCardSecurityCodeVersion1 != nil {
		if err := s.AmexCardSecurityCodeVersion1.Validate(); err != nil {
			invalidParams.AddNested("AmexCardSecurityCodeVersion1", err.(request.ErrInvalidParams))
		}
	}
	if s.AmexCardSecurityCodeVersion2 != nil {
		if err := s.AmexCardSecurityCodeVersion2.Validate(); err != nil {
			invalidParams.AddNested("AmexCardSecurityCodeVersion2", err.(request.ErrInvalidParams))
		}
	}
	if s.CardHolderVerificationValue != nil {
		if err := s.CardHolderVerificationValue.Validate(); err != nil {
			invalidParams.AddNested("CardHolderVerificationValue", err.(request.ErrInvalidParams))
		}
	}
	if s.CardVerificationValue1 != nil {
		if err := s.CardVerificationValue1.Validate(); err != nil {
			invalidParams.AddNested("CardVerificationValue1", err.(request.ErrInvalidParams))
		}
	}
	if s.CardVerificationValue2 != nil {
		if err := s.CardVerificationValue2.Validate(); err != nil {
			invalidParams.AddNested("CardVerificationValue2", err.(request.ErrInvalidParams))
		}
	}
	if s.DiscoverDynamicCardVerificationCode != nil {
		if err := s.DiscoverDynamicCardVerificationCode.Validate(); err != nil {
			invalidParams.AddNested("DiscoverDynamicCardVerificationCode", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamicCardVerificationCode != nil {
		if err := s.DynamicCardVerificationCode.Validate(); err != nil {
			invalidParams.AddNested("DynamicCardVerificationCode", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamicCardVerificationValue != nil {
		if err := s.DynamicCardVerificationValue.Validate(); err != nil {
			invalidParams.AddNested("DynamicCardVerificationValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmexCardSecurityCodeVersion1 sets the AmexCardSecurityCodeVersion1 field's value.
func (s *CardVerificationAttributes) SetAmexCardSecurityCodeVersion1(v *AmexCardSecurityCodeVersion1) *CardVerificationAttributes {
	s.AmexCardSecurityCodeVersion1 = v
	return s
}

// SetAmexCardSecurityCodeVersion2 sets the AmexCardSecurityCodeVersion2 field's value.
func (s *CardVerificationAttributes) SetAmexCardSecurityCodeVersion2(v *AmexCardSecurityCodeVersion2) *CardVerificationAttributes {
	s.AmexCardSecurityCodeVersion2 = v
	return s
}

// SetCardHolderVerificationValue sets the CardHolderVerificationValue field's value.
func (s *CardVerificationAttributes) SetCardHolderVerificationValue(v *CardHolderVerificationValue) *CardVerificationAttributes {
	s.CardHolderVerificationValue = v
	return s
}

// SetCardVerificationValue1 sets the CardVerificationValue1 field's value.
func (s *CardVerificationAttributes) SetCardVerificationValue1(v *CardVerificationValue1) *CardVerificationAttributes {
	s.CardVerificationValue1 = v
	return s
}

// SetCardVerificationValue2 sets the CardVerificationValue2 field's value.
func (s *CardVerificationAttributes) SetCardVerificationValue2(v *CardVerificationValue2) *CardVerificationAttributes {
	s.CardVerificationValue2 = v
	return s
}

// SetDiscoverDynamicCardVerificationCode sets the DiscoverDynamicCardVerificationCode field's value.
func (s *CardVerificationAttributes) SetDiscoverDynamicCardVerificationCode(v *DiscoverDynamicCardVerificationCode) *CardVerificationAttributes {
	s.DiscoverDynamicCardVerificationCode = v
	return s
}

// SetDynamicCardVerificationCode sets the DynamicCardVerificationCode field's value.
func (s *CardVerificationAttributes) SetDynamicCardVerificationCode(v *DynamicCardVerificationCode) *CardVerificationAttributes {
	s.DynamicCardVerificationCode = v
	return s
}

// SetDynamicCardVerificationValue sets the DynamicCardVerificationValue field's value.
func (s *CardVerificationAttributes) SetDynamicCardVerificationValue(v *DynamicCardVerificationValue) *CardVerificationAttributes {
	s.DynamicCardVerificationValue = v
	return s
}

// Card data parameters that are required to verify CVV (Card Verification Value)
// for the payment card.
type CardVerificationValue1 struct {
	_ struct{} `type:"structure"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`

	// The service code of the payment card. This is different from Card Security
	// Code (CSC).
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationValue1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationValue1) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardVerificationValue1) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardVerificationValue1"}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *CardVerificationValue1) SetCardExpiryDate(v string) *CardVerificationValue1 {
	s.CardExpiryDate = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *CardVerificationValue1) SetServiceCode(v string) *CardVerificationValue1 {
	s.ServiceCode = &v
	return s
}

// Card data parameters that are required to verify Card Verification Value
// (CVV2) for the payment card.
type CardVerificationValue2 struct {
	_ struct{} `type:"structure"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationValue2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CardVerificationValue2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CardVerificationValue2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CardVerificationValue2"}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *CardVerificationValue2) SetCardExpiryDate(v string) *CardVerificationValue2 {
	s.CardExpiryDate = &v
	return s
}

// Parameters that are required for Authorization Response Cryptogram (ARPC)
// generation after Authorization Request Cryptogram (ARQC) verification is
// successful.
type CryptogramAuthResponse struct {
	_ struct{} `type:"structure"`

	// Parameters that are required for ARPC response generation using method1 after
	// ARQC verification is successful.
	ArpcMethod1 *CryptogramVerificationArpcMethod1 `type:"structure"`

	// Parameters that are required for ARPC response generation using method2 after
	// ARQC verification is successful.
	ArpcMethod2 *CryptogramVerificationArpcMethod2 `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramAuthResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramAuthResponse) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CryptogramAuthResponse) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CryptogramAuthResponse"}
	if s.ArpcMethod1 != nil {
		if err := s.ArpcMethod1.Validate(); err != nil {
			invalidParams.AddNested("ArpcMethod1", err.(request.ErrInvalidParams))
		}
	}
	if s.ArpcMethod2 != nil {
		if err := s.ArpcMethod2.Validate(); err != nil {
			invalidParams.AddNested("ArpcMethod2", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArpcMethod1 sets the ArpcMethod1 field's value.
func (s *CryptogramAuthResponse) SetArpcMethod1(v *CryptogramVerificationArpcMethod1) *CryptogramAuthResponse {
	s.ArpcMethod1 = v
	return s
}

// SetArpcMethod2 sets the ArpcMethod2 field's value.
func (s *CryptogramAuthResponse) SetArpcMethod2(v *CryptogramVerificationArpcMethod2) *CryptogramAuthResponse {
	s.ArpcMethod2 = v
	return s
}

// Parameters that are required for ARPC response generation using method1 after
// ARQC verification is successful.
type CryptogramVerificationArpcMethod1 struct {
	_ struct{} `type:"structure"`

	// The auth code used to calculate APRC after ARQC verification is successful.
	// This is the same auth code used for ARQC generation outside of Amazon Web
	// Services Payment Cryptography.
	//
	// AuthResponseCode is a required field
	AuthResponseCode *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramVerificationArpcMethod1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramVerificationArpcMethod1) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CryptogramVerificationArpcMethod1) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CryptogramVerificationArpcMethod1"}
	if s.AuthResponseCode == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthResponseCode"))
	}
	if s.AuthResponseCode != nil && len(*s.AuthResponseCode) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("AuthResponseCode", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthResponseCode sets the AuthResponseCode field's value.
func (s *CryptogramVerificationArpcMethod1) SetAuthResponseCode(v string) *CryptogramVerificationArpcMethod1 {
	s.AuthResponseCode = &v
	return s
}

// Parameters that are required for ARPC response generation using method2 after
// ARQC verification is successful.
type CryptogramVerificationArpcMethod2 struct {
	_ struct{} `type:"structure"`

	// The data indicating whether the issuer approves or declines an online transaction
	// using an EMV chip card.
	//
	// CardStatusUpdate is a required field
	CardStatusUpdate *string `min:"8" type:"string" required:"true"`

	// The proprietary authentication data used by issuer for communication during
	// online transaction using an EMV chip card.
	ProprietaryAuthenticationData *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramVerificationArpcMethod2) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CryptogramVerificationArpcMethod2) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CryptogramVerificationArpcMethod2) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CryptogramVerificationArpcMethod2"}
	if s.CardStatusUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardStatusUpdate"))
	}
	if s.CardStatusUpdate != nil && len(*s.CardStatusUpdate) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("CardStatusUpdate", 8))
	}
	if s.ProprietaryAuthenticationData != nil && len(*s.ProprietaryAuthenticationData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProprietaryAuthenticationData", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCardStatusUpdate sets the CardStatusUpdate field's value.
func (s *CryptogramVerificationArpcMethod2) SetCardStatusUpdate(v string) *CryptogramVerificationArpcMethod2 {
	s.CardStatusUpdate = &v
	return s
}

// SetProprietaryAuthenticationData sets the ProprietaryAuthenticationData field's value.
func (s *CryptogramVerificationArpcMethod2) SetProprietaryAuthenticationData(v string) *CryptogramVerificationArpcMethod2 {
	s.ProprietaryAuthenticationData = &v
	return s
}

type DecryptDataInput struct {
	_ struct{} `type:"structure"`

	// The ciphertext to decrypt.
	//
	// CipherText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DecryptDataInput's
	// String and GoString methods.
	//
	// CipherText is a required field
	CipherText *string `min:"16" type:"string" required:"true" sensitive:"true"`

	// The encryption key type and attributes for ciphertext decryption.
	//
	// DecryptionAttributes is a required field
	DecryptionAttributes *EncryptionDecryptionAttributes `type:"structure" required:"true"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for ciphertext decryption.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `location:"uri" locationName:"KeyIdentifier" min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecryptDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecryptDataInput"}
	if s.CipherText == nil {
		invalidParams.Add(request.NewErrParamRequired("CipherText"))
	}
	if s.CipherText != nil && len(*s.CipherText) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("CipherText", 16))
	}
	if s.DecryptionAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("DecryptionAttributes"))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.DecryptionAttributes != nil {
		if err := s.DecryptionAttributes.Validate(); err != nil {
			invalidParams.AddNested("DecryptionAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCipherText sets the CipherText field's value.
func (s *DecryptDataInput) SetCipherText(v string) *DecryptDataInput {
	s.CipherText = &v
	return s
}

// SetDecryptionAttributes sets the DecryptionAttributes field's value.
func (s *DecryptDataInput) SetDecryptionAttributes(v *EncryptionDecryptionAttributes) *DecryptDataInput {
	s.DecryptionAttributes = v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *DecryptDataInput) SetKeyIdentifier(v string) *DecryptDataInput {
	s.KeyIdentifier = &v
	return s
}

type DecryptDataOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for ciphertext decryption.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The decrypted plaintext data in hexBinary format.
	//
	// PlainText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DecryptDataOutput's
	// String and GoString methods.
	//
	// PlainText is a required field
	PlainText *string `min:"16" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DecryptDataOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *DecryptDataOutput) SetKeyArn(v string) *DecryptDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *DecryptDataOutput) SetKeyCheckValue(v string) *DecryptDataOutput {
	s.KeyCheckValue = &v
	return s
}

// SetPlainText sets the PlainText field's value.
func (s *DecryptDataOutput) SetPlainText(v string) *DecryptDataOutput {
	s.PlainText = &v
	return s
}

// Parameters that are required to generate or verify dCVC (Dynamic Card Verification
// Code).
type DiscoverDynamicCardVerificationCode struct {
	_ struct{} `type:"structure"`

	// The transaction counter value that comes from the terminal.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`

	// A random number that is generated by the issuer.
	//
	// UnpredictableNumber is a required field
	UnpredictableNumber *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverDynamicCardVerificationCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DiscoverDynamicCardVerificationCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverDynamicCardVerificationCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoverDynamicCardVerificationCode"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}
	if s.UnpredictableNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("UnpredictableNumber"))
	}
	if s.UnpredictableNumber != nil && len(*s.UnpredictableNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnpredictableNumber", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *DiscoverDynamicCardVerificationCode) SetApplicationTransactionCounter(v string) *DiscoverDynamicCardVerificationCode {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *DiscoverDynamicCardVerificationCode) SetCardExpiryDate(v string) *DiscoverDynamicCardVerificationCode {
	s.CardExpiryDate = &v
	return s
}

// SetUnpredictableNumber sets the UnpredictableNumber field's value.
func (s *DiscoverDynamicCardVerificationCode) SetUnpredictableNumber(v string) *DiscoverDynamicCardVerificationCode {
	s.UnpredictableNumber = &v
	return s
}

// Parameters that are used for Derived Unique Key Per Transaction (DUKPT) derivation
// algorithm.
type DukptAttributes struct {
	_ struct{} `type:"structure"`

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the
	// BDK. For example, you can't use AES_128 as a derivation type for a BDK of
	// AES_128 or TDES_2KEY.
	//
	// DukptDerivationType is a required field
	DukptDerivationType *string `type:"string" required:"true" enum:"DukptDerivationType"`

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from
	// the encrypting device unique identifier and an internal transaction counter.
	//
	// KeySerialNumber is a required field
	KeySerialNumber *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DukptAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DukptAttributes"}
	if s.DukptDerivationType == nil {
		invalidParams.Add(request.NewErrParamRequired("DukptDerivationType"))
	}
	if s.KeySerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySerialNumber"))
	}
	if s.KeySerialNumber != nil && len(*s.KeySerialNumber) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("KeySerialNumber", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukptDerivationType sets the DukptDerivationType field's value.
func (s *DukptAttributes) SetDukptDerivationType(v string) *DukptAttributes {
	s.DukptDerivationType = &v
	return s
}

// SetKeySerialNumber sets the KeySerialNumber field's value.
func (s *DukptAttributes) SetKeySerialNumber(v string) *DukptAttributes {
	s.KeySerialNumber = &v
	return s
}

// Parameters required for encryption or decryption of data using DUKPT.
type DukptDerivationAttributes struct {
	_ struct{} `type:"structure"`

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the
	// BDK. For example, you can't use AES_128 as a derivation type for a BDK of
	// AES_128 or TDES_2KEY
	DukptKeyDerivationType *string `type:"string" enum:"DukptDerivationType"`

	// The type of use of DUKPT, which can be for incoming data decryption, outgoing
	// data encryption, or both.
	DukptKeyVariant *string `type:"string" enum:"DukptKeyVariant"`

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from
	// the encrypting device unique identifier and an internal transaction counter.
	//
	// KeySerialNumber is a required field
	KeySerialNumber *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptDerivationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptDerivationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DukptDerivationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DukptDerivationAttributes"}
	if s.KeySerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySerialNumber"))
	}
	if s.KeySerialNumber != nil && len(*s.KeySerialNumber) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("KeySerialNumber", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukptKeyDerivationType sets the DukptKeyDerivationType field's value.
func (s *DukptDerivationAttributes) SetDukptKeyDerivationType(v string) *DukptDerivationAttributes {
	s.DukptKeyDerivationType = &v
	return s
}

// SetDukptKeyVariant sets the DukptKeyVariant field's value.
func (s *DukptDerivationAttributes) SetDukptKeyVariant(v string) *DukptDerivationAttributes {
	s.DukptKeyVariant = &v
	return s
}

// SetKeySerialNumber sets the KeySerialNumber field's value.
func (s *DukptDerivationAttributes) SetKeySerialNumber(v string) *DukptDerivationAttributes {
	s.KeySerialNumber = &v
	return s
}

// Parameters that are required to encrypt plaintext data using DUKPT.
type DukptEncryptionAttributes struct {
	_ struct{} `type:"structure"`

	// The key type encrypted using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the
	// BDK. For example, you can't use AES_128 as a derivation type for a BDK of
	// AES_128 or TDES_2KEY
	DukptKeyDerivationType *string `type:"string" enum:"DukptDerivationType"`

	// The type of use of DUKPT, which can be incoming data decryption, outgoing
	// data encryption, or both.
	DukptKeyVariant *string `type:"string" enum:"DukptKeyVariant"`

	// An input used to provide the intial state. If no value is provided, Amazon
	// Web Services Payment Cryptography defaults it to zero.
	//
	// InitializationVector is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DukptEncryptionAttributes's
	// String and GoString methods.
	InitializationVector *string `min:"16" type:"string" sensitive:"true"`

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from
	// the encrypting device unique identifier and an internal transaction counter.
	//
	// KeySerialNumber is a required field
	KeySerialNumber *string `min:"10" type:"string" required:"true"`

	// The block cipher method to use for encryption.
	//
	// The default is CBC.
	Mode *string `type:"string" enum:"DukptEncryptionMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptEncryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DukptEncryptionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DukptEncryptionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DukptEncryptionAttributes"}
	if s.InitializationVector != nil && len(*s.InitializationVector) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("InitializationVector", 16))
	}
	if s.KeySerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySerialNumber"))
	}
	if s.KeySerialNumber != nil && len(*s.KeySerialNumber) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("KeySerialNumber", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukptKeyDerivationType sets the DukptKeyDerivationType field's value.
func (s *DukptEncryptionAttributes) SetDukptKeyDerivationType(v string) *DukptEncryptionAttributes {
	s.DukptKeyDerivationType = &v
	return s
}

// SetDukptKeyVariant sets the DukptKeyVariant field's value.
func (s *DukptEncryptionAttributes) SetDukptKeyVariant(v string) *DukptEncryptionAttributes {
	s.DukptKeyVariant = &v
	return s
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *DukptEncryptionAttributes) SetInitializationVector(v string) *DukptEncryptionAttributes {
	s.InitializationVector = &v
	return s
}

// SetKeySerialNumber sets the KeySerialNumber field's value.
func (s *DukptEncryptionAttributes) SetKeySerialNumber(v string) *DukptEncryptionAttributes {
	s.KeySerialNumber = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *DukptEncryptionAttributes) SetMode(v string) *DukptEncryptionAttributes {
	s.Mode = &v
	return s
}

// Parameters that are required to generate or verify Dynamic Card Verification
// Value (dCVV).
type DynamicCardVerificationCode struct {
	_ struct{} `type:"structure"`

	// The transaction counter value that comes from the terminal.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The data on the two tracks of magnetic cards used for financial transactions.
	// This includes the cardholder name, PAN, expiration date, bank ID (BIN) and
	// several other numbers the issuing bank uses to validate the data received.
	//
	// TrackData is a required field
	TrackData *string `min:"2" type:"string" required:"true"`

	// A random number generated by the issuer.
	//
	// UnpredictableNumber is a required field
	UnpredictableNumber *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicCardVerificationCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicCardVerificationCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamicCardVerificationCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamicCardVerificationCode"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.TrackData == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackData"))
	}
	if s.TrackData != nil && len(*s.TrackData) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TrackData", 2))
	}
	if s.UnpredictableNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("UnpredictableNumber"))
	}
	if s.UnpredictableNumber != nil && len(*s.UnpredictableNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnpredictableNumber", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *DynamicCardVerificationCode) SetApplicationTransactionCounter(v string) *DynamicCardVerificationCode {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *DynamicCardVerificationCode) SetPanSequenceNumber(v string) *DynamicCardVerificationCode {
	s.PanSequenceNumber = &v
	return s
}

// SetTrackData sets the TrackData field's value.
func (s *DynamicCardVerificationCode) SetTrackData(v string) *DynamicCardVerificationCode {
	s.TrackData = &v
	return s
}

// SetUnpredictableNumber sets the UnpredictableNumber field's value.
func (s *DynamicCardVerificationCode) SetUnpredictableNumber(v string) *DynamicCardVerificationCode {
	s.UnpredictableNumber = &v
	return s
}

// Parameters that are required to generate or verify Dynamic Card Verification
// Value (dCVV).
type DynamicCardVerificationValue struct {
	_ struct{} `type:"structure"`

	// The transaction counter value that comes from the terminal.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// The expiry date of a payment card.
	//
	// CardExpiryDate is a required field
	CardExpiryDate *string `min:"4" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The service code of the payment card. This is different from Card Security
	// Code (CSC).
	//
	// ServiceCode is a required field
	ServiceCode *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicCardVerificationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicCardVerificationValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamicCardVerificationValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamicCardVerificationValue"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.CardExpiryDate == nil {
		invalidParams.Add(request.NewErrParamRequired("CardExpiryDate"))
	}
	if s.CardExpiryDate != nil && len(*s.CardExpiryDate) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("CardExpiryDate", 4))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.ServiceCode == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceCode"))
	}
	if s.ServiceCode != nil && len(*s.ServiceCode) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceCode", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *DynamicCardVerificationValue) SetApplicationTransactionCounter(v string) *DynamicCardVerificationValue {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetCardExpiryDate sets the CardExpiryDate field's value.
func (s *DynamicCardVerificationValue) SetCardExpiryDate(v string) *DynamicCardVerificationValue {
	s.CardExpiryDate = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *DynamicCardVerificationValue) SetPanSequenceNumber(v string) *DynamicCardVerificationValue {
	s.PanSequenceNumber = &v
	return s
}

// SetServiceCode sets the ServiceCode field's value.
func (s *DynamicCardVerificationValue) SetServiceCode(v string) *DynamicCardVerificationValue {
	s.ServiceCode = &v
	return s
}

// Parameters for plaintext encryption using EMV keys.
type EmvEncryptionAttributes struct {
	_ struct{} `type:"structure"`

	// An input used to provide the intial state. If no value is provided, Amazon
	// Web Services Payment Cryptography defaults it to zero.
	//
	// InitializationVector is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EmvEncryptionAttributes's
	// String and GoString methods.
	InitializationVector *string `min:"16" type:"string" sensitive:"true"`

	// The EMV derivation mode to use for ICC master key derivation as per EMV version
	// 4.3 book 2.
	//
	// MajorKeyDerivationMode is a required field
	MajorKeyDerivationMode *string `type:"string" required:"true" enum:"EmvMajorKeyDerivationMode"`

	// The block cipher method to use for encryption.
	Mode *string `type:"string" enum:"EmvEncryptionMode"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card and associates the card to a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EmvEncryptionAttributes's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// The derivation value used to derive the ICC session key. It is typically
	// the application transaction counter value padded with zeros or previous ARQC
	// value padded with zeros as per EMV version 4.3 book 2.
	//
	// SessionDerivationData is a required field
	SessionDerivationData *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmvEncryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmvEncryptionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EmvEncryptionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EmvEncryptionAttributes"}
	if s.InitializationVector != nil && len(*s.InitializationVector) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("InitializationVector", 16))
	}
	if s.MajorKeyDerivationMode == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorKeyDerivationMode"))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.SessionDerivationData == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionDerivationData"))
	}
	if s.SessionDerivationData != nil && len(*s.SessionDerivationData) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("SessionDerivationData", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *EmvEncryptionAttributes) SetInitializationVector(v string) *EmvEncryptionAttributes {
	s.InitializationVector = &v
	return s
}

// SetMajorKeyDerivationMode sets the MajorKeyDerivationMode field's value.
func (s *EmvEncryptionAttributes) SetMajorKeyDerivationMode(v string) *EmvEncryptionAttributes {
	s.MajorKeyDerivationMode = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *EmvEncryptionAttributes) SetMode(v string) *EmvEncryptionAttributes {
	s.Mode = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *EmvEncryptionAttributes) SetPanSequenceNumber(v string) *EmvEncryptionAttributes {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *EmvEncryptionAttributes) SetPrimaryAccountNumber(v string) *EmvEncryptionAttributes {
	s.PrimaryAccountNumber = &v
	return s
}

// SetSessionDerivationData sets the SessionDerivationData field's value.
func (s *EmvEncryptionAttributes) SetSessionDerivationData(v string) *EmvEncryptionAttributes {
	s.SessionDerivationData = &v
	return s
}

type EncryptDataInput struct {
	_ struct{} `type:"structure"`

	// The encryption key type and attributes for plaintext encryption.
	//
	// EncryptionAttributes is a required field
	EncryptionAttributes *EncryptionDecryptionAttributes `type:"structure" required:"true"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for plaintext encryption.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `location:"uri" locationName:"KeyIdentifier" min:"7" type:"string" required:"true"`

	// The plaintext to be encrypted.
	//
	// For encryption using asymmetric keys, plaintext data length is constrained
	// by encryption key strength that you define in KeyAlgorithm and padding type
	// that you define in AsymmetricEncryptionAttributes. For more information,
	// see Encrypt data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html)
	// in the Amazon Web Services Payment Cryptography User Guide.
	//
	// PlainText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptDataInput's
	// String and GoString methods.
	//
	// PlainText is a required field
	PlainText *string `min:"16" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptDataInput"}
	if s.EncryptionAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionAttributes"))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.PlainText == nil {
		invalidParams.Add(request.NewErrParamRequired("PlainText"))
	}
	if s.PlainText != nil && len(*s.PlainText) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("PlainText", 16))
	}
	if s.EncryptionAttributes != nil {
		if err := s.EncryptionAttributes.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionAttributes sets the EncryptionAttributes field's value.
func (s *EncryptDataInput) SetEncryptionAttributes(v *EncryptionDecryptionAttributes) *EncryptDataInput {
	s.EncryptionAttributes = v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *EncryptDataInput) SetKeyIdentifier(v string) *EncryptDataInput {
	s.KeyIdentifier = &v
	return s
}

// SetPlainText sets the PlainText field's value.
func (s *EncryptDataInput) SetPlainText(v string) *EncryptDataInput {
	s.PlainText = &v
	return s
}

type EncryptDataOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted ciphertext.
	//
	// CipherText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EncryptDataOutput's
	// String and GoString methods.
	//
	// CipherText is a required field
	CipherText *string `min:"16" type:"string" required:"true" sensitive:"true"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for plaintext encryption.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	KeyCheckValue *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptDataOutput) GoString() string {
	return s.String()
}

// SetCipherText sets the CipherText field's value.
func (s *EncryptDataOutput) SetCipherText(v string) *EncryptDataOutput {
	s.CipherText = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *EncryptDataOutput) SetKeyArn(v string) *EncryptDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *EncryptDataOutput) SetKeyCheckValue(v string) *EncryptDataOutput {
	s.KeyCheckValue = &v
	return s
}

// Parameters that are required to perform encryption and decryption operations.
type EncryptionDecryptionAttributes struct {
	_ struct{} `type:"structure"`

	// Parameters for plaintext encryption using asymmetric keys.
	Asymmetric *AsymmetricEncryptionAttributes `type:"structure"`

	// Parameters that are required to encrypt plaintext data using DUKPT.
	Dukpt *DukptEncryptionAttributes `type:"structure"`

	// Parameters for plaintext encryption using EMV keys.
	Emv *EmvEncryptionAttributes `type:"structure"`

	// Parameters that are required to perform encryption and decryption using symmetric
	// keys.
	Symmetric *SymmetricEncryptionAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionDecryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionDecryptionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionDecryptionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionDecryptionAttributes"}
	if s.Dukpt != nil {
		if err := s.Dukpt.Validate(); err != nil {
			invalidParams.AddNested("Dukpt", err.(request.ErrInvalidParams))
		}
	}
	if s.Emv != nil {
		if err := s.Emv.Validate(); err != nil {
			invalidParams.AddNested("Emv", err.(request.ErrInvalidParams))
		}
	}
	if s.Symmetric != nil {
		if err := s.Symmetric.Validate(); err != nil {
			invalidParams.AddNested("Symmetric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAsymmetric sets the Asymmetric field's value.
func (s *EncryptionDecryptionAttributes) SetAsymmetric(v *AsymmetricEncryptionAttributes) *EncryptionDecryptionAttributes {
	s.Asymmetric = v
	return s
}

// SetDukpt sets the Dukpt field's value.
func (s *EncryptionDecryptionAttributes) SetDukpt(v *DukptEncryptionAttributes) *EncryptionDecryptionAttributes {
	s.Dukpt = v
	return s
}

// SetEmv sets the Emv field's value.
func (s *EncryptionDecryptionAttributes) SetEmv(v *EmvEncryptionAttributes) *EncryptionDecryptionAttributes {
	s.Emv = v
	return s
}

// SetSymmetric sets the Symmetric field's value.
func (s *EncryptionDecryptionAttributes) SetSymmetric(v *SymmetricEncryptionAttributes) *EncryptionDecryptionAttributes {
	s.Symmetric = v
	return s
}

type GenerateCardValidationDataInput struct {
	_ struct{} `type:"structure"`

	// The algorithm for generating CVV or CSC values for the card within Amazon
	// Web Services Payment Cryptography.
	//
	// GenerationAttributes is a required field
	GenerationAttributes *CardGenerationAttributes `type:"structure" required:"true"`

	// The keyARN of the CVK encryption key that Amazon Web Services Payment Cryptography
	// uses to generate card data.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card that associates the card with a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateCardValidationDataInput's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// The length of the CVV or CSC to be generated. The default value is 3.
	ValidationDataLength *int64 `min:"3" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateCardValidationDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateCardValidationDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateCardValidationDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateCardValidationDataInput"}
	if s.GenerationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerationAttributes"))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.ValidationDataLength != nil && *s.ValidationDataLength < 3 {
		invalidParams.Add(request.NewErrParamMinValue("ValidationDataLength", 3))
	}
	if s.GenerationAttributes != nil {
		if err := s.GenerationAttributes.Validate(); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerationAttributes sets the GenerationAttributes field's value.
func (s *GenerateCardValidationDataInput) SetGenerationAttributes(v *CardGenerationAttributes) *GenerateCardValidationDataInput {
	s.GenerationAttributes = v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *GenerateCardValidationDataInput) SetKeyIdentifier(v string) *GenerateCardValidationDataInput {
	s.KeyIdentifier = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *GenerateCardValidationDataInput) SetPrimaryAccountNumber(v string) *GenerateCardValidationDataInput {
	s.PrimaryAccountNumber = &v
	return s
}

// SetValidationDataLength sets the ValidationDataLength field's value.
func (s *GenerateCardValidationDataInput) SetValidationDataLength(v int64) *GenerateCardValidationDataInput {
	s.ValidationDataLength = &v
	return s
}

type GenerateCardValidationDataOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the CVK encryption key that Amazon Web Services Payment Cryptography
	// uses to generate CVV or CSC.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The CVV or CSC value that Amazon Web Services Payment Cryptography generates
	// for the card.
	//
	// ValidationData is a required field
	ValidationData *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateCardValidationDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateCardValidationDataOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *GenerateCardValidationDataOutput) SetKeyArn(v string) *GenerateCardValidationDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *GenerateCardValidationDataOutput) SetKeyCheckValue(v string) *GenerateCardValidationDataOutput {
	s.KeyCheckValue = &v
	return s
}

// SetValidationData sets the ValidationData field's value.
func (s *GenerateCardValidationDataOutput) SetValidationData(v string) *GenerateCardValidationDataOutput {
	s.ValidationData = &v
	return s
}

type GenerateMacInput struct {
	_ struct{} `type:"structure"`

	// The attributes and data values to use for MAC generation within Amazon Web
	// Services Payment Cryptography.
	//
	// GenerationAttributes is a required field
	GenerationAttributes *MacAttributes `type:"structure" required:"true"`

	// The keyARN of the MAC generation encryption key.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The length of a MAC under generation.
	MacLength *int64 `min:"4" type:"integer"`

	// The data for which a MAC is under generation. This value must be hexBinary.
	//
	// MessageData is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GenerateMacInput's
	// String and GoString methods.
	//
	// MessageData is a required field
	MessageData *string `min:"2" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateMacInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateMacInput"}
	if s.GenerationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerationAttributes"))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.MacLength != nil && *s.MacLength < 4 {
		invalidParams.Add(request.NewErrParamMinValue("MacLength", 4))
	}
	if s.MessageData == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageData"))
	}
	if s.MessageData != nil && len(*s.MessageData) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MessageData", 2))
	}
	if s.GenerationAttributes != nil {
		if err := s.GenerationAttributes.Validate(); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerationAttributes sets the GenerationAttributes field's value.
func (s *GenerateMacInput) SetGenerationAttributes(v *MacAttributes) *GenerateMacInput {
	s.GenerationAttributes = v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *GenerateMacInput) SetKeyIdentifier(v string) *GenerateMacInput {
	s.KeyIdentifier = &v
	return s
}

// SetMacLength sets the MacLength field's value.
func (s *GenerateMacInput) SetMacLength(v int64) *GenerateMacInput {
	s.MacLength = &v
	return s
}

// SetMessageData sets the MessageData field's value.
func (s *GenerateMacInput) SetMessageData(v string) *GenerateMacInput {
	s.MessageData = &v
	return s
}

type GenerateMacOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for MAC generation.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The MAC cryptogram generated within Amazon Web Services Payment Cryptography.
	//
	// Mac is a required field
	Mac *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateMacOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *GenerateMacOutput) SetKeyArn(v string) *GenerateMacOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *GenerateMacOutput) SetKeyCheckValue(v string) *GenerateMacOutput {
	s.KeyCheckValue = &v
	return s
}

// SetMac sets the Mac field's value.
func (s *GenerateMacOutput) SetMac(v string) *GenerateMacOutput {
	s.Mac = &v
	return s
}

type GeneratePinDataInput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the PEK that Amazon Web Services Payment Cryptography uses
	// to encrypt the PIN Block.
	//
	// EncryptionKeyIdentifier is a required field
	EncryptionKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The attributes and values to use for PIN, PVV, or PIN Offset generation.
	//
	// GenerationAttributes is a required field
	GenerationAttributes *PinGenerationAttributes `type:"structure" required:"true"`

	// The keyARN of the PEK that Amazon Web Services Payment Cryptography uses
	// for pin data generation.
	//
	// GenerationKeyIdentifier is a required field
	GenerationKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The PIN encoding format for pin data generation as specified in ISO 9564.
	// Amazon Web Services Payment Cryptography supports ISO_Format_0 and ISO_Format_3.
	//
	// The ISO_Format_0 PIN block format is equivalent to the ANSI X9.8, VISA-1,
	// and ECI-1 PIN block formats. It is similar to a VISA-4 PIN block format.
	// It supports a PIN from 4 to 12 digits in length.
	//
	// The ISO_Format_3 PIN block format is the same as ISO_Format_0 except that
	// the fill digits are random values from 10 to 15.
	//
	// PinBlockFormat is a required field
	PinBlockFormat *string `type:"string" required:"true" enum:"PinBlockFormatForPinData"`

	// The length of PIN under generation.
	PinDataLength *int64 `min:"4" type:"integer"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card that associates the card with a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GeneratePinDataInput's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratePinDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratePinDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeneratePinDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeneratePinDataInput"}
	if s.EncryptionKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionKeyIdentifier"))
	}
	if s.EncryptionKeyIdentifier != nil && len(*s.EncryptionKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyIdentifier", 7))
	}
	if s.GenerationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerationAttributes"))
	}
	if s.GenerationKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("GenerationKeyIdentifier"))
	}
	if s.GenerationKeyIdentifier != nil && len(*s.GenerationKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("GenerationKeyIdentifier", 7))
	}
	if s.PinBlockFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("PinBlockFormat"))
	}
	if s.PinDataLength != nil && *s.PinDataLength < 4 {
		invalidParams.Add(request.NewErrParamMinValue("PinDataLength", 4))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.GenerationAttributes != nil {
		if err := s.GenerationAttributes.Validate(); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptionKeyIdentifier sets the EncryptionKeyIdentifier field's value.
func (s *GeneratePinDataInput) SetEncryptionKeyIdentifier(v string) *GeneratePinDataInput {
	s.EncryptionKeyIdentifier = &v
	return s
}

// SetGenerationAttributes sets the GenerationAttributes field's value.
func (s *GeneratePinDataInput) SetGenerationAttributes(v *PinGenerationAttributes) *GeneratePinDataInput {
	s.GenerationAttributes = v
	return s
}

// SetGenerationKeyIdentifier sets the GenerationKeyIdentifier field's value.
func (s *GeneratePinDataInput) SetGenerationKeyIdentifier(v string) *GeneratePinDataInput {
	s.GenerationKeyIdentifier = &v
	return s
}

// SetPinBlockFormat sets the PinBlockFormat field's value.
func (s *GeneratePinDataInput) SetPinBlockFormat(v string) *GeneratePinDataInput {
	s.PinBlockFormat = &v
	return s
}

// SetPinDataLength sets the PinDataLength field's value.
func (s *GeneratePinDataInput) SetPinDataLength(v int64) *GeneratePinDataInput {
	s.PinDataLength = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *GeneratePinDataInput) SetPrimaryAccountNumber(v string) *GeneratePinDataInput {
	s.PrimaryAccountNumber = &v
	return s
}

type GeneratePinDataOutput struct {
	_ struct{} `type:"structure"`

	// The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography.
	// The encrypted PIN block is a composite of PAN (Primary Account Number) and
	// PIN (Personal Identification Number), generated in accordance with ISO 9564
	// standard.
	//
	// EncryptedPinBlock is a required field
	EncryptedPinBlock *string `min:"16" type:"string" required:"true"`

	// The keyARN of the PEK that Amazon Web Services Payment Cryptography uses
	// for encrypted pin block generation.
	//
	// EncryptionKeyArn is a required field
	EncryptionKeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// EncryptionKeyCheckValue is a required field
	EncryptionKeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The keyARN of the pin data generation key that Amazon Web Services Payment
	// Cryptography uses for PIN, PVV or PIN Offset generation.
	//
	// GenerationKeyArn is a required field
	GenerationKeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// GenerationKeyCheckValue is a required field
	GenerationKeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The attributes and values Amazon Web Services Payment Cryptography uses for
	// pin data generation.
	//
	// PinData is a required field
	PinData *PinData `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratePinDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GeneratePinDataOutput) GoString() string {
	return s.String()
}

// SetEncryptedPinBlock sets the EncryptedPinBlock field's value.
func (s *GeneratePinDataOutput) SetEncryptedPinBlock(v string) *GeneratePinDataOutput {
	s.EncryptedPinBlock = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *GeneratePinDataOutput) SetEncryptionKeyArn(v string) *GeneratePinDataOutput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionKeyCheckValue sets the EncryptionKeyCheckValue field's value.
func (s *GeneratePinDataOutput) SetEncryptionKeyCheckValue(v string) *GeneratePinDataOutput {
	s.EncryptionKeyCheckValue = &v
	return s
}

// SetGenerationKeyArn sets the GenerationKeyArn field's value.
func (s *GeneratePinDataOutput) SetGenerationKeyArn(v string) *GeneratePinDataOutput {
	s.GenerationKeyArn = &v
	return s
}

// SetGenerationKeyCheckValue sets the GenerationKeyCheckValue field's value.
func (s *GeneratePinDataOutput) SetGenerationKeyCheckValue(v string) *GeneratePinDataOutput {
	s.GenerationKeyCheckValue = &v
	return s
}

// SetPinData sets the PinData field's value.
func (s *GeneratePinDataOutput) SetPinData(v *PinData) *GeneratePinDataOutput {
	s.PinData = v
	return s
}

// Parameters that are required to generate or verify Ibm3624 natural PIN.
type Ibm3624NaturalPin struct {
	_ struct{} `type:"structure"`

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is
	// used to convert the algorithm intermediate result from hexadecimal characters
	// to decimal.
	//
	// DecimalizationTable is a required field
	DecimalizationTable *string `min:"16" type:"string" required:"true"`

	// The unique data for cardholder identification.
	//
	// PinValidationData is a required field
	PinValidationData *string `min:"4" type:"string" required:"true"`

	// The padding character for validation data.
	//
	// PinValidationDataPadCharacter is a required field
	PinValidationDataPadCharacter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624NaturalPin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624NaturalPin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ibm3624NaturalPin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ibm3624NaturalPin"}
	if s.DecimalizationTable == nil {
		invalidParams.Add(request.NewErrParamRequired("DecimalizationTable"))
	}
	if s.DecimalizationTable != nil && len(*s.DecimalizationTable) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("DecimalizationTable", 16))
	}
	if s.PinValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationData"))
	}
	if s.PinValidationData != nil && len(*s.PinValidationData) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationData", 4))
	}
	if s.PinValidationDataPadCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if s.PinValidationDataPadCharacter != nil && len(*s.PinValidationDataPadCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationDataPadCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalizationTable sets the DecimalizationTable field's value.
func (s *Ibm3624NaturalPin) SetDecimalizationTable(v string) *Ibm3624NaturalPin {
	s.DecimalizationTable = &v
	return s
}

// SetPinValidationData sets the PinValidationData field's value.
func (s *Ibm3624NaturalPin) SetPinValidationData(v string) *Ibm3624NaturalPin {
	s.PinValidationData = &v
	return s
}

// SetPinValidationDataPadCharacter sets the PinValidationDataPadCharacter field's value.
func (s *Ibm3624NaturalPin) SetPinValidationDataPadCharacter(v string) *Ibm3624NaturalPin {
	s.PinValidationDataPadCharacter = &v
	return s
}

// Parameters that are required to generate or verify Ibm3624 PIN from offset
// PIN.
type Ibm3624PinFromOffset struct {
	_ struct{} `type:"structure"`

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is
	// used to convert the algorithm intermediate result from hexadecimal characters
	// to decimal.
	//
	// DecimalizationTable is a required field
	DecimalizationTable *string `min:"16" type:"string" required:"true"`

	// The PIN offset value.
	//
	// PinOffset is a required field
	PinOffset *string `min:"4" type:"string" required:"true"`

	// The unique data for cardholder identification.
	//
	// PinValidationData is a required field
	PinValidationData *string `min:"4" type:"string" required:"true"`

	// The padding character for validation data.
	//
	// PinValidationDataPadCharacter is a required field
	PinValidationDataPadCharacter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinFromOffset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinFromOffset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ibm3624PinFromOffset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ibm3624PinFromOffset"}
	if s.DecimalizationTable == nil {
		invalidParams.Add(request.NewErrParamRequired("DecimalizationTable"))
	}
	if s.DecimalizationTable != nil && len(*s.DecimalizationTable) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("DecimalizationTable", 16))
	}
	if s.PinOffset == nil {
		invalidParams.Add(request.NewErrParamRequired("PinOffset"))
	}
	if s.PinOffset != nil && len(*s.PinOffset) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinOffset", 4))
	}
	if s.PinValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationData"))
	}
	if s.PinValidationData != nil && len(*s.PinValidationData) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationData", 4))
	}
	if s.PinValidationDataPadCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if s.PinValidationDataPadCharacter != nil && len(*s.PinValidationDataPadCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationDataPadCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalizationTable sets the DecimalizationTable field's value.
func (s *Ibm3624PinFromOffset) SetDecimalizationTable(v string) *Ibm3624PinFromOffset {
	s.DecimalizationTable = &v
	return s
}

// SetPinOffset sets the PinOffset field's value.
func (s *Ibm3624PinFromOffset) SetPinOffset(v string) *Ibm3624PinFromOffset {
	s.PinOffset = &v
	return s
}

// SetPinValidationData sets the PinValidationData field's value.
func (s *Ibm3624PinFromOffset) SetPinValidationData(v string) *Ibm3624PinFromOffset {
	s.PinValidationData = &v
	return s
}

// SetPinValidationDataPadCharacter sets the PinValidationDataPadCharacter field's value.
func (s *Ibm3624PinFromOffset) SetPinValidationDataPadCharacter(v string) *Ibm3624PinFromOffset {
	s.PinValidationDataPadCharacter = &v
	return s
}

// Pparameters that are required to generate or verify Ibm3624 PIN offset PIN.
type Ibm3624PinOffset struct {
	_ struct{} `type:"structure"`

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is
	// used to convert the algorithm intermediate result from hexadecimal characters
	// to decimal.
	//
	// DecimalizationTable is a required field
	DecimalizationTable *string `min:"16" type:"string" required:"true"`

	// The encrypted PIN block data. According to ISO 9564 standard, a PIN Block
	// is an encoded representation of a payment card Personal Account Number (PAN)
	// and the cardholder Personal Identification Number (PIN).
	//
	// EncryptedPinBlock is a required field
	EncryptedPinBlock *string `min:"16" type:"string" required:"true"`

	// The unique data for cardholder identification.
	//
	// PinValidationData is a required field
	PinValidationData *string `min:"4" type:"string" required:"true"`

	// The padding character for validation data.
	//
	// PinValidationDataPadCharacter is a required field
	PinValidationDataPadCharacter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinOffset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinOffset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ibm3624PinOffset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ibm3624PinOffset"}
	if s.DecimalizationTable == nil {
		invalidParams.Add(request.NewErrParamRequired("DecimalizationTable"))
	}
	if s.DecimalizationTable != nil && len(*s.DecimalizationTable) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("DecimalizationTable", 16))
	}
	if s.EncryptedPinBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedPinBlock"))
	}
	if s.EncryptedPinBlock != nil && len(*s.EncryptedPinBlock) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedPinBlock", 16))
	}
	if s.PinValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationData"))
	}
	if s.PinValidationData != nil && len(*s.PinValidationData) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationData", 4))
	}
	if s.PinValidationDataPadCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if s.PinValidationDataPadCharacter != nil && len(*s.PinValidationDataPadCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationDataPadCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalizationTable sets the DecimalizationTable field's value.
func (s *Ibm3624PinOffset) SetDecimalizationTable(v string) *Ibm3624PinOffset {
	s.DecimalizationTable = &v
	return s
}

// SetEncryptedPinBlock sets the EncryptedPinBlock field's value.
func (s *Ibm3624PinOffset) SetEncryptedPinBlock(v string) *Ibm3624PinOffset {
	s.EncryptedPinBlock = &v
	return s
}

// SetPinValidationData sets the PinValidationData field's value.
func (s *Ibm3624PinOffset) SetPinValidationData(v string) *Ibm3624PinOffset {
	s.PinValidationData = &v
	return s
}

// SetPinValidationDataPadCharacter sets the PinValidationDataPadCharacter field's value.
func (s *Ibm3624PinOffset) SetPinValidationDataPadCharacter(v string) *Ibm3624PinOffset {
	s.PinValidationDataPadCharacter = &v
	return s
}

// Parameters that are required to generate or verify Ibm3624 PIN verification
// PIN.
type Ibm3624PinVerification struct {
	_ struct{} `type:"structure"`

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is
	// used to convert the algorithm intermediate result from hexadecimal characters
	// to decimal.
	//
	// DecimalizationTable is a required field
	DecimalizationTable *string `min:"16" type:"string" required:"true"`

	// The PIN offset value.
	//
	// PinOffset is a required field
	PinOffset *string `min:"4" type:"string" required:"true"`

	// The unique data for cardholder identification.
	//
	// PinValidationData is a required field
	PinValidationData *string `min:"4" type:"string" required:"true"`

	// The padding character for validation data.
	//
	// PinValidationDataPadCharacter is a required field
	PinValidationDataPadCharacter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624PinVerification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ibm3624PinVerification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ibm3624PinVerification"}
	if s.DecimalizationTable == nil {
		invalidParams.Add(request.NewErrParamRequired("DecimalizationTable"))
	}
	if s.DecimalizationTable != nil && len(*s.DecimalizationTable) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("DecimalizationTable", 16))
	}
	if s.PinOffset == nil {
		invalidParams.Add(request.NewErrParamRequired("PinOffset"))
	}
	if s.PinOffset != nil && len(*s.PinOffset) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinOffset", 4))
	}
	if s.PinValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationData"))
	}
	if s.PinValidationData != nil && len(*s.PinValidationData) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationData", 4))
	}
	if s.PinValidationDataPadCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if s.PinValidationDataPadCharacter != nil && len(*s.PinValidationDataPadCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationDataPadCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalizationTable sets the DecimalizationTable field's value.
func (s *Ibm3624PinVerification) SetDecimalizationTable(v string) *Ibm3624PinVerification {
	s.DecimalizationTable = &v
	return s
}

// SetPinOffset sets the PinOffset field's value.
func (s *Ibm3624PinVerification) SetPinOffset(v string) *Ibm3624PinVerification {
	s.PinOffset = &v
	return s
}

// SetPinValidationData sets the PinValidationData field's value.
func (s *Ibm3624PinVerification) SetPinValidationData(v string) *Ibm3624PinVerification {
	s.PinValidationData = &v
	return s
}

// SetPinValidationDataPadCharacter sets the PinValidationDataPadCharacter field's value.
func (s *Ibm3624PinVerification) SetPinValidationDataPadCharacter(v string) *Ibm3624PinVerification {
	s.PinValidationDataPadCharacter = &v
	return s
}

// Parameters that are required to generate or verify Ibm3624 random PIN.
type Ibm3624RandomPin struct {
	_ struct{} `type:"structure"`

	// The decimalization table to use for IBM 3624 PIN algorithm. The table is
	// used to convert the algorithm intermediate result from hexadecimal characters
	// to decimal.
	//
	// DecimalizationTable is a required field
	DecimalizationTable *string `min:"16" type:"string" required:"true"`

	// The unique data for cardholder identification.
	//
	// PinValidationData is a required field
	PinValidationData *string `min:"4" type:"string" required:"true"`

	// The padding character for validation data.
	//
	// PinValidationDataPadCharacter is a required field
	PinValidationDataPadCharacter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624RandomPin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ibm3624RandomPin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ibm3624RandomPin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ibm3624RandomPin"}
	if s.DecimalizationTable == nil {
		invalidParams.Add(request.NewErrParamRequired("DecimalizationTable"))
	}
	if s.DecimalizationTable != nil && len(*s.DecimalizationTable) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("DecimalizationTable", 16))
	}
	if s.PinValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationData"))
	}
	if s.PinValidationData != nil && len(*s.PinValidationData) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationData", 4))
	}
	if s.PinValidationDataPadCharacter == nil {
		invalidParams.Add(request.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if s.PinValidationDataPadCharacter != nil && len(*s.PinValidationDataPadCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PinValidationDataPadCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecimalizationTable sets the DecimalizationTable field's value.
func (s *Ibm3624RandomPin) SetDecimalizationTable(v string) *Ibm3624RandomPin {
	s.DecimalizationTable = &v
	return s
}

// SetPinValidationData sets the PinValidationData field's value.
func (s *Ibm3624RandomPin) SetPinValidationData(v string) *Ibm3624RandomPin {
	s.PinValidationData = &v
	return s
}

// SetPinValidationDataPadCharacter sets the PinValidationDataPadCharacter field's value.
func (s *Ibm3624RandomPin) SetPinValidationDataPadCharacter(v string) *Ibm3624RandomPin {
	s.PinValidationDataPadCharacter = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Parameters required for DUKPT MAC generation and verification.
type MacAlgorithmDukpt struct {
	_ struct{} `type:"structure"`

	// The key type derived using DUKPT from a Base Derivation Key (BDK) and Key
	// Serial Number (KSN). This must be less than or equal to the strength of the
	// BDK. For example, you can't use AES_128 as a derivation type for a BDK of
	// AES_128 or TDES_2KEY.
	DukptDerivationType *string `type:"string" enum:"DukptDerivationType"`

	// The type of use of DUKPT, which can be MAC generation, MAC verification,
	// or both.
	//
	// DukptKeyVariant is a required field
	DukptKeyVariant *string `type:"string" required:"true" enum:"DukptKeyVariant"`

	// The unique identifier known as Key Serial Number (KSN) that comes from an
	// encrypting device using DUKPT encryption method. The KSN is derived from
	// the encrypting device unique identifier and an internal transaction counter.
	//
	// KeySerialNumber is a required field
	KeySerialNumber *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAlgorithmDukpt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAlgorithmDukpt) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MacAlgorithmDukpt) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MacAlgorithmDukpt"}
	if s.DukptKeyVariant == nil {
		invalidParams.Add(request.NewErrParamRequired("DukptKeyVariant"))
	}
	if s.KeySerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySerialNumber"))
	}
	if s.KeySerialNumber != nil && len(*s.KeySerialNumber) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("KeySerialNumber", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukptDerivationType sets the DukptDerivationType field's value.
func (s *MacAlgorithmDukpt) SetDukptDerivationType(v string) *MacAlgorithmDukpt {
	s.DukptDerivationType = &v
	return s
}

// SetDukptKeyVariant sets the DukptKeyVariant field's value.
func (s *MacAlgorithmDukpt) SetDukptKeyVariant(v string) *MacAlgorithmDukpt {
	s.DukptKeyVariant = &v
	return s
}

// SetKeySerialNumber sets the KeySerialNumber field's value.
func (s *MacAlgorithmDukpt) SetKeySerialNumber(v string) *MacAlgorithmDukpt {
	s.KeySerialNumber = &v
	return s
}

// Parameters that are required for EMV MAC generation and verification.
type MacAlgorithmEmv struct {
	_ struct{} `type:"structure"`

	// The method to use when deriving the master key for EMV MAC generation or
	// verification.
	//
	// MajorKeyDerivationMode is a required field
	MajorKeyDerivationMode *string `type:"string" required:"true" enum:"MajorKeyDerivationMode"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card and associates the card to a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by MacAlgorithmEmv's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// The method of deriving a session key for EMV MAC generation or verification.
	//
	// SessionKeyDerivationMode is a required field
	SessionKeyDerivationMode *string `type:"string" required:"true" enum:"SessionKeyDerivationMode"`

	// Parameters that are required to generate session key for EMV generation and
	// verification.
	//
	// SessionKeyDerivationValue is a required field
	SessionKeyDerivationValue *SessionKeyDerivationValue `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAlgorithmEmv) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAlgorithmEmv) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MacAlgorithmEmv) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MacAlgorithmEmv"}
	if s.MajorKeyDerivationMode == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorKeyDerivationMode"))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.SessionKeyDerivationMode == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionKeyDerivationMode"))
	}
	if s.SessionKeyDerivationValue == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionKeyDerivationValue"))
	}
	if s.SessionKeyDerivationValue != nil {
		if err := s.SessionKeyDerivationValue.Validate(); err != nil {
			invalidParams.AddNested("SessionKeyDerivationValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorKeyDerivationMode sets the MajorKeyDerivationMode field's value.
func (s *MacAlgorithmEmv) SetMajorKeyDerivationMode(v string) *MacAlgorithmEmv {
	s.MajorKeyDerivationMode = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *MacAlgorithmEmv) SetPanSequenceNumber(v string) *MacAlgorithmEmv {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *MacAlgorithmEmv) SetPrimaryAccountNumber(v string) *MacAlgorithmEmv {
	s.PrimaryAccountNumber = &v
	return s
}

// SetSessionKeyDerivationMode sets the SessionKeyDerivationMode field's value.
func (s *MacAlgorithmEmv) SetSessionKeyDerivationMode(v string) *MacAlgorithmEmv {
	s.SessionKeyDerivationMode = &v
	return s
}

// SetSessionKeyDerivationValue sets the SessionKeyDerivationValue field's value.
func (s *MacAlgorithmEmv) SetSessionKeyDerivationValue(v *SessionKeyDerivationValue) *MacAlgorithmEmv {
	s.SessionKeyDerivationValue = v
	return s
}

// Parameters that are required for DUKPT, HMAC, or EMV MAC generation or verification.
type MacAttributes struct {
	_ struct{} `type:"structure"`

	// The encryption algorithm for MAC generation or verification.
	Algorithm *string `type:"string" enum:"MacAlgorithm"`

	// Parameters that are required for MAC generation or verification using DUKPT
	// CMAC algorithm.
	DukptCmac *MacAlgorithmDukpt `type:"structure"`

	// Parameters that are required for MAC generation or verification using DUKPT
	// ISO 9797 algorithm1.
	DukptIso9797Algorithm1 *MacAlgorithmDukpt `type:"structure"`

	// Parameters that are required for MAC generation or verification using DUKPT
	// ISO 9797 algorithm3.
	DukptIso9797Algorithm3 *MacAlgorithmDukpt `type:"structure"`

	// Parameters that are required for MAC generation or verification using EMV
	// MAC algorithm.
	EmvMac *MacAlgorithmEmv `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MacAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MacAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MacAttributes"}
	if s.DukptCmac != nil {
		if err := s.DukptCmac.Validate(); err != nil {
			invalidParams.AddNested("DukptCmac", err.(request.ErrInvalidParams))
		}
	}
	if s.DukptIso9797Algorithm1 != nil {
		if err := s.DukptIso9797Algorithm1.Validate(); err != nil {
			invalidParams.AddNested("DukptIso9797Algorithm1", err.(request.ErrInvalidParams))
		}
	}
	if s.DukptIso9797Algorithm3 != nil {
		if err := s.DukptIso9797Algorithm3.Validate(); err != nil {
			invalidParams.AddNested("DukptIso9797Algorithm3", err.(request.ErrInvalidParams))
		}
	}
	if s.EmvMac != nil {
		if err := s.EmvMac.Validate(); err != nil {
			invalidParams.AddNested("EmvMac", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *MacAttributes) SetAlgorithm(v string) *MacAttributes {
	s.Algorithm = &v
	return s
}

// SetDukptCmac sets the DukptCmac field's value.
func (s *MacAttributes) SetDukptCmac(v *MacAlgorithmDukpt) *MacAttributes {
	s.DukptCmac = v
	return s
}

// SetDukptIso9797Algorithm1 sets the DukptIso9797Algorithm1 field's value.
func (s *MacAttributes) SetDukptIso9797Algorithm1(v *MacAlgorithmDukpt) *MacAttributes {
	s.DukptIso9797Algorithm1 = v
	return s
}

// SetDukptIso9797Algorithm3 sets the DukptIso9797Algorithm3 field's value.
func (s *MacAttributes) SetDukptIso9797Algorithm3(v *MacAlgorithmDukpt) *MacAttributes {
	s.DukptIso9797Algorithm3 = v
	return s
}

// SetEmvMac sets the EmvMac field's value.
func (s *MacAttributes) SetEmvMac(v *MacAlgorithmEmv) *MacAttributes {
	s.EmvMac = v
	return s
}

// Parameters that are required to generate, translate, or verify PIN data.
type PinData struct {
	_ struct{} `type:"structure"`

	// The PIN offset value.
	PinOffset *string `min:"4" type:"string"`

	// The unique data to identify a cardholder. In most cases, this is the same
	// as cardholder's Primary Account Number (PAN). If a value is not provided,
	// it defaults to PAN.
	VerificationValue *string `min:"4" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinData) GoString() string {
	return s.String()
}

// SetPinOffset sets the PinOffset field's value.
func (s *PinData) SetPinOffset(v string) *PinData {
	s.PinOffset = &v
	return s
}

// SetVerificationValue sets the VerificationValue field's value.
func (s *PinData) SetVerificationValue(v string) *PinData {
	s.VerificationValue = &v
	return s
}

// Parameters that are required for PIN data generation.
type PinGenerationAttributes struct {
	_ struct{} `type:"structure"`

	// Parameters that are required to generate or verify Ibm3624 natural PIN.
	Ibm3624NaturalPin *Ibm3624NaturalPin `type:"structure"`

	// Parameters that are required to generate or verify Ibm3624 PIN from offset
	// PIN.
	Ibm3624PinFromOffset *Ibm3624PinFromOffset `type:"structure"`

	// Parameters that are required to generate or verify Ibm3624 PIN offset PIN.
	Ibm3624PinOffset *Ibm3624PinOffset `type:"structure"`

	// Parameters that are required to generate or verify Ibm3624 random PIN.
	Ibm3624RandomPin *Ibm3624RandomPin `type:"structure"`

	// Parameters that are required to generate or verify Visa PIN.
	VisaPin *VisaPin `type:"structure"`

	// Parameters that are required to generate or verify Visa PIN Verification
	// Value (PVV).
	VisaPinVerificationValue *VisaPinVerificationValue `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinGenerationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinGenerationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PinGenerationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PinGenerationAttributes"}
	if s.Ibm3624NaturalPin != nil {
		if err := s.Ibm3624NaturalPin.Validate(); err != nil {
			invalidParams.AddNested("Ibm3624NaturalPin", err.(request.ErrInvalidParams))
		}
	}
	if s.Ibm3624PinFromOffset != nil {
		if err := s.Ibm3624PinFromOffset.Validate(); err != nil {
			invalidParams.AddNested("Ibm3624PinFromOffset", err.(request.ErrInvalidParams))
		}
	}
	if s.Ibm3624PinOffset != nil {
		if err := s.Ibm3624PinOffset.Validate(); err != nil {
			invalidParams.AddNested("Ibm3624PinOffset", err.(request.ErrInvalidParams))
		}
	}
	if s.Ibm3624RandomPin != nil {
		if err := s.Ibm3624RandomPin.Validate(); err != nil {
			invalidParams.AddNested("Ibm3624RandomPin", err.(request.ErrInvalidParams))
		}
	}
	if s.VisaPin != nil {
		if err := s.VisaPin.Validate(); err != nil {
			invalidParams.AddNested("VisaPin", err.(request.ErrInvalidParams))
		}
	}
	if s.VisaPinVerificationValue != nil {
		if err := s.VisaPinVerificationValue.Validate(); err != nil {
			invalidParams.AddNested("VisaPinVerificationValue", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIbm3624NaturalPin sets the Ibm3624NaturalPin field's value.
func (s *PinGenerationAttributes) SetIbm3624NaturalPin(v *Ibm3624NaturalPin) *PinGenerationAttributes {
	s.Ibm3624NaturalPin = v
	return s
}

// SetIbm3624PinFromOffset sets the Ibm3624PinFromOffset field's value.
func (s *PinGenerationAttributes) SetIbm3624PinFromOffset(v *Ibm3624PinFromOffset) *PinGenerationAttributes {
	s.Ibm3624PinFromOffset = v
	return s
}

// SetIbm3624PinOffset sets the Ibm3624PinOffset field's value.
func (s *PinGenerationAttributes) SetIbm3624PinOffset(v *Ibm3624PinOffset) *PinGenerationAttributes {
	s.Ibm3624PinOffset = v
	return s
}

// SetIbm3624RandomPin sets the Ibm3624RandomPin field's value.
func (s *PinGenerationAttributes) SetIbm3624RandomPin(v *Ibm3624RandomPin) *PinGenerationAttributes {
	s.Ibm3624RandomPin = v
	return s
}

// SetVisaPin sets the VisaPin field's value.
func (s *PinGenerationAttributes) SetVisaPin(v *VisaPin) *PinGenerationAttributes {
	s.VisaPin = v
	return s
}

// SetVisaPinVerificationValue sets the VisaPinVerificationValue field's value.
func (s *PinGenerationAttributes) SetVisaPinVerificationValue(v *VisaPinVerificationValue) *PinGenerationAttributes {
	s.VisaPinVerificationValue = v
	return s
}

// Parameters that are required for PIN data verification.
type PinVerificationAttributes struct {
	_ struct{} `type:"structure"`

	// Parameters that are required to generate or verify Ibm3624 PIN.
	Ibm3624Pin *Ibm3624PinVerification `type:"structure"`

	// Parameters that are required to generate or verify Visa PIN.
	VisaPin *VisaPinVerification `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PinVerificationAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PinVerificationAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PinVerificationAttributes"}
	if s.Ibm3624Pin != nil {
		if err := s.Ibm3624Pin.Validate(); err != nil {
			invalidParams.AddNested("Ibm3624Pin", err.(request.ErrInvalidParams))
		}
	}
	if s.VisaPin != nil {
		if err := s.VisaPin.Validate(); err != nil {
			invalidParams.AddNested("VisaPin", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIbm3624Pin sets the Ibm3624Pin field's value.
func (s *PinVerificationAttributes) SetIbm3624Pin(v *Ibm3624PinVerification) *PinVerificationAttributes {
	s.Ibm3624Pin = v
	return s
}

// SetVisaPin sets the VisaPin field's value.
func (s *PinVerificationAttributes) SetVisaPin(v *VisaPinVerification) *PinVerificationAttributes {
	s.VisaPin = v
	return s
}

type ReEncryptDataInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext to be encrypted. The minimum allowed length is 16 bytes and maximum
	// allowed length is 4096 bytes.
	//
	// CipherText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReEncryptDataInput's
	// String and GoString methods.
	//
	// CipherText is a required field
	CipherText *string `min:"16" type:"string" required:"true" sensitive:"true"`

	// The attributes and values for incoming ciphertext.
	//
	// IncomingEncryptionAttributes is a required field
	IncomingEncryptionAttributes *ReEncryptionAttributes `type:"structure" required:"true"`

	// The keyARN of the encryption key of incoming ciphertext data.
	//
	// IncomingKeyIdentifier is a required field
	IncomingKeyIdentifier *string `location:"uri" locationName:"IncomingKeyIdentifier" min:"7" type:"string" required:"true"`

	// The attributes and values for outgoing ciphertext data after encryption by
	// Amazon Web Services Payment Cryptography.
	//
	// OutgoingEncryptionAttributes is a required field
	OutgoingEncryptionAttributes *ReEncryptionAttributes `type:"structure" required:"true"`

	// The keyARN of the encryption key of outgoing ciphertext data after encryption
	// by Amazon Web Services Payment Cryptography.
	//
	// OutgoingKeyIdentifier is a required field
	OutgoingKeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReEncryptDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReEncryptDataInput"}
	if s.CipherText == nil {
		invalidParams.Add(request.NewErrParamRequired("CipherText"))
	}
	if s.CipherText != nil && len(*s.CipherText) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("CipherText", 16))
	}
	if s.IncomingEncryptionAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("IncomingEncryptionAttributes"))
	}
	if s.IncomingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IncomingKeyIdentifier"))
	}
	if s.IncomingKeyIdentifier != nil && len(*s.IncomingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("IncomingKeyIdentifier", 7))
	}
	if s.OutgoingEncryptionAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("OutgoingEncryptionAttributes"))
	}
	if s.OutgoingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OutgoingKeyIdentifier"))
	}
	if s.OutgoingKeyIdentifier != nil && len(*s.OutgoingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("OutgoingKeyIdentifier", 7))
	}
	if s.IncomingEncryptionAttributes != nil {
		if err := s.IncomingEncryptionAttributes.Validate(); err != nil {
			invalidParams.AddNested("IncomingEncryptionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.OutgoingEncryptionAttributes != nil {
		if err := s.OutgoingEncryptionAttributes.Validate(); err != nil {
			invalidParams.AddNested("OutgoingEncryptionAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCipherText sets the CipherText field's value.
func (s *ReEncryptDataInput) SetCipherText(v string) *ReEncryptDataInput {
	s.CipherText = &v
	return s
}

// SetIncomingEncryptionAttributes sets the IncomingEncryptionAttributes field's value.
func (s *ReEncryptDataInput) SetIncomingEncryptionAttributes(v *ReEncryptionAttributes) *ReEncryptDataInput {
	s.IncomingEncryptionAttributes = v
	return s
}

// SetIncomingKeyIdentifier sets the IncomingKeyIdentifier field's value.
func (s *ReEncryptDataInput) SetIncomingKeyIdentifier(v string) *ReEncryptDataInput {
	s.IncomingKeyIdentifier = &v
	return s
}

// SetOutgoingEncryptionAttributes sets the OutgoingEncryptionAttributes field's value.
func (s *ReEncryptDataInput) SetOutgoingEncryptionAttributes(v *ReEncryptionAttributes) *ReEncryptDataInput {
	s.OutgoingEncryptionAttributes = v
	return s
}

// SetOutgoingKeyIdentifier sets the OutgoingKeyIdentifier field's value.
func (s *ReEncryptDataInput) SetOutgoingKeyIdentifier(v string) *ReEncryptDataInput {
	s.OutgoingKeyIdentifier = &v
	return s
}

type ReEncryptDataOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted ciphertext.
	//
	// CipherText is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ReEncryptDataOutput's
	// String and GoString methods.
	//
	// CipherText is a required field
	CipherText *string `min:"16" type:"string" required:"true" sensitive:"true"`

	// The keyARN (Amazon Resource Name) of the encryption key that Amazon Web Services
	// Payment Cryptography uses for plaintext encryption.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptDataOutput) GoString() string {
	return s.String()
}

// SetCipherText sets the CipherText field's value.
func (s *ReEncryptDataOutput) SetCipherText(v string) *ReEncryptDataOutput {
	s.CipherText = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *ReEncryptDataOutput) SetKeyArn(v string) *ReEncryptDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *ReEncryptDataOutput) SetKeyCheckValue(v string) *ReEncryptDataOutput {
	s.KeyCheckValue = &v
	return s
}

// Parameters that are required to perform reencryption operation.
type ReEncryptionAttributes struct {
	_ struct{} `type:"structure"`

	// Parameters that are required to encrypt plaintext data using DUKPT.
	Dukpt *DukptEncryptionAttributes `type:"structure"`

	// Parameters that are required to encrypt data using symmetric keys.
	Symmetric *SymmetricEncryptionAttributes `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReEncryptionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReEncryptionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReEncryptionAttributes"}
	if s.Dukpt != nil {
		if err := s.Dukpt.Validate(); err != nil {
			invalidParams.AddNested("Dukpt", err.(request.ErrInvalidParams))
		}
	}
	if s.Symmetric != nil {
		if err := s.Symmetric.Validate(); err != nil {
			invalidParams.AddNested("Symmetric", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukpt sets the Dukpt field's value.
func (s *ReEncryptionAttributes) SetDukpt(v *DukptEncryptionAttributes) *ReEncryptionAttributes {
	s.Dukpt = v
	return s
}

// SetSymmetric sets the Symmetric field's value.
func (s *ReEncryptionAttributes) SetSymmetric(v *SymmetricEncryptionAttributes) *ReEncryptionAttributes {
	s.Symmetric = v
	return s
}

// The request was denied due to an invalid resource error.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The resource that is missing.
	ResourceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Parameters to derive session key for an Amex payment card.
type SessionKeyAmex struct {
	_ struct{} `type:"structure"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SessionKeyAmex's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyAmex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyAmex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyAmex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyAmex"}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *SessionKeyAmex) SetPanSequenceNumber(v string) *SessionKeyAmex {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *SessionKeyAmex) SetPrimaryAccountNumber(v string) *SessionKeyAmex {
	s.PrimaryAccountNumber = &v
	return s
}

// Parameters to derive a session key for Authorization Response Cryptogram
// (ARQC) verification.
type SessionKeyDerivation struct {
	_ struct{} `type:"structure"`

	// Parameters to derive session key for an Amex payment card for ARQC verification.
	Amex *SessionKeyAmex `type:"structure"`

	// Parameters to derive session key for an Emv2000 payment card for ARQC verification.
	Emv2000 *SessionKeyEmv2000 `type:"structure"`

	// Parameters to derive session key for an Emv common payment card for ARQC
	// verification.
	EmvCommon *SessionKeyEmvCommon `type:"structure"`

	// Parameters to derive session key for a Mastercard payment card for ARQC verification.
	Mastercard *SessionKeyMastercard `type:"structure"`

	// Parameters to derive session key for a Visa payment cardfor ARQC verification.
	Visa *SessionKeyVisa `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyDerivation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyDerivation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyDerivation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyDerivation"}
	if s.Amex != nil {
		if err := s.Amex.Validate(); err != nil {
			invalidParams.AddNested("Amex", err.(request.ErrInvalidParams))
		}
	}
	if s.Emv2000 != nil {
		if err := s.Emv2000.Validate(); err != nil {
			invalidParams.AddNested("Emv2000", err.(request.ErrInvalidParams))
		}
	}
	if s.EmvCommon != nil {
		if err := s.EmvCommon.Validate(); err != nil {
			invalidParams.AddNested("EmvCommon", err.(request.ErrInvalidParams))
		}
	}
	if s.Mastercard != nil {
		if err := s.Mastercard.Validate(); err != nil {
			invalidParams.AddNested("Mastercard", err.(request.ErrInvalidParams))
		}
	}
	if s.Visa != nil {
		if err := s.Visa.Validate(); err != nil {
			invalidParams.AddNested("Visa", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmex sets the Amex field's value.
func (s *SessionKeyDerivation) SetAmex(v *SessionKeyAmex) *SessionKeyDerivation {
	s.Amex = v
	return s
}

// SetEmv2000 sets the Emv2000 field's value.
func (s *SessionKeyDerivation) SetEmv2000(v *SessionKeyEmv2000) *SessionKeyDerivation {
	s.Emv2000 = v
	return s
}

// SetEmvCommon sets the EmvCommon field's value.
func (s *SessionKeyDerivation) SetEmvCommon(v *SessionKeyEmvCommon) *SessionKeyDerivation {
	s.EmvCommon = v
	return s
}

// SetMastercard sets the Mastercard field's value.
func (s *SessionKeyDerivation) SetMastercard(v *SessionKeyMastercard) *SessionKeyDerivation {
	s.Mastercard = v
	return s
}

// SetVisa sets the Visa field's value.
func (s *SessionKeyDerivation) SetVisa(v *SessionKeyVisa) *SessionKeyDerivation {
	s.Visa = v
	return s
}

// Parameters to derive session key value using a MAC EMV algorithm.
type SessionKeyDerivationValue struct {
	_ struct{} `type:"structure"`

	// The cryptogram provided by the terminal during transaction processing.
	ApplicationCryptogram *string `min:"16" type:"string"`

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	ApplicationTransactionCounter *string `min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyDerivationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyDerivationValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyDerivationValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyDerivationValue"}
	if s.ApplicationCryptogram != nil && len(*s.ApplicationCryptogram) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationCryptogram", 16))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationCryptogram sets the ApplicationCryptogram field's value.
func (s *SessionKeyDerivationValue) SetApplicationCryptogram(v string) *SessionKeyDerivationValue {
	s.ApplicationCryptogram = &v
	return s
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *SessionKeyDerivationValue) SetApplicationTransactionCounter(v string) *SessionKeyDerivationValue {
	s.ApplicationTransactionCounter = &v
	return s
}

// Parameters to derive session key for an Emv2000 payment card for ARQC verification.
type SessionKeyEmv2000 struct {
	_ struct{} `type:"structure"`

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SessionKeyEmv2000's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyEmv2000) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyEmv2000) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyEmv2000) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyEmv2000"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *SessionKeyEmv2000) SetApplicationTransactionCounter(v string) *SessionKeyEmv2000 {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *SessionKeyEmv2000) SetPanSequenceNumber(v string) *SessionKeyEmv2000 {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *SessionKeyEmv2000) SetPrimaryAccountNumber(v string) *SessionKeyEmv2000 {
	s.PrimaryAccountNumber = &v
	return s
}

// Parameters to derive session key for an Emv common payment card for ARQC
// verification.
type SessionKeyEmvCommon struct {
	_ struct{} `type:"structure"`

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SessionKeyEmvCommon's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyEmvCommon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyEmvCommon) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyEmvCommon) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyEmvCommon"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *SessionKeyEmvCommon) SetApplicationTransactionCounter(v string) *SessionKeyEmvCommon {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *SessionKeyEmvCommon) SetPanSequenceNumber(v string) *SessionKeyEmvCommon {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *SessionKeyEmvCommon) SetPrimaryAccountNumber(v string) *SessionKeyEmvCommon {
	s.PrimaryAccountNumber = &v
	return s
}

// Parameters to derive session key for Mastercard payment card for ARQC verification.
type SessionKeyMastercard struct {
	_ struct{} `type:"structure"`

	// The transaction counter that is provided by the terminal during transaction
	// processing.
	//
	// ApplicationTransactionCounter is a required field
	ApplicationTransactionCounter *string `min:"2" type:"string" required:"true"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SessionKeyMastercard's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// A random number generated by the issuer.
	//
	// UnpredictableNumber is a required field
	UnpredictableNumber *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyMastercard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyMastercard) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyMastercard) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyMastercard"}
	if s.ApplicationTransactionCounter == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if s.ApplicationTransactionCounter != nil && len(*s.ApplicationTransactionCounter) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationTransactionCounter", 2))
	}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.UnpredictableNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("UnpredictableNumber"))
	}
	if s.UnpredictableNumber != nil && len(*s.UnpredictableNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnpredictableNumber", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationTransactionCounter sets the ApplicationTransactionCounter field's value.
func (s *SessionKeyMastercard) SetApplicationTransactionCounter(v string) *SessionKeyMastercard {
	s.ApplicationTransactionCounter = &v
	return s
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *SessionKeyMastercard) SetPanSequenceNumber(v string) *SessionKeyMastercard {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *SessionKeyMastercard) SetPrimaryAccountNumber(v string) *SessionKeyMastercard {
	s.PrimaryAccountNumber = &v
	return s
}

// SetUnpredictableNumber sets the UnpredictableNumber field's value.
func (s *SessionKeyMastercard) SetUnpredictableNumber(v string) *SessionKeyMastercard {
	s.UnpredictableNumber = &v
	return s
}

// Parameters to derive session key for Visa payment card for ARQC verification.
type SessionKeyVisa struct {
	_ struct{} `type:"structure"`

	// A number that identifies and differentiates payment cards with the same Primary
	// Account Number (PAN).
	//
	// PanSequenceNumber is a required field
	PanSequenceNumber *string `min:"2" type:"string" required:"true"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SessionKeyVisa's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyVisa) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SessionKeyVisa) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SessionKeyVisa) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SessionKeyVisa"}
	if s.PanSequenceNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PanSequenceNumber"))
	}
	if s.PanSequenceNumber != nil && len(*s.PanSequenceNumber) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("PanSequenceNumber", 2))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPanSequenceNumber sets the PanSequenceNumber field's value.
func (s *SessionKeyVisa) SetPanSequenceNumber(v string) *SessionKeyVisa {
	s.PanSequenceNumber = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *SessionKeyVisa) SetPrimaryAccountNumber(v string) *SessionKeyVisa {
	s.PrimaryAccountNumber = &v
	return s
}

// Parameters requried to encrypt plaintext data using symmetric keys.
type SymmetricEncryptionAttributes struct {
	_ struct{} `type:"structure"`

	// An input used to provide the intial state. If no value is provided, Amazon
	// Web Services Payment Cryptography defaults it to zero.
	//
	// InitializationVector is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SymmetricEncryptionAttributes's
	// String and GoString methods.
	InitializationVector *string `min:"16" type:"string" sensitive:"true"`

	// The block cipher method to use for encryption.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"EncryptionMode"`

	// The padding to be included with the data.
	PaddingType *string `type:"string" enum:"PaddingType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SymmetricEncryptionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SymmetricEncryptionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SymmetricEncryptionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SymmetricEncryptionAttributes"}
	if s.InitializationVector != nil && len(*s.InitializationVector) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("InitializationVector", 16))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInitializationVector sets the InitializationVector field's value.
func (s *SymmetricEncryptionAttributes) SetInitializationVector(v string) *SymmetricEncryptionAttributes {
	s.InitializationVector = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *SymmetricEncryptionAttributes) SetMode(v string) *SymmetricEncryptionAttributes {
	s.Mode = &v
	return s
}

// SetPaddingType sets the PaddingType field's value.
func (s *SymmetricEncryptionAttributes) SetPaddingType(v string) *SymmetricEncryptionAttributes {
	s.PaddingType = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TranslatePinDataInput struct {
	_ struct{} `type:"structure"`

	// The encrypted PIN block data that Amazon Web Services Payment Cryptography
	// translates.
	//
	// EncryptedPinBlock is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TranslatePinDataInput's
	// String and GoString methods.
	//
	// EncryptedPinBlock is a required field
	EncryptedPinBlock *string `min:"16" type:"string" required:"true" sensitive:"true"`

	// The attributes and values to use for incoming DUKPT encryption key for PIN
	// block translation.
	IncomingDukptAttributes *DukptDerivationAttributes `type:"structure"`

	// The keyARN of the encryption key under which incoming PIN block data is encrypted.
	// This key type can be PEK or BDK.
	//
	// IncomingKeyIdentifier is a required field
	IncomingKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The format of the incoming PIN block data for translation within Amazon Web
	// Services Payment Cryptography.
	//
	// IncomingTranslationAttributes is a required field
	IncomingTranslationAttributes *TranslationIsoFormats `type:"structure" required:"true"`

	// The attributes and values to use for outgoing DUKPT encryption key after
	// PIN block translation.
	OutgoingDukptAttributes *DukptDerivationAttributes `type:"structure"`

	// The keyARN of the encryption key for encrypting outgoing PIN block data.
	// This key type can be PEK or BDK.
	//
	// OutgoingKeyIdentifier is a required field
	OutgoingKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The format of the outgoing PIN block data after translation by Amazon Web
	// Services Payment Cryptography.
	//
	// OutgoingTranslationAttributes is a required field
	OutgoingTranslationAttributes *TranslationIsoFormats `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslatePinDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslatePinDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranslatePinDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranslatePinDataInput"}
	if s.EncryptedPinBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedPinBlock"))
	}
	if s.EncryptedPinBlock != nil && len(*s.EncryptedPinBlock) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedPinBlock", 16))
	}
	if s.IncomingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("IncomingKeyIdentifier"))
	}
	if s.IncomingKeyIdentifier != nil && len(*s.IncomingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("IncomingKeyIdentifier", 7))
	}
	if s.IncomingTranslationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("IncomingTranslationAttributes"))
	}
	if s.OutgoingKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OutgoingKeyIdentifier"))
	}
	if s.OutgoingKeyIdentifier != nil && len(*s.OutgoingKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("OutgoingKeyIdentifier", 7))
	}
	if s.OutgoingTranslationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("OutgoingTranslationAttributes"))
	}
	if s.IncomingDukptAttributes != nil {
		if err := s.IncomingDukptAttributes.Validate(); err != nil {
			invalidParams.AddNested("IncomingDukptAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.IncomingTranslationAttributes != nil {
		if err := s.IncomingTranslationAttributes.Validate(); err != nil {
			invalidParams.AddNested("IncomingTranslationAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.OutgoingDukptAttributes != nil {
		if err := s.OutgoingDukptAttributes.Validate(); err != nil {
			invalidParams.AddNested("OutgoingDukptAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.OutgoingTranslationAttributes != nil {
		if err := s.OutgoingTranslationAttributes.Validate(); err != nil {
			invalidParams.AddNested("OutgoingTranslationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptedPinBlock sets the EncryptedPinBlock field's value.
func (s *TranslatePinDataInput) SetEncryptedPinBlock(v string) *TranslatePinDataInput {
	s.EncryptedPinBlock = &v
	return s
}

// SetIncomingDukptAttributes sets the IncomingDukptAttributes field's value.
func (s *TranslatePinDataInput) SetIncomingDukptAttributes(v *DukptDerivationAttributes) *TranslatePinDataInput {
	s.IncomingDukptAttributes = v
	return s
}

// SetIncomingKeyIdentifier sets the IncomingKeyIdentifier field's value.
func (s *TranslatePinDataInput) SetIncomingKeyIdentifier(v string) *TranslatePinDataInput {
	s.IncomingKeyIdentifier = &v
	return s
}

// SetIncomingTranslationAttributes sets the IncomingTranslationAttributes field's value.
func (s *TranslatePinDataInput) SetIncomingTranslationAttributes(v *TranslationIsoFormats) *TranslatePinDataInput {
	s.IncomingTranslationAttributes = v
	return s
}

// SetOutgoingDukptAttributes sets the OutgoingDukptAttributes field's value.
func (s *TranslatePinDataInput) SetOutgoingDukptAttributes(v *DukptDerivationAttributes) *TranslatePinDataInput {
	s.OutgoingDukptAttributes = v
	return s
}

// SetOutgoingKeyIdentifier sets the OutgoingKeyIdentifier field's value.
func (s *TranslatePinDataInput) SetOutgoingKeyIdentifier(v string) *TranslatePinDataInput {
	s.OutgoingKeyIdentifier = &v
	return s
}

// SetOutgoingTranslationAttributes sets the OutgoingTranslationAttributes field's value.
func (s *TranslatePinDataInput) SetOutgoingTranslationAttributes(v *TranslationIsoFormats) *TranslatePinDataInput {
	s.OutgoingTranslationAttributes = v
	return s
}

type TranslatePinDataOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses to encrypt outgoing PIN block data after translation.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The outgoing encrypted PIN block data after translation.
	//
	// PinBlock is a required field
	PinBlock *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslatePinDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslatePinDataOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *TranslatePinDataOutput) SetKeyArn(v string) *TranslatePinDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *TranslatePinDataOutput) SetKeyCheckValue(v string) *TranslatePinDataOutput {
	s.KeyCheckValue = &v
	return s
}

// SetPinBlock sets the PinBlock field's value.
func (s *TranslatePinDataOutput) SetPinBlock(v string) *TranslatePinDataOutput {
	s.PinBlock = &v
	return s
}

// Parameters that are required for translation between ISO9564 PIN block formats
// 0,1,3,4.
type TranslationIsoFormats struct {
	_ struct{} `type:"structure"`

	// Parameters that are required for ISO9564 PIN format 0 tranlation.
	IsoFormat0 *TranslationPinDataIsoFormat034 `type:"structure"`

	// Parameters that are required for ISO9564 PIN format 1 tranlation.
	IsoFormat1 *TranslationPinDataIsoFormat1 `type:"structure"`

	// Parameters that are required for ISO9564 PIN format 3 tranlation.
	IsoFormat3 *TranslationPinDataIsoFormat034 `type:"structure"`

	// Parameters that are required for ISO9564 PIN format 4 tranlation.
	IsoFormat4 *TranslationPinDataIsoFormat034 `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationIsoFormats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationIsoFormats) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranslationIsoFormats) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranslationIsoFormats"}
	if s.IsoFormat0 != nil {
		if err := s.IsoFormat0.Validate(); err != nil {
			invalidParams.AddNested("IsoFormat0", err.(request.ErrInvalidParams))
		}
	}
	if s.IsoFormat3 != nil {
		if err := s.IsoFormat3.Validate(); err != nil {
			invalidParams.AddNested("IsoFormat3", err.(request.ErrInvalidParams))
		}
	}
	if s.IsoFormat4 != nil {
		if err := s.IsoFormat4.Validate(); err != nil {
			invalidParams.AddNested("IsoFormat4", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIsoFormat0 sets the IsoFormat0 field's value.
func (s *TranslationIsoFormats) SetIsoFormat0(v *TranslationPinDataIsoFormat034) *TranslationIsoFormats {
	s.IsoFormat0 = v
	return s
}

// SetIsoFormat1 sets the IsoFormat1 field's value.
func (s *TranslationIsoFormats) SetIsoFormat1(v *TranslationPinDataIsoFormat1) *TranslationIsoFormats {
	s.IsoFormat1 = v
	return s
}

// SetIsoFormat3 sets the IsoFormat3 field's value.
func (s *TranslationIsoFormats) SetIsoFormat3(v *TranslationPinDataIsoFormat034) *TranslationIsoFormats {
	s.IsoFormat3 = v
	return s
}

// SetIsoFormat4 sets the IsoFormat4 field's value.
func (s *TranslationIsoFormats) SetIsoFormat4(v *TranslationPinDataIsoFormat034) *TranslationIsoFormats {
	s.IsoFormat4 = v
	return s
}

// Parameters that are required for tranlation between ISO9564 PIN format 0,3,4
// tranlation.
type TranslationPinDataIsoFormat034 struct {
	_ struct{} `type:"structure"`

	// The Primary Account Number (PAN) of the cardholder. A PAN is a unique identifier
	// for a payment credit or debit card and associates the card to a specific
	// account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TranslationPinDataIsoFormat034's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationPinDataIsoFormat034) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationPinDataIsoFormat034) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranslationPinDataIsoFormat034) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranslationPinDataIsoFormat034"}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *TranslationPinDataIsoFormat034) SetPrimaryAccountNumber(v string) *TranslationPinDataIsoFormat034 {
	s.PrimaryAccountNumber = &v
	return s
}

// Parameters that are required for ISO9564 PIN format 1 tranlation.
type TranslationPinDataIsoFormat1 struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationPinDataIsoFormat1) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranslationPinDataIsoFormat1) GoString() string {
	return s.String()
}

// The request was denied due to an invalid request error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The request was denied due to an invalid request error.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was denied due to an invalid request error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The request was denied due to an invalid request error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The request was denied due to an invalid request error.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ValidationExceptionField) SetPath(v string) *ValidationExceptionField {
	s.Path = &v
	return s
}

// This request failed verification.
type VerificationFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The reason for the exception.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true" enum:"VerificationFailedReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerificationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerificationFailedException) GoString() string {
	return s.String()
}

func newErrorVerificationFailedException(v protocol.ResponseMetadata) error {
	return &VerificationFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *VerificationFailedException) Code() string {
	return "VerificationFailedException"
}

// Message returns the exception's message.
func (s *VerificationFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *VerificationFailedException) OrigErr() error {
	return nil
}

func (s *VerificationFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *VerificationFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *VerificationFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type VerifyAuthRequestCryptogramInput struct {
	_ struct{} `type:"structure"`

	// The auth request cryptogram imported into Amazon Web Services Payment Cryptography
	// for ARQC verification using a major encryption key and transaction data.
	//
	// AuthRequestCryptogram is a required field
	AuthRequestCryptogram *string `min:"16" type:"string" required:"true"`

	// The attributes and values for auth request cryptogram verification. These
	// parameters are required in case using ARPC Method 1 or Method 2 for ARQC
	// verification.
	AuthResponseAttributes *CryptogramAuthResponse `type:"structure"`

	// The keyARN of the major encryption key that Amazon Web Services Payment Cryptography
	// uses for ARQC verification.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The method to use when deriving the major encryption key for ARQC verification
	// within Amazon Web Services Payment Cryptography. The same key derivation
	// mode was used for ARQC generation outside of Amazon Web Services Payment
	// Cryptography.
	//
	// MajorKeyDerivationMode is a required field
	MajorKeyDerivationMode *string `type:"string" required:"true" enum:"MajorKeyDerivationMode"`

	// The attributes and values to use for deriving a session key for ARQC verification
	// within Amazon Web Services Payment Cryptography. The same attributes were
	// used for ARQC generation outside of Amazon Web Services Payment Cryptography.
	//
	// SessionKeyDerivationAttributes is a required field
	SessionKeyDerivationAttributes *SessionKeyDerivation `type:"structure" required:"true"`

	// The transaction data that Amazon Web Services Payment Cryptography uses for
	// ARQC verification. The same transaction is used for ARQC generation outside
	// of Amazon Web Services Payment Cryptography.
	//
	// TransactionData is a required field
	TransactionData *string `min:"2" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyAuthRequestCryptogramInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyAuthRequestCryptogramInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyAuthRequestCryptogramInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyAuthRequestCryptogramInput"}
	if s.AuthRequestCryptogram == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthRequestCryptogram"))
	}
	if s.AuthRequestCryptogram != nil && len(*s.AuthRequestCryptogram) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("AuthRequestCryptogram", 16))
	}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.MajorKeyDerivationMode == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorKeyDerivationMode"))
	}
	if s.SessionKeyDerivationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionKeyDerivationAttributes"))
	}
	if s.TransactionData == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionData"))
	}
	if s.TransactionData != nil && len(*s.TransactionData) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionData", 2))
	}
	if s.AuthResponseAttributes != nil {
		if err := s.AuthResponseAttributes.Validate(); err != nil {
			invalidParams.AddNested("AuthResponseAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.SessionKeyDerivationAttributes != nil {
		if err := s.SessionKeyDerivationAttributes.Validate(); err != nil {
			invalidParams.AddNested("SessionKeyDerivationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthRequestCryptogram sets the AuthRequestCryptogram field's value.
func (s *VerifyAuthRequestCryptogramInput) SetAuthRequestCryptogram(v string) *VerifyAuthRequestCryptogramInput {
	s.AuthRequestCryptogram = &v
	return s
}

// SetAuthResponseAttributes sets the AuthResponseAttributes field's value.
func (s *VerifyAuthRequestCryptogramInput) SetAuthResponseAttributes(v *CryptogramAuthResponse) *VerifyAuthRequestCryptogramInput {
	s.AuthResponseAttributes = v
	return s
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *VerifyAuthRequestCryptogramInput) SetKeyIdentifier(v string) *VerifyAuthRequestCryptogramInput {
	s.KeyIdentifier = &v
	return s
}

// SetMajorKeyDerivationMode sets the MajorKeyDerivationMode field's value.
func (s *VerifyAuthRequestCryptogramInput) SetMajorKeyDerivationMode(v string) *VerifyAuthRequestCryptogramInput {
	s.MajorKeyDerivationMode = &v
	return s
}

// SetSessionKeyDerivationAttributes sets the SessionKeyDerivationAttributes field's value.
func (s *VerifyAuthRequestCryptogramInput) SetSessionKeyDerivationAttributes(v *SessionKeyDerivation) *VerifyAuthRequestCryptogramInput {
	s.SessionKeyDerivationAttributes = v
	return s
}

// SetTransactionData sets the TransactionData field's value.
func (s *VerifyAuthRequestCryptogramInput) SetTransactionData(v string) *VerifyAuthRequestCryptogramInput {
	s.TransactionData = &v
	return s
}

type VerifyAuthRequestCryptogramOutput struct {
	_ struct{} `type:"structure"`

	// The result for ARQC verification or ARPC generation within Amazon Web Services
	// Payment Cryptography.
	AuthResponseValue *string `min:"1" type:"string"`

	// The keyARN of the major encryption key that Amazon Web Services Payment Cryptography
	// uses for ARQC verification.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyAuthRequestCryptogramOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyAuthRequestCryptogramOutput) GoString() string {
	return s.String()
}

// SetAuthResponseValue sets the AuthResponseValue field's value.
func (s *VerifyAuthRequestCryptogramOutput) SetAuthResponseValue(v string) *VerifyAuthRequestCryptogramOutput {
	s.AuthResponseValue = &v
	return s
}

// SetKeyArn sets the KeyArn field's value.
func (s *VerifyAuthRequestCryptogramOutput) SetKeyArn(v string) *VerifyAuthRequestCryptogramOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *VerifyAuthRequestCryptogramOutput) SetKeyCheckValue(v string) *VerifyAuthRequestCryptogramOutput {
	s.KeyCheckValue = &v
	return s
}

type VerifyCardValidationDataInput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the CVK encryption key that Amazon Web Services Payment Cryptography
	// uses to verify card data.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card that associates the card with a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyCardValidationDataInput's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// The CVV or CSC value for use for card data verification within Amazon Web
	// Services Payment Cryptography.
	//
	// ValidationData is a required field
	ValidationData *string `min:"3" type:"string" required:"true"`

	// The algorithm to use for verification of card data within Amazon Web Services
	// Payment Cryptography.
	//
	// VerificationAttributes is a required field
	VerificationAttributes *CardVerificationAttributes `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyCardValidationDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyCardValidationDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyCardValidationDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyCardValidationDataInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.ValidationData == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationData"))
	}
	if s.ValidationData != nil && len(*s.ValidationData) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ValidationData", 3))
	}
	if s.VerificationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationAttributes"))
	}
	if s.VerificationAttributes != nil {
		if err := s.VerificationAttributes.Validate(); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *VerifyCardValidationDataInput) SetKeyIdentifier(v string) *VerifyCardValidationDataInput {
	s.KeyIdentifier = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *VerifyCardValidationDataInput) SetPrimaryAccountNumber(v string) *VerifyCardValidationDataInput {
	s.PrimaryAccountNumber = &v
	return s
}

// SetValidationData sets the ValidationData field's value.
func (s *VerifyCardValidationDataInput) SetValidationData(v string) *VerifyCardValidationDataInput {
	s.ValidationData = &v
	return s
}

// SetVerificationAttributes sets the VerificationAttributes field's value.
func (s *VerifyCardValidationDataInput) SetVerificationAttributes(v *CardVerificationAttributes) *VerifyCardValidationDataInput {
	s.VerificationAttributes = v
	return s
}

type VerifyCardValidationDataOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the CVK encryption key that Amazon Web Services Payment Cryptography
	// uses to verify CVV or CSC.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyCardValidationDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyCardValidationDataOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *VerifyCardValidationDataOutput) SetKeyArn(v string) *VerifyCardValidationDataOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *VerifyCardValidationDataOutput) SetKeyCheckValue(v string) *VerifyCardValidationDataOutput {
	s.KeyCheckValue = &v
	return s
}

type VerifyMacInput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses to verify MAC data.
	//
	// KeyIdentifier is a required field
	KeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The MAC being verified.
	//
	// Mac is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyMacInput's
	// String and GoString methods.
	//
	// Mac is a required field
	Mac *string `min:"4" type:"string" required:"true" sensitive:"true"`

	// The length of the MAC.
	MacLength *int64 `min:"4" type:"integer"`

	// The data on for which MAC is under verification. This value must be hexBinary.
	//
	// MessageData is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyMacInput's
	// String and GoString methods.
	//
	// MessageData is a required field
	MessageData *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The attributes and data values to use for MAC verification within Amazon
	// Web Services Payment Cryptography.
	//
	// VerificationAttributes is a required field
	VerificationAttributes *MacAttributes `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyMacInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyMacInput"}
	if s.KeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyIdentifier"))
	}
	if s.KeyIdentifier != nil && len(*s.KeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("KeyIdentifier", 7))
	}
	if s.Mac == nil {
		invalidParams.Add(request.NewErrParamRequired("Mac"))
	}
	if s.Mac != nil && len(*s.Mac) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("Mac", 4))
	}
	if s.MacLength != nil && *s.MacLength < 4 {
		invalidParams.Add(request.NewErrParamMinValue("MacLength", 4))
	}
	if s.MessageData == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageData"))
	}
	if s.MessageData != nil && len(*s.MessageData) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MessageData", 2))
	}
	if s.VerificationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationAttributes"))
	}
	if s.VerificationAttributes != nil {
		if err := s.VerificationAttributes.Validate(); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyIdentifier sets the KeyIdentifier field's value.
func (s *VerifyMacInput) SetKeyIdentifier(v string) *VerifyMacInput {
	s.KeyIdentifier = &v
	return s
}

// SetMac sets the Mac field's value.
func (s *VerifyMacInput) SetMac(v string) *VerifyMacInput {
	s.Mac = &v
	return s
}

// SetMacLength sets the MacLength field's value.
func (s *VerifyMacInput) SetMacLength(v int64) *VerifyMacInput {
	s.MacLength = &v
	return s
}

// SetMessageData sets the MessageData field's value.
func (s *VerifyMacInput) SetMessageData(v string) *VerifyMacInput {
	s.MessageData = &v
	return s
}

// SetVerificationAttributes sets the VerificationAttributes field's value.
func (s *VerifyMacInput) SetVerificationAttributes(v *MacAttributes) *VerifyMacInput {
	s.VerificationAttributes = v
	return s
}

type VerifyMacOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses for MAC verification.
	//
	// KeyArn is a required field
	KeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// KeyCheckValue is a required field
	KeyCheckValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyMacOutput) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *VerifyMacOutput) SetKeyArn(v string) *VerifyMacOutput {
	s.KeyArn = &v
	return s
}

// SetKeyCheckValue sets the KeyCheckValue field's value.
func (s *VerifyMacOutput) SetKeyCheckValue(v string) *VerifyMacOutput {
	s.KeyCheckValue = &v
	return s
}

type VerifyPinDataInput struct {
	_ struct{} `type:"structure"`

	// The attributes and values for the DUKPT encrypted PIN block data.
	DukptAttributes *DukptAttributes `type:"structure"`

	// The encrypted PIN block data that Amazon Web Services Payment Cryptography
	// verifies.
	//
	// EncryptedPinBlock is a required field
	EncryptedPinBlock *string `min:"16" type:"string" required:"true"`

	// The keyARN of the encryption key under which the PIN block data is encrypted.
	// This key type can be PEK or BDK.
	//
	// EncryptionKeyIdentifier is a required field
	EncryptionKeyIdentifier *string `min:"7" type:"string" required:"true"`

	// The PIN encoding format for pin data generation as specified in ISO 9564.
	// Amazon Web Services Payment Cryptography supports ISO_Format_0 and ISO_Format_3.
	//
	// The ISO_Format_0 PIN block format is equivalent to the ANSI X9.8, VISA-1,
	// and ECI-1 PIN block formats. It is similar to a VISA-4 PIN block format.
	// It supports a PIN from 4 to 12 digits in length.
	//
	// The ISO_Format_3 PIN block format is the same as ISO_Format_0 except that
	// the fill digits are random values from 10 to 15.
	//
	// PinBlockFormat is a required field
	PinBlockFormat *string `type:"string" required:"true" enum:"PinBlockFormatForPinData"`

	// The length of PIN being verified.
	PinDataLength *int64 `min:"4" type:"integer"`

	// The Primary Account Number (PAN), a unique identifier for a payment credit
	// or debit card that associates the card with a specific account holder.
	//
	// PrimaryAccountNumber is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by VerifyPinDataInput's
	// String and GoString methods.
	//
	// PrimaryAccountNumber is a required field
	PrimaryAccountNumber *string `min:"12" type:"string" required:"true" sensitive:"true"`

	// The attributes and values for PIN data verification.
	//
	// VerificationAttributes is a required field
	VerificationAttributes *PinVerificationAttributes `type:"structure" required:"true"`

	// The keyARN of the PIN verification key.
	//
	// VerificationKeyIdentifier is a required field
	VerificationKeyIdentifier *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyPinDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyPinDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyPinDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyPinDataInput"}
	if s.EncryptedPinBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedPinBlock"))
	}
	if s.EncryptedPinBlock != nil && len(*s.EncryptedPinBlock) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedPinBlock", 16))
	}
	if s.EncryptionKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionKeyIdentifier"))
	}
	if s.EncryptionKeyIdentifier != nil && len(*s.EncryptionKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKeyIdentifier", 7))
	}
	if s.PinBlockFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("PinBlockFormat"))
	}
	if s.PinDataLength != nil && *s.PinDataLength < 4 {
		invalidParams.Add(request.NewErrParamMinValue("PinDataLength", 4))
	}
	if s.PrimaryAccountNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if s.PrimaryAccountNumber != nil && len(*s.PrimaryAccountNumber) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("PrimaryAccountNumber", 12))
	}
	if s.VerificationAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationAttributes"))
	}
	if s.VerificationKeyIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationKeyIdentifier"))
	}
	if s.VerificationKeyIdentifier != nil && len(*s.VerificationKeyIdentifier) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("VerificationKeyIdentifier", 7))
	}
	if s.DukptAttributes != nil {
		if err := s.DukptAttributes.Validate(); err != nil {
			invalidParams.AddNested("DukptAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.VerificationAttributes != nil {
		if err := s.VerificationAttributes.Validate(); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDukptAttributes sets the DukptAttributes field's value.
func (s *VerifyPinDataInput) SetDukptAttributes(v *DukptAttributes) *VerifyPinDataInput {
	s.DukptAttributes = v
	return s
}

// SetEncryptedPinBlock sets the EncryptedPinBlock field's value.
func (s *VerifyPinDataInput) SetEncryptedPinBlock(v string) *VerifyPinDataInput {
	s.EncryptedPinBlock = &v
	return s
}

// SetEncryptionKeyIdentifier sets the EncryptionKeyIdentifier field's value.
func (s *VerifyPinDataInput) SetEncryptionKeyIdentifier(v string) *VerifyPinDataInput {
	s.EncryptionKeyIdentifier = &v
	return s
}

// SetPinBlockFormat sets the PinBlockFormat field's value.
func (s *VerifyPinDataInput) SetPinBlockFormat(v string) *VerifyPinDataInput {
	s.PinBlockFormat = &v
	return s
}

// SetPinDataLength sets the PinDataLength field's value.
func (s *VerifyPinDataInput) SetPinDataLength(v int64) *VerifyPinDataInput {
	s.PinDataLength = &v
	return s
}

// SetPrimaryAccountNumber sets the PrimaryAccountNumber field's value.
func (s *VerifyPinDataInput) SetPrimaryAccountNumber(v string) *VerifyPinDataInput {
	s.PrimaryAccountNumber = &v
	return s
}

// SetVerificationAttributes sets the VerificationAttributes field's value.
func (s *VerifyPinDataInput) SetVerificationAttributes(v *PinVerificationAttributes) *VerifyPinDataInput {
	s.VerificationAttributes = v
	return s
}

// SetVerificationKeyIdentifier sets the VerificationKeyIdentifier field's value.
func (s *VerifyPinDataInput) SetVerificationKeyIdentifier(v string) *VerifyPinDataInput {
	s.VerificationKeyIdentifier = &v
	return s
}

type VerifyPinDataOutput struct {
	_ struct{} `type:"structure"`

	// The keyARN of the PEK that Amazon Web Services Payment Cryptography uses
	// for encrypted pin block generation.
	//
	// EncryptionKeyArn is a required field
	EncryptionKeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// EncryptionKeyCheckValue is a required field
	EncryptionKeyCheckValue *string `min:"4" type:"string" required:"true"`

	// The keyARN of the PIN encryption key that Amazon Web Services Payment Cryptography
	// uses for PIN or PIN Offset verification.
	//
	// VerificationKeyArn is a required field
	VerificationKeyArn *string `min:"70" type:"string" required:"true"`

	// The key check value (KCV) of the encryption key. The KCV is used to check
	// if all parties holding a given key have the same key or to detect that a
	// key has changed.
	//
	// Amazon Web Services Payment Cryptography computes the KCV according to the
	// CMAC specification.
	//
	// VerificationKeyCheckValue is a required field
	VerificationKeyCheckValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyPinDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VerifyPinDataOutput) GoString() string {
	return s.String()
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *VerifyPinDataOutput) SetEncryptionKeyArn(v string) *VerifyPinDataOutput {
	s.EncryptionKeyArn = &v
	return s
}

// SetEncryptionKeyCheckValue sets the EncryptionKeyCheckValue field's value.
func (s *VerifyPinDataOutput) SetEncryptionKeyCheckValue(v string) *VerifyPinDataOutput {
	s.EncryptionKeyCheckValue = &v
	return s
}

// SetVerificationKeyArn sets the VerificationKeyArn field's value.
func (s *VerifyPinDataOutput) SetVerificationKeyArn(v string) *VerifyPinDataOutput {
	s.VerificationKeyArn = &v
	return s
}

// SetVerificationKeyCheckValue sets the VerificationKeyCheckValue field's value.
func (s *VerifyPinDataOutput) SetVerificationKeyCheckValue(v string) *VerifyPinDataOutput {
	s.VerificationKeyCheckValue = &v
	return s
}

// Parameters that are required to generate or verify Visa PIN.
type VisaPin struct {
	_ struct{} `type:"structure"`

	// The value for PIN verification index. It is used in the Visa PIN algorithm
	// to calculate the PVV (PIN Verification Value).
	//
	// PinVerificationKeyIndex is a required field
	PinVerificationKeyIndex *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPin) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPin) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VisaPin) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VisaPin"}
	if s.PinVerificationKeyIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("PinVerificationKeyIndex"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPinVerificationKeyIndex sets the PinVerificationKeyIndex field's value.
func (s *VisaPin) SetPinVerificationKeyIndex(v int64) *VisaPin {
	s.PinVerificationKeyIndex = &v
	return s
}

// Parameters that are required to generate or verify Visa PIN.
type VisaPinVerification struct {
	_ struct{} `type:"structure"`

	// The value for PIN verification index. It is used in the Visa PIN algorithm
	// to calculate the PVV (PIN Verification Value).
	//
	// PinVerificationKeyIndex is a required field
	PinVerificationKeyIndex *int64 `type:"integer" required:"true"`

	// Parameters that are required to generate or verify Visa PVV (PIN Verification
	// Value).
	//
	// VerificationValue is a required field
	VerificationValue *string `min:"4" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPinVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPinVerification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VisaPinVerification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VisaPinVerification"}
	if s.PinVerificationKeyIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("PinVerificationKeyIndex"))
	}
	if s.VerificationValue == nil {
		invalidParams.Add(request.NewErrParamRequired("VerificationValue"))
	}
	if s.VerificationValue != nil && len(*s.VerificationValue) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("VerificationValue", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPinVerificationKeyIndex sets the PinVerificationKeyIndex field's value.
func (s *VisaPinVerification) SetPinVerificationKeyIndex(v int64) *VisaPinVerification {
	s.PinVerificationKeyIndex = &v
	return s
}

// SetVerificationValue sets the VerificationValue field's value.
func (s *VisaPinVerification) SetVerificationValue(v string) *VisaPinVerification {
	s.VerificationValue = &v
	return s
}

// Parameters that are required to generate or verify Visa PVV (PIN Verification
// Value).
type VisaPinVerificationValue struct {
	_ struct{} `type:"structure"`

	// The encrypted PIN block data to verify.
	//
	// EncryptedPinBlock is a required field
	EncryptedPinBlock *string `min:"16" type:"string" required:"true"`

	// The value for PIN verification index. It is used in the Visa PIN algorithm
	// to calculate the PVV (PIN Verification Value).
	//
	// PinVerificationKeyIndex is a required field
	PinVerificationKeyIndex *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPinVerificationValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VisaPinVerificationValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VisaPinVerificationValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VisaPinVerificationValue"}
	if s.EncryptedPinBlock == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedPinBlock"))
	}
	if s.EncryptedPinBlock != nil && len(*s.EncryptedPinBlock) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedPinBlock", 16))
	}
	if s.PinVerificationKeyIndex == nil {
		invalidParams.Add(request.NewErrParamRequired("PinVerificationKeyIndex"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncryptedPinBlock sets the EncryptedPinBlock field's value.
func (s *VisaPinVerificationValue) SetEncryptedPinBlock(v string) *VisaPinVerificationValue {
	s.EncryptedPinBlock = &v
	return s
}

// SetPinVerificationKeyIndex sets the PinVerificationKeyIndex field's value.
func (s *VisaPinVerificationValue) SetPinVerificationKeyIndex(v int64) *VisaPinVerificationValue {
	s.PinVerificationKeyIndex = &v
	return s
}

const (
	// DukptDerivationTypeTdes2key is a DukptDerivationType enum value
	DukptDerivationTypeTdes2key = "TDES_2KEY"

	// DukptDerivationTypeTdes3key is a DukptDerivationType enum value
	DukptDerivationTypeTdes3key = "TDES_3KEY"

	// DukptDerivationTypeAes128 is a DukptDerivationType enum value
	DukptDerivationTypeAes128 = "AES_128"

	// DukptDerivationTypeAes192 is a DukptDerivationType enum value
	DukptDerivationTypeAes192 = "AES_192"

	// DukptDerivationTypeAes256 is a DukptDerivationType enum value
	DukptDerivationTypeAes256 = "AES_256"
)

// DukptDerivationType_Values returns all elements of the DukptDerivationType enum
func DukptDerivationType_Values() []string {
	return []string{
		DukptDerivationTypeTdes2key,
		DukptDerivationTypeTdes3key,
		DukptDerivationTypeAes128,
		DukptDerivationTypeAes192,
		DukptDerivationTypeAes256,
	}
}

const (
	// DukptEncryptionModeEcb is a DukptEncryptionMode enum value
	DukptEncryptionModeEcb = "ECB"

	// DukptEncryptionModeCbc is a DukptEncryptionMode enum value
	DukptEncryptionModeCbc = "CBC"
)

// DukptEncryptionMode_Values returns all elements of the DukptEncryptionMode enum
func DukptEncryptionMode_Values() []string {
	return []string{
		DukptEncryptionModeEcb,
		DukptEncryptionModeCbc,
	}
}

const (
	// DukptKeyVariantBidirectional is a DukptKeyVariant enum value
	DukptKeyVariantBidirectional = "BIDIRECTIONAL"

	// DukptKeyVariantRequest is a DukptKeyVariant enum value
	DukptKeyVariantRequest = "REQUEST"

	// DukptKeyVariantResponse is a DukptKeyVariant enum value
	DukptKeyVariantResponse = "RESPONSE"
)

// DukptKeyVariant_Values returns all elements of the DukptKeyVariant enum
func DukptKeyVariant_Values() []string {
	return []string{
		DukptKeyVariantBidirectional,
		DukptKeyVariantRequest,
		DukptKeyVariantResponse,
	}
}

const (
	// EmvEncryptionModeEcb is a EmvEncryptionMode enum value
	EmvEncryptionModeEcb = "ECB"

	// EmvEncryptionModeCbc is a EmvEncryptionMode enum value
	EmvEncryptionModeCbc = "CBC"
)

// EmvEncryptionMode_Values returns all elements of the EmvEncryptionMode enum
func EmvEncryptionMode_Values() []string {
	return []string{
		EmvEncryptionModeEcb,
		EmvEncryptionModeCbc,
	}
}

const (
	// EmvMajorKeyDerivationModeEmvOptionA is a EmvMajorKeyDerivationMode enum value
	EmvMajorKeyDerivationModeEmvOptionA = "EMV_OPTION_A"

	// EmvMajorKeyDerivationModeEmvOptionB is a EmvMajorKeyDerivationMode enum value
	EmvMajorKeyDerivationModeEmvOptionB = "EMV_OPTION_B"
)

// EmvMajorKeyDerivationMode_Values returns all elements of the EmvMajorKeyDerivationMode enum
func EmvMajorKeyDerivationMode_Values() []string {
	return []string{
		EmvMajorKeyDerivationModeEmvOptionA,
		EmvMajorKeyDerivationModeEmvOptionB,
	}
}

const (
	// EncryptionModeEcb is a EncryptionMode enum value
	EncryptionModeEcb = "ECB"

	// EncryptionModeCbc is a EncryptionMode enum value
	EncryptionModeCbc = "CBC"

	// EncryptionModeCfb is a EncryptionMode enum value
	EncryptionModeCfb = "CFB"

	// EncryptionModeCfb1 is a EncryptionMode enum value
	EncryptionModeCfb1 = "CFB1"

	// EncryptionModeCfb8 is a EncryptionMode enum value
	EncryptionModeCfb8 = "CFB8"

	// EncryptionModeCfb64 is a EncryptionMode enum value
	EncryptionModeCfb64 = "CFB64"

	// EncryptionModeCfb128 is a EncryptionMode enum value
	EncryptionModeCfb128 = "CFB128"

	// EncryptionModeOfb is a EncryptionMode enum value
	EncryptionModeOfb = "OFB"
)

// EncryptionMode_Values returns all elements of the EncryptionMode enum
func EncryptionMode_Values() []string {
	return []string{
		EncryptionModeEcb,
		EncryptionModeCbc,
		EncryptionModeCfb,
		EncryptionModeCfb1,
		EncryptionModeCfb8,
		EncryptionModeCfb64,
		EncryptionModeCfb128,
		EncryptionModeOfb,
	}
}

const (
	// MacAlgorithmIso9797Algorithm1 is a MacAlgorithm enum value
	MacAlgorithmIso9797Algorithm1 = "ISO9797_ALGORITHM1"

	// MacAlgorithmIso9797Algorithm3 is a MacAlgorithm enum value
	MacAlgorithmIso9797Algorithm3 = "ISO9797_ALGORITHM3"

	// MacAlgorithmCmac is a MacAlgorithm enum value
	MacAlgorithmCmac = "CMAC"

	// MacAlgorithmHmacSha224 is a MacAlgorithm enum value
	MacAlgorithmHmacSha224 = "HMAC_SHA224"

	// MacAlgorithmHmacSha256 is a MacAlgorithm enum value
	MacAlgorithmHmacSha256 = "HMAC_SHA256"

	// MacAlgorithmHmacSha384 is a MacAlgorithm enum value
	MacAlgorithmHmacSha384 = "HMAC_SHA384"

	// MacAlgorithmHmacSha512 is a MacAlgorithm enum value
	MacAlgorithmHmacSha512 = "HMAC_SHA512"
)

// MacAlgorithm_Values returns all elements of the MacAlgorithm enum
func MacAlgorithm_Values() []string {
	return []string{
		MacAlgorithmIso9797Algorithm1,
		MacAlgorithmIso9797Algorithm3,
		MacAlgorithmCmac,
		MacAlgorithmHmacSha224,
		MacAlgorithmHmacSha256,
		MacAlgorithmHmacSha384,
		MacAlgorithmHmacSha512,
	}
}

const (
	// MajorKeyDerivationModeEmvOptionA is a MajorKeyDerivationMode enum value
	MajorKeyDerivationModeEmvOptionA = "EMV_OPTION_A"

	// MajorKeyDerivationModeEmvOptionB is a MajorKeyDerivationMode enum value
	MajorKeyDerivationModeEmvOptionB = "EMV_OPTION_B"
)

// MajorKeyDerivationMode_Values returns all elements of the MajorKeyDerivationMode enum
func MajorKeyDerivationMode_Values() []string {
	return []string{
		MajorKeyDerivationModeEmvOptionA,
		MajorKeyDerivationModeEmvOptionB,
	}
}

const (
	// PaddingTypePkcs1 is a PaddingType enum value
	PaddingTypePkcs1 = "PKCS1"

	// PaddingTypeOaepSha1 is a PaddingType enum value
	PaddingTypeOaepSha1 = "OAEP_SHA1"

	// PaddingTypeOaepSha256 is a PaddingType enum value
	PaddingTypeOaepSha256 = "OAEP_SHA256"

	// PaddingTypeOaepSha512 is a PaddingType enum value
	PaddingTypeOaepSha512 = "OAEP_SHA512"
)

// PaddingType_Values returns all elements of the PaddingType enum
func PaddingType_Values() []string {
	return []string{
		PaddingTypePkcs1,
		PaddingTypeOaepSha1,
		PaddingTypeOaepSha256,
		PaddingTypeOaepSha512,
	}
}

const (
	// PinBlockFormatForPinDataIsoFormat0 is a PinBlockFormatForPinData enum value
	PinBlockFormatForPinDataIsoFormat0 = "ISO_FORMAT_0"

	// PinBlockFormatForPinDataIsoFormat3 is a PinBlockFormatForPinData enum value
	PinBlockFormatForPinDataIsoFormat3 = "ISO_FORMAT_3"
)

// PinBlockFormatForPinData_Values returns all elements of the PinBlockFormatForPinData enum
func PinBlockFormatForPinData_Values() []string {
	return []string{
		PinBlockFormatForPinDataIsoFormat0,
		PinBlockFormatForPinDataIsoFormat3,
	}
}

const (
	// SessionKeyDerivationModeEmvCommonSessionKey is a SessionKeyDerivationMode enum value
	SessionKeyDerivationModeEmvCommonSessionKey = "EMV_COMMON_SESSION_KEY"

	// SessionKeyDerivationModeEmv2000 is a SessionKeyDerivationMode enum value
	SessionKeyDerivationModeEmv2000 = "EMV2000"

	// SessionKeyDerivationModeAmex is a SessionKeyDerivationMode enum value
	SessionKeyDerivationModeAmex = "AMEX"

	// SessionKeyDerivationModeMastercardSessionKey is a SessionKeyDerivationMode enum value
	SessionKeyDerivationModeMastercardSessionKey = "MASTERCARD_SESSION_KEY"

	// SessionKeyDerivationModeVisa is a SessionKeyDerivationMode enum value
	SessionKeyDerivationModeVisa = "VISA"
)

// SessionKeyDerivationMode_Values returns all elements of the SessionKeyDerivationMode enum
func SessionKeyDerivationMode_Values() []string {
	return []string{
		SessionKeyDerivationModeEmvCommonSessionKey,
		SessionKeyDerivationModeEmv2000,
		SessionKeyDerivationModeAmex,
		SessionKeyDerivationModeMastercardSessionKey,
		SessionKeyDerivationModeVisa,
	}
}

const (
	// VerificationFailedReasonInvalidMac is a VerificationFailedReason enum value
	VerificationFailedReasonInvalidMac = "INVALID_MAC"

	// VerificationFailedReasonInvalidPin is a VerificationFailedReason enum value
	VerificationFailedReasonInvalidPin = "INVALID_PIN"

	// VerificationFailedReasonInvalidValidationData is a VerificationFailedReason enum value
	VerificationFailedReasonInvalidValidationData = "INVALID_VALIDATION_DATA"

	// VerificationFailedReasonInvalidAuthRequestCryptogram is a VerificationFailedReason enum value
	VerificationFailedReasonInvalidAuthRequestCryptogram = "INVALID_AUTH_REQUEST_CRYPTOGRAM"
)

// VerificationFailedReason_Values returns all elements of the VerificationFailedReason enum
func VerificationFailedReason_Values() []string {
	return []string{
		VerificationFailedReasonInvalidMac,
		VerificationFailedReasonInvalidPin,
		VerificationFailedReasonInvalidValidationData,
		VerificationFailedReasonInvalidAuthRequestCryptogram,
	}
}
