//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewdropoperation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCollectionViewDropOperation(pub NSInteger);
impl NSCollectionViewDropOperation {
    #[doc(alias = "NSCollectionViewDropOn")]
    pub const On: Self = Self(0);
    #[doc(alias = "NSCollectionViewDropBefore")]
    pub const Before: Self = Self(1);
}

unsafe impl Encode for NSCollectionViewDropOperation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSCollectionViewDropOperation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewitemhighlightstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCollectionViewItemHighlightState(pub NSInteger);
impl NSCollectionViewItemHighlightState {
    #[doc(alias = "NSCollectionViewItemHighlightNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "NSCollectionViewItemHighlightForSelection")]
    pub const ForSelection: Self = Self(1);
    #[doc(alias = "NSCollectionViewItemHighlightForDeselection")]
    pub const ForDeselection: Self = Self(2);
    #[doc(alias = "NSCollectionViewItemHighlightAsDropTarget")]
    pub const AsDropTarget: Self = Self(3);
}

unsafe impl Encode for NSCollectionViewItemHighlightState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSCollectionViewItemHighlightState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewscrollposition?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSCollectionViewScrollPosition(pub NSUInteger);
bitflags::bitflags! {
    impl NSCollectionViewScrollPosition: NSUInteger {
        #[doc(alias = "NSCollectionViewScrollPositionNone")]
        const None = 0;
        #[doc(alias = "NSCollectionViewScrollPositionTop")]
        const Top = 1<<0;
        #[doc(alias = "NSCollectionViewScrollPositionCenteredVertically")]
        const CenteredVertically = 1<<1;
        #[doc(alias = "NSCollectionViewScrollPositionBottom")]
        const Bottom = 1<<2;
        #[doc(alias = "NSCollectionViewScrollPositionNearestHorizontalEdge")]
        const NearestHorizontalEdge = 1<<9;
        #[doc(alias = "NSCollectionViewScrollPositionLeft")]
        const Left = 1<<3;
        #[doc(alias = "NSCollectionViewScrollPositionCenteredHorizontally")]
        const CenteredHorizontally = 1<<4;
        #[doc(alias = "NSCollectionViewScrollPositionRight")]
        const Right = 1<<5;
        #[doc(alias = "NSCollectionViewScrollPositionLeadingEdge")]
        const LeadingEdge = 1<<6;
        #[doc(alias = "NSCollectionViewScrollPositionTrailingEdge")]
        const TrailingEdge = 1<<7;
        #[doc(alias = "NSCollectionViewScrollPositionNearestVerticalEdge")]
        const NearestVerticalEdge = 1<<8;
    }
}

unsafe impl Encode for NSCollectionViewScrollPosition {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSCollectionViewScrollPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewsupplementaryelementkind?language=objc)
pub type NSCollectionViewSupplementaryElementKind = NSString;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewelement?language=objc)
    #[cfg(feature = "NSUserInterfaceItemIdentification")]
    pub unsafe trait NSCollectionViewElement:
        NSObjectProtocol + NSUserInterfaceItemIdentification + MainThreadOnly
    {
        #[optional]
        #[unsafe(method(prepareForReuse))]
        #[unsafe(method_family = none)]
        fn prepareForReuse(&self);

        #[cfg(feature = "NSCollectionViewLayout")]
        #[optional]
        #[unsafe(method(applyLayoutAttributes:))]
        #[unsafe(method_family = none)]
        fn applyLayoutAttributes(&self, layout_attributes: &NSCollectionViewLayoutAttributes);

        #[cfg(feature = "NSCollectionViewLayout")]
        #[optional]
        #[unsafe(method(willTransitionFromLayout:toLayout:))]
        #[unsafe(method_family = none)]
        fn willTransitionFromLayout_toLayout(
            &self,
            old_layout: &NSCollectionViewLayout,
            new_layout: &NSCollectionViewLayout,
        );

        #[cfg(feature = "NSCollectionViewLayout")]
        #[optional]
        #[unsafe(method(didTransitionFromLayout:toLayout:))]
        #[unsafe(method_family = none)]
        fn didTransitionFromLayout_toLayout(
            &self,
            old_layout: &NSCollectionViewLayout,
            new_layout: &NSCollectionViewLayout,
        );

        #[cfg(feature = "NSCollectionViewLayout")]
        #[optional]
        #[unsafe(method(preferredLayoutAttributesFittingAttributes:))]
        #[unsafe(method_family = none)]
        fn preferredLayoutAttributesFittingAttributes(
            &self,
            layout_attributes: &NSCollectionViewLayoutAttributes,
        ) -> Retained<NSCollectionViewLayoutAttributes>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewsectionheaderview?language=objc)
    #[cfg(feature = "NSUserInterfaceItemIdentification")]
    pub unsafe trait NSCollectionViewSectionHeaderView:
        NSCollectionViewElement + MainThreadOnly
    {
        #[cfg(all(
            feature = "NSButton",
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(sectionCollapseButton))]
        #[unsafe(method_family = none)]
        fn sectionCollapseButton(&self) -> Option<Retained<NSButton>>;

        #[cfg(all(
            feature = "NSButton",
            feature = "NSControl",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// Setter for [`sectionCollapseButton`][Self::sectionCollapseButton].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[optional]
        #[unsafe(method(setSectionCollapseButton:))]
        #[unsafe(method_family = none)]
        fn setSectionCollapseButton(&self, section_collapse_button: Option<&NSButton>);
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewitem?language=objc)
    #[unsafe(super(NSViewController, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
    pub struct NSCollectionViewItem;
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
extern_conformance!(
    unsafe impl NSCoding for NSCollectionViewItem {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSCollectionViewElement for NSCollectionViewItem {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
extern_conformance!(
    unsafe impl NSCopying for NSCollectionViewItem {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
unsafe impl CopyingHelper for NSCollectionViewItem {
    type Result = Self;
}

#[cfg(all(
    feature = "NSKeyValueBinding",
    feature = "NSResponder",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSEditor for NSCollectionViewItem {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionViewItem {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSStoryboardSegue",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSSeguePerforming for NSCollectionViewItem {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSViewController"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSCollectionViewItem {}
);

#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSCollectionViewItem {
    extern_methods!(
        #[cfg(feature = "NSView")]
        #[unsafe(method(collectionView))]
        #[unsafe(method_family = none)]
        pub fn collectionView(&self) -> Option<Retained<NSCollectionView>>;

        #[unsafe(method(isSelected))]
        #[unsafe(method_family = none)]
        pub fn isSelected(&self) -> bool;

        /// Setter for [`isSelected`][Self::isSelected].
        #[unsafe(method(setSelected:))]
        #[unsafe(method_family = none)]
        pub fn setSelected(&self, selected: bool);

        #[unsafe(method(highlightState))]
        #[unsafe(method_family = none)]
        pub fn highlightState(&self) -> NSCollectionViewItemHighlightState;

        /// Setter for [`highlightState`][Self::highlightState].
        #[unsafe(method(setHighlightState:))]
        #[unsafe(method_family = none)]
        pub fn setHighlightState(&self, highlight_state: NSCollectionViewItemHighlightState);

        #[cfg(all(feature = "NSControl", feature = "NSImageView", feature = "NSView"))]
        #[unsafe(method(imageView))]
        #[unsafe(method_family = none)]
        pub fn imageView(&self) -> Option<Retained<NSImageView>>;

        #[cfg(all(feature = "NSControl", feature = "NSImageView", feature = "NSView"))]
        /// Setter for [`imageView`][Self::imageView].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setImageView:))]
        #[unsafe(method_family = none)]
        pub fn setImageView(&self, image_view: Option<&NSImageView>);

        #[cfg(all(feature = "NSControl", feature = "NSTextField", feature = "NSView"))]
        #[unsafe(method(textField))]
        #[unsafe(method_family = none)]
        pub fn textField(&self) -> Option<Retained<NSTextField>>;

        #[cfg(all(feature = "NSControl", feature = "NSTextField", feature = "NSView"))]
        /// Setter for [`textField`][Self::textField].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setTextField:))]
        #[unsafe(method_family = none)]
        pub fn setTextField(&self, text_field: Option<&NSTextField>);

        #[cfg(feature = "NSDraggingItem")]
        #[unsafe(method(draggingImageComponents))]
        #[unsafe(method_family = none)]
        pub fn draggingImageComponents(&self) -> Retained<NSArray<NSDraggingImageComponent>>;
    );
}

/// Methods declared on superclass `NSViewController`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSCollectionViewItem {
    extern_methods!(
        #[cfg(feature = "NSNib")]
        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSNibName>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSCollectionViewItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSViewController"))]
impl NSCollectionViewItem {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionview?language=objc)
    #[unsafe(super(NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSResponder", feature = "NSView"))]
    pub struct NSCollectionView;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSCollectionView {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSCollectionView {}
);

#[cfg(all(feature = "NSAnimation", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSCollectionView {}
);

#[cfg(all(feature = "NSAppearance", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSCollectionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSCollectionView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSCollectionView {}
);

#[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSDraggingSource for NSCollectionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionView {}
);

#[cfg(all(
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSCollectionView {}
);

#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSCollectionView {
    extern_methods!(
        #[unsafe(method(dataSource))]
        #[unsafe(method_family = none)]
        pub fn dataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSCollectionViewDataSource>>>;

        /// Setter for [`dataSource`][Self::dataSource].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDataSource:))]
        #[unsafe(method_family = none)]
        pub fn setDataSource(
            &self,
            data_source: Option<&ProtocolObject<dyn NSCollectionViewDataSource>>,
        );

        #[unsafe(method(prefetchDataSource))]
        #[unsafe(method_family = none)]
        pub fn prefetchDataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSCollectionViewPrefetching>>>;

        /// Setter for [`prefetchDataSource`][Self::prefetchDataSource].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setPrefetchDataSource:))]
        #[unsafe(method_family = none)]
        pub fn setPrefetchDataSource(
            &self,
            prefetch_data_source: Option<&ProtocolObject<dyn NSCollectionViewPrefetching>>,
        );

        #[unsafe(method(content))]
        #[unsafe(method_family = none)]
        pub fn content(&self) -> Retained<NSArray<AnyObject>>;

        /// Setter for [`content`][Self::content].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `content` generic should be of the correct type.
        #[unsafe(method(setContent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContent(&self, content: &NSArray<AnyObject>);

        #[unsafe(method(reloadData))]
        #[unsafe(method_family = none)]
        pub fn reloadData(&self);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSCollectionViewDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSCollectionViewDelegate>>);

        #[unsafe(method(backgroundView))]
        #[unsafe(method_family = none)]
        pub fn backgroundView(&self) -> Option<Retained<NSView>>;

        /// Setter for [`backgroundView`][Self::backgroundView].
        #[unsafe(method(setBackgroundView:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundView(&self, background_view: Option<&NSView>);

        #[unsafe(method(backgroundViewScrollsWithContent))]
        #[unsafe(method_family = none)]
        pub fn backgroundViewScrollsWithContent(&self) -> bool;

        /// Setter for [`backgroundViewScrollsWithContent`][Self::backgroundViewScrollsWithContent].
        #[unsafe(method(setBackgroundViewScrollsWithContent:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundViewScrollsWithContent(
            &self,
            background_view_scrolls_with_content: bool,
        );

        #[cfg(feature = "NSCollectionViewLayout")]
        #[unsafe(method(collectionViewLayout))]
        #[unsafe(method_family = none)]
        pub fn collectionViewLayout(&self) -> Option<Retained<NSCollectionViewLayout>>;

        #[cfg(feature = "NSCollectionViewLayout")]
        /// Setter for [`collectionViewLayout`][Self::collectionViewLayout].
        #[unsafe(method(setCollectionViewLayout:))]
        #[unsafe(method_family = none)]
        pub fn setCollectionViewLayout(
            &self,
            collection_view_layout: Option<&NSCollectionViewLayout>,
        );

        #[cfg(feature = "NSCollectionViewLayout")]
        #[unsafe(method(layoutAttributesForItemAtIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn layoutAttributesForItemAtIndexPath(
            &self,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSCollectionViewLayoutAttributes>>;

        #[cfg(feature = "NSCollectionViewLayout")]
        #[unsafe(method(layoutAttributesForSupplementaryElementOfKind:atIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn layoutAttributesForSupplementaryElementOfKind_atIndexPath(
            &self,
            kind: &NSCollectionViewSupplementaryElementKind,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSCollectionViewLayoutAttributes>>;

        #[unsafe(method(frameForItemAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn frameForItemAtIndex(&self, index: NSUInteger) -> NSRect;

        #[unsafe(method(frameForItemAtIndex:withNumberOfItems:))]
        #[unsafe(method_family = none)]
        pub fn frameForItemAtIndex_withNumberOfItems(
            &self,
            index: NSUInteger,
            number_of_items: NSUInteger,
        ) -> NSRect;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColors))]
        #[unsafe(method_family = none)]
        pub fn backgroundColors(&self) -> Retained<NSArray<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColors`][Self::backgroundColors].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBackgroundColors:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColors(&self, background_colors: Option<&NSArray<NSColor>>);

        #[unsafe(method(numberOfSections))]
        #[unsafe(method_family = none)]
        pub fn numberOfSections(&self) -> NSInteger;

        #[unsafe(method(numberOfItemsInSection:))]
        #[unsafe(method_family = none)]
        pub fn numberOfItemsInSection(&self, section: NSInteger) -> NSInteger;

        #[unsafe(method(isFirstResponder))]
        #[unsafe(method_family = none)]
        pub fn isFirstResponder(&self) -> bool;

        #[unsafe(method(isSelectable))]
        #[unsafe(method_family = none)]
        pub fn isSelectable(&self) -> bool;

        /// Setter for [`isSelectable`][Self::isSelectable].
        #[unsafe(method(setSelectable:))]
        #[unsafe(method_family = none)]
        pub fn setSelectable(&self, selectable: bool);

        #[unsafe(method(allowsEmptySelection))]
        #[unsafe(method_family = none)]
        pub fn allowsEmptySelection(&self) -> bool;

        /// Setter for [`allowsEmptySelection`][Self::allowsEmptySelection].
        #[unsafe(method(setAllowsEmptySelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEmptySelection(&self, allows_empty_selection: bool);

        #[unsafe(method(allowsMultipleSelection))]
        #[unsafe(method_family = none)]
        pub fn allowsMultipleSelection(&self) -> bool;

        /// Setter for [`allowsMultipleSelection`][Self::allowsMultipleSelection].
        #[unsafe(method(setAllowsMultipleSelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsMultipleSelection(&self, allows_multiple_selection: bool);

        #[unsafe(method(selectionIndexes))]
        #[unsafe(method_family = none)]
        pub fn selectionIndexes(&self) -> Retained<NSIndexSet>;

        /// Setter for [`selectionIndexes`][Self::selectionIndexes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectionIndexes:))]
        #[unsafe(method_family = none)]
        pub fn setSelectionIndexes(&self, selection_indexes: &NSIndexSet);

        #[unsafe(method(selectionIndexPaths))]
        #[unsafe(method_family = none)]
        pub fn selectionIndexPaths(&self) -> Retained<NSSet<NSIndexPath>>;

        /// Setter for [`selectionIndexPaths`][Self::selectionIndexPaths].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectionIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn setSelectionIndexPaths(&self, selection_index_paths: &NSSet<NSIndexPath>);

        #[unsafe(method(selectItemsAtIndexPaths:scrollPosition:))]
        #[unsafe(method_family = none)]
        pub fn selectItemsAtIndexPaths_scrollPosition(
            &self,
            index_paths: &NSSet<NSIndexPath>,
            scroll_position: NSCollectionViewScrollPosition,
        );

        #[unsafe(method(deselectItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn deselectItemsAtIndexPaths(&self, index_paths: &NSSet<NSIndexPath>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(selectAll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectAll(&self, sender: Option<&AnyObject>);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(deselectAll:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deselectAll(&self, sender: Option<&AnyObject>);

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        /// # Safety
        ///
        /// `item_class` probably has further requirements.
        #[unsafe(method(registerClass:forItemWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerClass_forItemWithIdentifier(
            &self,
            item_class: Option<&AnyClass>,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[unsafe(method(registerNib:forItemWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn registerNib_forItemWithIdentifier(
            &self,
            nib: Option<&NSNib>,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        /// # Safety
        ///
        /// `view_class` probably has further requirements.
        #[unsafe(method(registerClass:forSupplementaryViewOfKind:withIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerClass_forSupplementaryViewOfKind_withIdentifier(
            &self,
            view_class: Option<&AnyClass>,
            kind: &NSCollectionViewSupplementaryElementKind,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(feature = "NSNib", feature = "NSUserInterfaceItemIdentification"))]
        #[unsafe(method(registerNib:forSupplementaryViewOfKind:withIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn registerNib_forSupplementaryViewOfKind_withIdentifier(
            &self,
            nib: Option<&NSNib>,
            kind: &NSCollectionViewSupplementaryElementKind,
            identifier: &NSUserInterfaceItemIdentifier,
        );

        #[cfg(all(
            feature = "NSUserInterfaceItemIdentification",
            feature = "NSViewController"
        ))]
        #[unsafe(method(makeItemWithIdentifier:forIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn makeItemWithIdentifier_forIndexPath(
            &self,
            identifier: &NSUserInterfaceItemIdentifier,
            index_path: &NSIndexPath,
        ) -> Retained<NSCollectionViewItem>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[unsafe(method(makeSupplementaryViewOfKind:withIdentifier:forIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn makeSupplementaryViewOfKind_withIdentifier_forIndexPath(
            &self,
            element_kind: &NSCollectionViewSupplementaryElementKind,
            identifier: &NSUserInterfaceItemIdentifier,
            index_path: &NSIndexPath,
        ) -> Retained<NSView>;

        #[cfg(feature = "NSViewController")]
        #[unsafe(method(itemAtIndex:))]
        #[unsafe(method_family = none)]
        pub fn itemAtIndex(&self, index: NSUInteger) -> Option<Retained<NSCollectionViewItem>>;

        #[cfg(feature = "NSViewController")]
        #[unsafe(method(itemAtIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn itemAtIndexPath(
            &self,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSCollectionViewItem>>;

        #[cfg(feature = "NSViewController")]
        #[unsafe(method(visibleItems))]
        #[unsafe(method_family = none)]
        pub fn visibleItems(&self) -> Retained<NSArray<NSCollectionViewItem>>;

        #[unsafe(method(indexPathsForVisibleItems))]
        #[unsafe(method_family = none)]
        pub fn indexPathsForVisibleItems(&self) -> Retained<NSSet<NSIndexPath>>;

        #[cfg(feature = "NSViewController")]
        #[unsafe(method(indexPathForItem:))]
        #[unsafe(method_family = none)]
        pub fn indexPathForItem(
            &self,
            item: &NSCollectionViewItem,
        ) -> Option<Retained<NSIndexPath>>;

        #[unsafe(method(indexPathForItemAtPoint:))]
        #[unsafe(method_family = none)]
        pub fn indexPathForItemAtPoint(&self, point: NSPoint) -> Option<Retained<NSIndexPath>>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[unsafe(method(supplementaryViewForElementKind:atIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn supplementaryViewForElementKind_atIndexPath(
            &self,
            element_kind: &NSCollectionViewSupplementaryElementKind,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSView>>;

        #[cfg(feature = "NSUserInterfaceItemIdentification")]
        #[unsafe(method(visibleSupplementaryViewsOfKind:))]
        #[unsafe(method_family = none)]
        pub fn visibleSupplementaryViewsOfKind(
            &self,
            element_kind: &NSCollectionViewSupplementaryElementKind,
        ) -> Retained<NSArray<NSView>>;

        #[unsafe(method(indexPathsForVisibleSupplementaryElementsOfKind:))]
        #[unsafe(method_family = none)]
        pub fn indexPathsForVisibleSupplementaryElementsOfKind(
            &self,
            element_kind: &NSCollectionViewSupplementaryElementKind,
        ) -> Retained<NSSet<NSIndexPath>>;

        #[unsafe(method(insertSections:))]
        #[unsafe(method_family = none)]
        pub fn insertSections(&self, sections: &NSIndexSet);

        #[unsafe(method(deleteSections:))]
        #[unsafe(method_family = none)]
        pub fn deleteSections(&self, sections: &NSIndexSet);

        #[unsafe(method(reloadSections:))]
        #[unsafe(method_family = none)]
        pub fn reloadSections(&self, sections: &NSIndexSet);

        #[unsafe(method(moveSection:toSection:))]
        #[unsafe(method_family = none)]
        pub fn moveSection_toSection(&self, section: NSInteger, new_section: NSInteger);

        #[unsafe(method(insertItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn insertItemsAtIndexPaths(&self, index_paths: &NSSet<NSIndexPath>);

        #[unsafe(method(deleteItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn deleteItemsAtIndexPaths(&self, index_paths: &NSSet<NSIndexPath>);

        #[unsafe(method(reloadItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn reloadItemsAtIndexPaths(&self, index_paths: &NSSet<NSIndexPath>);

        #[unsafe(method(moveItemAtIndexPath:toIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn moveItemAtIndexPath_toIndexPath(
            &self,
            index_path: &NSIndexPath,
            new_index_path: &NSIndexPath,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performBatchUpdates:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn performBatchUpdates_completionHandler(
            &self,
            updates: Option<&block2::DynBlock<dyn Fn() + '_>>,
            completion_handler: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(toggleSectionCollapse:))]
        #[unsafe(method_family = none)]
        pub unsafe fn toggleSectionCollapse(&self, sender: &AnyObject);

        #[unsafe(method(scrollToItemsAtIndexPaths:scrollPosition:))]
        #[unsafe(method_family = none)]
        pub fn scrollToItemsAtIndexPaths_scrollPosition(
            &self,
            index_paths: &NSSet<NSIndexPath>,
            scroll_position: NSCollectionViewScrollPosition,
        );

        #[cfg(feature = "NSDragging")]
        #[unsafe(method(setDraggingSourceOperationMask:forLocal:))]
        #[unsafe(method_family = none)]
        pub fn setDraggingSourceOperationMask_forLocal(
            &self,
            drag_operation_mask: NSDragOperation,
            local_destination: bool,
        );

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer.
        #[unsafe(method(draggingImageForItemsAtIndexPaths:withEvent:offset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn draggingImageForItemsAtIndexPaths_withEvent_offset(
            &self,
            index_paths: &NSSet<NSIndexPath>,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;

        #[cfg(all(feature = "NSEvent", feature = "NSImage"))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer.
        #[unsafe(method(draggingImageForItemsAtIndexes:withEvent:offset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn draggingImageForItemsAtIndexes_withEvent_offset(
            &self,
            indexes: &NSIndexSet,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;
    );
}

/// Methods declared on superclass `NSView`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSCollectionView {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSCollectionView {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSCollectionView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewdatasource?language=objc)
    pub unsafe trait NSCollectionViewDataSource: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(collectionView:numberOfItemsInSection:))]
        #[unsafe(method_family = none)]
        fn collectionView_numberOfItemsInSection(
            &self,
            collection_view: &NSCollectionView,
            section: NSInteger,
        ) -> NSInteger;

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSView",
            feature = "NSViewController"
        ))]
        #[unsafe(method(collectionView:itemForRepresentedObjectAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_itemForRepresentedObjectAtIndexPath(
            &self,
            collection_view: &NSCollectionView,
            index_path: &NSIndexPath,
        ) -> Retained<NSCollectionViewItem>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(numberOfSectionsInCollectionView:))]
        #[unsafe(method_family = none)]
        fn numberOfSectionsInCollectionView(&self, collection_view: &NSCollectionView)
            -> NSInteger;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:viewForSupplementaryElementOfKind:atIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_viewForSupplementaryElementOfKind_atIndexPath(
            &self,
            collection_view: &NSCollectionView,
            kind: &NSCollectionViewSupplementaryElementKind,
            index_path: &NSIndexPath,
        ) -> Retained<NSView>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewprefetching?language=objc)
    pub unsafe trait NSCollectionViewPrefetching: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[unsafe(method(collectionView:prefetchItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_prefetchItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSArray<NSIndexPath>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:cancelPrefetchingForItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_cancelPrefetchingForItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSArray<NSIndexPath>,
        );
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nscollectionviewdelegate?language=objc)
    pub unsafe trait NSCollectionViewDelegate: NSObjectProtocol {
        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:canDragItemsAtIndexPaths:withEvent:))]
        #[unsafe(method_family = none)]
        fn collectionView_canDragItemsAtIndexPaths_withEvent(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
            event: &NSEvent,
        ) -> bool;

        #[cfg(all(feature = "NSEvent", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:canDragItemsAtIndexes:withEvent:))]
        #[unsafe(method_family = none)]
        fn collectionView_canDragItemsAtIndexes_withEvent(
            &self,
            collection_view: &NSCollectionView,
            indexes: &NSIndexSet,
            event: &NSEvent,
        ) -> bool;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use -collectionView:pasteboardWriterForItemAtIndexPath: instead"]
        #[optional]
        #[unsafe(method(collectionView:writeItemsAtIndexPaths:toPasteboard:))]
        #[unsafe(method_family = none)]
        fn collectionView_writeItemsAtIndexPaths_toPasteboard(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
            pasteboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use -collectionView:pasteboardWriterForItemAtIndexPath: instead"]
        #[optional]
        #[unsafe(method(collectionView:writeItemsAtIndexes:toPasteboard:))]
        #[unsafe(method_family = none)]
        fn collectionView_writeItemsAtIndexes_toPasteboard(
            &self,
            collection_view: &NSCollectionView,
            indexes: &NSIndexSet,
            pasteboard: &NSPasteboard,
        ) -> bool;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[optional]
        #[unsafe(method(collectionView:namesOfPromisedFilesDroppedAtDestination:forDraggedItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_namesOfPromisedFilesDroppedAtDestination_forDraggedItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            drop_url: &NSURL,
            index_paths: &NSSet<NSIndexPath>,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[deprecated = "Use NSFilePromiseReceiver objects instead"]
        #[optional]
        #[unsafe(method(collectionView:namesOfPromisedFilesDroppedAtDestination:forDraggedItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        fn collectionView_namesOfPromisedFilesDroppedAtDestination_forDraggedItemsAtIndexes(
            &self,
            collection_view: &NSCollectionView,
            drop_url: &NSURL,
            indexes: &NSIndexSet,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSImage",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer.
        #[optional]
        #[unsafe(method(collectionView:draggingImageForItemsAtIndexPaths:withEvent:offset:))]
        #[unsafe(method_family = none)]
        unsafe fn collectionView_draggingImageForItemsAtIndexPaths_withEvent_offset(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;

        #[cfg(all(
            feature = "NSEvent",
            feature = "NSImage",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        /// # Safety
        ///
        /// `drag_image_offset` must be a valid pointer.
        #[optional]
        #[unsafe(method(collectionView:draggingImageForItemsAtIndexes:withEvent:offset:))]
        #[unsafe(method_family = none)]
        unsafe fn collectionView_draggingImageForItemsAtIndexes_withEvent_offset(
            &self,
            collection_view: &NSCollectionView,
            indexes: &NSIndexSet,
            event: &NSEvent,
            drag_image_offset: NSPointPointer,
        ) -> Retained<NSImage>;

        #[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// `proposed_drop_operation` must be a valid pointer.
        #[optional]
        #[unsafe(method(collectionView:validateDrop:proposedIndexPath:dropOperation:))]
        #[unsafe(method_family = none)]
        unsafe fn collectionView_validateDrop_proposedIndexPath_dropOperation(
            &self,
            collection_view: &NSCollectionView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
            proposed_drop_index_path: &mut Retained<NSIndexPath>,
            proposed_drop_operation: NonNull<NSCollectionViewDropOperation>,
        ) -> NSDragOperation;

        #[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
        /// # Safety
        ///
        /// - `proposed_drop_index` must be a valid pointer.
        /// - `proposed_drop_operation` must be a valid pointer.
        #[optional]
        #[unsafe(method(collectionView:validateDrop:proposedIndex:dropOperation:))]
        #[unsafe(method_family = none)]
        unsafe fn collectionView_validateDrop_proposedIndex_dropOperation(
            &self,
            collection_view: &NSCollectionView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
            proposed_drop_index: NonNull<NSInteger>,
            proposed_drop_operation: NonNull<NSCollectionViewDropOperation>,
        ) -> NSDragOperation;

        #[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:acceptDrop:indexPath:dropOperation:))]
        #[unsafe(method_family = none)]
        fn collectionView_acceptDrop_indexPath_dropOperation(
            &self,
            collection_view: &NSCollectionView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
            index_path: &NSIndexPath,
            drop_operation: NSCollectionViewDropOperation,
        ) -> bool;

        #[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:acceptDrop:index:dropOperation:))]
        #[unsafe(method_family = none)]
        fn collectionView_acceptDrop_index_dropOperation(
            &self,
            collection_view: &NSCollectionView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
            index: NSInteger,
            drop_operation: NSCollectionViewDropOperation,
        ) -> bool;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:pasteboardWriterForItemAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_pasteboardWriterForItemAtIndexPath(
            &self,
            collection_view: &NSCollectionView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<ProtocolObject<dyn NSPasteboardWriting>>>;

        #[cfg(all(feature = "NSPasteboard", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:pasteboardWriterForItemAtIndex:))]
        #[unsafe(method_family = none)]
        fn collectionView_pasteboardWriterForItemAtIndex(
            &self,
            collection_view: &NSCollectionView,
            index: NSUInteger,
        ) -> Option<Retained<ProtocolObject<dyn NSPasteboardWriting>>>;

        #[cfg(all(
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(collectionView:draggingSession:willBeginAtPoint:forItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_draggingSession_willBeginAtPoint_forItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            index_paths: &NSSet<NSIndexPath>,
        );

        #[cfg(all(
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(collectionView:draggingSession:willBeginAtPoint:forItemsAtIndexes:))]
        #[unsafe(method_family = none)]
        fn collectionView_draggingSession_willBeginAtPoint_forItemsAtIndexes(
            &self,
            collection_view: &NSCollectionView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            indexes: &NSIndexSet,
        );

        #[cfg(all(
            feature = "NSDragging",
            feature = "NSDraggingSession",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(collectionView:draggingSession:endedAtPoint:dragOperation:))]
        #[unsafe(method_family = none)]
        fn collectionView_draggingSession_endedAtPoint_dragOperation(
            &self,
            collection_view: &NSCollectionView,
            session: &NSDraggingSession,
            screen_point: NSPoint,
            operation: NSDragOperation,
        );

        #[cfg(all(feature = "NSDragging", feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:updateDraggingItemsForDrag:))]
        #[unsafe(method_family = none)]
        fn collectionView_updateDraggingItemsForDrag(
            &self,
            collection_view: &NSCollectionView,
            dragging_info: &ProtocolObject<dyn NSDraggingInfo>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:shouldChangeItemsAtIndexPaths:toHighlightState:))]
        #[unsafe(method_family = none)]
        fn collectionView_shouldChangeItemsAtIndexPaths_toHighlightState(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
            highlight_state: NSCollectionViewItemHighlightState,
        ) -> Retained<NSSet<NSIndexPath>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:didChangeItemsAtIndexPaths:toHighlightState:))]
        #[unsafe(method_family = none)]
        fn collectionView_didChangeItemsAtIndexPaths_toHighlightState(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
            highlight_state: NSCollectionViewItemHighlightState,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:shouldSelectItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_shouldSelectItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
        ) -> Retained<NSSet<NSIndexPath>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:shouldDeselectItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_shouldDeselectItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
        ) -> Retained<NSSet<NSIndexPath>>;

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:didSelectItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_didSelectItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:didDeselectItemsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn collectionView_didDeselectItemsAtIndexPaths(
            &self,
            collection_view: &NSCollectionView,
            index_paths: &NSSet<NSIndexPath>,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSView",
            feature = "NSViewController"
        ))]
        #[optional]
        #[unsafe(method(collectionView:willDisplayItem:forRepresentedObjectAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_willDisplayItem_forRepresentedObjectAtIndexPath(
            &self,
            collection_view: &NSCollectionView,
            item: &NSCollectionViewItem,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:willDisplaySupplementaryView:forElementKind:atIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_willDisplaySupplementaryView_forElementKind_atIndexPath(
            &self,
            collection_view: &NSCollectionView,
            view: &NSView,
            element_kind: &NSCollectionViewSupplementaryElementKind,
            index_path: &NSIndexPath,
        );

        #[cfg(all(
            feature = "NSResponder",
            feature = "NSView",
            feature = "NSViewController"
        ))]
        #[optional]
        #[unsafe(method(collectionView:didEndDisplayingItem:forRepresentedObjectAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_didEndDisplayingItem_forRepresentedObjectAtIndexPath(
            &self,
            collection_view: &NSCollectionView,
            item: &NSCollectionViewItem,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "NSResponder", feature = "NSView"))]
        #[optional]
        #[unsafe(method(collectionView:didEndDisplayingSupplementaryView:forElementOfKind:atIndexPath:))]
        #[unsafe(method_family = none)]
        fn collectionView_didEndDisplayingSupplementaryView_forElementOfKind_atIndexPath(
            &self,
            collection_view: &NSCollectionView,
            view: &NSView,
            element_kind: &NSCollectionViewSupplementaryElementKind,
            index_path: &NSIndexPath,
        );

        #[cfg(all(
            feature = "NSCollectionViewLayout",
            feature = "NSCollectionViewTransitionLayout",
            feature = "NSResponder",
            feature = "NSView"
        ))]
        #[optional]
        #[unsafe(method(collectionView:transitionLayoutForOldLayout:newLayout:))]
        #[unsafe(method_family = none)]
        fn collectionView_transitionLayoutForOldLayout_newLayout(
            &self,
            collection_view: &NSCollectionView,
            from_layout: &NSCollectionViewLayout,
            to_layout: &NSCollectionViewLayout,
        ) -> Retained<NSCollectionViewTransitionLayout>;
    }
);

mod private_NSIndexPathNSCollectionViewAdditions {
    pub trait Sealed {}
}

/// Category "NSCollectionViewAdditions" on [`NSIndexPath`].
#[doc(alias = "NSCollectionViewAdditions")]
pub unsafe trait NSIndexPathNSCollectionViewAdditions:
    ClassType + Sized + private_NSIndexPathNSCollectionViewAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(indexPathForItem:inSection:))]
        #[unsafe(method_family = none)]
        fn indexPathForItem_inSection(item: NSInteger, section: NSInteger)
            -> Retained<NSIndexPath>;

        #[unsafe(method(item))]
        #[unsafe(method_family = none)]
        fn item(&self) -> NSInteger;

        #[unsafe(method(section))]
        #[unsafe(method_family = none)]
        fn section(&self) -> NSInteger;
    );
}

impl private_NSIndexPathNSCollectionViewAdditions::Sealed for NSIndexPath {}
unsafe impl NSIndexPathNSCollectionViewAdditions for NSIndexPath {}

mod private_NSSetNSCollectionViewAdditions {
    pub trait Sealed {}
}

/// Category "NSCollectionViewAdditions" on [`NSSet`].
#[doc(alias = "NSCollectionViewAdditions")]
pub unsafe trait NSSetNSCollectionViewAdditions:
    ClassType + Sized + private_NSSetNSCollectionViewAdditions::Sealed
{
    extern_methods!(
        #[unsafe(method(setWithCollectionViewIndexPath:))]
        #[unsafe(method_family = none)]
        fn setWithCollectionViewIndexPath(index_path: &NSIndexPath) -> Retained<Self>;

        #[unsafe(method(setWithCollectionViewIndexPaths:))]
        #[unsafe(method_family = none)]
        fn setWithCollectionViewIndexPaths(index_paths: &NSArray<NSIndexPath>) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(enumerateIndexPathsWithOptions:usingBlock:))]
        #[unsafe(method_family = none)]
        fn enumerateIndexPathsWithOptions_usingBlock(
            &self,
            opts: NSEnumerationOptions,
            block: &block2::DynBlock<dyn Fn(NonNull<NSIndexPath>, NonNull<Bool>) + '_>,
        );
    );
}

impl private_NSSetNSCollectionViewAdditions::Sealed for NSSet {}
unsafe impl NSSetNSCollectionViewAdditions for NSSet {}

/// NSDeprecated.
#[cfg(all(feature = "NSResponder", feature = "NSView"))]
impl NSCollectionView {
    extern_methods!(
        #[cfg(feature = "NSViewController")]
        /// # Safety
        ///
        /// `object` should be of the correct type.
        #[deprecated = "Use -[NSCollectionViewDataSource collectionView:itemForRepresentedObjectAtIndexPath:] instead"]
        #[unsafe(method(newItemForRepresentedObject:))]
        #[unsafe(method_family = new)]
        pub unsafe fn newItemForRepresentedObject(
            &self,
            object: &AnyObject,
        ) -> Retained<NSCollectionViewItem>;

        #[cfg(feature = "NSViewController")]
        #[deprecated = "Use -registerNib:forItemWithIdentifier: or -registerClass:forItemWithIdentifier: instead."]
        #[unsafe(method(itemPrototype))]
        #[unsafe(method_family = none)]
        pub fn itemPrototype(&self) -> Option<Retained<NSCollectionViewItem>>;

        #[cfg(feature = "NSViewController")]
        /// Setter for [`itemPrototype`][Self::itemPrototype].
        #[deprecated = "Use -registerNib:forItemWithIdentifier: or -registerClass:forItemWithIdentifier: instead."]
        #[unsafe(method(setItemPrototype:))]
        #[unsafe(method_family = none)]
        pub fn setItemPrototype(&self, item_prototype: Option<&NSCollectionViewItem>);

        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumNumberOfRows instead"]
        #[unsafe(method(maxNumberOfRows))]
        #[unsafe(method_family = none)]
        pub fn maxNumberOfRows(&self) -> NSUInteger;

        /// Setter for [`maxNumberOfRows`][Self::maxNumberOfRows].
        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumNumberOfRows instead"]
        #[unsafe(method(setMaxNumberOfRows:))]
        #[unsafe(method_family = none)]
        pub fn setMaxNumberOfRows(&self, max_number_of_rows: NSUInteger);

        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumNumberOfColumns instead"]
        #[unsafe(method(maxNumberOfColumns))]
        #[unsafe(method_family = none)]
        pub fn maxNumberOfColumns(&self) -> NSUInteger;

        /// Setter for [`maxNumberOfColumns`][Self::maxNumberOfColumns].
        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumNumberOfColumns instead"]
        #[unsafe(method(setMaxNumberOfColumns:))]
        #[unsafe(method_family = none)]
        pub fn setMaxNumberOfColumns(&self, max_number_of_columns: NSUInteger);

        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its minimumItemSize instead"]
        #[unsafe(method(minItemSize))]
        #[unsafe(method_family = none)]
        pub fn minItemSize(&self) -> NSSize;

        /// Setter for [`minItemSize`][Self::minItemSize].
        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its minimumItemSize instead"]
        #[unsafe(method(setMinItemSize:))]
        #[unsafe(method_family = none)]
        pub fn setMinItemSize(&self, min_item_size: NSSize);

        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumItemSize instead"]
        #[unsafe(method(maxItemSize))]
        #[unsafe(method_family = none)]
        pub fn maxItemSize(&self) -> NSSize;

        /// Setter for [`maxItemSize`][Self::maxItemSize].
        #[deprecated = "Use NSCollectionViewGridLayout as the receiver's collectionViewLayout, setting its maximumItemSize instead"]
        #[unsafe(method(setMaxItemSize:))]
        #[unsafe(method_family = none)]
        pub fn setMaxItemSize(&self, max_item_size: NSSize);
    );
}
