/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.ProxyProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;

public class PreviewConsumer
extends DatabaseTransferConsumer {
    private final DBRProgressMonitor ctlMonitor;
    private final int previewRowCount;
    private boolean fetchEnded;

    public PreviewConsumer(DBRProgressMonitor monitor, DatabaseMappingContainer mappingContainer, int previewRowCount) {
        super(mappingContainer.getTarget());
        this.ctlMonitor = new ProxyProgressMonitor(monitor){

            public boolean isCanceled() {
                return super.isCanceled() || PreviewConsumer.this.fetchEnded;
            }
        };
        this.previewRowCount = previewRowCount;
        this.setPreview(true);
    }

    public DBRProgressMonitor getCtlMonitor() {
        return this.ctlMonitor;
    }

    public List<Object[]> getRows() {
        return this.getPreviewRows();
    }

    public void fetchRow(@NotNull DBCSession session, @NotNull DBCResultSet resultSet) throws DBCException {
        if (this.getPreviewRows().size() >= this.previewRowCount) {
            this.fetchEnded = true;
            return;
        }
        super.fetchRow(session, resultSet);
    }
}

