// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`GetBucketNotificationConfiguration`](crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket for which to get the notification configuration.</p> <p>When you use this API operation with an access point, provide the alias of the access point in place of the bucket name.</p> <p>When you use this API operation with an Object Lambda access point, provide the alias of the Object Lambda access point in place of the bucket name. If the Object Lambda access point alias in a request is not valid, the error code <code>InvalidAccessPointAliasError</code> is returned. For more information about <code>InvalidAccessPointAliasError</code>, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList">List of Error Codes</a>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    /// - On success, responds with [`GetBucketNotificationConfigurationOutput`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationOutput) with field(s):
    ///   - [`topic_configurations(Option<Vec::<TopicConfiguration>>)`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationOutput::topic_configurations): <p>The topic to which notifications are sent and the events for which notifications are generated.</p>
    ///   - [`queue_configurations(Option<Vec::<QueueConfiguration>>)`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationOutput::queue_configurations): <p>The Amazon Simple Queue Service queues to publish messages to and the events for which to publish messages.</p>
    ///   - [`lambda_function_configurations(Option<Vec::<LambdaFunctionConfiguration>>)`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationOutput::lambda_function_configurations): <p>Describes the Lambda functions to invoke and the events for which to invoke them.</p>
    ///   - [`event_bridge_configuration(Option<EventBridgeConfiguration>)`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationOutput::event_bridge_configuration): <p>Enables delivery of events to Amazon EventBridge.</p>
    /// - On failure, responds with [`SdkError<GetBucketNotificationConfigurationError>`](crate::operation::get_bucket_notification_configuration::GetBucketNotificationConfigurationError)
    pub fn get_bucket_notification_configuration(
        &self,
    ) -> crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder {
        crate::operation::get_bucket_notification_configuration::builders::GetBucketNotificationConfigurationFluentBuilder::new(self.handle.clone())
    }
}
