SYD-SYS(1)

# NAME

*syd-sys* - Lookup syscalls, errnos, ioctls, open flags, and signals by number or regular expression

# SYNOPSIS

*syd-sys* _[-heios]_ _[-a arch]_ _number|regex_

*syd-sys* _-a list_

# DESCRIPTION

Given a number, *syd-sys* prints the matching syscall name.

Given a regex, *syd-sys* prints case-insensitively matching syscall names.

Use *-e* to query _errno_(3) numbers.

Use *-i* to query _ioctl_(2) requests.

Use *-o* to query _open_(2) flags.

Use *-s* to query _signal_(7) numbers.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-a*
:< Specify alternative architecture, such as *x86*, *x86_64* and *aarch64*.
|[
:< Use *list* to print the list of libseccomp supported architectures.
|[ *-e*
:< Query _errno_(3) numbers
|[ *-i*
:< Query _ioctl_(2) requests
|[ *-o*
:< Query _open_(2) flags
|[ *-s*
:< Query _signal_(7) numbers

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _errno_(3), _ioctl_(2), _open_(2), _syscall_(2), _signal_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
