#!/usr/bin/env python3

import argparse
import origami


def parseArguments():
    parser = argparse.ArgumentParser(description="""Test Origami.""")
    parser.add_argument("-m", type=int, default=8192)
    parser.add_argument("-n", type=int, default=8192)
    parser.add_argument("-k", type=int, default=8192)
    parser.add_argument("--transA", type=bool, default=True)
    parser.add_argument("--transB", type=bool, default=False)
    parser.add_argument("--device", type=int, default=0)
    parser.add_argument("--element_size", type=int, default=2)
    parser.add_argument("--miDataType", type=int, default=4)
    parser.add_argument("--debug", action="store_true")
    parser.add_argument("--print", action="store_true")
    parser.add_argument("--wgm", type=int, default=6)

    return parser.parse_args()


tile_list = [
    (256, 256, 32, 16, 16, 16),
    (256, 224, 32, 16, 16, 16),
    (256, 192, 32, 16, 16, 16),
    (256, 160, 32, 16, 16, 16),
    (256, 128, 32, 16, 16, 16),
    (256, 96, 32, 16, 16, 16),
    (256, 64, 32, 16, 16, 16),
    (256, 32, 32, 16, 16, 16),
    (224, 256, 32, 16, 16, 16),
    (224, 224, 32, 16, 16, 16),
    (224, 192, 32, 16, 16, 16),
    (224, 160, 32, 16, 16, 16),
    (224, 128, 32, 16, 16, 16),
    (224, 96, 32, 16, 16, 16),
    (224, 64, 32, 16, 16, 16),
    (224, 32, 32, 16, 16, 16),
    (192, 256, 32, 16, 16, 16),
    (192, 224, 32, 16, 16, 16),
    (192, 192, 32, 16, 16, 16),
    (192, 160, 32, 16, 16, 16),
    (192, 128, 32, 16, 16, 16),
    (192, 96, 32, 16, 16, 16),
    (192, 64, 32, 16, 16, 16),
    (192, 32, 32, 16, 16, 16),
    (160, 256, 32, 16, 16, 16),
    (160, 224, 32, 16, 16, 16),
    (160, 192, 32, 16, 16, 16),
    (160, 160, 32, 16, 16, 16),
    (160, 128, 32, 16, 16, 16),
    (160, 96, 32, 16, 16, 16),
    (160, 64, 32, 16, 16, 16),
    (160, 32, 32, 16, 16, 16),
    (128, 256, 32, 16, 16, 16),
    (128, 224, 32, 16, 16, 16),
    (128, 192, 32, 16, 16, 16),
    (128, 160, 32, 16, 16, 16),
    (128, 128, 32, 16, 16, 16),
    (128, 96, 32, 16, 16, 16),
    (128, 64, 32, 16, 16, 16),
    (128, 32, 32, 16, 16, 16),
    (96, 256, 32, 16, 16, 16),
    (96, 224, 32, 16, 16, 16),
    (96, 192, 32, 16, 16, 16),
    (96, 160, 32, 16, 16, 16),
    (96, 128, 32, 16, 16, 16),
    (96, 96, 32, 16, 16, 16),
    (96, 64, 32, 16, 16, 16),
    (96, 32, 32, 16, 16, 16),
    (64, 256, 32, 16, 16, 16),
    (64, 224, 32, 16, 16, 16),
    (64, 192, 32, 16, 16, 16),
    (64, 160, 32, 16, 16, 16),
    (64, 128, 32, 16, 16, 16),
    (64, 96, 32, 16, 16, 16),
    (64, 64, 32, 16, 16, 16),
    (64, 32, 32, 16, 16, 16),
    (32, 256, 32, 16, 16, 16),
    (32, 224, 32, 16, 16, 16),
    (32, 192, 32, 16, 16, 16),
    (32, 160, 32, 16, 16, 16),
    (32, 128, 32, 16, 16, 16),
    (32, 96, 32, 16, 16, 16),
    (32, 64, 32, 16, 16, 16),
    (32, 32, 32, 16, 16, 16),
    (256, 240, 32, 16, 16, 16),
    (256, 208, 32, 16, 16, 16),
    (256, 176, 32, 16, 16, 16),
    (256, 144, 32, 16, 16, 16),
    (256, 112, 32, 16, 16, 16),
    (256, 80, 32, 16, 16, 16),
    (256, 48, 32, 16, 16, 16),
    (256, 16, 32, 16, 16, 16),
    (240, 256, 32, 16, 16, 16),
    (208, 256, 32, 16, 16, 16),
    (176, 256, 32, 16, 16, 16),
    (144, 256, 32, 16, 16, 16),
    (112, 256, 32, 16, 16, 16),
    (80, 256, 32, 16, 16, 16),
    (48, 256, 32, 16, 16, 16),
    (16, 256, 32, 16, 16, 16),
    (256, 224, 64, 16, 16, 16),
    (256, 192, 64, 16, 16, 16),
    (256, 160, 64, 16, 16, 16),
    (256, 128, 64, 16, 16, 16),
    (256, 96, 64, 16, 16, 16),
    (256, 64, 64, 16, 16, 16),
    (256, 32, 64, 16, 16, 16),
    (224, 256, 64, 16, 16, 16),
    (224, 224, 64, 16, 16, 16),
    (224, 192, 64, 16, 16, 16),
    (224, 160, 64, 16, 16, 16),
    (224, 128, 64, 16, 16, 16),
    (224, 96, 64, 16, 16, 16),
    (224, 64, 64, 16, 16, 16),
    (224, 32, 64, 16, 16, 16),
    (192, 256, 64, 16, 16, 16),
    (192, 224, 64, 16, 16, 16),
    (192, 192, 64, 16, 16, 16),
    (192, 160, 64, 16, 16, 16),
    (192, 128, 64, 16, 16, 16),
    (192, 96, 64, 16, 16, 16),
    (192, 64, 64, 16, 16, 16),
    (192, 32, 64, 16, 16, 16),
    (160, 256, 64, 16, 16, 16),
    (160, 224, 64, 16, 16, 16),
    (160, 192, 64, 16, 16, 16),
    (160, 160, 64, 16, 16, 16),
    (160, 128, 64, 16, 16, 16),
    (160, 96, 64, 16, 16, 16),
    (160, 64, 64, 16, 16, 16),
    (160, 32, 64, 16, 16, 16),
    (128, 256, 64, 16, 16, 16),
    (128, 224, 64, 16, 16, 16),
    (128, 192, 64, 16, 16, 16),
    (128, 160, 64, 16, 16, 16),
    (128, 128, 64, 16, 16, 16),
    (128, 96, 64, 16, 16, 16),
    (128, 64, 64, 16, 16, 16),
    (128, 32, 64, 16, 16, 16),
    (96, 256, 64, 16, 16, 16),
    (96, 224, 64, 16, 16, 16),
    (96, 192, 64, 16, 16, 16),
    (96, 160, 64, 16, 16, 16),
    (96, 128, 64, 16, 16, 16),
    (96, 96, 64, 16, 16, 16),
    (96, 64, 64, 16, 16, 16),
    (96, 32, 64, 16, 16, 16),
    (64, 256, 64, 16, 16, 16),
    (64, 224, 64, 16, 16, 16),
    (64, 192, 64, 16, 16, 16),
    (64, 160, 64, 16, 16, 16),
    (64, 128, 64, 16, 16, 16),
    (64, 96, 64, 16, 16, 16),
    (64, 64, 64, 16, 16, 16),
    (64, 32, 64, 16, 16, 16),
    (32, 256, 64, 16, 16, 16),
    (32, 224, 64, 16, 16, 16),
    (32, 192, 64, 16, 16, 16),
    (32, 160, 64, 16, 16, 16),
    (32, 128, 64, 16, 16, 16),
    (32, 96, 64, 16, 16, 16),
    (32, 64, 64, 16, 16, 16),
    (32, 32, 64, 16, 16, 16),
    (256, 208, 64, 16, 16, 16),
    (256, 176, 64, 16, 16, 16),
    (256, 144, 64, 16, 16, 16),
    (256, 112, 64, 16, 16, 16),
    (256, 80, 64, 16, 16, 16),
    (256, 48, 64, 16, 16, 16),
    (256, 16, 64, 16, 16, 16),
    (208, 256, 64, 16, 16, 16),
    (176, 256, 64, 16, 16, 16),
    (144, 256, 64, 16, 16, 16),
    (112, 256, 64, 16, 16, 16),
    (80, 256, 64, 16, 16, 16),
    (48, 256, 64, 16, 16, 16),
    (16, 256, 64, 16, 16, 16),
    (192, 32, 128, 16, 16, 16),
    (160, 64, 128, 16, 16, 16),
    (160, 32, 128, 16, 16, 16),
    (128, 96, 128, 16, 16, 16),
    (128, 64, 128, 16, 16, 16),
    (128, 32, 128, 16, 16, 16),
    (96, 128, 128, 16, 16, 16),
    (96, 96, 128, 16, 16, 16),
    (96, 64, 128, 16, 16, 16),
    (96, 32, 128, 16, 16, 16),
    (64, 160, 128, 16, 16, 16),
    (64, 128, 128, 16, 16, 16),
    (64, 96, 128, 16, 16, 16),
    (64, 64, 128, 16, 16, 16),
    (64, 32, 128, 16, 16, 16),
    (32, 192, 128, 16, 16, 16),
    (32, 160, 128, 16, 16, 16),
    (32, 128, 128, 16, 16, 16),
    (32, 96, 128, 16, 16, 16),
    (32, 64, 128, 16, 16, 16),
    (32, 32, 128, 16, 16, 16),
    (256, 256, 64, 16, 16, 16),
]


def main():
    args = parseArguments()

    hardware = origami.getHardwareForDevice(args.device)

    if args.print:
        hardware.print()

    print(
        origami.select_best_macro_tile_size(
            args.m,
            args.n,
            args.k,
            1,
            args.transA,
            args.transB,
            hardware,
            tile_list,
            args.element_size * 8,
            args.element_size * 8,
            args.element_size * 8,
            args.miDataType,
            0,
            0.8,
            args.debug,
            args.print,
            args.wgm,
        )
    )

    if args.print:
        hardware.print_debug_info()

    return 0


if __name__ == "__main__":
    exit(main())
