/*
 * Copyright: (C) 2000 Julius O. Smith
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Julius O. Smith  jos@ccrma.stanford.edu
 *
 */                                                                                      

/* 

The default filter requires an
oversampling factor of around 20% to avoid aliasing.  The expensive
filter is five times more computationally expensive and requires only
about a 5-10% oversampling factor.  Both filters have comparable
stop-band attenuations (approximately 80 dB).  The
expensive filter is not yet documented because its cut-off frequency
should be retuned slightly for optimal performance.  Also, we plan to
compute truly optimized resampling filters sometime in the future.  In
the meantime, the default filter is fast, well tuned, and works very
well for its level of computational expense.

*/

#define LARGE_FILTER_NMULT ((HWORD)65)
#define LARGE_FILTER_SCALE 14746 /* Unity-gain scale factor */
#define LARGE_FILTER_NWING 8192 /* Filter table length */

HWORD aflibConverter::LARGE_FILTER_IMP[] /* Impulse response */ = {
32767,
32766,
32764,
32761,
32756,
32750,
32743,
32734,
32724,
32713,
32700,
32686,
32671,
32654,
32636,
32617,
32596,
32574,
32551,
32526,
32500,
32473,
32445,
32415,
32383,
32351,
32317,
32282,
32246,
32208,
32169,
32129,
32087,
32044,
32000,
31955,
31908,
31860,
31811,
31760,
31708,
31655,
31601,
31545,
31489,
31431,
31371,
31311,
31249,
31186,
31122,
31056,
30990,
30922,
30853,
30783,
30711,
30639,
30565,
30490,
30414,
30337,
30258,
30179,
30098,
30016,
29933,
29849,
29764,
29677,
29590,
29501,
29411,
29321,
29229,
29136,
29042,
28947,
28851,
28753,
28655,
28556,
28456,
28354,
28252,
28149,
28044,
27939,
27833,
27725,
27617,
27508,
27398,
27287,
27175,
27062,
26948,
26833,
26717,
26601,
26483,
26365,
26246,
26125,
26005,
25883,
25760,
25637,
25512,
25387,
25261,
25135,
25007,
24879,
24750,
24620,
24490,
24358,
24226,
24094,
23960,
23826,
23691,
23556,
23420,
23283,
23146,
23008,
22869,
22730,
22590,
22449,
22308,
22166,
22024,
21881,
21738,
21594,
21449,
21304,
21159,
21013,
20866,
20719,
20572,
20424,
20275,
20127,
19977,
19828,
19678,
19527,
19376,
19225,
19073,
18921,
18769,
18616,
18463,
18310,
18157,
18003,
17849,
17694,
17539,
17384,
17229,
17074,
16918,
16762,
16606,
16450,
16294,
16137,
15980,
15823,
15666,
15509,
15352,
15195,
15037,
14880,
14722,
14564,
14407,
14249,
14091,
13933,
13775,
13618,
13460,
13302,
13144,
12987,
12829,
12671,
12514,
12356,
12199,
12042,
11885,
11728,
11571,
11414,
11257,
11101,
10945,
10789,
10633,
10477,
10322,
10167,
10012,
9857,
9702,
9548,
9394,
9241,
9087,
8934,
8781,
8629,
8477,
8325,
8174,
8023,
7872,
7722,
7572,
7422,
7273,
7124,
6976,
6828,
6681,
6534,
6387,
6241,
6096,
5951,
5806,
5662,
5518,
5375,
5233,
5091,
4949,
4808,
4668,
4528,
4389,
4250,
4112,
3975,
3838,
3702,
3566,
3431,
3297,
3163,
3030,
2898,
2766,
2635,
2505,
2375,
2246,
2118,
1990,
1864,
1738,
1612,
1487,
1364,
1240,
1118,
996,
875,
755,
636,
517,
400,
283,
166,
51,
-63,
-176,
-289,
-401,
-513,
-623,
-733,
-841,
-949,
-1056,
-1162,
-1268,
-1372,
-1476,
-1578,
-1680,
-1781,
-1881,
-1980,
-2078,
-2176,
-2272,
-2367,
-2462,
-2556,
-2648,
-2740,
-2831,
-2921,
-3010,
-3098,
-3185,
-3271,
-3356,
-3441,
-3524,
-3606,
-3688,
-3768,
-3848,
-3926,
-4004,
-4080,
-4156,
-4231,
-4304,
-4377,
-4449,
-4519,
-4589,
-4658,
-4726,
-4792,
-4858,
-4923,
-4987,
-5050,
-5111,
-5172,
-5232,
-5291,
-5349,
-5406,
-5462,
-5517,
-5571,
-5624,
-5675,
-5726,
-5776,
-5825,
-5873,
-5920,
-5966,
-6011,
-6055,
-6098,
-6140,
-6181,
-6222,
-6261,
-6299,
-6336,
-6372,
-6407,
-6441,
-6475,
-6507,
-6538,
-6569,
-6598,
-6626,
-6654,
-6680,
-6706,
-6730,
-6754,
-6777,
-6798,
-6819,
-6839,
-6858,
-6876,
-6893,
-6909,
-6924,
-6938,
-6951,
-6964,
-6975,
-6986,
-6995,
-7004,
-7012,
-7019,
-7025,
-7030,
-7035,
-7038,
-7040,
-7042,
-7043,
-7043,
-7042,
-7040,
-7038,
-7034,
-7030,
-7025,
-7019,
-7012,
-7004,
-6996,
-6986,
-6976,
-6965,
-6954,
-6941,
-6928,
-6914,
-6899,
-6884,
-6867,
-6850,
-6832,
-6814,
-6794,
-6774,
-6753,
-6732,
-6709,
-6686,
-6663,
-6638,
-6613,
-6587,
-6561,
-6534,
-6506,
-6478,
-6448,
-6419,
-6388,
-6357,
-6325,
-6293,
-6260,
-6226,
-6192,
-6157,
-6122,
-6086,
-6049,
-6012,
-5975,
-5936,
-5897,
-5858,
-5818,
-5778,
-5737,
-5695,
-5653,
-5611,
-5568,
-5524,
-5480,
-5436,
-5391,
-5345,
-5300,
-5253,
-5207,
-5159,
-5112,
-5064,
-5015,
-4966,
-4917,
-4868,
-4818,
-4767,
-4716,
-4665,
-4614,
-4562,
-4510,
-4457,
-4404,
-4351,
-4298,
-4244,
-4190,
-4136,
-4081,
-4026,
-3971,
-3916,
-3860,
-3804,
-3748,
-3692,
-3635,
-3578,
-3521,
-3464,
-3406,
-3349,
-3291,
-3233,
-3175,
-3117,
-3058,
-3000,
-2941,
-2882,
-2823,
-2764,
-2705,
-2646,
-2587,
-2527,
-2468,
-2408,
-2349,
-2289,
-2229,
-2169,
-2110,
-2050,
-1990,
-1930,
-1870,
-1811,
-1751,
-1691,
-1631,
-1571,
-1512,
-1452,
-1392,
-1333,
-1273,
-1214,
-1154,
-1095,
-1036,
-977,
-918,
-859,
-800,
-741,
-683,
-624,
-566,
-508,
-450,
-392,
-335,
-277,
-220,
-163,
-106,
-49,
6,
63,
119,
175,
230,
286,
341,
396,
450,
505,
559,
613,
667,
720,
773,
826,
878,
931,
983,
1034,
1086,
1137,
1187,
1238,
1288,
1337,
1387,
1436,
1484,
1533,
1581,
1628,
1675,
1722,
1769,
1815,
1861,
1906,
1951,
1996,
2040,
2084,
2127,
2170,
2212,
2255,
2296,
2338,
2378,
2419,
2459,
2498,
2538,
2576,
2615,
2652,
2690,
2727,
2763,
2799,
2834,
2870,
2904,
2938,
2972,
3005,
3038,
3070,
3102,
3133,
3164,
3194,
3224,
3253,
3282,
3310,
3338,
3365,
3392,
3418,
3444,
3469,
3494,
3518,
3542,
3566,
3588,
3611,
3632,
3653,
3674,
3694,
3714,
3733,
3752,
3770,
3788,
3805,
3821,
3837,
3853,
3868,
3882,
3896,
3910,
3923,
3935,
3947,
3958,
3969,
3980,
3989,
3999,
4007,
4016,
4023,
4031,
4037,
4044,
4049,
4054,
4059,
4063,
4067,
4070,
4073,
4075,
4076,
4077,
4078,
4078,
4078,
4077,
4076,
4074,
4071,
4068,
4065,
4061,
4057,
4052,
4047,
4041,
4035,
4028,
4021,
4013,
4005,
3997,
3988,
3978,
3968,
3958,
3947,
3936,
3924,
3912,
3899,
3886,
3872,
3858,
3844,
3829,
3814,
3798,
3782,
3766,
3749,
3731,
3714,
3696,
3677,
3658,
3639,
3619,
3599,
3578,
3558,
3536,
3515,
3493,
3470,
3448,
3425,
3401,
3378,
3353,
3329,
3304,
3279,
3254,
3228,
3202,
3175,
3149,
3122,
3094,
3067,
3039,
3011,
2982,
2953,
2924,
2895,
2865,
2835,
2805,
2775,
2744,
2713,
2682,
2651,
2619,
2587,
2555,
2523,
2490,
2457,
2424,
2391,
2358,
2324,
2290,
2256,
2222,
2188,
2153,
2119,
2084,
2049,
2014,
1978,
1943,
1907,
1872,
1836,
1800,
1764,
1727,
1691,
1655,
1618,
1581,
1545,
1508,
1471,
1434,
1397,
1360,
1322,
1285,
1248,
1210,
1173,
1135,
1098,
1060,
1023,
985,
947,
910,
872,
834,
797,
759,
721,
684,
646,
608,
571,
533,
496,
458,
421,
383,
346,
308,
271,
234,
197,
160,
123,
86,
49,
12,
-23,
-60,
-96,
-133,
-169,
-205,
-241,
-277,
-313,
-348,
-384,
-419,
-455,
-490,
-525,
-559,
-594,
-628,
-663,
-697,
-731,
-765,
-798,
-832,
-865,
-898,
-931,
-963,
-996,
-1028,
-1060,
-1092,
-1124,
-1155,
-1186,
-1217,
-1248,
-1279,
-1309,
-1339,
-1369,
-1398,
-1428,
-1457,
-1486,
-1514,
-1542,
-1571,
-1598,
-1626,
-1653,
-1680,
-1707,
-1733,
-1760,
-1785,
-1811,
-1836,
-1862,
-1886,
-1911,
-1935,
-1959,
-1982,
-2006,
-2029,
-2051,
-2074,
-2096,
-2118,
-2139,
-2160,
-2181,
-2202,
-2222,
-2242,
-2261,
-2280,
-2299,
-2318,
-2336,
-2354,
-2372,
-2389,
-2406,
-2423,
-2439,
-2455,
-2470,
-2486,
-2500,
-2515,
-2529,
-2543,
-2557,
-2570,
-2583,
-2595,
-2607,
-2619,
-2631,
-2642,
-2652,
-2663,
-2673,
-2683,
-2692,
-2701,
-2710,
-2718,
-2726,
-2734,
-2741,
-2748,
-2754,
-2760,
-2766,
-2772,
-2777,
-2782,
-2786,
-2790,
-2794,
-2797,
-2800,
-2803,
-2805,
-2807,
-2809,
-2810,
-2811,
-2812,
-2812,
-2812,
-2812,
-2811,
-2810,
-2808,
-2807,
-2804,
-2802,
-2799,
-2796,
-2792,
-2789,
-2785,
-2780,
-2775,
-2770,
-2765,
-2759,
-2753,
-2746,
-2740,
-2732,
-2725,
-2717,
-2709,
-2701,
-2692,
-2683,
-2674,
-2664,
-2655,
-2644,
-2634,
-2623,
-2612,
-2601,
-2589,
-2577,
-2565,
-2552,
-2539,
-2526,
-2513,
-2499,
-2485,
-2471,
-2457,
-2442,
-2427,
-2412,
-2396,
-2380,
-2364,
-2348,
-2331,
-2315,
-2297,
-2280,
-2263,
-2245,
-2227,
-2209,
-2190,
-2171,
-2152,
-2133,
-2114,
-2094,
-2075,
-2055,
-2034,
-2014,
-1993,
-1972,
-1951,
-1930,
-1909,
-1887,
-1865,
-1843,
-1821,
-1799,
-1776,
-1754,
-1731,
-1708,
-1685,
-1662,
-1638,
-1614,
-1591,
-1567,
-1543,
-1519,
-1494,
-1470,
-1445,
-1421,
-1396,
-1371,
-1346,
-1321,
-1295,
-1270,
-1244,
-1219,
-1193,
-1167,
-1142,
-1116,
-1090,
-1064,
-1037,
-1011,
-985,
-958,
-932,
-905,
-879,
-852,
-826,
-799,
-772,
-745,
-719,
-692,
-665,
-638,
-611,
-584,
-557,
-530,
-503,
-476,
-449,
-422,
-395,
-368,
-341,
-314,
-287,
-260,
-234,
-207,
-180,
-153,
-126,
-100,
-73,
-46,
-20,
6,
32,
59,
85,
111,
138,
164,
190,
216,
242,
268,
294,
319,
345,
370,
396,
421,
446,
471,
496,
521,
546,
571,
595,
619,
644,
668,
692,
716,
739,
763,
787,
810,
833,
856,
879,
902,
924,
947,
969,
991,
1013,
1035,
1056,
1078,
1099,
1120,
1141,
1162,
1182,
1202,
1223,
1243,
1262,
1282,
1301,
1320,
1339,
1358,
1377,
1395,
1413,
1431,
1449,
1467,
1484,
1501,
1518,
1535,
1551,
1567,
1583,
1599,
1615,
1630,
1645,
1660,
1674,
1689,
1703,
1717,
1731,
1744,
1757,
1770,
1783,
1795,
1808,
1820,
1831,
1843,
1854,
1865,
1876,
1886,
1897,
1907,
1916,
1926,
1935,
1944,
1953,
1961,
1970,
1978,
1985,
1993,
2000,
2007,
2014,
2020,
2026,
2032,
2038,
2043,
2048,
2053,
2058,
2062,
2066,
2070,
2073,
2077,
2080,
2083,
2085,
2087,
2089,
2091,
2093,
2094,
2095,
2095,
2096,
2096,
2096,
2096,
2095,
2094,
2093,
2092,
2090,
2088,
2086,
2084,
2081,
2079,
2075,
2072,
2069,
2065,
2061,
2056,
2052,
2047,
2042,
2037,
2031,
2025,
2019,
2013,
2006,
2000,
1993,
1986,
1978,
1971,
1963,
1955,
1946,
1938,
1929,
1920,
1911,
1901,
1892,
1882,
1872,
1862,
1851,
1841,
1830,
1819,
1807,
1796,
1784,
1772,
1760,
1748,
1735,
1723,
1710,
1697,
1684,
1670,
1657,
1643,
1629,
1615,
1601,
1586,
1572,
1557,
1542,
1527,
1512,
1496,
1481,
1465,
1449,
1433,
1417,
1401,
1384,
1368,
1351,
1334,
1317,
1300,
1283,
1265,
1248,
1230,
1212,
1195,
1177,
1159,
1140,
1122,
1104,
1085,
1067,
1048,
1029,
1010,
991,
972,
953,
934,
915,
895,
876,
856,
837,
817,
797,
777,
758,
738,
718,
698,
678,
658,
637,
617,
597,
577,
556,
536,
516,
495,
475,
454,
434,
414,
393,
373,
352,
332,
311,
291,
270,
250,
229,
208,
188,
168,
147,
127,
106,
86,
65,
45,
25,
5,
-15,
-35,
-55,
-75,
-95,
-115,
-135,
-155,
-175,
-195,
-215,
-234,
-254,
-274,
-293,
-313,
-332,
-351,
-370,
-390,
-409,
-428,
-446,
-465,
-484,
-503,
-521,
-539,
-558,
-576,
-594,
-612,
-630,
-648,
-666,
-683,
-701,
-718,
-735,
-752,
-769,
-786,
-803,
-819,
-836,
-852,
-868,
-885,
-900,
-916,
-932,
-947,
-963,
-978,
-993,
-1008,
-1023,
-1038,
-1052,
-1066,
-1081,
-1095,
-1108,
-1122,
-1136,
-1149,
-1162,
-1175,
-1188,
-1201,
-1214,
-1226,
-1238,
-1250,
-1262,
-1274,
-1285,
-1297,
-1308,
-1319,
-1330,
-1340,
-1351,
-1361,
-1371,
-1381,
-1390,
-1400,
-1409,
-1418,
-1427,
-1436,
-1445,
-1453,
-1461,
-1469,
-1477,
-1485,
-1492,
-1499,
-1506,
-1513,
-1520,
-1526,
-1532,
-1538,
-1544,
-1550,
-1555,
-1560,
-1566,
-1570,
-1575,
-1579,
-1584,
-1588,
-1592,
-1595,
-1599,
-1602,
-1605,
-1608,
-1610,
-1613,
-1615,
-1617,
-1619,
-1620,
-1622,
-1623,
-1624,
-1625,
-1625,
-1626,
-1626,
-1626,
-1626,
-1625,
-1625,
-1624,
-1623,
-1622,
-1621,
-1619,
-1617,
-1615,
-1613,
-1611,
-1608,
-1605,
-1603,
-1599,
-1596,
-1593,
-1589,
-1585,
-1581,
-1577,
-1572,
-1568,
-1563,
-1558,
-1553,
-1547,
-1542,
-1536,
-1530,
-1524,
-1518,
-1511,
-1505,
-1498,
-1491,
-1484,
-1477,
-1469,
-1462,
-1454,
-1446,
-1438,
-1430,
-1421,
-1413,
-1404,
-1395,
-1386,
-1377,
-1367,
-1358,
-1348,
-1338,
-1328,
-1318,
-1308,
-1297,
-1287,
-1276,
-1265,
-1254,
-1243,
-1232,
-1221,
-1209,
-1198,
-1186,
-1174,
-1162,
-1150,
-1138,
-1125,
-1113,
-1100,
-1087,
-1075,
-1062,
-1049,
-1035,
-1022,
-1009,
-995,
-982,
-968,
-954,
-941,
-927,
-913,
-898,
-884,
-870,
-856,
-841,
-827,
-812,
-797,
-783,
-768,
-753,
-738,
-723,
-708,
-692,
-677,
-662,
-647,
-631,
-616,
-600,
-585,
-569,
-554,
-538,
-522,
-506,
-491,
-475,
-459,
-443,
-427,
-411,
-395,
-379,
-363,
-347,
-331,
-315,
-299,
-283,
-267,
-251,
-235,
-218,
-202,
-186,
-170,
-154,
-138,
-122,
-106,
-90,
-74,
-58,
-42,
-26,
-10,
5,
21,
37,
53,
69,
85,
100,
116,
132,
147,
163,
179,
194,
209,
225,
240,
256,
271,
286,
301,
316,
331,
346,
361,
376,
391,
405,
420,
434,
449,
463,
477,
492,
506,
520,
534,
548,
561,
575,
589,
602,
615,
629,
642,
655,
668,
681,
694,
706,
719,
731,
744,
756,
768,
780,
792,
804,
816,
827,
839,
850,
861,
872,
883,
894,
905,
915,
926,
936,
946,
956,
966,
976,
986,
995,
1005,
1014,
1023,
1032,
1041,
1049,
1058,
1066,
1075,
1083,
1091,
1099,
1106,
1114,
1121,
1128,
1135,
1142,
1149,
1156,
1162,
1169,
1175,
1181,
1187,
1192,
1198,
1203,
1208,
1214,
1218,
1223,
1228,
1232,
1237,
1241,
1245,
1249,
1252,
1256,
1259,
1262,
1265,
1268,
1271,
1273,
1276,
1278,
1280,
1282,
1284,
1285,
1287,
1288,
1289,
1290,
1291,
1292,
1292,
1292,
1293,
1293,
1292,
1292,
1292,
1291,
1290,
1289,
1288,
1287,
1285,
1284,
1282,
1280,
1278,
1276,
1274,
1271,
1269,
1266,
1263,
1260,
1257,
1253,
1250,
1246,
1242,
1238,
1234,
1230,
1225,
1221,
1216,
1211,
1206,
1201,
1196,
1190,
1185,
1179,
1173,
1167,
1161,
1155,
1149,
1142,
1136,
1129,
1122,
1115,
1108,
1101,
1094,
1086,
1078,
1071,
1063,
1055,
1047,
1039,
1030,
1022,
1013,
1005,
996,
987,
978,
969,
960,
951,
941,
932,
922,
913,
903,
893,
883,
873,
863,
853,
842,
832,
821,
811,
800,
789,
778,
768,
757,
746,
734,
723,
712,
701,
689,
678,
666,
654,
643,
631,
619,
607,
596,
584,
572,
559,
547,
535,
523,
511,
498,
486,
474,
461,
449,
436,
424,
411,
399,
386,
373,
361,
348,
335,
322,
310,
297,
284,
271,
258,
246,
233,
220,
207,
194,
181,
168,
156,
143,
130,
117,
104,
91,
78,
65,
53,
40,
27,
14,
1,
-10,
-23,
-36,
-48,
-61,
-74,
-86,
-99,
-111,
-124,
-136,
-149,
-161,
-174,
-186,
-198,
-211,
-223,
-235,
-247,
-259,
-271,
-283,
-295,
-307,
-319,
-330,
-342,
-354,
-365,
-377,
-388,
-399,
-411,
-422,
-433,
-444,
-455,
-466,
-477,
-488,
-499,
-509,
-520,
-530,
-541,
-551,
-561,
-571,
-581,
-591,
-601,
-611,
-621,
-631,
-640,
-650,
-659,
-668,
-677,
-686,
-695,
-704,
-713,
-722,
-730,
-739,
-747,
-755,
-763,
-771,
-779,
-787,
-795,
-803,
-810,
-817,
-825,
-832,
-839,
-846,
-853,
-859,
-866,
-873,
-879,
-885,
-891,
-897,
-903,
-909,
-915,
-920,
-926,
-931,
-936,
-941,
-946,
-951,
-955,
-960,
-964,
-969,
-973,
-977,
-981,
-985,
-988,
-992,
-995,
-999,
-1002,
-1005,
-1008,
-1011,
-1013,
-1016,
-1018,
-1020,
-1023,
-1025,
-1026,
-1028,
-1030,
-1031,
-1033,
-1034,
-1035,
-1036,
-1037,
-1038,
-1038,
-1039,
-1039,
-1039,
-1039,
-1039,
-1039,
-1039,
-1038,
-1038,
-1037,
-1036,
-1036,
-1034,
-1033,
-1032,
-1031,
-1029,
-1027,
-1026,
-1024,
-1022,
-1019,
-1017,
-1015,
-1012,
-1010,
-1007,
-1004,
-1001,
-998,
-995,
-991,
-988,
-984,
-980,
-977,
-973,
-969,
-965,
-960,
-956,
-951,
-947,
-942,
-937,
-932,
-927,
-922,
-917,
-912,
-906,
-901,
-895,
-889,
-883,
-877,
-871,
-865,
-859,
-853,
-846,
-840,
-833,
-826,
-819,
-812,
-805,
-798,
-791,
-784,
-777,
-769,
-762,
-754,
-746,
-739,
-731,
-723,
-715,
-707,
-699,
-691,
-682,
-674,
-665,
-657,
-648,
-640,
-631,
-622,
-614,
-605,
-596,
-587,
-578,
-569,
-559,
-550,
-541,
-532,
-522,
-513,
-503,
-494,
-484,
-474,
-465,
-455,
-445,
-436,
-426,
-416,
-406,
-396,
-386,
-376,
-366,
-356,
-346,
-336,
-325,
-315,
-305,
-295,
-285,
-274,
-264,
-254,
-243,
-233,
-223,
-212,
-202,
-192,
-181,
-171,
-161,
-150,
-140,
-129,
-119,
-108,
-98,
-88,
-77,
-67,
-57,
-46,
-36,
-25,
-15,
-5,
5,
15,
25,
35,
46,
56,
66,
76,
86,
97,
107,
117,
127,
137,
147,
157,
167,
177,
186,
196,
206,
216,
225,
235,
245,
254,
264,
273,
283,
292,
301,
311,
320,
329,
338,
347,
356,
365,
374,
383,
392,
400,
409,
418,
426,
435,
443,
451,
460,
468,
476,
484,
492,
500,
508,
515,
523,
531,
538,
546,
553,
560,
568,
575,
582,
589,
596,
602,
609,
616,
622,
629,
635,
642,
648,
654,
660,
666,
672,
678,
683,
689,
694,
700,
705,
710,
715,
720,
725,
730,
735,
739,
744,
748,
753,
757,
761,
765,
769,
773,
777,
780,
784,
787,
791,
794,
797,
800,
803,
806,
809,
811,
814,
816,
818,
821,
823,
825,
827,
828,
830,
832,
833,
835,
836,
837,
838,
839,
840,
841,
841,
842,
842,
843,
843,
843,
843,
843,
843,
843,
842,
842,
841,
840,
840,
839,
838,
837,
835,
834,
833,
831,
830,
828,
826,
824,
822,
820,
818,
816,
813,
811,
808,
806,
803,
800,
797,
794,
791,
788,
784,
781,
777,
774,
770,
766,
763,
759,
755,
750,
746,
742,
738,
733,
729,
724,
719,
714,
710,
705,
700,
694,
689,
684,
679,
673,
668,
662,
657,
651,
645,
639,
633,
627,
621,
615,
609,
603,
596,
590,
584,
577,
571,
564,
557,
551,
544,
537,
530,
523,
516,
509,
502,
495,
487,
480,
473,
465,
458,
450,
443,
435,
428,
420,
413,
405,
397,
389,
381,
374,
366,
358,
350,
342,
334,
326,
318,
310,
301,
293,
285,
277,
269,
260,
252,
244,
236,
227,
219,
211,
202,
194,
185,
177,
169,
160,
152,
143,
135,
126,
118,
110,
101,
93,
84,
76,
67,
59,
50,
42,
34,
25,
17,
8,
0,
-7,
-16,
-24,
-32,
-41,
-49,
-57,
-66,
-74,
-82,
-90,
-98,
-106,
-115,
-123,
-131,
-139,
-147,
-155,
-163,
-171,
-179,
-186,
-194,
-202,
-210,
-217,
-225,
-233,
-240,
-248,
-255,
-263,
-270,
-278,
-285,
-292,
-299,
-307,
-314,
-321,
-328,
-335,
-342,
-349,
-356,
-362,
-369,
-376,
-382,
-389,
-396,
-402,
-408,
-415,
-421,
-427,
-433,
-439,
-445,
-451,
-457,
-463,
-469,
-475,
-480,
-486,
-491,
-497,
-502,
-507,
-513,
-518,
-523,
-528,
-533,
-538,
-542,
-547,
-552,
-556,
-561,
-565,
-570,
-574,
-578,
-582,
-586,
-590,
-594,
-598,
-602,
-605,
-609,
-612,
-616,
-619,
-622,
-625,
-629,
-632,
-634,
-637,
-640,
-643,
-645,
-648,
-650,
-653,
-655,
-657,
-659,
-661,
-663,
-665,
-667,
-668,
-670,
-671,
-673,
-674,
-675,
-676,
-678,
-679,
-679,
-680,
-681,
-682,
-682,
-683,
-683,
-683,
-684,
-684,
-684,
-684,
-684,
-684,
-683,
-683,
-682,
-682,
-681,
-681,
-680,
-679,
-678,
-677,
-676,
-675,
-674,
-672,
-671,
-669,
-668,
-666,
-664,
-662,
-661,
-659,
-657,
-654,
-652,
-650,
-648,
-645,
-643,
-640,
-637,
-635,
-632,
-629,
-626,
-623,
-620,
-617,
-613,
-610,
-607,
-603,
-600,
-596,
-593,
-589,
-585,
-581,
-577,
-573,
-569,
-565,
-561,
-557,
-552,
-548,
-544,
-539,
-534,
-530,
-525,
-520,
-516,
-511,
-506,
-501,
-496,
-491,
-486,
-481,
-475,
-470,
-465,
-460,
-454,
-449,
-443,
-438,
-432,
-426,
-421,
-415,
-409,
-403,
-398,
-392,
-386,
-380,
-374,
-368,
-362,
-355,
-349,
-343,
-337,
-331,
-324,
-318,
-312,
-305,
-299,
-292,
-286,
-280,
-273,
-266,
-260,
-253,
-247,
-240,
-234,
-227,
-220,
-213,
-207,
-200,
-193,
-187,
-180,
-173,
-166,
-159,
-153,
-146,
-139,
-132,
-125,
-118,
-112,
-105,
-98,
-91,
-84,
-77,
-70,
-64,
-57,
-50,
-43,
-36,
-29,
-22,
-16,
-9,
-2,
4,
11,
17,
24,
31,
38,
44,
51,
58,
64,
71,
78,
84,
91,
98,
104,
111,
117,
124,
130,
137,
143,
149,
156,
162,
168,
175,
181,
187,
193,
199,
205,
212,
218,
224,
230,
236,
241,
247,
253,
259,
265,
270,
276,
282,
287,
293,
298,
304,
309,
314,
320,
325,
330,
335,
340,
345,
350,
355,
360,
365,
370,
375,
380,
384,
389,
393,
398,
402,
407,
411,
415,
419,
424,
428,
432,
436,
440,
443,
447,
451,
455,
458,
462,
465,
469,
472,
475,
479,
482,
485,
488,
491,
494,
497,
499,
502,
505,
507,
510,
512,
515,
517,
519,
522,
524,
526,
528,
530,
532,
533,
535,
537,
538,
540,
541,
543,
544,
545,
546,
548,
549,
550,
550,
551,
552,
553,
553,
554,
554,
555,
555,
555,
556,
556,
556,
556,
556,
556,
555,
555,
555,
554,
554,
553,
553,
552,
551,
551,
550,
549,
548,
547,
546,
545,
543,
542,
541,
539,
538,
536,
534,
533,
531,
529,
527,
525,
523,
521,
519,
517,
514,
512,
510,
507,
505,
502,
500,
497,
494,
492,
489,
486,
483,
480,
477,
474,
471,
467,
464,
461,
457,
454,
450,
447,
443,
440,
436,
432,
429,
425,
421,
417,
413,
409,
405,
401,
397,
393,
388,
384,
380,
375,
371,
367,
362,
358,
353,
349,
344,
339,
335,
330,
325,
321,
316,
311,
306,
301,
296,
291,
286,
281,
276,
271,
266,
261,
256,
251,
245,
240,
235,
230,
225,
219,
214,
209,
203,
198,
193,
187,
182,
176,
171,
165,
160,
154,
149,
144,
138,
132,
127,
121,
116,
110,
105,
99,
94,
88,
83,
77,
71,
66,
60,
55,
49,
44,
38,
33,
27,
21,
16,
10,
5,
0,
-5,
-11,
-16,
-22,
-27,
-33,
-38,
-43,
-49,
-54,
-60,
-65,
-70,
-76,
-81,
-86,
-92,
-97,
-102,
-107,
-113,
-118,
-123,
-128,
-133,
-138,
-143,
-148,
-153,
-158,
-163,
-168,
-173,
-178,
-183,
-188,
-192,
-197,
-202,
-207,
-211,
-216,
-221,
-225,
-230,
-234,
-239,
-243,
-247,
-252,
-256,
-260,
-265,
-269,
-273,
-277,
-281,
-285,
-289,
-293,
-297,
-301,
-305,
-308,
-312,
-316,
-319,
-323,
-327,
-330,
-334,
-337,
-340,
-344,
-347,
-350,
-353,
-357,
-360,
-363,
-366,
-369,
-372,
-374,
-377,
-380,
-383,
-385,
-388,
-390,
-393,
-395,
-398,
-400,
-402,
-405,
-407,
-409,
-411,
-413,
-415,
-417,
-419,
-420,
-422,
-424,
-425,
-427,
-429,
-430,
-431,
-433,
-434,
-435,
-436,
-438,
-439,
-440,
-441,
-442,
-442,
-443,
-444,
-445,
-445,
-446,
-446,
-447,
-447,
-448,
-448,
-448,
-448,
-449,
-449,
-449,
-449,
-449,
-448,
-448,
-448,
-448,
-447,
-447,
-446,
-446,
-445,
-445,
-444,
-443,
-442,
-442,
-441,
-440,
-439,
-438,
-437,
-435,
-434,
-433,
-432,
-430,
-429,
-427,
-426,
-424,
-423,
-421,
-419,
-418,
-416,
-414,
-412,
-410,
-408,
-406,
-404,
-402,
-400,
-397,
-395,
-393,
-390,
-388,
-385,
-383,
-380,
-378,
-375,
-373,
-370,
-367,
-364,
-361,
-359,
-356,
-353,
-350,
-347,
-344,
-340,
-337,
-334,
-331,
-328,
-324,
-321,
-318,
-314,
-311,
-307,
-304,
-300,
-297,
-293,
-290,
-286,
-282,
-279,
-275,
-271,
-267,
-263,
-260,
-256,
-252,
-248,
-244,
-240,
-236,
-232,
-228,
-224,
-220,
-216,
-212,
-207,
-203,
-199,
-195,
-191,
-186,
-182,
-178,
-174,
-169,
-165,
-161,
-156,
-152,
-148,
-143,
-139,
-134,
-130,
-126,
-121,
-117,
-112,
-108,
-103,
-99,
-95,
-90,
-86,
-81,
-77,
-72,
-68,
-63,
-59,
-54,
-50,
-45,
-41,
-36,
-32,
-27,
-23,
-18,
-14,
-9,
-5,
0,
3,
7,
12,
16,
21,
25,
29,
34,
38,
43,
47,
51,
56,
60,
64,
69,
73,
77,
81,
85,
90,
94,
98,
102,
106,
110,
115,
119,
123,
127,
131,
135,
139,
143,
146,
150,
154,
158,
162,
166,
169,
173,
177,
181,
184,
188,
192,
195,
199,
202,
206,
209,
212,
216,
219,
223,
226,
229,
232,
236,
239,
242,
245,
248,
251,
254,
257,
260,
263,
266,
268,
271,
274,
277,
279,
282,
284,
287,
289,
292,
294,
297,
299,
301,
304,
306,
308,
310,
312,
314,
316,
318,
320,
322,
324,
326,
328,
329,
331,
333,
334,
336,
337,
339,
340,
341,
343,
344,
345,
346,
348,
349,
350,
351,
352,
353,
354,
354,
355,
356,
357,
357,
358,
358,
359,
359,
360,
360,
361,
361,
361,
361,
362,
362,
362,
362,
362,
362,
362,
361,
361,
361,
361,
360,
360,
360,
359,
359,
358,
358,
357,
356,
356,
355,
354,
353,
352,
351,
350,
349,
348,
347,
346,
345,
344,
343,
341,
340,
339,
337,
336,
334,
333,
331,
330,
328,
326,
324,
323,
321,
319,
317,
315,
313,
311,
309,
307,
305,
303,
301,
299,
297,
294,
292,
290,
288,
285,
283,
280,
278,
275,
273,
270,
268,
265,
263,
260,
257,
254,
252,
249,
246,
243,
240,
238,
235,
232,
229,
226,
223,
220,
217,
214,
211,
208,
204,
201,
198,
195,
192,
188,
185,
182,
179,
175,
172,
169,
165,
162,
159,
155,
152,
149,
145,
142,
138,
135,
131,
128,
124,
121,
117,
114,
110,
107,
103,
100,
96,
93,
89,
85,
82,
78,
75,
71,
67,
64,
60,
57,
53,
49,
46,
42,
39,
35,
31,
28,
24,
21,
17,
14,
10,
6,
3,
0,
-3,
-7,
-10,
-14,
-18,
-21,
-25,
-28,
-32,
-35,
-39,
-42,
-45,
-49,
-52,
-56,
-59,
-63,
-66,
-69,
-73,
-76,
-79,
-83,
-86,
-89,
-93,
-96,
-99,
-102,
-105,
-109,
-112,
-115,
-118,
-121,
-124,
-127,
-130,
-133,
-136,
-139,
-142,
-145,
-148,
-151,
-154,
-157,
-160,
-162,
-165,
-168,
-171,
-173,
-176,
-179,
-181,
-184,
-186,
-189,
-191,
-194,
-196,
-199,
-201,
-204,
-206,
-208,
-211,
-213,
-215,
-217,
-219,
-221,
-224,
-226,
-228,
-230,
-232,
-234,
-236,
-237,
-239,
-241,
-243,
-245,
-246,
-248,
-250,
-251,
-253,
-254,
-256,
-257,
-259,
-260,
-262,
-263,
-264,
-266,
-267,
-268,
-269,
-270,
-271,
-273,
-274,
-275,
-275,
-276,
-277,
-278,
-279,
-280,
-281,
-281,
-282,
-283,
-283,
-284,
-284,
-285,
-285,
-286,
-286,
-286,
-287,
-287,
-287,
-287,
-288,
-288,
-288,
-288,
-288,
-288,
-288,
-288,
-288,
-288,
-287,
-287,
-287,
-287,
-286,
-286,
-286,
-285,
-285,
-284,
-284,
-283,
-283,
-282,
-281,
-281,
-280,
-279,
-278,
-277,
-277,
-276,
-275,
-274,
-273,
-272,
-271,
-270,
-269,
-267,
-266,
-265,
-264,
-262,
-261,
-260,
-258,
-257,
-256,
-254,
-253,
-251,
-250,
-248,
-247,
-245,
-243,
-242,
-240,
-238,
-236,
-235,
-233,
-231,
-229,
-227,
-225,
-223,
-221,
-219,
-217,
-215,
-213,
-211,
-209,
-207,
-205,
-203,
-201,
-198,
-196,
-194,
-192,
-189,
-187,
-185,
-182,
-180,
-178,
-175,
-173,
-170,
-168,
-165,
-163,
-160,
-158,
-155,
-153,
-150,
-148,
-145,
-142,
-140,
-137,
-135,
-132,
-129,
-127,
-124,
-121,
-118,
-116,
-113,
-110,
-108,
-105,
-102,
-99,
-96,
-94,
-91,
-88,
-85,
-82,
-80,
-77,
-74,
-71,
-68,
-65,
-63,
-60,
-57,
-54,
-51,
-48,
-45,
-42,
-40,
-37,
-34,
-31,
-28,
-25,
-22,
-20,
-17,
-14,
-11,
-8,
-5,
-2,
0,
2,
5,
8,
11,
13,
16,
19,
22,
25,
27,
30,
33,
36,
38,
41,
44,
47,
49,
52,
55,
57,
60,
63,
65,
68,
71,
73,
76,
78,
81,
83,
86,
88,
91,
93,
96,
98,
101,
103,
106,
108,
110,
113,
115,
117,
120,
122,
124,
127,
129,
131,
133,
135,
137,
140,
142,
144,
146,
148,
150,
152,
154,
156,
158,
160,
161,
163,
165,
167,
169,
171,
172,
174,
176,
177,
179,
181,
182,
184,
185,
187,
188,
190,
191,
193,
194,
195,
197,
198,
199,
201,
202,
203,
204,
205,
207,
208,
209,
210,
211,
212,
213,
214,
215,
216,
216,
217,
218,
219,
219,
220,
221,
222,
222,
223,
223,
224,
224,
225,
225,
226,
226,
227,
227,
227,
227,
228,
228,
228,
228,
228,
229,
229,
229,
229,
229,
229,
229,
229,
228,
228,
228,
228,
228,
228,
227,
227,
227,
226,
226,
225,
225,
225,
224,
224,
223,
222,
222,
221,
221,
220,
219,
218,
218,
217,
216,
215,
214,
214,
213,
212,
211,
210,
209,
208,
207,
206,
205,
203,
202,
201,
200,
199,
197,
196,
195,
194,
192,
191,
190,
188,
187,
185,
184,
182,
181,
179,
178,
176,
175,
173,
172,
170,
168,
167,
165,
163,
162,
160,
158,
156,
155,
153,
151,
149,
147,
146,
144,
142,
140,
138,
136,
134,
132,
130,
128,
126,
124,
122,
120,
118,
116,
114,
112,
110,
108,
106,
104,
102,
99,
97,
95,
93,
91,
89,
87,
84,
82,
80,
78,
76,
73,
71,
69,
67,
64,
62,
60,
58,
56,
53,
51,
49,
47,
44,
42,
40,
38,
35,
33,
31,
28,
26,
24,
22,
19,
17,
15,
13,
10,
8,
6,
4,
1,
0,
-2,
-4,
-6,
-9,
-11,
-13,
-15,
-17,
-20,
-22,
-24,
-26,
-28,
-30,
-33,
-35,
-37,
-39,
-41,
-43,
-45,
-47,
-49,
-52,
-54,
-56,
-58,
-60,
-62,
-64,
-66,
-68,
-70,
-72,
-74,
-76,
-77,
-79,
-81,
-83,
-85,
-87,
-89,
-90,
-92,
-94,
-96,
-98,
-99,
-101,
-103,
-105,
-106,
-108,
-110,
-111,
-113,
-114,
-116,
-118,
-119,
-121,
-122,
-124,
-125,
-127,
-128,
-130,
-131,
-132,
-134,
-135,
-136,
-138,
-139,
-140,
-142,
-143,
-144,
-145,
-146,
-148,
-149,
-150,
-151,
-152,
-153,
-154,
-155,
-156,
-157,
-158,
-159,
-160,
-161,
-162,
-162,
-163,
-164,
-165,
-166,
-166,
-167,
-168,
-168,
-169,
-170,
-170,
-171,
-171,
-172,
-172,
-173,
-173,
-174,
-174,
-175,
-175,
-175,
-176,
-176,
-176,
-177,
-177,
-177,
-177,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-178,
-177,
-177,
-177,
-177,
-177,
-176,
-176,
-176,
-175,
-175,
-175,
-174,
-174,
-173,
-173,
-172,
-172,
-171,
-171,
-170,
-170,
-169,
-168,
-168,
-167,
-166,
-166,
-165,
-164,
-163,
-163,
-162,
-161,
-160,
-159,
-158,
-158,
-157,
-156,
-155,
-154,
-153,
-152,
-151,
-150,
-149,
-148,
-147,
-145,
-144,
-143,
-142,
-141,
-140,
-139,
-137,
-136,
-135,
-134,
-132,
-131,
-130,
-128,
-127,
-126,
-124,
-123,
-122,
-120,
-119,
-118,
-116,
-115,
-113,
-112,
-110,
-109,
-107,
-106,
-104,
-103,
-101,
-100,
-98,
-97,
-95,
-94,
-92,
-90,
-89,
-87,
-86,
-84,
-82,
-81,
-79,
-77,
-76,
-74,
-72,
-71,
-69,
-67,
-66,
-64,
-62,
-60,
-59,
-57,
-55,
-54,
-52,
-50,
-48,
-47,
-45,
-43,
-41,
-40,
-38,
-36,
-34,
-33,
-31,
-29,
-27,
-25,
-24,
-22,
-20,
-18,
-17,
-15,
-13,
-11,
-10,
-8,
-6,
-4,
-3,
-1,
0,
2,
3,
5,
7,
8,
10,
12,
14,
15,
17,
19,
20,
22,
24,
25,
27,
29,
30,
32,
34,
35,
37,
39,
40,
42,
43,
45,
47,
48,
50,
51,
53,
54,
56,
57,
59,
60,
62,
63,
65,
66,
68,
69,
70,
72,
73,
75,
76,
77,
79,
80,
81,
83,
84,
85,
87,
88,
89,
90,
92,
93,
94,
95,
96,
97,
99,
100,
101,
102,
103,
104,
105,
106,
107,
108,
109,
110,
111,
112,
113,
114,
115,
116,
117,
117,
118,
119,
120,
121,
121,
122,
123,
124,
124,
125,
126,
126,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
135,
136,
136,
136,
136,
137,
137,
137,
137,
138,
138,
138,
138,
138,
138,
138,
138,
139,
139,
139,
139,
139,
139,
139,
138,
138,
138,
138,
138,
138,
138,
138,
137,
137,
137,
137,
136,
136,
136,
136,
135,
135,
134,
134,
134,
133,
133,
132,
132,
132,
131,
131,
130,
129,
129,
128,
128,
127,
127,
126,
125,
125,
124,
123,
123,
122,
121,
121,
120,
119,
118,
117,
117,
116,
115,
114,
113,
113,
112,
111,
110,
109,
108,
107,
106,
105,
104,
103,
102,
101,
100,
99,
98,
97,
96,
95,
94,
93,
92,
91,
90,
89,
87,
86,
85,
84,
83,
82,
81,
79,
78,
77,
76,
75,
73,
72,
71,
70,
68,
67,
66,
65,
63,
62,
61,
60,
58,
57,
56,
54,
53,
52,
50,
49,
48,
47,
45,
44,
43,
41,
40,
39,
37,
36,
34,
33,
32,
30,
29,
28,
26,
25,
24,
22,
21,
20,
18,
17,
16,
14,
13,
11,
10,
9,
7,
6,
5,
3,
2,
1,
0,
-1,
-2,
-4,
-5,
-6,
-8,
-9,
-10,
-11,
-13,
-14,
-15,
-17,
-18,
-19,
-20,
-22,
-23,
-24,
-26,
-27,
-28,
-29,
-30,
-32,
-33,
-34,
-35,
-37,
-38,
-39,
-40,
-41,
-42,
-44,
-45,
-46,
-47,
-48,
-49,
-50,
-51,
-53,
-54,
-55,
-56,
-57,
-58,
-59,
-60,
-61,
-62,
-63,
-64,
-65,
-66,
-67,
-68,
-69,
-70,
-71,
-71,
-72,
-73,
-74,
-75,
-76,
-77,
-77,
-78,
-79,
-80,
-81,
-81,
-82,
-83,
-84,
-84,
-85,
-86,
-87,
-87,
-88,
-89,
-89,
-90,
-90,
-91,
-92,
-92,
-93,
-93,
-94,
-94,
-95,
-95,
-96,
-96,
-97,
-97,
-98,
-98,
-99,
-99,
-99,
-100,
-100,
-100,
-101,
-101,
-101,
-102,
-102,
-102,
-102,
-103,
-103,
-103,
-103,
-103,
-104,
-104,
-104,
-104,
-104,
-104,
-104,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-105,
-104,
-104,
-104,
-104,
-104,
-104,
-104,
-104,
-103,
-103,
-103,
-103,
-103,
-102,
-102,
-102,
-102,
-101,
-101,
-101,
-100,
-100,
-100,
-99,
-99,
-99,
-98,
-98,
-97,
-97,
-97,
-96,
-96,
-95,
-95,
-94,
-94,
-93,
-93,
-92,
-92,
-91,
-90,
-90,
-89,
-89,
-88,
-87,
-87,
-86,
-86,
-85,
-84,
-84,
-83,
-82,
-81,
-81,
-80,
-79,
-79,
-78,
-77,
-76,
-76,
-75,
-74,
-73,
-72,
-72,
-71,
-70,
-69,
-68,
-67,
-67,
-66,
-65,
-64,
-63,
-62,
-61,
-61,
-60,
-59,
-58,
-57,
-56,
-55,
-54,
-53,
-52,
-51,
-50,
-49,
-48,
-48,
-47,
-46,
-45,
-44,
-43,
-42,
-41,
-40,
-39,
-38,
-37,
-36,
-35,
-34,
-33,
-32,
-31,
-30,
-29,
-28,
-27,
-26,
-25,
-24,
-23,
-21,
-20,
-19,
-18,
-17,
-16,
-15,
-14,
-13,
-12,
-11,
-10,
-9,
-8,
-7,
-6,
-5,
-4,
-3,
-2,
-1,
0,
0,
1,
2,
3,
4,
5,
6,
7,
8,
9,
10,
11,
12,
13,
14,
15,
16,
17,
18,
19,
20,
21,
22,
22,
23,
24,
25,
26,
27,
28,
29,
30,
31,
32,
32,
33,
34,
35,
36,
37,
38,
38,
39,
40,
41,
42,
42,
43,
44,
45,
46,
46,
47,
48,
49,
49,
50,
51,
52,
52,
53,
54,
54,
55,
56,
56,
57,
58,
58,
59,
59,
60,
61,
61,
62,
62,
63,
64,
64,
65,
65,
66,
66,
67,
67,
68,
68,
69,
69,
69,
70,
70,
71,
71,
72,
72,
72,
73,
73,
73,
74,
74,
74,
75,
75,
75,
76,
76,
76,
76,
77,
77,
77,
77,
77,
78,
78,
78,
78,
78,
78,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
79,
78,
78,
78,
78,
78,
78,
77,
77,
77,
77,
77,
76,
76,
76,
76,
75,
75,
75,
74,
74,
74,
74,
73,
73,
72,
72,
72,
71,
71,
71,
70,
70,
69,
69,
69,
68,
68,
67,
67,
66,
66,
65,
65,
64,
64,
63,
63,
62,
62,
61,
61,
60,
60,
59,
59,
58,
57,
57,
56,
56,
55,
55,
54,
53,
53,
52,
51,
51,
50,
50,
49,
48,
48,
47,
46,
46,
45,
44,
44,
43,
42,
41,
41,
40,
39,
39,
38,
37,
37,
36,
35,
34,
34,
33,
32,
31,
31,
30,
29,
28,
28,
27,
26,
25,
25,
24,
23,
22,
22,
21,
20,
19,
19,
18,
17,
16,
16,
15,
14,
13,
12,
12,
11,
10,
9,
9,
8,
7,
6,
6,
5,
4,
3,
3,
2,
1,
0,
0,
0,
-1,
-2,
-2,
-3,
-4,
-5,
-5,
-6,
-7,
-8,
-8,
-9,
-10,
-10,
-11,
-12,
-13,
-13,
-14,
-15,
-15,
-16,
-17,
-17,
-18,
-19,
-19,
-20,
-21,
-21,
-22,
-23,
-23,
-24,
-25,
-25,
-26,
-27,
-27,
-28,
-28,
-29,
-30,
-30,
-31,
-31,
-32,
-33,
-33,
-34,
-34,
-35,
-35,
-36,
-36,
-37,
-37,
-38,
-38,
-39,
-39,
-40,
-40,
-41,
-41,
-42,
-42,
-43,
-43,
-44,
-44,
-45,
-45,
-45,
-46,
-46,
-47,
-47,
-47,
-48,
-48,
-49,
-49,
-49,
-50,
-50,
-50,
-51,
-51,
-51,
-51,
-52,
-52,
-52,
-53,
-53,
-53,
-53,
-54,
-54,
-54,
-54,
-54,
-55,
-55,
-55,
-55,
-55,
-56,
-56,
-56,
-56,
-56,
-56,
-56,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-57,
-56,
-56,
-56,
-56,
-56,
-56,
-56,
-55,
-55,
-55,
-55,
-55,
-54,
-54,
-54,
-54,
-54,
-53,
-53,
-53,
-53,
-52,
-52,
-52,
-52,
-51,
-51,
-51,
-50,
-50,
-50,
-50,
-49,
-49,
-49,
-48,
-48,
-48,
-47,
-47,
-46,
-46,
-46,
-45,
-45,
-45,
-44,
-44,
-43,
-43,
-43,
-42,
-42,
-41,
-41,
-40,
-40,
-40,
-39,
-39,
-38,
-38,
-37,
-37,
-36,
-36,
-35,
-35,
-35,
-34,
-34,
-33,
-33,
-32,
-32,
-31,
-31,
-30,
-30,
-29,
-29,
-28,
-28,
-27,
-26,
-26,
-25,
-25,
-24,
-24,
-23,
-23,
-22,
-22,
-21,
-21,
-20,
-19,
-19,
-18,
-18,
-17,
-17,
-16,
-16,
-15,
-15,
-14,
-13,
-13,
-12,
-12,
-11,
-11,
-10,
-9,
-9,
-8,
-8,
-7,
-7,
-6,
-6,
-5,
-4,
-4,
-3,
-3,
-2,
-2,
-1,
-1,
0,
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
7,
7,
8,
8,
9,
9,
10,
10,
11,
11,
12,
12,
13,
13,
14,
14,
15,
15,
16,
16,
17,
17,
18,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
22,
23,
23,
24,
24,
25,
25,
25,
26,
26,
27,
27,
27,
28,
28,
28,
29,
29,
30,
30,
30,
31,
31,
31,
32,
32,
32,
33,
33,
33,
33,
34,
34,
34,
35,
35,
35,
35,
36,
36,
36,
36,
37,
37,
37,
37,
38,
38,
38,
38,
38,
39,
39,
39,
39,
39,
40,
40,
40,
40,
40,
40,
40,
41,
41,
41,
41,
41,
41,
41,
41,
41,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
42,
41,
41,
41,
41,
41,
41,
41,
41,
41,
41,
40,
40,
40,
40,
40,
40,
40,
39,
39,
39,
39,
39,
38,
38,
38,
38,
38,
37,
37,
37,
37,
37,
36,
36,
36,
36,
35,
35,
35,
35,
34,
34,
34,
34,
33,
33,
33,
33,
32,
32,
32,
31,
31,
31,
30,
30,
30,
30,
29,
29,
29,
28,
28,
28,
27,
27,
27,
26,
26,
26,
25,
25,
25,
24,
24,
23,
23,
23,
22,
22,
22,
21,
21,
21,
20,
20,
19,
19,
19,
18,
18,
18,
17,
17,
16,
16,
16,
15,
15,
14,
14,
14,
13,
13,
12,
12,
12,
11,
11,
10,
10,
10,
9,
9,
8,
8,
8,
7,
7,
6,
6,
6,
5,
5,
4,
4,
4,
3,
3,
2,
2,
2,
1,
1,
1,
0,
0,
0,
0,
0,
-1,
-1,
-2,
-2,
-2,
-3,
-3,
-3,
-4,
-4,
-5,
-5,
-5,
-6,
-6,
-6,
-7,
-7,
-7,
-8,
-8,
-9,
-9,
-9,
-10,
-10,
-10,
-11,
-11,
-11,
-12,
-12,
-12,
-13,
-13,
-13,
-14,
-14,
-14,
-14,
-15,
-15,
-15,
-16,
-16,
-16,
-17,
-17,
-17,
-17,
-18,
-18,
-18,
-19,
-19,
-19,
-19,
-20,
-20,
-20,
-20,
-21,
-21,
-21,
-21,
-21,
-22,
-22,
-22,
-22,
-23,
-23,
-23,
-23,
-23,
-24,
-24,
-24,
-24,
-24,
-25,
-25,
-25,
-25,
-25,
-25,
-26,
-26,
-26,
-26,
-26,
-26,
-26,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-29,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-28,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-27,
-26,
-26,
-26,
-26,
-26,
-26,
-26,
-25,
-25,
-25,
-25,
-25,
-25,
-25,
-24,
-24,
-24,
-24,
-24,
-24,
-23,
-23,
-23,
-23,
-23,
-22,
-22,
-22,
-22,
-22,
-21,
-21,
-21,
-21,
-21,
-20,
-20,
-20,
-20,
-20,
-19,
-19,
-19,
-19,
-18,
-18,
-18,
-18,
-17,
-17,
-17,
-17,
-16,
-16,
-16,
-16,
-15,
-15,
-15,
-15,
-14,
-14,
-14,
-14,
-13,
-13,
-13,
-13,
-12,
-12,
-12,
-12,
-11,
-11,
-11,
-11,
-10,
-10,
-10,
-9,
-9,
-9,
-9,
-8,
-8,
-8,
-7,
-7,
-7,
-7,
-6,
-6,
-6,
-6,
-5,
-5,
-5,
-4,
-4,
-4,
-4,
-3,
-3,
-3,
-2,
-2,
-2,
-2,
-1,
-1,
-1,
-1,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
1,
2,
2,
2,
2,
3,
3,
3,
3,
4,
4,
4,
5,
5,
5,
5,
6,
6,
6,
6,
6,
7,
7,
7,
7,
8,
8,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
11,
11,
11,
11,
11,
12,
12,
12,
12,
12,
13,
13,
13,
13,
13,
14,
14,
14,
14,
14,
14,
15,
15,
15,
15,
15,
15,
16,
16,
16,
16,
16,
16,
16,
17,
17,
17,
17,
17,
17,
17,
17,
18,
18,
18,
18,
18,
18,
18,
18,
18,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
20,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
19,
18,
18,
18,
18,
18,
18,
18,
18,
18,
18,
17,
17,
17,
17,
17,
17,
17,
17,
16,
16,
16,
16,
16,
16,
16,
16,
15,
15,
15,
15,
15,
15,
15,
14,
14,
14,
14,
14,
14,
14,
13,
13,
13,
13,
13,
13,
12,
12,
12,
12,
12,
12,
11,
11,
11,
11,
11,
11,
10,
10,
10,
10,
10,
9,
9,
9,
9,
9,
9,
8,
8,
8,
8,
8,
7,
7,
7,
7,
7,
7,
6,
6,
6,
6,
6,
5,
5,
5,
5,
5,
4,
4,
4,
4,
4,
4,
3,
3,
3,
3,
3,
2,
2,
2,
2,
2,
2,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-3,
-3,
-3,
-3,
-3,
-4,
-4,
-4,
-4,
-4,
-4,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
8,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
7,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
6,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};

static HWORD LARGE_FILTER_IMPD[] /* Impulse response differences */ = {
-1,
-2,
-3,
-5,
-6,
-7,
-9,
-10,
-11,
-13,
-14,
-15,
-17,
-18,
-19,
-21,
-22,
-23,
-25,
-26,
-27,
-28,
-30,
-32,
-32,
-34,
-35,
-36,
-38,
-39,
-40,
-42,
-43,
-44,
-45,
-47,
-48,
-49,
-51,
-52,
-53,
-54,
-56,
-56,
-58,
-60,
-60,
-62,
-63,
-64,
-66,
-66,
-68,
-69,
-70,
-72,
-72,
-74,
-75,
-76,
-77,
-79,
-79,
-81,
-82,
-83,
-84,
-85,
-87,
-87,
-89,
-90,
-90,
-92,
-93,
-94,
-95,
-96,
-98,
-98,
-99,
-100,
-102,
-102,
-103,
-105,
-105,
-106,
-108,
-108,
-109,
-110,
-111,
-112,
-113,
-114,
-115,
-116,
-116,
-118,
-118,
-119,
-121,
-120,
-122,
-123,
-123,
-125,
-125,
-126,
-126,
-128,
-128,
-129,
-130,
-130,
-132,
-132,
-132,
-134,
-134,
-135,
-135,
-136,
-137,
-137,
-138,
-139,
-139,
-140,
-141,
-141,
-142,
-142,
-143,
-143,
-144,
-145,
-145,
-145,
-146,
-147,
-147,
-147,
-148,
-149,
-148,
-150,
-149,
-150,
-151,
-151,
-151,
-152,
-152,
-152,
-153,
-153,
-153,
-153,
-154,
-154,
-155,
-155,
-155,
-155,
-155,
-156,
-156,
-156,
-156,
-156,
-157,
-157,
-157,
-157,
-157,
-157,
-157,
-158,
-157,
-158,
-158,
-157,
-158,
-158,
-158,
-158,
-157,
-158,
-158,
-158,
-157,
-158,
-158,
-157,
-158,
-157,
-157,
-157,
-157,
-157,
-157,
-157,
-156,
-156,
-156,
-156,
-156,
-155,
-155,
-155,
-155,
-155,
-154,
-154,
-153,
-154,
-153,
-153,
-152,
-152,
-152,
-151,
-151,
-151,
-150,
-150,
-150,
-149,
-149,
-148,
-148,
-147,
-147,
-147,
-146,
-145,
-145,
-145,
-144,
-144,
-143,
-142,
-142,
-142,
-141,
-140,
-140,
-139,
-139,
-138,
-137,
-137,
-136,
-136,
-135,
-134,
-134,
-133,
-132,
-132,
-131,
-130,
-130,
-129,
-128,
-128,
-126,
-126,
-126,
-125,
-123,
-124,
-122,
-122,
-121,
-120,
-119,
-119,
-117,
-117,
-117,
-115,
-114,
-113,
-113,
-112,
-112,
-110,
-110,
-108,
-108,
-107,
-106,
-106,
-104,
-104,
-102,
-102,
-101,
-100,
-99,
-98,
-98,
-96,
-95,
-95,
-94,
-92,
-92,
-91,
-90,
-89,
-88,
-87,
-86,
-85,
-85,
-83,
-82,
-82,
-80,
-80,
-78,
-78,
-76,
-76,
-75,
-73,
-73,
-72,
-70,
-70,
-69,
-68,
-66,
-66,
-65,
-64,
-63,
-61,
-61,
-60,
-59,
-58,
-57,
-56,
-55,
-54,
-53,
-51,
-51,
-50,
-49,
-48,
-47,
-46,
-45,
-44,
-43,
-42,
-41,
-41,
-39,
-38,
-37,
-36,
-35,
-34,
-34,
-32,
-31,
-31,
-29,
-28,
-28,
-26,
-26,
-24,
-24,
-23,
-21,
-21,
-20,
-19,
-18,
-17,
-16,
-15,
-14,
-13,
-13,
-11,
-11,
-9,
-9,
-8,
-7,
-6,
-5,
-5,
-3,
-2,
-2,
-1,
0,
1,
2,
2,
4,
4,
5,
6,
7,
8,
8,
10,
10,
11,
11,
13,
13,
14,
15,
15,
17,
17,
18,
18,
20,
20,
21,
21,
23,
23,
23,
25,
25,
26,
26,
27,
28,
28,
30,
29,
31,
31,
32,
32,
33,
34,
34,
35,
35,
36,
37,
37,
37,
39,
39,
39,
40,
40,
41,
42,
42,
42,
43,
44,
44,
44,
45,
46,
45,
47,
46,
48,
47,
48,
49,
49,
49,
49,
50,
51,
51,
51,
51,
52,
52,
53,
53,
53,
53,
54,
54,
54,
55,
55,
55,
55,
56,
56,
56,
56,
57,
57,
57,
57,
58,
57,
58,
58,
58,
58,
59,
58,
59,
59,
59,
59,
59,
59,
59,
60,
59,
60,
59,
60,
60,
60,
59,
60,
60,
60,
60,
59,
60,
60,
60,
60,
59,
60,
60,
59,
60,
59,
60,
59,
59,
59,
59,
59,
59,
59,
58,
59,
58,
58,
58,
58,
57,
58,
57,
57,
57,
57,
55,
57,
56,
56,
55,
56,
55,
55,
54,
55,
54,
54,
54,
53,
53,
53,
52,
53,
52,
51,
52,
51,
50,
51,
50,
49,
50,
49,
48,
49,
48,
47,
47,
47,
47,
46,
46,
45,
45,
45,
44,
44,
43,
43,
42,
43,
41,
42,
40,
41,
40,
39,
40,
38,
39,
37,
38,
37,
36,
36,
35,
36,
34,
34,
34,
33,
33,
32,
32,
31,
31,
30,
30,
29,
29,
28,
28,
27,
27,
26,
26,
25,
25,
24,
24,
24,
22,
23,
21,
21,
21,
20,
20,
19,
19,
18,
18,
17,
16,
16,
16,
15,
14,
14,
14,
13,
12,
12,
11,
11,
11,
9,
10,
8,
9,
7,
8,
6,
7,
5,
5,
5,
4,
4,
3,
3,
2,
1,
1,
1,
0,
0,
-1,
-1,
-2,
-3,
-3,
-3,
-4,
-4,
-5,
-5,
-6,
-6,
-7,
-7,
-8,
-8,
-8,
-9,
-10,
-10,
-10,
-11,
-11,
-12,
-12,
-13,
-13,
-14,
-14,
-14,
-15,
-15,
-16,
-16,
-16,
-17,
-18,
-17,
-18,
-19,
-19,
-19,
-20,
-20,
-21,
-20,
-22,
-21,
-22,
-23,
-22,
-23,
-24,
-23,
-25,
-24,
-25,
-25,
-25,
-26,
-26,
-27,
-26,
-27,
-28,
-27,
-28,
-28,
-29,
-29,
-29,
-29,
-30,
-30,
-30,
-30,
-31,
-31,
-31,
-31,
-32,
-32,
-32,
-32,
-33,
-33,
-33,
-33,
-33,
-34,
-34,
-34,
-34,
-34,
-35,
-34,
-35,
-35,
-35,
-36,
-35,
-36,
-35,
-36,
-36,
-36,
-37,
-36,
-36,
-37,
-37,
-36,
-37,
-37,
-37,
-37,
-37,
-38,
-37,
-37,
-38,
-37,
-38,
-37,
-38,
-37,
-38,
-38,
-37,
-38,
-38,
-37,
-38,
-38,
-37,
-38,
-38,
-37,
-38,
-37,
-38,
-37,
-38,
-37,
-38,
-37,
-37,
-37,
-37,
-37,
-37,
-37,
-37,
-35,
-37,
-36,
-37,
-36,
-36,
-36,
-36,
-36,
-35,
-36,
-35,
-36,
-35,
-35,
-34,
-35,
-34,
-35,
-34,
-34,
-34,
-33,
-34,
-33,
-33,
-33,
-32,
-33,
-32,
-32,
-32,
-32,
-31,
-31,
-31,
-31,
-31,
-30,
-30,
-30,
-29,
-30,
-29,
-29,
-28,
-28,
-29,
-27,
-28,
-27,
-27,
-27,
-26,
-27,
-25,
-26,
-25,
-26,
-24,
-25,
-24,
-24,
-23,
-24,
-23,
-22,
-23,
-22,
-22,
-21,
-21,
-21,
-21,
-20,
-20,
-19,
-19,
-19,
-19,
-18,
-18,
-18,
-17,
-17,
-17,
-16,
-16,
-15,
-16,
-14,
-15,
-14,
-14,
-14,
-13,
-13,
-12,
-12,
-12,
-12,
-11,
-10,
-11,
-10,
-10,
-9,
-9,
-9,
-8,
-8,
-8,
-7,
-7,
-6,
-6,
-6,
-6,
-5,
-5,
-4,
-4,
-4,
-3,
-3,
-3,
-2,
-2,
-2,
-1,
-1,
-1,
0,
0,
0,
1,
1,
2,
1,
3,
2,
3,
3,
4,
3,
4,
5,
5,
5,
5,
6,
6,
7,
6,
8,
7,
8,
8,
8,
9,
9,
9,
10,
9,
11,
10,
11,
11,
11,
12,
12,
12,
13,
13,
13,
13,
14,
14,
14,
14,
15,
15,
15,
16,
16,
16,
16,
17,
16,
18,
17,
17,
18,
18,
18,
19,
19,
19,
19,
19,
20,
19,
20,
21,
20,
21,
21,
21,
21,
21,
22,
22,
22,
22,
22,
23,
22,
23,
23,
23,
23,
24,
24,
23,
24,
24,
24,
25,
24,
25,
24,
25,
25,
25,
25,
26,
25,
26,
25,
26,
26,
25,
26,
26,
26,
27,
26,
26,
27,
26,
27,
26,
27,
26,
27,
27,
27,
26,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
27,
26,
27,
27,
27,
27,
26,
27,
27,
26,
26,
26,
27,
26,
26,
27,
26,
26,
26,
26,
26,
26,
25,
26,
25,
26,
25,
25,
25,
25,
25,
25,
25,
24,
24,
25,
24,
24,
24,
23,
24,
24,
23,
23,
23,
23,
23,
22,
23,
22,
22,
22,
22,
21,
22,
21,
21,
21,
21,
20,
20,
21,
20,
19,
20,
19,
19,
19,
19,
19,
18,
18,
18,
18,
18,
17,
17,
17,
17,
16,
16,
16,
16,
16,
15,
15,
15,
14,
15,
14,
14,
14,
13,
13,
13,
13,
12,
13,
12,
11,
12,
11,
11,
11,
10,
11,
10,
9,
10,
9,
9,
9,
8,
9,
8,
7,
8,
7,
7,
7,
6,
6,
6,
6,
5,
5,
5,
5,
4,
4,
4,
3,
4,
3,
3,
2,
2,
2,
2,
2,
1,
1,
0,
1,
0,
0,
0,
-1,
-1,
-1,
-1,
-2,
-2,
-2,
-2,
-3,
-2,
-4,
-3,
-3,
-4,
-4,
-5,
-4,
-5,
-5,
-5,
-6,
-6,
-6,
-6,
-7,
-6,
-7,
-7,
-8,
-7,
-8,
-8,
-9,
-8,
-9,
-9,
-9,
-10,
-9,
-10,
-10,
-10,
-11,
-10,
-11,
-11,
-12,
-11,
-12,
-12,
-12,
-12,
-13,
-12,
-13,
-13,
-13,
-14,
-13,
-14,
-14,
-14,
-14,
-15,
-14,
-15,
-15,
-15,
-15,
-16,
-15,
-16,
-16,
-16,
-16,
-16,
-17,
-16,
-17,
-17,
-17,
-17,
-17,
-18,
-17,
-18,
-18,
-17,
-18,
-18,
-19,
-18,
-18,
-19,
-18,
-19,
-19,
-19,
-19,
-19,
-19,
-19,
-19,
-20,
-19,
-20,
-19,
-20,
-20,
-20,
-19,
-20,
-20,
-20,
-20,
-20,
-21,
-20,
-20,
-20,
-21,
-20,
-20,
-21,
-20,
-21,
-20,
-20,
-21,
-20,
-21,
-20,
-21,
-20,
-21,
-20,
-21,
-21,
-20,
-20,
-21,
-20,
-21,
-20,
-21,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-20,
-19,
-20,
-20,
-19,
-20,
-19,
-19,
-19,
-20,
-19,
-19,
-18,
-19,
-19,
-19,
-18,
-18,
-19,
-18,
-18,
-18,
-18,
-18,
-18,
-17,
-18,
-17,
-17,
-17,
-17,
-17,
-17,
-16,
-17,
-16,
-16,
-17,
-15,
-16,
-16,
-15,
-16,
-15,
-15,
-15,
-15,
-15,
-14,
-14,
-15,
-14,
-13,
-14,
-14,
-13,
-13,
-13,
-13,
-13,
-13,
-12,
-12,
-12,
-12,
-12,
-11,
-12,
-11,
-11,
-11,
-10,
-11,
-10,
-10,
-10,
-9,
-10,
-9,
-9,
-9,
-9,
-9,
-8,
-8,
-8,
-8,
-8,
-7,
-7,
-7,
-7,
-7,
-6,
-6,
-6,
-6,
-6,
-5,
-5,
-6,
-4,
-5,
-4,
-5,
-4,
-4,
-3,
-4,
-3,
-3,
-3,
-2,
-3,
-2,
-2,
-2,
-1,
-2,
-1,
-1,
-1,
0,
-1,
0,
0,
0,
1,
0,
1,
1,
1,
1,
2,
2,
2,
2,
2,
3,
3,
2,
4,
3,
3,
4,
4,
4,
4,
5,
4,
5,
5,
5,
6,
5,
6,
6,
6,
6,
7,
6,
7,
7,
7,
7,
8,
7,
8,
8,
8,
8,
9,
8,
9,
9,
9,
9,
10,
9,
10,
10,
10,
10,
10,
11,
10,
11,
11,
11,
11,
11,
11,
12,
11,
12,
12,
12,
12,
12,
13,
12,
13,
13,
12,
13,
13,
14,
13,
13,
14,
13,
14,
14,
13,
14,
14,
15,
14,
14,
14,
15,
14,
15,
15,
14,
15,
15,
15,
15,
15,
16,
15,
15,
15,
16,
15,
16,
15,
16,
15,
16,
16,
16,
15,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
17,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
16,
15,
16,
16,
16,
16,
16,
15,
16,
16,
15,
16,
16,
15,
15,
16,
15,
16,
15,
15,
15,
15,
15,
15,
15,
15,
15,
14,
15,
14,
15,
14,
14,
15,
14,
14,
14,
14,
13,
14,
14,
13,
13,
14,
13,
13,
13,
13,
13,
12,
13,
12,
13,
12,
12,
12,
12,
12,
12,
11,
12,
11,
11,
11,
11,
11,
11,
10,
11,
10,
10,
10,
10,
10,
10,
9,
10,
9,
9,
9,
9,
8,
9,
8,
9,
8,
8,
8,
7,
8,
7,
7,
7,
7,
7,
7,
6,
7,
6,
6,
6,
5,
6,
5,
5,
6,
4,
5,
5,
4,
5,
4,
4,
4,
3,
4,
3,
3,
3,
3,
3,
2,
3,
2,
2,
2,
2,
1,
2,
1,
1,
1,
1,
1,
0,
0,
1,
0,
-1,
0,
0,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-3,
-3,
-3,
-3,
-4,
-3,
-4,
-4,
-4,
-4,
-4,
-5,
-4,
-5,
-5,
-5,
-5,
-5,
-6,
-5,
-6,
-6,
-6,
-6,
-6,
-6,
-7,
-6,
-7,
-7,
-7,
-7,
-7,
-7,
-8,
-8,
-7,
-8,
-8,
-8,
-8,
-9,
-8,
-9,
-8,
-9,
-9,
-9,
-9,
-9,
-9,
-10,
-9,
-10,
-9,
-10,
-10,
-10,
-10,
-10,
-10,
-11,
-10,
-11,
-10,
-11,
-11,
-11,
-10,
-11,
-11,
-12,
-11,
-11,
-11,
-12,
-11,
-12,
-12,
-11,
-12,
-12,
-12,
-11,
-12,
-12,
-13,
-12,
-12,
-12,
-12,
-13,
-12,
-12,
-13,
-12,
-13,
-12,
-13,
-12,
-13,
-13,
-12,
-13,
-13,
-13,
-12,
-13,
-13,
-13,
-13,
-12,
-13,
-13,
-13,
-13,
-13,
-13,
-12,
-13,
-13,
-13,
-13,
-13,
-13,
-13,
-12,
-13,
-13,
-13,
-13,
-11,
-13,
-13,
-12,
-13,
-13,
-12,
-13,
-12,
-13,
-12,
-13,
-12,
-13,
-12,
-12,
-13,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-12,
-11,
-12,
-12,
-11,
-12,
-11,
-11,
-12,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-11,
-10,
-11,
-10,
-11,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-10,
-9,
-10,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-9,
-8,
-9,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-7,
-7,
-8,
-7,
-7,
-7,
-7,
-6,
-7,
-7,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-5,
-6,
-5,
-5,
-5,
-5,
-5,
-4,
-5,
-4,
-5,
-4,
-4,
-4,
-4,
-3,
-4,
-3,
-4,
-3,
-3,
-3,
-3,
-2,
-3,
-2,
-2,
-3,
-2,
-1,
-2,
-2,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
0,
-1,
0,
0,
0,
0,
0,
0,
1,
0,
1,
1,
0,
2,
1,
1,
1,
2,
2,
1,
2,
2,
3,
2,
2,
3,
2,
3,
3,
3,
3,
3,
4,
3,
4,
4,
3,
4,
4,
4,
5,
4,
5,
4,
5,
5,
5,
5,
5,
5,
5,
6,
5,
6,
6,
6,
6,
6,
6,
6,
6,
7,
6,
7,
7,
7,
7,
7,
7,
7,
7,
7,
8,
7,
8,
8,
7,
8,
8,
8,
8,
8,
8,
9,
8,
9,
8,
9,
8,
9,
9,
8,
9,
9,
9,
9,
9,
10,
9,
9,
9,
10,
9,
10,
9,
10,
10,
9,
10,
10,
9,
10,
10,
10,
10,
10,
10,
10,
10,
10,
10,
11,
10,
10,
10,
10,
11,
10,
10,
11,
10,
10,
11,
10,
10,
11,
10,
10,
11,
10,
11,
10,
11,
10,
10,
11,
10,
10,
11,
10,
11,
10,
10,
10,
10,
10,
10,
11,
10,
10,
10,
10,
11,
10,
10,
10,
10,
10,
10,
10,
10,
9,
10,
10,
10,
9,
10,
10,
9,
10,
9,
10,
9,
9,
10,
9,
9,
9,
9,
9,
9,
9,
9,
9,
8,
9,
9,
8,
9,
8,
8,
9,
8,
8,
8,
8,
8,
8,
7,
8,
8,
7,
8,
7,
7,
8,
7,
7,
7,
7,
6,
7,
7,
6,
7,
6,
7,
6,
6,
6,
6,
6,
6,
5,
6,
5,
6,
5,
5,
5,
5,
5,
5,
5,
4,
5,
4,
5,
4,
4,
4,
4,
4,
4,
3,
4,
3,
4,
3,
3,
3,
3,
3,
3,
2,
3,
2,
2,
3,
2,
2,
2,
1,
2,
2,
1,
2,
1,
1,
1,
1,
1,
1,
0,
1,
0,
1,
0,
0,
0,
0,
0,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-3,
-2,
-3,
-3,
-3,
-3,
-3,
-3,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-4,
-5,
-4,
-4,
-4,
-5,
-4,
-5,
-5,
-5,
-4,
-5,
-5,
-6,
-5,
-5,
-5,
-6,
-5,
-6,
-5,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-7,
-6,
-6,
-7,
-6,
-7,
-7,
-6,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-8,
-7,
-7,
-8,
-7,
-8,
-7,
-8,
-7,
-8,
-7,
-8,
-8,
-8,
-8,
-7,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-9,
-8,
-8,
-8,
-8,
-9,
-8,
-8,
-8,
-9,
-8,
-8,
-9,
-8,
-9,
-8,
-8,
-9,
-8,
-9,
-8,
-9,
-8,
-8,
-9,
-8,
-9,
-8,
-9,
-8,
-9,
-8,
-8,
-9,
-8,
-9,
-8,
-7,
-9,
-8,
-8,
-9,
-8,
-8,
-9,
-8,
-8,
-8,
-8,
-8,
-9,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-8,
-7,
-8,
-8,
-8,
-7,
-8,
-8,
-7,
-8,
-7,
-8,
-7,
-8,
-7,
-7,
-7,
-8,
-7,
-7,
-7,
-7,
-7,
-7,
-7,
-6,
-7,
-7,
-6,
-7,
-7,
-6,
-6,
-7,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-6,
-5,
-6,
-5,
-6,
-5,
-5,
-6,
-5,
-5,
-5,
-5,
-5,
-4,
-5,
-5,
-4,
-5,
-4,
-5,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-3,
-4,
-3,
-4,
-3,
-3,
-3,
-4,
-3,
-2,
-3,
-3,
-3,
-2,
-3,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-2,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
0,
-1,
-1,
-1,
0,
-1,
0,
0,
-1,
0,
0,
0,
0,
0,
1,
0,
1,
0,
1,
0,
1,
1,
1,
1,
1,
1,
1,
2,
1,
2,
1,
2,
2,
2,
1,
2,
2,
3,
2,
2,
2,
3,
2,
3,
3,
2,
3,
3,
3,
3,
3,
3,
4,
3,
3,
4,
3,
4,
3,
4,
4,
4,
4,
4,
4,
4,
4,
4,
5,
4,
4,
5,
5,
4,
5,
5,
4,
5,
5,
5,
5,
5,
5,
5,
6,
5,
5,
5,
6,
5,
6,
5,
6,
6,
5,
6,
6,
6,
5,
6,
6,
6,
6,
6,
6,
7,
6,
6,
6,
6,
7,
6,
6,
7,
6,
7,
6,
6,
7,
7,
6,
7,
6,
7,
6,
7,
7,
7,
6,
7,
7,
6,
7,
7,
7,
7,
6,
7,
7,
7,
7,
7,
6,
7,
7,
7,
7,
7,
7,
6,
7,
7,
7,
7,
7,
7,
6,
7,
7,
6,
7,
6,
7,
7,
7,
6,
7,
7,
6,
7,
7,
6,
7,
7,
6,
7,
6,
7,
6,
7,
6,
6,
7,
6,
6,
7,
6,
6,
6,
6,
6,
7,
6,
6,
6,
6,
5,
6,
6,
6,
6,
5,
6,
6,
5,
6,
5,
6,
5,
5,
6,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
5,
4,
5,
4,
5,
4,
5,
4,
4,
4,
5,
4,
4,
4,
4,
3,
4,
4,
4,
3,
4,
3,
4,
3,
3,
4,
3,
3,
3,
3,
3,
3,
2,
3,
3,
2,
3,
2,
3,
2,
2,
3,
2,
2,
2,
2,
2,
1,
2,
2,
1,
2,
1,
2,
1,
1,
1,
2,
1,
1,
0,
1,
1,
1,
0,
1,
0,
1,
0,
0,
1,
0,
0,
0,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-3,
-2,
-3,
-2,
-3,
-3,
-2,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-5,
-4,
-4,
-5,
-4,
-4,
-5,
-4,
-5,
-4,
-5,
-5,
-4,
-5,
-5,
-4,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-6,
-5,
-5,
-5,
-5,
-6,
-5,
-5,
-6,
-5,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-5,
-6,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-6,
-6,
-5,
-6,
-5,
-5,
-5,
-6,
-5,
-6,
-5,
-6,
-5,
-5,
-6,
-5,
-6,
-5,
-5,
-6,
-5,
-5,
-6,
-5,
-5,
-5,
-6,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-5,
-4,
-5,
-5,
-5,
-4,
-5,
-5,
-4,
-5,
-4,
-5,
-4,
-4,
-5,
-4,
-4,
-5,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-4,
-3,
-4,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-3,
-4,
-3,
-3,
-3,
-3,
-3,
-2,
-3,
-3,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-1,
-2,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
1,
0,
1,
0,
1,
1,
1,
0,
1,
1,
1,
1,
1,
2,
1,
1,
1,
2,
1,
2,
1,
2,
1,
2,
2,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
2,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
3,
3,
3,
2,
3,
3,
3,
3,
3,
4,
3,
3,
3,
3,
4,
3,
3,
4,
3,
4,
3,
4,
3,
4,
3,
4,
4,
3,
4,
4,
4,
4,
3,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
4,
5,
4,
4,
4,
4,
5,
4,
4,
4,
5,
4,
4,
5,
4,
4,
5,
4,
5,
4,
4,
5,
4,
5,
4,
5,
4,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
4,
5,
3,
4,
5,
4,
5,
4,
4,
5,
4,
5,
4,
4,
5,
4,
4,
5,
4,
4,
4,
4,
5,
4,
4,
4,
4,
4,
5,
4,
4,
4,
4,
4,
4,
4,
3,
4,
4,
4,
4,
4,
3,
4,
4,
4,
3,
4,
4,
3,
4,
3,
4,
3,
3,
4,
3,
4,
3,
3,
3,
4,
3,
3,
3,
3,
3,
3,
3,
3,
3,
3,
2,
3,
3,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
2,
3,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
1,
2,
2,
1,
2,
1,
2,
1,
1,
2,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-3,
-3,
-2,
-3,
-3,
-3,
-3,
-2,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-4,
-3,
-3,
-3,
-3,
-4,
-3,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-4,
-3,
-3,
-3,
-4,
-3,
-4,
-4,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-3,
-4,
-3,
-4,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-4,
-3,
-3,
-3,
-3,
-4,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-3,
-2,
-3,
-3,
-3,
-2,
-3,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-3,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
2,
1,
1,
1,
2,
1,
1,
2,
1,
1,
2,
1,
2,
1,
2,
1,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
3,
2,
2,
2,
3,
2,
2,
3,
2,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
3,
2,
3,
2,
3,
3,
2,
3,
3,
3,
2,
3,
3,
2,
3,
3,
3,
3,
2,
3,
3,
3,
3,
2,
3,
3,
3,
3,
3,
2,
3,
3,
3,
3,
3,
3,
3,
2,
3,
3,
3,
3,
3,
3,
2,
3,
3,
3,
3,
3,
3,
2,
2,
3,
3,
3,
2,
3,
3,
3,
3,
2,
3,
3,
3,
2,
3,
3,
3,
2,
3,
3,
2,
3,
3,
2,
3,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
3,
2,
2,
3,
2,
2,
3,
2,
2,
3,
2,
2,
2,
2,
2,
3,
2,
2,
2,
2,
2,
2,
2,
2,
2,
2,
1,
2,
2,
2,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
1,
2,
1,
1,
2,
1,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
0,
1,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-2,
-1,
-2,
-2,
-1,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-3,
-1,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-3,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-2,
-1,
-2,
-2,
-2,
-1,
-2,
-2,
-1,
-2,
-1,
-2,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
1,
0,
1,
1,
1,
0,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
2,
1,
1,
1,
2,
1,
1,
2,
1,
1,
2,
1,
1,
2,
1,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
2,
1,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
2,
1,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
1,
2,
2,
2,
1,
2,
1,
2,
1,
2,
2,
1,
2,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
2,
1,
2,
1,
2,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
2,
1,
1,
2,
1,
2,
1,
1,
2,
1,
1,
2,
1,
1,
2,
1,
1,
1,
2,
1,
1,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
0,
1,
1,
1,
0,
1,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-2,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
1,
0,
1,
1,
1,
0,
1,
1,
0,
1,
1,
1,
0,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
2,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
1,
1,
0,
1,
1,
1,
1,
0,
1,
1,
1,
1,
0,
1,
1,
1,
0,
1,
1,
1,
0,
1,
1,
0,
1,
1,
0,
1,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
0,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
1,
0,
0,
1,
0,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
1,
0,
0,
1,
0,
1,
0,
0,
1,
0,
0,
1,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0};
