#pragma once

#include "utils/split.hpp"
#include <optional>
#include <set>
#include <sstream>
#include <unordered_map>
#include <vector>

/**
 * Parse a list of IRC caps into a map of capabilities
 */
const std::unordered_map<std::string, std::optional<std::string>>
parse_caps(const std::string &caps);

/**
 * Parse the value of a cap into a list of values
 *
 * Used for the sasl cap
 */
const std::vector<std::string> parse_cap_val_list(const std::string &value);

/**
 * Parse the value of a cap into a key-value map
 *
 * Used for the multiline cap
 */
const std::unordered_map<std::string, std::optional<std::string>>
parse_cap_keyval(const std::string &value);
