//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-core-video")]
use objc2_core_video::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-io-surface")]
use objc2_io_surface::*;
#[cfg(feature = "objc2-metal")]
use objc2_metal::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coreimage/cirenderdestinationalphamode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CIRenderDestinationAlphaMode(pub NSUInteger);
impl CIRenderDestinationAlphaMode {
    #[doc(alias = "CIRenderDestinationAlphaNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "CIRenderDestinationAlphaPremultiplied")]
    pub const Premultiplied: Self = Self(1);
    #[doc(alias = "CIRenderDestinationAlphaUnpremultiplied")]
    pub const Unpremultiplied: Self = Self(2);
}

unsafe impl Encode for CIRenderDestinationAlphaMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for CIRenderDestinationAlphaMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/cirenderdestination?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIRenderDestination;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIRenderDestination {}
);

impl CIRenderDestination {
    extern_methods!(
        #[cfg(feature = "objc2-core-video")]
        #[unsafe(method(initWithPixelBuffer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPixelBuffer(
            this: Allocated<Self>,
            pixel_buffer: &CVPixelBuffer,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-io-surface")]
        #[unsafe(method(initWithIOSurface:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithIOSurface(
            this: Allocated<Self>,
            surface: &IOSurface,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-metal")]
        /// # Safety
        ///
        /// - `texture` may need to be synchronized.
        /// - `texture` may be unretained, you must ensure it is kept alive while in use.
        #[unsafe(method(initWithMTLTexture:commandBuffer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMTLTexture_commandBuffer(
            this: Allocated<Self>,
            texture: &ProtocolObject<dyn MTLTexture>,
            command_buffer: Option<&ProtocolObject<dyn MTLCommandBuffer>>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "block2", feature = "objc2-metal"))]
        /// # Safety
        ///
        /// `block` block's return must be a valid pointer.
        #[unsafe(method(initWithWidth:height:pixelFormat:commandBuffer:mtlTextureProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithWidth_height_pixelFormat_commandBuffer_mtlTextureProvider(
            this: Allocated<Self>,
            width: NSUInteger,
            height: NSUInteger,
            pixel_format: MTLPixelFormat,
            command_buffer: Option<&ProtocolObject<dyn MTLCommandBuffer>>,
            block: Option<&block2::DynBlock<dyn Fn() -> NonNull<ProtocolObject<dyn MTLTexture>>>>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithGLTexture:target:width:height:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithGLTexture_target_width_height(
            this: Allocated<Self>,
            texture: c_uint,
            target: c_uint,
            width: NSUInteger,
            height: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "CIImage")]
        /// # Safety
        ///
        /// `data` must be a valid pointer.
        #[unsafe(method(initWithBitmapData:width:height:bytesPerRow:format:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBitmapData_width_height_bytesPerRow_format(
            this: Allocated<Self>,
            data: NonNull<c_void>,
            width: NSUInteger,
            height: NSUInteger,
            bytes_per_row: NSUInteger,
            format: CIFormat,
        ) -> Retained<Self>;

        #[unsafe(method(width))]
        #[unsafe(method_family = none)]
        pub unsafe fn width(&self) -> NSUInteger;

        #[unsafe(method(height))]
        #[unsafe(method_family = none)]
        pub unsafe fn height(&self) -> NSUInteger;

        #[unsafe(method(alphaMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn alphaMode(&self) -> CIRenderDestinationAlphaMode;

        /// Setter for [`alphaMode`][Self::alphaMode].
        #[unsafe(method(setAlphaMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlphaMode(&self, alpha_mode: CIRenderDestinationAlphaMode);

        #[unsafe(method(isFlipped))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFlipped(&self) -> bool;

        /// Setter for [`isFlipped`][Self::isFlipped].
        #[unsafe(method(setFlipped:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFlipped(&self, flipped: bool);

        #[unsafe(method(isDithered))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDithered(&self) -> bool;

        /// Setter for [`isDithered`][Self::isDithered].
        #[unsafe(method(setDithered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDithered(&self, dithered: bool);

        #[unsafe(method(isClamped))]
        #[unsafe(method_family = none)]
        pub unsafe fn isClamped(&self) -> bool;

        /// Setter for [`isClamped`][Self::isClamped].
        #[unsafe(method(setClamped:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClamped(&self, clamped: bool);

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorSpace(&self) -> Option<Retained<CGColorSpace>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Setter for [`colorSpace`][Self::colorSpace].
        #[unsafe(method(setColorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setColorSpace(&self, color_space: Option<&CGColorSpace>);

        #[cfg(feature = "CIKernel")]
        #[unsafe(method(blendKernel))]
        #[unsafe(method_family = none)]
        pub unsafe fn blendKernel(&self) -> Option<Retained<CIBlendKernel>>;

        #[cfg(feature = "CIKernel")]
        /// Setter for [`blendKernel`][Self::blendKernel].
        #[unsafe(method(setBlendKernel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBlendKernel(&self, blend_kernel: Option<&CIBlendKernel>);

        #[unsafe(method(blendsInDestinationColorSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn blendsInDestinationColorSpace(&self) -> bool;

        /// Setter for [`blendsInDestinationColorSpace`][Self::blendsInDestinationColorSpace].
        #[unsafe(method(setBlendsInDestinationColorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBlendsInDestinationColorSpace(
            &self,
            blends_in_destination_color_space: bool,
        );

        /// Tell the next render using this destination to capture a Metal trace.
        ///
        /// If this property is set to a file-based URL, then the next render using this
        /// destination will capture a Metal trace, deleting any existing file if present.
        /// This property is nil by default.
        #[unsafe(method(captureTraceURL))]
        #[unsafe(method_family = none)]
        pub unsafe fn captureTraceURL(&self) -> Option<Retained<NSURL>>;

        /// Setter for [`captureTraceURL`][Self::captureTraceURL].
        #[unsafe(method(setCaptureTraceURL:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCaptureTraceURL(&self, capture_trace_url: Option<&NSURL>);
    );
}

/// Methods declared on superclass `NSObject`.
impl CIRenderDestination {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/cirenderinfo?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIRenderInfo;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIRenderInfo {}
);

impl CIRenderInfo {
    extern_methods!(
        #[unsafe(method(kernelExecutionTime))]
        #[unsafe(method_family = none)]
        pub unsafe fn kernelExecutionTime(&self) -> NSTimeInterval;

        #[unsafe(method(kernelCompileTime))]
        #[unsafe(method_family = none)]
        pub unsafe fn kernelCompileTime(&self) -> NSTimeInterval;

        #[unsafe(method(passCount))]
        #[unsafe(method_family = none)]
        pub unsafe fn passCount(&self) -> NSInteger;

        #[unsafe(method(pixelsProcessed))]
        #[unsafe(method_family = none)]
        pub unsafe fn pixelsProcessed(&self) -> NSInteger;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIRenderInfo {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/coreimage/cirendertask?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIRenderTask;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CIRenderTask {}
);

impl CIRenderTask {
    extern_methods!(
        #[unsafe(method(waitUntilCompletedAndReturnError:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn waitUntilCompletedAndReturnError(
            &self,
        ) -> Result<Retained<CIRenderInfo>, Retained<NSError>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIRenderTask {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// CIRenderDestination.
#[cfg(feature = "CIContext")]
impl CIContext {
    extern_methods!(
        #[cfg(all(feature = "CIImage", feature = "objc2-core-foundation"))]
        #[unsafe(method(startTaskToRender:fromRect:toDestination:atPoint:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn startTaskToRender_fromRect_toDestination_atPoint_error(
            &self,
            image: &CIImage,
            from_rect: CGRect,
            destination: &CIRenderDestination,
            at_point: CGPoint,
        ) -> Result<Retained<CIRenderTask>, Retained<NSError>>;

        #[cfg(feature = "CIImage")]
        #[unsafe(method(startTaskToRender:toDestination:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn startTaskToRender_toDestination_error(
            &self,
            image: &CIImage,
            destination: &CIRenderDestination,
        ) -> Result<Retained<CIRenderTask>, Retained<NSError>>;

        #[cfg(all(feature = "CIImage", feature = "objc2-core-foundation"))]
        #[unsafe(method(prepareRender:fromRect:toDestination:atPoint:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareRender_fromRect_toDestination_atPoint_error(
            &self,
            image: &CIImage,
            from_rect: CGRect,
            destination: &CIRenderDestination,
            at_point: CGPoint,
        ) -> Result<(), Retained<NSError>>;

        #[unsafe(method(startTaskToClear:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn startTaskToClear_error(
            &self,
            destination: &CIRenderDestination,
        ) -> Result<Retained<CIRenderTask>, Retained<NSError>>;
    );
}
