import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";

// https://vite.dev/config/
export default defineConfig({
    plugins: [
        react({
            babel: {
                plugins: [["babel-plugin-react-compiler", {}]],
            },
        }),
    ],
    base: "",
    build: {
        outDir: "../mitmproxy/tools/web",
        assetsDir: "static",
        rollupOptions: {
            output: {
                manualChunks: (id) => {
                    if (
                        id.includes("node_modules") ||
                        id.includes("vendor.less")
                    ) {
                        return "vendor";
                    }
                    return null;
                },
            },
        },
    },
    server: {
        host: "127.0.0.1",
        proxy: {
            "^/(?!@|src|node_modules|updates).+": {
                target: "http://127.0.0.1:8081",
            },
            "/updates": {
                target: "ws://127.0.0.1:8081",
                ws: true,
            },
        },
    },
});
