/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import org.eclipse.core.runtime.Assert;

public class Match {
    public static final int UNIT_LINE = 1;
    public static final int UNIT_CHARACTER = 2;
    private static final int IS_FILTERED = 4;
    private final Object fElement;
    private int fOffset;
    private int fLength;
    private int fFlags;

    public Match(Object element, int unit, int offset, int length) {
        Assert.isTrue((unit == 2 || unit == 1 ? 1 : 0) != 0);
        this.fElement = element;
        this.fOffset = offset;
        this.fLength = length;
        this.fFlags = unit;
    }

    public Match(Object element, int offset, int length) {
        this(element, 2, offset, length);
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public Object getElement() {
        return this.fElement;
    }

    public int getBaseUnit() {
        if ((this.fFlags & 1) != 0) {
            return 1;
        }
        return 2;
    }

    public void setFiltered(boolean value) {
        this.fFlags = value ? (this.fFlags |= 4) : (this.fFlags &= 0xFFFFFFFB);
    }

    public boolean isFiltered() {
        return (this.fFlags & 4) != 0;
    }

    public String toString() {
        return "offset=" + this.getOffset() + " length=" + this.getLength() + " isFiltered=" + this.isFiltered() + " element=" + String.valueOf(this.getElement());
    }
}

