package videorecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnderstandVideoContent invokes the videorecog.UnderstandVideoContent API synchronously
func (client *Client) UnderstandVideoContent(request *UnderstandVideoContentRequest) (response *UnderstandVideoContentResponse, err error) {
	response = CreateUnderstandVideoContentResponse()
	err = client.DoAction(request, response)
	return
}

// UnderstandVideoContentWithChan invokes the videorecog.UnderstandVideoContent API asynchronously
func (client *Client) UnderstandVideoContentWithChan(request *UnderstandVideoContentRequest) (<-chan *UnderstandVideoContentResponse, <-chan error) {
	responseChan := make(chan *UnderstandVideoContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnderstandVideoContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnderstandVideoContentWithCallback invokes the videorecog.UnderstandVideoContent API asynchronously
func (client *Client) UnderstandVideoContentWithCallback(request *UnderstandVideoContentRequest, callback func(response *UnderstandVideoContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnderstandVideoContentResponse
		var err error
		defer close(result)
		response, err = client.UnderstandVideoContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnderstandVideoContentRequest is the request struct for api UnderstandVideoContent
type UnderstandVideoContentRequest struct {
	*requests.RpcRequest
	Async    requests.Boolean `position:"Body" name:"Async"`
	VideoURL string           `position:"Body" name:"VideoURL"`
}

// UnderstandVideoContentResponse is the response struct for api UnderstandVideoContent
type UnderstandVideoContentResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateUnderstandVideoContentRequest creates a request to invoke UnderstandVideoContent API
func CreateUnderstandVideoContentRequest() (request *UnderstandVideoContentRequest) {
	request = &UnderstandVideoContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videorecog", "2020-03-20", "UnderstandVideoContent", "videorecog", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnderstandVideoContentResponse creates a response to parse from UnderstandVideoContent response
func CreateUnderstandVideoContentResponse() (response *UnderstandVideoContentResponse) {
	response = &UnderstandVideoContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
