package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantInstanceToCbn invokes the smartag.GrantInstanceToCbn API synchronously
func (client *Client) GrantInstanceToCbn(request *GrantInstanceToCbnRequest) (response *GrantInstanceToCbnResponse, err error) {
	response = CreateGrantInstanceToCbnResponse()
	err = client.DoAction(request, response)
	return
}

// GrantInstanceToCbnWithChan invokes the smartag.GrantInstanceToCbn API asynchronously
func (client *Client) GrantInstanceToCbnWithChan(request *GrantInstanceToCbnRequest) (<-chan *GrantInstanceToCbnResponse, <-chan error) {
	responseChan := make(chan *GrantInstanceToCbnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantInstanceToCbn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantInstanceToCbnWithCallback invokes the smartag.GrantInstanceToCbn API asynchronously
func (client *Client) GrantInstanceToCbnWithCallback(request *GrantInstanceToCbnRequest, callback func(response *GrantInstanceToCbnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantInstanceToCbnResponse
		var err error
		defer close(result)
		response, err = client.GrantInstanceToCbn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantInstanceToCbnRequest is the request struct for api GrantInstanceToCbn
type GrantInstanceToCbnRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CcnInstanceId        string           `position:"Query" name:"CcnInstanceId"`
	GrantTrafficService  requests.Boolean `position:"Query" name:"GrantTrafficService"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CenUid               requests.Integer `position:"Query" name:"CenUid"`
	CenInstanceId        string           `position:"Query" name:"CenInstanceId"`
}

// GrantInstanceToCbnResponse is the response struct for api GrantInstanceToCbn
type GrantInstanceToCbnResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGrantInstanceToCbnRequest creates a request to invoke GrantInstanceToCbn API
func CreateGrantInstanceToCbnRequest() (request *GrantInstanceToCbnRequest) {
	request = &GrantInstanceToCbnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "GrantInstanceToCbn", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGrantInstanceToCbnResponse creates a response to parse from GrantInstanceToCbn response
func CreateGrantInstanceToCbnResponse() (response *GrantInstanceToCbnResponse) {
	response = &GrantInstanceToCbnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
