package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserBusinessStatus invokes the sgw.DescribeUserBusinessStatus API synchronously
func (client *Client) DescribeUserBusinessStatus(request *DescribeUserBusinessStatusRequest) (response *DescribeUserBusinessStatusResponse, err error) {
	response = CreateDescribeUserBusinessStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserBusinessStatusWithChan invokes the sgw.DescribeUserBusinessStatus API asynchronously
func (client *Client) DescribeUserBusinessStatusWithChan(request *DescribeUserBusinessStatusRequest) (<-chan *DescribeUserBusinessStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeUserBusinessStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserBusinessStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserBusinessStatusWithCallback invokes the sgw.DescribeUserBusinessStatus API asynchronously
func (client *Client) DescribeUserBusinessStatusWithCallback(request *DescribeUserBusinessStatusRequest, callback func(response *DescribeUserBusinessStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserBusinessStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserBusinessStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserBusinessStatusRequest is the request struct for api DescribeUserBusinessStatus
type DescribeUserBusinessStatusRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeUserBusinessStatusResponse is the response struct for api DescribeUserBusinessStatus
type DescribeUserBusinessStatusResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Success           bool   `json:"Success" xml:"Success"`
	Code              string `json:"Code" xml:"Code"`
	Message           string `json:"Message" xml:"Message"`
	IsEnabled         bool   `json:"IsEnabled" xml:"IsEnabled"`
	IsIndebted        bool   `json:"IsIndebted" xml:"IsIndebted"`
	IsIndebtedOverdue bool   `json:"IsIndebtedOverdue" xml:"IsIndebtedOverdue"`
	IsRiskControl     bool   `json:"IsRiskControl" xml:"IsRiskControl"`
}

// CreateDescribeUserBusinessStatusRequest creates a request to invoke DescribeUserBusinessStatus API
func CreateDescribeUserBusinessStatusRequest() (request *DescribeUserBusinessStatusRequest) {
	request = &DescribeUserBusinessStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeUserBusinessStatus", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserBusinessStatusResponse creates a response to parse from DescribeUserBusinessStatus response
func CreateDescribeUserBusinessStatusResponse() (response *DescribeUserBusinessStatusResponse) {
	response = &DescribeUserBusinessStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
