package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPortalMenuAuthorization invokes the quickbi_public.ListPortalMenuAuthorization API synchronously
func (client *Client) ListPortalMenuAuthorization(request *ListPortalMenuAuthorizationRequest) (response *ListPortalMenuAuthorizationResponse, err error) {
	response = CreateListPortalMenuAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// ListPortalMenuAuthorizationWithChan invokes the quickbi_public.ListPortalMenuAuthorization API asynchronously
func (client *Client) ListPortalMenuAuthorizationWithChan(request *ListPortalMenuAuthorizationRequest) (<-chan *ListPortalMenuAuthorizationResponse, <-chan error) {
	responseChan := make(chan *ListPortalMenuAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPortalMenuAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPortalMenuAuthorizationWithCallback invokes the quickbi_public.ListPortalMenuAuthorization API asynchronously
func (client *Client) ListPortalMenuAuthorizationWithCallback(request *ListPortalMenuAuthorizationRequest, callback func(response *ListPortalMenuAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPortalMenuAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.ListPortalMenuAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPortalMenuAuthorizationRequest is the request struct for api ListPortalMenuAuthorization
type ListPortalMenuAuthorizationRequest struct {
	*requests.RpcRequest
	DataPortalId string `position:"Query" name:"DataPortalId"`
	AccessPoint  string `position:"Query" name:"AccessPoint"`
	SignType     string `position:"Query" name:"SignType"`
}

// ListPortalMenuAuthorizationResponse is the response struct for api ListPortalMenuAuthorization
type ListPortalMenuAuthorizationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []Data `json:"Result" xml:"Result"`
}

// CreateListPortalMenuAuthorizationRequest creates a request to invoke ListPortalMenuAuthorization API
func CreateListPortalMenuAuthorizationRequest() (request *ListPortalMenuAuthorizationRequest) {
	request = &ListPortalMenuAuthorizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-08", "ListPortalMenuAuthorization", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPortalMenuAuthorizationResponse creates a response to parse from ListPortalMenuAuthorization response
func CreateListPortalMenuAuthorizationResponse() (response *ListPortalMenuAuthorizationResponse) {
	response = &ListPortalMenuAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
