package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListABTestFixedFlowDividers invokes the opensearch.ListABTestFixedFlowDividers API synchronously
func (client *Client) ListABTestFixedFlowDividers(request *ListABTestFixedFlowDividersRequest) (response *ListABTestFixedFlowDividersResponse, err error) {
	response = CreateListABTestFixedFlowDividersResponse()
	err = client.DoAction(request, response)
	return
}

// ListABTestFixedFlowDividersWithChan invokes the opensearch.ListABTestFixedFlowDividers API asynchronously
func (client *Client) ListABTestFixedFlowDividersWithChan(request *ListABTestFixedFlowDividersRequest) (<-chan *ListABTestFixedFlowDividersResponse, <-chan error) {
	responseChan := make(chan *ListABTestFixedFlowDividersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListABTestFixedFlowDividers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListABTestFixedFlowDividersWithCallback invokes the opensearch.ListABTestFixedFlowDividers API asynchronously
func (client *Client) ListABTestFixedFlowDividersWithCallback(request *ListABTestFixedFlowDividersRequest, callback func(response *ListABTestFixedFlowDividersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListABTestFixedFlowDividersResponse
		var err error
		defer close(result)
		response, err = client.ListABTestFixedFlowDividers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListABTestFixedFlowDividersRequest is the request struct for api ListABTestFixedFlowDividers
type ListABTestFixedFlowDividersRequest struct {
	*requests.RoaRequest
	GroupId          requests.Integer `position:"Path" name:"groupId"`
	SceneId          requests.Integer `position:"Path" name:"sceneId"`
	ExperimentId     requests.Integer `position:"Path" name:"experimentId"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListABTestFixedFlowDividersResponse is the response struct for api ListABTestFixedFlowDividers
type ListABTestFixedFlowDividersResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"requestId" xml:"requestId"`
	Result    []string `json:"result" xml:"result"`
}

// CreateListABTestFixedFlowDividersRequest creates a request to invoke ListABTestFixedFlowDividers API
func CreateListABTestFixedFlowDividersRequest() (request *ListABTestFixedFlowDividersRequest) {
	request = &ListABTestFixedFlowDividersRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListABTestFixedFlowDividers", "/v4/openapi/app-groups/[appGroupIdentity]/scenes/[sceneId]/groups/[groupId]/experiments/[experimentId]/fixed-flow-dividers", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListABTestFixedFlowDividersResponse creates a response to parse from ListABTestFixedFlowDividers response
func CreateListABTestFixedFlowDividersResponse() (response *ListABTestFixedFlowDividersResponse) {
	response = &ListABTestFixedFlowDividersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
