package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainRealtimeLogDelivery invokes the live.DescribeLiveDomainRealtimeLogDelivery API synchronously
func (client *Client) DescribeLiveDomainRealtimeLogDelivery(request *DescribeLiveDomainRealtimeLogDeliveryRequest) (response *DescribeLiveDomainRealtimeLogDeliveryResponse, err error) {
	response = CreateDescribeLiveDomainRealtimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainRealtimeLogDeliveryWithChan invokes the live.DescribeLiveDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeLiveDomainRealtimeLogDeliveryWithChan(request *DescribeLiveDomainRealtimeLogDeliveryRequest) (<-chan *DescribeLiveDomainRealtimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainRealtimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainRealtimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainRealtimeLogDeliveryWithCallback invokes the live.DescribeLiveDomainRealtimeLogDelivery API asynchronously
func (client *Client) DescribeLiveDomainRealtimeLogDeliveryWithCallback(request *DescribeLiveDomainRealtimeLogDeliveryRequest, callback func(response *DescribeLiveDomainRealtimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainRealtimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainRealtimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainRealtimeLogDeliveryRequest is the request struct for api DescribeLiveDomainRealtimeLogDelivery
type DescribeLiveDomainRealtimeLogDeliveryRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainRealtimeLogDeliveryResponse is the response struct for api DescribeLiveDomainRealtimeLogDelivery
type DescribeLiveDomainRealtimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Project   string `json:"Project" xml:"Project"`
	Region    string `json:"Region" xml:"Region"`
	Logstore  string `json:"Logstore" xml:"Logstore"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateDescribeLiveDomainRealtimeLogDeliveryRequest creates a request to invoke DescribeLiveDomainRealtimeLogDelivery API
func CreateDescribeLiveDomainRealtimeLogDeliveryRequest() (request *DescribeLiveDomainRealtimeLogDeliveryRequest) {
	request = &DescribeLiveDomainRealtimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainRealtimeLogDelivery", "live", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeLiveDomainRealtimeLogDeliveryResponse creates a response to parse from DescribeLiveDomainRealtimeLogDelivery response
func CreateDescribeLiveDomainRealtimeLogDeliveryResponse() (response *DescribeLiveDomainRealtimeLogDeliveryResponse) {
	response = &DescribeLiveDomainRealtimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
