package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMultiRateConfig invokes the live.AddMultiRateConfig API synchronously
func (client *Client) AddMultiRateConfig(request *AddMultiRateConfigRequest) (response *AddMultiRateConfigResponse, err error) {
	response = CreateAddMultiRateConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddMultiRateConfigWithChan invokes the live.AddMultiRateConfig API asynchronously
func (client *Client) AddMultiRateConfigWithChan(request *AddMultiRateConfigRequest) (<-chan *AddMultiRateConfigResponse, <-chan error) {
	responseChan := make(chan *AddMultiRateConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMultiRateConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMultiRateConfigWithCallback invokes the live.AddMultiRateConfig API asynchronously
func (client *Client) AddMultiRateConfigWithCallback(request *AddMultiRateConfigRequest, callback func(response *AddMultiRateConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMultiRateConfigResponse
		var err error
		defer close(result)
		response, err = client.AddMultiRateConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMultiRateConfigRequest is the request struct for api AddMultiRateConfig
type AddMultiRateConfigRequest struct {
	*requests.RpcRequest
	App         string           `position:"Query" name:"App"`
	GroupId     string           `position:"Query" name:"GroupId"`
	Templates   string           `position:"Query" name:"Templates"`
	DomainName  string           `position:"Query" name:"DomainName"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	IsLazy      string           `position:"Query" name:"IsLazy"`
	AvFormat    string           `position:"Query" name:"AvFormat"`
	IsTimeAlign string           `position:"Query" name:"IsTimeAlign"`
}

// AddMultiRateConfigResponse is the response struct for api AddMultiRateConfig
type AddMultiRateConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
	Body      Body   `json:"Body" xml:"Body"`
}

// CreateAddMultiRateConfigRequest creates a request to invoke AddMultiRateConfig API
func CreateAddMultiRateConfigRequest() (request *AddMultiRateConfigRequest) {
	request = &AddMultiRateConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddMultiRateConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddMultiRateConfigResponse creates a response to parse from AddMultiRateConfig response
func CreateAddMultiRateConfigResponse() (response *AddMultiRateConfigResponse) {
	response = &AddMultiRateConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
