package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySoundCodeList invokes the iot.QuerySoundCodeList API synchronously
func (client *Client) QuerySoundCodeList(request *QuerySoundCodeListRequest) (response *QuerySoundCodeListResponse, err error) {
	response = CreateQuerySoundCodeListResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySoundCodeListWithChan invokes the iot.QuerySoundCodeList API asynchronously
func (client *Client) QuerySoundCodeListWithChan(request *QuerySoundCodeListRequest) (<-chan *QuerySoundCodeListResponse, <-chan error) {
	responseChan := make(chan *QuerySoundCodeListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySoundCodeList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySoundCodeListWithCallback invokes the iot.QuerySoundCodeList API asynchronously
func (client *Client) QuerySoundCodeListWithCallback(request *QuerySoundCodeListRequest, callback func(response *QuerySoundCodeListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySoundCodeListResponse
		var err error
		defer close(result)
		response, err = client.QuerySoundCodeList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySoundCodeListRequest is the request struct for api QuerySoundCodeList
type QuerySoundCodeListRequest struct {
	*requests.RpcRequest
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySoundCodeListResponse is the response struct for api QuerySoundCodeList
type QuerySoundCodeListResponse struct {
	*responses.BaseResponse
	RequestId    string                   `json:"RequestId" xml:"RequestId"`
	Success      bool                     `json:"Success" xml:"Success"`
	Code         string                   `json:"Code" xml:"Code"`
	ErrorMessage string                   `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySoundCodeList `json:"Data" xml:"Data"`
}

// CreateQuerySoundCodeListRequest creates a request to invoke QuerySoundCodeList API
func CreateQuerySoundCodeListRequest() (request *QuerySoundCodeListRequest) {
	request = &QuerySoundCodeListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySoundCodeList", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySoundCodeListResponse creates a response to parse from QuerySoundCodeList response
func CreateQuerySoundCodeListResponse() (response *QuerySoundCodeListResponse) {
	response = &QuerySoundCodeListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
