package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHotlineTransferNumber invokes the dyvmsapi.ListHotlineTransferNumber API synchronously
func (client *Client) ListHotlineTransferNumber(request *ListHotlineTransferNumberRequest) (response *ListHotlineTransferNumberResponse, err error) {
	response = CreateListHotlineTransferNumberResponse()
	err = client.DoAction(request, response)
	return
}

// ListHotlineTransferNumberWithChan invokes the dyvmsapi.ListHotlineTransferNumber API asynchronously
func (client *Client) ListHotlineTransferNumberWithChan(request *ListHotlineTransferNumberRequest) (<-chan *ListHotlineTransferNumberResponse, <-chan error) {
	responseChan := make(chan *ListHotlineTransferNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHotlineTransferNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHotlineTransferNumberWithCallback invokes the dyvmsapi.ListHotlineTransferNumber API asynchronously
func (client *Client) ListHotlineTransferNumberWithCallback(request *ListHotlineTransferNumberRequest, callback func(response *ListHotlineTransferNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHotlineTransferNumberResponse
		var err error
		defer close(result)
		response, err = client.ListHotlineTransferNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHotlineTransferNumberRequest is the request struct for api ListHotlineTransferNumber
type ListHotlineTransferNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HotlineNumber        string           `position:"Query" name:"HotlineNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	QualificationId      string           `position:"Query" name:"QualificationId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
}

// ListHotlineTransferNumberResponse is the response struct for api ListHotlineTransferNumber
type ListHotlineTransferNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListHotlineTransferNumberRequest creates a request to invoke ListHotlineTransferNumber API
func CreateListHotlineTransferNumberRequest() (request *ListHotlineTransferNumberRequest) {
	request = &ListHotlineTransferNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ListHotlineTransferNumber", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHotlineTransferNumberResponse creates a response to parse from ListHotlineTransferNumber response
func CreateListHotlineTransferNumberResponse() (response *ListHotlineTransferNumberResponse) {
	response = &ListHotlineTransferNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
