package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMigrationJobStatus invokes the dts.DescribeMigrationJobStatus API synchronously
func (client *Client) DescribeMigrationJobStatus(request *DescribeMigrationJobStatusRequest) (response *DescribeMigrationJobStatusResponse, err error) {
	response = CreateDescribeMigrationJobStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMigrationJobStatusWithChan invokes the dts.DescribeMigrationJobStatus API asynchronously
func (client *Client) DescribeMigrationJobStatusWithChan(request *DescribeMigrationJobStatusRequest) (<-chan *DescribeMigrationJobStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeMigrationJobStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMigrationJobStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMigrationJobStatusWithCallback invokes the dts.DescribeMigrationJobStatus API asynchronously
func (client *Client) DescribeMigrationJobStatusWithCallback(request *DescribeMigrationJobStatusRequest, callback func(response *DescribeMigrationJobStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMigrationJobStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeMigrationJobStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMigrationJobStatusRequest is the request struct for api DescribeMigrationJobStatus
type DescribeMigrationJobStatusRequest struct {
	*requests.RpcRequest
	ClientToken    string `position:"Query" name:"ClientToken"`
	MigrationJobId string `position:"Query" name:"MigrationJobId"`
	OwnerId        string `position:"Query" name:"OwnerId"`
	AccountId      string `position:"Query" name:"AccountId"`
}

// DescribeMigrationJobStatusResponse is the response struct for api DescribeMigrationJobStatus
type DescribeMigrationJobStatusResponse struct {
	*responses.BaseResponse
	RequestId                     string                                     `json:"RequestId" xml:"RequestId"`
	MigrationJobName              string                                     `json:"MigrationJobName" xml:"MigrationJobName"`
	MigrationJobStatus            string                                     `json:"MigrationJobStatus" xml:"MigrationJobStatus"`
	ErrCode                       string                                     `json:"ErrCode" xml:"ErrCode"`
	Success                       string                                     `json:"Success" xml:"Success"`
	PayType                       string                                     `json:"PayType" xml:"PayType"`
	ErrMessage                    string                                     `json:"ErrMessage" xml:"ErrMessage"`
	MigrationObject               string                                     `json:"MigrationObject" xml:"MigrationObject"`
	MigrationJobId                string                                     `json:"MigrationJobId" xml:"MigrationJobId"`
	TaskId                        string                                     `json:"TaskId" xml:"TaskId"`
	MigrationJobClass             string                                     `json:"MigrationJobClass" xml:"MigrationJobClass"`
	DataInitializationStatus      DataInitializationStatus                   `json:"DataInitializationStatus" xml:"DataInitializationStatus"`
	DataSynchronizationStatus     DataSynchronizationStatus                  `json:"DataSynchronizationStatus" xml:"DataSynchronizationStatus"`
	DestinationEndpoint           DestinationEndpoint                        `json:"DestinationEndpoint" xml:"DestinationEndpoint"`
	MigrationMode                 MigrationMode                              `json:"MigrationMode" xml:"MigrationMode"`
	PrecheckStatus                PrecheckStatusInDescribeMigrationJobStatus `json:"PrecheckStatus" xml:"PrecheckStatus"`
	SourceEndpoint                SourceEndpoint                             `json:"SourceEndpoint" xml:"SourceEndpoint"`
	StructureInitializationStatus StructureInitializationStatus              `json:"StructureInitializationStatus" xml:"StructureInitializationStatus"`
}

// CreateDescribeMigrationJobStatusRequest creates a request to invoke DescribeMigrationJobStatus API
func CreateDescribeMigrationJobStatusRequest() (request *DescribeMigrationJobStatusRequest) {
	request = &DescribeMigrationJobStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "DescribeMigrationJobStatus", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMigrationJobStatusResponse creates a response to parse from DescribeMigrationJobStatus response
func CreateDescribeMigrationJobStatusResponse() (response *DescribeMigrationJobStatusResponse) {
	response = &DescribeMigrationJobStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
