package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNodeSpecBatch invokes the dds.ModifyNodeSpecBatch API synchronously
func (client *Client) ModifyNodeSpecBatch(request *ModifyNodeSpecBatchRequest) (response *ModifyNodeSpecBatchResponse, err error) {
	response = CreateModifyNodeSpecBatchResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNodeSpecBatchWithChan invokes the dds.ModifyNodeSpecBatch API asynchronously
func (client *Client) ModifyNodeSpecBatchWithChan(request *ModifyNodeSpecBatchRequest) (<-chan *ModifyNodeSpecBatchResponse, <-chan error) {
	responseChan := make(chan *ModifyNodeSpecBatchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNodeSpecBatch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNodeSpecBatchWithCallback invokes the dds.ModifyNodeSpecBatch API asynchronously
func (client *Client) ModifyNodeSpecBatchWithCallback(request *ModifyNodeSpecBatchRequest, callback func(response *ModifyNodeSpecBatchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNodeSpecBatchResponse
		var err error
		defer close(result)
		response, err = client.ModifyNodeSpecBatch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNodeSpecBatchRequest is the request struct for api ModifyNodeSpecBatch
type ModifyNodeSpecBatchRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NodesInfo            string           `position:"Query" name:"NodesInfo"`
	CouponNo             string           `position:"Query" name:"CouponNo"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	EffectiveTime        string           `position:"Query" name:"EffectiveTime"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	BusinessInfo         string           `position:"Query" name:"BusinessInfo"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	FromApp              string           `position:"Query" name:"FromApp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OrderType            string           `position:"Query" name:"OrderType"`
}

// ModifyNodeSpecBatchResponse is the response struct for api ModifyNodeSpecBatch
type ModifyNodeSpecBatchResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNodeSpecBatchRequest creates a request to invoke ModifyNodeSpecBatch API
func CreateModifyNodeSpecBatchRequest() (request *ModifyNodeSpecBatchRequest) {
	request = &ModifyNodeSpecBatchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "ModifyNodeSpecBatch", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNodeSpecBatchResponse creates a response to parse from ModifyNodeSpecBatch response
func CreateModifyNodeSpecBatchResponse() (response *ModifyNodeSpecBatchResponse) {
	response = &ModifyNodeSpecBatchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
