package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDcdnSLSRealTimeLogDelivery invokes the dcdn.CreateDcdnSLSRealTimeLogDelivery API synchronously
func (client *Client) CreateDcdnSLSRealTimeLogDelivery(request *CreateDcdnSLSRealTimeLogDeliveryRequest) (response *CreateDcdnSLSRealTimeLogDeliveryResponse, err error) {
	response = CreateCreateDcdnSLSRealTimeLogDeliveryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDcdnSLSRealTimeLogDeliveryWithChan invokes the dcdn.CreateDcdnSLSRealTimeLogDelivery API asynchronously
func (client *Client) CreateDcdnSLSRealTimeLogDeliveryWithChan(request *CreateDcdnSLSRealTimeLogDeliveryRequest) (<-chan *CreateDcdnSLSRealTimeLogDeliveryResponse, <-chan error) {
	responseChan := make(chan *CreateDcdnSLSRealTimeLogDeliveryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDcdnSLSRealTimeLogDelivery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDcdnSLSRealTimeLogDeliveryWithCallback invokes the dcdn.CreateDcdnSLSRealTimeLogDelivery API asynchronously
func (client *Client) CreateDcdnSLSRealTimeLogDeliveryWithCallback(request *CreateDcdnSLSRealTimeLogDeliveryRequest, callback func(response *CreateDcdnSLSRealTimeLogDeliveryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDcdnSLSRealTimeLogDeliveryResponse
		var err error
		defer close(result)
		response, err = client.CreateDcdnSLSRealTimeLogDelivery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDcdnSLSRealTimeLogDeliveryRequest is the request struct for api CreateDcdnSLSRealTimeLogDelivery
type CreateDcdnSLSRealTimeLogDeliveryRequest struct {
	*requests.RpcRequest
	SLSLogStore  string           `position:"Body" name:"SLSLogStore"`
	SLSProject   string           `position:"Body" name:"SLSProject"`
	BusinessType string           `position:"Body" name:"BusinessType"`
	SLSRegion    string           `position:"Body" name:"SLSRegion"`
	ProjectName  string           `position:"Body" name:"ProjectName"`
	DomainName   string           `position:"Body" name:"DomainName"`
	SamplingRate string           `position:"Body" name:"SamplingRate"`
	DataCenter   string           `position:"Body" name:"DataCenter"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateDcdnSLSRealTimeLogDeliveryResponse is the response struct for api CreateDcdnSLSRealTimeLogDelivery
type CreateDcdnSLSRealTimeLogDeliveryResponse struct {
	*responses.BaseResponse
	RequestId string                                    `json:"RequestId" xml:"RequestId"`
	Content   ContentInCreateDcdnSLSRealTimeLogDelivery `json:"Content" xml:"Content"`
}

// CreateCreateDcdnSLSRealTimeLogDeliveryRequest creates a request to invoke CreateDcdnSLSRealTimeLogDelivery API
func CreateCreateDcdnSLSRealTimeLogDeliveryRequest() (request *CreateDcdnSLSRealTimeLogDeliveryRequest) {
	request = &CreateDcdnSLSRealTimeLogDeliveryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "CreateDcdnSLSRealTimeLogDelivery", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDcdnSLSRealTimeLogDeliveryResponse creates a response to parse from CreateDcdnSLSRealTimeLogDelivery response
func CreateCreateDcdnSLSRealTimeLogDeliveryResponse() (response *CreateDcdnSLSRealTimeLogDeliveryResponse) {
	response = &CreateDcdnSLSRealTimeLogDeliveryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
