package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemovePhoneNumberEx invokes the cloudcallcenter.RemovePhoneNumberEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removephonenumberex.html
func (client *Client) RemovePhoneNumberEx(request *RemovePhoneNumberExRequest) (response *RemovePhoneNumberExResponse, err error) {
	response = CreateRemovePhoneNumberExResponse()
	err = client.DoAction(request, response)
	return
}

// RemovePhoneNumberExWithChan invokes the cloudcallcenter.RemovePhoneNumberEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removephonenumberex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemovePhoneNumberExWithChan(request *RemovePhoneNumberExRequest) (<-chan *RemovePhoneNumberExResponse, <-chan error) {
	responseChan := make(chan *RemovePhoneNumberExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemovePhoneNumberEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemovePhoneNumberExWithCallback invokes the cloudcallcenter.RemovePhoneNumberEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/removephonenumberex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemovePhoneNumberExWithCallback(request *RemovePhoneNumberExRequest, callback func(response *RemovePhoneNumberExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemovePhoneNumberExResponse
		var err error
		defer close(result)
		response, err = client.RemovePhoneNumberEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemovePhoneNumberExRequest is the request struct for api RemovePhoneNumberEx
type RemovePhoneNumberExRequest struct {
	*requests.RpcRequest
	PhoneNumberIds *[]string `position:"Query" name:"PhoneNumberIds"  type:"Repeated"`
	InstanceId     string    `position:"Query" name:"InstanceId"`
}

// RemovePhoneNumberExResponse is the response struct for api RemovePhoneNumberEx
type RemovePhoneNumberExResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemovePhoneNumberExRequest creates a request to invoke RemovePhoneNumberEx API
func CreateRemovePhoneNumberExRequest() (request *RemovePhoneNumberExRequest) {
	request = &RemovePhoneNumberExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "RemovePhoneNumberEx", "", "")
	request.Method = requests.POST
	return
}

// CreateRemovePhoneNumberExResponse creates a response to parse from RemovePhoneNumberEx response
func CreateRemovePhoneNumberExResponse() (response *RemovePhoneNumberExResponse) {
	response = &RemovePhoneNumberExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
